/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.distribution.ParametricDistributionModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.UnivariateFunction;
import dr.math.distributions.Distribution;
import dr.math.distributions.RandomGenerator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TwoPieceLocationScaleDistributionModel
extends AbstractModel
implements ParametricDistributionModel,
RandomGenerator {
    private final Parameter locationParameter;
    private final Parameter sigmaParameter;
    private final Parameter gammaParameter;
    private final Distribution distribution;
    private final Parameterization parameterization;

    public TwoPieceLocationScaleDistributionModel(Parameter parameter, Distribution distribution, Parameter parameter2, Parameter parameter3, Parameterization parameterization) {
        super("twoPieceLocationScaleDistributionModel");
        this.locationParameter = parameter;
        this.sigmaParameter = parameter2;
        this.gammaParameter = parameter3;
        this.distribution = distribution;
        this.addVariable(parameter);
        this.addVariable(parameter2);
        this.addVariable(parameter3);
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1));
        parameter2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        parameter3.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.parameterization = parameterization;
    }

    private double getLowerScale() {
        return this.parameterization.getLowerScale(this.sigmaParameter.getParameterValue(0), this.gammaParameter.getParameterValue(0));
    }

    private double getUpperScale() {
        return this.parameterization.getUpperScale(this.sigmaParameter.getParameterValue(0), this.gammaParameter.getParameterValue(0));
    }

    private double getLocation() {
        return this.locationParameter.getParameterValue(0);
    }

    @Override
    public double pdf(double d) {
        return Math.exp(this.logPdf(d));
    }

    @Override
    public double logPdf(double d) {
        double d2 = this.getLocation();
        double d3 = this.getLowerScale();
        double d4 = this.getUpperScale();
        double d5 = d - d2;
        d5 = d < d2 ? (d5 /= d3) : (d5 /= d4);
        return Math.log(2.0) - Math.log(d3 + d4) + this.distribution.logPdf(d5);
    }

    @Override
    public double cdf(double d) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public double quantile(double d) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public double mean() {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public double variance() {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public final UnivariateFunction getProbabilityDensityFunction() {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public Object nextRandom() {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public double logPdf(Object object) {
        double d = (Double)object;
        return this.logPdf(d);
    }

    @Override
    public double logPdf(double[] dArray) {
        return this.logPdf(dArray[0]);
    }

    @Override
    public Variable<Double> getLocationVariable() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Element createElement(Document document) {
        throw new RuntimeException("Not yet implemented!");
    }

    public static enum Parameterization implements Scale
    {
        TWO_SCALE("twoScale", new Scale(){

            @Override
            public double getLowerScale(double d, double d2) {
                return d;
            }

            @Override
            public double getUpperScale(double d, double d2) {
                return d2;
            }
        }),
        ISF("inverseScaleFactors", new Scale(){

            @Override
            public double getLowerScale(double d, double d2) {
                return d / d2;
            }

            @Override
            public double getUpperScale(double d, double d2) {
                return d * d2;
            }
        }),
        EPSILON_SKEW("epsilonSkew", new Scale(){

            @Override
            public double getLowerScale(double d, double d2) {
                return d * (1.0 - d2);
            }

            @Override
            public double getUpperScale(double d, double d2) {
                return d * (1.0 + d2);
            }
        }),
        LOGISTIC_AG("logisticAG", new Scale(){

            @Override
            public double getLowerScale(double d, double d2) {
                return d * (1.0 + Math.exp(-2.0 * d2));
            }

            @Override
            public double getUpperScale(double d, double d2) {
                return d * (1.0 + Math.exp(2.0 * d2));
            }
        });

        private final String text;
        private final Scale scale;

        private Parameterization(String string2, Scale scale) {
            this.text = string2;
            this.scale = scale;
        }

        public static Parameterization parseFromString(String string) {
            for (Parameterization parameterization : Parameterization.values()) {
                if (parameterization.toString().compareToIgnoreCase(string) != 0) continue;
                return parameterization;
            }
            return null;
        }

        public String toString() {
            return this.text;
        }

        @Override
        public double getLowerScale(double d, double d2) {
            return this.scale.getLowerScale(d, d2);
        }

        @Override
        public double getUpperScale(double d, double d2) {
            return this.scale.getUpperScale(d, d2);
        }
    }

    private static interface Scale {
        public double getLowerScale(double var1, double var3);

        public double getUpperScale(double var1, double var3);
    }
}

