/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.TreeTraitProvider;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Parameter;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;
import java.util.Map;

public class NodeTraitLogger
extends TreeTraitProvider.Helper {
    public static final String TRAIT_LOGGER = "logAllTraits";
    private final TreeModel treeModel;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(TreeModel.class, "The tree which is to be logged")};

        @Override
        public String getParserName() {
            return NodeTraitLogger.TRAIT_LOGGER;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
            try {
                return new NodeTraitLogger(treeModel);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new XMLParseException("Tree " + treeModel.getId() + " contains no traits to log");
            }
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return null;
        }

        @Override
        public String getExample() {
            return null;
        }

        @Override
        public Class getReturnType() {
            return TreeTraitProvider.class;
        }
    };

    public NodeTraitLogger(TreeModel treeModel) {
        this.treeModel = treeModel;
        throw new RuntimeException("NodeTraitLogger has not been fully converted to using TreeTraitProvider");
    }

    public static String[] getAllNodeTraitLabels(TreeModel treeModel) {
        Map<String, Parameter> map = treeModel.getTraitMap(treeModel.getRoot());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, Parameter> entry : map.entrySet()) {
            Parameter parameter = entry.getValue();
            if (parameter.getDimension() == 1) {
                arrayList.add(entry.getKey());
                continue;
            }
            for (int i = 1; i <= parameter.getDimension(); ++i) {
                arrayList.add(entry.getKey() + i);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] getAllNodeTraitValues(TreeModel treeModel, NodeRef nodeRef) {
        Map<String, Parameter> map = treeModel.getTraitMap(nodeRef);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, Parameter> entry : map.entrySet()) {
            Parameter parameter = entry.getValue();
            for (int i = 0; i < parameter.getDimension(); ++i) {
                arrayList.add(Double.toString(parameter.getParameterValue(i)));
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

