/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic.phyloclustering.operators;

import cern.jet.random.Beta;
import dr.evomodel.antigenic.phyloclustering.TreeClusteringVirusesPrior;
import dr.inference.model.Parameter;
import dr.inference.operators.GibbsOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class ProbSitesGibbsOperator
extends SimpleMCMCOperator
implements GibbsOperator {
    public static final String CLASSNAME_OPERATOR = "probSitesGibbsOperator";
    private TreeClusteringVirusesPrior clusterPrior;
    private Parameter probSites;
    private int numSites;
    private double probSite_alpha = 1.0;
    private double probSite_beta = 1.0;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String PROBSITES = "probSites";
        public static final String PROBSITE_ALPHA = "shape";
        public static final String PROBSITE_BETA = "shapeB";
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), AttributeRule.newDoubleRule("shape", true, "the alpha parameter in the Beta prior"), AttributeRule.newDoubleRule("shapeB", true, "the beta parameter in the Beta prior"), new ElementRule(TreeClusteringVirusesPrior.class), new ElementRule("probSites", Parameter.class)};

        @Override
        public String getParserName() {
            return ProbSitesGibbsOperator.CLASSNAME_OPERATOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            double d = xMLObject.getDoubleAttribute("weight");
            XMLObject xMLObject2 = xMLObject.getChild(PROBSITES);
            Parameter parameter = (Parameter)xMLObject2.getChild(Parameter.class);
            TreeClusteringVirusesPrior treeClusteringVirusesPrior = (TreeClusteringVirusesPrior)xMLObject.getChild(TreeClusteringVirusesPrior.class);
            double d2 = 1.0;
            if (xMLObject.hasAttribute(PROBSITE_ALPHA)) {
                d2 = xMLObject.getDoubleAttribute(PROBSITE_ALPHA);
            }
            double d3 = 1.0;
            if (xMLObject.hasAttribute(PROBSITE_BETA)) {
                d3 = xMLObject.getDoubleAttribute(PROBSITE_BETA);
            }
            return new ProbSitesGibbsOperator(d, treeClusteringVirusesPrior, parameter, d2, d3);
        }

        @Override
        public String getParserDescription() {
            return "An operator that updates the probability of sites given a beta distribution.";
        }

        @Override
        public Class getReturnType() {
            return ProbSitesGibbsOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public ProbSitesGibbsOperator(double d, TreeClusteringVirusesPrior treeClusteringVirusesPrior, Parameter parameter, double d2, double d3) {
        this.clusterPrior = treeClusteringVirusesPrior;
        this.probSites = parameter;
        this.numSites = this.clusterPrior.getNumSites();
        this.setWeight(d);
        this.probSite_alpha = d2;
        this.probSite_beta = d3;
    }

    @Override
    public double doOperation() {
        int[] nArray = this.clusterPrior.getCausalCount();
        int[] nArray2 = this.clusterPrior.getNonCausalCount();
        int n = this.probSites.getDimension();
        int n2 = (int)Math.floor(MathUtils.nextDouble() * (double)n);
        double d = Beta.staticNextDouble((double)nArray[n2] + this.probSite_alpha, (double)nArray2[n2] + this.probSite_beta);
        this.probSites.setParameterValue(n2, d);
        return 0.0;
    }

    @Override
    public void accept(double d) {
        super.accept(d);
    }

    @Override
    public void reject() {
        super.reject();
    }

    @Override
    public final String getOperatorName() {
        return CLASSNAME_OPERATOR;
    }

    public int getStepCount() {
        return 1;
    }
}

