/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory.copy;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.memory.IStateIntVector;
import choco.kernel.memory.copy.EnvironmentCopying;
import choco.kernel.memory.copy.RcInt;
import choco.kernel.memory.copy.RecomputableElement;

public final class RcIntVector
implements IStateIntVector,
RecomputableElement {
    public static final int MIN_CAPACITY = 8;
    private int[] elementData;
    private RcInt size;
    private final EnvironmentCopying environment;
    private int timeStamp;

    public RcIntVector(EnvironmentCopying env, int initialSize, int initialValue) {
        int initialCapacity = 8;
        int w = env.getWorldIndex();
        if (initialCapacity < initialSize) {
            initialCapacity = initialSize;
        }
        this.environment = env;
        this.timeStamp = this.environment.getWorldIndex();
        this.elementData = new int[initialCapacity];
        for (int i = 0; i < initialSize; ++i) {
            this.elementData[i] = initialValue;
        }
        this.size = new RcInt(env, initialSize);
        env.add(this);
    }

    public RcIntVector(EnvironmentCopying env, int[] entries) {
        int initialCapacity = 8;
        int w = env.getWorldIndex();
        int initialSize = entries.length;
        if (initialCapacity < initialSize) {
            initialCapacity = initialSize;
        }
        this.environment = env;
        this.elementData = new int[initialCapacity];
        for (int i = 0; i < initialSize; ++i) {
            this.elementData[i] = entries[i];
        }
        this.size = new RcInt(env, initialSize);
        env.add(this);
        this.timeStamp = this.environment.getWorldIndex();
    }

    public RcIntVector(EnvironmentCopying env) {
        this(env, 0, 0);
    }

    @Override
    public int size() {
        return this.size.get();
    }

    @Override
    public boolean isEmpty() {
        return this.size.get() == 0;
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            int[] oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new int[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size.get());
        }
    }

    @Override
    public void add(int i) {
        this.timeStamp = this.environment.getWorldIndex();
        int newsize = this.size.get() + 1;
        this.ensureCapacity(newsize);
        this.size.set(newsize);
        this.elementData[newsize - 1] = i;
    }

    @Override
    public void removeLast() {
        this.timeStamp = this.environment.getWorldIndex();
        int newsize = this.size.get() - 1;
        if (newsize >= 0) {
            this.size.set(newsize);
        }
    }

    @Override
    public int get(int index) {
        if (index < this.size.get() && index >= 0) {
            return this.elementData[index];
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size.get());
    }

    @Override
    public int quickGet(int index) {
        return this.elementData[index];
    }

    @Override
    public boolean contain(int val) {
        int ssize = this.size.get();
        for (int i = 0; i < ssize; ++i) {
            if (val != this.elementData[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public int set(int index, int val) {
        if (index < this.size.get() && index >= 0) {
            int oldValue = this.elementData[index];
            if (val != oldValue) {
                this.elementData[index] = val;
            }
            this.timeStamp = this.environment.getWorldIndex();
            return oldValue;
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size.get());
    }

    @Override
    public int quickSet(int index, int val) {
        int oldValue = this.elementData[index];
        if (val != oldValue) {
            this.elementData[index] = val;
        }
        this.timeStamp = this.environment.getWorldIndex();
        return oldValue;
    }

    public int[] toArray(int[] tab) {
        return new int[0];
    }

    @Override
    public void remove(int i) {
    }

    public void _set(int[] vals) {
        this.timeStamp = this.environment.getWorldIndex();
        System.arraycopy(vals, 0, this.elementData, 0, vals.length);
    }

    public void _set(int[] vals, int timeStamp) {
        this.timeStamp = timeStamp;
        System.arraycopy(vals, 0, this.elementData, 0, vals.length);
    }

    public int[] deepCopy() {
        int[] ret = new int[this.size.get()];
        System.arraycopy(this.elementData, 0, ret, 0, this.size.get());
        return ret;
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public int getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public DisposableIntIterator getIterator() {
        throw new UnsupportedOperationException("not yet implemented");
    }
}

