## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(cmaRs)

## -----------------------------------------------------------------------------
data(preddata.std)
head(preddata.std)

## -----------------------------------------------------------------------------
data(classdata.std)
head(classdata.std)

## -----------------------------------------------------------------------------
data(table.b6)
head(table.b6)

## ----echo=TRUE,  results='hide', eval=FALSE-----------------------------------
#  prediction.model <-  cmaRs(Volume ~ ., degree = 2, nk = 20, data = trees)

## ---- eval=FALSE--------------------------------------------------------------
#  summary(prediction.model)
#  #> Call:
#  #> cmaRs(formula = Volume ~ ., data = trees, degree = 2, nk = 20)
#  
#  #> Volume = +29.1634
#  #> +4.9278 * pmax(0,Girth-14.2)
#  #> -3.2309 * pmax(0,14.2-Girth)
#  #> +0.7313 * pmax(0,Height-75)
#  #> -0.1684 * pmax(0,75-Height)
#  #> +0.1312 * pmax(0,Girth-8.3)*pmax(0,Height-75)
#  #> -1.2977 * pmax(0,Height-78)
#  
#  #> R2 0.9793 r 0.9896 RSS 168.0029

## ----eval=FALSE---------------------------------------------------------------
#  fig1 <- plot(prediction.model)

## ----fig1, echo=FALSE, fig.height=12------------------------------------------
knitr::include_graphics("Figure1.png")

## ----eval=FALSE---------------------------------------------------------------
#  predict(prediction.model)
#  #> [1] 9.259021 9.386200 9.695543 16.703820 20.239753 20.164926 17.308760
#  #> [8] 18.824519 22.046053 19.470698 22.996184 21.255036 21.255036 20.075638
#  #> [15] 22.055412 24.794797 29.229259 31.136370 26.874258 26.018423 32.955379
#  #> [22] 34.096100 30.473296 37.528153 43.074254 52.021298 53.805352 54.756953
#  #> [29] 55.315354 55.315354 77.168803

## ----results='hide', warning=FALSE, eval=FALSE, message=FALSE-----------------
#  library(earth)
#  library(cmaRs)
#  classification.model <- cmaRs(survived ~ age, nk = 35,
#                                classification = TRUE, data = etitanic)

## ----eval=FALSE---------------------------------------------------------------
#  summary(classification.model)
#  #> Call:
#  #> cmaRs(formula = survived ~ age, data = etitanic, classification = TRUE,
#  #> nk = 35)
#  #>
#  #> survived = -4.9489
#  #> -0.3084 * pmax(0,age-18)
#  #> +0.3321 * pmax(0,18-age)
#  #> -0.427 * pmax(0,age-53)
#  #> +0.3564 * pmax(0,age-67)
#  #> -0.3291 * pmax(0,age-64)
#  #> +1.1664 * pmax(0,age-46)
#  #> +0.7742 * pmax(0,age-57)
#  #> -0.1451 * pmax(0,age-35)
#  #> -0.7469 * pmax(0,age-58)
#  #> +0.2288 * pmax(0,age-61)
#  #> +0.0725 * pmax(0,age-41)
#  #> -1.0824 * pmax(0,age-45)
#  #> -0.5147 * pmax(0,age-48)
#  #> +0.3658 * pmax(0,age-51)
#  #> +0.281 * pmax(0,age-44)
#  #> +0.0994 * pmax(0,age-34)
#  #> +0.6316 * pmax(0,age-2)
#  #> -0.32 * pmax(0,age-3)
#  #>
#  #> AUC 0.6221 MCR 0.3681 PCC 0.6319 precision 0.6339 recall 0.895 specificity 0.2506

## ----echo=TRUE, results='hide', warning=FALSE, eval=FALSE---------------------
#  classification.model.threshold <- cmaRs(survived ~ age, nk = 35,
#                                classification = TRUE, data = etitanic,
#                                threshold.class = 0.1, Auto.linpreds = FALSE)

## ----eval=FALSE---------------------------------------------------------------
#  summary(classification.model.threshold)
#  #> Call:
#  #> cmaRs(formula = survived ~ age, data = etitanic, classification = TRUE,
#  #> threshold.class = 0.1, nk = 35, Auto.linpreds = FALSE)
#  #>
#  #> survived = -4.9489
#  #> -0.3084 * pmax(0,age-18)
#  #> +0.3321 * pmax(0,18-age)
#  #> -0.427 * pmax(0,age-53)
#  #> +0.3564 * pmax(0,age-67)
#  #> -0.3291 * pmax(0,age-64)
#  #> +1.1664 * pmax(0,age-46)
#  #> +0.7742 * pmax(0,age-57)
#  #> -0.1451 * pmax(0,age-35)
#  #> -0.7469 * pmax(0,age-58)
#  #> +0.2288 * pmax(0,age-61)
#  #> +0.0725 * pmax(0,age-41)
#  #> -1.0824 * pmax(0,age-45)
#  #> -0.5147 * pmax(0,age-48)
#  #> +0.3658 * pmax(0,age-51)
#  #> +0.281 * pmax(0,age-44)
#  #> +0.0994 * pmax(0,age-34)
#  #> +0.6316 * pmax(0,age-2)
#  #> -0.32 * pmax(0,age-3)
#  #>
#  #> AUC 0.6221 MCR 0.5746 PCC 0.4254 precision 1 recall 0.0291 specificity 1

## ----eval=FALSE---------------------------------------------------------------
#  fig2 <- plot(classification.model)

## ----fig2, echo=FALSE, fig.height=6-------------------------------------------
knitr::include_graphics("Figure2.png")

## -----------------------------------------------------------------------------
data(table.b6)
head(table.b6)

## ----echo=TRUE,  results='hide', eval=FALSE-----------------------------------
#  model.ex1 <- cmaRs(y~., degree = 2, nk = 20, classification = FALSE,
#  Auto.linpreds = FALSE, data = table.b6)
#  
#  summary(model.ex1)
#  # y= +0.003
#  # -0.003 * pmax(0,x4-0.0177)
#  # -0.0798 * pmax(0,0.0177-x4)
#  # 0 * pmax(0,x2-436.9)
#  # 0 * pmax(0,436.9-x2)
#  # -7e-04 * pmax(0,x1-0.0044)*pmax(0,436.9-x2)
#  # -2.6911 * pmax(0,x1-0.01)
#  # +0.5728 * pmax(0,x3-0.0186)
#  # +7e-04 * pmax(0,x1-0.0044)*pmax(0,x2-436.9)
#  # +2.6131 * pmax(0,x1-0.0106)
#  # -2e-04 * pmax(0,436.9-x2)*pmax(0,x4-0.0062)

## ----echo=TRUE,  results='hide', eval=FALSE-----------------------------------
#  model.ex1$bf.cmars
#  # [1] "pmax(0,x4-0.0177)" "pmax(0,0.0177-x4)"
#  # [3] "pmax(0,x2-436.9)" "pmax(0,436.9-x2)"
#  # [5] "pmax(0,x1-0.0044)*pmax(0,436.9-x2)" "pmax(0,x1-0.01)"
#  # [7] "pmax(0,x3-0.0186)" "pmax(0,x1-0.0044)*pmax(0,x2-436.9)"
#  # [9] "pmax(0,x1-0.0106)" "pmax(0,436.9-x2)*pmax(0,x4-0.0062)"

## ----echo=TRUE,  results='hide', eval=FALSE-----------------------------------
#  model.ex1$L
#  #     [,1]     [,2]      [,3]    [,4]     [,5]    [,6]        [,7]      [,8]
#  # [1,] 0  0.0000000 0.0000000 0.00000  0.00000  0.0000   0.0000000 0.0000000
#  # [2,] 0  0.3978693 0.0000000 0.00000  0.00000  0.0000   0.0000000 0.0000000
#  # [3,] 0  0.0000000 0.3339162 0.00000  0.00000  0.0000   0.0000000 0.0000000
#  # [4,] 0  0.0000000 0.0000000 10.15874 0.00000  0.0000   0.0000000 0.0000000
#  # [5,] 0  0.0000000 0.0000000 0.00000  19.45508 0.0000   0.0000000 0.0000000
#  # [6,] 0  0.0000000 0.0000000 0.00000  0.00000  134.2702 0.0000000 0.0000000
#  # [7,] 0  0.0000000 0.0000000 0.00000  0.00000  0.0000   0.3196873 0.0000000
#  # [8,] 0  0.0000000 0.0000000 0.00000  0.00000  0.0000   0.0000000 0.3170173
#  # [9,] 0  0.0000000 0.0000000 0.00000  0.00000  0.0000   0.0000000 0.0000000
#  # [10,] 0 0.0000000 0.0000000 0.00000  0.00000  0.0000   0.0000000 0.0000000
#  # [11,] 0 0.0000000 0.0000000 0.00000  0.00000  0.0000   0.0000000 0.0000000
#  #         [,9]        [,10]    [,11]
#  # [1,]  0.00000   0.0000000   0.0000
#  # [2,]  0.00000   0.0000000   0.0000
#  # [3,]  0.00000   0.0000000   0.0000
#  # [4,]  0.00000   0.0000000   0.0000
#  # [5,]  0.00000   0.0000000   0.0000
#  # [6,]  0.00000   0.0000000   0.0000
#  # [7,]  0.00000   0.0000000   0.0000
#  # [8,]  0.00000   0.0000000   0.0000
#  # [9,]  11.53763  0.0000000   0.0000
#  # [10,] 0.00000   0.3182766   0.0000
#  # [11,] 0.00000   0.0000000   78.2987
#  

## ----echo=TRUE,  results='hide', eval=FALSE-----------------------------------
#     bfs_forward_names <- bfs_forward_names[1:2]

## ----echo=TRUE,  results='hide', eval=FALSE-----------------------------------
#  bfs_forward_names <- rownames(model_mars$dirs)
#  bfs_forward_names <- bfs_forward_names[1:2]
#  bfs_forward_names.orig <- bfs_forward_names

## ----echo=TRUE,  results='hide', eval=FALSE-----------------------------------
#  model.ex1$DMS
#  # [,1] [,2] [,3] [,4]
#  # [1,] "0" "0" "0" "0"
#  # [2,] "0" "0" "0" "0"
#  # [3,] "0" "0" "0" "0"
#  # [4,] "0" "0" "0" "matrix(1, nrow <- (n+1), ncol <- 1)"
#  

## ----echo=TRUE,  results='hide', eval=FALSE-----------------------------------
#  model.ex1$VARMS
#  # [,1] [,2] [,3] [,4]
#  # [1,] "1" "1" "1" "1"
#  # [2,] "1" "1" "1" "1"
#  # [3,] "1" "1" "1" "1"
#  # [4,] "1" "1" "1" "xplus4"
#  

## ----echo=TRUE,  results='hide', eval=FALSE-----------------------------------
#  # matrix(-1, nrow <- (n+1), ncol <- 1)

## ----echo=TRUE,  results='hide', eval=FALSE-----------------------------------
#  model.ex1$DMS
#  #      [,1] [,2]                 [,3]   [,4]
#  # [1,] "0"   "0"                  "0"   "0"
#  # [2,] "0"   "0.0062 - xfirst4"   "0"   "matrix(-1, nrow <- (n+1), ncol <- 1)"
#  # [3,] "0"   "0"                  "0"   "0"
#  # [4,] "0"   "0"                  "0"   "436.9 - xfirst2"
#  

## ----echo=TRUE,  results='hide', eval=FALSE-----------------------------------
#  model.ex1$VARMS
#  #     [,1] [,2]     [,3] [,4]
#  # [1,] "1" "1"      "1" "1"
#  # [2,] "1" "xplus2" "1" "1"
#  # [3,] "1" "1"      "1" "1"
#  # [4,] "1" "1"      "1" "xplus4"
#  

## ----echo=TRUE,  results='hide', eval=FALSE-----------------------------------
#  model.ex1$coefficients
#  # [1] 3.038673e-03 -2.996649e-03 -7.977544e-02 -6.809132e-06 3.517929e-06
#  # [6] -6.991181e-04 -2.691055e+00 5.728424e-01 6.722162e-04 2.613055e+00
#  # [11] -1.701914e-04

## ----echo=TRUE,  results='hide', eval=FALSE-----------------------------------
#  > model.ex1$fitted.values
#  # [1] 0.0007575982 0.0003071999 0.0004176579 0.0005434535 0.0004821474 0.0004517915
#  # [7] 0.0004376478 0.0004160878 0.0013674034 0.0012119509 0.0012961460 0.0011833885
#  # [13] 0.0009870342 0.0012386077 0.0013057215 0.0011887701 0.0012214500 0.0017378222
#  # [19] 0.0017998247 0.0018951991 0.0026293088 0.0031847542 0.0033385298 0.0033184915
#  # [25] 0.0013479697 0.0024916551 0.0027357523 0.0026836362

