/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Statistical_Classifiers.Naive_Bayes;

import java.io.IOException;
import keel.Algorithms.Statistical_Classifiers.Naive_Bayes.myDataset;
import keel.Algorithms.Statistical_Classifiers.Naive_Bayes.parseParameters;
import org.core.Fichero;

public class Algorithm {
    myDataset train;
    myDataset val;
    myDataset test;
    String outputTr;
    String outputTst;
    String output;
    double[] classProb;
    double[][][] attrProb;
    int[][][] counts;
    int nClasses;
    private boolean somethingWrong = false;

    public Algorithm() {
    }

    public Algorithm(parseParameters parameters) {
        this.train = new myDataset();
        this.val = new myDataset();
        this.test = new myDataset();
        try {
            System.out.println("\nReading the training set: " + parameters.getTrainingInputFile());
            this.train.readClassificationSet(parameters.getTrainingInputFile(), true);
            System.out.println("\nReading the validation set: " + parameters.getValidationInputFile());
            this.val.readClassificationSet(parameters.getValidationInputFile(), false);
            System.out.println("\nReading the test set: " + parameters.getTestInputFile());
            this.test.readClassificationSet(parameters.getTestInputFile(), false);
        }
        catch (IOException e) {
            System.err.println("There was a problem while reading the input data-sets: " + e);
            this.somethingWrong = true;
        }
        this.somethingWrong = this.somethingWrong || this.train.hasNumericalAttributes();
        this.outputTr = parameters.getTrainingOutputFile();
        this.outputTst = parameters.getTestOutputFile();
        this.output = parameters.getOutputFile(0);
    }

    public void execute() {
        if (this.somethingWrong) {
            System.err.println("An error was found, the data-set have numerical attributes. Please use a discretizer.");
            System.err.println("Aborting the program");
        } else {
            this.nClasses = this.train.getnOutputs();
            this.computeProbabilites();
            this.doOutput(this.val, this.outputTr);
            this.doOutput(this.test, this.outputTst);
            this.generateOutputInfo();
            System.out.println("Algorithm Finished");
        }
    }

    private void doOutput(myDataset dataset, String filename) {
        String output = new String("");
        output = dataset.copyHeader();
        for (int i = 0; i < dataset.getnData(); ++i) {
            output = output + dataset.getOutputAsString(i) + " " + this.classificationOutput(dataset.getExample(i), dataset.getMissing(i)) + "\n";
        }
        Fichero.escribeFichero(filename, output);
    }

    private String classificationOutput(double[] example, boolean[] missing) {
        int i;
        String output = new String("?");
        double[] probClasses = new double[this.nClasses];
        double[] probExampleClass = new double[this.nClasses];
        double probExample = 0.0;
        for (i = 0; i < this.nClasses; ++i) {
            probExampleClass[i] = this.computeProbExampleClass(example, missing, i);
            probExample += probExampleClass[i] * this.classProb[i];
        }
        for (i = 0; i < this.nClasses; ++i) {
            probClasses[i] = probExampleClass[i] * this.classProb[i] / probExample;
        }
        double max = 0.0;
        int finalClass = -1;
        for (int i2 = 0; i2 < this.nClasses; ++i2) {
            if (!(max < probClasses[i2])) continue;
            max = probClasses[i2];
            finalClass = i2;
        }
        if (finalClass != -1) {
            output = this.train.getOutputValue(finalClass);
        }
        return output;
    }

    private void computeProbabilites() {
        this.computeClassProb();
        this.computeAttrProb();
    }

    private void computeClassProb() {
        this.classProb = new double[this.nClasses];
        this.train.computeInstancesPerClass();
        for (int i = 0; i < this.nClasses; ++i) {
            this.classProb[i] = 1.0 * (double)this.train.numberInstances(i) / (double)this.train.getnData();
        }
    }

    private void computeAttrProb() {
        int k;
        int j;
        int i;
        int j2;
        int i2;
        this.attrProb = new double[this.nClasses][this.train.getnInputs()][1];
        this.counts = new int[this.nClasses][this.train.getnInputs()][1];
        for (i2 = 0; i2 < this.nClasses; ++i2) {
            for (j2 = 0; j2 < this.train.getnInputs(); ++j2) {
                this.attrProb[i2][j2] = new double[this.train.numberValues(j2)];
                this.counts[i2][j2] = new int[this.train.numberValues(j2)];
            }
        }
        for (i2 = 0; i2 < this.train.getnData(); ++i2) {
            double[] example = this.train.getExample(i2);
            int clas = this.train.getOutputAsInteger(i2);
            for (j2 = 0; j2 < this.train.getnInputs(); ++j2) {
                if (this.train.isMissing(i2, j2)) continue;
                double[] dArray = this.attrProb[clas][j2];
                int n = (int)example[j2];
                dArray[n] = dArray[n] + 1.0;
            }
        }
        int[][] contador = new int[this.nClasses][this.train.getnInputs()];
        for (i = 0; i < this.attrProb.length; ++i) {
            for (j = 0; j < this.attrProb[i].length; ++j) {
                for (k = 0; k < this.attrProb[i][j].length; ++k) {
                    this.counts[i][j][k] = (int)this.attrProb[i][j][k];
                    double[] dArray = this.attrProb[i][j];
                    int n = k;
                    dArray[n] = dArray[n] + 1.0;
                    int[] nArray = contador[i];
                    int n2 = j;
                    nArray[n2] = (int)((double)nArray[n2] + this.attrProb[i][j][k]);
                }
            }
        }
        for (i = 0; i < this.attrProb.length; ++i) {
            for (j = 0; j < this.attrProb[i].length; ++j) {
                k = 0;
                while (k < this.attrProb[i][j].length) {
                    double[] dArray = this.attrProb[i][j];
                    int n = k++;
                    dArray[n] = dArray[n] / (double)contador[i][j];
                }
            }
        }
    }

    private double computeProbExampleClass(double[] example, boolean[] missing, int clas) {
        double prob = 1.0;
        for (int i = 0; i < example.length; ++i) {
            if (missing[i]) continue;
            prob *= this.attrProb[clas][i][(int)example[i]];
        }
        return prob;
    }

    private void generateOutputInfo() {
        String string = new String("");
        for (int i = 0; i < this.nClasses; ++i) {
            string = string + "\nClass " + this.train.getOutputValue(i) + ": Prior probability = " + this.classProb[i] + "\n";
            for (int j = 0; j < this.counts[i].length; ++j) {
                string = string + this.train.varName(j) + ": Discrete Estimator. Counts = ";
                int contador = 0;
                for (int k = 0; k < this.counts[i][j].length; ++k) {
                    string = string + this.counts[i][j][k] + " ";
                    contador += this.counts[i][j][k];
                }
                string = string + "(Total = " + contador + ")\n";
            }
            string = string + "\n\n";
        }
        Fichero.escribeFichero(this.output, string);
    }
}

