/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Associative_Classification.ClassifierCPAR;

import java.util.ArrayList;
import keel.Algorithms.Associative_Classification.ClassifierCPAR.DataBase;
import keel.Algorithms.Associative_Classification.ClassifierCPAR.Literal;
import keel.Algorithms.Associative_Classification.ClassifierCPAR.PNArray;
import keel.Algorithms.Associative_Classification.ClassifierCPAR.myDataset;

public class Rule
implements Comparable {
    int[] antecedent;
    int clas;
    int nAnts;
    double laplaceAccuracy;
    DataBase dataBase;

    public Rule() {
    }

    public Rule(DataBase dataBase) {
        this.antecedent = new int[dataBase.numVariables()];
        for (int i = 0; i < this.antecedent.length; ++i) {
            this.antecedent[i] = -1;
        }
        this.dataBase = dataBase;
        this.clas = -1;
        this.nAnts = 0;
        this.laplaceAccuracy = 0.0;
    }

    public Rule(myDataset train, DataBase dataBase, int clas) {
        this.antecedent = new int[dataBase.numVariables()];
        for (int i = 0; i < this.antecedent.length; ++i) {
            this.antecedent[i] = -1;
        }
        this.dataBase = dataBase;
        this.clas = clas;
        this.nAnts = 0;
        this.laplaceAccuracy = 0.0;
    }

    public Rule clone() {
        Rule r = new Rule(this.dataBase);
        for (int i = 0; i < this.antecedent.length; ++i) {
            r.antecedent[i] = this.antecedent[i];
        }
        r.clas = this.clas;
        r.dataBase = this.dataBase;
        r.nAnts = this.nAnts;
        r.laplaceAccuracy = this.laplaceAccuracy;
        return r;
    }

    public void setLabel(int pos, int label) {
        if (this.antecedent[pos] < 0 && label > -1) {
            ++this.nAnts;
        }
        if (this.antecedent[pos] > -1 && label < 0) {
            --this.nAnts;
        }
        this.antecedent[pos] = label;
    }

    public double matching(int[] example) {
        return this.degree(example);
    }

    private double degree(int[] example) {
        double degree = 1.0;
        for (int i = 0; i < this.antecedent.length && degree > 0.0; degree *= (double)this.dataBase.matching(i, this.antecedent[i], example[i]), ++i) {
        }
        return degree;
    }

    public int getClas() {
        return this.clas;
    }

    public int getnAnts() {
        return this.nAnts;
    }

    public double getLaplace() {
        return this.laplaceAccuracy;
    }

    public ArrayList<Literal> getGain(double min_gain, PNArray A) {
        ArrayList<Literal> listLiterals = new ArrayList<Literal>();
        for (int i = 0; i < this.antecedent.length; ++i) {
            if (this.antecedent[i] >= 0 || this.dataBase.numLabels(i) <= 1) continue;
            for (int j = 0; j < this.dataBase.numLabels(i); ++j) {
                double gain = A.getP(i, j) > 0.0 ? A.getP(i, j) * (Math.log(A.getP(i, j) * 1.0 / (A.getP(i, j) + A.getN(i, j))) - Math.log(A.getP() / (A.getP() + A.getN()))) : -1.0;
                if (!(gain >= min_gain)) continue;
                Literal lit = new Literal(i, j);
                lit.setGain(gain);
                listLiterals.add(lit);
            }
        }
        return listLiterals;
    }

    public void calculateLaplace(myDataset train) {
        int nTotal = 0;
        int nc = 0;
        for (int i = 0; i < train.getnData(); ++i) {
            if (!(this.matching(train.getExample(i)) > 0.0)) continue;
            if (train.getOutputAsInteger(i) == this.clas) {
                ++nc;
            }
            ++nTotal;
        }
        this.laplaceAccuracy = ((double)nc + 1.0) / (1.0 * (double)nTotal + (double)train.getnClasses());
    }

    public int compareTo(Object a) {
        if (((Rule)a).laplaceAccuracy < this.laplaceAccuracy) {
            return -1;
        }
        if (((Rule)a).laplaceAccuracy > this.laplaceAccuracy) {
            return 1;
        }
        return 0;
    }
}

