/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.gann;

import keel.Algorithms.Neural_Networks.gann.Genesis;
import keel.Algorithms.Neural_Networks.gann.Network;
import keel.Algorithms.Neural_Networks.gann.Parameters;

public class ConnNetwork
extends Network {
    public boolean[][][] conns;

    public ConnNetwork(Parameters global) {
        int i;
        this.transfer = new String[global.Nhidden_layers + 1];
        for (i = 0; i < global.Nhidden_layers + 1; ++i) {
            this.transfer[i] = global.transfer[i];
        }
        this.Ninputs = global.Ninputs;
        this.Noutputs = global.Noutputs;
        this.Nlayers = global.Nhidden_layers + 2;
        this.Nhidden = new int[this.Nlayers];
        this.w = new double[this.Nlayers - 1][][];
        this.conns = new boolean[this.Nlayers - 1][][];
        this.delta = new double[this.Nlayers][];
        this.activation = new double[this.Nlayers][];
        this.momentum = new double[this.Nlayers - 1][][];
        this.Nhidden[0] = this.Ninputs;
        this.delta[0] = new double[this.Nhidden[0]];
        this.activation[0] = new double[this.Nhidden[0]];
        for (i = 1; i < this.Nlayers; ++i) {
            this.Nhidden[i] = global.Nhidden[i - 1];
            this.w[i - 1] = new double[this.Nhidden[i]][this.Nhidden[i - 1]];
            this.conns[i - 1] = new boolean[this.Nhidden[i]][this.Nhidden[i - 1]];
            this.momentum[i - 1] = new double[this.Nhidden[i]][this.Nhidden[i - 1]];
            this.delta[i] = new double[this.Nhidden[i]];
            this.activation[i] = new double[this.Nhidden[i]];
        }
        this.Nhidden[this.Nlayers - 1] = this.Noutputs;
    }

    public void BackPropagation(Parameters global, int cycles, double[][] data, int npatterns) {
        int i;
        double[] error = new double[this.Noutputs];
        for (int k = 0; k < this.Nlayers - 1; ++k) {
            for (i = 0; i < this.Nhidden[k + 1]; ++i) {
                for (int j = 0; j < this.Nhidden[k]; ++j) {
                    this.momentum[k][i][j] = 0.0;
                }
            }
        }
        for (int iter = 0; iter < cycles; ++iter) {
            int j;
            int i2;
            int k;
            int pattern = Genesis.irandom(0.0, npatterns);
            this.GenerateOutput(data[pattern]);
            for (i = 0; i < this.Noutputs; ++i) {
                error[i] = data[pattern][this.Ninputs + i] - this.activation[this.Nlayers - 1][i];
            }
            for (i = 0; i < this.Noutputs; ++i) {
                this.delta[this.Nlayers - 1][i] = this.transfer[this.Nlayers - 2].compareToIgnoreCase("Log") == 0 ? error[i] * 1.5 * this.activation[this.Nlayers - 1][i] * (1.0 - this.activation[this.Nlayers - 1][i] / 1.7165) : (this.transfer[this.Nlayers - 2].compareToIgnoreCase("Htan") == 0 ? error[i] * 0.38834838333818816 * (1.7165 - this.activation[this.Nlayers - 1][i]) * (1.7165 + this.activation[this.Nlayers - 1][i]) : error[i]);
            }
            for (k = this.Nlayers - 2; k > 0; --k) {
                for (i2 = 0; i2 < this.Nhidden[k]; ++i2) {
                    this.delta[k][i2] = 0.0;
                    for (j = 0; j < this.Nhidden[k + 1]; ++j) {
                        double[] dArray = this.delta[k];
                        int n = i2;
                        dArray[n] = dArray[n] + this.delta[k + 1][j] * this.w[k][j][i2];
                    }
                    if (this.transfer[k - 1].compareToIgnoreCase("Log") == 0) {
                        double[] dArray = this.delta[k];
                        int n = i2;
                        dArray[n] = dArray[n] * (1.5 * this.activation[k][i2] * (1.0 - this.activation[k][i2] / 1.7165));
                        continue;
                    }
                    if (this.transfer[k - 1].compareToIgnoreCase("Htan") != 0) continue;
                    double[] dArray = this.delta[k];
                    int n = i2;
                    dArray[n] = dArray[n] * (0.38834838333818816 * (1.7165 - this.activation[k][i2]) * (1.7165 + this.activation[k][i2]));
                }
            }
            for (k = this.Nlayers - 2; k >= 0; --k) {
                for (i2 = 0; i2 < this.Nhidden[k + 1]; ++i2) {
                    for (j = 0; j < this.Nhidden[k]; ++j) {
                        if (!this.conns[k][i2][j]) continue;
                        double change = global.eta * this.delta[k + 1][i2] * this.activation[k][j] + global.alpha * this.momentum[k][i2][j] - global.lambda * this.w[k][i2][j];
                        double[] dArray = this.w[k][i2];
                        int n = j;
                        dArray[n] = dArray[n] + change;
                        this.momentum[k][i2][j] = change;
                    }
                }
            }
        }
    }
}

