/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima;

import ec.tstoolkit.data.RootMeanSquareNormalizer;
import ec.tstoolkit.modelling.arima.ISeriesScaling;
import ec.tstoolkit.modelling.arima.ModelDescription;
import ec.tstoolkit.modelling.arima.ModellingContext;

public class DefaultSeriesScaling
implements ISeriesScaling {
    private final Type type;

    public DefaultSeriesScaling() {
        this.type = Type.MeanAbs;
    }

    public DefaultSeriesScaling(Type type) {
        this.type = type;
    }

    @Override
    public boolean process(ModellingContext context) {
        if (context.description.getUnits() != 1.0) {
            return false;
        }
        switch (this.type) {
            case MeanAbs: {
                return this.calcMeanAbs(context.description);
            }
            case RootMeanSquare: {
                return this.calcRootMeanSquare(context.description);
            }
            case MaxAbs: {
                return this.calcMaxAbs(context.description);
            }
        }
        return false;
    }

    private boolean calcMeanAbs(ModelDescription model) {
        double[] data = model.getY();
        double s = 0.0;
        int n = 0;
        for (int i = 0; i < data.length; ++i) {
            double d = data[i];
            if (!Double.isFinite(d)) continue;
            s += Math.abs(d);
            ++n;
        }
        if (s == 0.0) {
            return false;
        }
        model.setUnit((double)n / s);
        return true;
    }

    private boolean calcRootMeanSquare(ModelDescription model) {
        double[] data = model.getY();
        double s = 0.0;
        double n = 0.0;
        for (int i = 0; i < data.length; ++i) {
            double d = data[i];
            if (!Double.isFinite(d)) continue;
            s = RootMeanSquareNormalizer.hypot(s, d);
            n += 1.0;
        }
        if (s == 0.0) {
            return false;
        }
        model.setUnit(Math.sqrt(n) / s);
        return true;
    }

    private boolean calcMaxAbs(ModelDescription model) {
        double[] data = model.getY();
        double max = 0.0;
        for (int i = 0; i < data.length; ++i) {
            double d = data[i];
            if (!Double.isFinite(d) || !((d = Math.abs(d)) > max)) continue;
            max = d;
        }
        if (max == 0.0) {
            return false;
        }
        model.setUnit(10.0 / max);
        return true;
    }

    public static enum Type {
        MeanAbs,
        RootMeanSquare,
        MaxAbs;

    }
}

