/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.ui.cytoscape3;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import javax.swing.JOptionPane;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.application.swing.CyAction;
import org.cytoscape.application.swing.CyNodeViewContextMenuFactory;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.work.swing.DialogTaskManager;
import uk.ac.rhul.cs.cl1.ClusterONEAlgorithmParameters;
import uk.ac.rhul.cs.cl1.CohesivenessFunction;
import uk.ac.rhul.cs.cl1.MutableNodeSet;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.AboutAction;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.AffinityColouringAction;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.ClusterONECytoscapeTask;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.ClusterONECytoscapeTaskFactory;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.ControlPanel;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.CyNetworkCache;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.CytoscapeAppActivator;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.Graph;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.GrowClusterAction;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.HelpAction;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.NodeContextMenuFactory;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.NonNumericAttributeException;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.ShowControlPanelAction;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.VisualStyleManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterONECytoscapeApp {
    private CytoscapeAppActivator activator;
    private CySwingApplication app;
    private ControlPanel controlPanel;
    private GrowClusterAction growClusterAction;
    private CyNetworkCache networkCache;
    private String resourcePathName;
    private VisualStyleManager visualStyleManager;
    public static final String ATTRIBUTE_STATUS = "cl1.Status";
    public static final String ATTRIBUTE_AFFINITY = "cl1.Affinity";
    public static final String PREFERRED_MENU = "Apps.ClusterONE";

    public ClusterONECytoscapeApp(CytoscapeAppActivator activator) {
        this.activator = activator;
        this.initialize();
    }

    private void initialize() {
        this.app = this.activator.getService(CySwingApplication.class);
        this.networkCache = new CyNetworkCache(this);
        this.visualStyleManager = new VisualStyleManager(this);
        this.controlPanel = new ControlPanel(this);
        this.growClusterAction = new GrowClusterAction(this);
        this.app.addAction((CyAction)new ShowControlPanelAction(this.controlPanel));
        this.app.addAction((CyAction)this.growClusterAction);
        this.app.addAction((CyAction)new AffinityColouringAction(this));
        this.app.addAction((CyAction)new HelpAction(this, "introduction"));
        this.app.addAction((CyAction)new AboutAction(this));
        this.registerService(new NodeContextMenuFactory(this), CyNodeViewContextMenuFactory.class);
    }

    public ControlPanel getControlPanel() {
        return this.controlPanel;
    }

    public CyApplicationManager getApplicationManager() {
        return this.activator.getService(CyApplicationManager.class);
    }

    public CyNetwork getCurrentNetwork() {
        return this.getApplicationManager().getCurrentNetwork();
    }

    public CyNetworkView getCurrentNetworkView() {
        return this.getApplicationManager().getCurrentNetworkView();
    }

    public CySwingApplication getCySwingApplication() {
        return this.app;
    }

    public AbstractCyAction getGrowClusterAction() {
        return this.growClusterAction;
    }

    public CyNetworkViewManager getNetworkViewManager() {
        return this.activator.getService(CyNetworkViewManager.class);
    }

    public URL getResource(String name) {
        return this.activator.getResource(name);
    }

    public InputStream getResourceAsStream(String name) throws IOException {
        return this.activator.getResourceAsStream(name);
    }

    public String getResourcePathName() {
        if (this.resourcePathName == null) {
            String packageName = this.getClass().getPackage().getName().replace('.', '/');
            packageName = packageName.substring(0, packageName.lastIndexOf(47));
            packageName = packageName.substring(0, packageName.lastIndexOf(47));
            this.resourcePathName = packageName + "/resources";
        }
        return this.resourcePathName;
    }

    public <S> S getService(Class<S> cls) {
        return this.activator.getService(cls);
    }

    public <S> S getService(Class<S> cls, String properties) {
        return this.activator.getService(cls, properties);
    }

    public VisualStyleManager getVisualStyleManager() {
        return this.visualStyleManager;
    }

    public Graph convertCyNetworkToGraph(CyNetwork network, String weightAttr) {
        Graph graph = null;
        try {
            graph = this.networkCache.convertCyNetworkToGraph(network, weightAttr);
        }
        catch (NonNumericAttributeException ex) {
            this.showErrorMessage("Weight attribute values must be numeric.");
            return null;
        }
        return graph;
    }

    public <S> void registerService(S object, Class<S> cls) {
        this.activator.registerService(object, cls);
    }

    public <S> void unregisterService(S object, Class<S> cls) {
        this.activator.unregisterService(object, cls);
    }

    public void runAlgorithm(CyNetwork network, ClusterONEAlgorithmParameters parameters, String weightAttr, ClusterONECytoscapeTask.ResultListener listener) {
        this.networkCache.invalidate(network);
        if (network == null || network.getEdgeCount() == 0) {
            this.showErrorMessage("The selected network contains no edges");
            return;
        }
        ClusterONECytoscapeTaskFactory taskFactory = new ClusterONECytoscapeTaskFactory(this);
        taskFactory.setParameters(parameters);
        taskFactory.setWeightAttr(weightAttr);
        taskFactory.setResultListener(listener);
        DialogTaskManager taskManager = this.activator.getService(DialogTaskManager.class);
        taskManager.execute(taskFactory.createTaskIterator(network));
    }

    public void runAlgorithm(CyNetworkView networkView, ClusterONEAlgorithmParameters parameters, String weightAttr, ClusterONECytoscapeTask.ResultListener listener) {
        CyNetwork network = (CyNetwork)networkView.getModel();
        this.networkCache.invalidate(network);
        if (network == null || network.getEdgeCount() == 0) {
            this.showErrorMessage("The selected network contains no edges");
            return;
        }
        ClusterONECytoscapeTaskFactory taskFactory = new ClusterONECytoscapeTaskFactory(this);
        taskFactory.setParameters(parameters);
        taskFactory.setWeightAttr(weightAttr);
        taskFactory.setResultListener(listener);
        DialogTaskManager taskManager = this.activator.getService(DialogTaskManager.class);
        taskManager.execute(taskFactory.createTaskIterator(networkView));
    }

    public void setAffinityAttributes(CyNetwork network, Graph graph, List<Integer> nodes) {
        CyTable nodeTable = network.getDefaultNodeTable();
        CyColumn affinityColumn = nodeTable.getColumn(ATTRIBUTE_AFFINITY);
        if (affinityColumn != null && affinityColumn.getType() != Double.class) {
            int response = JOptionPane.showConfirmDialog(this.app.getJFrame(), "A node attribute named cl1.Status already exists and it is not a string attribute.\nDo you want to remove the existing attribute and re-register it as a string attribute?", "Attribute type mismatch", 0, 2);
            if (response == 1) {
                return;
            }
            nodeTable.deleteColumn(ATTRIBUTE_AFFINITY);
            affinityColumn = null;
        }
        if (affinityColumn == null) {
            nodeTable.createColumn(ATTRIBUTE_AFFINITY, Double.class, false, (Object)0.0);
        }
        int i = 0;
        MutableNodeSet nodeSet = new MutableNodeSet((uk.ac.rhul.cs.graph.Graph)graph, nodes);
        CohesivenessFunction func = new CohesivenessFunction();
        double currentQuality = func.calculate(nodeSet);
        for (CyNode node : graph.getNodeMapping()) {
            CyRow row;
            double affinity = nodeSet.contains(i) ? -(func.getRemovalAffinity(nodeSet, i) - currentQuality) : func.getAdditionAffinity(nodeSet, i) - currentQuality;
            if (Double.isNaN(affinity)) {
                affinity = 0.0;
            }
            if ((row = network.getRow((CyIdentifiable)node)) != null) {
                row.set(ATTRIBUTE_AFFINITY, (Object)affinity);
            }
            ++i;
        }
    }

    public void showBugMessage(String message) {
        StringBuilder sb = new StringBuilder(message);
        sb.append("\n\n");
        sb.append("This is possibly a bug in ");
        sb.append("ClusterONE");
        sb.append(".\nPlease inform the developers about what you were doing and\n");
        sb.append("what the expected result would have been.");
        JOptionPane.showMessageDialog(this.app.getJFrame(), sb.toString(), "Possible bug in ClusterONE", 0);
    }

    public void showErrorMessage(String message) {
        JOptionPane.showMessageDialog(this.app.getJFrame(), message, "ClusterONE", 0);
    }

    public void showInformationMessage(String message) {
        JOptionPane.showMessageDialog(this.app.getJFrame(), message, "ClusterONE", 1);
    }
}

