/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.filters;

import com.sosnoski.util.array.IntArray;
import uk.ac.rhul.cs.cl1.MutableNodeSet;
import uk.ac.rhul.cs.cl1.filters.NodeSetFilter;

public class HaircutFilter
implements NodeSetFilter {
    private double threshold = 0.2;
    private boolean iterative = true;

    public HaircutFilter(double threshold, boolean iterative) {
        this.setThreshold(threshold);
        this.setIterative(iterative);
    }

    public boolean filter(MutableNodeSet nodeSet) {
        if (this.threshold <= 0.0) {
            return true;
        }
        if (this.isIterative()) {
            return this.filterIterative(nodeSet);
        }
        return this.filterNonIterative(nodeSet);
    }

    protected boolean filterIterative(MutableNodeSet nodeSet) {
        while (!nodeSet.isEmpty()) {
            int minIdx = -1;
            double minInWeight = Double.MAX_VALUE;
            double limit = 2.0 * nodeSet.getTotalInternalEdgeWeight() / (double)nodeSet.size() * this.threshold;
            for (int i : nodeSet) {
                double inWeight = nodeSet.getInternalWeight(i);
                if (!(inWeight < minInWeight)) continue;
                minInWeight = inWeight;
                minIdx = i;
            }
            if (!(minInWeight < limit)) break;
            nodeSet.remove(minIdx);
        }
        return true;
    }

    protected boolean filterNonIterative(MutableNodeSet nodeSet) {
        IntArray nodesToRemove = new IntArray();
        double limit = 2.0 * nodeSet.getTotalInternalEdgeWeight() / (double)nodeSet.size() * this.threshold;
        for (int i : nodeSet) {
            if (!(nodeSet.getInternalWeight(i) < limit)) continue;
            nodesToRemove.add(i);
        }
        nodeSet.remove(nodesToRemove.toArray());
        return true;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public boolean isIterative() {
        return this.iterative;
    }

    public void setIterative(boolean iterative) {
        this.iterative = iterative;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }
}

