/*
 * Decompiled with CFR 0.152.
 */
package com.sosnoski.util;

import com.sosnoski.util.array.ArrayBase;
import com.sosnoski.util.array.CharArray;

public class CharBuffer
extends CharArray {
    protected static final int KEY_MULTIPLIER = 517;

    public CharBuffer(int n, int n2) {
        super(n, n2);
    }

    public CharBuffer(int n) {
        super(n);
    }

    public CharBuffer() {
        this(8);
    }

    public CharBuffer(String string) {
        this(string.length());
        this.append(string);
    }

    public CharBuffer(char[] cArray) {
        this(cArray.length);
        this.append(cArray);
    }

    public CharBuffer(CharArray charArray) {
        super(charArray);
    }

    public int append(String string) {
        int n = string.length();
        this.ensureCapacity(this.m_countPresent + n);
        int n2 = this.m_countPresent;
        int n3 = 0;
        while (n3 < n) {
            this.m_baseArray[this.m_countPresent++] = string.charAt(n3);
            ++n3;
        }
        return n2;
    }

    public int append(char[] cArray, int n, int n2) {
        this.ensureCapacity(this.m_countPresent + n2);
        int n3 = this.m_countPresent;
        System.arraycopy(cArray, n, this.m_baseArray, this.m_countPresent, n2);
        this.m_countPresent += n2;
        return n3;
    }

    public int append(char[] cArray) {
        return this.append(cArray, 0, cArray.length);
    }

    public int append(CharArray charArray) {
        return this.append((char[])ArrayBase.getArray(charArray), 0, charArray.size());
    }

    protected void adjust(int n, int n2, int n3) {
        if (n >= 0 && n2 < this.m_countPresent && n <= n2) {
            int n4 = n + n3 - n2;
            if (n4 > 0) {
                this.ensureCapacity(this.m_countPresent + n4);
            }
            if (n2 < this.m_countPresent) {
                System.arraycopy(this.m_baseArray, n2, this.m_baseArray, n2 + n4, this.m_countPresent - n2);
                this.m_countPresent += n4;
            }
        } else {
            throw new ArrayIndexOutOfBoundsException("Invalid remove range");
        }
    }

    public void replace(int n, int n2, String string) {
        this.adjust(n, n2, string.length());
        string.getChars(0, string.length(), this.m_baseArray, n);
    }

    public void replace(int n, int n2, char[] cArray) {
        this.adjust(n, n2, cArray.length);
        System.arraycopy(cArray, 0, this.m_baseArray, n, cArray.length);
    }

    public void insert(int n, String string) {
        this.adjust(n, n, string.length());
        string.getChars(0, string.length(), this.m_baseArray, n);
    }

    public void insert(int n, char[] cArray) {
        this.adjust(n, n, cArray.length);
        System.arraycopy(cArray, 0, this.m_baseArray, n, cArray.length);
    }

    public boolean equals(String string) {
        if (string != null && this.m_countPresent == string.length()) {
            int n = 0;
            while (n < this.m_countPresent) {
                if (this.m_baseArray[n] != string.charAt(n)) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public boolean equals(char[] cArray, int n, int n2) {
        if (cArray != null && this.m_countPresent == n2) {
            int n3 = 0;
            while (n3 < this.m_countPresent) {
                if (this.m_baseArray[n3] != cArray[n3 + n]) {
                    return false;
                }
                ++n3;
            }
            return true;
        }
        return false;
    }

    public boolean equals(char[] cArray) {
        return this.equals(cArray, 0, cArray.length);
    }

    public boolean equals(CharArray charArray) {
        return this.equals((char[])ArrayBase.getArray(charArray), 0, charArray.size());
    }

    public static boolean equals(char[] cArray, char[] cArray2) {
        if (cArray2 != null && cArray.length == cArray2.length) {
            int n = 0;
            while (n < cArray.length) {
                if (cArray[n] != cArray2[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(char[] cArray, String string) {
        if (string != null && cArray.length == string.length()) {
            int n = 0;
            while (n < cArray.length) {
                if (cArray[n] != string.charAt(n)) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public boolean equalsNoCase(String string) {
        if (string != null && this.m_countPresent == string.length()) {
            int n = 0;
            while (n < this.m_countPresent) {
                if (Character.toLowerCase(this.m_baseArray[n]) != Character.toLowerCase(string.charAt(n))) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public boolean equalsNoCase(char[] cArray, int n, int n2) {
        if (cArray != null && this.m_countPresent == n2) {
            int n3 = 0;
            while (n3 < this.m_countPresent) {
                if (Character.toLowerCase(this.m_baseArray[n3]) != Character.toLowerCase(cArray[n3 + n])) {
                    return false;
                }
                ++n3;
            }
            return true;
        }
        return false;
    }

    public boolean equalsNoCase(char[] cArray) {
        return this.equalsNoCase(cArray, 0, cArray.length);
    }

    public boolean equalsNoCase(CharArray charArray) {
        return this.equalsNoCase((char[])ArrayBase.getArray(charArray), 0, charArray.size());
    }

    public static boolean equalsNoCase(char[] cArray, char[] cArray2) {
        if (cArray2 != null && cArray.length == cArray2.length) {
            int n = 0;
            while (n < cArray.length) {
                if (Character.toUpperCase(cArray[n]) != Character.toUpperCase(cArray2[n])) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public static boolean equalsNoCase(char[] cArray, String string) {
        if (string != null && cArray.length == string.length()) {
            int n = 0;
            while (n < cArray.length) {
                if (Character.toLowerCase(cArray[n]) != Character.toLowerCase(string.charAt(n))) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public static int hashCode(char[] cArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            n = n * 517 + cArray[n2];
            ++n2;
        }
        return n;
    }

    public static int hashCode(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            n = n * 517 + string.charAt(n2);
            ++n2;
        }
        return n;
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.size()) {
            n = n * 517 + this.m_baseArray[n2];
            ++n2;
        }
        return n;
    }

    public Object clone() {
        return new CharBuffer(this);
    }

    public String toString() {
        return new String(this.m_baseArray, 0, this.m_countPresent);
    }

    public String toString(int n, int n2) {
        if (n + n2 <= this.m_countPresent) {
            return new String(this.m_baseArray, n, n2);
        }
        throw new ArrayIndexOutOfBoundsException();
    }
}

