/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent;

import dr.evomodel.coalescent.CoalescentTreeIntervalStatistic;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Likelihood;
import dr.math.distributions.GammaDistribution;

public class GammaProductLikelihood
extends Likelihood.Abstract {
    public static final boolean USE_EXPONENTIAL = false;
    public static final boolean REDUCE_TO_EXPONENTIAL = false;
    public static final boolean DEBUG = false;
    public static final boolean FIXED_TREE = false;
    private TreeModel treeModel;
    private double popSize;
    private double[] means;
    private double[] variances;
    private double[] alphas;
    private double[] betas;

    public GammaProductLikelihood(TreeModel treeModel, double d, double[] dArray, double[] dArray2) {
        super(treeModel);
        int n;
        this.treeModel = treeModel;
        this.popSize = d;
        this.means = dArray;
        this.variances = dArray2;
        System.err.println("\nProvided empirical means and variances: ");
        for (n = 0; n < dArray.length; ++n) {
            System.err.println(dArray[n] + "   " + dArray2[n]);
        }
        System.err.println("Ratio of mean squared and variance:");
        for (n = 0; n < dArray.length; ++n) {
            System.err.println(dArray[n] * dArray[n] / dArray2[n]);
        }
        this.alphas = new double[dArray.length];
        this.betas = new double[dArray.length];
        for (n = 0; n < this.alphas.length; ++n) {
            this.alphas[n] = dArray[n] * dArray[n] / dArray2[n];
        }
        for (n = 0; n < this.betas.length; ++n) {
            this.betas[n] = dArray[n] / dArray2[n];
        }
        System.err.println("\nResulting alphas and betas: ");
        for (n = 0; n < this.alphas.length; ++n) {
            System.err.println(this.alphas[n] + "   " + this.betas[n] + " --> mean = " + this.alphas[n] / this.betas[n] + " variance = " + this.alphas[n] / (this.betas[n] * this.betas[n]));
        }
    }

    public GammaProductLikelihood(TreeModel treeModel, double d, int n) {
        super(treeModel);
        int n2;
        this.treeModel = treeModel;
        this.popSize = d;
        int n3 = n;
        System.err.println("Number of intervals: " + n3);
        this.alphas = new double[n3];
        this.betas = new double[n3];
        for (n2 = 0; n2 < this.alphas.length; ++n2) {
            this.alphas[n2] = 0.5;
        }
        for (n2 = 0; n2 < this.betas.length; ++n2) {
            this.betas[n2] = 0.5 / this.popSize;
        }
        System.err.println("\nResulting alphas and betas: ");
        for (n2 = 0; n2 < this.alphas.length; ++n2) {
            System.err.println(this.alphas[n2] + "   " + this.betas[n2] + " --> mean = " + this.alphas[n2] / this.betas[n2] + " variance = " + this.alphas[n2] / (this.betas[n2] * this.betas[n2]));
        }
    }

    @Override
    public double calculateLogLikelihood() {
        double d = 0.0;
        CoalescentTreeIntervalStatistic coalescentTreeIntervalStatistic = new CoalescentTreeIntervalStatistic(this.treeModel);
        int n = 0;
        for (int i = 0; i < coalescentTreeIntervalStatistic.getDimension(); ++i) {
            int n2 = (int)coalescentTreeIntervalStatistic.getLineageCount(i) * ((int)coalescentTreeIntervalStatistic.getLineageCount(i) - 1) / 2;
            double d2 = coalescentTreeIntervalStatistic.getStatisticValue(i);
            if (coalescentTreeIntervalStatistic.getLineageCount(i) == 1.0) continue;
            if (i == coalescentTreeIntervalStatistic.getDimension() - 1) {
                d += GammaDistribution.logPdf(d2, this.alphas[n], 1.0 / ((double)n2 * this.betas[n])) - Math.log(n2);
                continue;
            }
            if (coalescentTreeIntervalStatistic.getLineageCount(i) > coalescentTreeIntervalStatistic.getLineageCount(i + 1)) {
                d += GammaDistribution.logPdf(d2, this.alphas[n], 1.0 / ((double)n2 * this.betas[n])) - Math.log(n2);
                ++n;
                continue;
            }
            d += Math.log(1.0 - GammaDistribution.cdf(d2, this.alphas[n], 1.0 / ((double)n2 * this.betas[n])));
        }
        return d;
    }

    @Override
    protected boolean getLikelihoodKnown() {
        return false;
    }
}

