/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.datatype;

import dr.evolution.datatype.DataType;

public class MutationDeathType
extends DataType {
    protected static String DESCRIPTION = "MutationDeathType";
    protected static int UNKNOWN_STATE = 128;
    protected int[][] codes;
    protected char[] stateCodes;
    public int DEATHSTATE;

    public MutationDeathType(char c, char c2) {
        this.initialize_internals();
        this.codes[c2] = new int[]{0};
        this.stateCodes[0] = c2;
        this.codes[c] = new int[]{1};
        this.stateCodes[1] = c;
        this.stateCount = 2;
        this.DEATHSTATE = 1;
        this.ambiguousStateCount = 0;
    }

    public MutationDeathType(DataType dataType, char c) {
        int n;
        this.initialize_internals();
        for (n = 0; n < dataType.getStateCount(); ++n) {
            char c2 = dataType.getCode(n).charAt(0);
            this.codes[c2] = new int[]{n};
            this.stateCodes[n] = c2;
        }
        this.codes[c] = new int[]{n};
        this.stateCodes[n] = c;
        this.DEATHSTATE = n;
        this.stateCount = n + 1;
        for (n = 0; n < 128; ++n) {
            int n2 = dataType.getState((char)n);
            if (n2 <= 0 || n2 >= 128 || !dataType.isAmbiguousState(n2) || n == c || dataType.isUnknownState(n2)) continue;
            int[] nArray = dataType.getStates(n2);
            this.codes[n] = new int[nArray.length];
            System.arraycopy(nArray, 0, this.codes[n], 0, nArray.length);
        }
        this.ambiguousStateCount = dataType.getAmbiguousStateCount() + 1;
    }

    public void addAmbiguity(char c, String string) {
        if (string.length() == 0) {
            this.codes[c] = new int[this.stateCount];
            for (int i = 0; i < this.stateCount; ++i) {
                this.codes[c][i] = i;
            }
        } else {
            this.codes[c] = new int[string.length()];
            for (int i = 0; i < string.length(); ++i) {
                this.codes[c][i] = this.getState(string.charAt(i));
            }
        }
        ++this.ambiguousStateCount;
    }

    private void initialize_internals() {
        this.codes = new int[128][];
        this.stateCodes = new char[128];
    }

    @Override
    public char[] getValidChars() {
        return null;
    }

    @Override
    public int getState(char c) {
        if (this.codes[c] != null && this.codes[c].length == 1) {
            return this.codes[c][0];
        }
        return c;
    }

    @Override
    public int getUnknownState() {
        return UNKNOWN_STATE;
    }

    @Override
    public char getChar(int n) {
        if (n < this.stateCount) {
            return this.stateCodes[n];
        }
        return super.getChar(n);
    }

    @Override
    public int[] getStates(int n) {
        if (n < this.stateCount) {
            return this.codes[this.stateCodes[n]];
        }
        return this.codes[n];
    }

    @Override
    public boolean[] getStateSet(int n) {
        int n2;
        boolean[] blArray = new boolean[this.stateCount];
        for (n2 = 0; n2 < this.stateCount; ++n2) {
            blArray[n2] = false;
        }
        int[] nArray = this.getStates(n);
        for (n2 = 0; nArray != null && n2 < nArray.length; ++n2) {
            blArray[nArray[n2]] = true;
        }
        return blArray;
    }

    @Override
    public boolean isAmbiguousChar(char c) {
        return this.codes[c] != null && this.codes[c].length > 1;
    }

    @Override
    public boolean isUnknownChar(char c) {
        return this.codes[c] == null;
    }

    @Override
    public boolean isAmbiguousState(int n) {
        return n >= this.stateCount;
    }

    @Override
    public boolean isUnknownState(int n) {
        return n >= this.stateCount && this.codes[n] == null;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public int getType() {
        return 314;
    }
}

