#ifndef __LANTERN_H__
#define __LANTERN_H__

#ifndef _WIN32
#include <dlfcn.h>
#else
#define WIN32_LEAN_AND_MEAN 1
#include <windows.h>
#endif

#ifndef HOST_API
#define HOST_API inline
#endif

#ifdef LANTERN_BUILD
#define LANTERN_PTR
#define LANTERN_HEADERS_ONLY

#ifdef _WIN32
#define LANTERN_API extern "C" __declspec(dllexport)
#endif
#else
#define LANTERN_PTR *
#endif

#ifndef LANTERN_API
#ifdef LANTERN_HEADERS_ONLY
#define LANTERN_API extern
#else
#define LANTERN_API
#endif
#endif

#ifndef LANTERN_HOST_HANDLER
void lantern_host_handler();
#define LANTERN_HOST_HANDLER lantern_host_handler();
#endif

#ifndef LANTERN_CHECK_LOADED
extern bool lantern_loaded;
void check_lantern_loaded();
#define LANTERN_CHECK_LOADED check_lantern_loaded();
#endif

#include <stdint.h>
#include <stdio.h>
#include <string>

extern int lanternLogEnabled;
#define LLOG(...) if ((lanternLogEnabled & 1) == 1) {              \
  printf("%ld INFO ", time(NULL));                                 \
  printf(__VA_ARGS__);                                             \
  printf("\n");                                                    \
}                                                                  \
if ((lanternLogEnabled & 2) == 2) {                                \
  FILE *pFile = fopen("lantern.log", "a");                         \
  fprintf(pFile, "%ld INFO ", time(NULL));                         \
  fprintf(pFile, __VA_ARGS__);                                     \
  fprintf(pFile, "\n");                                            \
  fclose(pFile);                                                   \
}

#ifdef LANTERN_BUILD
extern std::string *pLanternLastError;
#endif
#define LANTERN_FUNCTION_START                                     \
  LLOG("Entering %s", __func__)                                    \
  try {
#define LANTERN_FUNCTION_END_RET(ret)                              \
} catch(const std::exception& ex) {                                \
  LLOG("Error %s in %s", ex.what(), __func__)                      \
  pLanternLastError = new std::string(ex.what());                  \
  return ret;                                                      \
} catch(std::string& ex) {                                         \
  LLOG("Error %s in %s", ex.c_str(), __func__)                     \
  pLanternLastError = new std::string(ex);                         \
  return ret;                                                      \
} catch(...) {                                                     \
  LLOG("Error in %s", __func__)                                    \
  pLanternLastError = new std::string("Unknown error. ");          \
  return ret;                                                      \
}
#define LANTERN_FUNCTION_END LANTERN_FUNCTION_END_RET(NULL)
#define LANTERN_FUNCTION_END_VOID                                  \
} catch(const std::exception& ex) {                                \
  LLOG("Error %s in %s", ex.what(), __func__)                      \
  pLanternLastError = new std::string(ex.what());                  \
} catch(std::string& ex) {                                         \
  LLOG("Error %s in %s", ex.c_str(), __func__)                     \
  pLanternLastError = new std::string(ex);                         \
} catch(...) {                                                     \
  LLOG("Error in %s", __func__)                                    \
  pLanternLastError = new std::string("Unknown error. ");          \
}
 
#ifdef __cplusplus
extern "C"
{
#endif

enum IValue_types {
    IValueBlobType,
    IValueBoolType,
    IValueBoolListType,
    IValueCapsuleType,
    IValueComplexDoubleType,
    IValueComplexDoubleListType,
    IValueCustomClassType,
    IValueDeviceType,
    IValueDoubleType,
    IValueDoubleListType,
    IValueNoneType,
    IValueEnumType,
    IValueFutureType,
    IValueGeneratorType,
    IValueGenericDictType,
    IValueIntType,
    IValueIntListType,
    IValueListType,
    IValueModuleType,
    IValueObjectType,
    IValuePtrTypeType,
    IValuePyObjectType,
    IValueQuantizerType,
    IValueRRefType,
    IValueSameIdentityType,
    IValueScalarType,
    IValueStorageType,
    IValueStreamType,
    IValueStringType,
    IValueTensorType,
    IValueTensorListType,
    IValueTupleType,
    IValueTypeUnknownType
};



#define LANTERN_TYPE2VOID_DECL(type, name)                            \
  LANTERN_API type (LANTERN_PTR _##name) (void*);                     \
  HOST_API type name (void* x) {                                      \
      LANTERN_CHECK_LOADED                                            \
      type ret = _##name(x);                                          \
      LANTERN_HOST_HANDLER return ret;                                \
  }                                                                     

#define LANTERN_VOID2VOID_DECL(type, name)                            \
  LANTERN_API type (LANTERN_PTR _##name) (void*);                     \
  HOST_API type name (void* x) {                                      \
      LANTERN_CHECK_LOADED                                            \
      _##name(x);                                          \
      LANTERN_HOST_HANDLER;                                \
  }

#define LANTERN_OPTIONAL_DECLS(name)                                  \
  LANTERN_TYPE2VOID_DECL(void*, lantern_optional_##name)              \
  LANTERN_TYPE2VOID_DECL(bool, lantern_optional_##name##_has_value)   \
  LANTERN_TYPE2VOID_DECL(void*, lantern_optional_##name##_value)      \
  LANTERN_VOID2VOID_DECL(void, lantern_optional_##name##_delete)      \


LANTERN_OPTIONAL_DECLS(dimname_list)
LANTERN_OPTIONAL_DECLS(generator)
LANTERN_OPTIONAL_DECLS(tensor)
LANTERN_OPTIONAL_DECLS(double)
LANTERN_OPTIONAL_DECLS(int64_t)
LANTERN_OPTIONAL_DECLS(bool)
LANTERN_OPTIONAL_DECLS(scalar_type)
LANTERN_OPTIONAL_DECLS(string)
LANTERN_OPTIONAL_DECLS(scalar)
LANTERN_OPTIONAL_DECLS(memory_format)
LANTERN_OPTIONAL_DECLS(device)
LANTERN_OPTIONAL_DECLS(string_view)

  LANTERN_API void(LANTERN_PTR lanternConfigure)(int log);
  LANTERN_API const char*(LANTERN_PTR lanternVersion)();
  LANTERN_API void(LANTERN_PTR lanternSetLastError)(const char*);
  LANTERN_API void(LANTERN_PTR lanternLastErrorClear)();
  LANTERN_API const char*(LANTERN_PTR lanternLastError)();
  LANTERN_API void(LANTERN_PTR lanternTest)();
  LANTERN_API void *(LANTERN_PTR _lantern_Device)(const char *type, int64_t index, bool useIndex);
  HOST_API void * lantern_Device(const char *type, int64_t index, bool useIndex) {LANTERN_CHECK_LOADED void * ret = _lantern_Device(type, index, useIndex); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API const char *(LANTERN_PTR _lantern_Device_type)(void *device);
  HOST_API const char * lantern_Device_type(void *device) {LANTERN_CHECK_LOADED const char * ret = _lantern_Device_type(device); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API int64_t(LANTERN_PTR _lantern_Device_index)(void *device);
  HOST_API int64_t lantern_Device_index(void *device) {LANTERN_CHECK_LOADED int64_t ret = _lantern_Device_index(device); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API const char *(LANTERN_PTR _lantern_Tensor_StreamInsertion)(void *x);
  HOST_API const char * lantern_Tensor_StreamInsertion(void *x) {LANTERN_CHECK_LOADED const char * ret = _lantern_Tensor_StreamInsertion(x); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_TensorOptions)();
  HOST_API void * lantern_TensorOptions() {LANTERN_CHECK_LOADED void * ret = _lantern_TensorOptions(); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_TensorOptions_dtype)(void *self, void *dtype);
  HOST_API void * lantern_TensorOptions_dtype(void *self, void *dtype) {LANTERN_CHECK_LOADED void * ret = _lantern_TensorOptions_dtype(self, dtype); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_TensorOptions_layout)(void *self, void *layout);
  HOST_API void * lantern_TensorOptions_layout(void *self, void *layout) {LANTERN_CHECK_LOADED void * ret = _lantern_TensorOptions_layout(self, layout); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_TensorOptions_device)(void *self, void *device);
  HOST_API void * lantern_TensorOptions_device(void *self, void *device) {LANTERN_CHECK_LOADED void * ret = _lantern_TensorOptions_device(self, device); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_TensorOptions_requires_grad)(void *self, bool requires_grad);
  HOST_API void * lantern_TensorOptions_requires_grad(void *self, bool requires_grad) {LANTERN_CHECK_LOADED void * ret = _lantern_TensorOptions_requires_grad(self, requires_grad); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_TensorOptions_pinned_memory)(void *self, bool pinned_memory);
  HOST_API void * lantern_TensorOptions_pinned_memory(void *self, bool pinned_memory) {LANTERN_CHECK_LOADED void * ret = _lantern_TensorOptions_pinned_memory(self, pinned_memory); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_Dtype_float32)();
  HOST_API void * lantern_Dtype_float32() {LANTERN_CHECK_LOADED void * ret = _lantern_Dtype_float32(); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_Dtype_cfloat)();
  HOST_API void * lantern_Dtype_cfloat() {LANTERN_CHECK_LOADED void * ret = _lantern_Dtype_cfloat(); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_Dtype_cdouble)();
  HOST_API void * lantern_Dtype_cdouble() {LANTERN_CHECK_LOADED void * ret = _lantern_Dtype_cdouble(); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_Dtype_float64)();
  HOST_API void * lantern_Dtype_float64() {LANTERN_CHECK_LOADED void * ret = _lantern_Dtype_float64(); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_Dtype_float16)();
  HOST_API void * lantern_Dtype_float16() {LANTERN_CHECK_LOADED void * ret = _lantern_Dtype_float16(); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_Dtype_uint8)();
  HOST_API void * lantern_Dtype_uint8() {LANTERN_CHECK_LOADED void * ret = _lantern_Dtype_uint8(); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_Dtype_int8)();
  HOST_API void * lantern_Dtype_int8() {LANTERN_CHECK_LOADED void * ret = _lantern_Dtype_int8(); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_Dtype_int16)();
  HOST_API void * lantern_Dtype_int16() {LANTERN_CHECK_LOADED void * ret = _lantern_Dtype_int16(); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_Dtype_int32)();
  HOST_API void * lantern_Dtype_int32() {LANTERN_CHECK_LOADED void * ret = _lantern_Dtype_int32(); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_Dtype_int64)();
  HOST_API void * lantern_Dtype_int64() {LANTERN_CHECK_LOADED void * ret = _lantern_Dtype_int64(); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_Dtype_bool)();
  HOST_API void * lantern_Dtype_bool() {LANTERN_CHECK_LOADED void * ret = _lantern_Dtype_bool(); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_Dtype_byte)();
  HOST_API void * lantern_Dtype_byte() {LANTERN_CHECK_LOADED void * ret = _lantern_Dtype_byte(); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_Dtype_type)(void *dtype);
  HOST_API void * lantern_Dtype_type(void *dtype) {LANTERN_CHECK_LOADED void * ret = _lantern_Dtype_type(dtype); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_vector_int64_t)(int64_t *x, size_t x_size);
  HOST_API void * lantern_vector_int64_t(int64_t *x, size_t x_size) {LANTERN_CHECK_LOADED void * ret = _lantern_vector_int64_t(x, x_size); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_vector_double)(double *x, size_t x_size);
  HOST_API void * lantern_vector_double(double *x, size_t x_size) {LANTERN_CHECK_LOADED void * ret = _lantern_vector_double(x, x_size); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_MemoryFormat_Contiguous)();
  HOST_API void * lantern_MemoryFormat_Contiguous() {LANTERN_CHECK_LOADED void * ret = _lantern_MemoryFormat_Contiguous(); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_MemoryFormat_Preserve)();
  HOST_API void * lantern_MemoryFormat_Preserve() {LANTERN_CHECK_LOADED void * ret = _lantern_MemoryFormat_Preserve(); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_MemoryFormat_ChannelsLast)();
  HOST_API void * lantern_MemoryFormat_ChannelsLast() {LANTERN_CHECK_LOADED void * ret = _lantern_MemoryFormat_ChannelsLast(); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API const char *(LANTERN_PTR _lantern_MemoryFormat_type)(void *format);
  HOST_API const char * lantern_MemoryFormat_type(void *format) {LANTERN_CHECK_LOADED const char * ret = _lantern_MemoryFormat_type(format); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_Tensor_clone)(void *self);
  HOST_API void * lantern_Tensor_clone(void *self) {LANTERN_CHECK_LOADED void * ret = _lantern_Tensor_clone(self); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_Tensor_permute)(void *self, void *dims);
  HOST_API void * lantern_Tensor_permute(void *self, void *dims) {LANTERN_CHECK_LOADED void * ret = _lantern_Tensor_permute(self, dims); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_Tensor_contiguous)(void *self);
  HOST_API void * lantern_Tensor_contiguous(void *self) {LANTERN_CHECK_LOADED void * ret = _lantern_Tensor_contiguous(self); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_Tensor_to)(void *self, void *options);
  HOST_API void * lantern_Tensor_to(void *self, void *options) {LANTERN_CHECK_LOADED void * ret = _lantern_Tensor_to(self, options); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_Tensor_set_requires_grad)(void *self, bool requires_grad);
  HOST_API void * lantern_Tensor_set_requires_grad(void *self, bool requires_grad) {LANTERN_CHECK_LOADED void * ret = _lantern_Tensor_set_requires_grad(self, requires_grad); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API double *(LANTERN_PTR _lantern_Tensor_data_ptr_double)(void *self);
  HOST_API double * lantern_Tensor_data_ptr_double(void *self) {LANTERN_CHECK_LOADED double * ret = _lantern_Tensor_data_ptr_double(self); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API uint8_t *(LANTERN_PTR _lantern_Tensor_data_ptr_uint8_t)(void *self);
  HOST_API uint8_t * lantern_Tensor_data_ptr_uint8_t(void *self) {LANTERN_CHECK_LOADED uint8_t * ret = _lantern_Tensor_data_ptr_uint8_t(self); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API int32_t *(LANTERN_PTR _lantern_Tensor_data_ptr_int32_t)(void *self);
  HOST_API int32_t * lantern_Tensor_data_ptr_int32_t(void *self) {LANTERN_CHECK_LOADED int32_t * ret = _lantern_Tensor_data_ptr_int32_t(self); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API int16_t *(LANTERN_PTR _lantern_Tensor_data_ptr_int16_t)(void *self);
  HOST_API int16_t * lantern_Tensor_data_ptr_int16_t(void *self) {LANTERN_CHECK_LOADED int16_t * ret = _lantern_Tensor_data_ptr_int16_t(self); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API bool *(LANTERN_PTR _lantern_Tensor_data_ptr_bool)(void *self);
  HOST_API bool * lantern_Tensor_data_ptr_bool(void *self) {LANTERN_CHECK_LOADED bool * ret = _lantern_Tensor_data_ptr_bool(self); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API int64_t(LANTERN_PTR _lantern_Tensor_numel)(void *self);
  HOST_API int64_t lantern_Tensor_numel(void *self) {LANTERN_CHECK_LOADED int64_t ret = _lantern_Tensor_numel(self); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API int64_t(LANTERN_PTR _lantern_Tensor_element_size)(void *self);
  HOST_API int64_t lantern_Tensor_element_size(void *self) {LANTERN_CHECK_LOADED int64_t ret = _lantern_Tensor_element_size(self); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API int64_t(LANTERN_PTR _lantern_Tensor_size)(void *self, int64_t i);
  HOST_API int64_t lantern_Tensor_size(void *self, int64_t i) {LANTERN_CHECK_LOADED int64_t ret = _lantern_Tensor_size(self, i); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API int64_t(LANTERN_PTR _lantern_Tensor_ndimension)(void *self);
  HOST_API int64_t lantern_Tensor_ndimension(void *self) {LANTERN_CHECK_LOADED int64_t ret = _lantern_Tensor_ndimension(self); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_Tensor_dtype)(void *self);
  HOST_API void * lantern_Tensor_dtype(void *self) {LANTERN_CHECK_LOADED void * ret = _lantern_Tensor_dtype(self); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_Generator)();
  HOST_API void * lantern_Generator() {LANTERN_CHECK_LOADED void * ret = _lantern_Generator(); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API uint64_t(LANTERN_PTR _lantern_Generator_current_seed)(void *generator);
  HOST_API uint64_t lantern_Generator_current_seed(void *generator) {LANTERN_CHECK_LOADED uint64_t ret = _lantern_Generator_current_seed(generator); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void(LANTERN_PTR _lantern_Generator_set_current_seed)(void *generator, uint64_t seed);
  HOST_API void lantern_Generator_set_current_seed(void *generator, uint64_t seed) {LANTERN_CHECK_LOADED _lantern_Generator_set_current_seed(generator, seed); LANTERN_HOST_HANDLER }
  LANTERN_API void *(LANTERN_PTR _lantern_QScheme_per_channel_affine)();
  HOST_API void * lantern_QScheme_per_channel_affine() {LANTERN_CHECK_LOADED void * ret = _lantern_QScheme_per_channel_affine(); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_QScheme_per_tensor_affine)();
  HOST_API void * lantern_QScheme_per_tensor_affine() {LANTERN_CHECK_LOADED void * ret = _lantern_QScheme_per_tensor_affine(); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_QScheme_per_channel_symmetric)();
  HOST_API void * lantern_QScheme_per_channel_symmetric() {LANTERN_CHECK_LOADED void * ret = _lantern_QScheme_per_channel_symmetric(); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_QScheme_per_tensor_symmetric)();
  HOST_API void * lantern_QScheme_per_tensor_symmetric() {LANTERN_CHECK_LOADED void * ret = _lantern_QScheme_per_tensor_symmetric(); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API const char *(LANTERN_PTR _lantern_QScheme_type)(void *x);
  HOST_API const char * lantern_QScheme_type(void *x) {LANTERN_CHECK_LOADED const char * ret = _lantern_QScheme_type(x); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_TensorList)();
  HOST_API void * lantern_TensorList() {LANTERN_CHECK_LOADED void * ret = _lantern_TensorList(); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void(LANTERN_PTR _lantern_TensorList_push_back)(void *self, void *x);
  HOST_API void lantern_TensorList_push_back(void *self, void *x) {LANTERN_CHECK_LOADED _lantern_TensorList_push_back(self, x); LANTERN_HOST_HANDLER }
  LANTERN_API void *(LANTERN_PTR _lantern_TensorList_at)(void *self, int64_t i);
  HOST_API void * lantern_TensorList_at(void *self, int64_t i) {LANTERN_CHECK_LOADED void * ret = _lantern_TensorList_at(self, i); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API int64_t(LANTERN_PTR _lantern_TensorList_size)(void *self);
  HOST_API int64_t lantern_TensorList_size(void *self) {LANTERN_CHECK_LOADED int64_t ret = _lantern_TensorList_size(self); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_Scalar)(void *value, const char *type);
  HOST_API void * lantern_Scalar(void *value, const char *type) {LANTERN_CHECK_LOADED void * ret = _lantern_Scalar(value, type); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_vector_get)(void *x, int i);
  HOST_API void * lantern_vector_get(void *x, int i) {LANTERN_CHECK_LOADED void * ret = _lantern_vector_get(x, i); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_int64_t)(int64_t x);
  HOST_API void * lantern_int64_t(int64_t x) {LANTERN_CHECK_LOADED void * ret = _lantern_int64_t(x); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_bool)(bool x);
  HOST_API void * lantern_bool(bool x) {LANTERN_CHECK_LOADED void * ret = _lantern_bool(x); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_Dimname)(void* name);
  HOST_API void * lantern_Dimname(void* name) {LANTERN_CHECK_LOADED void * ret = _lantern_Dimname(name); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_DimnameList)();
  HOST_API void * lantern_DimnameList() {LANTERN_CHECK_LOADED void * ret = _lantern_DimnameList(); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void(LANTERN_PTR _lantern_DimnameList_push_back)(void *list, void *dimname);
  HOST_API void lantern_DimnameList_push_back(void *list, void *dimname) {LANTERN_CHECK_LOADED _lantern_DimnameList_push_back(list, dimname); LANTERN_HOST_HANDLER }
  LANTERN_API const char *(LANTERN_PTR _lantern_Dimname_to_string)(void *dimname);
  HOST_API const char * lantern_Dimname_to_string(void *dimname) {LANTERN_CHECK_LOADED const char * ret = _lantern_Dimname_to_string(dimname); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API int64_t(LANTERN_PTR _lantern_DimnameList_size)(void *list);
  HOST_API int64_t lantern_DimnameList_size(void *list) {LANTERN_CHECK_LOADED int64_t ret = _lantern_DimnameList_size(list); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_DimnameList_at)(void *list, int i);
  HOST_API void * lantern_DimnameList_at(void *list, int i) {LANTERN_CHECK_LOADED void * ret = _lantern_DimnameList_at(list, i); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_Scalar_nullopt)();
  HOST_API void * lantern_Scalar_nullopt() {LANTERN_CHECK_LOADED void * ret = _lantern_Scalar_nullopt(); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void(LANTERN_PTR _lantern_Tensor_delete)(void *);
  HOST_API void lantern_Tensor_delete(void * x) {LANTERN_CHECK_LOADED _lantern_Tensor_delete(x); LANTERN_HOST_HANDLER }
  LANTERN_API void(LANTERN_PTR _lantern_bool_delete)(void *);
  HOST_API void lantern_bool_delete(void * x) {LANTERN_CHECK_LOADED _lantern_bool_delete(x); LANTERN_HOST_HANDLER }
  LANTERN_API void(LANTERN_PTR _lantern_int64_t_delete)(void *);
  HOST_API void lantern_int64_t_delete(void * x) {LANTERN_CHECK_LOADED _lantern_int64_t_delete(x); LANTERN_HOST_HANDLER }
  LANTERN_API void(LANTERN_PTR _lantern_TensorList_delete)(void *);
  HOST_API void lantern_TensorList_delete(void * x) {LANTERN_CHECK_LOADED _lantern_TensorList_delete(x); LANTERN_HOST_HANDLER }
  LANTERN_API void(LANTERN_PTR _lantern_double_delete)(void *);
  HOST_API void lantern_double_delete(void * x) {LANTERN_CHECK_LOADED _lantern_double_delete(x); LANTERN_HOST_HANDLER }
  LANTERN_API void(LANTERN_PTR _lantern_QScheme_delete)(void *);
  HOST_API void lantern_QScheme_delete(void * x) {LANTERN_CHECK_LOADED _lantern_QScheme_delete(x); LANTERN_HOST_HANDLER }
  LANTERN_API void(LANTERN_PTR _lantern_Scalar_delete)(void *);
  HOST_API void lantern_Scalar_delete(void * x) {LANTERN_CHECK_LOADED _lantern_Scalar_delete(x); LANTERN_HOST_HANDLER }
  LANTERN_API void(LANTERN_PTR _lantern_ScalarType_delete)(void *);
  HOST_API void lantern_ScalarType_delete(void * x) {LANTERN_CHECK_LOADED _lantern_ScalarType_delete(x); LANTERN_HOST_HANDLER }
  LANTERN_API void(LANTERN_PTR _lantern_TensorOptions_delete)(void *x);
  HOST_API void lantern_TensorOptions_delete(void *x) {LANTERN_CHECK_LOADED _lantern_TensorOptions_delete(x); LANTERN_HOST_HANDLER }
  LANTERN_API void(LANTERN_PTR _lantern_Dtype_delete)(void *x);
  HOST_API void lantern_Dtype_delete(void *x) {LANTERN_CHECK_LOADED _lantern_Dtype_delete(x); LANTERN_HOST_HANDLER }
  LANTERN_API void(LANTERN_PTR _lantern_Device_delete)(void *x);
  HOST_API void lantern_Device_delete(void *x) {LANTERN_CHECK_LOADED _lantern_Device_delete(x); LANTERN_HOST_HANDLER }
  LANTERN_API void(LANTERN_PTR _lantern_Layout_delete)(void *x);
  HOST_API void lantern_Layout_delete(void *x) {LANTERN_CHECK_LOADED _lantern_Layout_delete(x); LANTERN_HOST_HANDLER }
  LANTERN_API void(LANTERN_PTR _lantern_TensorOptions_print)(void *self);
  HOST_API void lantern_TensorOptions_print(void *self) {LANTERN_CHECK_LOADED _lantern_TensorOptions_print(self); LANTERN_HOST_HANDLER }
  LANTERN_API void(LANTERN_PTR _lantern_TensorOptions_address)(void *self);
  HOST_API void lantern_TensorOptions_address(void *self) {LANTERN_CHECK_LOADED _lantern_TensorOptions_address(self); LANTERN_HOST_HANDLER }
  LANTERN_API void(LANTERN_PTR _lantern_Generator_delete)(void *x);
  HOST_API void lantern_Generator_delete(void *x) {LANTERN_CHECK_LOADED _lantern_Generator_delete(x); LANTERN_HOST_HANDLER }
  LANTERN_API void(LANTERN_PTR _lantern_Dimname_delete)(void *x);
  HOST_API void lantern_Dimname_delete(void *x) {LANTERN_CHECK_LOADED _lantern_Dimname_delete(x); LANTERN_HOST_HANDLER }
  LANTERN_API void(LANTERN_PTR _lantern_DimnameList_delete)(void *x);
  HOST_API void lantern_DimnameList_delete(void *x) {LANTERN_CHECK_LOADED _lantern_DimnameList_delete(x); LANTERN_HOST_HANDLER }
  LANTERN_API void(LANTERN_PTR _lantern_MemoryFormat_delete)(void *x);
  HOST_API void lantern_MemoryFormat_delete(void *x) {LANTERN_CHECK_LOADED _lantern_MemoryFormat_delete(x); LANTERN_HOST_HANDLER }
  LANTERN_API int64_t(LANTERN_PTR _lantern_Reduction_Sum)();
  HOST_API int64_t lantern_Reduction_Sum() {LANTERN_CHECK_LOADED int64_t ret = _lantern_Reduction_Sum(); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API int64_t(LANTERN_PTR _lantern_Reduction_None)();
  HOST_API int64_t lantern_Reduction_None() {LANTERN_CHECK_LOADED int64_t ret = _lantern_Reduction_None(); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API int64_t(LANTERN_PTR _lantern_Reduction_Mean)();
  HOST_API int64_t lantern_Reduction_Mean() {LANTERN_CHECK_LOADED int64_t ret = _lantern_Reduction_Mean(); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_double)(double x);
  HOST_API void * lantern_double(double x) {LANTERN_CHECK_LOADED void * ret = _lantern_double(x); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_Dtype_quint8)();
  HOST_API void * lantern_Dtype_quint8() {LANTERN_CHECK_LOADED void * ret = _lantern_Dtype_quint8(); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_Dtype_qint8)();
  HOST_API void * lantern_Dtype_qint8() {LANTERN_CHECK_LOADED void * ret = _lantern_Dtype_qint8(); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_Dtype_qint32)();
  HOST_API void * lantern_Dtype_qint32() {LANTERN_CHECK_LOADED void * ret = _lantern_Dtype_qint32(); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API bool(LANTERN_PTR _lantern_Tensor_is_quantized)(void *x);
  HOST_API bool lantern_Tensor_is_quantized(void *x) {LANTERN_CHECK_LOADED bool ret = _lantern_Tensor_is_quantized(x); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void(LANTERN_PTR _lantern_autograd_set_grad_mode)(bool enabled);
  HOST_API void lantern_autograd_set_grad_mode(bool enabled) {LANTERN_CHECK_LOADED _lantern_autograd_set_grad_mode(enabled); LANTERN_HOST_HANDLER }
  LANTERN_API void *(LANTERN_PTR _lantern_Tensor_undefined)();
  HOST_API void * lantern_Tensor_undefined() {LANTERN_CHECK_LOADED void * ret = _lantern_Tensor_undefined(); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_Tensor_grad)(void *self);
  HOST_API void * lantern_Tensor_grad(void *self) {LANTERN_CHECK_LOADED void * ret = _lantern_Tensor_grad(self); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API bool(LANTERN_PTR _lantern_Tensor_requires_grad)(void *self);
  HOST_API bool lantern_Tensor_requires_grad(void *self) {LANTERN_CHECK_LOADED bool ret = _lantern_Tensor_requires_grad(self); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API unsigned int(LANTERN_PTR _lantern_Tensor_register_hook)(void *self, void *hook);
  HOST_API unsigned int lantern_Tensor_register_hook(void *self, void *hook) {LANTERN_CHECK_LOADED unsigned int ret = _lantern_Tensor_register_hook(self, hook); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_new_hook)(void *(*fun)(void *, void *), void *custom);
  HOST_API void * lantern_new_hook(void *(*fun)(void *, void *), void *custom) {LANTERN_CHECK_LOADED void * ret = _lantern_new_hook(fun, custom); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void(LANTERN_PTR _lantern_Tensor_remove_hook)(void *self, unsigned int pos);
  HOST_API void lantern_Tensor_remove_hook(void *self, unsigned int pos) {LANTERN_CHECK_LOADED _lantern_Tensor_remove_hook(self, pos); LANTERN_HOST_HANDLER }
  LANTERN_API void *(LANTERN_PTR _lantern_variable_list_new)();
  HOST_API void * lantern_variable_list_new() {LANTERN_CHECK_LOADED void * ret = _lantern_variable_list_new(); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void(LANTERN_PTR _lantern_variable_list_push_back)(void *self, void *x);
  HOST_API void lantern_variable_list_push_back(void *self, void *x) {LANTERN_CHECK_LOADED _lantern_variable_list_push_back(self, x); LANTERN_HOST_HANDLER }
  LANTERN_API void *(LANTERN_PTR _lantern_variable_list_get)(void *self, int64_t i);
  HOST_API void * lantern_variable_list_get(void *self, int64_t i) {LANTERN_CHECK_LOADED void * ret = _lantern_variable_list_get(self, i); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void(LANTERN_PTR _lantern_variable_list_delete)(void *x);
  HOST_API void lantern_variable_list_delete(void *x) {LANTERN_CHECK_LOADED _lantern_variable_list_delete(x); LANTERN_HOST_HANDLER }
  LANTERN_API int64_t(LANTERN_PTR _lantern_variable_list_size)(void *self);
  HOST_API int64_t lantern_variable_list_size(void *self) {LANTERN_CHECK_LOADED int64_t ret = _lantern_variable_list_size(self); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_Function_lambda)(void *(*fun)(void *, void *, void *), void *custom, void (*delete_out)(void *), void *(*get_ptr)(void *));
  HOST_API void * lantern_Function_lambda(void *(*fun)(void *, void *, void *), void *custom, void (*delete_out)(void *), void *(*get_ptr)(void *)) {LANTERN_CHECK_LOADED void * ret = _lantern_Function_lambda(fun, custom, delete_out, get_ptr); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_Function_apply)(void *inputs, void *forward, void *backward);
  HOST_API void * lantern_Function_apply(void *inputs, void *forward, void *backward) {LANTERN_CHECK_LOADED void * ret = _lantern_Function_apply(inputs, forward, backward); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void(LANTERN_PTR _lantern_AutogradContext_save_for_backward)(void *self, void *vars);
  HOST_API void lantern_AutogradContext_save_for_backward(void *self, void *vars) {LANTERN_CHECK_LOADED _lantern_AutogradContext_save_for_backward(self, vars); LANTERN_HOST_HANDLER }
  LANTERN_API void *(LANTERN_PTR _lantern_AutogradContext_get_saved_variables)(void *self);
  HOST_API void * lantern_AutogradContext_get_saved_variables(void *self) {LANTERN_CHECK_LOADED void * ret = _lantern_AutogradContext_get_saved_variables(self); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_vector_string_new)();
  HOST_API void * lantern_vector_string_new() {LANTERN_CHECK_LOADED void * ret = _lantern_vector_string_new(); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void(LANTERN_PTR _lantern_vector_string_push_back)(void *self, const char *x);
  HOST_API void lantern_vector_string_push_back(void *self, const char *x) {LANTERN_CHECK_LOADED _lantern_vector_string_push_back(self, x); LANTERN_HOST_HANDLER }
  LANTERN_API int64_t(LANTERN_PTR _lantern_vector_string_size)(void *self);
  HOST_API int64_t lantern_vector_string_size(void *self) {LANTERN_CHECK_LOADED int64_t ret = _lantern_vector_string_size(self); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API const char *(LANTERN_PTR _lantern_vector_string_at)(void *self, int64_t i);
  HOST_API const char * lantern_vector_string_at(void *self, int64_t i) {LANTERN_CHECK_LOADED const char * ret = _lantern_vector_string_at(self, i); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_vector_bool_new)();
  HOST_API void * lantern_vector_bool_new() {LANTERN_CHECK_LOADED void * ret = _lantern_vector_bool_new(); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void(LANTERN_PTR _lantern_vector_bool_push_back)(void *self, bool x);
  HOST_API void lantern_vector_bool_push_back(void *self, bool x) {LANTERN_CHECK_LOADED _lantern_vector_bool_push_back(self, x); LANTERN_HOST_HANDLER }
  LANTERN_API int64_t(LANTERN_PTR _lantern_vector_bool_size)(void *self);
  HOST_API int64_t lantern_vector_bool_size(void *self) {LANTERN_CHECK_LOADED int64_t ret = _lantern_vector_bool_size(self); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API bool(LANTERN_PTR _lantern_vector_bool_at)(void *self, int64_t i);
  HOST_API bool lantern_vector_bool_at(void *self, int64_t i) {LANTERN_CHECK_LOADED bool ret = _lantern_vector_bool_at(self, i); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void(LANTERN_PTR _lantern_AutogradContext_set_arguments)(void *self, void *names, void *needs_grad);
  HOST_API void lantern_AutogradContext_set_arguments(void *self, void *names, void *needs_grad) {LANTERN_CHECK_LOADED _lantern_AutogradContext_set_arguments(self, names, needs_grad); LANTERN_HOST_HANDLER }
  LANTERN_API void *(LANTERN_PTR _lantern_AutogradContext_get_argument_names)(void *self);
  HOST_API void * lantern_AutogradContext_get_argument_names(void *self) {LANTERN_CHECK_LOADED void * ret = _lantern_AutogradContext_get_argument_names(self); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_AutogradContext_get_argument_needs_grad)(void *self);
  HOST_API void * lantern_AutogradContext_get_argument_needs_grad(void *self) {LANTERN_CHECK_LOADED void * ret = _lantern_AutogradContext_get_argument_needs_grad(self); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void(LANTERN_PTR _lantern_AutogradContext_set_saved_variables_names)(void *self, void *names);
  HOST_API void lantern_AutogradContext_set_saved_variables_names(void *self, void *names) {LANTERN_CHECK_LOADED _lantern_AutogradContext_set_saved_variables_names(self, names); LANTERN_HOST_HANDLER }
  LANTERN_API void *(LANTERN_PTR _lantern_AutogradContext_get_saved_variables_names)(void *self);
  HOST_API void * lantern_AutogradContext_get_saved_variables_names(void *self) {LANTERN_CHECK_LOADED void * ret = _lantern_AutogradContext_get_saved_variables_names(self); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void(LANTERN_PTR _lantern_AutogradContext_mark_dirty)(void *self, void *inputs);
  HOST_API void lantern_AutogradContext_mark_dirty(void *self, void *inputs) {LANTERN_CHECK_LOADED _lantern_AutogradContext_mark_dirty(self, inputs); LANTERN_HOST_HANDLER }
  LANTERN_API void(LANTERN_PTR _lantern_AutogradContext_mark_non_differentiable)(void *self, void *outputs);
  HOST_API void lantern_AutogradContext_mark_non_differentiable(void *self, void *outputs) {LANTERN_CHECK_LOADED _lantern_AutogradContext_mark_non_differentiable(self, outputs); LANTERN_HOST_HANDLER }
  LANTERN_API void(LANTERN_PTR _test_grad_fn)();
  HOST_API void test_grad_fn(double x, bool is_null) {LANTERN_CHECK_LOADED _test_grad_fn(); LANTERN_HOST_HANDLER }
  LANTERN_API void *(LANTERN_PTR _lantern_Tensor_grad_fn)(void *self);
  HOST_API void * lantern_Tensor_grad_fn(void *self) {LANTERN_CHECK_LOADED void * ret = _lantern_Tensor_grad_fn(self); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API const char *(LANTERN_PTR _lantern_Node_name)(void *self);
  HOST_API const char * lantern_Node_name(void *self) {LANTERN_CHECK_LOADED const char * ret = _lantern_Node_name(self); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_Node_next_edges)(void *self);
  HOST_API void * lantern_Node_next_edges(void *self) {LANTERN_CHECK_LOADED void * ret = _lantern_Node_next_edges(self); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API int64_t(LANTERN_PTR _lantern_edge_list_size)(void *self);
  HOST_API int64_t lantern_edge_list_size(void *self) {LANTERN_CHECK_LOADED int64_t ret = _lantern_edge_list_size(self); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_edge_list_at)(void *self, int64_t i);
  HOST_API void * lantern_edge_list_at(void *self, int64_t i) {LANTERN_CHECK_LOADED void * ret = _lantern_edge_list_at(self, i); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_Edge_function)(void *self);
  HOST_API void * lantern_Edge_function(void *self) {LANTERN_CHECK_LOADED void * ret = _lantern_Edge_function(self); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void(LANTERN_PTR _lantern_vector_int64_t_delete)(void *x);
  HOST_API void lantern_vector_int64_t_delete(void *x) {LANTERN_CHECK_LOADED _lantern_vector_int64_t_delete(x); LANTERN_HOST_HANDLER }
  LANTERN_API void(LANTERN_PTR _lantern_optional_vector_int64_t_delete)(void *x);
  HOST_API void lantern_optional_vector_int64_t_delete(void *x) {LANTERN_CHECK_LOADED _lantern_optional_vector_int64_t_delete(x); LANTERN_HOST_HANDLER }
  LANTERN_API void(LANTERN_PTR _lantern_autograd_backward)(void *tensors, void *grad_tensors, bool retain_graph, bool create_graph);
  HOST_API void lantern_autograd_backward(void *tensors, void *grad_tensors, bool retain_graph, bool create_graph) {LANTERN_CHECK_LOADED _lantern_autograd_backward(tensors, grad_tensors, retain_graph, create_graph); LANTERN_HOST_HANDLER }
  LANTERN_API void *(LANTERN_PTR _lantern_autograd_grad)(void *outputs, void *inputs, void *grad_outputs, bool retain_graph, bool create_graph, bool allow_unused);
  HOST_API void * lantern_autograd_grad(void *outputs, void *inputs, void *grad_outputs, bool retain_graph, bool create_graph, bool allow_unused) {LANTERN_CHECK_LOADED void * ret = _lantern_autograd_grad(outputs, inputs, grad_outputs, retain_graph, create_graph, allow_unused); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_Layout_strided)();
  HOST_API void * lantern_Layout_strided() {LANTERN_CHECK_LOADED void * ret = _lantern_Layout_strided(); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_Layout_sparse)();
  HOST_API void * lantern_Layout_sparse() {LANTERN_CHECK_LOADED void * ret = _lantern_Layout_sparse(); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API const char *(LANTERN_PTR _lantern_Layout_string)(void *x);
  HOST_API const char * lantern_Layout_string(void *x) {LANTERN_CHECK_LOADED const char * ret = _lantern_Layout_string(x); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_TensorIndex_new)();
  HOST_API void * lantern_TensorIndex_new() {LANTERN_CHECK_LOADED void * ret = _lantern_TensorIndex_new(); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void(LANTERN_PTR _lantern_TensorIndex_append_tensor)(void *self, void *x);
  HOST_API void lantern_TensorIndex_append_tensor(void *self, void *x) {LANTERN_CHECK_LOADED _lantern_TensorIndex_append_tensor(self, x); LANTERN_HOST_HANDLER }
  LANTERN_API void(LANTERN_PTR _lantern_TensorIndex_append_ellipsis)(void *self);
  HOST_API void lantern_TensorIndex_append_ellipsis(void *self) {LANTERN_CHECK_LOADED _lantern_TensorIndex_append_ellipsis(self); LANTERN_HOST_HANDLER }
  LANTERN_API void(LANTERN_PTR _lantern_TensorIndex_append_slice)(void *self, void *x);
  HOST_API void lantern_TensorIndex_append_slice(void *self, void *x) {LANTERN_CHECK_LOADED _lantern_TensorIndex_append_slice(self, x); LANTERN_HOST_HANDLER }
  LANTERN_API void(LANTERN_PTR _lantern_TensorIndex_append_none)(void *self);
  HOST_API void lantern_TensorIndex_append_none(void *self) {LANTERN_CHECK_LOADED _lantern_TensorIndex_append_none(self); LANTERN_HOST_HANDLER }
  LANTERN_API void(LANTERN_PTR _lantern_TensorIndex_append_bool)(void *self, bool x);
  HOST_API void lantern_TensorIndex_append_bool(void *self, bool x) {LANTERN_CHECK_LOADED _lantern_TensorIndex_append_bool(self, x); LANTERN_HOST_HANDLER }
  LANTERN_API void(LANTERN_PTR _lantern_TensorIndex_append_int64)(void *self, int64_t x);
  HOST_API void lantern_TensorIndex_append_int64(void *self, int64_t x) {LANTERN_CHECK_LOADED _lantern_TensorIndex_append_int64(self, x); LANTERN_HOST_HANDLER }
  LANTERN_API void *(LANTERN_PTR _lantern_Tensor_index)(void *self, void *index);
  HOST_API void * lantern_Tensor_index(void *self, void *index) {LANTERN_CHECK_LOADED void * ret = _lantern_Tensor_index(self, index); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void(LANTERN_PTR _lantern_TensorIndex_delete)(void *x);
  HOST_API void lantern_TensorIndex_delete(void *x) {LANTERN_CHECK_LOADED _lantern_TensorIndex_delete(x); LANTERN_HOST_HANDLER }
  LANTERN_API void *(LANTERN_PTR _lantern_Slice)(void *start, void *end, void *step);
  HOST_API void * lantern_Slice(void *start, void *end, void *step) {LANTERN_CHECK_LOADED void * ret = _lantern_Slice(start, end, step); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void(LANTERN_PTR _lantern_Slice_delete)(void *x);
  HOST_API void lantern_Slice_delete(void *x) {LANTERN_CHECK_LOADED _lantern_Slice_delete(x); LANTERN_HOST_HANDLER }
  LANTERN_API void *(LANTERN_PTR _lantern_Tensor_device)(void *self);
  HOST_API void * lantern_Tensor_device(void *self) {LANTERN_CHECK_LOADED void * ret = _lantern_Tensor_device(self); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API bool(LANTERN_PTR _lantern_cuda_is_available)();
  HOST_API bool lantern_cuda_is_available() {LANTERN_CHECK_LOADED bool ret = _lantern_cuda_is_available(); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API int(LANTERN_PTR _lantern_cuda_device_count)();
  HOST_API int lantern_cuda_device_count() {LANTERN_CHECK_LOADED int ret = _lantern_cuda_device_count(); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API int64_t(LANTERN_PTR _lantern_cuda_current_device)();
  HOST_API int64_t lantern_cuda_current_device() {LANTERN_CHECK_LOADED int64_t ret = _lantern_cuda_current_device(); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void(LANTERN_PTR _lantern_cuda_show_config)();
  HOST_API void lantern_cuda_show_config() {LANTERN_CHECK_LOADED _lantern_cuda_show_config(); LANTERN_HOST_HANDLER }
  LANTERN_API void *(LANTERN_PTR _lantern_nn_utils_rnn_pack_padded_sequence)(void *input, void *lengths, bool batch_first, bool enforce_sorted);
  HOST_API void * lantern_nn_utils_rnn_pack_padded_sequence(void *input, void *lengths, bool batch_first, bool enforce_sorted) {LANTERN_CHECK_LOADED void * ret = _lantern_nn_utils_rnn_pack_padded_sequence(input, lengths, batch_first, enforce_sorted); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void(LANTERN_PTR _lantern_PackedSequence_delete)(void *x);
  HOST_API void lantern_PackedSequence_delete(void *x) {LANTERN_CHECK_LOADED _lantern_PackedSequence_delete(x); LANTERN_HOST_HANDLER }
  LANTERN_API void *(LANTERN_PTR _lantern_nn_utils_PackedSequence_batch_sizes)(void *input);
  HOST_API void * lantern_nn_utils_PackedSequence_batch_sizes(void *input) {LANTERN_CHECK_LOADED void * ret = _lantern_nn_utils_PackedSequence_batch_sizes(input); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_nn_utils_PackedSequence_data)(void *input);
  HOST_API void * lantern_nn_utils_PackedSequence_data(void *input) {LANTERN_CHECK_LOADED void * ret = _lantern_nn_utils_PackedSequence_data(input); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_nn_utils_PackedSequence_sorted_indices)(void *input);
  HOST_API void * lantern_nn_utils_PackedSequence_sorted_indices(void *input) {LANTERN_CHECK_LOADED void * ret = _lantern_nn_utils_PackedSequence_sorted_indices(input); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_nn_utils_PackedSequence_unsorted_indices)(void *input);
  HOST_API void * lantern_nn_utils_PackedSequence_unsorted_indices(void *input) {LANTERN_CHECK_LOADED void * ret = _lantern_nn_utils_PackedSequence_unsorted_indices(input); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_nn_utils_rnn_pack_sequence)(void *sequence, bool enforce_sorted);
  HOST_API void * lantern_nn_utils_rnn_pack_sequence(void *sequence, bool enforce_sorted) {LANTERN_CHECK_LOADED void * ret = _lantern_nn_utils_rnn_pack_sequence(sequence, enforce_sorted); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_nn_utils_rnn_pad_packed_sequence)(void *sequence, bool batch_first, double padding_value, void *total_length);
  HOST_API void * lantern_nn_utils_rnn_pad_packed_sequence(void *sequence, bool batch_first, double padding_value, void *total_length) {LANTERN_CHECK_LOADED void * ret = _lantern_nn_utils_rnn_pad_packed_sequence(sequence, batch_first, padding_value, total_length); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_nn_utils_rnn_pad_sequence)(void *sequence, bool batch_first, double padding_value);
  HOST_API void * lantern_nn_utils_rnn_pad_sequence(void *sequence, bool batch_first, double padding_value) {LANTERN_CHECK_LOADED void * ret = _lantern_nn_utils_rnn_pad_sequence(sequence, batch_first, padding_value); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_nn_utils_rnn_PackedSequence_new)(void *data, void *batch_sizes, void *sorted_indices, void *unsorted_indices);
  HOST_API void * lantern_nn_utils_rnn_PackedSequence_new(void *data, void *batch_sizes, void *sorted_indices, void *unsorted_indices) {LANTERN_CHECK_LOADED void * ret = _lantern_nn_utils_rnn_PackedSequence_new(data, batch_sizes, sorted_indices, unsorted_indices); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_Scalar_dtype)(void *self);
  HOST_API void * lantern_Scalar_dtype(void *self) {LANTERN_CHECK_LOADED void * ret = _lantern_Scalar_dtype(self); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API float(LANTERN_PTR _lantern_Scalar_to_float)(void *self);
  HOST_API float lantern_Scalar_to_float(void *self) {LANTERN_CHECK_LOADED float ret = _lantern_Scalar_to_float(self); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API int(LANTERN_PTR _lantern_Scalar_to_int)(void *self);
  HOST_API int lantern_Scalar_to_int(void *self) {LANTERN_CHECK_LOADED int ret = _lantern_Scalar_to_int(self); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API double(LANTERN_PTR _lantern_Scalar_to_double)(void *self);
  HOST_API double lantern_Scalar_to_double(void *self) {LANTERN_CHECK_LOADED double ret = _lantern_Scalar_to_double(self); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API bool(LANTERN_PTR _lantern_Scalar_to_bool)(void *self);
  HOST_API bool lantern_Scalar_to_bool(void *self) {LANTERN_CHECK_LOADED bool ret = _lantern_Scalar_to_bool(self); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API bool(LANTERN_PTR _lantern_Tensor_is_undefined)(void *self);
  HOST_API bool lantern_Tensor_is_undefined(void *self) {LANTERN_CHECK_LOADED bool ret = _lantern_Tensor_is_undefined(self); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void(LANTERN_PTR _lantern_set_default_dtype)(void *dtype);
  HOST_API void lantern_set_default_dtype(void *dtype) {LANTERN_CHECK_LOADED _lantern_set_default_dtype(dtype); LANTERN_HOST_HANDLER }
  LANTERN_API void *(LANTERN_PTR _lantern_get_default_dtype)();
  HOST_API void * lantern_get_default_dtype() {LANTERN_CHECK_LOADED void * ret = _lantern_get_default_dtype(); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void (LANTERN_PTR _lantern_Tensor_set_grad_)(void* self, void* new_grad);
  HOST_API void lantern_Tensor_set_grad_(void* self, void* new_grad) {LANTERN_CHECK_LOADED _lantern_Tensor_set_grad_(self, new_grad); LANTERN_HOST_HANDLER }
  LANTERN_API void *(LANTERN_PTR _lantern_Tensor_storage)(void *self);
  HOST_API void * lantern_Tensor_storage(void *self) {LANTERN_CHECK_LOADED void * ret = _lantern_Tensor_storage(self); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API bool(LANTERN_PTR _lantern_Tensor_has_storage)(void *self);
  HOST_API bool lantern_Tensor_has_storage(void *self) {LANTERN_CHECK_LOADED bool ret = _lantern_Tensor_has_storage(self); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void *(LANTERN_PTR _lantern_Storage_data_ptr)(void *self);
  HOST_API void * lantern_Storage_data_ptr(void *self) {LANTERN_CHECK_LOADED void * ret = _lantern_Storage_data_ptr(self); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void(LANTERN_PTR _lantern_Storage_delete)(void *x);
  HOST_API void lantern_Storage_delete(void *x) {LANTERN_CHECK_LOADED _lantern_Storage_delete(x); LANTERN_HOST_HANDLER }
  LANTERN_API bool(LANTERN_PTR _lantern_Tensor_is_contiguous)(void *self);
  HOST_API bool lantern_Tensor_is_contiguous(void *self) {LANTERN_CHECK_LOADED bool ret = _lantern_Tensor_is_contiguous(self); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void* (LANTERN_PTR _lantern_tensor_save) (void* self, bool base64);
  HOST_API void* lantern_tensor_save(void* self, bool base64) {LANTERN_CHECK_LOADED void* ret = _lantern_tensor_save(self, base64); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void * (LANTERN_PTR _lantern_tensor_load) (void * s, void* device, bool base64);
  HOST_API void * lantern_tensor_load(void * s, void* device, bool base64) {LANTERN_CHECK_LOADED void * ret = _lantern_tensor_load(s, device, base64); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void * (LANTERN_PTR _lantern_test_tensor)();
  HOST_API void * lantern_test_tensor() {LANTERN_CHECK_LOADED void * ret = _lantern_test_tensor(); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void (LANTERN_PTR _lantern_test_print)(void* x); 
  HOST_API void lantern_test_print(void* x) {LANTERN_CHECK_LOADED _lantern_test_print(x); LANTERN_HOST_HANDLER }
  LANTERN_API size_t (LANTERN_PTR _lantern_tensor_serialized_size) (const char * s);
  HOST_API size_t lantern_tensor_serialized_size(const char * s) {LANTERN_CHECK_LOADED size_t ret = _lantern_tensor_serialized_size(s); LANTERN_HOST_HANDLER return ret;}
  LANTERN_API void (LANTERN_PTR _lantern_const_char_delete) (const char * x);
  HOST_API void lantern_const_char_delete(const char * x) {LANTERN_CHECK_LOADED _lantern_const_char_delete(x); LANTERN_HOST_HANDLER}  
  LANTERN_API void (LANTERN_PTR _lantern_Tensor_index_put_tensor_) (void* self, void* index, void* rhs);
  HOST_API void lantern_Tensor_index_put_tensor_ (void* self, void* index, void* rhs) {LANTERN_CHECK_LOADED _lantern_Tensor_index_put_tensor_(self, index, rhs); LANTERN_HOST_HANDLER}
  LANTERN_API void (LANTERN_PTR _lantern_Tensor_index_put_scalar_) (void* self, void* index, void* rhs);
  HOST_API void lantern_Tensor_index_put_scalar_ (void* self, void* index, void* rhs) {LANTERN_CHECK_LOADED _lantern_Tensor_index_put_scalar_(self, index, rhs); LANTERN_HOST_HANDLER}
  LANTERN_API void (LANTERN_PTR _lantern_manual_seed) (int64_t seed);
  HOST_API void lantern_manual_seed (int64_t seed) {LANTERN_CHECK_LOADED _lantern_manual_seed(seed); LANTERN_HOST_HANDLER}

  LANTERN_API void* (LANTERN_PTR _lantern_load_state_dict) (const char * path);
  HOST_API void * lantern_load_state_dict (const char * path)
  {
    LANTERN_CHECK_LOADED
    void * ret = _lantern_load_state_dict(path);
    LANTERN_HOST_HANDLER return ret;
  }

  LANTERN_API void* (LANTERN_PTR _lantern_get_state_dict_keys) (void * ivalue);
  HOST_API void* lantern_get_state_dict_keys (void* ivalue)
  {
    LANTERN_CHECK_LOADED
    void * ret = _lantern_get_state_dict_keys(ivalue);
    LANTERN_HOST_HANDLER return ret;
  }

  LANTERN_API void* (LANTERN_PTR _lantern_get_state_dict_values) (void * ivalue);
  HOST_API void* lantern_get_state_dict_values (void* ivalue)
  {
    LANTERN_CHECK_LOADED
    void * ret = _lantern_get_state_dict_values(ivalue);
    LANTERN_HOST_HANDLER return ret;
  }

  LANTERN_API void (LANTERN_PTR _lantern_IValue_delete) (void * x);
  HOST_API void lantern_IValue_delete (void* x)
  {
    LANTERN_CHECK_LOADED
    _lantern_IValue_delete(x);
    LANTERN_HOST_HANDLER;
  }

  LANTERN_API void (LANTERN_PTR _lantern_vector_string_delete) (void * x);
  HOST_API void lantern_vector_string_delete (void* x)
  {
    LANTERN_CHECK_LOADED
    _lantern_vector_string_delete(x);
    LANTERN_HOST_HANDLER;
  }

  LANTERN_API int64_t *(LANTERN_PTR _lantern_Tensor_data_ptr_int64_t)(void *self);
  HOST_API int64_t* lantern_Tensor_data_ptr_int64_t (void* self)
  {
    LANTERN_CHECK_LOADED
    int64_t* ret = _lantern_Tensor_data_ptr_int64_t(self);
    LANTERN_HOST_HANDLER;
    return ret;
  }

  LANTERN_API bool  (LANTERN_PTR _lantern_Tensor_has_names) (void* self);
  HOST_API bool lantern_Tensor_has_names (void* self)
  {
    LANTERN_CHECK_LOADED
    bool ret = _lantern_Tensor_has_names(self);
    LANTERN_HOST_HANDLER;
    return ret;
  }

  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_names) (void * self);
  HOST_API void* lantern_Tensor_names (void* self)
  {
    LANTERN_CHECK_LOADED
    void* ret = _lantern_Tensor_names(self);
    LANTERN_HOST_HANDLER;
    return ret;
  }

  LANTERN_API void* (LANTERN_PTR _lantern_string_new) (const char * value, int size);
  HOST_API void* lantern_string_new (const char* value, int size)
  {
    LANTERN_CHECK_LOADED
    void* ret = _lantern_string_new(value, size);
    LANTERN_HOST_HANDLER;
    return ret;
  }

  LANTERN_API void* (LANTERN_PTR _lantern_string_view_new) (const char * value);
  HOST_API void* lantern_string_view_new (const char* value)
  {
    LANTERN_CHECK_LOADED
    void* ret = _lantern_string_view_new(value);
    LANTERN_HOST_HANDLER;
    return ret;
  }

  LANTERN_API void (LANTERN_PTR _lantern_string_delete) (void * x);
  HOST_API void lantern_string_delete (void* x)
  {
    LANTERN_CHECK_LOADED
    _lantern_string_delete(x);
    LANTERN_HOST_HANDLER;
  }

  LANTERN_API void (LANTERN_PTR _lantern_string_view_delete) (void * x);
  HOST_API void lantern_string_view_delete (void* x)
  {
    LANTERN_CHECK_LOADED
    _lantern_string_view_delete(x);
    LANTERN_HOST_HANDLER;
  }

  LANTERN_API void * (LANTERN_PTR _lantern_contrib_torch_sparsemax) (void * input, int dim);
  HOST_API void * lantern_contrib_torch_sparsemax (void* input, int dim)
  {
    LANTERN_CHECK_LOADED
    void * ret = _lantern_contrib_torch_sparsemax(input, dim);
    LANTERN_HOST_HANDLER;
    return ret;
  }

LANTERN_API void (LANTERN_PTR _lantern_set_num_threads) (int n);
HOST_API void lantern_set_num_threads (int n)
{
  LANTERN_CHECK_LOADED
  _lantern_set_num_threads(n);
  LANTERN_HOST_HANDLER;
}

LANTERN_API void (LANTERN_PTR _lantern_set_num_interop_threads) (int n);
HOST_API void lantern_set_num_interop_threads (int n)
{
  LANTERN_CHECK_LOADED
  _lantern_set_num_interop_threads(n);
  LANTERN_HOST_HANDLER;
}

LANTERN_API int (LANTERN_PTR _lantern_get_num_threads) ();
HOST_API int lantern_get_num_threads ()
{
  LANTERN_CHECK_LOADED
  int ret = _lantern_get_num_threads();
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API int (LANTERN_PTR _lantern_get_num_interop_threads) ();
HOST_API int lantern_get_num_interop_threads ()
{
  LANTERN_CHECK_LOADED
  int ret = _lantern_get_num_interop_threads();
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void * (LANTERN_PTR _lantern_optional_vector_int64_t) (int64_t * x, size_t x_size, bool is_null);
HOST_API void* lantern_optional_vector_int64_t (int64_t * x, size_t x_size, bool is_null)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_optional_vector_int64_t(x, x_size, is_null);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void * (LANTERN_PTR _lantern_optional_vector_double) (double * x, size_t x_size, bool is_null);
HOST_API void* lantern_optional_vector_double (double * x, size_t x_size, bool is_null)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_optional_vector_double(x, x_size, is_null);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void (LANTERN_PTR _trace_r_nn_module) ();
HOST_API void trace_r_nn_module ()
{
  LANTERN_CHECK_LOADED
  _trace_r_nn_module();
  LANTERN_HOST_HANDLER;
}

LANTERN_API void * (LANTERN_PTR _lantern_Stack_new) ();
HOST_API void * lantern_Stack_new ()
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_Stack_new();
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void (LANTERN_PTR _lantern_Stack_delete) (void * x);
HOST_API void lantern_Stack_delete (void * x)
{
  LANTERN_CHECK_LOADED
  _lantern_Stack_delete(x);
  LANTERN_HOST_HANDLER;
}

LANTERN_API int64_t (LANTERN_PTR _lantern_Stack_size) (void* self);
HOST_API int64_t lantern_Stack_size (void* self)
{
  LANTERN_CHECK_LOADED
  int64_t ret = _lantern_Stack_size(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_create_traceable_fun) (void *(*r_caller)(void *, void *), void* fn);
HOST_API void* lantern_create_traceable_fun (void *(*r_caller)(void *, void *), void* fn)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_create_traceable_fun(r_caller, fn);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_trace_fn) (void* fn, void* inputs, void* compilation_unit, bool strict, void* module, void* name, bool should_mangle);
HOST_API void* lantern_trace_fn (void* fn, void* inputs, void* compilation_unit, bool strict, void* module, void* name, bool should_mangle)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_trace_fn(fn, inputs, compilation_unit, strict, module, name, should_mangle);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_call_traced_fn) (void* fn, void* inputs);
HOST_API void* lantern_call_traced_fn(void* fn, void* inputs)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_call_traced_fn(fn, inputs);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_CompilationUnit_new) ();
HOST_API void* lantern_CompilationUnit_new ()
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_CompilationUnit_new();
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void (LANTERN_PTR _lantern_CompilationUnit_delete) (void* x);
HOST_API void lantern_CompilationUnit_delete (void* x)
{
  LANTERN_CHECK_LOADED
  _lantern_CompilationUnit_delete(x);
  LANTERN_HOST_HANDLER;
}

LANTERN_API void (LANTERN_PTR _lantern_traced_fn_save) (void* fn, const char * filename);
HOST_API void lantern_traced_fn_save (void* fn, const char * filename)
{
  LANTERN_CHECK_LOADED
  _lantern_traced_fn_save(fn, filename);
  LANTERN_HOST_HANDLER;
}

LANTERN_API void (LANTERN_PTR _lantern_traced_fn_save_for_mobile) (void* fn, const char * filename);
HOST_API void lantern_traced_fn_save_for_mobile (void* fn, const char * filename)
{
  _lantern_traced_fn_save_for_mobile(fn, filename);
  LANTERN_HOST_HANDLER;
}

LANTERN_API const char * (LANTERN_PTR _lantern_traced_fn_graph_print) (void* fn);
HOST_API const char * lantern_traced_fn_graph_print (void* fn)
{
  LANTERN_CHECK_LOADED
  const char * ret = _lantern_traced_fn_graph_print(fn);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API bool (LANTERN_PTR _lantern_Tensor_has_any_zeros) (void * self);
HOST_API bool lantern_Tensor_has_any_zeros (void* self)
{
  LANTERN_CHECK_LOADED
  bool ret = _lantern_Tensor_has_any_zeros(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_jit_load) (const char * path);
HOST_API void* lantern_jit_load (const char * path)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_jit_load(path);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_call_jit_script) (void* module, void* inputs);
HOST_API void* lantern_call_jit_script (void* module, void* inputs)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_call_jit_script(module, inputs);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void (LANTERN_PTR _lantern_JITModule_delete) (void* x);
HOST_API void lantern_JITModule_delete (void* x)
{
  LANTERN_CHECK_LOADED
  _lantern_JITModule_delete(x);
  LANTERN_HOST_HANDLER;
}

LANTERN_API void (LANTERN_PTR _lantern_TraceableFunction_delete) (void* x);
HOST_API void lantern_TraceableFunction_delete (void* x)
{
  LANTERN_CHECK_LOADED
  _lantern_TraceableFunction_delete(x);
  LANTERN_HOST_HANDLER;
}

LANTERN_API void (LANTERN_PTR _set_lantern_allocator) (void (*r_gc) (bool), uint64_t threshold_mb);
HOST_API void set_lantern_allocator (void (*r_gc) (bool), uint64_t threshold_mb)
{
  LANTERN_CHECK_LOADED
  _set_lantern_allocator(r_gc, threshold_mb);
  LANTERN_HOST_HANDLER;
}

LANTERN_API void (LANTERN_PTR _lantern_vector_bool_delete) (void* x);
HOST_API void lantern_vector_bool_delete (void* x)
{
  LANTERN_CHECK_LOADED
  _lantern_vector_bool_delete(x);
  LANTERN_HOST_HANDLER;
}

LANTERN_API void* (LANTERN_PTR _lantern_normal_double_double_intarrayref_generator_tensoroptions) (double mean, double std, void* size, void* generator, void* options);
HOST_API void* lantern_normal_double_double_intarrayref_generator_tensoroptions (double mean, double std, void* size, void* generator, void* options) 
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_normal_double_double_intarrayref_generator_tensoroptions(mean, std, size, generator, options);
  LANTERN_HOST_HANDLER 
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_normal_tensor_tensor_generator) (void* mean, void* std, void* generator);
HOST_API void* lantern_normal_tensor_tensor_generator (void* mean, void* std, void* generator)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_normal_tensor_tensor_generator(mean, std, generator);
  LANTERN_HOST_HANDLER 
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_normal_double_tensor_generator) (double mean, void* std, void* generator);
HOST_API void* lantern_normal_double_tensor_generator (double mean, void* std, void* generator)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_normal_double_tensor_generator(mean, std, generator);
  LANTERN_HOST_HANDLER 
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_normal_tensor_double_generator) (void* mean, double std, void* generator);
HOST_API void* lantern_normal_tensor_double_generator (void* mean, double std, void* generator)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_normal_tensor_double_generator(mean, std, generator);
  LANTERN_HOST_HANDLER 
  return ret;
}

LANTERN_API void (LANTERN_PTR _lantern_vector_void_delete) (void* x);
HOST_API void lantern_vector_void_delete (void* x)
{
  LANTERN_CHECK_LOADED
  _lantern_vector_void_delete(x);
  LANTERN_HOST_HANDLER;
}

LANTERN_API bool (LANTERN_PTR _lantern_autograd_is_enabled) ();
HOST_API bool lantern_autograd_is_enabled ()
{
  LANTERN_CHECK_LOADED
  bool ret = _lantern_autograd_is_enabled();
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void (LANTERN_PTR _lantern_print_stuff) (void* x);
HOST_API void lantern_print_stuff (void* x) {
  LANTERN_CHECK_LOADED
  _lantern_print_stuff (x);
  LANTERN_HOST_HANDLER;
}

LANTERN_API void* (LANTERN_PTR _lantern_nn_functional_pad_circular) (void* input, void* padding);
HOST_API void* lantern_nn_functional_pad_circular (void* input, void* padding)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_nn_functional_pad_circular(input, padding);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API bool (LANTERN_PTR _lantern_backend_has_mkl) ();
HOST_API bool lantern_backend_has_mkl ()
{
  LANTERN_CHECK_LOADED
  bool ret = _lantern_backend_has_mkl();
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API bool (LANTERN_PTR _lantern_backend_has_openmp) ();
HOST_API bool lantern_backend_has_openmp ()
{
  LANTERN_CHECK_LOADED
  bool ret = _lantern_backend_has_openmp();
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API bool (LANTERN_PTR _lantern_backend_has_lapack) ();
HOST_API bool lantern_backend_has_lapack ()
{
  LANTERN_CHECK_LOADED
  bool ret = _lantern_backend_has_lapack();
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API bool (LANTERN_PTR _lantern_backend_has_mkldnn) ();
HOST_API bool lantern_backend_has_mkldnn ()
{
  LANTERN_CHECK_LOADED
  bool ret = _lantern_backend_has_mkldnn();
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_OptionalTensorList) ();
HOST_API void* lantern_OptionalTensorList ()
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_OptionalTensorList();
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void (LANTERN_PTR _lantern_OptionalTensorList_push_back) (void* self, void* x, bool is_null);
HOST_API void lantern_OptionalTensorList_push_back (void* self, void* x, bool is_null)
{
  LANTERN_CHECK_LOADED
  _lantern_OptionalTensorList_push_back(self, x, is_null);
  LANTERN_HOST_HANDLER;
}

LANTERN_API void* (LANTERN_PTR _lantern_Stream) ();
HOST_API void* lantern_Stream ()
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_Stream();
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void (LANTERN_PTR _lantern_tensor_set_pyobj) (void*x, void* ptr);
HOST_API void lantern_tensor_set_pyobj (void* x, void* ptr)
{
  LANTERN_CHECK_LOADED
  _lantern_tensor_set_pyobj(x, ptr);
  LANTERN_HOST_HANDLER;
}

LANTERN_API void* (LANTERN_PTR _lantern_tensor_get_pyobj) (void* x);
HOST_API void* lantern_tensor_get_pyobj (void* x)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_tensor_get_pyobj(x);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_ScriptModule_parameters) (void* module, bool recurse);
HOST_API void* lantern_ScriptModule_parameters (void* module, bool recurse)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_ScriptModule_parameters(module, recurse);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void (LANTERN_PTR _lantern_jit_named_parameter_list_delete) (void* x);
HOST_API void lantern_jit_named_parameter_list_delete (void* x)
{
  LANTERN_CHECK_LOADED
  _lantern_jit_named_parameter_list_delete(x);
  LANTERN_HOST_HANDLER;
}

LANTERN_API int (LANTERN_PTR _lantern_jit_named_parameter_list_size) (void* self);
HOST_API int lantern_jit_named_parameter_list_size (void* module)
{
  LANTERN_CHECK_LOADED
  int ret = _lantern_jit_named_parameter_list_size(module);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_jit_named_parameter_list_tensors) (void* self);
HOST_API void* lantern_jit_named_parameter_list_tensors (void* module)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_jit_named_parameter_list_tensors(module);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_jit_named_parameter_list_names) (void* self);
HOST_API void* lantern_jit_named_parameter_list_names (void* module)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_jit_named_parameter_list_names(module);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_ScriptModule_forward) (void* module, void* inputs);
HOST_API void* lantern_ScriptModule_forward (void* module, void* inputs)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_ScriptModule_forward(module, inputs);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void (LANTERN_PTR _lantern_ScriptModule_train) (void* module, bool on);
HOST_API void lantern_ScriptModule_train (void* module, bool on)
{
  LANTERN_CHECK_LOADED
   _lantern_ScriptModule_train(module, on);
  LANTERN_HOST_HANDLER;
  
}

LANTERN_API void (LANTERN_PTR _lantern_ScriptModule_to) (void* module, void* device, bool non_blocking);
HOST_API void lantern_ScriptModule_to (void* module, void* device, bool non_blocking)
{
  LANTERN_CHECK_LOADED
   _lantern_ScriptModule_to(module, device, non_blocking);
  LANTERN_HOST_HANDLER;
}

LANTERN_API void (LANTERN_PTR _lantern_ScriptModule_set_optimized) (void* module, bool o);
HOST_API void lantern_ScriptModule_set_optimized (void* module, bool o)
{
  LANTERN_CHECK_LOADED
   _lantern_ScriptModule_set_optimized(module, o);
  LANTERN_HOST_HANDLER;
  
}

LANTERN_API bool (LANTERN_PTR _lantern_ScriptModule_is_training) (void* module);
HOST_API bool lantern_ScriptModule_is_training (void* module)
{
  LANTERN_CHECK_LOADED
  bool ret = _lantern_ScriptModule_is_training(module);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API bool (LANTERN_PTR _lantern_ScriptModule_is_optimized) (void* module);
HOST_API bool lantern_ScriptModule_is_optimized (void* module)
{
  LANTERN_CHECK_LOADED
  bool ret = _lantern_ScriptModule_is_optimized(module);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_ScriptModule_modules) (void* module);
HOST_API void* lantern_ScriptModule_modules (void* module)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_ScriptModule_modules(module);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API int (LANTERN_PTR _lantern_jit_named_module_list_size) (void* self);
HOST_API int lantern_jit_named_module_list_size (void* self)
{
  LANTERN_CHECK_LOADED
  int ret = _lantern_jit_named_module_list_size(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_jit_named_module_list_module_at) (void* self, int64_t index);
HOST_API void* lantern_jit_named_module_list_module_at (void* self, int64_t index)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_jit_named_module_list_module_at(self, index);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_jit_named_module_list_names) (void* self);
HOST_API void* lantern_jit_named_module_list_names (void* self)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_jit_named_module_list_names(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void (LANTERN_PTR _lantern_jit_named_module_list_delete) (void* x);
HOST_API void lantern_jit_named_module_list_delete (void* x)
{
  LANTERN_CHECK_LOADED
   _lantern_jit_named_module_list_delete(x);
  LANTERN_HOST_HANDLER;
  
}

LANTERN_API void (LANTERN_PTR _lantern_ScriptModule_register_parameter) (void* module, void* name, void* v, bool is_buffer);
HOST_API void lantern_ScriptModule_register_parameter (void* module, void* name, void* v, bool is_buffer)
{
  LANTERN_CHECK_LOADED
   _lantern_ScriptModule_register_parameter(module, name, v, is_buffer);
  LANTERN_HOST_HANDLER;
  
}

LANTERN_API void (LANTERN_PTR _lantern_ScriptModule_register_buffer) (void* module, void* name, void* v);
HOST_API void lantern_ScriptModule_register_buffer (void* module, void* name, void* v)
{
  LANTERN_CHECK_LOADED
   _lantern_ScriptModule_register_buffer(module, name, v);
  LANTERN_HOST_HANDLER;
  
}

LANTERN_API void (LANTERN_PTR _lantern_ScriptModule_register_module) (void* self, void* name, void* module);
HOST_API void lantern_ScriptModule_register_module (void* self, void* name, void* module)
{
  LANTERN_CHECK_LOADED
   _lantern_ScriptModule_register_module(self, name, module);
  LANTERN_HOST_HANDLER;
  
}

LANTERN_API void (LANTERN_PTR _lantern_ScriptModule_register_attribute) (void* module, void* name, void* t, void* v, bool is_param, bool is_buffer);
HOST_API void lantern_ScriptModule_register_attribute (void* module, void* name, void* t, void* v, bool is_param, bool is_buffer)
{
  LANTERN_CHECK_LOADED
   _lantern_ScriptModule_register_attribute(module, name, t, v, is_param, is_buffer);
  LANTERN_HOST_HANDLER;
  
}

LANTERN_API void* (LANTERN_PTR _lantern_jit_named_buffer_list_names) (void* self);
HOST_API void* lantern_jit_named_buffer_list_names (void* self)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_jit_named_buffer_list_names(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_jit_named_buffer_list_tensors) (void* self);
HOST_API void* lantern_jit_named_buffer_list_tensors (void* self)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_jit_named_buffer_list_tensors(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API int (LANTERN_PTR _lantern_jit_named_buffer_list_size) (void* self);
HOST_API int lantern_jit_named_buffer_list_size (void* self)
{
  LANTERN_CHECK_LOADED
  int ret = _lantern_jit_named_buffer_list_size(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_ScriptModule_buffers) (void* module, bool recurse);
HOST_API void* lantern_ScriptModule_buffers (void* module, bool recurse)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_ScriptModule_buffers(module, recurse);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void (LANTERN_PTR _lantern_jit_named_buffer_list_delete) (void* x);
HOST_API void lantern_jit_named_buffer_list_delete (void* x)
{
  LANTERN_CHECK_LOADED
   _lantern_jit_named_buffer_list_delete(x);
  LANTERN_HOST_HANDLER;
  
}

LANTERN_API void* (LANTERN_PTR _lantern_ScriptModule_children) (void* module);
HOST_API void* lantern_ScriptModule_children (void* module)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_ScriptModule_children(module);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void (LANTERN_PTR _lantern_jit_ScriptMethod_delete) (void* x);
HOST_API void lantern_jit_ScriptMethod_delete (void* x)
{
  LANTERN_CHECK_LOADED
   _lantern_jit_ScriptMethod_delete(x);
  LANTERN_HOST_HANDLER;
  
}

LANTERN_API void* (LANTERN_PTR _lantern_ScriptModule_find_method) (void* self, void* basename);
HOST_API void* lantern_ScriptModule_find_method (void* self, void* basename)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_ScriptModule_find_method(self, basename);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_ScriptMethod_call) (void* self, void* inputs);
HOST_API void* lantern_ScriptMethod_call (void* self, void* inputs)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_ScriptMethod_call(self, inputs);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API int (LANTERN_PTR _lantern_IValue_type) (void* self);
HOST_API int lantern_IValue_type (void* self)
{
  LANTERN_CHECK_LOADED
  int ret = _lantern_IValue_type(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API bool (LANTERN_PTR _lantern_IValue_Bool) (void * self);
HOST_API bool lantern_IValue_Bool (void * self)
{
  LANTERN_CHECK_LOADED
  bool ret = _lantern_IValue_Bool(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_IValue_BoolList) (void* self);
HOST_API void* lantern_IValue_BoolList (void* self)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_IValue_BoolList(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_IValue_Device) (void* self);
HOST_API void* lantern_IValue_Device (void* self)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_IValue_Device(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API double (LANTERN_PTR _lantern_IValue_Double) (void* self);
HOST_API double lantern_IValue_Double (void* self)
{
  LANTERN_CHECK_LOADED
  double ret = _lantern_IValue_Double(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_IValue_DoubleList) (void* self);
HOST_API void* lantern_IValue_DoubleList (void* self)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_IValue_DoubleList(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_IValue_Generator) (void* self);
HOST_API void* lantern_IValue_Generator (void* self)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_IValue_Generator(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_IValue_GenericDict) (void* self);
HOST_API void* lantern_IValue_GenericDict (void* self)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_IValue_GenericDict(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API int64_t (LANTERN_PTR _lantern_IValue_Int) (void* self);
HOST_API int64_t lantern_IValue_Int (void* self)
{
  LANTERN_CHECK_LOADED
  int64_t ret = _lantern_IValue_Int(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_IValue_IntList) (void* self);
HOST_API void* lantern_IValue_IntList (void* self)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_IValue_IntList(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_IValue_List) (void* self);
HOST_API void* lantern_IValue_List (void* self)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_IValue_List(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_IValue_Module) (void* self);
HOST_API void* lantern_IValue_Module (void* self)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_IValue_Module(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_IValue_Scalar) (void* self);
HOST_API void* lantern_IValue_Scalar (void* self)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_IValue_Scalar(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_IValue_String) (void* self);
HOST_API void* lantern_IValue_String (void* self)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_IValue_String(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_IValue_Tensor) (void* self);
HOST_API void* lantern_IValue_Tensor (void* self)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_IValue_Tensor(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_IValue_TensorList) (void* self);
HOST_API void* lantern_IValue_TensorList (void* self)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_IValue_TensorList(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_IValue_Tuple) (void* self);
HOST_API void* lantern_IValue_Tuple (void* self)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_IValue_Tuple(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void (LANTERN_PTR _lantern_GenericDict_delete) (void* x);
HOST_API void lantern_GenericDict_delete (void* x)
{
  LANTERN_CHECK_LOADED
   _lantern_GenericDict_delete(x);
  LANTERN_HOST_HANDLER;
  
}

LANTERN_API void (LANTERN_PTR _lantern_GenericList_delete) (void* x);
HOST_API void lantern_GenericList_delete (void* x)
{
  LANTERN_CHECK_LOADED
   _lantern_GenericList_delete(x);
  LANTERN_HOST_HANDLER;
  
}

LANTERN_API void* (LANTERN_PTR _lantern_Stack_at) (void* self, int64_t index);
HOST_API void* lantern_Stack_at (void* self, int64_t index)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_Stack_at(self, index);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_IValue_from_Bool) (bool self);
HOST_API void* lantern_IValue_from_Bool (bool self)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_IValue_from_Bool(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_IValue_from_BoolList) (void* self);
HOST_API void* lantern_IValue_from_BoolList (void* self)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_IValue_from_BoolList(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_IValue_from_Device) (void* self);
HOST_API void* lantern_IValue_from_Device (void* self)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_IValue_from_Device(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_IValue_from_Double) (double self);
HOST_API void* lantern_IValue_from_Double (double self)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_IValue_from_Double(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_IValue_from_DoubleList) (void* self);
HOST_API void* lantern_IValue_from_DoubleList (void* self)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_IValue_from_DoubleList(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_IValue_from_Generator) (void* self);
HOST_API void* lantern_IValue_from_Generator (void* self)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_IValue_from_Generator(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_IValue_from_GenericDict) (void* self);
HOST_API void* lantern_IValue_from_GenericDict (void* self)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_IValue_from_GenericDict(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_IValue_from_Int) (int64_t self);
HOST_API void* lantern_IValue_from_Int (int64_t self)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_IValue_from_Int(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_IValue_from_IntList) (void* self);
HOST_API void* lantern_IValue_from_IntList (void* self)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_IValue_from_IntList(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_IValue_from_List) (void* self);
HOST_API void* lantern_IValue_from_List (void* self)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_IValue_from_List(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_IValue_from_Module) (void* self);
HOST_API void* lantern_IValue_from_Module (void* self)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_IValue_from_Module(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_IValue_from_Scalar) (void* self);
HOST_API void* lantern_IValue_from_Scalar (void* self)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_IValue_from_Scalar(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_IValue_from_String) (void* self);
HOST_API void* lantern_IValue_from_String (void* self)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_IValue_from_String(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_IValue_from_Tensor) (void* self);
HOST_API void* lantern_IValue_from_Tensor (void* self)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_IValue_from_Tensor(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_IValue_from_TensorList) (void* self);
HOST_API void* lantern_IValue_from_TensorList (void* self)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_IValue_from_TensorList(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API int64_t (LANTERN_PTR _lantern_vector_int64_t_size) (void* self);
HOST_API int64_t lantern_vector_int64_t_size (void* self)
{
  LANTERN_CHECK_LOADED
  int64_t ret = _lantern_vector_int64_t_size(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API int64_t (LANTERN_PTR _lantern_vector_int64_t_at) (void* self, int64_t index);
HOST_API int64_t lantern_vector_int64_t_at (void* self, int64_t index)
{
  LANTERN_CHECK_LOADED
  int64_t ret = _lantern_vector_int64_t_at(self, index);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API double (LANTERN_PTR _lantern_vector_double_size) (void* self);
HOST_API double lantern_vector_double_size (void* self)
{
  LANTERN_CHECK_LOADED
  double ret = _lantern_vector_double_size(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API double (LANTERN_PTR _lantern_vector_double_at) (void* self, int64_t index);
HOST_API double lantern_vector_double_at (void* self, int64_t index)
{
  LANTERN_CHECK_LOADED
  double ret = _lantern_vector_double_at(self, index);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void (LANTERN_PTR _lantern_vector_double_delete) (void* x);
HOST_API void lantern_vector_double_delete (void* x)
{
  LANTERN_CHECK_LOADED
   _lantern_vector_double_delete(x);
  LANTERN_HOST_HANDLER;
  
}

LANTERN_API void* (LANTERN_PTR _lantern_vector_double_new) ();
HOST_API void* lantern_vector_double_new ()
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_vector_double_new();
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_vector_int64_t_new) ();
HOST_API void* lantern_vector_int64_t_new ()
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_vector_int64_t_new();
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void (LANTERN_PTR _lantern_vector_double_push_back) (void* self, double x);
HOST_API void lantern_vector_double_push_back (void* self, double x)
{
  LANTERN_CHECK_LOADED
   _lantern_vector_double_push_back(self, x);
  LANTERN_HOST_HANDLER;
  
}

LANTERN_API void (LANTERN_PTR _lantern_vector_int64_t_push_back) (void* self, int64_t x);
HOST_API void lantern_vector_int64_t_push_back (void* self, int64_t x)
{
  LANTERN_CHECK_LOADED
   _lantern_vector_int64_t_push_back(self, x);
  LANTERN_HOST_HANDLER;
  
}

LANTERN_API char * (LANTERN_PTR _lantern_string_get) (void* self);
HOST_API char * lantern_string_get (void* self)
{
  LANTERN_CHECK_LOADED
  char * ret = _lantern_string_get(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void (LANTERN_PTR _lantern_jit_Tuple_delete) (void *x);
HOST_API void lantern_jit_Tuple_delete (void *x)
{
  LANTERN_CHECK_LOADED
   _lantern_jit_Tuple_delete(x);
  LANTERN_HOST_HANDLER;
  
}

LANTERN_API void* (LANTERN_PTR _lantern_IValue_from_Tuple) (void* self);
HOST_API void* lantern_IValue_from_Tuple (void* self)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_IValue_from_Tuple(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_jit_Tuple_new) ();
HOST_API void* lantern_jit_Tuple_new ()
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_jit_Tuple_new();
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void (LANTERN_PTR _lantern_jit_Tuple_push_back) (void* self, void* element);
HOST_API void lantern_jit_Tuple_push_back (void* self, void* element)
{
  LANTERN_CHECK_LOADED
   _lantern_jit_Tuple_push_back(self, element);
  LANTERN_HOST_HANDLER;
  
}

LANTERN_API int64_t (LANTERN_PTR _lantern_jit_Tuple_size) (void* self);
HOST_API int64_t lantern_jit_Tuple_size (void* self)
{
  LANTERN_CHECK_LOADED
  int64_t ret = _lantern_jit_Tuple_size(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_jit_Tuple_at) (void* self, int64_t index);
HOST_API void* lantern_jit_Tuple_at (void* self, int64_t index)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_jit_Tuple_at(self, index);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void (LANTERN_PTR _lantern_jit_TensorDict_delete) (void *x);
HOST_API void lantern_jit_TensorDict_delete (void *x)
{
  LANTERN_CHECK_LOADED
   _lantern_jit_TensorDict_delete(x);
  LANTERN_HOST_HANDLER;
  
}

LANTERN_API void (LANTERN_PTR _lantern_jit_GenericDict_delete) (void *x);
HOST_API void lantern_jit_GenericDict_delete (void *x)
{
  LANTERN_CHECK_LOADED
   _lantern_jit_GenericDict_delete(x);
  LANTERN_HOST_HANDLER;
  
}

LANTERN_API void (LANTERN_PTR _lantern_jit_GenericList_delete) (void *x);
HOST_API void lantern_jit_GenericList_delete (void *x)
{
  LANTERN_CHECK_LOADED
   _lantern_jit_GenericList_delete(x);
  LANTERN_HOST_HANDLER;
  
}

LANTERN_API void* (LANTERN_PTR _lantern_jit_TensorDict_new) ();
HOST_API void* lantern_jit_TensorDict_new ()
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_jit_TensorDict_new();
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void (LANTERN_PTR _lantern_jit_TensorDict_push_back) (void* self, void* key, void* value);
HOST_API void lantern_jit_TensorDict_push_back (void* self, void* key, void* value)
{
  LANTERN_CHECK_LOADED
   _lantern_jit_TensorDict_push_back(self, key, value);
  LANTERN_HOST_HANDLER;
  
}

LANTERN_API void* (LANTERN_PTR _lantern_jit_GenericDict_keys) (void* self);
HOST_API void* lantern_jit_GenericDict_keys (void* self)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_jit_GenericDict_keys(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_jit_GenericDict_at) (void* self, void* key);
HOST_API void* lantern_jit_GenericDict_at (void* self, void* key)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_jit_GenericDict_at(self, key);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API int64_t (LANTERN_PTR _lantern_jit_GenericList_size) (void* self);
HOST_API int64_t lantern_jit_GenericList_size (void* self)
{
  LANTERN_CHECK_LOADED
  int64_t ret = _lantern_jit_GenericList_size(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_jit_GenericList_at) (void* self, int64_t index);
HOST_API void* lantern_jit_GenericList_at (void* self, int64_t index)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_jit_GenericList_at(self, index);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_IValue_from_TensorDict) (void* self);
HOST_API void* lantern_IValue_from_TensorDict (void* self)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_IValue_from_TensorDict(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void (LANTERN_PTR _lantern_jit_vector_IValue_delete) (void* x);
HOST_API void lantern_jit_vector_IValue_delete (void* x)
{
  LANTERN_CHECK_LOADED
   _lantern_jit_vector_IValue_delete(x);
  LANTERN_HOST_HANDLER;
  
}

LANTERN_API int64_t (LANTERN_PTR _lantern_jit_vector_IValue_size) (void* self);
HOST_API int64_t lantern_jit_vector_IValue_size (void* self)
{
  LANTERN_CHECK_LOADED
  int64_t ret = _lantern_jit_vector_IValue_size(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_jit_vector_IValue_at) (void* self, int64_t index);
HOST_API void* lantern_jit_vector_IValue_at (void* self, int64_t index)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_jit_vector_IValue_at(self, index);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_jit_NamedTuple_new) ();
HOST_API void* lantern_jit_NamedTuple_new ()
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_jit_NamedTuple_new();
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void (LANTERN_PTR _lantern_jit_NamedTuple_push_back) (void* self, void* name, void* element);
HOST_API void lantern_jit_NamedTuple_push_back (void* self, void* name, void* element)
{
  LANTERN_CHECK_LOADED
   _lantern_jit_NamedTuple_push_back(self, name, element);
  LANTERN_HOST_HANDLER;
  
}

LANTERN_API void* (LANTERN_PTR _lantern_jit_NamedTupleHelper_keys) (void* self);
HOST_API void* lantern_jit_NamedTupleHelper_keys (void* self)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_jit_NamedTupleHelper_keys(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_jit_NamedTupleHelper_elements) (void* self);
HOST_API void* lantern_jit_NamedTupleHelper_elements (void* self)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_jit_NamedTupleHelper_elements(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_IValue_from_NamedTuple) (void* self);
HOST_API void* lantern_IValue_from_NamedTuple (void* self)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_IValue_from_NamedTuple(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void (LANTERN_PTR _lantern_NamedTupleHelper_delete) (void* x);
HOST_API void lantern_NamedTupleHelper_delete (void* x)
{
  LANTERN_CHECK_LOADED
   _lantern_NamedTupleHelper_delete(x);
  LANTERN_HOST_HANDLER;
  
}

LANTERN_API void (LANTERN_PTR _lantern_Stack_push_back_IValue) (void* self, void* x);
HOST_API void lantern_Stack_push_back_IValue (void* self, void* x)
{
  LANTERN_CHECK_LOADED
   _lantern_Stack_push_back_IValue(self, x);
  LANTERN_HOST_HANDLER;
  
}

LANTERN_API void (LANTERN_PTR _lantern_FunctionPtr_delete) (void* x);
HOST_API void lantern_FunctionPtr_delete (void* x)
{
  LANTERN_CHECK_LOADED
   _lantern_FunctionPtr_delete(x);
  LANTERN_HOST_HANDLER;
  
}

LANTERN_API void* (LANTERN_PTR _lantern_IValue_from_None) ();
HOST_API void* lantern_IValue_from_None ()
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_IValue_from_None();
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_jit_compile_get_method) (void* cu, void* name);
HOST_API void* lantern_jit_compile_get_method (void* cu, void* name)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_jit_compile_get_method(cu, name);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_jit_compile_list_methods) (void* cu);
HOST_API void* lantern_jit_compile_list_methods (void* cu)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_jit_compile_list_methods(cu);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_jit_compile) (void* source, void* cu);
HOST_API void* lantern_jit_compile (void* source, void* cu)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_jit_compile(source, cu);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_ScriptModule_new) (void* cu, void* name);
HOST_API void* lantern_ScriptModule_new (void* cu, void* name)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_ScriptModule_new(cu, name);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void (LANTERN_PTR _lantern_ScriptModule_add_constant) (void* self, void* name, void* value);
HOST_API void lantern_ScriptModule_add_constant (void* self, void* name, void* value)
{
  LANTERN_CHECK_LOADED
   _lantern_ScriptModule_add_constant(self, name, value);
  LANTERN_HOST_HANDLER;
  
}

LANTERN_API void* (LANTERN_PTR _lantern_ScriptModule_find_constant) (void* self, void* name);
HOST_API void* lantern_ScriptModule_find_constant (void* self, void* name)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_ScriptModule_find_constant(self, name);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void (LANTERN_PTR _lantern_ScriptModule_add_method) (void* self, void* method);
HOST_API void lantern_ScriptModule_add_method (void* self, void* method)
{
  LANTERN_CHECK_LOADED
   _lantern_ScriptModule_add_method(self, method);
  LANTERN_HOST_HANDLER;
  
}

LANTERN_API void (LANTERN_PTR _lantern_ScriptModule_save) (void* self, void* path);
HOST_API void lantern_ScriptModule_save (void* self, void* path)
{
  LANTERN_CHECK_LOADED
   _lantern_ScriptModule_save(self, path);
  LANTERN_HOST_HANDLER;
  
}

LANTERN_API void (LANTERN_PTR _lantern_ScriptModule_save_for_mobile) (void* self, void* path);
HOST_API void lantern_ScriptModule_save_for_mobile (void* self, void* path)
{
  _lantern_ScriptModule_save_for_mobile(self, path);
  LANTERN_HOST_HANDLER;
  
}

LANTERN_API void* (LANTERN_PTR _lantern_vector_Scalar_new) ();
HOST_API void* lantern_vector_Scalar_new ()
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_vector_Scalar_new();
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void (LANTERN_PTR _lantern_vector_Scalar_push_back) (void* self, void* value);
HOST_API void lantern_vector_Scalar_push_back (void* self, void* value)
{
  LANTERN_CHECK_LOADED
   _lantern_vector_Scalar_push_back(self, value);
  LANTERN_HOST_HANDLER;
  
}

LANTERN_API int64_t (LANTERN_PTR _lantern_vector_Scalar_size) (void* self);
HOST_API int64_t lantern_vector_Scalar_size (void* self)
{
  LANTERN_CHECK_LOADED
  int64_t ret = _lantern_vector_Scalar_size(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_vector_Scalar_at) (void* self, int64_t index);
HOST_API void* lantern_vector_Scalar_at (void* self, int64_t index)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_vector_Scalar_at(self, index);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void (LANTERN_PTR _lantern_vector_Scalar_delete) (void* x);
HOST_API void lantern_vector_Scalar_delete (void* x)
{
  LANTERN_CHECK_LOADED
   _lantern_vector_Scalar_delete(x);
  LANTERN_HOST_HANDLER;
  
}

LANTERN_API void* (LANTERN_PTR _lantern_contrib_sort_vertices) (void* vertices, void* mask, void* num_valid);
HOST_API void* lantern_contrib_sort_vertices(void* vertices, void* mask, void* num_valid)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_contrib_sort_vertices(vertices, mask, num_valid);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_ScriptMethod_graph_print) (void* self);
HOST_API void* lantern_ScriptMethod_graph_print (void* self)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_ScriptMethod_graph_print(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void (LANTERN_PTR _lantern_autograd_set_detect_anomaly) (bool enabled);
HOST_API void lantern_autograd_set_detect_anomaly (bool enabled)
{
  LANTERN_CHECK_LOADED
   _lantern_autograd_set_detect_anomaly(enabled);
  LANTERN_HOST_HANDLER;
  
}

LANTERN_API bool (LANTERN_PTR _lantern_autograd_detect_anomaly_is_enabled) ();
HOST_API bool lantern_autograd_detect_anomaly_is_enabled ()
{
  LANTERN_CHECK_LOADED
  bool ret = _lantern_autograd_detect_anomaly_is_enabled();
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_get_default_Generator) ();
HOST_API void* lantern_get_default_Generator ()
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_get_default_Generator();
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_last_executed_optimized_graph_print) ();
HOST_API void* lantern_last_executed_optimized_graph_print ()
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_last_executed_optimized_graph_print();
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API bool (LANTERN_PTR _lantern_TensorIndex_is_empty) (void* self);
HOST_API bool lantern_TensorIndex_is_empty (void* self)
{
  LANTERN_CHECK_LOADED
  bool ret = _lantern_TensorIndex_is_empty(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void (LANTERN_PTR _lantern_OptionalTensorList_delete) (void* x);
HOST_API void lantern_OptionalTensorList_delete (void* x)
{
  LANTERN_CHECK_LOADED
   _lantern_OptionalTensorList_delete(x);
  LANTERN_HOST_HANDLER;
  
}

LANTERN_API int64_t (LANTERN_PTR _lantern_OptionalTensorList_size) (void* self);
HOST_API int64_t lantern_OptionalTensorList_size (void* self)
{
  LANTERN_CHECK_LOADED
  int64_t ret = _lantern_OptionalTensorList_size(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_OptionalTensorList_at) (void* self, int64_t i);
HOST_API void* lantern_OptionalTensorList_at (void* self, int64_t i)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_OptionalTensorList_at(self, i);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API bool (LANTERN_PTR _lantern_OptionalTensorList_at_is_null) (void* self, int64_t i);
HOST_API bool lantern_OptionalTensorList_at_is_null (void* self, int64_t i)
{
  LANTERN_CHECK_LOADED
  bool ret = _lantern_OptionalTensorList_at_is_null(self, i);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API bool (LANTERN_PTR _lantern_bool_get) (void* x);
HOST_API bool lantern_bool_get (void* x)
{
  LANTERN_CHECK_LOADED
  bool ret = _lantern_bool_get(x);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API int64_t (LANTERN_PTR _lantern_int64_t_get) (void* x);
HOST_API int64_t lantern_int64_t_get (void* x)
{
  LANTERN_CHECK_LOADED
  int64_t ret = _lantern_int64_t_get(x);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API double (LANTERN_PTR _lantern_double_get) (void* x);
HOST_API double lantern_double_get (void* x)
{
  LANTERN_CHECK_LOADED
  double ret = _lantern_double_get(x);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void (LANTERN_PTR _lantern_optional_vector_double_delete) (void* x);
HOST_API void lantern_optional_vector_double_delete (void* x)
{
  LANTERN_CHECK_LOADED
   _lantern_optional_vector_double_delete(x);
  LANTERN_HOST_HANDLER;
}

LANTERN_API void (LANTERN_PTR _lantern_Function_lambda_delete) (void* x);
HOST_API void lantern_Function_lambda_delete (void* x)
{
  LANTERN_CHECK_LOADED
   _lantern_Function_lambda_delete(x);
  LANTERN_HOST_HANDLER; 
}

LANTERN_API void (LANTERN_PTR _lantern_autograd_edge_list_delete) (void* x);
HOST_API void lantern_autograd_edge_list_delete (void* x)
{
  LANTERN_CHECK_LOADED
   _lantern_autograd_edge_list_delete(x);
  LANTERN_HOST_HANDLER;
}

LANTERN_API void (LANTERN_PTR _lantern_autograd_edge_delete) (void* x);
HOST_API void lantern_autograd_edge_delete (void* x)
{
  LANTERN_CHECK_LOADED
   _lantern_autograd_edge_delete(x);
  LANTERN_HOST_HANDLER;
}

LANTERN_API void* (LANTERN_PTR _lantern_cuda_get_device_capability) (int64_t device);
HOST_API void* lantern_cuda_get_device_capability (int64_t device)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_cuda_get_device_capability(device);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API int64_t (LANTERN_PTR _lantern_cudnn_runtime_version) ();
HOST_API int64_t lantern_cudnn_runtime_version ()
{
  LANTERN_CHECK_LOADED
  int64_t ret = _lantern_cudnn_runtime_version();
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API bool (LANTERN_PTR _lantern_cudnn_is_available) ();
HOST_API bool lantern_cudnn_is_available ()
{
  LANTERN_CHECK_LOADED
  bool ret = _lantern_cudnn_is_available();
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_cuda_device_stats) (int64_t device);
HOST_API void* lantern_cuda_device_stats (int64_t device)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_cuda_device_stats(device);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API int (LANTERN_PTR _lantern_cuda_get_runtime_version) ();
HOST_API int lantern_cuda_get_runtime_version () {
  LANTERN_CHECK_LOADED
  int ret = _lantern_cuda_get_runtime_version();
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void (LANTERN_PTR _set_delete_lambda_fun) (void (*fun)(void*));
HOST_API void set_delete_lambda_fun (void (*fun)(void*))
{
  LANTERN_CHECK_LOADED
  _set_delete_lambda_fun(fun);
  LANTERN_HOST_HANDLER;
}

LANTERN_API void* (LANTERN_PTR _lantern_from_blob) (void* data, int64_t *sizes, size_t sizes_size,
                          int64_t* strides, size_t strides_size, void* options);
HOST_API void* lantern_from_blob(void* data, int64_t *sizes, size_t sizes_size,
                          int64_t* strides, size_t strides_size, void* options) { 
  LANTERN_CHECK_LOADED
  void* ret = _lantern_from_blob(data, sizes, sizes_size, strides, strides_size, options);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API int (LANTERN_PTR _lantern_string_size) (void* self);
HOST_API int lantern_string_size (void* self)
{
  LANTERN_CHECK_LOADED
  int ret = _lantern_string_size(self);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void (LANTERN_PTR _lantern_set_gc_called) (bool called);
HOST_API void lantern_set_gc_called (bool called) 
{
  LANTERN_CHECK_LOADED
  _lantern_set_gc_called(called);
  LANTERN_HOST_HANDLER;
}

LANTERN_API void* (LANTERN_PTR _lantern_torch_show_config) ();
HOST_API void* lantern_torch_show_config () 
{
  LANTERN_CHECK_LOADED
  auto ret = _lantern_torch_show_config();
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_torch_parallel_info) ();
HOST_API void* lantern_torch_parallel_info () 
{
  LANTERN_CHECK_LOADED
  auto ret = _lantern_torch_parallel_info();
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void (LANTERN_PTR _lantern_set_cuda_allocator_thresholds) (double reserved_rate, double allocated_rate, double allocated_reserved_rate);
HOST_API void lantern_set_cuda_allocator_thresholds (double reserved_rate, double allocated_rate, double allocated_reserved_rate) {
  LANTERN_CHECK_LOADED
  _lantern_set_cuda_allocator_thresholds(reserved_rate, allocated_rate, allocated_reserved_rate);
  LANTERN_HOST_HANDLER;
}

LANTERN_API void (LANTERN_PTR _lantern_cuda_synchronize) (int device_index);
HOST_API void lantern_cuda_synchronize (int device_index) {
  LANTERN_CHECK_LOADED
  _lantern_cuda_synchronize (device_index);
  LANTERN_HOST_HANDLER;
}

LANTERN_API bool (LANTERN_PTR _lantern_backend_has_mps) ();
HOST_API bool lantern_backend_has_mps () {
  LANTERN_CHECK_LOADED
  bool ret = _lantern_backend_has_mps();
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void (LANTERN_PTR _lantern_cuda_empty_cache) ();
HOST_API void lantern_cuda_empty_cache () {
  LANTERN_CHECK_LOADED
  _lantern_cuda_empty_cache();
  LANTERN_HOST_HANDLER;
}

LANTERN_API bool (LANTERN_PTR _lantern_Tensor_is_sparse) (void* x);
HOST_API bool lantern_Tensor_is_sparse (void* x)
{
  LANTERN_CHECK_LOADED
  bool ret = _lantern_Tensor_is_sparse(x);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_IntArrayRef_get) (void* x);
HOST_API void* lantern_IntArrayRef_get (void* x)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_IntArrayRef_get(x);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void (LANTERN_PTR _lantern_autograd_zero_grad) (void * self);
HOST_API void lantern_autograd_zero_grad (void * self) {
  LANTERN_CHECK_LOADED
  _lantern_autograd_zero_grad(self);
  LANTERN_HOST_HANDLER;
}

LANTERN_API bool (LANTERN_PTR _lantern_amp_is_autocast_gpu_enabled) ();
HOST_API bool lantern_amp_is_autocast_gpu_enabled ()
{
  LANTERN_CHECK_LOADED
  bool ret = _lantern_amp_is_autocast_gpu_enabled();
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API bool (LANTERN_PTR _lantern_amp_is_autocast_cpu_enabled) ();
HOST_API bool lantern_amp_is_autocast_cpu_enabled ()
{
  LANTERN_CHECK_LOADED
  bool ret = _lantern_amp_is_autocast_cpu_enabled();
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void (LANTERN_PTR _lantern_amp_autocast_set_gpu_enabled) (bool enabled);
HOST_API void lantern_amp_autocast_set_gpu_enabled (bool enabled)
{
  LANTERN_CHECK_LOADED
   _lantern_amp_autocast_set_gpu_enabled(enabled);
  LANTERN_HOST_HANDLER;
  
}

LANTERN_API void (LANTERN_PTR _lantern_amp_autocast_set_cpu_enabled) (bool enabled);
HOST_API void lantern_amp_autocast_set_cpu_enabled (bool enabled)
{
  LANTERN_CHECK_LOADED
   _lantern_amp_autocast_set_cpu_enabled(enabled);
  LANTERN_HOST_HANDLER;
  
}

LANTERN_API void (LANTERN_PTR _lantern_amp_autocast_set_gpu_dtype) (void* dtype);
HOST_API void lantern_amp_autocast_set_gpu_dtype (void* dtype)
{
  LANTERN_CHECK_LOADED
   _lantern_amp_autocast_set_gpu_dtype(dtype);
  LANTERN_HOST_HANDLER;
  
}

LANTERN_API void (LANTERN_PTR _lantern_amp_autocast_set_cpu_dtype) (void* dtype);
HOST_API void lantern_amp_autocast_set_cpu_dtype (void* dtype)
{
  LANTERN_CHECK_LOADED
   _lantern_amp_autocast_set_cpu_dtype(dtype);
  LANTERN_HOST_HANDLER;
  
}

LANTERN_API void (LANTERN_PTR _lantern_amp_autocast_set_cache_enabled) (bool enabled);
HOST_API void lantern_amp_autocast_set_cache_enabled (bool enabled)
{
  LANTERN_CHECK_LOADED
   _lantern_amp_autocast_set_cache_enabled(enabled);
  LANTERN_HOST_HANDLER;
  
}

LANTERN_API bool (LANTERN_PTR _lantern_amp_autocast_is_cache_enabled) ();
HOST_API bool lantern_amp_autocast_is_cache_enabled ()
{
  LANTERN_CHECK_LOADED
  bool ret = _lantern_amp_autocast_is_cache_enabled();
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_amp_autocast_get_gpu_dtype) ();
HOST_API void* lantern_amp_autocast_get_gpu_dtype ()
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_amp_autocast_get_gpu_dtype();
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_amp_autocast_get_cpu_dtype) ();
HOST_API void* lantern_amp_autocast_get_cpu_dtype ()
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_amp_autocast_get_cpu_dtype();
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void (LANTERN_PTR _lantern_amp_autocast_increment_nesting) ();
HOST_API void lantern_amp_autocast_increment_nesting ()
{
  LANTERN_CHECK_LOADED
   _lantern_amp_autocast_increment_nesting();
  LANTERN_HOST_HANDLER;
  
}

LANTERN_API int (LANTERN_PTR _lantern_amp_autocast_decrement_nesting) ();
HOST_API int lantern_amp_autocast_decrement_nesting ()
{
  LANTERN_CHECK_LOADED
   int ret = _lantern_amp_autocast_decrement_nesting();
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void (LANTERN_PTR _lantern_amp_autocast_clear_cache) ();
HOST_API void lantern_amp_autocast_clear_cache ()
{
  LANTERN_CHECK_LOADED
   _lantern_amp_autocast_clear_cache();
  LANTERN_HOST_HANDLER;
  
}

LANTERN_API int (LANTERN_PTR _lantern_amp_foreach_non_finite_check_and_unscale) (void* params, void* found_inf, void* inv_scale);
HOST_API int lantern_amp_foreach_non_finite_check_and_unscale (void* params, void* found_inf, void* inv_scale)
{
  LANTERN_CHECK_LOADED
  int ret = _lantern_amp_foreach_non_finite_check_and_unscale(params, found_inf, inv_scale);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void (LANTERN_PTR _lantern_amp_update_scale_) (void* self, void* growth_tracker, void* found_inf, double scale_growth_factor, double scale_backoff_factor, void* growth_interval);
HOST_API void lantern_amp_update_scale_ (void* self, void* growth_tracker, void* found_inf, double scale_growth_factor, double scale_backoff_factor, void* growth_interval)
{
  LANTERN_CHECK_LOADED
   _lantern_amp_update_scale_(self, growth_tracker, found_inf, scale_growth_factor, scale_backoff_factor, growth_interval);
  LANTERN_HOST_HANDLER;
  
}

LANTERN_API void (LANTERN_PTR _lantern_cuda_set_rng_state) (int device, void* state);
HOST_API void lantern_cuda_set_rng_state (int device, void* state)
{
  LANTERN_CHECK_LOADED
   _lantern_cuda_set_rng_state(device, state);
  LANTERN_HOST_HANDLER;
  
}

LANTERN_API void* (LANTERN_PTR _lantern_cuda_get_rng_state) (int device);
HOST_API void* lantern_cuda_get_rng_state (int device)
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_cuda_get_rng_state(device);
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void* (LANTERN_PTR _lantern_cpu_get_rng_state) ();
HOST_API void* lantern_cpu_get_rng_state ()
{
  LANTERN_CHECK_LOADED
  void* ret = _lantern_cpu_get_rng_state();
  LANTERN_HOST_HANDLER;
  return ret;
}

LANTERN_API void (LANTERN_PTR _lantern_cpu_set_rng_state) (void* state);
HOST_API void lantern_cpu_set_rng_state (void* state)
{
  LANTERN_CHECK_LOADED
   _lantern_cpu_set_rng_state(state);
  LANTERN_HOST_HANDLER;
  
}

  /* Autogen Headers -- Start */
  LANTERN_API void* (LANTERN_PTR _lantern__cast_byte_tensor_bool)(void* self, void* non_blocking);
  HOST_API void* lantern__cast_byte_tensor_bool(void* self, void* non_blocking) { LANTERN_CHECK_LOADED void* ret = _lantern__cast_byte_tensor_bool(self, non_blocking); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__cast_char_tensor_bool)(void* self, void* non_blocking);
  HOST_API void* lantern__cast_char_tensor_bool(void* self, void* non_blocking) { LANTERN_CHECK_LOADED void* ret = _lantern__cast_char_tensor_bool(self, non_blocking); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__cast_double_tensor_bool)(void* self, void* non_blocking);
  HOST_API void* lantern__cast_double_tensor_bool(void* self, void* non_blocking) { LANTERN_CHECK_LOADED void* ret = _lantern__cast_double_tensor_bool(self, non_blocking); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__cast_float_tensor_bool)(void* self, void* non_blocking);
  HOST_API void* lantern__cast_float_tensor_bool(void* self, void* non_blocking) { LANTERN_CHECK_LOADED void* ret = _lantern__cast_float_tensor_bool(self, non_blocking); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__cast_int_tensor_bool)(void* self, void* non_blocking);
  HOST_API void* lantern__cast_int_tensor_bool(void* self, void* non_blocking) { LANTERN_CHECK_LOADED void* ret = _lantern__cast_int_tensor_bool(self, non_blocking); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__cast_long_tensor_bool)(void* self, void* non_blocking);
  HOST_API void* lantern__cast_long_tensor_bool(void* self, void* non_blocking) { LANTERN_CHECK_LOADED void* ret = _lantern__cast_long_tensor_bool(self, non_blocking); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__cast_short_tensor_bool)(void* self, void* non_blocking);
  HOST_API void* lantern__cast_short_tensor_bool(void* self, void* non_blocking) { LANTERN_CHECK_LOADED void* ret = _lantern__cast_short_tensor_bool(self, non_blocking); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__cast_half_tensor_bool)(void* self, void* non_blocking);
  HOST_API void* lantern__cast_half_tensor_bool(void* self, void* non_blocking) { LANTERN_CHECK_LOADED void* ret = _lantern__cast_half_tensor_bool(self, non_blocking); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor__backward_tensor_tensorlist_tensor_bool_bool)(void* self, void* inputs, void* gradient, void* retain_graph, void* create_graph);
  HOST_API void* lantern_Tensor__backward_tensor_tensorlist_tensor_bool_bool(void* self, void* inputs, void* gradient, void* retain_graph, void* create_graph) { void* ret = _lantern_Tensor__backward_tensor_tensorlist_tensor_bool_bool(self, inputs, gradient, retain_graph, create_graph); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_set_data_tensor_tensor)(void* self, void* new_data);
  HOST_API void* lantern_Tensor_set_data_tensor_tensor(void* self, void* new_data) { void* ret = _lantern_Tensor_set_data_tensor_tensor(self, new_data); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_data_tensor)(void* self);
  HOST_API void* lantern_Tensor_data_tensor(void* self) { void* ret = _lantern_Tensor_data_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_is_leaf_tensor)(void* self);
  HOST_API void* lantern_Tensor_is_leaf_tensor(void* self) { void* ret = _lantern_Tensor_is_leaf_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_output_nr_tensor)(void* self);
  HOST_API void* lantern_Tensor_output_nr_tensor(void* self) { void* ret = _lantern_Tensor_output_nr_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor__version_tensor)(void* self);
  HOST_API void* lantern_Tensor__version_tensor(void* self) { void* ret = _lantern_Tensor__version_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_requires_grad__tensor_bool)(void* self, void* requires_grad);
  HOST_API void* lantern_Tensor_requires_grad__tensor_bool(void* self, void* requires_grad) { void* ret = _lantern_Tensor_requires_grad__tensor_bool(self, requires_grad); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_retain_grad_tensor)(void* self);
  HOST_API void* lantern_Tensor_retain_grad_tensor(void* self) { void* ret = _lantern_Tensor_retain_grad_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_retains_grad_tensor)(void* self);
  HOST_API void* lantern_Tensor_retains_grad_tensor(void* self) { void* ret = _lantern_Tensor_retains_grad_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor__fw_primal_tensor_intt)(void* self, void* level);
  HOST_API void* lantern_Tensor__fw_primal_tensor_intt(void* self, void* level) { void* ret = _lantern_Tensor__fw_primal_tensor_intt(self, level); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__make_dual_tensor_tensor_intt)(void* primal, void* tangent, void* level);
  HOST_API void* lantern__make_dual_tensor_tensor_intt(void* primal, void* tangent, void* level) { LANTERN_CHECK_LOADED void* ret = _lantern__make_dual_tensor_tensor_intt(primal, tangent, level); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__unpack_dual_tensor_intt)(void* dual, void* level);
  HOST_API void* lantern__unpack_dual_tensor_intt(void* dual, void* level) { LANTERN_CHECK_LOADED void* ret = _lantern__unpack_dual_tensor_intt(dual, level); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__new_zeros_with_same_feature_meta_tensor_tensor_intt)(void* self, void* other, void* self_num_batch_dims);
  HOST_API void* lantern__new_zeros_with_same_feature_meta_tensor_tensor_intt(void* self, void* other, void* self_num_batch_dims) { LANTERN_CHECK_LOADED void* ret = _lantern__new_zeros_with_same_feature_meta_tensor_tensor_intt(self, other, self_num_batch_dims); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__has_same_storage_numel_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern__has_same_storage_numel_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern__has_same_storage_numel_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_rename__tensor_dimnamelist)(void* self, void* names);
  HOST_API void* lantern_Tensor_rename__tensor_dimnamelist(void* self, void* names) { void* ret = _lantern_Tensor_rename__tensor_dimnamelist(self, names); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_rename_tensor_dimnamelist)(void* self, void* names);
  HOST_API void* lantern_Tensor_rename_tensor_dimnamelist(void* self, void* names) { void* ret = _lantern_Tensor_rename_tensor_dimnamelist(self, names); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_align_to_tensor_dimnamelist)(void* self, void* names);
  HOST_API void* lantern_Tensor_align_to_tensor_dimnamelist(void* self, void* names) { void* ret = _lantern_Tensor_align_to_tensor_dimnamelist(self, names); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_align_to_tensor_dimnamelist_intt)(void* self, void* order, void* ellipsis_idx);
  HOST_API void* lantern_Tensor_align_to_tensor_dimnamelist_intt(void* self, void* order, void* ellipsis_idx) { void* ret = _lantern_Tensor_align_to_tensor_dimnamelist_intt(self, order, ellipsis_idx); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_align_as_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_align_as_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_align_as_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_align_tensors_tensorlist)(void* tensors);
  HOST_API void* lantern_align_tensors_tensorlist(void* tensors) { LANTERN_CHECK_LOADED void* ret = _lantern_align_tensors_tensorlist(tensors); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__assert_async_tensor)(void* self);
  HOST_API void* lantern__assert_async_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__assert_async_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__assert_tensor_metadata_tensor_intarrayref_intarrayref_scalartype)(void* a, void* size, void* stride, void* dtype);
  HOST_API void* lantern__assert_tensor_metadata_tensor_intarrayref_intarrayref_scalartype(void* a, void* size, void* stride, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern__assert_tensor_metadata_tensor_intarrayref_intarrayref_scalartype(a, size, stride, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_refine_names_tensor_dimnamelist)(void* self, void* names);
  HOST_API void* lantern_Tensor_refine_names_tensor_dimnamelist(void* self, void* names) { void* ret = _lantern_Tensor_refine_names_tensor_dimnamelist(self, names); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__use_cudnn_ctc_loss_tensor_tensor_intarrayref_intarrayref_intt)(void* log_probs, void* targets, void* input_lengths, void* target_lengths, void* blank);
  HOST_API void* lantern__use_cudnn_ctc_loss_tensor_tensor_intarrayref_intarrayref_intt(void* log_probs, void* targets, void* input_lengths, void* target_lengths, void* blank) { LANTERN_CHECK_LOADED void* ret = _lantern__use_cudnn_ctc_loss_tensor_tensor_intarrayref_intarrayref_intt(log_probs, targets, input_lengths, target_lengths, blank); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__use_cudnn_ctc_loss_tensor_tensor_tensor_tensor_intt)(void* log_probs, void* targets, void* input_lengths, void* target_lengths, void* blank);
  HOST_API void* lantern__use_cudnn_ctc_loss_tensor_tensor_tensor_tensor_intt(void* log_probs, void* targets, void* input_lengths, void* target_lengths, void* blank) { LANTERN_CHECK_LOADED void* ret = _lantern__use_cudnn_ctc_loss_tensor_tensor_tensor_tensor_intt(log_probs, targets, input_lengths, target_lengths, blank); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__cudnn_ctc_loss_tensor_tensor_intarrayref_intarrayref_intt_bool_bool)(void* log_probs, void* targets, void* input_lengths, void* target_lengths, void* blank, void* deterministic, void* zero_infinity);
  HOST_API void* lantern__cudnn_ctc_loss_tensor_tensor_intarrayref_intarrayref_intt_bool_bool(void* log_probs, void* targets, void* input_lengths, void* target_lengths, void* blank, void* deterministic, void* zero_infinity) { LANTERN_CHECK_LOADED void* ret = _lantern__cudnn_ctc_loss_tensor_tensor_intarrayref_intarrayref_intt_bool_bool(log_probs, targets, input_lengths, target_lengths, blank, deterministic, zero_infinity); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__cudnn_ctc_loss_tensor_tensor_tensor_tensor_intt_bool_bool)(void* log_probs, void* targets, void* input_lengths, void* target_lengths, void* blank, void* deterministic, void* zero_infinity);
  HOST_API void* lantern__cudnn_ctc_loss_tensor_tensor_tensor_tensor_intt_bool_bool(void* log_probs, void* targets, void* input_lengths, void* target_lengths, void* blank, void* deterministic, void* zero_infinity) { LANTERN_CHECK_LOADED void* ret = _lantern__cudnn_ctc_loss_tensor_tensor_tensor_tensor_intt_bool_bool(log_probs, targets, input_lengths, target_lengths, blank, deterministic, zero_infinity); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__use_cudnn_rnn_flatten_weight)();
  HOST_API void* lantern__use_cudnn_rnn_flatten_weight() { LANTERN_CHECK_LOADED void* ret = _lantern__use_cudnn_rnn_flatten_weight(); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__cudnn_rnn_flatten_weight_tensorlist_intt_intt_intt_intt_intt_intt_bool_bool)(void* weight_arr, void* weight_stride0, void* input_size, void* mode, void* hidden_size, void* proj_size, void* num_layers, void* batch_first, void* bidirectional);
  HOST_API void* lantern__cudnn_rnn_flatten_weight_tensorlist_intt_intt_intt_intt_intt_intt_bool_bool(void* weight_arr, void* weight_stride0, void* input_size, void* mode, void* hidden_size, void* proj_size, void* num_layers, void* batch_first, void* bidirectional) { LANTERN_CHECK_LOADED void* ret = _lantern__cudnn_rnn_flatten_weight_tensorlist_intt_intt_intt_intt_intt_intt_bool_bool(weight_arr, weight_stride0, input_size, mode, hidden_size, proj_size, num_layers, batch_first, bidirectional); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__cudnn_rnn_tensor_tensorlist_intt_tensor_tensor_tensor_intt_intt_intt_intt_bool_double_bool_bool_intarrayref_tensor)(void* input, void* weight, void* weight_stride0, void* weight_buf, void* hx, void* cx, void* mode, void* hidden_size, void* proj_size, void* num_layers, void* batch_first, void* dropout, void* train, void* bidirectional, void* batch_sizes, void* dropout_state);
  HOST_API void* lantern__cudnn_rnn_tensor_tensorlist_intt_tensor_tensor_tensor_intt_intt_intt_intt_bool_double_bool_bool_intarrayref_tensor(void* input, void* weight, void* weight_stride0, void* weight_buf, void* hx, void* cx, void* mode, void* hidden_size, void* proj_size, void* num_layers, void* batch_first, void* dropout, void* train, void* bidirectional, void* batch_sizes, void* dropout_state) { LANTERN_CHECK_LOADED void* ret = _lantern__cudnn_rnn_tensor_tensorlist_intt_tensor_tensor_tensor_intt_intt_intt_intt_bool_double_bool_bool_intarrayref_tensor(input, weight, weight_stride0, weight_buf, hx, cx, mode, hidden_size, proj_size, num_layers, batch_first, dropout, train, bidirectional, batch_sizes, dropout_state); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__cudnn_rnn_backward_tensor_tensorlist_intt_tensor_tensor_tensor_tensor_tensor_tensor_tensor_intt_intt_intt_intt_bool_double_bool_bool_intarrayref_tensor_tensor_stdarraybool)(void* input, void* weight, void* weight_stride0, void* weight_buf, void* hx, void* cx, void* output, void* grad_output, void* grad_hy, void* grad_cy, void* mode, void* hidden_size, void* proj_size, void* num_layers, void* batch_first, void* dropout, void* train, void* bidirectional, void* batch_sizes, void* dropout_state, void* reserve, void* output_mask);
  HOST_API void* lantern__cudnn_rnn_backward_tensor_tensorlist_intt_tensor_tensor_tensor_tensor_tensor_tensor_tensor_intt_intt_intt_intt_bool_double_bool_bool_intarrayref_tensor_tensor_stdarraybool(void* input, void* weight, void* weight_stride0, void* weight_buf, void* hx, void* cx, void* output, void* grad_output, void* grad_hy, void* grad_cy, void* mode, void* hidden_size, void* proj_size, void* num_layers, void* batch_first, void* dropout, void* train, void* bidirectional, void* batch_sizes, void* dropout_state, void* reserve, void* output_mask) { LANTERN_CHECK_LOADED void* ret = _lantern__cudnn_rnn_backward_tensor_tensorlist_intt_tensor_tensor_tensor_tensor_tensor_tensor_tensor_intt_intt_intt_intt_bool_double_bool_bool_intarrayref_tensor_tensor_stdarraybool(input, weight, weight_stride0, weight_buf, hx, cx, output, grad_output, grad_hy, grad_cy, mode, hidden_size, proj_size, num_layers, batch_first, dropout, train, bidirectional, batch_sizes, dropout_state, reserve, output_mask); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__cudnn_init_dropout_state_double_bool_intt_tensoroptions)(void* dropout, void* train, void* dropout_seed, void* options);
  HOST_API void* lantern__cudnn_init_dropout_state_double_bool_intt_tensoroptions(void* dropout, void* train, void* dropout_seed, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern__cudnn_init_dropout_state_double_bool_intt_tensoroptions(dropout, train, dropout_seed, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__debug_has_internal_overlap_tensor)(void* self);
  HOST_API void* lantern__debug_has_internal_overlap_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__debug_has_internal_overlap_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__fused_dropout_tensor_double_generator)(void* self, void* p, void* generator);
  HOST_API void* lantern__fused_dropout_tensor_double_generator(void* self, void* p, void* generator) { LANTERN_CHECK_LOADED void* ret = _lantern__fused_dropout_tensor_double_generator(self, p, generator); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__masked_scale_tensor_tensor_double)(void* self, void* mask, void* scale);
  HOST_API void* lantern__masked_scale_tensor_tensor_double(void* self, void* mask, void* scale) { LANTERN_CHECK_LOADED void* ret = _lantern__masked_scale_tensor_tensor_double(self, mask, scale); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_native_dropout_tensor_double_bool)(void* input, void* p, void* train);
  HOST_API void* lantern_native_dropout_tensor_double_bool(void* input, void* p, void* train) { LANTERN_CHECK_LOADED void* ret = _lantern_native_dropout_tensor_double_bool(input, p, train); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_native_dropout_backward_tensor_tensor_double)(void* grad_output, void* mask, void* scale);
  HOST_API void* lantern_native_dropout_backward_tensor_tensor_double(void* grad_output, void* mask, void* scale) { LANTERN_CHECK_LOADED void* ret = _lantern_native_dropout_backward_tensor_tensor_double(grad_output, mask, scale); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__sobol_engine_draw_tensor_intt_tensor_intt_intt_scalartype)(void* quasi, void* n, void* sobolstate, void* dimension, void* num_generated, void* dtype);
  HOST_API void* lantern__sobol_engine_draw_tensor_intt_tensor_intt_intt_scalartype(void* quasi, void* n, void* sobolstate, void* dimension, void* num_generated, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern__sobol_engine_draw_tensor_intt_tensor_intt_intt_scalartype(quasi, n, sobolstate, dimension, num_generated, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__sobol_engine_ff__tensor_intt_tensor_intt_intt)(void* self, void* n, void* sobolstate, void* dimension, void* num_generated);
  HOST_API void* lantern__sobol_engine_ff__tensor_intt_tensor_intt_intt(void* self, void* n, void* sobolstate, void* dimension, void* num_generated) { LANTERN_CHECK_LOADED void* ret = _lantern__sobol_engine_ff__tensor_intt_tensor_intt_intt(self, n, sobolstate, dimension, num_generated); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__sobol_engine_scramble__tensor_tensor_intt)(void* self, void* ltm, void* dimension);
  HOST_API void* lantern__sobol_engine_scramble__tensor_tensor_intt(void* self, void* ltm, void* dimension) { LANTERN_CHECK_LOADED void* ret = _lantern__sobol_engine_scramble__tensor_tensor_intt(self, ltm, dimension); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__sobol_engine_initialize_state__tensor_intt)(void* self, void* dimension);
  HOST_API void* lantern__sobol_engine_initialize_state__tensor_intt(void* self, void* dimension) { LANTERN_CHECK_LOADED void* ret = _lantern__sobol_engine_initialize_state__tensor_intt(self, dimension); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__reshape_from_tensor_tensor_tensor)(void* self, void* shape);
  HOST_API void* lantern__reshape_from_tensor_tensor_tensor(void* self, void* shape) { LANTERN_CHECK_LOADED void* ret = _lantern__reshape_from_tensor_tensor_tensor(self, shape); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__shape_as_tensor_tensor)(void* self);
  HOST_API void* lantern__shape_as_tensor_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__shape_as_tensor_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_dropout_tensor_double_bool)(void* input, void* p, void* train);
  HOST_API void* lantern_dropout_tensor_double_bool(void* input, void* p, void* train) { LANTERN_CHECK_LOADED void* ret = _lantern_dropout_tensor_double_bool(input, p, train); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_dropout__tensor_double_bool)(void* self, void* p, void* train);
  HOST_API void* lantern_dropout__tensor_double_bool(void* self, void* p, void* train) { LANTERN_CHECK_LOADED void* ret = _lantern_dropout__tensor_double_bool(self, p, train); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_feature_dropout_tensor_double_bool)(void* input, void* p, void* train);
  HOST_API void* lantern_feature_dropout_tensor_double_bool(void* input, void* p, void* train) { LANTERN_CHECK_LOADED void* ret = _lantern_feature_dropout_tensor_double_bool(input, p, train); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_feature_dropout__tensor_double_bool)(void* self, void* p, void* train);
  HOST_API void* lantern_feature_dropout__tensor_double_bool(void* self, void* p, void* train) { LANTERN_CHECK_LOADED void* ret = _lantern_feature_dropout__tensor_double_bool(self, p, train); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_alpha_dropout_tensor_double_bool)(void* input, void* p, void* train);
  HOST_API void* lantern_alpha_dropout_tensor_double_bool(void* input, void* p, void* train) { LANTERN_CHECK_LOADED void* ret = _lantern_alpha_dropout_tensor_double_bool(input, p, train); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_alpha_dropout__tensor_double_bool)(void* self, void* p, void* train);
  HOST_API void* lantern_alpha_dropout__tensor_double_bool(void* self, void* p, void* train) { LANTERN_CHECK_LOADED void* ret = _lantern_alpha_dropout__tensor_double_bool(self, p, train); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_feature_alpha_dropout_tensor_double_bool)(void* input, void* p, void* train);
  HOST_API void* lantern_feature_alpha_dropout_tensor_double_bool(void* input, void* p, void* train) { LANTERN_CHECK_LOADED void* ret = _lantern_feature_alpha_dropout_tensor_double_bool(input, p, train); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_feature_alpha_dropout__tensor_double_bool)(void* self, void* p, void* train);
  HOST_API void* lantern_feature_alpha_dropout__tensor_double_bool(void* self, void* p, void* train) { LANTERN_CHECK_LOADED void* ret = _lantern_feature_alpha_dropout__tensor_double_bool(self, p, train); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_abs_tensor)(void* self);
  HOST_API void* lantern_abs_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_abs_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_abs_tensor)(void* self);
  HOST_API void* lantern_Tensor_abs_tensor(void* self) { void* ret = _lantern_Tensor_abs_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_abs__tensor)(void* self);
  HOST_API void* lantern_abs__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_abs__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_abs__tensor)(void* self);
  HOST_API void* lantern_Tensor_abs__tensor(void* self) { void* ret = _lantern_Tensor_abs__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_abs_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_abs_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_abs_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_absolute_tensor)(void* self);
  HOST_API void* lantern_absolute_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_absolute_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_absolute_tensor)(void* self);
  HOST_API void* lantern_Tensor_absolute_tensor(void* self) { void* ret = _lantern_Tensor_absolute_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_absolute__tensor)(void* self);
  HOST_API void* lantern_Tensor_absolute__tensor(void* self) { void* ret = _lantern_Tensor_absolute__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_absolute_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_absolute_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_absolute_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_angle_tensor)(void* self);
  HOST_API void* lantern_angle_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_angle_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_angle_tensor)(void* self);
  HOST_API void* lantern_Tensor_angle_tensor(void* self) { void* ret = _lantern_Tensor_angle_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_angle_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_angle_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_angle_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_view_as_real_tensor)(void* self);
  HOST_API void* lantern_view_as_real_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_view_as_real_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_view_as_complex_tensor)(void* self);
  HOST_API void* lantern_view_as_complex_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_view_as_complex_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sgn_tensor)(void* self);
  HOST_API void* lantern_sgn_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_sgn_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_sgn_tensor)(void* self);
  HOST_API void* lantern_Tensor_sgn_tensor(void* self) { void* ret = _lantern_Tensor_sgn_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_sgn__tensor)(void* self);
  HOST_API void* lantern_Tensor_sgn__tensor(void* self) { void* ret = _lantern_Tensor_sgn__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sgn_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_sgn_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_sgn_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_chalf_tensor_memoryformat)(void* self, void* memory_format);
  HOST_API void* lantern_Tensor_chalf_tensor_memoryformat(void* self, void* memory_format) { void* ret = _lantern_Tensor_chalf_tensor_memoryformat(self, memory_format); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_real_tensor)(void* self);
  HOST_API void* lantern_real_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_real_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_imag_tensor)(void* self);
  HOST_API void* lantern_imag_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_imag_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__conj_tensor)(void* self);
  HOST_API void* lantern__conj_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__conj_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor__conj_tensor)(void* self);
  HOST_API void* lantern_Tensor__conj_tensor(void* self) { void* ret = _lantern_Tensor__conj_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_conj_tensor)(void* self);
  HOST_API void* lantern_conj_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_conj_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_conj_tensor)(void* self);
  HOST_API void* lantern_Tensor_conj_tensor(void* self) { void* ret = _lantern_Tensor_conj_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__conj_physical_tensor)(void* self);
  HOST_API void* lantern__conj_physical_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__conj_physical_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor__conj_physical_tensor)(void* self);
  HOST_API void* lantern_Tensor__conj_physical_tensor(void* self) { void* ret = _lantern_Tensor__conj_physical_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_conj_physical_tensor)(void* self);
  HOST_API void* lantern_conj_physical_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_conj_physical_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_conj_physical_tensor)(void* self);
  HOST_API void* lantern_Tensor_conj_physical_tensor(void* self) { void* ret = _lantern_Tensor_conj_physical_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_conj_physical_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_conj_physical_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_conj_physical_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_conj_physical__tensor)(void* self);
  HOST_API void* lantern_conj_physical__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_conj_physical__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_conj_physical__tensor)(void* self);
  HOST_API void* lantern_Tensor_conj_physical__tensor(void* self) { void* ret = _lantern_Tensor_conj_physical__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_resolve_conj_tensor)(void* self);
  HOST_API void* lantern_resolve_conj_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_resolve_conj_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_resolve_conj_tensor)(void* self);
  HOST_API void* lantern_Tensor_resolve_conj_tensor(void* self) { void* ret = _lantern_Tensor_resolve_conj_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_resolve_neg_tensor)(void* self);
  HOST_API void* lantern_resolve_neg_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_resolve_neg_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_resolve_neg_tensor)(void* self);
  HOST_API void* lantern_Tensor_resolve_neg_tensor(void* self) { void* ret = _lantern_Tensor_resolve_neg_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__neg_view_tensor)(void* self);
  HOST_API void* lantern__neg_view_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__neg_view_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor__neg_view_tensor)(void* self);
  HOST_API void* lantern_Tensor__neg_view_tensor(void* self) { void* ret = _lantern_Tensor__neg_view_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_acos_tensor)(void* self);
  HOST_API void* lantern_acos_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_acos_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_acos_tensor)(void* self);
  HOST_API void* lantern_Tensor_acos_tensor(void* self) { void* ret = _lantern_Tensor_acos_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_acos__tensor)(void* self);
  HOST_API void* lantern_acos__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_acos__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_acos__tensor)(void* self);
  HOST_API void* lantern_Tensor_acos__tensor(void* self) { void* ret = _lantern_Tensor_acos__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_acos_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_acos_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_acos_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_arccos_tensor)(void* self);
  HOST_API void* lantern_arccos_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_arccos_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_arccos_tensor)(void* self);
  HOST_API void* lantern_Tensor_arccos_tensor(void* self) { void* ret = _lantern_Tensor_arccos_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_arccos__tensor)(void* self);
  HOST_API void* lantern_arccos__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_arccos__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_arccos__tensor)(void* self);
  HOST_API void* lantern_Tensor_arccos__tensor(void* self) { void* ret = _lantern_Tensor_arccos__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_arccos_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_arccos_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_arccos_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_avg_pool1d_tensor_intarrayref_intarrayref_intarrayref_bool_bool)(void* self, void* kernel_size, void* stride, void* padding, void* ceil_mode, void* count_include_pad);
  HOST_API void* lantern_avg_pool1d_tensor_intarrayref_intarrayref_intarrayref_bool_bool(void* self, void* kernel_size, void* stride, void* padding, void* ceil_mode, void* count_include_pad) { LANTERN_CHECK_LOADED void* ret = _lantern_avg_pool1d_tensor_intarrayref_intarrayref_intarrayref_bool_bool(self, kernel_size, stride, padding, ceil_mode, count_include_pad); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_adaptive_avg_pool1d_tensor_intarrayref)(void* self, void* output_size);
  HOST_API void* lantern_adaptive_avg_pool1d_tensor_intarrayref(void* self, void* output_size) { LANTERN_CHECK_LOADED void* ret = _lantern_adaptive_avg_pool1d_tensor_intarrayref(self, output_size); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_adaptive_max_pool1d_tensor_intarrayref)(void* self, void* output_size);
  HOST_API void* lantern_adaptive_max_pool1d_tensor_intarrayref(void* self, void* output_size) { LANTERN_CHECK_LOADED void* ret = _lantern_adaptive_max_pool1d_tensor_intarrayref(self, output_size); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_add_tensor_tensor_scalar)(void* self, void* other, void* alpha);
  HOST_API void* lantern_add_tensor_tensor_scalar(void* self, void* other, void* alpha) { LANTERN_CHECK_LOADED void* ret = _lantern_add_tensor_tensor_scalar(self, other, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_add_tensor_tensor_scalar)(void* self, void* other, void* alpha);
  HOST_API void* lantern_Tensor_add_tensor_tensor_scalar(void* self, void* other, void* alpha) { void* ret = _lantern_Tensor_add_tensor_tensor_scalar(self, other, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_add__tensor_tensor_scalar)(void* self, void* other, void* alpha);
  HOST_API void* lantern_Tensor_add__tensor_tensor_scalar(void* self, void* other, void* alpha) { void* ret = _lantern_Tensor_add__tensor_tensor_scalar(self, other, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_add_out_tensor_tensor_tensor_scalar)(void* out, void* self, void* other, void* alpha);
  HOST_API void* lantern_add_out_tensor_tensor_tensor_scalar(void* out, void* self, void* other, void* alpha) { LANTERN_CHECK_LOADED void* ret = _lantern_add_out_tensor_tensor_tensor_scalar(out, self, other, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__add_relu_tensor_tensor_scalar)(void* self, void* other, void* alpha);
  HOST_API void* lantern__add_relu_tensor_tensor_scalar(void* self, void* other, void* alpha) { LANTERN_CHECK_LOADED void* ret = _lantern__add_relu_tensor_tensor_scalar(self, other, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__add_relu__tensor_tensor_scalar)(void* self, void* other, void* alpha);
  HOST_API void* lantern__add_relu__tensor_tensor_scalar(void* self, void* other, void* alpha) { LANTERN_CHECK_LOADED void* ret = _lantern__add_relu__tensor_tensor_scalar(self, other, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__add_relu_out_tensor_tensor_tensor_scalar)(void* out, void* self, void* other, void* alpha);
  HOST_API void* lantern__add_relu_out_tensor_tensor_tensor_scalar(void* out, void* self, void* other, void* alpha) { LANTERN_CHECK_LOADED void* ret = _lantern__add_relu_out_tensor_tensor_tensor_scalar(out, self, other, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__add_relu_tensor_scalar_scalar)(void* self, void* other, void* alpha);
  HOST_API void* lantern__add_relu_tensor_scalar_scalar(void* self, void* other, void* alpha) { LANTERN_CHECK_LOADED void* ret = _lantern__add_relu_tensor_scalar_scalar(self, other, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__add_relu__tensor_scalar_scalar)(void* self, void* other, void* alpha);
  HOST_API void* lantern__add_relu__tensor_scalar_scalar(void* self, void* other, void* alpha) { LANTERN_CHECK_LOADED void* ret = _lantern__add_relu__tensor_scalar_scalar(self, other, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_add_tensor_scalar_scalar)(void* self, void* other, void* alpha);
  HOST_API void* lantern_add_tensor_scalar_scalar(void* self, void* other, void* alpha) { LANTERN_CHECK_LOADED void* ret = _lantern_add_tensor_scalar_scalar(self, other, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_add_tensor_scalar_scalar)(void* self, void* other, void* alpha);
  HOST_API void* lantern_Tensor_add_tensor_scalar_scalar(void* self, void* other, void* alpha) { void* ret = _lantern_Tensor_add_tensor_scalar_scalar(self, other, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_add__tensor_scalar_scalar)(void* self, void* other, void* alpha);
  HOST_API void* lantern_Tensor_add__tensor_scalar_scalar(void* self, void* other, void* alpha) { void* ret = _lantern_Tensor_add__tensor_scalar_scalar(self, other, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_addmv_tensor_tensor_tensor_scalar_scalar)(void* self, void* mat, void* vec, void* beta, void* alpha);
  HOST_API void* lantern_addmv_tensor_tensor_tensor_scalar_scalar(void* self, void* mat, void* vec, void* beta, void* alpha) { LANTERN_CHECK_LOADED void* ret = _lantern_addmv_tensor_tensor_tensor_scalar_scalar(self, mat, vec, beta, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_addmv_tensor_tensor_tensor_scalar_scalar)(void* self, void* mat, void* vec, void* beta, void* alpha);
  HOST_API void* lantern_Tensor_addmv_tensor_tensor_tensor_scalar_scalar(void* self, void* mat, void* vec, void* beta, void* alpha) { void* ret = _lantern_Tensor_addmv_tensor_tensor_tensor_scalar_scalar(self, mat, vec, beta, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_addmv__tensor_tensor_tensor_scalar_scalar)(void* self, void* mat, void* vec, void* beta, void* alpha);
  HOST_API void* lantern_addmv__tensor_tensor_tensor_scalar_scalar(void* self, void* mat, void* vec, void* beta, void* alpha) { LANTERN_CHECK_LOADED void* ret = _lantern_addmv__tensor_tensor_tensor_scalar_scalar(self, mat, vec, beta, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_addmv__tensor_tensor_tensor_scalar_scalar)(void* self, void* mat, void* vec, void* beta, void* alpha);
  HOST_API void* lantern_Tensor_addmv__tensor_tensor_tensor_scalar_scalar(void* self, void* mat, void* vec, void* beta, void* alpha) { void* ret = _lantern_Tensor_addmv__tensor_tensor_tensor_scalar_scalar(self, mat, vec, beta, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_addmv_out_tensor_tensor_tensor_tensor_scalar_scalar)(void* out, void* self, void* mat, void* vec, void* beta, void* alpha);
  HOST_API void* lantern_addmv_out_tensor_tensor_tensor_tensor_scalar_scalar(void* out, void* self, void* mat, void* vec, void* beta, void* alpha) { LANTERN_CHECK_LOADED void* ret = _lantern_addmv_out_tensor_tensor_tensor_tensor_scalar_scalar(out, self, mat, vec, beta, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_addr_tensor_tensor_tensor_scalar_scalar)(void* self, void* vec1, void* vec2, void* beta, void* alpha);
  HOST_API void* lantern_addr_tensor_tensor_tensor_scalar_scalar(void* self, void* vec1, void* vec2, void* beta, void* alpha) { LANTERN_CHECK_LOADED void* ret = _lantern_addr_tensor_tensor_tensor_scalar_scalar(self, vec1, vec2, beta, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_addr_tensor_tensor_tensor_scalar_scalar)(void* self, void* vec1, void* vec2, void* beta, void* alpha);
  HOST_API void* lantern_Tensor_addr_tensor_tensor_tensor_scalar_scalar(void* self, void* vec1, void* vec2, void* beta, void* alpha) { void* ret = _lantern_Tensor_addr_tensor_tensor_tensor_scalar_scalar(self, vec1, vec2, beta, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_addr__tensor_tensor_tensor_scalar_scalar)(void* self, void* vec1, void* vec2, void* beta, void* alpha);
  HOST_API void* lantern_Tensor_addr__tensor_tensor_tensor_scalar_scalar(void* self, void* vec1, void* vec2, void* beta, void* alpha) { void* ret = _lantern_Tensor_addr__tensor_tensor_tensor_scalar_scalar(self, vec1, vec2, beta, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_addr_out_tensor_tensor_tensor_tensor_scalar_scalar)(void* out, void* self, void* vec1, void* vec2, void* beta, void* alpha);
  HOST_API void* lantern_addr_out_tensor_tensor_tensor_tensor_scalar_scalar(void* out, void* self, void* vec1, void* vec2, void* beta, void* alpha) { LANTERN_CHECK_LOADED void* ret = _lantern_addr_out_tensor_tensor_tensor_tensor_scalar_scalar(out, self, vec1, vec2, beta, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_affine_grid_generator_tensor_intarrayref_bool)(void* theta, void* size, void* align_corners);
  HOST_API void* lantern_affine_grid_generator_tensor_intarrayref_bool(void* theta, void* size, void* align_corners) { LANTERN_CHECK_LOADED void* ret = _lantern_affine_grid_generator_tensor_intarrayref_bool(theta, size, align_corners); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_affine_grid_generator_backward_tensor_intarrayref_bool)(void* grad, void* size, void* align_corners);
  HOST_API void* lantern_affine_grid_generator_backward_tensor_intarrayref_bool(void* grad, void* size, void* align_corners) { LANTERN_CHECK_LOADED void* ret = _lantern_affine_grid_generator_backward_tensor_intarrayref_bool(grad, size, align_corners); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_all_tensor_intt_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_all_tensor_intt_bool(void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_all_tensor_intt_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_all_tensor_intt_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_Tensor_all_tensor_intt_bool(void* self, void* dim, void* keepdim) { void* ret = _lantern_Tensor_all_tensor_intt_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_all_out_tensor_tensor_intt_bool)(void* out, void* self, void* dim, void* keepdim);
  HOST_API void* lantern_all_out_tensor_tensor_intt_bool(void* out, void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_all_out_tensor_tensor_intt_bool(out, self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_all_tensor_dimname_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_all_tensor_dimname_bool(void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_all_tensor_dimname_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_all_tensor_dimname_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_Tensor_all_tensor_dimname_bool(void* self, void* dim, void* keepdim) { void* ret = _lantern_Tensor_all_tensor_dimname_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_all_out_tensor_tensor_dimname_bool)(void* out, void* self, void* dim, void* keepdim);
  HOST_API void* lantern_all_out_tensor_tensor_dimname_bool(void* out, void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_all_out_tensor_tensor_dimname_bool(out, self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_allclose_tensor_tensor_double_double_bool)(void* self, void* other, void* rtol, void* atol, void* equal_nan);
  HOST_API void* lantern_allclose_tensor_tensor_double_double_bool(void* self, void* other, void* rtol, void* atol, void* equal_nan) { LANTERN_CHECK_LOADED void* ret = _lantern_allclose_tensor_tensor_double_double_bool(self, other, rtol, atol, equal_nan); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_allclose_tensor_tensor_double_double_bool)(void* self, void* other, void* rtol, void* atol, void* equal_nan);
  HOST_API void* lantern_Tensor_allclose_tensor_tensor_double_double_bool(void* self, void* other, void* rtol, void* atol, void* equal_nan) { void* ret = _lantern_Tensor_allclose_tensor_tensor_double_double_bool(self, other, rtol, atol, equal_nan); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_any_tensor_intt_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_any_tensor_intt_bool(void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_any_tensor_intt_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_any_tensor_intt_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_Tensor_any_tensor_intt_bool(void* self, void* dim, void* keepdim) { void* ret = _lantern_Tensor_any_tensor_intt_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_any_out_tensor_tensor_intt_bool)(void* out, void* self, void* dim, void* keepdim);
  HOST_API void* lantern_any_out_tensor_tensor_intt_bool(void* out, void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_any_out_tensor_tensor_intt_bool(out, self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_any_tensor_dimname_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_any_tensor_dimname_bool(void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_any_tensor_dimname_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_any_tensor_dimname_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_Tensor_any_tensor_dimname_bool(void* self, void* dim, void* keepdim) { void* ret = _lantern_Tensor_any_tensor_dimname_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_any_out_tensor_tensor_dimname_bool)(void* out, void* self, void* dim, void* keepdim);
  HOST_API void* lantern_any_out_tensor_tensor_dimname_bool(void* out, void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_any_out_tensor_tensor_dimname_bool(out, self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_arange_scalar_tensoroptions)(void* end, void* options);
  HOST_API void* lantern_arange_scalar_tensoroptions(void* end, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_arange_scalar_tensoroptions(end, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_arange_scalar_scalar_tensoroptions)(void* start, void* end, void* options);
  HOST_API void* lantern_arange_scalar_scalar_tensoroptions(void* start, void* end, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_arange_scalar_scalar_tensoroptions(start, end, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_arange_scalar_scalar_scalar_tensoroptions)(void* start, void* end, void* step, void* options);
  HOST_API void* lantern_arange_scalar_scalar_scalar_tensoroptions(void* start, void* end, void* step, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_arange_scalar_scalar_scalar_tensoroptions(start, end, step, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_arange_out_tensor_scalar)(void* out, void* end);
  HOST_API void* lantern_arange_out_tensor_scalar(void* out, void* end) { LANTERN_CHECK_LOADED void* ret = _lantern_arange_out_tensor_scalar(out, end); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_arange_out_tensor_scalar_scalar_scalar)(void* out, void* start, void* end, void* step);
  HOST_API void* lantern_arange_out_tensor_scalar_scalar_scalar(void* out, void* start, void* end, void* step) { LANTERN_CHECK_LOADED void* ret = _lantern_arange_out_tensor_scalar_scalar_scalar(out, start, end, step); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__dim_arange_tensor_intt)(void* like, void* dim);
  HOST_API void* lantern__dim_arange_tensor_intt(void* like, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern__dim_arange_tensor_intt(like, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_argmax_tensor_intt_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_argmax_tensor_intt_bool(void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_argmax_tensor_intt_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_argmax_tensor_intt_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_Tensor_argmax_tensor_intt_bool(void* self, void* dim, void* keepdim) { void* ret = _lantern_Tensor_argmax_tensor_intt_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_argmax_out_tensor_tensor_intt_bool)(void* out, void* self, void* dim, void* keepdim);
  HOST_API void* lantern_argmax_out_tensor_tensor_intt_bool(void* out, void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_argmax_out_tensor_tensor_intt_bool(out, self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_argmin_tensor_intt_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_argmin_tensor_intt_bool(void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_argmin_tensor_intt_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_argmin_tensor_intt_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_Tensor_argmin_tensor_intt_bool(void* self, void* dim, void* keepdim) { void* ret = _lantern_Tensor_argmin_tensor_intt_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_argmin_out_tensor_tensor_intt_bool)(void* out, void* self, void* dim, void* keepdim);
  HOST_API void* lantern_argmin_out_tensor_tensor_intt_bool(void* out, void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_argmin_out_tensor_tensor_intt_bool(out, self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_acosh_tensor)(void* self);
  HOST_API void* lantern_acosh_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_acosh_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_acosh_tensor)(void* self);
  HOST_API void* lantern_Tensor_acosh_tensor(void* self) { void* ret = _lantern_Tensor_acosh_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_acosh__tensor)(void* self);
  HOST_API void* lantern_acosh__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_acosh__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_acosh__tensor)(void* self);
  HOST_API void* lantern_Tensor_acosh__tensor(void* self) { void* ret = _lantern_Tensor_acosh__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_acosh_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_acosh_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_acosh_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_arccosh_tensor)(void* self);
  HOST_API void* lantern_arccosh_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_arccosh_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_arccosh_tensor)(void* self);
  HOST_API void* lantern_Tensor_arccosh_tensor(void* self) { void* ret = _lantern_Tensor_arccosh_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_arccosh__tensor)(void* self);
  HOST_API void* lantern_arccosh__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_arccosh__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_arccosh__tensor)(void* self);
  HOST_API void* lantern_Tensor_arccosh__tensor(void* self) { void* ret = _lantern_Tensor_arccosh__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_arccosh_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_arccosh_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_arccosh_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_asinh_tensor)(void* self);
  HOST_API void* lantern_asinh_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_asinh_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_asinh_tensor)(void* self);
  HOST_API void* lantern_Tensor_asinh_tensor(void* self) { void* ret = _lantern_Tensor_asinh_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_asinh__tensor)(void* self);
  HOST_API void* lantern_asinh__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_asinh__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_asinh__tensor)(void* self);
  HOST_API void* lantern_Tensor_asinh__tensor(void* self) { void* ret = _lantern_Tensor_asinh__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_asinh_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_asinh_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_asinh_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_arcsinh_tensor)(void* self);
  HOST_API void* lantern_arcsinh_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_arcsinh_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_arcsinh_tensor)(void* self);
  HOST_API void* lantern_Tensor_arcsinh_tensor(void* self) { void* ret = _lantern_Tensor_arcsinh_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_arcsinh__tensor)(void* self);
  HOST_API void* lantern_arcsinh__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_arcsinh__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_arcsinh__tensor)(void* self);
  HOST_API void* lantern_Tensor_arcsinh__tensor(void* self) { void* ret = _lantern_Tensor_arcsinh__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_arcsinh_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_arcsinh_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_arcsinh_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_atanh_tensor)(void* self);
  HOST_API void* lantern_atanh_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_atanh_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_atanh_tensor)(void* self);
  HOST_API void* lantern_Tensor_atanh_tensor(void* self) { void* ret = _lantern_Tensor_atanh_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_atanh__tensor)(void* self);
  HOST_API void* lantern_atanh__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_atanh__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_atanh__tensor)(void* self);
  HOST_API void* lantern_Tensor_atanh__tensor(void* self) { void* ret = _lantern_Tensor_atanh__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_atanh_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_atanh_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_atanh_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_arctanh_tensor)(void* self);
  HOST_API void* lantern_arctanh_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_arctanh_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_arctanh_tensor)(void* self);
  HOST_API void* lantern_Tensor_arctanh_tensor(void* self) { void* ret = _lantern_Tensor_arctanh_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_arctanh__tensor)(void* self);
  HOST_API void* lantern_arctanh__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_arctanh__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_arctanh__tensor)(void* self);
  HOST_API void* lantern_Tensor_arctanh__tensor(void* self) { void* ret = _lantern_Tensor_arctanh__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_arctanh_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_arctanh_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_arctanh_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_as_strided_tensor_intarrayref_intarrayref_intt)(void* self, void* size, void* stride, void* storage_offset);
  HOST_API void* lantern_as_strided_tensor_intarrayref_intarrayref_intt(void* self, void* size, void* stride, void* storage_offset) { LANTERN_CHECK_LOADED void* ret = _lantern_as_strided_tensor_intarrayref_intarrayref_intt(self, size, stride, storage_offset); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_as_strided_tensor_intarrayref_intarrayref_intt)(void* self, void* size, void* stride, void* storage_offset);
  HOST_API void* lantern_Tensor_as_strided_tensor_intarrayref_intarrayref_intt(void* self, void* size, void* stride, void* storage_offset) { void* ret = _lantern_Tensor_as_strided_tensor_intarrayref_intarrayref_intt(self, size, stride, storage_offset); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_as_strided__tensor_intarrayref_intarrayref_intt)(void* self, void* size, void* stride, void* storage_offset);
  HOST_API void* lantern_as_strided__tensor_intarrayref_intarrayref_intt(void* self, void* size, void* stride, void* storage_offset) { LANTERN_CHECK_LOADED void* ret = _lantern_as_strided__tensor_intarrayref_intarrayref_intt(self, size, stride, storage_offset); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_as_strided__tensor_intarrayref_intarrayref_intt)(void* self, void* size, void* stride, void* storage_offset);
  HOST_API void* lantern_Tensor_as_strided__tensor_intarrayref_intarrayref_intt(void* self, void* size, void* stride, void* storage_offset) { void* ret = _lantern_Tensor_as_strided__tensor_intarrayref_intarrayref_intt(self, size, stride, storage_offset); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_asin_tensor)(void* self);
  HOST_API void* lantern_asin_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_asin_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_asin_tensor)(void* self);
  HOST_API void* lantern_Tensor_asin_tensor(void* self) { void* ret = _lantern_Tensor_asin_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_asin__tensor)(void* self);
  HOST_API void* lantern_asin__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_asin__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_asin__tensor)(void* self);
  HOST_API void* lantern_Tensor_asin__tensor(void* self) { void* ret = _lantern_Tensor_asin__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_asin_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_asin_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_asin_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_arcsin_tensor)(void* self);
  HOST_API void* lantern_arcsin_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_arcsin_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_arcsin_tensor)(void* self);
  HOST_API void* lantern_Tensor_arcsin_tensor(void* self) { void* ret = _lantern_Tensor_arcsin_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_arcsin__tensor)(void* self);
  HOST_API void* lantern_arcsin__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_arcsin__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_arcsin__tensor)(void* self);
  HOST_API void* lantern_Tensor_arcsin__tensor(void* self) { void* ret = _lantern_Tensor_arcsin__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_arcsin_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_arcsin_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_arcsin_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_atan_tensor)(void* self);
  HOST_API void* lantern_atan_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_atan_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_atan_tensor)(void* self);
  HOST_API void* lantern_Tensor_atan_tensor(void* self) { void* ret = _lantern_Tensor_atan_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_atan__tensor)(void* self);
  HOST_API void* lantern_atan__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_atan__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_atan__tensor)(void* self);
  HOST_API void* lantern_Tensor_atan__tensor(void* self) { void* ret = _lantern_Tensor_atan__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_atan_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_atan_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_atan_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_arctan_tensor)(void* self);
  HOST_API void* lantern_arctan_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_arctan_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_arctan_tensor)(void* self);
  HOST_API void* lantern_Tensor_arctan_tensor(void* self) { void* ret = _lantern_Tensor_arctan_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_arctan__tensor)(void* self);
  HOST_API void* lantern_arctan__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_arctan__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_arctan__tensor)(void* self);
  HOST_API void* lantern_Tensor_arctan__tensor(void* self) { void* ret = _lantern_Tensor_arctan__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_arctan_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_arctan_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_arctan_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_atleast_1d_tensor)(void* self);
  HOST_API void* lantern_atleast_1d_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_atleast_1d_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_atleast_1d_tensorlist)(void* tensors);
  HOST_API void* lantern_atleast_1d_tensorlist(void* tensors) { LANTERN_CHECK_LOADED void* ret = _lantern_atleast_1d_tensorlist(tensors); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_atleast_2d_tensor)(void* self);
  HOST_API void* lantern_atleast_2d_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_atleast_2d_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_atleast_2d_tensorlist)(void* tensors);
  HOST_API void* lantern_atleast_2d_tensorlist(void* tensors) { LANTERN_CHECK_LOADED void* ret = _lantern_atleast_2d_tensorlist(tensors); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_atleast_3d_tensor)(void* self);
  HOST_API void* lantern_atleast_3d_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_atleast_3d_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_atleast_3d_tensorlist)(void* tensors);
  HOST_API void* lantern_atleast_3d_tensorlist(void* tensors) { LANTERN_CHECK_LOADED void* ret = _lantern_atleast_3d_tensorlist(tensors); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_baddbmm_tensor_tensor_tensor_scalar_scalar)(void* self, void* batch1, void* batch2, void* beta, void* alpha);
  HOST_API void* lantern_baddbmm_tensor_tensor_tensor_scalar_scalar(void* self, void* batch1, void* batch2, void* beta, void* alpha) { LANTERN_CHECK_LOADED void* ret = _lantern_baddbmm_tensor_tensor_tensor_scalar_scalar(self, batch1, batch2, beta, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_baddbmm_tensor_tensor_tensor_scalar_scalar)(void* self, void* batch1, void* batch2, void* beta, void* alpha);
  HOST_API void* lantern_Tensor_baddbmm_tensor_tensor_tensor_scalar_scalar(void* self, void* batch1, void* batch2, void* beta, void* alpha) { void* ret = _lantern_Tensor_baddbmm_tensor_tensor_tensor_scalar_scalar(self, batch1, batch2, beta, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_baddbmm__tensor_tensor_tensor_scalar_scalar)(void* self, void* batch1, void* batch2, void* beta, void* alpha);
  HOST_API void* lantern_Tensor_baddbmm__tensor_tensor_tensor_scalar_scalar(void* self, void* batch1, void* batch2, void* beta, void* alpha) { void* ret = _lantern_Tensor_baddbmm__tensor_tensor_tensor_scalar_scalar(self, batch1, batch2, beta, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_baddbmm_out_tensor_tensor_tensor_tensor_scalar_scalar)(void* out, void* self, void* batch1, void* batch2, void* beta, void* alpha);
  HOST_API void* lantern_baddbmm_out_tensor_tensor_tensor_tensor_scalar_scalar(void* out, void* self, void* batch1, void* batch2, void* beta, void* alpha) { LANTERN_CHECK_LOADED void* ret = _lantern_baddbmm_out_tensor_tensor_tensor_tensor_scalar_scalar(out, self, batch1, batch2, beta, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_bartlett_window_intt_tensoroptions)(void* window_length, void* options);
  HOST_API void* lantern_bartlett_window_intt_tensoroptions(void* window_length, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_bartlett_window_intt_tensoroptions(window_length, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_bartlett_window_intt_bool_tensoroptions)(void* window_length, void* periodic, void* options);
  HOST_API void* lantern_bartlett_window_intt_bool_tensoroptions(void* window_length, void* periodic, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_bartlett_window_intt_bool_tensoroptions(window_length, periodic, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_batch_norm_tensor_tensor_tensor_tensor_tensor_bool_double_double_bool)(void* input, void* weight, void* bias, void* running_mean, void* running_var, void* training, void* momentum, void* eps, void* cudnn_enabled);
  HOST_API void* lantern_batch_norm_tensor_tensor_tensor_tensor_tensor_bool_double_double_bool(void* input, void* weight, void* bias, void* running_mean, void* running_var, void* training, void* momentum, void* eps, void* cudnn_enabled) { LANTERN_CHECK_LOADED void* ret = _lantern_batch_norm_tensor_tensor_tensor_tensor_tensor_bool_double_double_bool(input, weight, bias, running_mean, running_var, training, momentum, eps, cudnn_enabled); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_quantized_batch_norm_tensor_tensor_tensor_tensor_tensor_double_double_intt)(void* input, void* weight, void* bias, void* mean, void* var, void* eps, void* output_scale, void* output_zero_point);
  HOST_API void* lantern_quantized_batch_norm_tensor_tensor_tensor_tensor_tensor_double_double_intt(void* input, void* weight, void* bias, void* mean, void* var, void* eps, void* output_scale, void* output_zero_point) { LANTERN_CHECK_LOADED void* ret = _lantern_quantized_batch_norm_tensor_tensor_tensor_tensor_tensor_double_double_intt(input, weight, bias, mean, var, eps, output_scale, output_zero_point); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__batch_norm_impl_index_tensor_tensor_tensor_tensor_tensor_bool_double_double_bool)(void* input, void* weight, void* bias, void* running_mean, void* running_var, void* training, void* momentum, void* eps, void* cudnn_enabled);
  HOST_API void* lantern__batch_norm_impl_index_tensor_tensor_tensor_tensor_tensor_bool_double_double_bool(void* input, void* weight, void* bias, void* running_mean, void* running_var, void* training, void* momentum, void* eps, void* cudnn_enabled) { LANTERN_CHECK_LOADED void* ret = _lantern__batch_norm_impl_index_tensor_tensor_tensor_tensor_tensor_bool_double_double_bool(input, weight, bias, running_mean, running_var, training, momentum, eps, cudnn_enabled); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__batch_norm_impl_index_backward_intt_tensor_tensor_tensor_tensor_tensor_tensor_tensor_bool_double_stdarraybool_tensor)(void* impl_index, void* input, void* grad_output, void* weight, void* running_mean, void* running_var, void* save_mean, void* save_var_transform, void* train, void* eps, void* output_mask, void* reservedSpace);
  HOST_API void* lantern__batch_norm_impl_index_backward_intt_tensor_tensor_tensor_tensor_tensor_tensor_tensor_bool_double_stdarraybool_tensor(void* impl_index, void* input, void* grad_output, void* weight, void* running_mean, void* running_var, void* save_mean, void* save_var_transform, void* train, void* eps, void* output_mask, void* reservedSpace) { LANTERN_CHECK_LOADED void* ret = _lantern__batch_norm_impl_index_backward_intt_tensor_tensor_tensor_tensor_tensor_tensor_tensor_bool_double_stdarraybool_tensor(impl_index, input, grad_output, weight, running_mean, running_var, save_mean, save_var_transform, train, eps, output_mask, reservedSpace); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_bernoulli_tensor_generator)(void* self, void* generator);
  HOST_API void* lantern_bernoulli_tensor_generator(void* self, void* generator) { LANTERN_CHECK_LOADED void* ret = _lantern_bernoulli_tensor_generator(self, generator); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_bernoulli_tensor_generator)(void* self, void* generator);
  HOST_API void* lantern_Tensor_bernoulli_tensor_generator(void* self, void* generator) { void* ret = _lantern_Tensor_bernoulli_tensor_generator(self, generator); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_bernoulli_out_tensor_tensor_generator)(void* out, void* self, void* generator);
  HOST_API void* lantern_bernoulli_out_tensor_tensor_generator(void* out, void* self, void* generator) { LANTERN_CHECK_LOADED void* ret = _lantern_bernoulli_out_tensor_tensor_generator(out, self, generator); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_bernoulli__tensor_tensor_generator)(void* self, void* p, void* generator);
  HOST_API void* lantern_Tensor_bernoulli__tensor_tensor_generator(void* self, void* p, void* generator) { void* ret = _lantern_Tensor_bernoulli__tensor_tensor_generator(self, p, generator); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_bernoulli__tensor_double_generator)(void* self, void* p, void* generator);
  HOST_API void* lantern_Tensor_bernoulli__tensor_double_generator(void* self, void* p, void* generator) { void* ret = _lantern_Tensor_bernoulli__tensor_double_generator(self, p, generator); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_bernoulli_tensor_double_generator)(void* self, void* p, void* generator);
  HOST_API void* lantern_bernoulli_tensor_double_generator(void* self, void* p, void* generator) { LANTERN_CHECK_LOADED void* ret = _lantern_bernoulli_tensor_double_generator(self, p, generator); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_bernoulli_tensor_double_generator)(void* self, void* p, void* generator);
  HOST_API void* lantern_Tensor_bernoulli_tensor_double_generator(void* self, void* p, void* generator) { void* ret = _lantern_Tensor_bernoulli_tensor_double_generator(self, p, generator); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_bilinear_tensor_tensor_tensor_tensor)(void* input1, void* input2, void* weight, void* bias);
  HOST_API void* lantern_bilinear_tensor_tensor_tensor_tensor(void* input1, void* input2, void* weight, void* bias) { LANTERN_CHECK_LOADED void* ret = _lantern_bilinear_tensor_tensor_tensor_tensor(input1, input2, weight, bias); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_binary_cross_entropy_tensor_tensor_tensor_intt)(void* self, void* target, void* weight, void* reduction);
  HOST_API void* lantern_binary_cross_entropy_tensor_tensor_tensor_intt(void* self, void* target, void* weight, void* reduction) { LANTERN_CHECK_LOADED void* ret = _lantern_binary_cross_entropy_tensor_tensor_tensor_intt(self, target, weight, reduction); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_binary_cross_entropy_out_tensor_tensor_tensor_tensor_intt)(void* out, void* self, void* target, void* weight, void* reduction);
  HOST_API void* lantern_binary_cross_entropy_out_tensor_tensor_tensor_tensor_intt(void* out, void* self, void* target, void* weight, void* reduction) { LANTERN_CHECK_LOADED void* ret = _lantern_binary_cross_entropy_out_tensor_tensor_tensor_tensor_intt(out, self, target, weight, reduction); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_binary_cross_entropy_backward_tensor_tensor_tensor_tensor_intt)(void* grad_output, void* self, void* target, void* weight, void* reduction);
  HOST_API void* lantern_binary_cross_entropy_backward_tensor_tensor_tensor_tensor_intt(void* grad_output, void* self, void* target, void* weight, void* reduction) { LANTERN_CHECK_LOADED void* ret = _lantern_binary_cross_entropy_backward_tensor_tensor_tensor_tensor_intt(grad_output, self, target, weight, reduction); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_binary_cross_entropy_backward_out_tensor_tensor_tensor_tensor_tensor_intt)(void* grad_input, void* grad_output, void* self, void* target, void* weight, void* reduction);
  HOST_API void* lantern_binary_cross_entropy_backward_out_tensor_tensor_tensor_tensor_tensor_intt(void* grad_input, void* grad_output, void* self, void* target, void* weight, void* reduction) { LANTERN_CHECK_LOADED void* ret = _lantern_binary_cross_entropy_backward_out_tensor_tensor_tensor_tensor_tensor_intt(grad_input, grad_output, self, target, weight, reduction); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_binary_cross_entropy_with_logits_tensor_tensor_tensor_tensor_intt)(void* self, void* target, void* weight, void* pos_weight, void* reduction);
  HOST_API void* lantern_binary_cross_entropy_with_logits_tensor_tensor_tensor_tensor_intt(void* self, void* target, void* weight, void* pos_weight, void* reduction) { LANTERN_CHECK_LOADED void* ret = _lantern_binary_cross_entropy_with_logits_tensor_tensor_tensor_tensor_intt(self, target, weight, pos_weight, reduction); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_bincount_tensor_tensor_intt)(void* self, void* weights, void* minlength);
  HOST_API void* lantern_bincount_tensor_tensor_intt(void* self, void* weights, void* minlength) { LANTERN_CHECK_LOADED void* ret = _lantern_bincount_tensor_tensor_intt(self, weights, minlength); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_bincount_tensor_tensor_intt)(void* self, void* weights, void* minlength);
  HOST_API void* lantern_Tensor_bincount_tensor_tensor_intt(void* self, void* weights, void* minlength) { void* ret = _lantern_Tensor_bincount_tensor_tensor_intt(self, weights, minlength); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_bitwise_not_tensor)(void* self);
  HOST_API void* lantern_bitwise_not_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_bitwise_not_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_bitwise_not_tensor)(void* self);
  HOST_API void* lantern_Tensor_bitwise_not_tensor(void* self) { void* ret = _lantern_Tensor_bitwise_not_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_bitwise_not__tensor)(void* self);
  HOST_API void* lantern_Tensor_bitwise_not__tensor(void* self) { void* ret = _lantern_Tensor_bitwise_not__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_bitwise_not_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_bitwise_not_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_bitwise_not_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_copysign_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_copysign_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_copysign_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_copysign_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_copysign_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_copysign_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_copysign_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_copysign_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_copysign_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_copysign__tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_copysign__tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_copysign__tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_copysign_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_copysign_tensor_scalar(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_copysign_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_copysign_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_copysign_tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_copysign_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_copysign__tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_copysign__tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_copysign__tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_copysign_out_tensor_tensor_scalar)(void* out, void* self, void* other);
  HOST_API void* lantern_copysign_out_tensor_tensor_scalar(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_copysign_out_tensor_tensor_scalar(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_logical_not_tensor)(void* self);
  HOST_API void* lantern_logical_not_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_logical_not_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_logical_not_tensor)(void* self);
  HOST_API void* lantern_Tensor_logical_not_tensor(void* self) { void* ret = _lantern_Tensor_logical_not_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_logical_not__tensor)(void* self);
  HOST_API void* lantern_Tensor_logical_not__tensor(void* self) { void* ret = _lantern_Tensor_logical_not__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_logical_not_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_logical_not_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_logical_not_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_logical_xor_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_logical_xor_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_logical_xor_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_logical_xor_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_logical_xor_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_logical_xor_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_logical_xor__tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_logical_xor__tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_logical_xor__tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_logical_xor_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_logical_xor_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_logical_xor_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_logical_and_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_logical_and_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_logical_and_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_logical_and_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_logical_and_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_logical_and_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_logical_and__tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_logical_and__tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_logical_and__tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_logical_and_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_logical_and_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_logical_and_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_logical_or_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_logical_or_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_logical_or_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_logical_or_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_logical_or_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_logical_or_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_logical_or__tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_logical_or__tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_logical_or__tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_logical_or_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_logical_or_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_logical_or_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_blackman_window_intt_tensoroptions)(void* window_length, void* options);
  HOST_API void* lantern_blackman_window_intt_tensoroptions(void* window_length, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_blackman_window_intt_tensoroptions(window_length, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_blackman_window_intt_bool_tensoroptions)(void* window_length, void* periodic, void* options);
  HOST_API void* lantern_blackman_window_intt_bool_tensoroptions(void* window_length, void* periodic, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_blackman_window_intt_bool_tensoroptions(window_length, periodic, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_bmm_tensor_tensor)(void* self, void* mat2);
  HOST_API void* lantern_bmm_tensor_tensor(void* self, void* mat2) { LANTERN_CHECK_LOADED void* ret = _lantern_bmm_tensor_tensor(self, mat2); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_bmm_tensor_tensor)(void* self, void* mat2);
  HOST_API void* lantern_Tensor_bmm_tensor_tensor(void* self, void* mat2) { void* ret = _lantern_Tensor_bmm_tensor_tensor(self, mat2); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_bmm_out_tensor_tensor_tensor)(void* out, void* self, void* mat2);
  HOST_API void* lantern_bmm_out_tensor_tensor_tensor(void* out, void* self, void* mat2) { LANTERN_CHECK_LOADED void* ret = _lantern_bmm_out_tensor_tensor_tensor(out, self, mat2); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_broadcast_tensors_tensorlist)(void* tensors);
  HOST_API void* lantern_broadcast_tensors_tensorlist(void* tensors) { LANTERN_CHECK_LOADED void* ret = _lantern_broadcast_tensors_tensorlist(tensors); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_broadcast_to_tensor_intarrayref)(void* self, void* size);
  HOST_API void* lantern_broadcast_to_tensor_intarrayref(void* self, void* size) { LANTERN_CHECK_LOADED void* ret = _lantern_broadcast_to_tensor_intarrayref(self, size); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_broadcast_to_tensor_intarrayref)(void* self, void* size);
  HOST_API void* lantern_Tensor_broadcast_to_tensor_intarrayref(void* self, void* size) { void* ret = _lantern_Tensor_broadcast_to_tensor_intarrayref(self, size); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__sparse_broadcast_to_tensor_intarrayref)(void* self, void* size);
  HOST_API void* lantern__sparse_broadcast_to_tensor_intarrayref(void* self, void* size) { LANTERN_CHECK_LOADED void* ret = _lantern__sparse_broadcast_to_tensor_intarrayref(self, size); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cat_constitensorlistref_intt)(void* tensors, void* dim);
  HOST_API void* lantern_cat_constitensorlistref_intt(void* tensors, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_cat_constitensorlistref_intt(tensors, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cat_out_tensor_constitensorlistref_intt)(void* out, void* tensors, void* dim);
  HOST_API void* lantern_cat_out_tensor_constitensorlistref_intt(void* out, void* tensors, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_cat_out_tensor_constitensorlistref_intt(out, tensors, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cat_tensorlist_dimname)(void* tensors, void* dim);
  HOST_API void* lantern_cat_tensorlist_dimname(void* tensors, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_cat_tensorlist_dimname(tensors, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cat_out_tensor_tensorlist_dimname)(void* out, void* tensors, void* dim);
  HOST_API void* lantern_cat_out_tensor_tensorlist_dimname(void* out, void* tensors, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_cat_out_tensor_tensorlist_dimname(out, tensors, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_concat_tensorlist_intt)(void* tensors, void* dim);
  HOST_API void* lantern_concat_tensorlist_intt(void* tensors, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_concat_tensorlist_intt(tensors, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_concat_out_tensor_tensorlist_intt)(void* out, void* tensors, void* dim);
  HOST_API void* lantern_concat_out_tensor_tensorlist_intt(void* out, void* tensors, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_concat_out_tensor_tensorlist_intt(out, tensors, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_concat_tensorlist_dimname)(void* tensors, void* dim);
  HOST_API void* lantern_concat_tensorlist_dimname(void* tensors, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_concat_tensorlist_dimname(tensors, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_concat_out_tensor_tensorlist_dimname)(void* out, void* tensors, void* dim);
  HOST_API void* lantern_concat_out_tensor_tensorlist_dimname(void* out, void* tensors, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_concat_out_tensor_tensorlist_dimname(out, tensors, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_concatenate_tensorlist_intt)(void* tensors, void* dim);
  HOST_API void* lantern_concatenate_tensorlist_intt(void* tensors, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_concatenate_tensorlist_intt(tensors, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_concatenate_out_tensor_tensorlist_intt)(void* out, void* tensors, void* dim);
  HOST_API void* lantern_concatenate_out_tensor_tensorlist_intt(void* out, void* tensors, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_concatenate_out_tensor_tensorlist_intt(out, tensors, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_concatenate_tensorlist_dimname)(void* tensors, void* dim);
  HOST_API void* lantern_concatenate_tensorlist_dimname(void* tensors, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_concatenate_tensorlist_dimname(tensors, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_concatenate_out_tensor_tensorlist_dimname)(void* out, void* tensors, void* dim);
  HOST_API void* lantern_concatenate_out_tensor_tensorlist_dimname(void* out, void* tensors, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_concatenate_out_tensor_tensorlist_dimname(out, tensors, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_block_diag_tensorlist)(void* tensors);
  HOST_API void* lantern_block_diag_tensorlist(void* tensors) { LANTERN_CHECK_LOADED void* ret = _lantern_block_diag_tensorlist(tensors); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_ceil_tensor)(void* self);
  HOST_API void* lantern_ceil_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_ceil_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_ceil_tensor)(void* self);
  HOST_API void* lantern_Tensor_ceil_tensor(void* self) { void* ret = _lantern_Tensor_ceil_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_ceil__tensor)(void* self);
  HOST_API void* lantern_ceil__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_ceil__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_ceil__tensor)(void* self);
  HOST_API void* lantern_Tensor_ceil__tensor(void* self) { void* ret = _lantern_Tensor_ceil__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_ceil_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_ceil_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_ceil_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_chain_matmul_tensorlist)(void* matrices);
  HOST_API void* lantern_chain_matmul_tensorlist(void* matrices) { LANTERN_CHECK_LOADED void* ret = _lantern_chain_matmul_tensorlist(matrices); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_chain_matmul_out_tensor_tensorlist)(void* out, void* matrices);
  HOST_API void* lantern_chain_matmul_out_tensor_tensorlist(void* out, void* matrices) { LANTERN_CHECK_LOADED void* ret = _lantern_chain_matmul_out_tensor_tensorlist(out, matrices); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_unsafe_chunk_tensor_intt_intt)(void* self, void* chunks, void* dim);
  HOST_API void* lantern_unsafe_chunk_tensor_intt_intt(void* self, void* chunks, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_unsafe_chunk_tensor_intt_intt(self, chunks, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_unsafe_chunk_tensor_intt_intt)(void* self, void* chunks, void* dim);
  HOST_API void* lantern_Tensor_unsafe_chunk_tensor_intt_intt(void* self, void* chunks, void* dim) { void* ret = _lantern_Tensor_unsafe_chunk_tensor_intt_intt(self, chunks, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_chunk_tensor_intt_intt)(void* self, void* chunks, void* dim);
  HOST_API void* lantern_chunk_tensor_intt_intt(void* self, void* chunks, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_chunk_tensor_intt_intt(self, chunks, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_chunk_tensor_intt_intt)(void* self, void* chunks, void* dim);
  HOST_API void* lantern_Tensor_chunk_tensor_intt_intt(void* self, void* chunks, void* dim) { void* ret = _lantern_Tensor_chunk_tensor_intt_intt(self, chunks, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_tensor_split_tensor_intt_intt)(void* self, void* sections, void* dim);
  HOST_API void* lantern_tensor_split_tensor_intt_intt(void* self, void* sections, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_tensor_split_tensor_intt_intt(self, sections, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_tensor_split_tensor_intt_intt)(void* self, void* sections, void* dim);
  HOST_API void* lantern_Tensor_tensor_split_tensor_intt_intt(void* self, void* sections, void* dim) { void* ret = _lantern_Tensor_tensor_split_tensor_intt_intt(self, sections, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_tensor_split_tensor_intarrayref_intt)(void* self, void* indices, void* dim);
  HOST_API void* lantern_tensor_split_tensor_intarrayref_intt(void* self, void* indices, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_tensor_split_tensor_intarrayref_intt(self, indices, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_tensor_split_tensor_intarrayref_intt)(void* self, void* indices, void* dim);
  HOST_API void* lantern_Tensor_tensor_split_tensor_intarrayref_intt(void* self, void* indices, void* dim) { void* ret = _lantern_Tensor_tensor_split_tensor_intarrayref_intt(self, indices, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_tensor_split_tensor_tensor_intt)(void* self, void* tensor_indices_or_sections, void* dim);
  HOST_API void* lantern_tensor_split_tensor_tensor_intt(void* self, void* tensor_indices_or_sections, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_tensor_split_tensor_tensor_intt(self, tensor_indices_or_sections, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_tensor_split_tensor_tensor_intt)(void* self, void* tensor_indices_or_sections, void* dim);
  HOST_API void* lantern_Tensor_tensor_split_tensor_tensor_intt(void* self, void* tensor_indices_or_sections, void* dim) { void* ret = _lantern_Tensor_tensor_split_tensor_tensor_intt(self, tensor_indices_or_sections, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_clamp_tensor_scalar_scalar)(void* self, void* min, void* max);
  HOST_API void* lantern_clamp_tensor_scalar_scalar(void* self, void* min, void* max) { LANTERN_CHECK_LOADED void* ret = _lantern_clamp_tensor_scalar_scalar(self, min, max); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_clamp_tensor_scalar_scalar)(void* self, void* min, void* max);
  HOST_API void* lantern_Tensor_clamp_tensor_scalar_scalar(void* self, void* min, void* max) { void* ret = _lantern_Tensor_clamp_tensor_scalar_scalar(self, min, max); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_clamp_tensor_tensor_tensor)(void* self, void* min, void* max);
  HOST_API void* lantern_clamp_tensor_tensor_tensor(void* self, void* min, void* max) { LANTERN_CHECK_LOADED void* ret = _lantern_clamp_tensor_tensor_tensor(self, min, max); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_clamp_tensor_tensor_tensor)(void* self, void* min, void* max);
  HOST_API void* lantern_Tensor_clamp_tensor_tensor_tensor(void* self, void* min, void* max) { void* ret = _lantern_Tensor_clamp_tensor_tensor_tensor(self, min, max); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_clamp__tensor_scalar_scalar)(void* self, void* min, void* max);
  HOST_API void* lantern_clamp__tensor_scalar_scalar(void* self, void* min, void* max) { LANTERN_CHECK_LOADED void* ret = _lantern_clamp__tensor_scalar_scalar(self, min, max); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_clamp__tensor_scalar_scalar)(void* self, void* min, void* max);
  HOST_API void* lantern_Tensor_clamp__tensor_scalar_scalar(void* self, void* min, void* max) { void* ret = _lantern_Tensor_clamp__tensor_scalar_scalar(self, min, max); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_clamp__tensor_tensor_tensor)(void* self, void* min, void* max);
  HOST_API void* lantern_clamp__tensor_tensor_tensor(void* self, void* min, void* max) { LANTERN_CHECK_LOADED void* ret = _lantern_clamp__tensor_tensor_tensor(self, min, max); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_clamp__tensor_tensor_tensor)(void* self, void* min, void* max);
  HOST_API void* lantern_Tensor_clamp__tensor_tensor_tensor(void* self, void* min, void* max) { void* ret = _lantern_Tensor_clamp__tensor_tensor_tensor(self, min, max); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_clamp_out_tensor_tensor_scalar_scalar)(void* out, void* self, void* min, void* max);
  HOST_API void* lantern_clamp_out_tensor_tensor_scalar_scalar(void* out, void* self, void* min, void* max) { LANTERN_CHECK_LOADED void* ret = _lantern_clamp_out_tensor_tensor_scalar_scalar(out, self, min, max); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_clamp_out_tensor_tensor_tensor_tensor)(void* out, void* self, void* min, void* max);
  HOST_API void* lantern_clamp_out_tensor_tensor_tensor_tensor(void* out, void* self, void* min, void* max) { LANTERN_CHECK_LOADED void* ret = _lantern_clamp_out_tensor_tensor_tensor_tensor(out, self, min, max); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_clamp_max_tensor_scalar)(void* self, void* max);
  HOST_API void* lantern_clamp_max_tensor_scalar(void* self, void* max) { LANTERN_CHECK_LOADED void* ret = _lantern_clamp_max_tensor_scalar(self, max); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_clamp_max_tensor_scalar)(void* self, void* max);
  HOST_API void* lantern_Tensor_clamp_max_tensor_scalar(void* self, void* max) { void* ret = _lantern_Tensor_clamp_max_tensor_scalar(self, max); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_clamp_max_tensor_tensor)(void* self, void* max);
  HOST_API void* lantern_clamp_max_tensor_tensor(void* self, void* max) { LANTERN_CHECK_LOADED void* ret = _lantern_clamp_max_tensor_tensor(self, max); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_clamp_max_tensor_tensor)(void* self, void* max);
  HOST_API void* lantern_Tensor_clamp_max_tensor_tensor(void* self, void* max) { void* ret = _lantern_Tensor_clamp_max_tensor_tensor(self, max); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_clamp_max__tensor_scalar)(void* self, void* max);
  HOST_API void* lantern_clamp_max__tensor_scalar(void* self, void* max) { LANTERN_CHECK_LOADED void* ret = _lantern_clamp_max__tensor_scalar(self, max); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_clamp_max__tensor_scalar)(void* self, void* max);
  HOST_API void* lantern_Tensor_clamp_max__tensor_scalar(void* self, void* max) { void* ret = _lantern_Tensor_clamp_max__tensor_scalar(self, max); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_clamp_max__tensor_tensor)(void* self, void* max);
  HOST_API void* lantern_clamp_max__tensor_tensor(void* self, void* max) { LANTERN_CHECK_LOADED void* ret = _lantern_clamp_max__tensor_tensor(self, max); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_clamp_max__tensor_tensor)(void* self, void* max);
  HOST_API void* lantern_Tensor_clamp_max__tensor_tensor(void* self, void* max) { void* ret = _lantern_Tensor_clamp_max__tensor_tensor(self, max); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_clamp_max_out_tensor_tensor_scalar)(void* out, void* self, void* max);
  HOST_API void* lantern_clamp_max_out_tensor_tensor_scalar(void* out, void* self, void* max) { LANTERN_CHECK_LOADED void* ret = _lantern_clamp_max_out_tensor_tensor_scalar(out, self, max); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_clamp_max_out_tensor_tensor_tensor)(void* out, void* self, void* max);
  HOST_API void* lantern_clamp_max_out_tensor_tensor_tensor(void* out, void* self, void* max) { LANTERN_CHECK_LOADED void* ret = _lantern_clamp_max_out_tensor_tensor_tensor(out, self, max); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_clamp_min_tensor_scalar)(void* self, void* min);
  HOST_API void* lantern_clamp_min_tensor_scalar(void* self, void* min) { LANTERN_CHECK_LOADED void* ret = _lantern_clamp_min_tensor_scalar(self, min); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_clamp_min_tensor_scalar)(void* self, void* min);
  HOST_API void* lantern_Tensor_clamp_min_tensor_scalar(void* self, void* min) { void* ret = _lantern_Tensor_clamp_min_tensor_scalar(self, min); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_clamp_min_tensor_tensor)(void* self, void* min);
  HOST_API void* lantern_clamp_min_tensor_tensor(void* self, void* min) { LANTERN_CHECK_LOADED void* ret = _lantern_clamp_min_tensor_tensor(self, min); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_clamp_min_tensor_tensor)(void* self, void* min);
  HOST_API void* lantern_Tensor_clamp_min_tensor_tensor(void* self, void* min) { void* ret = _lantern_Tensor_clamp_min_tensor_tensor(self, min); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_clamp_min__tensor_scalar)(void* self, void* min);
  HOST_API void* lantern_clamp_min__tensor_scalar(void* self, void* min) { LANTERN_CHECK_LOADED void* ret = _lantern_clamp_min__tensor_scalar(self, min); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_clamp_min__tensor_scalar)(void* self, void* min);
  HOST_API void* lantern_Tensor_clamp_min__tensor_scalar(void* self, void* min) { void* ret = _lantern_Tensor_clamp_min__tensor_scalar(self, min); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_clamp_min__tensor_tensor)(void* self, void* min);
  HOST_API void* lantern_clamp_min__tensor_tensor(void* self, void* min) { LANTERN_CHECK_LOADED void* ret = _lantern_clamp_min__tensor_tensor(self, min); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_clamp_min__tensor_tensor)(void* self, void* min);
  HOST_API void* lantern_Tensor_clamp_min__tensor_tensor(void* self, void* min) { void* ret = _lantern_Tensor_clamp_min__tensor_tensor(self, min); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_clamp_min_out_tensor_tensor_scalar)(void* out, void* self, void* min);
  HOST_API void* lantern_clamp_min_out_tensor_tensor_scalar(void* out, void* self, void* min) { LANTERN_CHECK_LOADED void* ret = _lantern_clamp_min_out_tensor_tensor_scalar(out, self, min); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_clamp_min_out_tensor_tensor_tensor)(void* out, void* self, void* min);
  HOST_API void* lantern_clamp_min_out_tensor_tensor_tensor(void* out, void* self, void* min) { LANTERN_CHECK_LOADED void* ret = _lantern_clamp_min_out_tensor_tensor_tensor(out, self, min); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_clip_tensor_scalar_scalar)(void* self, void* min, void* max);
  HOST_API void* lantern_clip_tensor_scalar_scalar(void* self, void* min, void* max) { LANTERN_CHECK_LOADED void* ret = _lantern_clip_tensor_scalar_scalar(self, min, max); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_clip_tensor_scalar_scalar)(void* self, void* min, void* max);
  HOST_API void* lantern_Tensor_clip_tensor_scalar_scalar(void* self, void* min, void* max) { void* ret = _lantern_Tensor_clip_tensor_scalar_scalar(self, min, max); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_clip_tensor_tensor_tensor)(void* self, void* min, void* max);
  HOST_API void* lantern_clip_tensor_tensor_tensor(void* self, void* min, void* max) { LANTERN_CHECK_LOADED void* ret = _lantern_clip_tensor_tensor_tensor(self, min, max); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_clip_tensor_tensor_tensor)(void* self, void* min, void* max);
  HOST_API void* lantern_Tensor_clip_tensor_tensor_tensor(void* self, void* min, void* max) { void* ret = _lantern_Tensor_clip_tensor_tensor_tensor(self, min, max); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_clip__tensor_scalar_scalar)(void* self, void* min, void* max);
  HOST_API void* lantern_clip__tensor_scalar_scalar(void* self, void* min, void* max) { LANTERN_CHECK_LOADED void* ret = _lantern_clip__tensor_scalar_scalar(self, min, max); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_clip__tensor_scalar_scalar)(void* self, void* min, void* max);
  HOST_API void* lantern_Tensor_clip__tensor_scalar_scalar(void* self, void* min, void* max) { void* ret = _lantern_Tensor_clip__tensor_scalar_scalar(self, min, max); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_clip__tensor_tensor_tensor)(void* self, void* min, void* max);
  HOST_API void* lantern_clip__tensor_tensor_tensor(void* self, void* min, void* max) { LANTERN_CHECK_LOADED void* ret = _lantern_clip__tensor_tensor_tensor(self, min, max); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_clip__tensor_tensor_tensor)(void* self, void* min, void* max);
  HOST_API void* lantern_Tensor_clip__tensor_tensor_tensor(void* self, void* min, void* max) { void* ret = _lantern_Tensor_clip__tensor_tensor_tensor(self, min, max); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_clip_out_tensor_tensor_scalar_scalar)(void* out, void* self, void* min, void* max);
  HOST_API void* lantern_clip_out_tensor_tensor_scalar_scalar(void* out, void* self, void* min, void* max) { LANTERN_CHECK_LOADED void* ret = _lantern_clip_out_tensor_tensor_scalar_scalar(out, self, min, max); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_clip_out_tensor_tensor_tensor_tensor)(void* out, void* self, void* min, void* max);
  HOST_API void* lantern_clip_out_tensor_tensor_tensor_tensor(void* out, void* self, void* min, void* max) { LANTERN_CHECK_LOADED void* ret = _lantern_clip_out_tensor_tensor_tensor_tensor(out, self, min, max); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cudnn_is_acceptable_tensor)(void* self);
  HOST_API void* lantern_cudnn_is_acceptable_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_cudnn_is_acceptable_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_complex_tensor_tensor)(void* real, void* imag);
  HOST_API void* lantern_complex_tensor_tensor(void* real, void* imag) { LANTERN_CHECK_LOADED void* ret = _lantern_complex_tensor_tensor(real, imag); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_complex_out_tensor_tensor_tensor)(void* out, void* real, void* imag);
  HOST_API void* lantern_complex_out_tensor_tensor_tensor(void* out, void* real, void* imag) { LANTERN_CHECK_LOADED void* ret = _lantern_complex_out_tensor_tensor_tensor(out, real, imag); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_polar_tensor_tensor)(void* abs, void* angle);
  HOST_API void* lantern_polar_tensor_tensor(void* abs, void* angle) { LANTERN_CHECK_LOADED void* ret = _lantern_polar_tensor_tensor(abs, angle); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_polar_out_tensor_tensor_tensor)(void* out, void* abs, void* angle);
  HOST_API void* lantern_polar_out_tensor_tensor_tensor(void* out, void* abs, void* angle) { LANTERN_CHECK_LOADED void* ret = _lantern_polar_out_tensor_tensor_tensor(out, abs, angle); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_constant_pad_nd_tensor_intarrayref_scalar)(void* self, void* pad, void* value);
  HOST_API void* lantern_constant_pad_nd_tensor_intarrayref_scalar(void* self, void* pad, void* value) { LANTERN_CHECK_LOADED void* ret = _lantern_constant_pad_nd_tensor_intarrayref_scalar(self, pad, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_contiguous_tensor_memoryformat)(void* self, void* memory_format);
  HOST_API void* lantern_Tensor_contiguous_tensor_memoryformat(void* self, void* memory_format) { void* ret = _lantern_Tensor_contiguous_tensor_memoryformat(self, memory_format); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_convolution_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_bool_intarrayref_intt)(void* input, void* weight, void* bias, void* stride, void* padding, void* dilation, void* transposed, void* output_padding, void* groups);
  HOST_API void* lantern_convolution_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_bool_intarrayref_intt(void* input, void* weight, void* bias, void* stride, void* padding, void* dilation, void* transposed, void* output_padding, void* groups) { LANTERN_CHECK_LOADED void* ret = _lantern_convolution_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_bool_intarrayref_intt(input, weight, bias, stride, padding, dilation, transposed, output_padding, groups); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_convolution_backward_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool_intarrayref_intt_stdarraybool)(void* grad_output, void* input, void* weight, void* bias_sizes, void* stride, void* padding, void* dilation, void* transposed, void* output_padding, void* groups, void* output_mask);
  HOST_API void* lantern_convolution_backward_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool_intarrayref_intt_stdarraybool(void* grad_output, void* input, void* weight, void* bias_sizes, void* stride, void* padding, void* dilation, void* transposed, void* output_padding, void* groups, void* output_mask) { LANTERN_CHECK_LOADED void* ret = _lantern_convolution_backward_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool_intarrayref_intt_stdarraybool(grad_output, input, weight, bias_sizes, stride, padding, dilation, transposed, output_padding, groups, output_mask); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_convolution_overrideable_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_bool_intarrayref_intt)(void* input, void* weight, void* bias, void* stride, void* padding, void* dilation, void* transposed, void* output_padding, void* groups);
  HOST_API void* lantern_convolution_overrideable_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_bool_intarrayref_intt(void* input, void* weight, void* bias, void* stride, void* padding, void* dilation, void* transposed, void* output_padding, void* groups) { LANTERN_CHECK_LOADED void* ret = _lantern_convolution_overrideable_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_bool_intarrayref_intt(input, weight, bias, stride, padding, dilation, transposed, output_padding, groups); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_convolution_backward_overrideable_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_bool_intarrayref_intt_stdarraybool)(void* grad_output, void* input, void* weight, void* stride, void* padding, void* dilation, void* transposed, void* output_padding, void* groups, void* output_mask);
  HOST_API void* lantern_convolution_backward_overrideable_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_bool_intarrayref_intt_stdarraybool(void* grad_output, void* input, void* weight, void* stride, void* padding, void* dilation, void* transposed, void* output_padding, void* groups, void* output_mask) { LANTERN_CHECK_LOADED void* ret = _lantern_convolution_backward_overrideable_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_bool_intarrayref_intt_stdarraybool(grad_output, input, weight, stride, padding, dilation, transposed, output_padding, groups, output_mask); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__convolution_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_bool_intarrayref_intt_bool_bool_bool_bool)(void* input, void* weight, void* bias, void* stride, void* padding, void* dilation, void* transposed, void* output_padding, void* groups, void* benchmark, void* deterministic, void* cudnn_enabled, void* allow_tf32);
  HOST_API void* lantern__convolution_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_bool_intarrayref_intt_bool_bool_bool_bool(void* input, void* weight, void* bias, void* stride, void* padding, void* dilation, void* transposed, void* output_padding, void* groups, void* benchmark, void* deterministic, void* cudnn_enabled, void* allow_tf32) { LANTERN_CHECK_LOADED void* ret = _lantern__convolution_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_bool_intarrayref_intt_bool_bool_bool_bool(input, weight, bias, stride, padding, dilation, transposed, output_padding, groups, benchmark, deterministic, cudnn_enabled, allow_tf32); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__convolution_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_bool_intarrayref_intt_bool_bool_bool)(void* input, void* weight, void* bias, void* stride, void* padding, void* dilation, void* transposed, void* output_padding, void* groups, void* benchmark, void* deterministic, void* cudnn_enabled);
  HOST_API void* lantern__convolution_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_bool_intarrayref_intt_bool_bool_bool(void* input, void* weight, void* bias, void* stride, void* padding, void* dilation, void* transposed, void* output_padding, void* groups, void* benchmark, void* deterministic, void* cudnn_enabled) { LANTERN_CHECK_LOADED void* ret = _lantern__convolution_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_bool_intarrayref_intt_bool_bool_bool(input, weight, bias, stride, padding, dilation, transposed, output_padding, groups, benchmark, deterministic, cudnn_enabled); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__convolution_mode_tensor_tensor_tensor_intarrayref_cstringview_intarrayref_intt)(void* input, void* weight, void* bias, void* stride, void* padding, void* dilation, void* groups);
  HOST_API void* lantern__convolution_mode_tensor_tensor_tensor_intarrayref_cstringview_intarrayref_intt(void* input, void* weight, void* bias, void* stride, void* padding, void* dilation, void* groups) { LANTERN_CHECK_LOADED void* ret = _lantern__convolution_mode_tensor_tensor_tensor_intarrayref_cstringview_intarrayref_intt(input, weight, bias, stride, padding, dilation, groups); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__convolution_double_backward_tensor_tensor_tensor_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_bool_intarrayref_intt_stdarraybool)(void* ggI, void* ggW, void* ggb, void* gO, void* weight, void* self, void* stride, void* padding, void* dilation, void* transposed, void* output_padding, void* groups, void* output_mask);
  HOST_API void* lantern__convolution_double_backward_tensor_tensor_tensor_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_bool_intarrayref_intt_stdarraybool(void* ggI, void* ggW, void* ggb, void* gO, void* weight, void* self, void* stride, void* padding, void* dilation, void* transposed, void* output_padding, void* groups, void* output_mask) { LANTERN_CHECK_LOADED void* ret = _lantern__convolution_double_backward_tensor_tensor_tensor_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_bool_intarrayref_intt_stdarraybool(ggI, ggW, ggb, gO, weight, self, stride, padding, dilation, transposed, output_padding, groups, output_mask); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_conv1d_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intt)(void* input, void* weight, void* bias, void* stride, void* padding, void* dilation, void* groups);
  HOST_API void* lantern_conv1d_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intt(void* input, void* weight, void* bias, void* stride, void* padding, void* dilation, void* groups) { LANTERN_CHECK_LOADED void* ret = _lantern_conv1d_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intt(input, weight, bias, stride, padding, dilation, groups); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_conv2d_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intt)(void* input, void* weight, void* bias, void* stride, void* padding, void* dilation, void* groups);
  HOST_API void* lantern_conv2d_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intt(void* input, void* weight, void* bias, void* stride, void* padding, void* dilation, void* groups) { LANTERN_CHECK_LOADED void* ret = _lantern_conv2d_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intt(input, weight, bias, stride, padding, dilation, groups); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_conv3d_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intt)(void* input, void* weight, void* bias, void* stride, void* padding, void* dilation, void* groups);
  HOST_API void* lantern_conv3d_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intt(void* input, void* weight, void* bias, void* stride, void* padding, void* dilation, void* groups) { LANTERN_CHECK_LOADED void* ret = _lantern_conv3d_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intt(input, weight, bias, stride, padding, dilation, groups); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_conv1d_tensor_tensor_tensor_intarrayref_cstringview_intarrayref_intt)(void* input, void* weight, void* bias, void* stride, void* padding, void* dilation, void* groups);
  HOST_API void* lantern_conv1d_tensor_tensor_tensor_intarrayref_cstringview_intarrayref_intt(void* input, void* weight, void* bias, void* stride, void* padding, void* dilation, void* groups) { LANTERN_CHECK_LOADED void* ret = _lantern_conv1d_tensor_tensor_tensor_intarrayref_cstringview_intarrayref_intt(input, weight, bias, stride, padding, dilation, groups); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_conv2d_tensor_tensor_tensor_intarrayref_cstringview_intarrayref_intt)(void* input, void* weight, void* bias, void* stride, void* padding, void* dilation, void* groups);
  HOST_API void* lantern_conv2d_tensor_tensor_tensor_intarrayref_cstringview_intarrayref_intt(void* input, void* weight, void* bias, void* stride, void* padding, void* dilation, void* groups) { LANTERN_CHECK_LOADED void* ret = _lantern_conv2d_tensor_tensor_tensor_intarrayref_cstringview_intarrayref_intt(input, weight, bias, stride, padding, dilation, groups); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_conv3d_tensor_tensor_tensor_intarrayref_cstringview_intarrayref_intt)(void* input, void* weight, void* bias, void* stride, void* padding, void* dilation, void* groups);
  HOST_API void* lantern_conv3d_tensor_tensor_tensor_intarrayref_cstringview_intarrayref_intt(void* input, void* weight, void* bias, void* stride, void* padding, void* dilation, void* groups) { LANTERN_CHECK_LOADED void* ret = _lantern_conv3d_tensor_tensor_tensor_intarrayref_cstringview_intarrayref_intt(input, weight, bias, stride, padding, dilation, groups); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_conv_tbc_tensor_tensor_tensor_intt)(void* self, void* weight, void* bias, void* pad);
  HOST_API void* lantern_conv_tbc_tensor_tensor_tensor_intt(void* self, void* weight, void* bias, void* pad) { LANTERN_CHECK_LOADED void* ret = _lantern_conv_tbc_tensor_tensor_tensor_intt(self, weight, bias, pad); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_conv_tbc_backward_tensor_tensor_tensor_tensor_intt)(void* self, void* input, void* weight, void* bias, void* pad);
  HOST_API void* lantern_conv_tbc_backward_tensor_tensor_tensor_tensor_intt(void* self, void* input, void* weight, void* bias, void* pad) { LANTERN_CHECK_LOADED void* ret = _lantern_conv_tbc_backward_tensor_tensor_tensor_tensor_intt(self, input, weight, bias, pad); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_conv_transpose1d_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intt_intarrayref)(void* input, void* weight, void* bias, void* stride, void* padding, void* output_padding, void* groups, void* dilation);
  HOST_API void* lantern_conv_transpose1d_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intt_intarrayref(void* input, void* weight, void* bias, void* stride, void* padding, void* output_padding, void* groups, void* dilation) { LANTERN_CHECK_LOADED void* ret = _lantern_conv_transpose1d_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intt_intarrayref(input, weight, bias, stride, padding, output_padding, groups, dilation); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_conv_transpose2d_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intt_intarrayref)(void* input, void* weight, void* bias, void* stride, void* padding, void* output_padding, void* groups, void* dilation);
  HOST_API void* lantern_conv_transpose2d_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intt_intarrayref(void* input, void* weight, void* bias, void* stride, void* padding, void* output_padding, void* groups, void* dilation) { LANTERN_CHECK_LOADED void* ret = _lantern_conv_transpose2d_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intt_intarrayref(input, weight, bias, stride, padding, output_padding, groups, dilation); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_conv_transpose3d_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intt_intarrayref)(void* input, void* weight, void* bias, void* stride, void* padding, void* output_padding, void* groups, void* dilation);
  HOST_API void* lantern_conv_transpose3d_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intt_intarrayref(void* input, void* weight, void* bias, void* stride, void* padding, void* output_padding, void* groups, void* dilation) { LANTERN_CHECK_LOADED void* ret = _lantern_conv_transpose3d_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intt_intarrayref(input, weight, bias, stride, padding, output_padding, groups, dilation); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_copy_tensor_tensor_bool)(void* self, void* src, void* non_blocking);
  HOST_API void* lantern_copy_tensor_tensor_bool(void* self, void* src, void* non_blocking) { LANTERN_CHECK_LOADED void* ret = _lantern_copy_tensor_tensor_bool(self, src, non_blocking); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_copy__tensor_tensor_bool)(void* self, void* src, void* non_blocking);
  HOST_API void* lantern_Tensor_copy__tensor_tensor_bool(void* self, void* src, void* non_blocking) { void* ret = _lantern_Tensor_copy__tensor_tensor_bool(self, src, non_blocking); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__copy_from_tensor_tensor_bool)(void* self, void* dst, void* non_blocking);
  HOST_API void* lantern__copy_from_tensor_tensor_bool(void* self, void* dst, void* non_blocking) { LANTERN_CHECK_LOADED void* ret = _lantern__copy_from_tensor_tensor_bool(self, dst, non_blocking); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__copy_from_and_resize_tensor_tensor)(void* self, void* dst);
  HOST_API void* lantern__copy_from_and_resize_tensor_tensor(void* self, void* dst) { LANTERN_CHECK_LOADED void* ret = _lantern__copy_from_and_resize_tensor_tensor(self, dst); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cos_tensor)(void* self);
  HOST_API void* lantern_cos_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_cos_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_cos_tensor)(void* self);
  HOST_API void* lantern_Tensor_cos_tensor(void* self) { void* ret = _lantern_Tensor_cos_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cos__tensor)(void* self);
  HOST_API void* lantern_cos__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_cos__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_cos__tensor)(void* self);
  HOST_API void* lantern_Tensor_cos__tensor(void* self) { void* ret = _lantern_Tensor_cos__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cos_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_cos_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_cos_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cosh_tensor)(void* self);
  HOST_API void* lantern_cosh_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_cosh_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_cosh_tensor)(void* self);
  HOST_API void* lantern_Tensor_cosh_tensor(void* self) { void* ret = _lantern_Tensor_cosh_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cosh__tensor)(void* self);
  HOST_API void* lantern_cosh__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_cosh__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_cosh__tensor)(void* self);
  HOST_API void* lantern_Tensor_cosh__tensor(void* self) { void* ret = _lantern_Tensor_cosh__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cosh_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_cosh_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_cosh_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cosine_embedding_loss_tensor_tensor_tensor_double_intt)(void* input1, void* input2, void* target, void* margin, void* reduction);
  HOST_API void* lantern_cosine_embedding_loss_tensor_tensor_tensor_double_intt(void* input1, void* input2, void* target, void* margin, void* reduction) { LANTERN_CHECK_LOADED void* ret = _lantern_cosine_embedding_loss_tensor_tensor_tensor_double_intt(input1, input2, target, margin, reduction); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_count_nonzero_tensor_intarrayref)(void* self, void* dim);
  HOST_API void* lantern_count_nonzero_tensor_intarrayref(void* self, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_count_nonzero_tensor_intarrayref(self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_count_nonzero_tensor_intarrayref)(void* self, void* dim);
  HOST_API void* lantern_Tensor_count_nonzero_tensor_intarrayref(void* self, void* dim) { void* ret = _lantern_Tensor_count_nonzero_tensor_intarrayref(self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_count_nonzero_tensor_intt)(void* self, void* dim);
  HOST_API void* lantern_count_nonzero_tensor_intt(void* self, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_count_nonzero_tensor_intt(self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_count_nonzero_tensor_intt)(void* self, void* dim);
  HOST_API void* lantern_Tensor_count_nonzero_tensor_intt(void* self, void* dim) { void* ret = _lantern_Tensor_count_nonzero_tensor_intt(self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cov_tensor_intt_tensor_tensor)(void* self, void* correction, void* fweights, void* aweights);
  HOST_API void* lantern_cov_tensor_intt_tensor_tensor(void* self, void* correction, void* fweights, void* aweights) { LANTERN_CHECK_LOADED void* ret = _lantern_cov_tensor_intt_tensor_tensor(self, correction, fweights, aweights); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_cov_tensor_intt_tensor_tensor)(void* self, void* correction, void* fweights, void* aweights);
  HOST_API void* lantern_Tensor_cov_tensor_intt_tensor_tensor(void* self, void* correction, void* fweights, void* aweights) { void* ret = _lantern_Tensor_cov_tensor_intt_tensor_tensor(self, correction, fweights, aweights); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_corrcoef_tensor)(void* self);
  HOST_API void* lantern_corrcoef_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_corrcoef_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_corrcoef_tensor)(void* self);
  HOST_API void* lantern_Tensor_corrcoef_tensor(void* self) { void* ret = _lantern_Tensor_corrcoef_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cudnn_affine_grid_generator_tensor_intt_intt_intt_intt)(void* theta, void* N, void* C, void* H, void* W);
  HOST_API void* lantern_cudnn_affine_grid_generator_tensor_intt_intt_intt_intt(void* theta, void* N, void* C, void* H, void* W) { LANTERN_CHECK_LOADED void* ret = _lantern_cudnn_affine_grid_generator_tensor_intt_intt_intt_intt(theta, N, C, H, W); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cudnn_affine_grid_generator_backward_tensor_intt_intt_intt_intt)(void* grad, void* N, void* C, void* H, void* W);
  HOST_API void* lantern_cudnn_affine_grid_generator_backward_tensor_intt_intt_intt_intt(void* grad, void* N, void* C, void* H, void* W) { LANTERN_CHECK_LOADED void* ret = _lantern_cudnn_affine_grid_generator_backward_tensor_intt_intt_intt_intt(grad, N, C, H, W); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cudnn_batch_norm_tensor_tensor_tensor_tensor_tensor_bool_double_double)(void* input, void* weight, void* bias, void* running_mean, void* running_var, void* training, void* exponential_average_factor, void* epsilon);
  HOST_API void* lantern_cudnn_batch_norm_tensor_tensor_tensor_tensor_tensor_bool_double_double(void* input, void* weight, void* bias, void* running_mean, void* running_var, void* training, void* exponential_average_factor, void* epsilon) { LANTERN_CHECK_LOADED void* ret = _lantern_cudnn_batch_norm_tensor_tensor_tensor_tensor_tensor_bool_double_double(input, weight, bias, running_mean, running_var, training, exponential_average_factor, epsilon); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cudnn_batch_norm_backward_tensor_tensor_tensor_tensor_tensor_tensor_tensor_double_tensor)(void* input, void* grad_output, void* weight, void* running_mean, void* running_var, void* save_mean, void* save_var, void* epsilon, void* reserveSpace);
  HOST_API void* lantern_cudnn_batch_norm_backward_tensor_tensor_tensor_tensor_tensor_tensor_tensor_double_tensor(void* input, void* grad_output, void* weight, void* running_mean, void* running_var, void* save_mean, void* save_var, void* epsilon, void* reserveSpace) { LANTERN_CHECK_LOADED void* ret = _lantern_cudnn_batch_norm_backward_tensor_tensor_tensor_tensor_tensor_tensor_tensor_double_tensor(input, grad_output, weight, running_mean, running_var, save_mean, save_var, epsilon, reserveSpace); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cudnn_convolution_tensor_tensor_intarrayref_intarrayref_intarrayref_intt_bool_bool_bool)(void* self, void* weight, void* padding, void* stride, void* dilation, void* groups, void* benchmark, void* deterministic, void* allow_tf32);
  HOST_API void* lantern_cudnn_convolution_tensor_tensor_intarrayref_intarrayref_intarrayref_intt_bool_bool_bool(void* self, void* weight, void* padding, void* stride, void* dilation, void* groups, void* benchmark, void* deterministic, void* allow_tf32) { LANTERN_CHECK_LOADED void* ret = _lantern_cudnn_convolution_tensor_tensor_intarrayref_intarrayref_intarrayref_intt_bool_bool_bool(self, weight, padding, stride, dilation, groups, benchmark, deterministic, allow_tf32); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cudnn_convolution_transpose_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_intt_bool_bool_bool)(void* self, void* weight, void* padding, void* output_padding, void* stride, void* dilation, void* groups, void* benchmark, void* deterministic, void* allow_tf32);
  HOST_API void* lantern_cudnn_convolution_transpose_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_intt_bool_bool_bool(void* self, void* weight, void* padding, void* output_padding, void* stride, void* dilation, void* groups, void* benchmark, void* deterministic, void* allow_tf32) { LANTERN_CHECK_LOADED void* ret = _lantern_cudnn_convolution_transpose_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_intt_bool_bool_bool(self, weight, padding, output_padding, stride, dilation, groups, benchmark, deterministic, allow_tf32); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__mps_convolution_transpose_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_intt)(void* self, void* weight, void* padding, void* output_padding, void* stride, void* dilation, void* groups);
  HOST_API void* lantern__mps_convolution_transpose_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_intt(void* self, void* weight, void* padding, void* output_padding, void* stride, void* dilation, void* groups) { LANTERN_CHECK_LOADED void* ret = _lantern__mps_convolution_transpose_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_intt(self, weight, padding, output_padding, stride, dilation, groups); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_mps_convolution_transpose_backward_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_intt_stdarraybool)(void* self, void* grad_output, void* weight, void* padding, void* output_padding, void* stride, void* dilation, void* groups, void* output_mask);
  HOST_API void* lantern_mps_convolution_transpose_backward_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_intt_stdarraybool(void* self, void* grad_output, void* weight, void* padding, void* output_padding, void* stride, void* dilation, void* groups, void* output_mask) { LANTERN_CHECK_LOADED void* ret = _lantern_mps_convolution_transpose_backward_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_intt_stdarraybool(self, grad_output, weight, padding, output_padding, stride, dilation, groups, output_mask); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cudnn_convolution_relu_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intt)(void* self, void* weight, void* bias, void* stride, void* padding, void* dilation, void* groups);
  HOST_API void* lantern_cudnn_convolution_relu_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intt(void* self, void* weight, void* bias, void* stride, void* padding, void* dilation, void* groups) { LANTERN_CHECK_LOADED void* ret = _lantern_cudnn_convolution_relu_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intt(self, weight, bias, stride, padding, dilation, groups); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cudnn_convolution_add_relu_tensor_tensor_tensor_scalar_tensor_intarrayref_intarrayref_intarrayref_intt)(void* self, void* weight, void* z, void* alpha, void* bias, void* stride, void* padding, void* dilation, void* groups);
  HOST_API void* lantern_cudnn_convolution_add_relu_tensor_tensor_tensor_scalar_tensor_intarrayref_intarrayref_intarrayref_intt(void* self, void* weight, void* z, void* alpha, void* bias, void* stride, void* padding, void* dilation, void* groups) { LANTERN_CHECK_LOADED void* ret = _lantern_cudnn_convolution_add_relu_tensor_tensor_tensor_scalar_tensor_intarrayref_intarrayref_intarrayref_intt(self, weight, z, alpha, bias, stride, padding, dilation, groups); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cudnn_grid_sampler_tensor_tensor)(void* self, void* grid);
  HOST_API void* lantern_cudnn_grid_sampler_tensor_tensor(void* self, void* grid) { LANTERN_CHECK_LOADED void* ret = _lantern_cudnn_grid_sampler_tensor_tensor(self, grid); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cudnn_grid_sampler_backward_tensor_tensor_tensor)(void* self, void* grid, void* grad_output);
  HOST_API void* lantern_cudnn_grid_sampler_backward_tensor_tensor_tensor(void* self, void* grid, void* grad_output) { LANTERN_CHECK_LOADED void* ret = _lantern_cudnn_grid_sampler_backward_tensor_tensor_tensor(self, grid, grad_output); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cummax_tensor_intt)(void* self, void* dim);
  HOST_API void* lantern_cummax_tensor_intt(void* self, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_cummax_tensor_intt(self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_cummax_tensor_intt)(void* self, void* dim);
  HOST_API void* lantern_Tensor_cummax_tensor_intt(void* self, void* dim) { void* ret = _lantern_Tensor_cummax_tensor_intt(self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cummax_out_tensor_tensor_tensor_intt)(void* values, void* indices, void* self, void* dim);
  HOST_API void* lantern_cummax_out_tensor_tensor_tensor_intt(void* values, void* indices, void* self, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_cummax_out_tensor_tensor_tensor_intt(values, indices, self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cummax_tensor_dimname)(void* self, void* dim);
  HOST_API void* lantern_cummax_tensor_dimname(void* self, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_cummax_tensor_dimname(self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_cummax_tensor_dimname)(void* self, void* dim);
  HOST_API void* lantern_Tensor_cummax_tensor_dimname(void* self, void* dim) { void* ret = _lantern_Tensor_cummax_tensor_dimname(self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cummax_out_tensor_tensor_tensor_dimname)(void* values, void* indices, void* self, void* dim);
  HOST_API void* lantern_cummax_out_tensor_tensor_tensor_dimname(void* values, void* indices, void* self, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_cummax_out_tensor_tensor_tensor_dimname(values, indices, self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__cummax_helper_tensor_tensor_tensor_intt)(void* self, void* values, void* indices, void* dim);
  HOST_API void* lantern__cummax_helper_tensor_tensor_tensor_intt(void* self, void* values, void* indices, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern__cummax_helper_tensor_tensor_tensor_intt(self, values, indices, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cummin_tensor_intt)(void* self, void* dim);
  HOST_API void* lantern_cummin_tensor_intt(void* self, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_cummin_tensor_intt(self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_cummin_tensor_intt)(void* self, void* dim);
  HOST_API void* lantern_Tensor_cummin_tensor_intt(void* self, void* dim) { void* ret = _lantern_Tensor_cummin_tensor_intt(self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cummin_out_tensor_tensor_tensor_intt)(void* values, void* indices, void* self, void* dim);
  HOST_API void* lantern_cummin_out_tensor_tensor_tensor_intt(void* values, void* indices, void* self, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_cummin_out_tensor_tensor_tensor_intt(values, indices, self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cummin_tensor_dimname)(void* self, void* dim);
  HOST_API void* lantern_cummin_tensor_dimname(void* self, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_cummin_tensor_dimname(self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_cummin_tensor_dimname)(void* self, void* dim);
  HOST_API void* lantern_Tensor_cummin_tensor_dimname(void* self, void* dim) { void* ret = _lantern_Tensor_cummin_tensor_dimname(self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cummin_out_tensor_tensor_tensor_dimname)(void* values, void* indices, void* self, void* dim);
  HOST_API void* lantern_cummin_out_tensor_tensor_tensor_dimname(void* values, void* indices, void* self, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_cummin_out_tensor_tensor_tensor_dimname(values, indices, self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__cummin_helper_tensor_tensor_tensor_intt)(void* self, void* values, void* indices, void* dim);
  HOST_API void* lantern__cummin_helper_tensor_tensor_tensor_intt(void* self, void* values, void* indices, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern__cummin_helper_tensor_tensor_tensor_intt(self, values, indices, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cummaxmin_backward_tensor_tensor_tensor_intt)(void* grad, void* input, void* indices, void* dim);
  HOST_API void* lantern_cummaxmin_backward_tensor_tensor_tensor_intt(void* grad, void* input, void* indices, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_cummaxmin_backward_tensor_tensor_tensor_intt(grad, input, indices, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cumprod_tensor_intt_scalartype)(void* self, void* dim, void* dtype);
  HOST_API void* lantern_cumprod_tensor_intt_scalartype(void* self, void* dim, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern_cumprod_tensor_intt_scalartype(self, dim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_cumprod_tensor_intt_scalartype)(void* self, void* dim, void* dtype);
  HOST_API void* lantern_Tensor_cumprod_tensor_intt_scalartype(void* self, void* dim, void* dtype) { void* ret = _lantern_Tensor_cumprod_tensor_intt_scalartype(self, dim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_cumprod__tensor_intt_scalartype)(void* self, void* dim, void* dtype);
  HOST_API void* lantern_Tensor_cumprod__tensor_intt_scalartype(void* self, void* dim, void* dtype) { void* ret = _lantern_Tensor_cumprod__tensor_intt_scalartype(self, dim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cumprod_out_tensor_tensor_intt_scalartype)(void* out, void* self, void* dim, void* dtype);
  HOST_API void* lantern_cumprod_out_tensor_tensor_intt_scalartype(void* out, void* self, void* dim, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern_cumprod_out_tensor_tensor_intt_scalartype(out, self, dim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cumprod_tensor_dimname_scalartype)(void* self, void* dim, void* dtype);
  HOST_API void* lantern_cumprod_tensor_dimname_scalartype(void* self, void* dim, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern_cumprod_tensor_dimname_scalartype(self, dim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_cumprod_tensor_dimname_scalartype)(void* self, void* dim, void* dtype);
  HOST_API void* lantern_Tensor_cumprod_tensor_dimname_scalartype(void* self, void* dim, void* dtype) { void* ret = _lantern_Tensor_cumprod_tensor_dimname_scalartype(self, dim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_cumprod__tensor_dimname_scalartype)(void* self, void* dim, void* dtype);
  HOST_API void* lantern_Tensor_cumprod__tensor_dimname_scalartype(void* self, void* dim, void* dtype) { void* ret = _lantern_Tensor_cumprod__tensor_dimname_scalartype(self, dim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cumprod_out_tensor_tensor_dimname_scalartype)(void* out, void* self, void* dim, void* dtype);
  HOST_API void* lantern_cumprod_out_tensor_tensor_dimname_scalartype(void* out, void* self, void* dim, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern_cumprod_out_tensor_tensor_dimname_scalartype(out, self, dim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cumprod_backward_tensor_tensor_intt_tensor)(void* grad, void* input, void* dim, void* output);
  HOST_API void* lantern_cumprod_backward_tensor_tensor_intt_tensor(void* grad, void* input, void* dim, void* output) { LANTERN_CHECK_LOADED void* ret = _lantern_cumprod_backward_tensor_tensor_intt_tensor(grad, input, dim, output); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cumsum_tensor_intt_scalartype)(void* self, void* dim, void* dtype);
  HOST_API void* lantern_cumsum_tensor_intt_scalartype(void* self, void* dim, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern_cumsum_tensor_intt_scalartype(self, dim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_cumsum_tensor_intt_scalartype)(void* self, void* dim, void* dtype);
  HOST_API void* lantern_Tensor_cumsum_tensor_intt_scalartype(void* self, void* dim, void* dtype) { void* ret = _lantern_Tensor_cumsum_tensor_intt_scalartype(self, dim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_cumsum__tensor_intt_scalartype)(void* self, void* dim, void* dtype);
  HOST_API void* lantern_Tensor_cumsum__tensor_intt_scalartype(void* self, void* dim, void* dtype) { void* ret = _lantern_Tensor_cumsum__tensor_intt_scalartype(self, dim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cumsum_out_tensor_tensor_intt_scalartype)(void* out, void* self, void* dim, void* dtype);
  HOST_API void* lantern_cumsum_out_tensor_tensor_intt_scalartype(void* out, void* self, void* dim, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern_cumsum_out_tensor_tensor_intt_scalartype(out, self, dim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cumsum_tensor_dimname_scalartype)(void* self, void* dim, void* dtype);
  HOST_API void* lantern_cumsum_tensor_dimname_scalartype(void* self, void* dim, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern_cumsum_tensor_dimname_scalartype(self, dim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_cumsum_tensor_dimname_scalartype)(void* self, void* dim, void* dtype);
  HOST_API void* lantern_Tensor_cumsum_tensor_dimname_scalartype(void* self, void* dim, void* dtype) { void* ret = _lantern_Tensor_cumsum_tensor_dimname_scalartype(self, dim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_cumsum__tensor_dimname_scalartype)(void* self, void* dim, void* dtype);
  HOST_API void* lantern_Tensor_cumsum__tensor_dimname_scalartype(void* self, void* dim, void* dtype) { void* ret = _lantern_Tensor_cumsum__tensor_dimname_scalartype(self, dim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cumsum_out_tensor_tensor_dimname_scalartype)(void* out, void* self, void* dim, void* dtype);
  HOST_API void* lantern_cumsum_out_tensor_tensor_dimname_scalartype(void* out, void* self, void* dim, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern_cumsum_out_tensor_tensor_dimname_scalartype(out, self, dim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cumulative_trapezoid_tensor_tensor_intt)(void* y, void* x, void* dim);
  HOST_API void* lantern_cumulative_trapezoid_tensor_tensor_intt(void* y, void* x, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_cumulative_trapezoid_tensor_tensor_intt(y, x, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cumulative_trapezoid_tensor_scalar_intt)(void* y, void* dx, void* dim);
  HOST_API void* lantern_cumulative_trapezoid_tensor_scalar_intt(void* y, void* dx, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_cumulative_trapezoid_tensor_scalar_intt(y, dx, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_ctc_loss_tensor_tensor_intarrayref_intarrayref_intt_intt_bool)(void* log_probs, void* targets, void* input_lengths, void* target_lengths, void* blank, void* reduction, void* zero_infinity);
  HOST_API void* lantern_ctc_loss_tensor_tensor_intarrayref_intarrayref_intt_intt_bool(void* log_probs, void* targets, void* input_lengths, void* target_lengths, void* blank, void* reduction, void* zero_infinity) { LANTERN_CHECK_LOADED void* ret = _lantern_ctc_loss_tensor_tensor_intarrayref_intarrayref_intt_intt_bool(log_probs, targets, input_lengths, target_lengths, blank, reduction, zero_infinity); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_ctc_loss_tensor_tensor_tensor_tensor_intt_intt_bool)(void* log_probs, void* targets, void* input_lengths, void* target_lengths, void* blank, void* reduction, void* zero_infinity);
  HOST_API void* lantern_ctc_loss_tensor_tensor_tensor_tensor_intt_intt_bool(void* log_probs, void* targets, void* input_lengths, void* target_lengths, void* blank, void* reduction, void* zero_infinity) { LANTERN_CHECK_LOADED void* ret = _lantern_ctc_loss_tensor_tensor_tensor_tensor_intt_intt_bool(log_probs, targets, input_lengths, target_lengths, blank, reduction, zero_infinity); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__ctc_loss_tensor_tensor_intarrayref_intarrayref_intt_bool)(void* log_probs, void* targets, void* input_lengths, void* target_lengths, void* blank, void* zero_infinity);
  HOST_API void* lantern__ctc_loss_tensor_tensor_intarrayref_intarrayref_intt_bool(void* log_probs, void* targets, void* input_lengths, void* target_lengths, void* blank, void* zero_infinity) { LANTERN_CHECK_LOADED void* ret = _lantern__ctc_loss_tensor_tensor_intarrayref_intarrayref_intt_bool(log_probs, targets, input_lengths, target_lengths, blank, zero_infinity); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__ctc_loss_tensor_tensor_tensor_tensor_intt_bool)(void* log_probs, void* targets, void* input_lengths, void* target_lengths, void* blank, void* zero_infinity);
  HOST_API void* lantern__ctc_loss_tensor_tensor_tensor_tensor_intt_bool(void* log_probs, void* targets, void* input_lengths, void* target_lengths, void* blank, void* zero_infinity) { LANTERN_CHECK_LOADED void* ret = _lantern__ctc_loss_tensor_tensor_tensor_tensor_intt_bool(log_probs, targets, input_lengths, target_lengths, blank, zero_infinity); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__ctc_loss_backward_tensor_tensor_tensor_intarrayref_intarrayref_tensor_tensor_intt_bool)(void* grad, void* log_probs, void* targets, void* input_lengths, void* target_lengths, void* neg_log_likelihood, void* log_alpha, void* blank, void* zero_infinity);
  HOST_API void* lantern__ctc_loss_backward_tensor_tensor_tensor_intarrayref_intarrayref_tensor_tensor_intt_bool(void* grad, void* log_probs, void* targets, void* input_lengths, void* target_lengths, void* neg_log_likelihood, void* log_alpha, void* blank, void* zero_infinity) { LANTERN_CHECK_LOADED void* ret = _lantern__ctc_loss_backward_tensor_tensor_tensor_intarrayref_intarrayref_tensor_tensor_intt_bool(grad, log_probs, targets, input_lengths, target_lengths, neg_log_likelihood, log_alpha, blank, zero_infinity); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__ctc_loss_backward_tensor_tensor_tensor_tensor_tensor_tensor_tensor_intt_bool)(void* grad, void* log_probs, void* targets, void* input_lengths, void* target_lengths, void* neg_log_likelihood, void* log_alpha, void* blank, void* zero_infinity);
  HOST_API void* lantern__ctc_loss_backward_tensor_tensor_tensor_tensor_tensor_tensor_tensor_intt_bool(void* grad, void* log_probs, void* targets, void* input_lengths, void* target_lengths, void* neg_log_likelihood, void* log_alpha, void* blank, void* zero_infinity) { LANTERN_CHECK_LOADED void* ret = _lantern__ctc_loss_backward_tensor_tensor_tensor_tensor_tensor_tensor_tensor_intt_bool(grad, log_probs, targets, input_lengths, target_lengths, neg_log_likelihood, log_alpha, blank, zero_infinity); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_diag_embed_tensor_intt_intt_intt)(void* self, void* offset, void* dim1, void* dim2);
  HOST_API void* lantern_diag_embed_tensor_intt_intt_intt(void* self, void* offset, void* dim1, void* dim2) { LANTERN_CHECK_LOADED void* ret = _lantern_diag_embed_tensor_intt_intt_intt(self, offset, dim1, dim2); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_diag_embed_tensor_intt_intt_intt)(void* self, void* offset, void* dim1, void* dim2);
  HOST_API void* lantern_Tensor_diag_embed_tensor_intt_intt_intt(void* self, void* offset, void* dim1, void* dim2) { void* ret = _lantern_Tensor_diag_embed_tensor_intt_intt_intt(self, offset, dim1, dim2); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_diagflat_tensor_intt)(void* self, void* offset);
  HOST_API void* lantern_diagflat_tensor_intt(void* self, void* offset) { LANTERN_CHECK_LOADED void* ret = _lantern_diagflat_tensor_intt(self, offset); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_diagflat_tensor_intt)(void* self, void* offset);
  HOST_API void* lantern_Tensor_diagflat_tensor_intt(void* self, void* offset) { void* ret = _lantern_Tensor_diagflat_tensor_intt(self, offset); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_diagonal_tensor_intt_intt_intt)(void* self, void* offset, void* dim1, void* dim2);
  HOST_API void* lantern_diagonal_tensor_intt_intt_intt(void* self, void* offset, void* dim1, void* dim2) { LANTERN_CHECK_LOADED void* ret = _lantern_diagonal_tensor_intt_intt_intt(self, offset, dim1, dim2); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_diagonal_tensor_intt_intt_intt)(void* self, void* offset, void* dim1, void* dim2);
  HOST_API void* lantern_Tensor_diagonal_tensor_intt_intt_intt(void* self, void* offset, void* dim1, void* dim2) { void* ret = _lantern_Tensor_diagonal_tensor_intt_intt_intt(self, offset, dim1, dim2); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_linalg_diagonal_tensor_intt_intt_intt)(void* A, void* offset, void* dim1, void* dim2);
  HOST_API void* lantern_linalg_diagonal_tensor_intt_intt_intt(void* A, void* offset, void* dim1, void* dim2) { LANTERN_CHECK_LOADED void* ret = _lantern_linalg_diagonal_tensor_intt_intt_intt(A, offset, dim1, dim2); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_diagonal_tensor_dimname_dimname_dimname_intt)(void* self, void* outdim, void* dim1, void* dim2, void* offset);
  HOST_API void* lantern_diagonal_tensor_dimname_dimname_dimname_intt(void* self, void* outdim, void* dim1, void* dim2, void* offset) { LANTERN_CHECK_LOADED void* ret = _lantern_diagonal_tensor_dimname_dimname_dimname_intt(self, outdim, dim1, dim2, offset); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_diagonal_tensor_dimname_dimname_dimname_intt)(void* self, void* outdim, void* dim1, void* dim2, void* offset);
  HOST_API void* lantern_Tensor_diagonal_tensor_dimname_dimname_dimname_intt(void* self, void* outdim, void* dim1, void* dim2, void* offset) { void* ret = _lantern_Tensor_diagonal_tensor_dimname_dimname_dimname_intt(self, outdim, dim1, dim2, offset); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_diagonal_backward_tensor_intarrayref_intt_intt_intt)(void* grad_output, void* input_sizes, void* offset, void* dim1, void* dim2);
  HOST_API void* lantern_diagonal_backward_tensor_intarrayref_intt_intt_intt(void* grad_output, void* input_sizes, void* offset, void* dim1, void* dim2) { LANTERN_CHECK_LOADED void* ret = _lantern_diagonal_backward_tensor_intarrayref_intt_intt_intt(grad_output, input_sizes, offset, dim1, dim2); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_fill_diagonal__tensor_scalar_bool)(void* self, void* fill_value, void* wrap);
  HOST_API void* lantern_Tensor_fill_diagonal__tensor_scalar_bool(void* self, void* fill_value, void* wrap) { void* ret = _lantern_Tensor_fill_diagonal__tensor_scalar_bool(self, fill_value, wrap); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_diff_tensor_intt_intt_tensor_tensor)(void* self, void* n, void* dim, void* prepend, void* append);
  HOST_API void* lantern_diff_tensor_intt_intt_tensor_tensor(void* self, void* n, void* dim, void* prepend, void* append) { LANTERN_CHECK_LOADED void* ret = _lantern_diff_tensor_intt_intt_tensor_tensor(self, n, dim, prepend, append); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_diff_tensor_intt_intt_tensor_tensor)(void* self, void* n, void* dim, void* prepend, void* append);
  HOST_API void* lantern_Tensor_diff_tensor_intt_intt_tensor_tensor(void* self, void* n, void* dim, void* prepend, void* append) { void* ret = _lantern_Tensor_diff_tensor_intt_intt_tensor_tensor(self, n, dim, prepend, append); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_diff_out_tensor_tensor_intt_intt_tensor_tensor)(void* out, void* self, void* n, void* dim, void* prepend, void* append);
  HOST_API void* lantern_diff_out_tensor_tensor_intt_intt_tensor_tensor(void* out, void* self, void* n, void* dim, void* prepend, void* append) { LANTERN_CHECK_LOADED void* ret = _lantern_diff_out_tensor_tensor_intt_intt_tensor_tensor(out, self, n, dim, prepend, append); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_gradient_tensor_scalar_intt_intt)(void* self, void* spacing, void* dim, void* edge_order);
  HOST_API void* lantern_gradient_tensor_scalar_intt_intt(void* self, void* spacing, void* dim, void* edge_order) { LANTERN_CHECK_LOADED void* ret = _lantern_gradient_tensor_scalar_intt_intt(self, spacing, dim, edge_order); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_gradient_tensor_scalar_intarrayref_intt)(void* self, void* spacing, void* dim, void* edge_order);
  HOST_API void* lantern_gradient_tensor_scalar_intarrayref_intt(void* self, void* spacing, void* dim, void* edge_order) { LANTERN_CHECK_LOADED void* ret = _lantern_gradient_tensor_scalar_intarrayref_intt(self, spacing, dim, edge_order); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_gradient_tensor_intarrayref_intt)(void* self, void* dim, void* edge_order);
  HOST_API void* lantern_gradient_tensor_intarrayref_intt(void* self, void* dim, void* edge_order) { LANTERN_CHECK_LOADED void* ret = _lantern_gradient_tensor_intarrayref_intt(self, dim, edge_order); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_gradient_tensor_arrayrefscalar_intt_intt)(void* self, void* spacing, void* dim, void* edge_order);
  HOST_API void* lantern_gradient_tensor_arrayrefscalar_intt_intt(void* self, void* spacing, void* dim, void* edge_order) { LANTERN_CHECK_LOADED void* ret = _lantern_gradient_tensor_arrayrefscalar_intt_intt(self, spacing, dim, edge_order); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_gradient_tensor_arrayrefscalar_intarrayref_intt)(void* self, void* spacing, void* dim, void* edge_order);
  HOST_API void* lantern_gradient_tensor_arrayrefscalar_intarrayref_intt(void* self, void* spacing, void* dim, void* edge_order) { LANTERN_CHECK_LOADED void* ret = _lantern_gradient_tensor_arrayrefscalar_intarrayref_intt(self, spacing, dim, edge_order); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_gradient_tensor_tensorlist_intt_intt)(void* self, void* spacing, void* dim, void* edge_order);
  HOST_API void* lantern_gradient_tensor_tensorlist_intt_intt(void* self, void* spacing, void* dim, void* edge_order) { LANTERN_CHECK_LOADED void* ret = _lantern_gradient_tensor_tensorlist_intt_intt(self, spacing, dim, edge_order); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_gradient_tensor_tensorlist_intarrayref_intt)(void* self, void* spacing, void* dim, void* edge_order);
  HOST_API void* lantern_gradient_tensor_tensorlist_intarrayref_intt(void* self, void* spacing, void* dim, void* edge_order) { LANTERN_CHECK_LOADED void* ret = _lantern_gradient_tensor_tensorlist_intarrayref_intt(self, spacing, dim, edge_order); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_div_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_div_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_div_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_div_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_div_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_div_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_div__tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_div__tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_div__tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_div_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_div_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_div_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_div_tensor_tensor_cstringview)(void* self, void* other, void* rounding_mode);
  HOST_API void* lantern_div_tensor_tensor_cstringview(void* self, void* other, void* rounding_mode) { LANTERN_CHECK_LOADED void* ret = _lantern_div_tensor_tensor_cstringview(self, other, rounding_mode); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_div_tensor_tensor_cstringview)(void* self, void* other, void* rounding_mode);
  HOST_API void* lantern_Tensor_div_tensor_tensor_cstringview(void* self, void* other, void* rounding_mode) { void* ret = _lantern_Tensor_div_tensor_tensor_cstringview(self, other, rounding_mode); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_div__tensor_tensor_cstringview)(void* self, void* other, void* rounding_mode);
  HOST_API void* lantern_Tensor_div__tensor_tensor_cstringview(void* self, void* other, void* rounding_mode) { void* ret = _lantern_Tensor_div__tensor_tensor_cstringview(self, other, rounding_mode); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_div_out_tensor_tensor_tensor_cstringview)(void* out, void* self, void* other, void* rounding_mode);
  HOST_API void* lantern_div_out_tensor_tensor_tensor_cstringview(void* out, void* self, void* other, void* rounding_mode) { LANTERN_CHECK_LOADED void* ret = _lantern_div_out_tensor_tensor_tensor_cstringview(out, self, other, rounding_mode); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_div_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_div_tensor_scalar(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_div_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_div_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_div_tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_div_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_div__tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_div__tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_div__tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_div_tensor_scalar_cstringview)(void* self, void* other, void* rounding_mode);
  HOST_API void* lantern_div_tensor_scalar_cstringview(void* self, void* other, void* rounding_mode) { LANTERN_CHECK_LOADED void* ret = _lantern_div_tensor_scalar_cstringview(self, other, rounding_mode); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_div_tensor_scalar_cstringview)(void* self, void* other, void* rounding_mode);
  HOST_API void* lantern_Tensor_div_tensor_scalar_cstringview(void* self, void* other, void* rounding_mode) { void* ret = _lantern_Tensor_div_tensor_scalar_cstringview(self, other, rounding_mode); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_div__tensor_scalar_cstringview)(void* self, void* other, void* rounding_mode);
  HOST_API void* lantern_Tensor_div__tensor_scalar_cstringview(void* self, void* other, void* rounding_mode) { void* ret = _lantern_Tensor_div__tensor_scalar_cstringview(self, other, rounding_mode); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_divide_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_divide_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_divide_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_divide_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_divide_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_divide_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_divide__tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_divide__tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_divide__tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_divide_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_divide_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_divide_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_divide_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_divide_tensor_scalar(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_divide_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_divide_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_divide_tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_divide_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_divide__tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_divide__tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_divide__tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_divide_tensor_tensor_cstringview)(void* self, void* other, void* rounding_mode);
  HOST_API void* lantern_divide_tensor_tensor_cstringview(void* self, void* other, void* rounding_mode) { LANTERN_CHECK_LOADED void* ret = _lantern_divide_tensor_tensor_cstringview(self, other, rounding_mode); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_divide_tensor_tensor_cstringview)(void* self, void* other, void* rounding_mode);
  HOST_API void* lantern_Tensor_divide_tensor_tensor_cstringview(void* self, void* other, void* rounding_mode) { void* ret = _lantern_Tensor_divide_tensor_tensor_cstringview(self, other, rounding_mode); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_divide__tensor_tensor_cstringview)(void* self, void* other, void* rounding_mode);
  HOST_API void* lantern_Tensor_divide__tensor_tensor_cstringview(void* self, void* other, void* rounding_mode) { void* ret = _lantern_Tensor_divide__tensor_tensor_cstringview(self, other, rounding_mode); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_divide_out_tensor_tensor_tensor_cstringview)(void* out, void* self, void* other, void* rounding_mode);
  HOST_API void* lantern_divide_out_tensor_tensor_tensor_cstringview(void* out, void* self, void* other, void* rounding_mode) { LANTERN_CHECK_LOADED void* ret = _lantern_divide_out_tensor_tensor_tensor_cstringview(out, self, other, rounding_mode); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_divide_tensor_scalar_cstringview)(void* self, void* other, void* rounding_mode);
  HOST_API void* lantern_divide_tensor_scalar_cstringview(void* self, void* other, void* rounding_mode) { LANTERN_CHECK_LOADED void* ret = _lantern_divide_tensor_scalar_cstringview(self, other, rounding_mode); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_divide_tensor_scalar_cstringview)(void* self, void* other, void* rounding_mode);
  HOST_API void* lantern_Tensor_divide_tensor_scalar_cstringview(void* self, void* other, void* rounding_mode) { void* ret = _lantern_Tensor_divide_tensor_scalar_cstringview(self, other, rounding_mode); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_divide__tensor_scalar_cstringview)(void* self, void* other, void* rounding_mode);
  HOST_API void* lantern_Tensor_divide__tensor_scalar_cstringview(void* self, void* other, void* rounding_mode) { void* ret = _lantern_Tensor_divide__tensor_scalar_cstringview(self, other, rounding_mode); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_true_divide_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_true_divide_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_true_divide_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_true_divide_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_true_divide_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_true_divide_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_true_divide__tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_true_divide__tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_true_divide__tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_true_divide_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_true_divide_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_true_divide_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_true_divide_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_true_divide_tensor_scalar(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_true_divide_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_true_divide_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_true_divide_tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_true_divide_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_true_divide__tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_true_divide__tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_true_divide__tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_dot_tensor_tensor)(void* self, void* tensor);
  HOST_API void* lantern_dot_tensor_tensor(void* self, void* tensor) { LANTERN_CHECK_LOADED void* ret = _lantern_dot_tensor_tensor(self, tensor); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_dot_tensor_tensor)(void* self, void* tensor);
  HOST_API void* lantern_Tensor_dot_tensor_tensor(void* self, void* tensor) { void* ret = _lantern_Tensor_dot_tensor_tensor(self, tensor); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_dot_out_tensor_tensor_tensor)(void* out, void* self, void* tensor);
  HOST_API void* lantern_dot_out_tensor_tensor_tensor(void* out, void* self, void* tensor) { LANTERN_CHECK_LOADED void* ret = _lantern_dot_out_tensor_tensor_tensor(out, self, tensor); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_vdot_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_vdot_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_vdot_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_vdot_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_vdot_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_vdot_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_vdot_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_vdot_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_vdot_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_einsum_cstringview_tensorlist_intarrayref)(void* equation, void* tensors, void* path);
  HOST_API void* lantern_einsum_cstringview_tensorlist_intarrayref(void* equation, void* tensors, void* path) { LANTERN_CHECK_LOADED void* ret = _lantern_einsum_cstringview_tensorlist_intarrayref(equation, tensors, path); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_embedding_tensor_tensor_intt_bool_bool)(void* weight, void* indices, void* padding_idx, void* scale_grad_by_freq, void* sparse);
  HOST_API void* lantern_embedding_tensor_tensor_intt_bool_bool(void* weight, void* indices, void* padding_idx, void* scale_grad_by_freq, void* sparse) { LANTERN_CHECK_LOADED void* ret = _lantern_embedding_tensor_tensor_intt_bool_bool(weight, indices, padding_idx, scale_grad_by_freq, sparse); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_embedding_backward_tensor_tensor_intt_intt_bool_bool)(void* grad, void* indices, void* num_weights, void* padding_idx, void* scale_grad_by_freq, void* sparse);
  HOST_API void* lantern_embedding_backward_tensor_tensor_intt_intt_bool_bool(void* grad, void* indices, void* num_weights, void* padding_idx, void* scale_grad_by_freq, void* sparse) { LANTERN_CHECK_LOADED void* ret = _lantern_embedding_backward_tensor_tensor_intt_intt_bool_bool(grad, indices, num_weights, padding_idx, scale_grad_by_freq, sparse); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_embedding_dense_backward_tensor_tensor_intt_intt_bool)(void* grad_output, void* indices, void* num_weights, void* padding_idx, void* scale_grad_by_freq);
  HOST_API void* lantern_embedding_dense_backward_tensor_tensor_intt_intt_bool(void* grad_output, void* indices, void* num_weights, void* padding_idx, void* scale_grad_by_freq) { LANTERN_CHECK_LOADED void* ret = _lantern_embedding_dense_backward_tensor_tensor_intt_intt_bool(grad_output, indices, num_weights, padding_idx, scale_grad_by_freq); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_embedding_renorm__tensor_tensor_double_double)(void* self, void* indices, void* max_norm, void* norm_type);
  HOST_API void* lantern_embedding_renorm__tensor_tensor_double_double(void* self, void* indices, void* max_norm, void* norm_type) { LANTERN_CHECK_LOADED void* ret = _lantern_embedding_renorm__tensor_tensor_double_double(self, indices, max_norm, norm_type); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_embedding_sparse_backward_tensor_tensor_intt_intt_bool)(void* grad, void* indices, void* num_weights, void* padding_idx, void* scale_grad_by_freq);
  HOST_API void* lantern_embedding_sparse_backward_tensor_tensor_intt_intt_bool(void* grad, void* indices, void* num_weights, void* padding_idx, void* scale_grad_by_freq) { LANTERN_CHECK_LOADED void* ret = _lantern_embedding_sparse_backward_tensor_tensor_intt_intt_bool(grad, indices, num_weights, padding_idx, scale_grad_by_freq); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__embedding_bag_forward_only_tensor_tensor_tensor_bool_intt_bool_tensor_bool_intt)(void* weight, void* indices, void* offsets, void* scale_grad_by_freq, void* mode, void* sparse, void* per_sample_weights, void* include_last_offset, void* padding_idx);
  HOST_API void* lantern__embedding_bag_forward_only_tensor_tensor_tensor_bool_intt_bool_tensor_bool_intt(void* weight, void* indices, void* offsets, void* scale_grad_by_freq, void* mode, void* sparse, void* per_sample_weights, void* include_last_offset, void* padding_idx) { LANTERN_CHECK_LOADED void* ret = _lantern__embedding_bag_forward_only_tensor_tensor_tensor_bool_intt_bool_tensor_bool_intt(weight, indices, offsets, scale_grad_by_freq, mode, sparse, per_sample_weights, include_last_offset, padding_idx); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__rowwise_prune_tensor_tensor_scalartype)(void* weight, void* mask, void* compressed_indices_dtype);
  HOST_API void* lantern__rowwise_prune_tensor_tensor_scalartype(void* weight, void* mask, void* compressed_indices_dtype) { LANTERN_CHECK_LOADED void* ret = _lantern__rowwise_prune_tensor_tensor_scalartype(weight, mask, compressed_indices_dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_row_stack_tensorlist)(void* tensors);
  HOST_API void* lantern_row_stack_tensorlist(void* tensors) { LANTERN_CHECK_LOADED void* ret = _lantern_row_stack_tensorlist(tensors); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_row_stack_out_tensor_tensorlist)(void* out, void* tensors);
  HOST_API void* lantern_row_stack_out_tensor_tensorlist(void* out, void* tensors) { LANTERN_CHECK_LOADED void* ret = _lantern_row_stack_out_tensor_tensorlist(out, tensors); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_embedding_bag_tensor_tensor_tensor_bool_intt_bool_tensor_bool)(void* weight, void* indices, void* offsets, void* scale_grad_by_freq, void* mode, void* sparse, void* per_sample_weights, void* include_last_offset);
  HOST_API void* lantern_embedding_bag_tensor_tensor_tensor_bool_intt_bool_tensor_bool(void* weight, void* indices, void* offsets, void* scale_grad_by_freq, void* mode, void* sparse, void* per_sample_weights, void* include_last_offset) { LANTERN_CHECK_LOADED void* ret = _lantern_embedding_bag_tensor_tensor_tensor_bool_intt_bool_tensor_bool(weight, indices, offsets, scale_grad_by_freq, mode, sparse, per_sample_weights, include_last_offset); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_embedding_bag_tensor_tensor_tensor_bool_intt_bool_tensor_bool_intt)(void* weight, void* indices, void* offsets, void* scale_grad_by_freq, void* mode, void* sparse, void* per_sample_weights, void* include_last_offset, void* padding_idx);
  HOST_API void* lantern_embedding_bag_tensor_tensor_tensor_bool_intt_bool_tensor_bool_intt(void* weight, void* indices, void* offsets, void* scale_grad_by_freq, void* mode, void* sparse, void* per_sample_weights, void* include_last_offset, void* padding_idx) { LANTERN_CHECK_LOADED void* ret = _lantern_embedding_bag_tensor_tensor_tensor_bool_intt_bool_tensor_bool_intt(weight, indices, offsets, scale_grad_by_freq, mode, sparse, per_sample_weights, include_last_offset, padding_idx); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__embedding_bag_tensor_tensor_tensor_bool_intt_bool_tensor_bool_intt)(void* weight, void* indices, void* offsets, void* scale_grad_by_freq, void* mode, void* sparse, void* per_sample_weights, void* include_last_offset, void* padding_idx);
  HOST_API void* lantern__embedding_bag_tensor_tensor_tensor_bool_intt_bool_tensor_bool_intt(void* weight, void* indices, void* offsets, void* scale_grad_by_freq, void* mode, void* sparse, void* per_sample_weights, void* include_last_offset, void* padding_idx) { LANTERN_CHECK_LOADED void* ret = _lantern__embedding_bag_tensor_tensor_tensor_bool_intt_bool_tensor_bool_intt(weight, indices, offsets, scale_grad_by_freq, mode, sparse, per_sample_weights, include_last_offset, padding_idx); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__embedding_bag_backward_tensor_tensor_tensor_tensor_tensor_tensor_intt_bool_intt_bool_tensor_intt)(void* grad, void* indices, void* offsets, void* offset2bag, void* bag_size, void* maximum_indices, void* num_weights, void* scale_grad_by_freq, void* mode, void* sparse, void* per_sample_weights, void* padding_idx);
  HOST_API void* lantern__embedding_bag_backward_tensor_tensor_tensor_tensor_tensor_tensor_intt_bool_intt_bool_tensor_intt(void* grad, void* indices, void* offsets, void* offset2bag, void* bag_size, void* maximum_indices, void* num_weights, void* scale_grad_by_freq, void* mode, void* sparse, void* per_sample_weights, void* padding_idx) { LANTERN_CHECK_LOADED void* ret = _lantern__embedding_bag_backward_tensor_tensor_tensor_tensor_tensor_tensor_intt_bool_intt_bool_tensor_intt(grad, indices, offsets, offset2bag, bag_size, maximum_indices, num_weights, scale_grad_by_freq, mode, sparse, per_sample_weights, padding_idx); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__embedding_bag_sparse_backward_tensor_tensor_tensor_tensor_tensor_intt_bool_intt_tensor_intt)(void* grad, void* indices, void* offsets, void* offset2bag, void* bag_size, void* num_weights, void* scale_grad_by_freq, void* mode, void* per_sample_weights, void* padding_idx);
  HOST_API void* lantern__embedding_bag_sparse_backward_tensor_tensor_tensor_tensor_tensor_intt_bool_intt_tensor_intt(void* grad, void* indices, void* offsets, void* offset2bag, void* bag_size, void* num_weights, void* scale_grad_by_freq, void* mode, void* per_sample_weights, void* padding_idx) { LANTERN_CHECK_LOADED void* ret = _lantern__embedding_bag_sparse_backward_tensor_tensor_tensor_tensor_tensor_intt_bool_intt_tensor_intt(grad, indices, offsets, offset2bag, bag_size, num_weights, scale_grad_by_freq, mode, per_sample_weights, padding_idx); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__embedding_bag_dense_backward_tensor_tensor_tensor_tensor_tensor_intt_bool_intt_tensor_intt)(void* grad, void* indices, void* offset2bag, void* bag_size, void* maximum_indices, void* num_weights, void* scale_grad_by_freq, void* mode, void* per_sample_weights, void* padding_idx);
  HOST_API void* lantern__embedding_bag_dense_backward_tensor_tensor_tensor_tensor_tensor_intt_bool_intt_tensor_intt(void* grad, void* indices, void* offset2bag, void* bag_size, void* maximum_indices, void* num_weights, void* scale_grad_by_freq, void* mode, void* per_sample_weights, void* padding_idx) { LANTERN_CHECK_LOADED void* ret = _lantern__embedding_bag_dense_backward_tensor_tensor_tensor_tensor_tensor_intt_bool_intt_tensor_intt(grad, indices, offset2bag, bag_size, maximum_indices, num_weights, scale_grad_by_freq, mode, per_sample_weights, padding_idx); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__embedding_bag_per_sample_weights_backward_tensor_tensor_tensor_tensor_tensor_intt_intt)(void* grad, void* weight, void* indices, void* offsets, void* offset2bag, void* mode, void* padding_idx);
  HOST_API void* lantern__embedding_bag_per_sample_weights_backward_tensor_tensor_tensor_tensor_tensor_intt_intt(void* grad, void* weight, void* indices, void* offsets, void* offset2bag, void* mode, void* padding_idx) { LANTERN_CHECK_LOADED void* ret = _lantern__embedding_bag_per_sample_weights_backward_tensor_tensor_tensor_tensor_tensor_intt_intt(grad, weight, indices, offsets, offset2bag, mode, padding_idx); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_empty_intarrayref_dimnamelist_tensoroptions_memoryformat)(void* size, void* names, void* options, void* memory_format);
  HOST_API void* lantern_empty_intarrayref_dimnamelist_tensoroptions_memoryformat(void* size, void* names, void* options, void* memory_format) { LANTERN_CHECK_LOADED void* ret = _lantern_empty_intarrayref_dimnamelist_tensoroptions_memoryformat(size, names, options, memory_format); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_empty_intarrayref_tensoroptions_memoryformat)(void* size, void* options, void* memory_format);
  HOST_API void* lantern_empty_intarrayref_tensoroptions_memoryformat(void* size, void* options, void* memory_format) { LANTERN_CHECK_LOADED void* ret = _lantern_empty_intarrayref_tensoroptions_memoryformat(size, options, memory_format); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_new_empty_tensor_intarrayref_tensoroptions)(void* self, void* size, void* options);
  HOST_API void* lantern_Tensor_new_empty_tensor_intarrayref_tensoroptions(void* self, void* size, void* options) { void* ret = _lantern_Tensor_new_empty_tensor_intarrayref_tensoroptions(self, size, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_new_empty_strided_tensor_intarrayref_intarrayref_tensoroptions)(void* self, void* size, void* stride, void* options);
  HOST_API void* lantern_Tensor_new_empty_strided_tensor_intarrayref_intarrayref_tensoroptions(void* self, void* size, void* stride, void* options) { void* ret = _lantern_Tensor_new_empty_strided_tensor_intarrayref_intarrayref_tensoroptions(self, size, stride, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_new_full_tensor_intarrayref_scalar_tensoroptions)(void* self, void* size, void* fill_value, void* options);
  HOST_API void* lantern_Tensor_new_full_tensor_intarrayref_scalar_tensoroptions(void* self, void* size, void* fill_value, void* options) { void* ret = _lantern_Tensor_new_full_tensor_intarrayref_scalar_tensoroptions(self, size, fill_value, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_new_zeros_tensor_intarrayref_tensoroptions)(void* self, void* size, void* options);
  HOST_API void* lantern_Tensor_new_zeros_tensor_intarrayref_tensoroptions(void* self, void* size, void* options) { void* ret = _lantern_Tensor_new_zeros_tensor_intarrayref_tensoroptions(self, size, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_new_ones_tensor_intarrayref_tensoroptions)(void* self, void* size, void* options);
  HOST_API void* lantern_Tensor_new_ones_tensor_intarrayref_tensoroptions(void* self, void* size, void* options) { void* ret = _lantern_Tensor_new_ones_tensor_intarrayref_tensoroptions(self, size, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__empty_affine_quantized_intarrayref_tensoroptions_double_intt_memoryformat)(void* size, void* options, void* scale, void* zero_point, void* memory_format);
  HOST_API void* lantern__empty_affine_quantized_intarrayref_tensoroptions_double_intt_memoryformat(void* size, void* options, void* scale, void* zero_point, void* memory_format) { LANTERN_CHECK_LOADED void* ret = _lantern__empty_affine_quantized_intarrayref_tensoroptions_double_intt_memoryformat(size, options, scale, zero_point, memory_format); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__empty_per_channel_affine_quantized_intarrayref_tensor_tensor_intt_tensoroptions_memoryformat)(void* size, void* scales, void* zero_points, void* axis, void* options, void* memory_format);
  HOST_API void* lantern__empty_per_channel_affine_quantized_intarrayref_tensor_tensor_intt_tensoroptions_memoryformat(void* size, void* scales, void* zero_points, void* axis, void* options, void* memory_format) { LANTERN_CHECK_LOADED void* ret = _lantern__empty_per_channel_affine_quantized_intarrayref_tensor_tensor_intt_tensoroptions_memoryformat(size, scales, zero_points, axis, options, memory_format); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_resize__tensor_intarrayref_memoryformat)(void* self, void* size, void* memory_format);
  HOST_API void* lantern_Tensor_resize__tensor_intarrayref_memoryformat(void* self, void* size, void* memory_format) { void* ret = _lantern_Tensor_resize__tensor_intarrayref_memoryformat(self, size, memory_format); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__resize_output__tensor_intarrayref_device)(void* self, void* size, void* device);
  HOST_API void* lantern__resize_output__tensor_intarrayref_device(void* self, void* size, void* device) { LANTERN_CHECK_LOADED void* ret = _lantern__resize_output__tensor_intarrayref_device(self, size, device); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_empty_quantized_intarrayref_tensor_tensoroptions_memoryformat)(void* size, void* qtensor, void* options, void* memory_format);
  HOST_API void* lantern_empty_quantized_intarrayref_tensor_tensoroptions_memoryformat(void* size, void* qtensor, void* options, void* memory_format) { LANTERN_CHECK_LOADED void* ret = _lantern_empty_quantized_intarrayref_tensor_tensoroptions_memoryformat(size, qtensor, options, memory_format); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_empty_out_tensor_intarrayref_memoryformat)(void* out, void* size, void* memory_format);
  HOST_API void* lantern_empty_out_tensor_intarrayref_memoryformat(void* out, void* size, void* memory_format) { LANTERN_CHECK_LOADED void* ret = _lantern_empty_out_tensor_intarrayref_memoryformat(out, size, memory_format); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_empty_like_tensor_tensoroptions_memoryformat)(void* self, void* options, void* memory_format);
  HOST_API void* lantern_empty_like_tensor_tensoroptions_memoryformat(void* self, void* options, void* memory_format) { LANTERN_CHECK_LOADED void* ret = _lantern_empty_like_tensor_tensoroptions_memoryformat(self, options, memory_format); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_empty_strided_intarrayref_intarrayref_tensoroptions)(void* size, void* stride, void* options);
  HOST_API void* lantern_empty_strided_intarrayref_intarrayref_tensoroptions(void* size, void* stride, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_empty_strided_intarrayref_intarrayref_tensoroptions(size, stride, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_erf_tensor)(void* self);
  HOST_API void* lantern_erf_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_erf_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_erf_tensor)(void* self);
  HOST_API void* lantern_Tensor_erf_tensor(void* self) { void* ret = _lantern_Tensor_erf_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_erf__tensor)(void* self);
  HOST_API void* lantern_erf__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_erf__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_erf__tensor)(void* self);
  HOST_API void* lantern_Tensor_erf__tensor(void* self) { void* ret = _lantern_Tensor_erf__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_erf_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_erf_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_erf_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_erfc_tensor)(void* self);
  HOST_API void* lantern_erfc_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_erfc_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_erfc_tensor)(void* self);
  HOST_API void* lantern_Tensor_erfc_tensor(void* self) { void* ret = _lantern_Tensor_erfc_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_erfc__tensor)(void* self);
  HOST_API void* lantern_erfc__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_erfc__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_erfc__tensor)(void* self);
  HOST_API void* lantern_Tensor_erfc__tensor(void* self) { void* ret = _lantern_Tensor_erfc__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_erfc_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_erfc_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_erfc_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_exp_tensor)(void* self);
  HOST_API void* lantern_exp_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_exp_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_exp_tensor)(void* self);
  HOST_API void* lantern_Tensor_exp_tensor(void* self) { void* ret = _lantern_Tensor_exp_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_exp__tensor)(void* self);
  HOST_API void* lantern_exp__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_exp__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_exp__tensor)(void* self);
  HOST_API void* lantern_Tensor_exp__tensor(void* self) { void* ret = _lantern_Tensor_exp__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_exp_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_exp_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_exp_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_exp2_tensor)(void* self);
  HOST_API void* lantern_exp2_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_exp2_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_exp2_tensor)(void* self);
  HOST_API void* lantern_Tensor_exp2_tensor(void* self) { void* ret = _lantern_Tensor_exp2_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_exp2__tensor)(void* self);
  HOST_API void* lantern_exp2__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_exp2__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_exp2__tensor)(void* self);
  HOST_API void* lantern_Tensor_exp2__tensor(void* self) { void* ret = _lantern_Tensor_exp2__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_exp2_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_exp2_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_exp2_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_expm1_tensor)(void* self);
  HOST_API void* lantern_expm1_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_expm1_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_expm1_tensor)(void* self);
  HOST_API void* lantern_Tensor_expm1_tensor(void* self) { void* ret = _lantern_Tensor_expm1_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_expm1__tensor)(void* self);
  HOST_API void* lantern_expm1__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_expm1__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_expm1__tensor)(void* self);
  HOST_API void* lantern_Tensor_expm1__tensor(void* self) { void* ret = _lantern_Tensor_expm1__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_expm1_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_expm1_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_expm1_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_expand_tensor_intarrayref_bool)(void* self, void* size, void* implicit);
  HOST_API void* lantern_Tensor_expand_tensor_intarrayref_bool(void* self, void* size, void* implicit) { void* ret = _lantern_Tensor_expand_tensor_intarrayref_bool(self, size, implicit); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_expand_as_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_expand_as_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_expand_as_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_eye_intt_tensoroptions)(void* n, void* options);
  HOST_API void* lantern_eye_intt_tensoroptions(void* n, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_eye_intt_tensoroptions(n, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_eye_intt_intt_tensoroptions)(void* n, void* m, void* options);
  HOST_API void* lantern_eye_intt_intt_tensoroptions(void* n, void* m, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_eye_intt_intt_tensoroptions(n, m, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_eye_out_tensor_intt)(void* out, void* n);
  HOST_API void* lantern_eye_out_tensor_intt(void* out, void* n) { LANTERN_CHECK_LOADED void* ret = _lantern_eye_out_tensor_intt(out, n); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_eye_out_tensor_intt_intt)(void* out, void* n, void* m);
  HOST_API void* lantern_eye_out_tensor_intt_intt(void* out, void* n, void* m) { LANTERN_CHECK_LOADED void* ret = _lantern_eye_out_tensor_intt_intt(out, n, m); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_flatten_tensor_intt_intt)(void* self, void* start_dim, void* end_dim);
  HOST_API void* lantern_flatten_tensor_intt_intt(void* self, void* start_dim, void* end_dim) { LANTERN_CHECK_LOADED void* ret = _lantern_flatten_tensor_intt_intt(self, start_dim, end_dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_flatten_tensor_intt_intt)(void* self, void* start_dim, void* end_dim);
  HOST_API void* lantern_Tensor_flatten_tensor_intt_intt(void* self, void* start_dim, void* end_dim) { void* ret = _lantern_Tensor_flatten_tensor_intt_intt(self, start_dim, end_dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_flatten_tensor_intt_intt_dimname)(void* self, void* start_dim, void* end_dim, void* out_dim);
  HOST_API void* lantern_flatten_tensor_intt_intt_dimname(void* self, void* start_dim, void* end_dim, void* out_dim) { LANTERN_CHECK_LOADED void* ret = _lantern_flatten_tensor_intt_intt_dimname(self, start_dim, end_dim, out_dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_flatten_tensor_intt_intt_dimname)(void* self, void* start_dim, void* end_dim, void* out_dim);
  HOST_API void* lantern_Tensor_flatten_tensor_intt_intt_dimname(void* self, void* start_dim, void* end_dim, void* out_dim) { void* ret = _lantern_Tensor_flatten_tensor_intt_intt_dimname(self, start_dim, end_dim, out_dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_flatten_tensor_dimname_dimname_dimname)(void* self, void* start_dim, void* end_dim, void* out_dim);
  HOST_API void* lantern_flatten_tensor_dimname_dimname_dimname(void* self, void* start_dim, void* end_dim, void* out_dim) { LANTERN_CHECK_LOADED void* ret = _lantern_flatten_tensor_dimname_dimname_dimname(self, start_dim, end_dim, out_dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_flatten_tensor_dimname_dimname_dimname)(void* self, void* start_dim, void* end_dim, void* out_dim);
  HOST_API void* lantern_Tensor_flatten_tensor_dimname_dimname_dimname(void* self, void* start_dim, void* end_dim, void* out_dim) { void* ret = _lantern_Tensor_flatten_tensor_dimname_dimname_dimname(self, start_dim, end_dim, out_dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_flatten_tensor_dimnamelist_dimname)(void* self, void* dims, void* out_dim);
  HOST_API void* lantern_flatten_tensor_dimnamelist_dimname(void* self, void* dims, void* out_dim) { LANTERN_CHECK_LOADED void* ret = _lantern_flatten_tensor_dimnamelist_dimname(self, dims, out_dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_flatten_tensor_dimnamelist_dimname)(void* self, void* dims, void* out_dim);
  HOST_API void* lantern_Tensor_flatten_tensor_dimnamelist_dimname(void* self, void* dims, void* out_dim) { void* ret = _lantern_Tensor_flatten_tensor_dimnamelist_dimname(self, dims, out_dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_unflatten_tensor_intt_intarrayref)(void* self, void* dim, void* sizes);
  HOST_API void* lantern_unflatten_tensor_intt_intarrayref(void* self, void* dim, void* sizes) { LANTERN_CHECK_LOADED void* ret = _lantern_unflatten_tensor_intt_intarrayref(self, dim, sizes); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_unflatten_tensor_intt_intarrayref)(void* self, void* dim, void* sizes);
  HOST_API void* lantern_Tensor_unflatten_tensor_intt_intarrayref(void* self, void* dim, void* sizes) { void* ret = _lantern_Tensor_unflatten_tensor_intt_intarrayref(self, dim, sizes); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_unflatten_tensor_dimname_intarrayref_dimnamelist)(void* self, void* dim, void* sizes, void* names);
  HOST_API void* lantern_unflatten_tensor_dimname_intarrayref_dimnamelist(void* self, void* dim, void* sizes, void* names) { LANTERN_CHECK_LOADED void* ret = _lantern_unflatten_tensor_dimname_intarrayref_dimnamelist(self, dim, sizes, names); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_unflatten_tensor_dimname_intarrayref_dimnamelist)(void* self, void* dim, void* sizes, void* names);
  HOST_API void* lantern_Tensor_unflatten_tensor_dimname_intarrayref_dimnamelist(void* self, void* dim, void* sizes, void* names) { void* ret = _lantern_Tensor_unflatten_tensor_dimname_intarrayref_dimnamelist(self, dim, sizes, names); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_fill_tensor_scalar)(void* self, void* value);
  HOST_API void* lantern_fill_tensor_scalar(void* self, void* value) { LANTERN_CHECK_LOADED void* ret = _lantern_fill_tensor_scalar(self, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_fill_tensor_tensor)(void* self, void* value);
  HOST_API void* lantern_fill_tensor_tensor(void* self, void* value) { LANTERN_CHECK_LOADED void* ret = _lantern_fill_tensor_tensor(self, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_fill__tensor_scalar)(void* self, void* value);
  HOST_API void* lantern_fill__tensor_scalar(void* self, void* value) { LANTERN_CHECK_LOADED void* ret = _lantern_fill__tensor_scalar(self, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_fill__tensor_scalar)(void* self, void* value);
  HOST_API void* lantern_Tensor_fill__tensor_scalar(void* self, void* value) { void* ret = _lantern_Tensor_fill__tensor_scalar(self, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_fill__tensor_tensor)(void* self, void* value);
  HOST_API void* lantern_fill__tensor_tensor(void* self, void* value) { LANTERN_CHECK_LOADED void* ret = _lantern_fill__tensor_tensor(self, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_fill__tensor_tensor)(void* self, void* value);
  HOST_API void* lantern_Tensor_fill__tensor_tensor(void* self, void* value) { void* ret = _lantern_Tensor_fill__tensor_tensor(self, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_floor_tensor)(void* self);
  HOST_API void* lantern_floor_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_floor_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_floor_tensor)(void* self);
  HOST_API void* lantern_Tensor_floor_tensor(void* self) { void* ret = _lantern_Tensor_floor_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_floor__tensor)(void* self);
  HOST_API void* lantern_floor__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_floor__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_floor__tensor)(void* self);
  HOST_API void* lantern_Tensor_floor__tensor(void* self) { void* ret = _lantern_Tensor_floor__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_floor_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_floor_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_floor_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_floor_divide_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_floor_divide_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_floor_divide_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_floor_divide_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_floor_divide_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_floor_divide_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_floor_divide__tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_floor_divide__tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_floor_divide__tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_floor_divide_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_floor_divide_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_floor_divide_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_floor_divide_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_floor_divide_tensor_scalar(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_floor_divide_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_floor_divide_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_floor_divide_tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_floor_divide_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_floor_divide__tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_floor_divide__tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_floor_divide__tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_frac_tensor)(void* self);
  HOST_API void* lantern_frac_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_frac_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_frac_tensor)(void* self);
  HOST_API void* lantern_Tensor_frac_tensor(void* self) { void* ret = _lantern_Tensor_frac_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_frac__tensor)(void* self);
  HOST_API void* lantern_frac__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_frac__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_frac__tensor)(void* self);
  HOST_API void* lantern_Tensor_frac__tensor(void* self) { void* ret = _lantern_Tensor_frac__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_frac_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_frac_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_frac_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_full_intarrayref_scalar_dimnamelist_tensoroptions)(void* size, void* fill_value, void* names, void* options);
  HOST_API void* lantern_full_intarrayref_scalar_dimnamelist_tensoroptions(void* size, void* fill_value, void* names, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_full_intarrayref_scalar_dimnamelist_tensoroptions(size, fill_value, names, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_full_intarrayref_scalar_tensoroptions)(void* size, void* fill_value, void* options);
  HOST_API void* lantern_full_intarrayref_scalar_tensoroptions(void* size, void* fill_value, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_full_intarrayref_scalar_tensoroptions(size, fill_value, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_full_out_tensor_intarrayref_scalar)(void* out, void* size, void* fill_value);
  HOST_API void* lantern_full_out_tensor_intarrayref_scalar(void* out, void* size, void* fill_value) { LANTERN_CHECK_LOADED void* ret = _lantern_full_out_tensor_intarrayref_scalar(out, size, fill_value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_full_like_tensor_scalar_tensoroptions_memoryformat)(void* self, void* fill_value, void* options, void* memory_format);
  HOST_API void* lantern_full_like_tensor_scalar_tensoroptions_memoryformat(void* self, void* fill_value, void* options, void* memory_format) { LANTERN_CHECK_LOADED void* ret = _lantern_full_like_tensor_scalar_tensoroptions_memoryformat(self, fill_value, options, memory_format); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_from_file_cstringview_bool_intt_tensoroptions)(void* filename, void* shared, void* size, void* options);
  HOST_API void* lantern_from_file_cstringview_bool_intt_tensoroptions(void* filename, void* shared, void* size, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_from_file_cstringview_bool_intt_tensoroptions(filename, shared, size, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_gcd_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_gcd_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_gcd_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_gcd_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_gcd_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_gcd_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_gcd_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_gcd_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_gcd_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_gcd__tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_gcd__tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_gcd__tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_gcd__tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_gcd__tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_gcd__tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_lcm_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_lcm_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_lcm_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_lcm_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_lcm_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_lcm_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_lcm_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_lcm_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_lcm_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_lcm__tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_lcm__tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_lcm__tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_lcm__tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_lcm__tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_lcm__tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_grid_sampler_tensor_tensor_intt_intt_bool)(void* input, void* grid, void* interpolation_mode, void* padding_mode, void* align_corners);
  HOST_API void* lantern_grid_sampler_tensor_tensor_intt_intt_bool(void* input, void* grid, void* interpolation_mode, void* padding_mode, void* align_corners) { LANTERN_CHECK_LOADED void* ret = _lantern_grid_sampler_tensor_tensor_intt_intt_bool(input, grid, interpolation_mode, padding_mode, align_corners); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_grid_sampler_2d_tensor_tensor_intt_intt_bool)(void* input, void* grid, void* interpolation_mode, void* padding_mode, void* align_corners);
  HOST_API void* lantern_grid_sampler_2d_tensor_tensor_intt_intt_bool(void* input, void* grid, void* interpolation_mode, void* padding_mode, void* align_corners) { LANTERN_CHECK_LOADED void* ret = _lantern_grid_sampler_2d_tensor_tensor_intt_intt_bool(input, grid, interpolation_mode, padding_mode, align_corners); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_grid_sampler_2d_backward_tensor_tensor_tensor_intt_intt_bool_stdarraybool)(void* grad_output, void* input, void* grid, void* interpolation_mode, void* padding_mode, void* align_corners, void* output_mask);
  HOST_API void* lantern_grid_sampler_2d_backward_tensor_tensor_tensor_intt_intt_bool_stdarraybool(void* grad_output, void* input, void* grid, void* interpolation_mode, void* padding_mode, void* align_corners, void* output_mask) { LANTERN_CHECK_LOADED void* ret = _lantern_grid_sampler_2d_backward_tensor_tensor_tensor_intt_intt_bool_stdarraybool(grad_output, input, grid, interpolation_mode, padding_mode, align_corners, output_mask); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__grid_sampler_2d_cpu_fallback_tensor_tensor_intt_intt_bool)(void* input, void* grid, void* interpolation_mode, void* padding_mode, void* align_corners);
  HOST_API void* lantern__grid_sampler_2d_cpu_fallback_tensor_tensor_intt_intt_bool(void* input, void* grid, void* interpolation_mode, void* padding_mode, void* align_corners) { LANTERN_CHECK_LOADED void* ret = _lantern__grid_sampler_2d_cpu_fallback_tensor_tensor_intt_intt_bool(input, grid, interpolation_mode, padding_mode, align_corners); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__grid_sampler_2d_cpu_fallback_backward_tensor_tensor_tensor_intt_intt_bool)(void* grad_output, void* input, void* grid, void* interpolation_mode, void* padding_mode, void* align_corners);
  HOST_API void* lantern__grid_sampler_2d_cpu_fallback_backward_tensor_tensor_tensor_intt_intt_bool(void* grad_output, void* input, void* grid, void* interpolation_mode, void* padding_mode, void* align_corners) { LANTERN_CHECK_LOADED void* ret = _lantern__grid_sampler_2d_cpu_fallback_backward_tensor_tensor_tensor_intt_intt_bool(grad_output, input, grid, interpolation_mode, padding_mode, align_corners); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_grid_sampler_3d_tensor_tensor_intt_intt_bool)(void* input, void* grid, void* interpolation_mode, void* padding_mode, void* align_corners);
  HOST_API void* lantern_grid_sampler_3d_tensor_tensor_intt_intt_bool(void* input, void* grid, void* interpolation_mode, void* padding_mode, void* align_corners) { LANTERN_CHECK_LOADED void* ret = _lantern_grid_sampler_3d_tensor_tensor_intt_intt_bool(input, grid, interpolation_mode, padding_mode, align_corners); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_grid_sampler_3d_backward_tensor_tensor_tensor_intt_intt_bool_stdarraybool)(void* grad_output, void* input, void* grid, void* interpolation_mode, void* padding_mode, void* align_corners, void* output_mask);
  HOST_API void* lantern_grid_sampler_3d_backward_tensor_tensor_tensor_intt_intt_bool_stdarraybool(void* grad_output, void* input, void* grid, void* interpolation_mode, void* padding_mode, void* align_corners, void* output_mask) { LANTERN_CHECK_LOADED void* ret = _lantern_grid_sampler_3d_backward_tensor_tensor_tensor_intt_intt_bool_stdarraybool(grad_output, input, grid, interpolation_mode, padding_mode, align_corners, output_mask); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_hann_window_intt_tensoroptions)(void* window_length, void* options);
  HOST_API void* lantern_hann_window_intt_tensoroptions(void* window_length, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_hann_window_intt_tensoroptions(window_length, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_hann_window_intt_bool_tensoroptions)(void* window_length, void* periodic, void* options);
  HOST_API void* lantern_hann_window_intt_bool_tensoroptions(void* window_length, void* periodic, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_hann_window_intt_bool_tensoroptions(window_length, periodic, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_hamming_window_intt_tensoroptions)(void* window_length, void* options);
  HOST_API void* lantern_hamming_window_intt_tensoroptions(void* window_length, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_hamming_window_intt_tensoroptions(window_length, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_hamming_window_intt_bool_tensoroptions)(void* window_length, void* periodic, void* options);
  HOST_API void* lantern_hamming_window_intt_bool_tensoroptions(void* window_length, void* periodic, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_hamming_window_intt_bool_tensoroptions(window_length, periodic, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_hamming_window_intt_bool_double_tensoroptions)(void* window_length, void* periodic, void* alpha, void* options);
  HOST_API void* lantern_hamming_window_intt_bool_double_tensoroptions(void* window_length, void* periodic, void* alpha, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_hamming_window_intt_bool_double_tensoroptions(window_length, periodic, alpha, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_hamming_window_intt_bool_double_double_tensoroptions)(void* window_length, void* periodic, void* alpha, void* beta, void* options);
  HOST_API void* lantern_hamming_window_intt_bool_double_double_tensoroptions(void* window_length, void* periodic, void* alpha, void* beta, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_hamming_window_intt_bool_double_double_tensoroptions(window_length, periodic, alpha, beta, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_kaiser_window_intt_tensoroptions)(void* window_length, void* options);
  HOST_API void* lantern_kaiser_window_intt_tensoroptions(void* window_length, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_kaiser_window_intt_tensoroptions(window_length, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_kaiser_window_intt_bool_tensoroptions)(void* window_length, void* periodic, void* options);
  HOST_API void* lantern_kaiser_window_intt_bool_tensoroptions(void* window_length, void* periodic, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_kaiser_window_intt_bool_tensoroptions(window_length, periodic, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_kaiser_window_intt_bool_double_tensoroptions)(void* window_length, void* periodic, void* beta, void* options);
  HOST_API void* lantern_kaiser_window_intt_bool_double_tensoroptions(void* window_length, void* periodic, void* beta, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_kaiser_window_intt_bool_double_tensoroptions(window_length, periodic, beta, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_hinge_embedding_loss_tensor_tensor_double_intt)(void* self, void* target, void* margin, void* reduction);
  HOST_API void* lantern_hinge_embedding_loss_tensor_tensor_double_intt(void* self, void* target, void* margin, void* reduction) { LANTERN_CHECK_LOADED void* ret = _lantern_hinge_embedding_loss_tensor_tensor_double_intt(self, target, margin, reduction); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_group_norm_tensor_intt_tensor_tensor_double_bool)(void* input, void* num_groups, void* weight, void* bias, void* eps, void* cudnn_enabled);
  HOST_API void* lantern_group_norm_tensor_intt_tensor_tensor_double_bool(void* input, void* num_groups, void* weight, void* bias, void* eps, void* cudnn_enabled) { LANTERN_CHECK_LOADED void* ret = _lantern_group_norm_tensor_intt_tensor_tensor_double_bool(input, num_groups, weight, bias, eps, cudnn_enabled); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_native_group_norm_tensor_tensor_tensor_intt_intt_intt_intt_double)(void* input, void* weight, void* bias, void* N, void* C, void* HxW, void* group, void* eps);
  HOST_API void* lantern_native_group_norm_tensor_tensor_tensor_intt_intt_intt_intt_double(void* input, void* weight, void* bias, void* N, void* C, void* HxW, void* group, void* eps) { LANTERN_CHECK_LOADED void* ret = _lantern_native_group_norm_tensor_tensor_tensor_intt_intt_intt_intt_double(input, weight, bias, N, C, HxW, group, eps); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_native_group_norm_backward_tensor_tensor_tensor_tensor_tensor_intt_intt_intt_intt_stdarraybool)(void* grad_out, void* input, void* mean, void* rstd, void* weight, void* N, void* C, void* HxW, void* group, void* output_mask);
  HOST_API void* lantern_native_group_norm_backward_tensor_tensor_tensor_tensor_tensor_intt_intt_intt_intt_stdarraybool(void* grad_out, void* input, void* mean, void* rstd, void* weight, void* N, void* C, void* HxW, void* group, void* output_mask) { LANTERN_CHECK_LOADED void* ret = _lantern_native_group_norm_backward_tensor_tensor_tensor_tensor_tensor_intt_intt_intt_intt_stdarraybool(grad_out, input, mean, rstd, weight, N, C, HxW, group, output_mask); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__fft_r2c_tensor_intarrayref_intt_bool)(void* self, void* dim, void* normalization, void* onesided);
  HOST_API void* lantern__fft_r2c_tensor_intarrayref_intt_bool(void* self, void* dim, void* normalization, void* onesided) { LANTERN_CHECK_LOADED void* ret = _lantern__fft_r2c_tensor_intarrayref_intt_bool(self, dim, normalization, onesided); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__fft_r2c_out_tensor_tensor_intarrayref_intt_bool)(void* out, void* self, void* dim, void* normalization, void* onesided);
  HOST_API void* lantern__fft_r2c_out_tensor_tensor_intarrayref_intt_bool(void* out, void* self, void* dim, void* normalization, void* onesided) { LANTERN_CHECK_LOADED void* ret = _lantern__fft_r2c_out_tensor_tensor_intarrayref_intt_bool(out, self, dim, normalization, onesided); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__fft_c2r_tensor_intarrayref_intt_intt)(void* self, void* dim, void* normalization, void* last_dim_size);
  HOST_API void* lantern__fft_c2r_tensor_intarrayref_intt_intt(void* self, void* dim, void* normalization, void* last_dim_size) { LANTERN_CHECK_LOADED void* ret = _lantern__fft_c2r_tensor_intarrayref_intt_intt(self, dim, normalization, last_dim_size); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__fft_c2r_out_tensor_tensor_intarrayref_intt_intt)(void* out, void* self, void* dim, void* normalization, void* last_dim_size);
  HOST_API void* lantern__fft_c2r_out_tensor_tensor_intarrayref_intt_intt(void* out, void* self, void* dim, void* normalization, void* last_dim_size) { LANTERN_CHECK_LOADED void* ret = _lantern__fft_c2r_out_tensor_tensor_intarrayref_intt_intt(out, self, dim, normalization, last_dim_size); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__fft_c2c_tensor_intarrayref_intt_bool)(void* self, void* dim, void* normalization, void* forward);
  HOST_API void* lantern__fft_c2c_tensor_intarrayref_intt_bool(void* self, void* dim, void* normalization, void* forward) { LANTERN_CHECK_LOADED void* ret = _lantern__fft_c2c_tensor_intarrayref_intt_bool(self, dim, normalization, forward); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__fft_c2c_out_tensor_tensor_intarrayref_intt_bool)(void* out, void* self, void* dim, void* normalization, void* forward);
  HOST_API void* lantern__fft_c2c_out_tensor_tensor_intarrayref_intt_bool(void* out, void* self, void* dim, void* normalization, void* forward) { LANTERN_CHECK_LOADED void* ret = _lantern__fft_c2c_out_tensor_tensor_intarrayref_intt_bool(out, self, dim, normalization, forward); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__validate_compressed_sparse_indices_bool_tensor_tensor_intt_intt_intt)(void* is_crow, void* compressed_idx, void* plain_idx, void* cdim, void* dim, void* nnz);
  HOST_API void* lantern__validate_compressed_sparse_indices_bool_tensor_tensor_intt_intt_intt(void* is_crow, void* compressed_idx, void* plain_idx, void* cdim, void* dim, void* nnz) { LANTERN_CHECK_LOADED void* ret = _lantern__validate_compressed_sparse_indices_bool_tensor_tensor_intt_intt_intt(is_crow, compressed_idx, plain_idx, cdim, dim, nnz); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__cufft_get_plan_cache_size_intt)(void* device_index);
  HOST_API void* lantern__cufft_get_plan_cache_size_intt(void* device_index) { LANTERN_CHECK_LOADED void* ret = _lantern__cufft_get_plan_cache_size_intt(device_index); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__cufft_get_plan_cache_max_size_intt)(void* device_index);
  HOST_API void* lantern__cufft_get_plan_cache_max_size_intt(void* device_index) { LANTERN_CHECK_LOADED void* ret = _lantern__cufft_get_plan_cache_max_size_intt(device_index); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__cufft_set_plan_cache_max_size_intt_intt)(void* device_index, void* max_size);
  HOST_API void* lantern__cufft_set_plan_cache_max_size_intt_intt(void* device_index, void* max_size) { LANTERN_CHECK_LOADED void* ret = _lantern__cufft_set_plan_cache_max_size_intt_intt(device_index, max_size); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__cufft_clear_plan_cache_intt)(void* device_index);
  HOST_API void* lantern__cufft_clear_plan_cache_intt(void* device_index) { LANTERN_CHECK_LOADED void* ret = _lantern__cufft_clear_plan_cache_intt(device_index); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_index_tensor_constclistcoptionaltensor)(void* self, void* indices);
  HOST_API void* lantern_index_tensor_constclistcoptionaltensor(void* self, void* indices) { LANTERN_CHECK_LOADED void* ret = _lantern_index_tensor_constclistcoptionaltensor(self, indices); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_index_tensor_constclistcoptionaltensor)(void* self, void* indices);
  HOST_API void* lantern_Tensor_index_tensor_constclistcoptionaltensor(void* self, void* indices) { void* ret = _lantern_Tensor_index_tensor_constclistcoptionaltensor(self, indices); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_index_out_tensor_tensor_constclistcoptionaltensor)(void* out, void* self, void* indices);
  HOST_API void* lantern_index_out_tensor_tensor_constclistcoptionaltensor(void* out, void* self, void* indices) { LANTERN_CHECK_LOADED void* ret = _lantern_index_out_tensor_tensor_constclistcoptionaltensor(out, self, indices); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_index_copy_out_tensor_tensor_intt_tensor_tensor)(void* out, void* self, void* dim, void* index, void* source);
  HOST_API void* lantern_index_copy_out_tensor_tensor_intt_tensor_tensor(void* out, void* self, void* dim, void* index, void* source) { LANTERN_CHECK_LOADED void* ret = _lantern_index_copy_out_tensor_tensor_intt_tensor_tensor(out, self, dim, index, source); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_index_copy__tensor_intt_tensor_tensor)(void* self, void* dim, void* index, void* source);
  HOST_API void* lantern_Tensor_index_copy__tensor_intt_tensor_tensor(void* self, void* dim, void* index, void* source) { void* ret = _lantern_Tensor_index_copy__tensor_intt_tensor_tensor(self, dim, index, source); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_index_copy_tensor_intt_tensor_tensor)(void* self, void* dim, void* index, void* source);
  HOST_API void* lantern_index_copy_tensor_intt_tensor_tensor(void* self, void* dim, void* index, void* source) { LANTERN_CHECK_LOADED void* ret = _lantern_index_copy_tensor_intt_tensor_tensor(self, dim, index, source); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_index_copy_tensor_intt_tensor_tensor)(void* self, void* dim, void* index, void* source);
  HOST_API void* lantern_Tensor_index_copy_tensor_intt_tensor_tensor(void* self, void* dim, void* index, void* source) { void* ret = _lantern_Tensor_index_copy_tensor_intt_tensor_tensor(self, dim, index, source); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_index_copy__tensor_dimname_tensor_tensor)(void* self, void* dim, void* index, void* source);
  HOST_API void* lantern_Tensor_index_copy__tensor_dimname_tensor_tensor(void* self, void* dim, void* index, void* source) { void* ret = _lantern_Tensor_index_copy__tensor_dimname_tensor_tensor(self, dim, index, source); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_index_copy_tensor_dimname_tensor_tensor)(void* self, void* dim, void* index, void* source);
  HOST_API void* lantern_index_copy_tensor_dimname_tensor_tensor(void* self, void* dim, void* index, void* source) { LANTERN_CHECK_LOADED void* ret = _lantern_index_copy_tensor_dimname_tensor_tensor(self, dim, index, source); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_index_copy_tensor_dimname_tensor_tensor)(void* self, void* dim, void* index, void* source);
  HOST_API void* lantern_Tensor_index_copy_tensor_dimname_tensor_tensor(void* self, void* dim, void* index, void* source) { void* ret = _lantern_Tensor_index_copy_tensor_dimname_tensor_tensor(self, dim, index, source); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_index_put__tensor_constclistcoptionaltensor_tensor_bool)(void* self, void* indices, void* values, void* accumulate);
  HOST_API void* lantern_index_put__tensor_constclistcoptionaltensor_tensor_bool(void* self, void* indices, void* values, void* accumulate) { LANTERN_CHECK_LOADED void* ret = _lantern_index_put__tensor_constclistcoptionaltensor_tensor_bool(self, indices, values, accumulate); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_index_put__tensor_constclistcoptionaltensor_tensor_bool)(void* self, void* indices, void* values, void* accumulate);
  HOST_API void* lantern_Tensor_index_put__tensor_constclistcoptionaltensor_tensor_bool(void* self, void* indices, void* values, void* accumulate) { void* ret = _lantern_Tensor_index_put__tensor_constclistcoptionaltensor_tensor_bool(self, indices, values, accumulate); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_index_put_tensor_constclistcoptionaltensor_tensor_bool)(void* self, void* indices, void* values, void* accumulate);
  HOST_API void* lantern_index_put_tensor_constclistcoptionaltensor_tensor_bool(void* self, void* indices, void* values, void* accumulate) { LANTERN_CHECK_LOADED void* ret = _lantern_index_put_tensor_constclistcoptionaltensor_tensor_bool(self, indices, values, accumulate); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_index_put_tensor_constclistcoptionaltensor_tensor_bool)(void* self, void* indices, void* values, void* accumulate);
  HOST_API void* lantern_Tensor_index_put_tensor_constclistcoptionaltensor_tensor_bool(void* self, void* indices, void* values, void* accumulate) { void* ret = _lantern_Tensor_index_put_tensor_constclistcoptionaltensor_tensor_bool(self, indices, values, accumulate); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__index_put_impl__tensor_constclistcoptionaltensor_tensor_bool_bool)(void* self, void* indices, void* values, void* accumulate, void* unsafe);
  HOST_API void* lantern__index_put_impl__tensor_constclistcoptionaltensor_tensor_bool_bool(void* self, void* indices, void* values, void* accumulate, void* unsafe) { LANTERN_CHECK_LOADED void* ret = _lantern__index_put_impl__tensor_constclistcoptionaltensor_tensor_bool_bool(self, indices, values, accumulate, unsafe); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_instance_norm_tensor_tensor_tensor_tensor_tensor_bool_double_double_bool)(void* input, void* weight, void* bias, void* running_mean, void* running_var, void* use_input_stats, void* momentum, void* eps, void* cudnn_enabled);
  HOST_API void* lantern_instance_norm_tensor_tensor_tensor_tensor_tensor_bool_double_double_bool(void* input, void* weight, void* bias, void* running_mean, void* running_var, void* use_input_stats, void* momentum, void* eps, void* cudnn_enabled) { LANTERN_CHECK_LOADED void* ret = _lantern_instance_norm_tensor_tensor_tensor_tensor_tensor_bool_double_double_bool(input, weight, bias, running_mean, running_var, use_input_stats, momentum, eps, cudnn_enabled); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_isclose_tensor_tensor_double_double_bool)(void* self, void* other, void* rtol, void* atol, void* equal_nan);
  HOST_API void* lantern_isclose_tensor_tensor_double_double_bool(void* self, void* other, void* rtol, void* atol, void* equal_nan) { LANTERN_CHECK_LOADED void* ret = _lantern_isclose_tensor_tensor_double_double_bool(self, other, rtol, atol, equal_nan); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_isclose_tensor_tensor_double_double_bool)(void* self, void* other, void* rtol, void* atol, void* equal_nan);
  HOST_API void* lantern_Tensor_isclose_tensor_tensor_double_double_bool(void* self, void* other, void* rtol, void* atol, void* equal_nan) { void* ret = _lantern_Tensor_isclose_tensor_tensor_double_double_bool(self, other, rtol, atol, equal_nan); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_isin_out_tensor_tensor_tensor_bool_bool)(void* out, void* elements, void* test_elements, void* assume_unique, void* invert);
  HOST_API void* lantern_isin_out_tensor_tensor_tensor_bool_bool(void* out, void* elements, void* test_elements, void* assume_unique, void* invert) { LANTERN_CHECK_LOADED void* ret = _lantern_isin_out_tensor_tensor_tensor_bool_bool(out, elements, test_elements, assume_unique, invert); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_isin_tensor_tensor_bool_bool)(void* elements, void* test_elements, void* assume_unique, void* invert);
  HOST_API void* lantern_isin_tensor_tensor_bool_bool(void* elements, void* test_elements, void* assume_unique, void* invert) { LANTERN_CHECK_LOADED void* ret = _lantern_isin_tensor_tensor_bool_bool(elements, test_elements, assume_unique, invert); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_isin_out_tensor_tensor_scalar_bool_bool)(void* out, void* elements, void* test_element, void* assume_unique, void* invert);
  HOST_API void* lantern_isin_out_tensor_tensor_scalar_bool_bool(void* out, void* elements, void* test_element, void* assume_unique, void* invert) { LANTERN_CHECK_LOADED void* ret = _lantern_isin_out_tensor_tensor_scalar_bool_bool(out, elements, test_element, assume_unique, invert); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_isin_tensor_scalar_bool_bool)(void* elements, void* test_element, void* assume_unique, void* invert);
  HOST_API void* lantern_isin_tensor_scalar_bool_bool(void* elements, void* test_element, void* assume_unique, void* invert) { LANTERN_CHECK_LOADED void* ret = _lantern_isin_tensor_scalar_bool_bool(elements, test_element, assume_unique, invert); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_isin_out_tensor_scalar_tensor_bool_bool)(void* out, void* element, void* test_elements, void* assume_unique, void* invert);
  HOST_API void* lantern_isin_out_tensor_scalar_tensor_bool_bool(void* out, void* element, void* test_elements, void* assume_unique, void* invert) { LANTERN_CHECK_LOADED void* ret = _lantern_isin_out_tensor_scalar_tensor_bool_bool(out, element, test_elements, assume_unique, invert); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_isin_scalar_tensor_bool_bool)(void* element, void* test_elements, void* assume_unique, void* invert);
  HOST_API void* lantern_isin_scalar_tensor_bool_bool(void* element, void* test_elements, void* assume_unique, void* invert) { LANTERN_CHECK_LOADED void* ret = _lantern_isin_scalar_tensor_bool_bool(element, test_elements, assume_unique, invert); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_isnan_tensor)(void* self);
  HOST_API void* lantern_isnan_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_isnan_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_isnan_tensor)(void* self);
  HOST_API void* lantern_Tensor_isnan_tensor(void* self) { void* ret = _lantern_Tensor_isnan_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_is_distributed_tensor)(void* self);
  HOST_API void* lantern_is_distributed_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_is_distributed_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_is_distributed_tensor)(void* self);
  HOST_API void* lantern_Tensor_is_distributed_tensor(void* self) { void* ret = _lantern_Tensor_is_distributed_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_is_floating_point_tensor)(void* self);
  HOST_API void* lantern_is_floating_point_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_is_floating_point_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_is_floating_point_tensor)(void* self);
  HOST_API void* lantern_Tensor_is_floating_point_tensor(void* self) { void* ret = _lantern_Tensor_is_floating_point_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_is_complex_tensor)(void* self);
  HOST_API void* lantern_is_complex_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_is_complex_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_is_complex_tensor)(void* self);
  HOST_API void* lantern_Tensor_is_complex_tensor(void* self) { void* ret = _lantern_Tensor_is_complex_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_is_conj_tensor)(void* self);
  HOST_API void* lantern_is_conj_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_is_conj_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_is_conj_tensor)(void* self);
  HOST_API void* lantern_Tensor_is_conj_tensor(void* self) { void* ret = _lantern_Tensor_is_conj_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__is_zerotensor_tensor)(void* self);
  HOST_API void* lantern__is_zerotensor_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__is_zerotensor_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor__is_zerotensor_tensor)(void* self);
  HOST_API void* lantern_Tensor__is_zerotensor_tensor(void* self) { void* ret = _lantern_Tensor__is_zerotensor_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_is_neg_tensor)(void* self);
  HOST_API void* lantern_is_neg_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_is_neg_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_is_neg_tensor)(void* self);
  HOST_API void* lantern_Tensor_is_neg_tensor(void* self) { void* ret = _lantern_Tensor_is_neg_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_isreal_tensor)(void* self);
  HOST_API void* lantern_isreal_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_isreal_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_isreal_tensor)(void* self);
  HOST_API void* lantern_Tensor_isreal_tensor(void* self) { void* ret = _lantern_Tensor_isreal_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_is_nonzero_tensor)(void* self);
  HOST_API void* lantern_is_nonzero_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_is_nonzero_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_is_nonzero_tensor)(void* self);
  HOST_API void* lantern_Tensor_is_nonzero_tensor(void* self) { void* ret = _lantern_Tensor_is_nonzero_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_is_same_size_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_is_same_size_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_is_same_size_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_is_same_size_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_is_same_size_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_is_same_size_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_is_signed_tensor)(void* self);
  HOST_API void* lantern_is_signed_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_is_signed_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_is_signed_tensor)(void* self);
  HOST_API void* lantern_Tensor_is_signed_tensor(void* self) { void* ret = _lantern_Tensor_is_signed_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_is_inference_tensor)(void* self);
  HOST_API void* lantern_is_inference_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_is_inference_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_is_inference_tensor)(void* self);
  HOST_API void* lantern_Tensor_is_inference_tensor(void* self) { void* ret = _lantern_Tensor_is_inference_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_kl_div_tensor_tensor_intt_bool)(void* self, void* target, void* reduction, void* log_target);
  HOST_API void* lantern_kl_div_tensor_tensor_intt_bool(void* self, void* target, void* reduction, void* log_target) { LANTERN_CHECK_LOADED void* ret = _lantern_kl_div_tensor_tensor_intt_bool(self, target, reduction, log_target); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_kron_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_kron_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_kron_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_kron_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_kron_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_kron_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_kron_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_kron_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_kron_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_kthvalue_tensor_intt_intt_bool)(void* self, void* k, void* dim, void* keepdim);
  HOST_API void* lantern_kthvalue_tensor_intt_intt_bool(void* self, void* k, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_kthvalue_tensor_intt_intt_bool(self, k, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_kthvalue_tensor_intt_intt_bool)(void* self, void* k, void* dim, void* keepdim);
  HOST_API void* lantern_Tensor_kthvalue_tensor_intt_intt_bool(void* self, void* k, void* dim, void* keepdim) { void* ret = _lantern_Tensor_kthvalue_tensor_intt_intt_bool(self, k, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_kthvalue_out_tensor_tensor_tensor_intt_intt_bool)(void* values, void* indices, void* self, void* k, void* dim, void* keepdim);
  HOST_API void* lantern_kthvalue_out_tensor_tensor_tensor_intt_intt_bool(void* values, void* indices, void* self, void* k, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_kthvalue_out_tensor_tensor_tensor_intt_intt_bool(values, indices, self, k, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_kthvalue_tensor_intt_dimname_bool)(void* self, void* k, void* dim, void* keepdim);
  HOST_API void* lantern_kthvalue_tensor_intt_dimname_bool(void* self, void* k, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_kthvalue_tensor_intt_dimname_bool(self, k, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_kthvalue_tensor_intt_dimname_bool)(void* self, void* k, void* dim, void* keepdim);
  HOST_API void* lantern_Tensor_kthvalue_tensor_intt_dimname_bool(void* self, void* k, void* dim, void* keepdim) { void* ret = _lantern_Tensor_kthvalue_tensor_intt_dimname_bool(self, k, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_kthvalue_out_tensor_tensor_tensor_intt_dimname_bool)(void* values, void* indices, void* self, void* k, void* dim, void* keepdim);
  HOST_API void* lantern_kthvalue_out_tensor_tensor_tensor_intt_dimname_bool(void* values, void* indices, void* self, void* k, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_kthvalue_out_tensor_tensor_tensor_intt_dimname_bool(values, indices, self, k, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_layer_norm_tensor_intarrayref_tensor_tensor_double_bool)(void* input, void* normalized_shape, void* weight, void* bias, void* eps, void* cudnn_enable);
  HOST_API void* lantern_layer_norm_tensor_intarrayref_tensor_tensor_double_bool(void* input, void* normalized_shape, void* weight, void* bias, void* eps, void* cudnn_enable) { LANTERN_CHECK_LOADED void* ret = _lantern_layer_norm_tensor_intarrayref_tensor_tensor_double_bool(input, normalized_shape, weight, bias, eps, cudnn_enable); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_native_layer_norm_tensor_intarrayref_tensor_tensor_double)(void* input, void* normalized_shape, void* weight, void* bias, void* eps);
  HOST_API void* lantern_native_layer_norm_tensor_intarrayref_tensor_tensor_double(void* input, void* normalized_shape, void* weight, void* bias, void* eps) { LANTERN_CHECK_LOADED void* ret = _lantern_native_layer_norm_tensor_intarrayref_tensor_tensor_double(input, normalized_shape, weight, bias, eps); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_native_layer_norm_backward_tensor_tensor_intarrayref_tensor_tensor_tensor_tensor_stdarraybool)(void* grad_out, void* input, void* normalized_shape, void* mean, void* rstd, void* weight, void* bias, void* output_mask);
  HOST_API void* lantern_native_layer_norm_backward_tensor_tensor_intarrayref_tensor_tensor_tensor_tensor_stdarraybool(void* grad_out, void* input, void* normalized_shape, void* mean, void* rstd, void* weight, void* bias, void* output_mask) { LANTERN_CHECK_LOADED void* ret = _lantern_native_layer_norm_backward_tensor_tensor_intarrayref_tensor_tensor_tensor_tensor_stdarraybool(grad_out, input, normalized_shape, mean, rstd, weight, bias, output_mask); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_nan_to_num_tensor_double_double_double)(void* self, void* nan, void* posinf, void* neginf);
  HOST_API void* lantern_nan_to_num_tensor_double_double_double(void* self, void* nan, void* posinf, void* neginf) { LANTERN_CHECK_LOADED void* ret = _lantern_nan_to_num_tensor_double_double_double(self, nan, posinf, neginf); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_nan_to_num_tensor_double_double_double)(void* self, void* nan, void* posinf, void* neginf);
  HOST_API void* lantern_Tensor_nan_to_num_tensor_double_double_double(void* self, void* nan, void* posinf, void* neginf) { void* ret = _lantern_Tensor_nan_to_num_tensor_double_double_double(self, nan, posinf, neginf); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_nan_to_num__tensor_double_double_double)(void* self, void* nan, void* posinf, void* neginf);
  HOST_API void* lantern_nan_to_num__tensor_double_double_double(void* self, void* nan, void* posinf, void* neginf) { LANTERN_CHECK_LOADED void* ret = _lantern_nan_to_num__tensor_double_double_double(self, nan, posinf, neginf); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_nan_to_num__tensor_double_double_double)(void* self, void* nan, void* posinf, void* neginf);
  HOST_API void* lantern_Tensor_nan_to_num__tensor_double_double_double(void* self, void* nan, void* posinf, void* neginf) { void* ret = _lantern_Tensor_nan_to_num__tensor_double_double_double(self, nan, posinf, neginf); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_nan_to_num_out_tensor_tensor_double_double_double)(void* out, void* self, void* nan, void* posinf, void* neginf);
  HOST_API void* lantern_nan_to_num_out_tensor_tensor_double_double_double(void* out, void* self, void* nan, void* posinf, void* neginf) { LANTERN_CHECK_LOADED void* ret = _lantern_nan_to_num_out_tensor_tensor_double_double_double(out, self, nan, posinf, neginf); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_linear_tensor_tensor_tensor)(void* input, void* weight, void* bias);
  HOST_API void* lantern_linear_tensor_tensor_tensor(void* input, void* weight, void* bias) { LANTERN_CHECK_LOADED void* ret = _lantern_linear_tensor_tensor_tensor(input, weight, bias); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_linear_backward_tensor_tensor_tensor_stdarraybool)(void* self, void* grad_output, void* weight, void* output_mask);
  HOST_API void* lantern_linear_backward_tensor_tensor_tensor_stdarraybool(void* self, void* grad_output, void* weight, void* output_mask) { LANTERN_CHECK_LOADED void* ret = _lantern_linear_backward_tensor_tensor_tensor_stdarraybool(self, grad_output, weight, output_mask); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_linear_out_tensor_tensor_tensor_tensor)(void* out, void* input, void* weight, void* bias);
  HOST_API void* lantern_linear_out_tensor_tensor_tensor_tensor(void* out, void* input, void* weight, void* bias) { LANTERN_CHECK_LOADED void* ret = _lantern_linear_out_tensor_tensor_tensor_tensor(out, input, weight, bias); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_mkldnn_linear_tensor_tensor_tensor)(void* self, void* weight, void* bias);
  HOST_API void* lantern_mkldnn_linear_tensor_tensor_tensor(void* self, void* weight, void* bias) { LANTERN_CHECK_LOADED void* ret = _lantern_mkldnn_linear_tensor_tensor_tensor(self, weight, bias); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_mkldnn_linear_backward_input_intarrayref_tensor_tensor)(void* input_size, void* grad_output, void* weight);
  HOST_API void* lantern_mkldnn_linear_backward_input_intarrayref_tensor_tensor(void* input_size, void* grad_output, void* weight) { LANTERN_CHECK_LOADED void* ret = _lantern_mkldnn_linear_backward_input_intarrayref_tensor_tensor(input_size, grad_output, weight); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_mkldnn_linear_backward_weights_tensor_tensor_tensor_bool)(void* grad_output, void* input, void* weight, void* bias_defined);
  HOST_API void* lantern_mkldnn_linear_backward_weights_tensor_tensor_tensor_bool(void* grad_output, void* input, void* weight, void* bias_defined) { LANTERN_CHECK_LOADED void* ret = _lantern_mkldnn_linear_backward_weights_tensor_tensor_tensor_bool(grad_output, input, weight, bias_defined); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_mkldnn_linear_backward_tensor_tensor_tensor_stdarraybool)(void* self, void* grad_output, void* weight, void* output_mask);
  HOST_API void* lantern_mkldnn_linear_backward_tensor_tensor_tensor_stdarraybool(void* self, void* grad_output, void* weight, void* output_mask) { LANTERN_CHECK_LOADED void* ret = _lantern_mkldnn_linear_backward_tensor_tensor_tensor_stdarraybool(self, grad_output, weight, output_mask); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_fbgemm_linear_int8_weight_fp32_activation_tensor_tensor_tensor_tensor_scalar_scalar_tensor)(void* input, void* weight, void* packed, void* col_offsets, void* weight_scale, void* weight_zero_point, void* bias);
  HOST_API void* lantern_fbgemm_linear_int8_weight_fp32_activation_tensor_tensor_tensor_tensor_scalar_scalar_tensor(void* input, void* weight, void* packed, void* col_offsets, void* weight_scale, void* weight_zero_point, void* bias) { LANTERN_CHECK_LOADED void* ret = _lantern_fbgemm_linear_int8_weight_fp32_activation_tensor_tensor_tensor_tensor_scalar_scalar_tensor(input, weight, packed, col_offsets, weight_scale, weight_zero_point, bias); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_fbgemm_linear_int8_weight_tensor_tensor_tensor_tensor_scalar_scalar_tensor)(void* input, void* weight, void* packed, void* col_offsets, void* weight_scale, void* weight_zero_point, void* bias);
  HOST_API void* lantern_fbgemm_linear_int8_weight_tensor_tensor_tensor_tensor_scalar_scalar_tensor(void* input, void* weight, void* packed, void* col_offsets, void* weight_scale, void* weight_zero_point, void* bias) { LANTERN_CHECK_LOADED void* ret = _lantern_fbgemm_linear_int8_weight_tensor_tensor_tensor_tensor_scalar_scalar_tensor(input, weight, packed, col_offsets, weight_scale, weight_zero_point, bias); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_fbgemm_linear_quantize_weight_tensor)(void* input);
  HOST_API void* lantern_fbgemm_linear_quantize_weight_tensor(void* input) { LANTERN_CHECK_LOADED void* ret = _lantern_fbgemm_linear_quantize_weight_tensor(input); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_fbgemm_pack_gemm_matrix_fp16_tensor)(void* input);
  HOST_API void* lantern_fbgemm_pack_gemm_matrix_fp16_tensor(void* input) { LANTERN_CHECK_LOADED void* ret = _lantern_fbgemm_pack_gemm_matrix_fp16_tensor(input); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_fbgemm_linear_fp16_weight_fp32_activation_tensor_tensor_tensor)(void* input, void* packed_weight, void* bias);
  HOST_API void* lantern_fbgemm_linear_fp16_weight_fp32_activation_tensor_tensor_tensor(void* input, void* packed_weight, void* bias) { LANTERN_CHECK_LOADED void* ret = _lantern_fbgemm_linear_fp16_weight_fp32_activation_tensor_tensor_tensor(input, packed_weight, bias); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_fbgemm_linear_fp16_weight_tensor_tensor_tensor)(void* input, void* packed_weight, void* bias);
  HOST_API void* lantern_fbgemm_linear_fp16_weight_tensor_tensor_tensor(void* input, void* packed_weight, void* bias) { LANTERN_CHECK_LOADED void* ret = _lantern_fbgemm_linear_fp16_weight_tensor_tensor_tensor(input, packed_weight, bias); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_fbgemm_pack_quantized_matrix_tensor)(void* input);
  HOST_API void* lantern_fbgemm_pack_quantized_matrix_tensor(void* input) { LANTERN_CHECK_LOADED void* ret = _lantern_fbgemm_pack_quantized_matrix_tensor(input); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_fbgemm_pack_quantized_matrix_tensor_intt_intt)(void* input, void* K, void* N);
  HOST_API void* lantern_fbgemm_pack_quantized_matrix_tensor_intt_intt(void* input, void* K, void* N) { LANTERN_CHECK_LOADED void* ret = _lantern_fbgemm_pack_quantized_matrix_tensor_intt_intt(input, K, N); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_ldexp_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_ldexp_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_ldexp_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_ldexp_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_ldexp_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_ldexp_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_ldexp__tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_ldexp__tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_ldexp__tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_ldexp__tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_ldexp__tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_ldexp__tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_ldexp_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_ldexp_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_ldexp_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_linspace_scalar_scalar_intt_tensoroptions)(void* start, void* end, void* steps, void* options);
  HOST_API void* lantern_linspace_scalar_scalar_intt_tensoroptions(void* start, void* end, void* steps, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_linspace_scalar_scalar_intt_tensoroptions(start, end, steps, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_linspace_out_tensor_scalar_scalar_intt)(void* out, void* start, void* end, void* steps);
  HOST_API void* lantern_linspace_out_tensor_scalar_scalar_intt(void* out, void* start, void* end, void* steps) { LANTERN_CHECK_LOADED void* ret = _lantern_linspace_out_tensor_scalar_scalar_intt(out, start, end, steps); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_log_tensor)(void* self);
  HOST_API void* lantern_log_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_log_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_log_tensor)(void* self);
  HOST_API void* lantern_Tensor_log_tensor(void* self) { void* ret = _lantern_Tensor_log_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_log__tensor)(void* self);
  HOST_API void* lantern_log__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_log__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_log__tensor)(void* self);
  HOST_API void* lantern_Tensor_log__tensor(void* self) { void* ret = _lantern_Tensor_log__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_log_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_log_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_log_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_log10_tensor)(void* self);
  HOST_API void* lantern_log10_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_log10_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_log10_tensor)(void* self);
  HOST_API void* lantern_Tensor_log10_tensor(void* self) { void* ret = _lantern_Tensor_log10_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_log10__tensor)(void* self);
  HOST_API void* lantern_log10__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_log10__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_log10__tensor)(void* self);
  HOST_API void* lantern_Tensor_log10__tensor(void* self) { void* ret = _lantern_Tensor_log10__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_log10_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_log10_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_log10_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_log1p_tensor)(void* self);
  HOST_API void* lantern_log1p_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_log1p_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_log1p_tensor)(void* self);
  HOST_API void* lantern_Tensor_log1p_tensor(void* self) { void* ret = _lantern_Tensor_log1p_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_log1p__tensor)(void* self);
  HOST_API void* lantern_log1p__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_log1p__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_log1p__tensor)(void* self);
  HOST_API void* lantern_Tensor_log1p__tensor(void* self) { void* ret = _lantern_Tensor_log1p__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_log1p_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_log1p_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_log1p_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_log2_tensor)(void* self);
  HOST_API void* lantern_log2_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_log2_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_log2_tensor)(void* self);
  HOST_API void* lantern_Tensor_log2_tensor(void* self) { void* ret = _lantern_Tensor_log2_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_log2__tensor)(void* self);
  HOST_API void* lantern_log2__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_log2__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_log2__tensor)(void* self);
  HOST_API void* lantern_Tensor_log2__tensor(void* self) { void* ret = _lantern_Tensor_log2__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_log2_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_log2_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_log2_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_logaddexp_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_logaddexp_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_logaddexp_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_logaddexp_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_logaddexp_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_logaddexp_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_logaddexp_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_logaddexp_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_logaddexp_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_logaddexp2_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_logaddexp2_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_logaddexp2_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_logaddexp2_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_logaddexp2_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_logaddexp2_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_logaddexp2_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_logaddexp2_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_logaddexp2_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_xlogy_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_xlogy_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_xlogy_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_xlogy_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_xlogy_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_xlogy_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_xlogy_scalar_tensor)(void* self, void* other);
  HOST_API void* lantern_xlogy_scalar_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_xlogy_scalar_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_xlogy_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_xlogy_tensor_scalar(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_xlogy_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_xlogy_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_xlogy_tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_xlogy_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_xlogy__tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_xlogy__tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_xlogy__tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_xlogy__tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_xlogy__tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_xlogy__tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_xlogy__tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_xlogy__tensor_scalar(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_xlogy__tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_xlogy__tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_xlogy__tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_xlogy__tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_xlogy_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_xlogy_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_xlogy_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_xlogy_out_tensor_scalar_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_xlogy_out_tensor_scalar_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_xlogy_out_tensor_scalar_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_xlogy_out_tensor_tensor_scalar)(void* out, void* self, void* other);
  HOST_API void* lantern_xlogy_out_tensor_tensor_scalar(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_xlogy_out_tensor_tensor_scalar(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_logspace_scalar_scalar_intt_double_tensoroptions)(void* start, void* end, void* steps, void* base, void* options);
  HOST_API void* lantern_logspace_scalar_scalar_intt_double_tensoroptions(void* start, void* end, void* steps, void* base, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_logspace_scalar_scalar_intt_double_tensoroptions(start, end, steps, base, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_logspace_out_tensor_scalar_scalar_intt_double)(void* out, void* start, void* end, void* steps, void* base);
  HOST_API void* lantern_logspace_out_tensor_scalar_scalar_intt_double(void* out, void* start, void* end, void* steps, void* base) { LANTERN_CHECK_LOADED void* ret = _lantern_logspace_out_tensor_scalar_scalar_intt_double(out, start, end, steps, base); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_log_softmax_tensor_intt_scalartype)(void* self, void* dim, void* dtype);
  HOST_API void* lantern_log_softmax_tensor_intt_scalartype(void* self, void* dim, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern_log_softmax_tensor_intt_scalartype(self, dim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_log_softmax_tensor_intt_scalartype)(void* self, void* dim, void* dtype);
  HOST_API void* lantern_Tensor_log_softmax_tensor_intt_scalartype(void* self, void* dim, void* dtype) { void* ret = _lantern_Tensor_log_softmax_tensor_intt_scalartype(self, dim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_log_softmax_out_tensor_tensor_intt_scalartype)(void* out, void* self, void* dim, void* dtype);
  HOST_API void* lantern_log_softmax_out_tensor_tensor_intt_scalartype(void* out, void* self, void* dim, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern_log_softmax_out_tensor_tensor_intt_scalartype(out, self, dim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_log_softmax_tensor_dimname_scalartype)(void* self, void* dim, void* dtype);
  HOST_API void* lantern_log_softmax_tensor_dimname_scalartype(void* self, void* dim, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern_log_softmax_tensor_dimname_scalartype(self, dim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_log_softmax_tensor_dimname_scalartype)(void* self, void* dim, void* dtype);
  HOST_API void* lantern_Tensor_log_softmax_tensor_dimname_scalartype(void* self, void* dim, void* dtype) { void* ret = _lantern_Tensor_log_softmax_tensor_dimname_scalartype(self, dim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__log_softmax_tensor_intt_bool)(void* self, void* dim, void* half_to_float);
  HOST_API void* lantern__log_softmax_tensor_intt_bool(void* self, void* dim, void* half_to_float) { LANTERN_CHECK_LOADED void* ret = _lantern__log_softmax_tensor_intt_bool(self, dim, half_to_float); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__log_softmax_out_tensor_tensor_intt_bool)(void* out, void* self, void* dim, void* half_to_float);
  HOST_API void* lantern__log_softmax_out_tensor_tensor_intt_bool(void* out, void* self, void* dim, void* half_to_float) { LANTERN_CHECK_LOADED void* ret = _lantern__log_softmax_out_tensor_tensor_intt_bool(out, self, dim, half_to_float); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__log_softmax_backward_data_tensor_tensor_intt_scalartype)(void* grad_output, void* output, void* dim, void* input_dtype);
  HOST_API void* lantern__log_softmax_backward_data_tensor_tensor_intt_scalartype(void* grad_output, void* output, void* dim, void* input_dtype) { LANTERN_CHECK_LOADED void* ret = _lantern__log_softmax_backward_data_tensor_tensor_intt_scalartype(grad_output, output, dim, input_dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__log_softmax_backward_data_out_tensor_tensor_tensor_intt_scalartype)(void* out, void* grad_output, void* output, void* dim, void* input_dtype);
  HOST_API void* lantern__log_softmax_backward_data_out_tensor_tensor_tensor_intt_scalartype(void* out, void* grad_output, void* output, void* dim, void* input_dtype) { LANTERN_CHECK_LOADED void* ret = _lantern__log_softmax_backward_data_out_tensor_tensor_tensor_intt_scalartype(out, grad_output, output, dim, input_dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__logcumsumexp_tensor_intt)(void* self, void* dim);
  HOST_API void* lantern__logcumsumexp_tensor_intt(void* self, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern__logcumsumexp_tensor_intt(self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__logcumsumexp_out_tensor_tensor_intt)(void* out, void* self, void* dim);
  HOST_API void* lantern__logcumsumexp_out_tensor_tensor_intt(void* out, void* self, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern__logcumsumexp_out_tensor_tensor_intt(out, self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_logcumsumexp_tensor_intt)(void* self, void* dim);
  HOST_API void* lantern_logcumsumexp_tensor_intt(void* self, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_logcumsumexp_tensor_intt(self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_logcumsumexp_tensor_intt)(void* self, void* dim);
  HOST_API void* lantern_Tensor_logcumsumexp_tensor_intt(void* self, void* dim) { void* ret = _lantern_Tensor_logcumsumexp_tensor_intt(self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_logcumsumexp_out_tensor_tensor_intt)(void* out, void* self, void* dim);
  HOST_API void* lantern_logcumsumexp_out_tensor_tensor_intt(void* out, void* self, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_logcumsumexp_out_tensor_tensor_intt(out, self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_logcumsumexp_tensor_dimname)(void* self, void* dim);
  HOST_API void* lantern_logcumsumexp_tensor_dimname(void* self, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_logcumsumexp_tensor_dimname(self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_logcumsumexp_tensor_dimname)(void* self, void* dim);
  HOST_API void* lantern_Tensor_logcumsumexp_tensor_dimname(void* self, void* dim) { void* ret = _lantern_Tensor_logcumsumexp_tensor_dimname(self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_logcumsumexp_out_tensor_tensor_dimname)(void* out, void* self, void* dim);
  HOST_API void* lantern_logcumsumexp_out_tensor_tensor_dimname(void* out, void* self, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_logcumsumexp_out_tensor_tensor_dimname(out, self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_logsumexp_tensor_intarrayref_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_logsumexp_tensor_intarrayref_bool(void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_logsumexp_tensor_intarrayref_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_logsumexp_tensor_intarrayref_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_Tensor_logsumexp_tensor_intarrayref_bool(void* self, void* dim, void* keepdim) { void* ret = _lantern_Tensor_logsumexp_tensor_intarrayref_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_logsumexp_out_tensor_tensor_intarrayref_bool)(void* out, void* self, void* dim, void* keepdim);
  HOST_API void* lantern_logsumexp_out_tensor_tensor_intarrayref_bool(void* out, void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_logsumexp_out_tensor_tensor_intarrayref_bool(out, self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_logsumexp_tensor_dimnamelist_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_logsumexp_tensor_dimnamelist_bool(void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_logsumexp_tensor_dimnamelist_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_logsumexp_tensor_dimnamelist_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_Tensor_logsumexp_tensor_dimnamelist_bool(void* self, void* dim, void* keepdim) { void* ret = _lantern_Tensor_logsumexp_tensor_dimnamelist_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_logsumexp_out_tensor_tensor_dimnamelist_bool)(void* out, void* self, void* dim, void* keepdim);
  HOST_API void* lantern_logsumexp_out_tensor_tensor_dimnamelist_bool(void* out, void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_logsumexp_out_tensor_tensor_dimnamelist_bool(out, self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_margin_ranking_loss_tensor_tensor_tensor_double_intt)(void* input1, void* input2, void* target, void* margin, void* reduction);
  HOST_API void* lantern_margin_ranking_loss_tensor_tensor_tensor_double_intt(void* input1, void* input2, void* target, void* margin, void* reduction) { LANTERN_CHECK_LOADED void* ret = _lantern_margin_ranking_loss_tensor_tensor_tensor_double_intt(input1, input2, target, margin, reduction); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_matmul_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_matmul_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_matmul_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_matmul_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_matmul_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_matmul_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_matmul_backward_tensor_tensor_tensor_stdarraybool)(void* grad, void* self, void* other, void* mask);
  HOST_API void* lantern_matmul_backward_tensor_tensor_tensor_stdarraybool(void* grad, void* self, void* other, void* mask) { LANTERN_CHECK_LOADED void* ret = _lantern_matmul_backward_tensor_tensor_tensor_stdarraybool(grad, self, other, mask); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_matmul_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_matmul_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_matmul_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_matrix_power_tensor_intt)(void* self, void* n);
  HOST_API void* lantern_matrix_power_tensor_intt(void* self, void* n) { LANTERN_CHECK_LOADED void* ret = _lantern_matrix_power_tensor_intt(self, n); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_matrix_power_tensor_intt)(void* self, void* n);
  HOST_API void* lantern_Tensor_matrix_power_tensor_intt(void* self, void* n) { void* ret = _lantern_Tensor_matrix_power_tensor_intt(self, n); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_matrix_power_out_tensor_tensor_intt)(void* out, void* self, void* n);
  HOST_API void* lantern_matrix_power_out_tensor_tensor_intt(void* out, void* self, void* n) { LANTERN_CHECK_LOADED void* ret = _lantern_matrix_power_out_tensor_tensor_intt(out, self, n); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_matrix_exp_tensor)(void* self);
  HOST_API void* lantern_matrix_exp_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_matrix_exp_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_matrix_exp_tensor)(void* self);
  HOST_API void* lantern_Tensor_matrix_exp_tensor(void* self) { void* ret = _lantern_Tensor_matrix_exp_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_matrix_exp_backward_tensor_tensor)(void* self, void* grad);
  HOST_API void* lantern_matrix_exp_backward_tensor_tensor(void* self, void* grad) { LANTERN_CHECK_LOADED void* ret = _lantern_matrix_exp_backward_tensor_tensor(self, grad); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__aminmax_tensor)(void* self);
  HOST_API void* lantern__aminmax_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__aminmax_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__aminmax_tensor_intt_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern__aminmax_tensor_intt_bool(void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern__aminmax_tensor_intt_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_aminmax_tensor_intt_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_aminmax_tensor_intt_bool(void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_aminmax_tensor_intt_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_aminmax_tensor_intt_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_Tensor_aminmax_tensor_intt_bool(void* self, void* dim, void* keepdim) { void* ret = _lantern_Tensor_aminmax_tensor_intt_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_aminmax_out_tensor_tensor_tensor_intt_bool)(void* min, void* max, void* self, void* dim, void* keepdim);
  HOST_API void* lantern_aminmax_out_tensor_tensor_tensor_intt_bool(void* min, void* max, void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_aminmax_out_tensor_tensor_tensor_intt_bool(min, max, self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__compute_linear_combination_tensor_tensor)(void* input, void* coefficients);
  HOST_API void* lantern__compute_linear_combination_tensor_tensor(void* input, void* coefficients) { LANTERN_CHECK_LOADED void* ret = _lantern__compute_linear_combination_tensor_tensor(input, coefficients); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__compute_linear_combination_out_tensor_tensor_tensor)(void* out, void* input, void* coefficients);
  HOST_API void* lantern__compute_linear_combination_out_tensor_tensor_tensor(void* out, void* input, void* coefficients) { LANTERN_CHECK_LOADED void* ret = _lantern__compute_linear_combination_out_tensor_tensor_tensor(out, input, coefficients); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_max_tensor_intt_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_max_tensor_intt_bool(void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_max_tensor_intt_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_max_tensor_intt_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_Tensor_max_tensor_intt_bool(void* self, void* dim, void* keepdim) { void* ret = _lantern_Tensor_max_tensor_intt_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_max_out_tensor_tensor_tensor_intt_bool)(void* max, void* max_values, void* self, void* dim, void* keepdim);
  HOST_API void* lantern_max_out_tensor_tensor_tensor_intt_bool(void* max, void* max_values, void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_max_out_tensor_tensor_tensor_intt_bool(max, max_values, self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_max_tensor_dimname_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_max_tensor_dimname_bool(void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_max_tensor_dimname_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_max_tensor_dimname_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_Tensor_max_tensor_dimname_bool(void* self, void* dim, void* keepdim) { void* ret = _lantern_Tensor_max_tensor_dimname_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_max_out_tensor_tensor_tensor_dimname_bool)(void* max, void* max_values, void* self, void* dim, void* keepdim);
  HOST_API void* lantern_max_out_tensor_tensor_tensor_dimname_bool(void* max, void* max_values, void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_max_out_tensor_tensor_tensor_dimname_bool(max, max_values, self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_value_selecting_reduction_backward_tensor_intt_tensor_intarrayref_bool)(void* grad, void* dim, void* indices, void* sizes, void* keepdim);
  HOST_API void* lantern_value_selecting_reduction_backward_tensor_intt_tensor_intarrayref_bool(void* grad, void* dim, void* indices, void* sizes, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_value_selecting_reduction_backward_tensor_intt_tensor_intarrayref_bool(grad, dim, indices, sizes, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_amax_tensor_intarrayref_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_amax_tensor_intarrayref_bool(void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_amax_tensor_intarrayref_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_amax_tensor_intarrayref_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_Tensor_amax_tensor_intarrayref_bool(void* self, void* dim, void* keepdim) { void* ret = _lantern_Tensor_amax_tensor_intarrayref_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_amax_out_tensor_tensor_intarrayref_bool)(void* out, void* self, void* dim, void* keepdim);
  HOST_API void* lantern_amax_out_tensor_tensor_intarrayref_bool(void* out, void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_amax_out_tensor_tensor_intarrayref_bool(out, self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_max_pool1d_with_indices_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool)(void* self, void* kernel_size, void* stride, void* padding, void* dilation, void* ceil_mode);
  HOST_API void* lantern_max_pool1d_with_indices_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool(void* self, void* kernel_size, void* stride, void* padding, void* dilation, void* ceil_mode) { LANTERN_CHECK_LOADED void* ret = _lantern_max_pool1d_with_indices_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool(self, kernel_size, stride, padding, dilation, ceil_mode); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_max_pool1d_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool)(void* self, void* kernel_size, void* stride, void* padding, void* dilation, void* ceil_mode);
  HOST_API void* lantern_max_pool1d_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool(void* self, void* kernel_size, void* stride, void* padding, void* dilation, void* ceil_mode) { LANTERN_CHECK_LOADED void* ret = _lantern_max_pool1d_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool(self, kernel_size, stride, padding, dilation, ceil_mode); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_max_pool2d_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool)(void* self, void* kernel_size, void* stride, void* padding, void* dilation, void* ceil_mode);
  HOST_API void* lantern_max_pool2d_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool(void* self, void* kernel_size, void* stride, void* padding, void* dilation, void* ceil_mode) { LANTERN_CHECK_LOADED void* ret = _lantern_max_pool2d_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool(self, kernel_size, stride, padding, dilation, ceil_mode); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__mps_max_pool2d_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool)(void* self, void* kernel_size, void* stride, void* padding, void* dilation, void* ceil_mode);
  HOST_API void* lantern__mps_max_pool2d_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool(void* self, void* kernel_size, void* stride, void* padding, void* dilation, void* ceil_mode) { LANTERN_CHECK_LOADED void* ret = _lantern__mps_max_pool2d_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool(self, kernel_size, stride, padding, dilation, ceil_mode); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_mps_max_pool2d_backward_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool)(void* grad_output, void* self, void* kernel_size, void* stride, void* padding, void* dilation, void* ceil_mode);
  HOST_API void* lantern_mps_max_pool2d_backward_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool(void* grad_output, void* self, void* kernel_size, void* stride, void* padding, void* dilation, void* ceil_mode) { LANTERN_CHECK_LOADED void* ret = _lantern_mps_max_pool2d_backward_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool(grad_output, self, kernel_size, stride, padding, dilation, ceil_mode); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_mkldnn_max_pool2d_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool)(void* self, void* kernel_size, void* stride, void* padding, void* dilation, void* ceil_mode);
  HOST_API void* lantern_mkldnn_max_pool2d_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool(void* self, void* kernel_size, void* stride, void* padding, void* dilation, void* ceil_mode) { LANTERN_CHECK_LOADED void* ret = _lantern_mkldnn_max_pool2d_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool(self, kernel_size, stride, padding, dilation, ceil_mode); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_mkldnn_max_pool2d_backward_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool)(void* grad_output, void* output, void* input, void* kernel_size, void* stride, void* padding, void* dilation, void* ceil_mode);
  HOST_API void* lantern_mkldnn_max_pool2d_backward_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool(void* grad_output, void* output, void* input, void* kernel_size, void* stride, void* padding, void* dilation, void* ceil_mode) { LANTERN_CHECK_LOADED void* ret = _lantern_mkldnn_max_pool2d_backward_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool(grad_output, output, input, kernel_size, stride, padding, dilation, ceil_mode); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_mkldnn_max_pool3d_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool)(void* self, void* kernel_size, void* stride, void* padding, void* dilation, void* ceil_mode);
  HOST_API void* lantern_mkldnn_max_pool3d_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool(void* self, void* kernel_size, void* stride, void* padding, void* dilation, void* ceil_mode) { LANTERN_CHECK_LOADED void* ret = _lantern_mkldnn_max_pool3d_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool(self, kernel_size, stride, padding, dilation, ceil_mode); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_mkldnn_max_pool3d_backward_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool)(void* grad_output, void* output, void* input, void* kernel_size, void* stride, void* padding, void* dilation, void* ceil_mode);
  HOST_API void* lantern_mkldnn_max_pool3d_backward_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool(void* grad_output, void* output, void* input, void* kernel_size, void* stride, void* padding, void* dilation, void* ceil_mode) { LANTERN_CHECK_LOADED void* ret = _lantern_mkldnn_max_pool3d_backward_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool(grad_output, output, input, kernel_size, stride, padding, dilation, ceil_mode); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_quantized_max_pool1d_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool)(void* self, void* kernel_size, void* stride, void* padding, void* dilation, void* ceil_mode);
  HOST_API void* lantern_quantized_max_pool1d_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool(void* self, void* kernel_size, void* stride, void* padding, void* dilation, void* ceil_mode) { LANTERN_CHECK_LOADED void* ret = _lantern_quantized_max_pool1d_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool(self, kernel_size, stride, padding, dilation, ceil_mode); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_quantized_max_pool2d_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool)(void* self, void* kernel_size, void* stride, void* padding, void* dilation, void* ceil_mode);
  HOST_API void* lantern_quantized_max_pool2d_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool(void* self, void* kernel_size, void* stride, void* padding, void* dilation, void* ceil_mode) { LANTERN_CHECK_LOADED void* ret = _lantern_quantized_max_pool2d_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool(self, kernel_size, stride, padding, dilation, ceil_mode); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_max_pool3d_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool)(void* self, void* kernel_size, void* stride, void* padding, void* dilation, void* ceil_mode);
  HOST_API void* lantern_max_pool3d_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool(void* self, void* kernel_size, void* stride, void* padding, void* dilation, void* ceil_mode) { LANTERN_CHECK_LOADED void* ret = _lantern_max_pool3d_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool(self, kernel_size, stride, padding, dilation, ceil_mode); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_mean_tensor_scalartype)(void* self, void* dtype);
  HOST_API void* lantern_mean_tensor_scalartype(void* self, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern_mean_tensor_scalartype(self, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_mean_tensor_scalartype)(void* self, void* dtype);
  HOST_API void* lantern_Tensor_mean_tensor_scalartype(void* self, void* dtype) { void* ret = _lantern_Tensor_mean_tensor_scalartype(self, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_mean_tensor_intarrayref_bool_scalartype)(void* self, void* dim, void* keepdim, void* dtype);
  HOST_API void* lantern_mean_tensor_intarrayref_bool_scalartype(void* self, void* dim, void* keepdim, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern_mean_tensor_intarrayref_bool_scalartype(self, dim, keepdim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_mean_tensor_intarrayref_bool_scalartype)(void* self, void* dim, void* keepdim, void* dtype);
  HOST_API void* lantern_Tensor_mean_tensor_intarrayref_bool_scalartype(void* self, void* dim, void* keepdim, void* dtype) { void* ret = _lantern_Tensor_mean_tensor_intarrayref_bool_scalartype(self, dim, keepdim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_mean_out_tensor_tensor_intarrayref_bool_scalartype)(void* out, void* self, void* dim, void* keepdim, void* dtype);
  HOST_API void* lantern_mean_out_tensor_tensor_intarrayref_bool_scalartype(void* out, void* self, void* dim, void* keepdim, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern_mean_out_tensor_tensor_intarrayref_bool_scalartype(out, self, dim, keepdim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_mean_tensor_dimnamelist_bool_scalartype)(void* self, void* dim, void* keepdim, void* dtype);
  HOST_API void* lantern_mean_tensor_dimnamelist_bool_scalartype(void* self, void* dim, void* keepdim, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern_mean_tensor_dimnamelist_bool_scalartype(self, dim, keepdim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_mean_tensor_dimnamelist_bool_scalartype)(void* self, void* dim, void* keepdim, void* dtype);
  HOST_API void* lantern_Tensor_mean_tensor_dimnamelist_bool_scalartype(void* self, void* dim, void* keepdim, void* dtype) { void* ret = _lantern_Tensor_mean_tensor_dimnamelist_bool_scalartype(self, dim, keepdim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_mean_out_tensor_tensor_dimnamelist_bool_scalartype)(void* out, void* self, void* dim, void* keepdim, void* dtype);
  HOST_API void* lantern_mean_out_tensor_tensor_dimnamelist_bool_scalartype(void* out, void* self, void* dim, void* keepdim, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern_mean_out_tensor_tensor_dimnamelist_bool_scalartype(out, self, dim, keepdim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_nanmean_tensor_intarrayref_bool_scalartype)(void* self, void* dim, void* keepdim, void* dtype);
  HOST_API void* lantern_nanmean_tensor_intarrayref_bool_scalartype(void* self, void* dim, void* keepdim, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern_nanmean_tensor_intarrayref_bool_scalartype(self, dim, keepdim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_nanmean_tensor_intarrayref_bool_scalartype)(void* self, void* dim, void* keepdim, void* dtype);
  HOST_API void* lantern_Tensor_nanmean_tensor_intarrayref_bool_scalartype(void* self, void* dim, void* keepdim, void* dtype) { void* ret = _lantern_Tensor_nanmean_tensor_intarrayref_bool_scalartype(self, dim, keepdim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_nanmean_out_tensor_tensor_intarrayref_bool_scalartype)(void* out, void* self, void* dim, void* keepdim, void* dtype);
  HOST_API void* lantern_nanmean_out_tensor_tensor_intarrayref_bool_scalartype(void* out, void* self, void* dim, void* keepdim, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern_nanmean_out_tensor_tensor_intarrayref_bool_scalartype(out, self, dim, keepdim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_median_tensor)(void* self);
  HOST_API void* lantern_median_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_median_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_median_tensor)(void* self);
  HOST_API void* lantern_Tensor_median_tensor(void* self) { void* ret = _lantern_Tensor_median_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_median_tensor_intt_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_median_tensor_intt_bool(void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_median_tensor_intt_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_median_tensor_intt_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_Tensor_median_tensor_intt_bool(void* self, void* dim, void* keepdim) { void* ret = _lantern_Tensor_median_tensor_intt_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_median_out_tensor_tensor_tensor_intt_bool)(void* values, void* indices, void* self, void* dim, void* keepdim);
  HOST_API void* lantern_median_out_tensor_tensor_tensor_intt_bool(void* values, void* indices, void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_median_out_tensor_tensor_tensor_intt_bool(values, indices, self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_median_tensor_dimname_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_median_tensor_dimname_bool(void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_median_tensor_dimname_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_median_tensor_dimname_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_Tensor_median_tensor_dimname_bool(void* self, void* dim, void* keepdim) { void* ret = _lantern_Tensor_median_tensor_dimname_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_median_out_tensor_tensor_tensor_dimname_bool)(void* values, void* indices, void* self, void* dim, void* keepdim);
  HOST_API void* lantern_median_out_tensor_tensor_tensor_dimname_bool(void* values, void* indices, void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_median_out_tensor_tensor_tensor_dimname_bool(values, indices, self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_nanmedian_tensor)(void* self);
  HOST_API void* lantern_nanmedian_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_nanmedian_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_nanmedian_tensor)(void* self);
  HOST_API void* lantern_Tensor_nanmedian_tensor(void* self) { void* ret = _lantern_Tensor_nanmedian_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_nanmedian_tensor_intt_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_nanmedian_tensor_intt_bool(void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_nanmedian_tensor_intt_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_nanmedian_tensor_intt_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_Tensor_nanmedian_tensor_intt_bool(void* self, void* dim, void* keepdim) { void* ret = _lantern_Tensor_nanmedian_tensor_intt_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_nanmedian_out_tensor_tensor_tensor_intt_bool)(void* values, void* indices, void* self, void* dim, void* keepdim);
  HOST_API void* lantern_nanmedian_out_tensor_tensor_tensor_intt_bool(void* values, void* indices, void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_nanmedian_out_tensor_tensor_tensor_intt_bool(values, indices, self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_nanmedian_tensor_dimname_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_nanmedian_tensor_dimname_bool(void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_nanmedian_tensor_dimname_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_nanmedian_tensor_dimname_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_Tensor_nanmedian_tensor_dimname_bool(void* self, void* dim, void* keepdim) { void* ret = _lantern_Tensor_nanmedian_tensor_dimname_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_nanmedian_out_tensor_tensor_tensor_dimname_bool)(void* values, void* indices, void* self, void* dim, void* keepdim);
  HOST_API void* lantern_nanmedian_out_tensor_tensor_tensor_dimname_bool(void* values, void* indices, void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_nanmedian_out_tensor_tensor_tensor_dimname_bool(values, indices, self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_min_tensor_intt_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_min_tensor_intt_bool(void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_min_tensor_intt_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_min_tensor_intt_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_Tensor_min_tensor_intt_bool(void* self, void* dim, void* keepdim) { void* ret = _lantern_Tensor_min_tensor_intt_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_min_out_tensor_tensor_tensor_intt_bool)(void* min, void* min_indices, void* self, void* dim, void* keepdim);
  HOST_API void* lantern_min_out_tensor_tensor_tensor_intt_bool(void* min, void* min_indices, void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_min_out_tensor_tensor_tensor_intt_bool(min, min_indices, self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_min_tensor_dimname_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_min_tensor_dimname_bool(void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_min_tensor_dimname_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_min_tensor_dimname_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_Tensor_min_tensor_dimname_bool(void* self, void* dim, void* keepdim) { void* ret = _lantern_Tensor_min_tensor_dimname_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_min_out_tensor_tensor_tensor_dimname_bool)(void* min, void* min_indices, void* self, void* dim, void* keepdim);
  HOST_API void* lantern_min_out_tensor_tensor_tensor_dimname_bool(void* min, void* min_indices, void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_min_out_tensor_tensor_tensor_dimname_bool(min, min_indices, self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_amin_tensor_intarrayref_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_amin_tensor_intarrayref_bool(void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_amin_tensor_intarrayref_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_amin_tensor_intarrayref_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_Tensor_amin_tensor_intarrayref_bool(void* self, void* dim, void* keepdim) { void* ret = _lantern_Tensor_amin_tensor_intarrayref_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_amin_out_tensor_tensor_intarrayref_bool)(void* out, void* self, void* dim, void* keepdim);
  HOST_API void* lantern_amin_out_tensor_tensor_intarrayref_bool(void* out, void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_amin_out_tensor_tensor_intarrayref_bool(out, self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__mps_convolution_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intt)(void* self, void* weight, void* bias, void* padding, void* stride, void* dilation, void* groups);
  HOST_API void* lantern__mps_convolution_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intt(void* self, void* weight, void* bias, void* padding, void* stride, void* dilation, void* groups) { LANTERN_CHECK_LOADED void* ret = _lantern__mps_convolution_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intt(self, weight, bias, padding, stride, dilation, groups); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_mps_convolution_backward_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intt_stdarraybool)(void* self, void* grad_output, void* weight, void* padding, void* stride, void* dilation, void* groups, void* output_mask);
  HOST_API void* lantern_mps_convolution_backward_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intt_stdarraybool(void* self, void* grad_output, void* weight, void* padding, void* stride, void* dilation, void* groups, void* output_mask) { LANTERN_CHECK_LOADED void* ret = _lantern_mps_convolution_backward_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intt_stdarraybool(self, grad_output, weight, padding, stride, dilation, groups, output_mask); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_mkldnn_convolution_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intt)(void* self, void* weight, void* bias, void* padding, void* stride, void* dilation, void* groups);
  HOST_API void* lantern_mkldnn_convolution_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intt(void* self, void* weight, void* bias, void* padding, void* stride, void* dilation, void* groups) { LANTERN_CHECK_LOADED void* ret = _lantern_mkldnn_convolution_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intt(self, weight, bias, padding, stride, dilation, groups); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_miopen_batch_norm_tensor_tensor_tensor_tensor_tensor_bool_double_double)(void* input, void* weight, void* bias, void* running_mean, void* running_var, void* training, void* exponential_average_factor, void* epsilon);
  HOST_API void* lantern_miopen_batch_norm_tensor_tensor_tensor_tensor_tensor_bool_double_double(void* input, void* weight, void* bias, void* running_mean, void* running_var, void* training, void* exponential_average_factor, void* epsilon) { LANTERN_CHECK_LOADED void* ret = _lantern_miopen_batch_norm_tensor_tensor_tensor_tensor_tensor_bool_double_double(input, weight, bias, running_mean, running_var, training, exponential_average_factor, epsilon); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_miopen_batch_norm_backward_tensor_tensor_tensor_tensor_tensor_tensor_tensor_double)(void* input, void* grad_output, void* weight, void* running_mean, void* running_var, void* save_mean, void* save_var, void* epsilon);
  HOST_API void* lantern_miopen_batch_norm_backward_tensor_tensor_tensor_tensor_tensor_tensor_tensor_double(void* input, void* grad_output, void* weight, void* running_mean, void* running_var, void* save_mean, void* save_var, void* epsilon) { LANTERN_CHECK_LOADED void* ret = _lantern_miopen_batch_norm_backward_tensor_tensor_tensor_tensor_tensor_tensor_tensor_double(input, grad_output, weight, running_mean, running_var, save_mean, save_var, epsilon); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_miopen_convolution_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intt_bool_bool)(void* self, void* weight, void* bias, void* padding, void* stride, void* dilation, void* groups, void* benchmark, void* deterministic);
  HOST_API void* lantern_miopen_convolution_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intt_bool_bool(void* self, void* weight, void* bias, void* padding, void* stride, void* dilation, void* groups, void* benchmark, void* deterministic) { LANTERN_CHECK_LOADED void* ret = _lantern_miopen_convolution_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intt_bool_bool(self, weight, bias, padding, stride, dilation, groups, benchmark, deterministic); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_miopen_convolution_transpose_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_intt_bool_bool)(void* self, void* weight, void* bias, void* padding, void* output_padding, void* stride, void* dilation, void* groups, void* benchmark, void* deterministic);
  HOST_API void* lantern_miopen_convolution_transpose_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_intt_bool_bool(void* self, void* weight, void* bias, void* padding, void* output_padding, void* stride, void* dilation, void* groups, void* benchmark, void* deterministic) { LANTERN_CHECK_LOADED void* ret = _lantern_miopen_convolution_transpose_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_intt_bool_bool(self, weight, bias, padding, output_padding, stride, dilation, groups, benchmark, deterministic); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_miopen_depthwise_convolution_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intt_bool_bool)(void* self, void* weight, void* bias, void* padding, void* stride, void* dilation, void* groups, void* benchmark, void* deterministic);
  HOST_API void* lantern_miopen_depthwise_convolution_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intt_bool_bool(void* self, void* weight, void* bias, void* padding, void* stride, void* dilation, void* groups, void* benchmark, void* deterministic) { LANTERN_CHECK_LOADED void* ret = _lantern_miopen_depthwise_convolution_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intt_bool_bool(self, weight, bias, padding, stride, dilation, groups, benchmark, deterministic); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_miopen_convolution_relu_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intt)(void* self, void* weight, void* bias, void* stride, void* padding, void* dilation, void* groups);
  HOST_API void* lantern_miopen_convolution_relu_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intt(void* self, void* weight, void* bias, void* stride, void* padding, void* dilation, void* groups) { LANTERN_CHECK_LOADED void* ret = _lantern_miopen_convolution_relu_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intt(self, weight, bias, stride, padding, dilation, groups); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_miopen_convolution_add_relu_tensor_tensor_tensor_scalar_tensor_intarrayref_intarrayref_intarrayref_intt)(void* self, void* weight, void* z, void* alpha, void* bias, void* stride, void* padding, void* dilation, void* groups);
  HOST_API void* lantern_miopen_convolution_add_relu_tensor_tensor_tensor_scalar_tensor_intarrayref_intarrayref_intarrayref_intt(void* self, void* weight, void* z, void* alpha, void* bias, void* stride, void* padding, void* dilation, void* groups) { LANTERN_CHECK_LOADED void* ret = _lantern_miopen_convolution_add_relu_tensor_tensor_tensor_scalar_tensor_intarrayref_intarrayref_intarrayref_intt(self, weight, z, alpha, bias, stride, padding, dilation, groups); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_miopen_rnn_tensor_tensorlist_intt_tensor_tensor_intt_intt_intt_bool_double_bool_bool_intarrayref_tensor)(void* input, void* weight, void* weight_stride0, void* hx, void* cx, void* mode, void* hidden_size, void* num_layers, void* batch_first, void* dropout, void* train, void* bidirectional, void* batch_sizes, void* dropout_state);
  HOST_API void* lantern_miopen_rnn_tensor_tensorlist_intt_tensor_tensor_intt_intt_intt_bool_double_bool_bool_intarrayref_tensor(void* input, void* weight, void* weight_stride0, void* hx, void* cx, void* mode, void* hidden_size, void* num_layers, void* batch_first, void* dropout, void* train, void* bidirectional, void* batch_sizes, void* dropout_state) { LANTERN_CHECK_LOADED void* ret = _lantern_miopen_rnn_tensor_tensorlist_intt_tensor_tensor_intt_intt_intt_bool_double_bool_bool_intarrayref_tensor(input, weight, weight_stride0, hx, cx, mode, hidden_size, num_layers, batch_first, dropout, train, bidirectional, batch_sizes, dropout_state); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_miopen_rnn_backward_tensor_tensorlist_intt_tensor_tensor_tensor_tensor_tensor_tensor_tensor_intt_intt_intt_bool_double_bool_bool_intarrayref_tensor_tensor_stdarraybool)(void* input, void* weight, void* weight_stride0, void* weight_buf, void* hx, void* cx, void* output, void* grad_output, void* grad_hy, void* grad_cy, void* mode, void* hidden_size, void* num_layers, void* batch_first, void* dropout, void* train, void* bidirectional, void* batch_sizes, void* dropout_state, void* reserve, void* output_mask);
  HOST_API void* lantern_miopen_rnn_backward_tensor_tensorlist_intt_tensor_tensor_tensor_tensor_tensor_tensor_tensor_intt_intt_intt_bool_double_bool_bool_intarrayref_tensor_tensor_stdarraybool(void* input, void* weight, void* weight_stride0, void* weight_buf, void* hx, void* cx, void* output, void* grad_output, void* grad_hy, void* grad_cy, void* mode, void* hidden_size, void* num_layers, void* batch_first, void* dropout, void* train, void* bidirectional, void* batch_sizes, void* dropout_state, void* reserve, void* output_mask) { LANTERN_CHECK_LOADED void* ret = _lantern_miopen_rnn_backward_tensor_tensorlist_intt_tensor_tensor_tensor_tensor_tensor_tensor_tensor_intt_intt_intt_bool_double_bool_bool_intarrayref_tensor_tensor_stdarraybool(input, weight, weight_stride0, weight_buf, hx, cx, output, grad_output, grad_hy, grad_cy, mode, hidden_size, num_layers, batch_first, dropout, train, bidirectional, batch_sizes, dropout_state, reserve, output_mask); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_mm_tensor_tensor)(void* self, void* mat2);
  HOST_API void* lantern_mm_tensor_tensor(void* self, void* mat2) { LANTERN_CHECK_LOADED void* ret = _lantern_mm_tensor_tensor(self, mat2); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_mm_tensor_tensor)(void* self, void* mat2);
  HOST_API void* lantern_Tensor_mm_tensor_tensor(void* self, void* mat2) { void* ret = _lantern_Tensor_mm_tensor_tensor(self, mat2); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_mm_out_tensor_tensor_tensor)(void* out, void* self, void* mat2);
  HOST_API void* lantern_mm_out_tensor_tensor_tensor(void* out, void* self, void* mat2) { LANTERN_CHECK_LOADED void* ret = _lantern_mm_out_tensor_tensor_tensor(out, self, mat2); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__sparse_mm_tensor_tensor)(void* sparse, void* dense);
  HOST_API void* lantern__sparse_mm_tensor_tensor(void* sparse, void* dense) { LANTERN_CHECK_LOADED void* ret = _lantern__sparse_mm_tensor_tensor(sparse, dense); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__sparse_sparse_matmul_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern__sparse_sparse_matmul_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern__sparse_sparse_matmul_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__sparse_mask_helper_tensor_tensor)(void* t, void* mask_indices);
  HOST_API void* lantern__sparse_mask_helper_tensor_tensor(void* t, void* mask_indices) { LANTERN_CHECK_LOADED void* ret = _lantern__sparse_mask_helper_tensor_tensor(t, mask_indices); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_mode_tensor_intt_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_mode_tensor_intt_bool(void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_mode_tensor_intt_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_mode_tensor_intt_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_Tensor_mode_tensor_intt_bool(void* self, void* dim, void* keepdim) { void* ret = _lantern_Tensor_mode_tensor_intt_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_mode_out_tensor_tensor_tensor_intt_bool)(void* values, void* indices, void* self, void* dim, void* keepdim);
  HOST_API void* lantern_mode_out_tensor_tensor_tensor_intt_bool(void* values, void* indices, void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_mode_out_tensor_tensor_tensor_intt_bool(values, indices, self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_mode_tensor_dimname_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_mode_tensor_dimname_bool(void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_mode_tensor_dimname_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_mode_tensor_dimname_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_Tensor_mode_tensor_dimname_bool(void* self, void* dim, void* keepdim) { void* ret = _lantern_Tensor_mode_tensor_dimname_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_mode_out_tensor_tensor_tensor_dimname_bool)(void* values, void* indices, void* self, void* dim, void* keepdim);
  HOST_API void* lantern_mode_out_tensor_tensor_tensor_dimname_bool(void* values, void* indices, void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_mode_out_tensor_tensor_tensor_dimname_bool(values, indices, self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_mul_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_mul_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_mul_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_mul_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_mul_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_mul_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_mul__tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_mul__tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_mul__tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_mul_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_mul_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_mul_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_mul_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_mul_tensor_scalar(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_mul_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_mul_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_mul_tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_mul_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_mul__tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_mul__tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_mul__tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_multiply_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_multiply_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_multiply_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_multiply_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_multiply_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_multiply_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_multiply__tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_multiply__tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_multiply__tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_multiply_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_multiply_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_multiply_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_multiply_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_multiply_tensor_scalar(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_multiply_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_multiply_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_multiply_tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_multiply_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_multiply__tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_multiply__tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_multiply__tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_mv_tensor_tensor)(void* self, void* vec);
  HOST_API void* lantern_mv_tensor_tensor(void* self, void* vec) { LANTERN_CHECK_LOADED void* ret = _lantern_mv_tensor_tensor(self, vec); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_mv_tensor_tensor)(void* self, void* vec);
  HOST_API void* lantern_Tensor_mv_tensor_tensor(void* self, void* vec) { void* ret = _lantern_Tensor_mv_tensor_tensor(self, vec); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_mv_out_tensor_tensor_tensor)(void* out, void* self, void* vec);
  HOST_API void* lantern_mv_out_tensor_tensor_tensor(void* out, void* self, void* vec) { LANTERN_CHECK_LOADED void* ret = _lantern_mv_out_tensor_tensor_tensor(out, self, vec); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_mvlgamma_out_tensor_tensor_intt)(void* out, void* self, void* p);
  HOST_API void* lantern_mvlgamma_out_tensor_tensor_intt(void* out, void* self, void* p) { LANTERN_CHECK_LOADED void* ret = _lantern_mvlgamma_out_tensor_tensor_intt(out, self, p); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_mvlgamma_tensor_intt)(void* self, void* p);
  HOST_API void* lantern_mvlgamma_tensor_intt(void* self, void* p) { LANTERN_CHECK_LOADED void* ret = _lantern_mvlgamma_tensor_intt(self, p); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_mvlgamma_tensor_intt)(void* self, void* p);
  HOST_API void* lantern_Tensor_mvlgamma_tensor_intt(void* self, void* p) { void* ret = _lantern_Tensor_mvlgamma_tensor_intt(self, p); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_mvlgamma__tensor_intt)(void* self, void* p);
  HOST_API void* lantern_Tensor_mvlgamma__tensor_intt(void* self, void* p) { void* ret = _lantern_Tensor_mvlgamma__tensor_intt(self, p); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_narrow_copy_tensor_intt_intt_intt)(void* self, void* dim, void* start, void* length);
  HOST_API void* lantern_narrow_copy_tensor_intt_intt_intt(void* self, void* dim, void* start, void* length) { LANTERN_CHECK_LOADED void* ret = _lantern_narrow_copy_tensor_intt_intt_intt(self, dim, start, length); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_narrow_copy_tensor_intt_intt_intt)(void* self, void* dim, void* start, void* length);
  HOST_API void* lantern_Tensor_narrow_copy_tensor_intt_intt_intt(void* self, void* dim, void* start, void* length) { void* ret = _lantern_Tensor_narrow_copy_tensor_intt_intt_intt(self, dim, start, length); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_narrow_copy_out_tensor_tensor_intt_intt_intt)(void* out, void* self, void* dim, void* start, void* length);
  HOST_API void* lantern_narrow_copy_out_tensor_tensor_intt_intt_intt(void* out, void* self, void* dim, void* start, void* length) { LANTERN_CHECK_LOADED void* ret = _lantern_narrow_copy_out_tensor_tensor_intt_intt_intt(out, self, dim, start, length); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_narrow_tensor_intt_intt_intt)(void* self, void* dim, void* start, void* length);
  HOST_API void* lantern_narrow_tensor_intt_intt_intt(void* self, void* dim, void* start, void* length) { LANTERN_CHECK_LOADED void* ret = _lantern_narrow_tensor_intt_intt_intt(self, dim, start, length); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_narrow_tensor_intt_intt_intt)(void* self, void* dim, void* start, void* length);
  HOST_API void* lantern_Tensor_narrow_tensor_intt_intt_intt(void* self, void* dim, void* start, void* length) { void* ret = _lantern_Tensor_narrow_tensor_intt_intt_intt(self, dim, start, length); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_narrow_tensor_intt_tensor_intt)(void* self, void* dim, void* start, void* length);
  HOST_API void* lantern_narrow_tensor_intt_tensor_intt(void* self, void* dim, void* start, void* length) { LANTERN_CHECK_LOADED void* ret = _lantern_narrow_tensor_intt_tensor_intt(self, dim, start, length); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_narrow_tensor_intt_tensor_intt)(void* self, void* dim, void* start, void* length);
  HOST_API void* lantern_Tensor_narrow_tensor_intt_tensor_intt(void* self, void* dim, void* start, void* length) { void* ret = _lantern_Tensor_narrow_tensor_intt_tensor_intt(self, dim, start, length); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_native_batch_norm_tensor_tensor_tensor_tensor_tensor_bool_double_double)(void* input, void* weight, void* bias, void* running_mean, void* running_var, void* training, void* momentum, void* eps);
  HOST_API void* lantern_native_batch_norm_tensor_tensor_tensor_tensor_tensor_bool_double_double(void* input, void* weight, void* bias, void* running_mean, void* running_var, void* training, void* momentum, void* eps) { LANTERN_CHECK_LOADED void* ret = _lantern_native_batch_norm_tensor_tensor_tensor_tensor_tensor_bool_double_double(input, weight, bias, running_mean, running_var, training, momentum, eps); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_native_batch_norm_out_tensor_tensor_tensor_tensor_tensor_tensor_tensor_tensor_bool_double_double)(void* out, void* save_mean, void* save_invstd, void* input, void* weight, void* bias, void* running_mean, void* running_var, void* training, void* momentum, void* eps);
  HOST_API void* lantern_native_batch_norm_out_tensor_tensor_tensor_tensor_tensor_tensor_tensor_tensor_bool_double_double(void* out, void* save_mean, void* save_invstd, void* input, void* weight, void* bias, void* running_mean, void* running_var, void* training, void* momentum, void* eps) { LANTERN_CHECK_LOADED void* ret = _lantern_native_batch_norm_out_tensor_tensor_tensor_tensor_tensor_tensor_tensor_tensor_bool_double_double(out, save_mean, save_invstd, input, weight, bias, running_mean, running_var, training, momentum, eps); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_batch_norm_stats_tensor_double)(void* input, void* eps);
  HOST_API void* lantern_batch_norm_stats_tensor_double(void* input, void* eps) { LANTERN_CHECK_LOADED void* ret = _lantern_batch_norm_stats_tensor_double(input, eps); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_batch_norm_elemt_tensor_tensor_tensor_tensor_tensor_double)(void* input, void* weight, void* bias, void* mean, void* invstd, void* eps);
  HOST_API void* lantern_batch_norm_elemt_tensor_tensor_tensor_tensor_tensor_double(void* input, void* weight, void* bias, void* mean, void* invstd, void* eps) { LANTERN_CHECK_LOADED void* ret = _lantern_batch_norm_elemt_tensor_tensor_tensor_tensor_tensor_double(input, weight, bias, mean, invstd, eps); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_batch_norm_elemt_out_tensor_tensor_tensor_tensor_tensor_tensor_double)(void* out, void* input, void* weight, void* bias, void* mean, void* invstd, void* eps);
  HOST_API void* lantern_batch_norm_elemt_out_tensor_tensor_tensor_tensor_tensor_tensor_double(void* out, void* input, void* weight, void* bias, void* mean, void* invstd, void* eps) { LANTERN_CHECK_LOADED void* ret = _lantern_batch_norm_elemt_out_tensor_tensor_tensor_tensor_tensor_tensor_double(out, input, weight, bias, mean, invstd, eps); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_batch_norm_gather_stats_tensor_tensor_tensor_tensor_tensor_double_double_intt)(void* input, void* mean, void* invstd, void* running_mean, void* running_var, void* momentum, void* eps, void* count);
  HOST_API void* lantern_batch_norm_gather_stats_tensor_tensor_tensor_tensor_tensor_double_double_intt(void* input, void* mean, void* invstd, void* running_mean, void* running_var, void* momentum, void* eps, void* count) { LANTERN_CHECK_LOADED void* ret = _lantern_batch_norm_gather_stats_tensor_tensor_tensor_tensor_tensor_double_double_intt(input, mean, invstd, running_mean, running_var, momentum, eps, count); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_batch_norm_gather_stats_with_counts_tensor_tensor_tensor_tensor_tensor_double_double_tensor)(void* input, void* mean, void* invstd, void* running_mean, void* running_var, void* momentum, void* eps, void* counts);
  HOST_API void* lantern_batch_norm_gather_stats_with_counts_tensor_tensor_tensor_tensor_tensor_double_double_tensor(void* input, void* mean, void* invstd, void* running_mean, void* running_var, void* momentum, void* eps, void* counts) { LANTERN_CHECK_LOADED void* ret = _lantern_batch_norm_gather_stats_with_counts_tensor_tensor_tensor_tensor_tensor_double_double_tensor(input, mean, invstd, running_mean, running_var, momentum, eps, counts); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_native_batch_norm_backward_tensor_tensor_tensor_tensor_tensor_tensor_tensor_bool_double_stdarraybool)(void* grad_out, void* input, void* weight, void* running_mean, void* running_var, void* save_mean, void* save_invstd, void* train, void* eps, void* output_mask);
  HOST_API void* lantern_native_batch_norm_backward_tensor_tensor_tensor_tensor_tensor_tensor_tensor_bool_double_stdarraybool(void* grad_out, void* input, void* weight, void* running_mean, void* running_var, void* save_mean, void* save_invstd, void* train, void* eps, void* output_mask) { LANTERN_CHECK_LOADED void* ret = _lantern_native_batch_norm_backward_tensor_tensor_tensor_tensor_tensor_tensor_tensor_bool_double_stdarraybool(grad_out, input, weight, running_mean, running_var, save_mean, save_invstd, train, eps, output_mask); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_batch_norm_backward_reduce_tensor_tensor_tensor_tensor_tensor_bool_bool_bool)(void* grad_out, void* input, void* mean, void* invstd, void* weight, void* input_g, void* weight_g, void* bias_g);
  HOST_API void* lantern_batch_norm_backward_reduce_tensor_tensor_tensor_tensor_tensor_bool_bool_bool(void* grad_out, void* input, void* mean, void* invstd, void* weight, void* input_g, void* weight_g, void* bias_g) { LANTERN_CHECK_LOADED void* ret = _lantern_batch_norm_backward_reduce_tensor_tensor_tensor_tensor_tensor_bool_bool_bool(grad_out, input, mean, invstd, weight, input_g, weight_g, bias_g); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_batch_norm_backward_elemt_tensor_tensor_tensor_tensor_tensor_tensor_tensor_tensor)(void* grad_out, void* input, void* mean, void* invstd, void* weight, void* mean_dy, void* mean_dy_xmu, void* count);
  HOST_API void* lantern_batch_norm_backward_elemt_tensor_tensor_tensor_tensor_tensor_tensor_tensor_tensor(void* grad_out, void* input, void* mean, void* invstd, void* weight, void* mean_dy, void* mean_dy_xmu, void* count) { LANTERN_CHECK_LOADED void* ret = _lantern_batch_norm_backward_elemt_tensor_tensor_tensor_tensor_tensor_tensor_tensor_tensor(grad_out, input, mean, invstd, weight, mean_dy, mean_dy_xmu, count); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_batch_norm_update_stats_tensor_tensor_tensor_double)(void* input, void* running_mean, void* running_var, void* momentum);
  HOST_API void* lantern_batch_norm_update_stats_tensor_tensor_tensor_double(void* input, void* running_mean, void* running_var, void* momentum) { LANTERN_CHECK_LOADED void* ret = _lantern_batch_norm_update_stats_tensor_tensor_tensor_double(input, running_mean, running_var, momentum); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_is_vulkan_available)();
  HOST_API void* lantern_is_vulkan_available() { LANTERN_CHECK_LOADED void* ret = _lantern_is_vulkan_available(); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__nnpack_available)();
  HOST_API void* lantern__nnpack_available() { LANTERN_CHECK_LOADED void* ret = _lantern__nnpack_available(); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__nnpack_spatial_convolution_tensor_tensor_tensor_intarrayref_intarrayref)(void* input, void* weight, void* bias, void* padding, void* stride);
  HOST_API void* lantern__nnpack_spatial_convolution_tensor_tensor_tensor_intarrayref_intarrayref(void* input, void* weight, void* bias, void* padding, void* stride) { LANTERN_CHECK_LOADED void* ret = _lantern__nnpack_spatial_convolution_tensor_tensor_tensor_intarrayref_intarrayref(input, weight, bias, padding, stride); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_ones_intarrayref_dimnamelist_tensoroptions)(void* size, void* names, void* options);
  HOST_API void* lantern_ones_intarrayref_dimnamelist_tensoroptions(void* size, void* names, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_ones_intarrayref_dimnamelist_tensoroptions(size, names, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_ones_intarrayref_tensoroptions)(void* size, void* options);
  HOST_API void* lantern_ones_intarrayref_tensoroptions(void* size, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_ones_intarrayref_tensoroptions(size, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_ones_out_tensor_intarrayref)(void* out, void* size);
  HOST_API void* lantern_ones_out_tensor_intarrayref(void* out, void* size) { LANTERN_CHECK_LOADED void* ret = _lantern_ones_out_tensor_intarrayref(out, size); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_ones_like_tensor_tensoroptions_memoryformat)(void* self, void* options, void* memory_format);
  HOST_API void* lantern_ones_like_tensor_tensoroptions_memoryformat(void* self, void* options, void* memory_format) { LANTERN_CHECK_LOADED void* ret = _lantern_ones_like_tensor_tensoroptions_memoryformat(self, options, memory_format); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_pairwise_distance_tensor_tensor_double_double_bool)(void* x1, void* x2, void* p, void* eps, void* keepdim);
  HOST_API void* lantern_pairwise_distance_tensor_tensor_double_double_bool(void* x1, void* x2, void* p, void* eps, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_pairwise_distance_tensor_tensor_double_double_bool(x1, x2, p, eps, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cdist_tensor_tensor_double_intt)(void* x1, void* x2, void* p, void* compute_mode);
  HOST_API void* lantern_cdist_tensor_tensor_double_intt(void* x1, void* x2, void* p, void* compute_mode) { LANTERN_CHECK_LOADED void* ret = _lantern_cdist_tensor_tensor_double_intt(x1, x2, p, compute_mode); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__euclidean_dist_tensor_tensor)(void* x1, void* x2);
  HOST_API void* lantern__euclidean_dist_tensor_tensor(void* x1, void* x2) { LANTERN_CHECK_LOADED void* ret = _lantern__euclidean_dist_tensor_tensor(x1, x2); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__cdist_forward_tensor_tensor_double_intt)(void* x1, void* x2, void* p, void* compute_mode);
  HOST_API void* lantern__cdist_forward_tensor_tensor_double_intt(void* x1, void* x2, void* p, void* compute_mode) { LANTERN_CHECK_LOADED void* ret = _lantern__cdist_forward_tensor_tensor_double_intt(x1, x2, p, compute_mode); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__cdist_backward_tensor_tensor_tensor_double_tensor)(void* grad, void* x1, void* x2, void* p, void* cdist);
  HOST_API void* lantern__cdist_backward_tensor_tensor_tensor_double_tensor(void* grad, void* x1, void* x2, void* p, void* cdist) { LANTERN_CHECK_LOADED void* ret = _lantern__cdist_backward_tensor_tensor_tensor_double_tensor(grad, x1, x2, p, cdist); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_pdist_tensor_double)(void* self, void* p);
  HOST_API void* lantern_pdist_tensor_double(void* self, void* p) { LANTERN_CHECK_LOADED void* ret = _lantern_pdist_tensor_double(self, p); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__pdist_forward_tensor_double)(void* self, void* p);
  HOST_API void* lantern__pdist_forward_tensor_double(void* self, void* p) { LANTERN_CHECK_LOADED void* ret = _lantern__pdist_forward_tensor_double(self, p); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__pdist_backward_tensor_tensor_double_tensor)(void* grad, void* self, void* p, void* pdist);
  HOST_API void* lantern__pdist_backward_tensor_tensor_double_tensor(void* grad, void* self, void* p, void* pdist) { LANTERN_CHECK_LOADED void* ret = _lantern__pdist_backward_tensor_tensor_double_tensor(grad, self, p, pdist); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cosine_similarity_tensor_tensor_intt_double)(void* x1, void* x2, void* dim, void* eps);
  HOST_API void* lantern_cosine_similarity_tensor_tensor_intt_double(void* x1, void* x2, void* dim, void* eps) { LANTERN_CHECK_LOADED void* ret = _lantern_cosine_similarity_tensor_tensor_intt_double(x1, x2, dim, eps); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_permute_tensor_intarrayref)(void* self, void* dims);
  HOST_API void* lantern_permute_tensor_intarrayref(void* self, void* dims) { LANTERN_CHECK_LOADED void* ret = _lantern_permute_tensor_intarrayref(self, dims); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_permute_tensor_intarrayref)(void* self, void* dims);
  HOST_API void* lantern_Tensor_permute_tensor_intarrayref(void* self, void* dims) { void* ret = _lantern_Tensor_permute_tensor_intarrayref(self, dims); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_movedim_tensor_intarrayref_intarrayref)(void* self, void* source, void* destination);
  HOST_API void* lantern_movedim_tensor_intarrayref_intarrayref(void* self, void* source, void* destination) { LANTERN_CHECK_LOADED void* ret = _lantern_movedim_tensor_intarrayref_intarrayref(self, source, destination); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_movedim_tensor_intarrayref_intarrayref)(void* self, void* source, void* destination);
  HOST_API void* lantern_Tensor_movedim_tensor_intarrayref_intarrayref(void* self, void* source, void* destination) { void* ret = _lantern_Tensor_movedim_tensor_intarrayref_intarrayref(self, source, destination); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_movedim_tensor_intt_intt)(void* self, void* source, void* destination);
  HOST_API void* lantern_movedim_tensor_intt_intt(void* self, void* source, void* destination) { LANTERN_CHECK_LOADED void* ret = _lantern_movedim_tensor_intt_intt(self, source, destination); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_movedim_tensor_intt_intt)(void* self, void* source, void* destination);
  HOST_API void* lantern_Tensor_movedim_tensor_intt_intt(void* self, void* source, void* destination) { void* ret = _lantern_Tensor_movedim_tensor_intt_intt(self, source, destination); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_moveaxis_tensor_intarrayref_intarrayref)(void* self, void* source, void* destination);
  HOST_API void* lantern_moveaxis_tensor_intarrayref_intarrayref(void* self, void* source, void* destination) { LANTERN_CHECK_LOADED void* ret = _lantern_moveaxis_tensor_intarrayref_intarrayref(self, source, destination); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_moveaxis_tensor_intarrayref_intarrayref)(void* self, void* source, void* destination);
  HOST_API void* lantern_Tensor_moveaxis_tensor_intarrayref_intarrayref(void* self, void* source, void* destination) { void* ret = _lantern_Tensor_moveaxis_tensor_intarrayref_intarrayref(self, source, destination); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_moveaxis_tensor_intt_intt)(void* self, void* source, void* destination);
  HOST_API void* lantern_moveaxis_tensor_intt_intt(void* self, void* source, void* destination) { LANTERN_CHECK_LOADED void* ret = _lantern_moveaxis_tensor_intt_intt(self, source, destination); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_moveaxis_tensor_intt_intt)(void* self, void* source, void* destination);
  HOST_API void* lantern_Tensor_moveaxis_tensor_intt_intt(void* self, void* source, void* destination) { void* ret = _lantern_Tensor_moveaxis_tensor_intt_intt(self, source, destination); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_numpy_t_tensor)(void* self);
  HOST_API void* lantern_Tensor_numpy_t_tensor(void* self) { void* ret = _lantern_Tensor_numpy_t_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_matrix_h_tensor)(void* self);
  HOST_API void* lantern_Tensor_matrix_h_tensor(void* self) { void* ret = _lantern_Tensor_matrix_h_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_mt_tensor)(void* self);
  HOST_API void* lantern_Tensor_mt_tensor(void* self) { void* ret = _lantern_Tensor_mt_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_mh_tensor)(void* self);
  HOST_API void* lantern_Tensor_mh_tensor(void* self) { void* ret = _lantern_Tensor_mh_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_adjoint_tensor)(void* self);
  HOST_API void* lantern_adjoint_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_adjoint_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_adjoint_tensor)(void* self);
  HOST_API void* lantern_Tensor_adjoint_tensor(void* self) { void* ret = _lantern_Tensor_adjoint_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_pixel_shuffle_tensor_intt)(void* self, void* upscale_factor);
  HOST_API void* lantern_pixel_shuffle_tensor_intt(void* self, void* upscale_factor) { LANTERN_CHECK_LOADED void* ret = _lantern_pixel_shuffle_tensor_intt(self, upscale_factor); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_pixel_unshuffle_tensor_intt)(void* self, void* downscale_factor);
  HOST_API void* lantern_pixel_unshuffle_tensor_intt(void* self, void* downscale_factor) { LANTERN_CHECK_LOADED void* ret = _lantern_pixel_unshuffle_tensor_intt(self, downscale_factor); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_channel_shuffle_tensor_intt)(void* self, void* groups);
  HOST_API void* lantern_channel_shuffle_tensor_intt(void* self, void* groups) { LANTERN_CHECK_LOADED void* ret = _lantern_channel_shuffle_tensor_intt(self, groups); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_native_channel_shuffle_tensor_intt)(void* self, void* groups);
  HOST_API void* lantern_native_channel_shuffle_tensor_intt(void* self, void* groups) { LANTERN_CHECK_LOADED void* ret = _lantern_native_channel_shuffle_tensor_intt(self, groups); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_is_pinned_tensor_device)(void* self, void* device);
  HOST_API void* lantern_Tensor_is_pinned_tensor_device(void* self, void* device) { void* ret = _lantern_Tensor_is_pinned_tensor_device(self, device); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_pin_memory_tensor_device)(void* self, void* device);
  HOST_API void* lantern_Tensor_pin_memory_tensor_device(void* self, void* device) { void* ret = _lantern_Tensor_pin_memory_tensor_device(self, device); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__pin_memory_tensor_device)(void* self, void* device);
  HOST_API void* lantern__pin_memory_tensor_device(void* self, void* device) { LANTERN_CHECK_LOADED void* ret = _lantern__pin_memory_tensor_device(self, device); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_pinverse_tensor_double)(void* self, void* rcond);
  HOST_API void* lantern_pinverse_tensor_double(void* self, void* rcond) { LANTERN_CHECK_LOADED void* ret = _lantern_pinverse_tensor_double(self, rcond); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_pinverse_tensor_double)(void* self, void* rcond);
  HOST_API void* lantern_Tensor_pinverse_tensor_double(void* self, void* rcond) { void* ret = _lantern_Tensor_pinverse_tensor_double(self, rcond); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_poisson_nll_loss_tensor_tensor_bool_bool_double_intt)(void* input, void* target, void* log_input, void* full, void* eps, void* reduction);
  HOST_API void* lantern_poisson_nll_loss_tensor_tensor_bool_bool_double_intt(void* input, void* target, void* log_input, void* full, void* eps, void* reduction) { LANTERN_CHECK_LOADED void* ret = _lantern_poisson_nll_loss_tensor_tensor_bool_bool_double_intt(input, target, log_input, full, eps, reduction); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_rad2deg_tensor)(void* self);
  HOST_API void* lantern_rad2deg_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_rad2deg_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_rad2deg_tensor)(void* self);
  HOST_API void* lantern_Tensor_rad2deg_tensor(void* self) { void* ret = _lantern_Tensor_rad2deg_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_rad2deg__tensor)(void* self);
  HOST_API void* lantern_rad2deg__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_rad2deg__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_rad2deg__tensor)(void* self);
  HOST_API void* lantern_Tensor_rad2deg__tensor(void* self) { void* ret = _lantern_Tensor_rad2deg__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_rad2deg_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_rad2deg_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_rad2deg_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_deg2rad_tensor)(void* self);
  HOST_API void* lantern_deg2rad_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_deg2rad_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_deg2rad_tensor)(void* self);
  HOST_API void* lantern_Tensor_deg2rad_tensor(void* self) { void* ret = _lantern_Tensor_deg2rad_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_deg2rad__tensor)(void* self);
  HOST_API void* lantern_deg2rad__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_deg2rad__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_deg2rad__tensor)(void* self);
  HOST_API void* lantern_Tensor_deg2rad__tensor(void* self) { void* ret = _lantern_Tensor_deg2rad__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_deg2rad_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_deg2rad_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_deg2rad_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_scalar_tensor_scalar_tensoroptions)(void* s, void* options);
  HOST_API void* lantern_scalar_tensor_scalar_tensoroptions(void* s, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_scalar_tensor_scalar_tensoroptions(s, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_rand_intarrayref_dimnamelist_tensoroptions)(void* size, void* names, void* options);
  HOST_API void* lantern_rand_intarrayref_dimnamelist_tensoroptions(void* size, void* names, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_rand_intarrayref_dimnamelist_tensoroptions(size, names, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_rand_intarrayref_generator_dimnamelist_tensoroptions)(void* size, void* generator, void* names, void* options);
  HOST_API void* lantern_rand_intarrayref_generator_dimnamelist_tensoroptions(void* size, void* generator, void* names, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_rand_intarrayref_generator_dimnamelist_tensoroptions(size, generator, names, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_rand_intarrayref_tensoroptions)(void* size, void* options);
  HOST_API void* lantern_rand_intarrayref_tensoroptions(void* size, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_rand_intarrayref_tensoroptions(size, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_rand_intarrayref_generator_tensoroptions)(void* size, void* generator, void* options);
  HOST_API void* lantern_rand_intarrayref_generator_tensoroptions(void* size, void* generator, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_rand_intarrayref_generator_tensoroptions(size, generator, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_rand_out_tensor_intarrayref)(void* out, void* size);
  HOST_API void* lantern_rand_out_tensor_intarrayref(void* out, void* size) { LANTERN_CHECK_LOADED void* ret = _lantern_rand_out_tensor_intarrayref(out, size); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_rand_out_tensor_intarrayref_generator)(void* out, void* size, void* generator);
  HOST_API void* lantern_rand_out_tensor_intarrayref_generator(void* out, void* size, void* generator) { LANTERN_CHECK_LOADED void* ret = _lantern_rand_out_tensor_intarrayref_generator(out, size, generator); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_rand_like_tensor_tensoroptions_memoryformat)(void* self, void* options, void* memory_format);
  HOST_API void* lantern_rand_like_tensor_tensoroptions_memoryformat(void* self, void* options, void* memory_format) { LANTERN_CHECK_LOADED void* ret = _lantern_rand_like_tensor_tensoroptions_memoryformat(self, options, memory_format); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_randint_intt_intarrayref_tensoroptions)(void* high, void* size, void* options);
  HOST_API void* lantern_randint_intt_intarrayref_tensoroptions(void* high, void* size, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_randint_intt_intarrayref_tensoroptions(high, size, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_randint_intt_intarrayref_generator_tensoroptions)(void* high, void* size, void* generator, void* options);
  HOST_API void* lantern_randint_intt_intarrayref_generator_tensoroptions(void* high, void* size, void* generator, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_randint_intt_intarrayref_generator_tensoroptions(high, size, generator, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_randint_intt_intt_intarrayref_tensoroptions)(void* low, void* high, void* size, void* options);
  HOST_API void* lantern_randint_intt_intt_intarrayref_tensoroptions(void* low, void* high, void* size, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_randint_intt_intt_intarrayref_tensoroptions(low, high, size, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_randint_intt_intt_intarrayref_generator_tensoroptions)(void* low, void* high, void* size, void* generator, void* options);
  HOST_API void* lantern_randint_intt_intt_intarrayref_generator_tensoroptions(void* low, void* high, void* size, void* generator, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_randint_intt_intt_intarrayref_generator_tensoroptions(low, high, size, generator, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_randint_out_tensor_intt_intarrayref)(void* out, void* high, void* size);
  HOST_API void* lantern_randint_out_tensor_intt_intarrayref(void* out, void* high, void* size) { LANTERN_CHECK_LOADED void* ret = _lantern_randint_out_tensor_intt_intarrayref(out, high, size); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_randint_out_tensor_intt_intarrayref_generator)(void* out, void* high, void* size, void* generator);
  HOST_API void* lantern_randint_out_tensor_intt_intarrayref_generator(void* out, void* high, void* size, void* generator) { LANTERN_CHECK_LOADED void* ret = _lantern_randint_out_tensor_intt_intarrayref_generator(out, high, size, generator); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_randint_out_tensor_intt_intt_intarrayref)(void* out, void* low, void* high, void* size);
  HOST_API void* lantern_randint_out_tensor_intt_intt_intarrayref(void* out, void* low, void* high, void* size) { LANTERN_CHECK_LOADED void* ret = _lantern_randint_out_tensor_intt_intt_intarrayref(out, low, high, size); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_randint_out_tensor_intt_intt_intarrayref_generator)(void* out, void* low, void* high, void* size, void* generator);
  HOST_API void* lantern_randint_out_tensor_intt_intt_intarrayref_generator(void* out, void* low, void* high, void* size, void* generator) { LANTERN_CHECK_LOADED void* ret = _lantern_randint_out_tensor_intt_intt_intarrayref_generator(out, low, high, size, generator); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_randint_like_tensor_intt_tensoroptions_memoryformat)(void* self, void* high, void* options, void* memory_format);
  HOST_API void* lantern_randint_like_tensor_intt_tensoroptions_memoryformat(void* self, void* high, void* options, void* memory_format) { LANTERN_CHECK_LOADED void* ret = _lantern_randint_like_tensor_intt_tensoroptions_memoryformat(self, high, options, memory_format); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_randint_like_tensor_intt_intt_tensoroptions_memoryformat)(void* self, void* low, void* high, void* options, void* memory_format);
  HOST_API void* lantern_randint_like_tensor_intt_intt_tensoroptions_memoryformat(void* self, void* low, void* high, void* options, void* memory_format) { LANTERN_CHECK_LOADED void* ret = _lantern_randint_like_tensor_intt_intt_tensoroptions_memoryformat(self, low, high, options, memory_format); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_randn_intarrayref_tensoroptions)(void* size, void* options);
  HOST_API void* lantern_randn_intarrayref_tensoroptions(void* size, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_randn_intarrayref_tensoroptions(size, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_randn_intarrayref_generator_tensoroptions)(void* size, void* generator, void* options);
  HOST_API void* lantern_randn_intarrayref_generator_tensoroptions(void* size, void* generator, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_randn_intarrayref_generator_tensoroptions(size, generator, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_randn_intarrayref_dimnamelist_tensoroptions)(void* size, void* names, void* options);
  HOST_API void* lantern_randn_intarrayref_dimnamelist_tensoroptions(void* size, void* names, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_randn_intarrayref_dimnamelist_tensoroptions(size, names, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_randn_intarrayref_generator_dimnamelist_tensoroptions)(void* size, void* generator, void* names, void* options);
  HOST_API void* lantern_randn_intarrayref_generator_dimnamelist_tensoroptions(void* size, void* generator, void* names, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_randn_intarrayref_generator_dimnamelist_tensoroptions(size, generator, names, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_randn_out_tensor_intarrayref)(void* out, void* size);
  HOST_API void* lantern_randn_out_tensor_intarrayref(void* out, void* size) { LANTERN_CHECK_LOADED void* ret = _lantern_randn_out_tensor_intarrayref(out, size); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_randn_out_tensor_intarrayref_generator)(void* out, void* size, void* generator);
  HOST_API void* lantern_randn_out_tensor_intarrayref_generator(void* out, void* size, void* generator) { LANTERN_CHECK_LOADED void* ret = _lantern_randn_out_tensor_intarrayref_generator(out, size, generator); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_randn_like_tensor_tensoroptions_memoryformat)(void* self, void* options, void* memory_format);
  HOST_API void* lantern_randn_like_tensor_tensoroptions_memoryformat(void* self, void* options, void* memory_format) { LANTERN_CHECK_LOADED void* ret = _lantern_randn_like_tensor_tensoroptions_memoryformat(self, options, memory_format); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_randperm_intt_tensoroptions)(void* n, void* options);
  HOST_API void* lantern_randperm_intt_tensoroptions(void* n, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_randperm_intt_tensoroptions(n, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_randperm_intt_generator_tensoroptions)(void* n, void* generator, void* options);
  HOST_API void* lantern_randperm_intt_generator_tensoroptions(void* n, void* generator, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_randperm_intt_generator_tensoroptions(n, generator, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_randperm_out_tensor_intt)(void* out, void* n);
  HOST_API void* lantern_randperm_out_tensor_intt(void* out, void* n) { LANTERN_CHECK_LOADED void* ret = _lantern_randperm_out_tensor_intt(out, n); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_randperm_out_tensor_intt_generator)(void* out, void* n, void* generator);
  HOST_API void* lantern_randperm_out_tensor_intt_generator(void* out, void* n, void* generator) { LANTERN_CHECK_LOADED void* ret = _lantern_randperm_out_tensor_intt_generator(out, n, generator); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_range_scalar_scalar_scalar_tensoroptions)(void* start, void* end, void* step, void* options);
  HOST_API void* lantern_range_scalar_scalar_scalar_tensoroptions(void* start, void* end, void* step, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_range_scalar_scalar_scalar_tensoroptions(start, end, step, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_range_scalar_scalar_tensoroptions)(void* start, void* end, void* options);
  HOST_API void* lantern_range_scalar_scalar_tensoroptions(void* start, void* end, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_range_scalar_scalar_tensoroptions(start, end, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_range_out_tensor_scalar_scalar)(void* out, void* start, void* end);
  HOST_API void* lantern_range_out_tensor_scalar_scalar(void* out, void* start, void* end) { LANTERN_CHECK_LOADED void* ret = _lantern_range_out_tensor_scalar_scalar(out, start, end); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_range_out_tensor_scalar_scalar_scalar)(void* out, void* start, void* end, void* step);
  HOST_API void* lantern_range_out_tensor_scalar_scalar_scalar(void* out, void* start, void* end, void* step) { LANTERN_CHECK_LOADED void* ret = _lantern_range_out_tensor_scalar_scalar_scalar(out, start, end, step); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_ravel_tensor)(void* self);
  HOST_API void* lantern_ravel_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_ravel_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_ravel_tensor)(void* self);
  HOST_API void* lantern_Tensor_ravel_tensor(void* self) { void* ret = _lantern_Tensor_ravel_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_reciprocal_tensor)(void* self);
  HOST_API void* lantern_reciprocal_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_reciprocal_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_reciprocal_tensor)(void* self);
  HOST_API void* lantern_Tensor_reciprocal_tensor(void* self) { void* ret = _lantern_Tensor_reciprocal_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_reciprocal__tensor)(void* self);
  HOST_API void* lantern_reciprocal__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_reciprocal__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_reciprocal__tensor)(void* self);
  HOST_API void* lantern_Tensor_reciprocal__tensor(void* self) { void* ret = _lantern_Tensor_reciprocal__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_reciprocal_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_reciprocal_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_reciprocal_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_neg_tensor)(void* self);
  HOST_API void* lantern_neg_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_neg_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_neg_tensor)(void* self);
  HOST_API void* lantern_Tensor_neg_tensor(void* self) { void* ret = _lantern_Tensor_neg_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_neg__tensor)(void* self);
  HOST_API void* lantern_neg__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_neg__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_neg__tensor)(void* self);
  HOST_API void* lantern_Tensor_neg__tensor(void* self) { void* ret = _lantern_Tensor_neg__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_neg_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_neg_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_neg_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_negative_tensor)(void* self);
  HOST_API void* lantern_negative_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_negative_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_negative_tensor)(void* self);
  HOST_API void* lantern_Tensor_negative_tensor(void* self) { void* ret = _lantern_Tensor_negative_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_negative__tensor)(void* self);
  HOST_API void* lantern_negative__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_negative__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_negative__tensor)(void* self);
  HOST_API void* lantern_Tensor_negative__tensor(void* self) { void* ret = _lantern_Tensor_negative__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_negative_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_negative_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_negative_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_repeat_tensor_intarrayref)(void* self, void* repeats);
  HOST_API void* lantern_Tensor_repeat_tensor_intarrayref(void* self, void* repeats) { void* ret = _lantern_Tensor_repeat_tensor_intarrayref(self, repeats); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_repeat_interleave_tensor_intt)(void* repeats, void* output_size);
  HOST_API void* lantern_repeat_interleave_tensor_intt(void* repeats, void* output_size) { LANTERN_CHECK_LOADED void* ret = _lantern_repeat_interleave_tensor_intt(repeats, output_size); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_repeat_interleave_tensor_tensor_intt_intt)(void* self, void* repeats, void* dim, void* output_size);
  HOST_API void* lantern_repeat_interleave_tensor_tensor_intt_intt(void* self, void* repeats, void* dim, void* output_size) { LANTERN_CHECK_LOADED void* ret = _lantern_repeat_interleave_tensor_tensor_intt_intt(self, repeats, dim, output_size); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_repeat_interleave_tensor_tensor_intt_intt)(void* self, void* repeats, void* dim, void* output_size);
  HOST_API void* lantern_Tensor_repeat_interleave_tensor_tensor_intt_intt(void* self, void* repeats, void* dim, void* output_size) { void* ret = _lantern_Tensor_repeat_interleave_tensor_tensor_intt_intt(self, repeats, dim, output_size); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_repeat_interleave_tensor_intt_intt_intt)(void* self, void* repeats, void* dim, void* output_size);
  HOST_API void* lantern_repeat_interleave_tensor_intt_intt_intt(void* self, void* repeats, void* dim, void* output_size) { LANTERN_CHECK_LOADED void* ret = _lantern_repeat_interleave_tensor_intt_intt_intt(self, repeats, dim, output_size); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_repeat_interleave_tensor_intt_intt_intt)(void* self, void* repeats, void* dim, void* output_size);
  HOST_API void* lantern_Tensor_repeat_interleave_tensor_intt_intt_intt(void* self, void* repeats, void* dim, void* output_size) { void* ret = _lantern_Tensor_repeat_interleave_tensor_intt_intt_intt(self, repeats, dim, output_size); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_reshape_tensor_intarrayref)(void* self, void* shape);
  HOST_API void* lantern_reshape_tensor_intarrayref(void* self, void* shape) { LANTERN_CHECK_LOADED void* ret = _lantern_reshape_tensor_intarrayref(self, shape); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_reshape_tensor_intarrayref)(void* self, void* shape);
  HOST_API void* lantern_Tensor_reshape_tensor_intarrayref(void* self, void* shape) { void* ret = _lantern_Tensor_reshape_tensor_intarrayref(self, shape); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__reshape_alias_tensor_intarrayref_intarrayref)(void* self, void* size, void* stride);
  HOST_API void* lantern__reshape_alias_tensor_intarrayref_intarrayref(void* self, void* size, void* stride) { LANTERN_CHECK_LOADED void* ret = _lantern__reshape_alias_tensor_intarrayref_intarrayref(self, size, stride); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor__reshape_alias_tensor_intarrayref_intarrayref)(void* self, void* size, void* stride);
  HOST_API void* lantern_Tensor__reshape_alias_tensor_intarrayref_intarrayref(void* self, void* size, void* stride) { void* ret = _lantern_Tensor__reshape_alias_tensor_intarrayref_intarrayref(self, size, stride); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__mkldnn_reshape_tensor_intarrayref)(void* self, void* shape);
  HOST_API void* lantern__mkldnn_reshape_tensor_intarrayref(void* self, void* shape) { LANTERN_CHECK_LOADED void* ret = _lantern__mkldnn_reshape_tensor_intarrayref(self, shape); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_reshape_as_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_reshape_as_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_reshape_as_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_round_tensor)(void* self);
  HOST_API void* lantern_round_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_round_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_round_tensor)(void* self);
  HOST_API void* lantern_Tensor_round_tensor(void* self) { void* ret = _lantern_Tensor_round_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_round__tensor)(void* self);
  HOST_API void* lantern_round__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_round__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_round__tensor)(void* self);
  HOST_API void* lantern_Tensor_round__tensor(void* self) { void* ret = _lantern_Tensor_round__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_round_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_round_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_round_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_round_tensor_intt)(void* self, void* decimals);
  HOST_API void* lantern_round_tensor_intt(void* self, void* decimals) { LANTERN_CHECK_LOADED void* ret = _lantern_round_tensor_intt(self, decimals); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_round_tensor_intt)(void* self, void* decimals);
  HOST_API void* lantern_Tensor_round_tensor_intt(void* self, void* decimals) { void* ret = _lantern_Tensor_round_tensor_intt(self, decimals); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_round__tensor_intt)(void* self, void* decimals);
  HOST_API void* lantern_round__tensor_intt(void* self, void* decimals) { LANTERN_CHECK_LOADED void* ret = _lantern_round__tensor_intt(self, decimals); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_round__tensor_intt)(void* self, void* decimals);
  HOST_API void* lantern_Tensor_round__tensor_intt(void* self, void* decimals) { void* ret = _lantern_Tensor_round__tensor_intt(self, decimals); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_round_out_tensor_tensor_intt)(void* out, void* self, void* decimals);
  HOST_API void* lantern_round_out_tensor_tensor_intt(void* out, void* self, void* decimals) { LANTERN_CHECK_LOADED void* ret = _lantern_round_out_tensor_tensor_intt(out, self, decimals); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_rrelu_tensor_scalar_scalar_bool_generator)(void* self, void* lower, void* upper, void* training, void* generator);
  HOST_API void* lantern_rrelu_tensor_scalar_scalar_bool_generator(void* self, void* lower, void* upper, void* training, void* generator) { LANTERN_CHECK_LOADED void* ret = _lantern_rrelu_tensor_scalar_scalar_bool_generator(self, lower, upper, training, generator); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_rrelu__tensor_scalar_scalar_bool_generator)(void* self, void* lower, void* upper, void* training, void* generator);
  HOST_API void* lantern_rrelu__tensor_scalar_scalar_bool_generator(void* self, void* lower, void* upper, void* training, void* generator) { LANTERN_CHECK_LOADED void* ret = _lantern_rrelu__tensor_scalar_scalar_bool_generator(self, lower, upper, training, generator); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_relu_tensor)(void* self);
  HOST_API void* lantern_relu_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_relu_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_relu_tensor)(void* self);
  HOST_API void* lantern_Tensor_relu_tensor(void* self) { void* ret = _lantern_Tensor_relu_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_relu__tensor)(void* self);
  HOST_API void* lantern_relu__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_relu__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_relu__tensor)(void* self);
  HOST_API void* lantern_Tensor_relu__tensor(void* self) { void* ret = _lantern_Tensor_relu__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_relu6_tensor)(void* self);
  HOST_API void* lantern_relu6_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_relu6_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_relu6__tensor)(void* self);
  HOST_API void* lantern_relu6__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_relu6__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_prelu_tensor_tensor)(void* self, void* weight);
  HOST_API void* lantern_prelu_tensor_tensor(void* self, void* weight) { LANTERN_CHECK_LOADED void* ret = _lantern_prelu_tensor_tensor(self, weight); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_prelu_tensor_tensor)(void* self, void* weight);
  HOST_API void* lantern_Tensor_prelu_tensor_tensor(void* self, void* weight) { void* ret = _lantern_Tensor_prelu_tensor_tensor(self, weight); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_prelu_backward_tensor_tensor_tensor)(void* grad_output, void* self, void* weight);
  HOST_API void* lantern_prelu_backward_tensor_tensor_tensor(void* grad_output, void* self, void* weight) { LANTERN_CHECK_LOADED void* ret = _lantern_prelu_backward_tensor_tensor_tensor(grad_output, self, weight); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_prelu_backward_tensor_tensor_tensor)(void* grad_output, void* self, void* weight);
  HOST_API void* lantern_Tensor_prelu_backward_tensor_tensor_tensor(void* grad_output, void* self, void* weight) { void* ret = _lantern_Tensor_prelu_backward_tensor_tensor_tensor(grad_output, self, weight); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_gelu_out_tensor_tensor_cstringview)(void* out, void* self, void* approximate);
  HOST_API void* lantern_gelu_out_tensor_tensor_cstringview(void* out, void* self, void* approximate) { LANTERN_CHECK_LOADED void* ret = _lantern_gelu_out_tensor_tensor_cstringview(out, self, approximate); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_gelu__tensor_cstringview)(void* self, void* approximate);
  HOST_API void* lantern_gelu__tensor_cstringview(void* self, void* approximate) { LANTERN_CHECK_LOADED void* ret = _lantern_gelu__tensor_cstringview(self, approximate); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_gelu_tensor_cstringview)(void* self, void* approximate);
  HOST_API void* lantern_gelu_tensor_cstringview(void* self, void* approximate) { LANTERN_CHECK_LOADED void* ret = _lantern_gelu_tensor_cstringview(self, approximate); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_gelu_backward_out_tensor_tensor_tensor_cstringview)(void* grad_input, void* grad_output, void* self, void* approximate);
  HOST_API void* lantern_gelu_backward_out_tensor_tensor_tensor_cstringview(void* grad_input, void* grad_output, void* self, void* approximate) { LANTERN_CHECK_LOADED void* ret = _lantern_gelu_backward_out_tensor_tensor_tensor_cstringview(grad_input, grad_output, self, approximate); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_gelu_backward_tensor_tensor_cstringview)(void* grad_output, void* self, void* approximate);
  HOST_API void* lantern_gelu_backward_tensor_tensor_cstringview(void* grad_output, void* self, void* approximate) { LANTERN_CHECK_LOADED void* ret = _lantern_gelu_backward_tensor_tensor_cstringview(grad_output, self, approximate); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_infinitely_differentiable_gelu_backward_tensor_tensor)(void* grad, void* self);
  HOST_API void* lantern_infinitely_differentiable_gelu_backward_tensor_tensor(void* grad, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_infinitely_differentiable_gelu_backward_tensor_tensor(grad, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_hardshrink_out_tensor_tensor_scalar)(void* out, void* self, void* lambd);
  HOST_API void* lantern_hardshrink_out_tensor_tensor_scalar(void* out, void* self, void* lambd) { LANTERN_CHECK_LOADED void* ret = _lantern_hardshrink_out_tensor_tensor_scalar(out, self, lambd); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_hardshrink_tensor_scalar)(void* self, void* lambd);
  HOST_API void* lantern_hardshrink_tensor_scalar(void* self, void* lambd) { LANTERN_CHECK_LOADED void* ret = _lantern_hardshrink_tensor_scalar(self, lambd); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_hardshrink_tensor_scalar)(void* self, void* lambd);
  HOST_API void* lantern_Tensor_hardshrink_tensor_scalar(void* self, void* lambd) { void* ret = _lantern_Tensor_hardshrink_tensor_scalar(self, lambd); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_hardshrink_backward_out_tensor_tensor_tensor_scalar)(void* grad_input, void* grad_out, void* self, void* lambd);
  HOST_API void* lantern_hardshrink_backward_out_tensor_tensor_tensor_scalar(void* grad_input, void* grad_out, void* self, void* lambd) { LANTERN_CHECK_LOADED void* ret = _lantern_hardshrink_backward_out_tensor_tensor_tensor_scalar(grad_input, grad_out, self, lambd); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_hardshrink_backward_tensor_tensor_scalar)(void* grad_out, void* self, void* lambd);
  HOST_API void* lantern_hardshrink_backward_tensor_tensor_scalar(void* grad_out, void* self, void* lambd) { LANTERN_CHECK_LOADED void* ret = _lantern_hardshrink_backward_tensor_tensor_scalar(grad_out, self, lambd); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_hardshrink_backward_tensor_tensor_scalar)(void* grad_out, void* self, void* lambd);
  HOST_API void* lantern_Tensor_hardshrink_backward_tensor_tensor_scalar(void* grad_out, void* self, void* lambd) { void* ret = _lantern_Tensor_hardshrink_backward_tensor_tensor_scalar(grad_out, self, lambd); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_rsqrt_tensor)(void* self);
  HOST_API void* lantern_rsqrt_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_rsqrt_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_rsqrt_tensor)(void* self);
  HOST_API void* lantern_Tensor_rsqrt_tensor(void* self) { void* ret = _lantern_Tensor_rsqrt_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_rsqrt__tensor)(void* self);
  HOST_API void* lantern_rsqrt__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_rsqrt__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_rsqrt__tensor)(void* self);
  HOST_API void* lantern_Tensor_rsqrt__tensor(void* self) { void* ret = _lantern_Tensor_rsqrt__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_rsqrt_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_rsqrt_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_rsqrt_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_select_tensor_dimname_intt)(void* self, void* dim, void* index);
  HOST_API void* lantern_select_tensor_dimname_intt(void* self, void* dim, void* index) { LANTERN_CHECK_LOADED void* ret = _lantern_select_tensor_dimname_intt(self, dim, index); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_select_tensor_dimname_intt)(void* self, void* dim, void* index);
  HOST_API void* lantern_Tensor_select_tensor_dimname_intt(void* self, void* dim, void* index) { void* ret = _lantern_Tensor_select_tensor_dimname_intt(self, dim, index); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_select_tensor_intt_intt)(void* self, void* dim, void* index);
  HOST_API void* lantern_select_tensor_intt_intt(void* self, void* dim, void* index) { LANTERN_CHECK_LOADED void* ret = _lantern_select_tensor_intt_intt(self, dim, index); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_select_tensor_intt_intt)(void* self, void* dim, void* index);
  HOST_API void* lantern_Tensor_select_tensor_intt_intt(void* self, void* dim, void* index) { void* ret = _lantern_Tensor_select_tensor_intt_intt(self, dim, index); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_select_backward_tensor_intarrayref_intt_intt)(void* grad_output, void* input_sizes, void* dim, void* index);
  HOST_API void* lantern_select_backward_tensor_intarrayref_intt_intt(void* grad_output, void* input_sizes, void* dim, void* index) { LANTERN_CHECK_LOADED void* ret = _lantern_select_backward_tensor_intarrayref_intt_intt(grad_output, input_sizes, dim, index); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__nested_select_backward_tensor_tensor_intt_intt)(void* grad_output, void* self, void* dim, void* index);
  HOST_API void* lantern__nested_select_backward_tensor_tensor_intt_intt(void* grad_output, void* self, void* dim, void* index) { LANTERN_CHECK_LOADED void* ret = _lantern__nested_select_backward_tensor_tensor_intt_intt(grad_output, self, dim, index); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_selu_tensor)(void* self);
  HOST_API void* lantern_selu_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_selu_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_selu__tensor)(void* self);
  HOST_API void* lantern_selu__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_selu__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_celu_tensor_scalar)(void* self, void* alpha);
  HOST_API void* lantern_celu_tensor_scalar(void* self, void* alpha) { LANTERN_CHECK_LOADED void* ret = _lantern_celu_tensor_scalar(self, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_celu__tensor_scalar)(void* self, void* alpha);
  HOST_API void* lantern_celu__tensor_scalar(void* self, void* alpha) { LANTERN_CHECK_LOADED void* ret = _lantern_celu__tensor_scalar(self, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_silu_tensor)(void* self);
  HOST_API void* lantern_silu_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_silu_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_silu__tensor)(void* self);
  HOST_API void* lantern_silu__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_silu__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_silu_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_silu_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_silu_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_silu_backward_out_tensor_tensor_tensor)(void* grad_input, void* grad_output, void* self);
  HOST_API void* lantern_silu_backward_out_tensor_tensor_tensor(void* grad_input, void* grad_output, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_silu_backward_out_tensor_tensor_tensor(grad_input, grad_output, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_silu_backward_tensor_tensor)(void* grad_output, void* self);
  HOST_API void* lantern_silu_backward_tensor_tensor(void* grad_output, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_silu_backward_tensor_tensor(grad_output, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_mish_tensor)(void* self);
  HOST_API void* lantern_mish_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_mish_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_mish__tensor)(void* self);
  HOST_API void* lantern_mish__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_mish__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_mish_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_mish_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_mish_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_mish_backward_tensor_tensor)(void* grad_output, void* self);
  HOST_API void* lantern_mish_backward_tensor_tensor(void* grad_output, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_mish_backward_tensor_tensor(grad_output, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sigmoid_tensor)(void* self);
  HOST_API void* lantern_sigmoid_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_sigmoid_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_sigmoid_tensor)(void* self);
  HOST_API void* lantern_Tensor_sigmoid_tensor(void* self) { void* ret = _lantern_Tensor_sigmoid_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sigmoid__tensor)(void* self);
  HOST_API void* lantern_sigmoid__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_sigmoid__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_sigmoid__tensor)(void* self);
  HOST_API void* lantern_Tensor_sigmoid__tensor(void* self) { void* ret = _lantern_Tensor_sigmoid__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sigmoid_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_sigmoid_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_sigmoid_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_logit_tensor_double)(void* self, void* eps);
  HOST_API void* lantern_logit_tensor_double(void* self, void* eps) { LANTERN_CHECK_LOADED void* ret = _lantern_logit_tensor_double(self, eps); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_logit_tensor_double)(void* self, void* eps);
  HOST_API void* lantern_Tensor_logit_tensor_double(void* self, void* eps) { void* ret = _lantern_Tensor_logit_tensor_double(self, eps); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_logit__tensor_double)(void* self, void* eps);
  HOST_API void* lantern_logit__tensor_double(void* self, void* eps) { LANTERN_CHECK_LOADED void* ret = _lantern_logit__tensor_double(self, eps); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_logit__tensor_double)(void* self, void* eps);
  HOST_API void* lantern_Tensor_logit__tensor_double(void* self, void* eps) { void* ret = _lantern_Tensor_logit__tensor_double(self, eps); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_logit_out_tensor_tensor_double)(void* out, void* self, void* eps);
  HOST_API void* lantern_logit_out_tensor_tensor_double(void* out, void* self, void* eps) { LANTERN_CHECK_LOADED void* ret = _lantern_logit_out_tensor_tensor_double(out, self, eps); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sin_tensor)(void* self);
  HOST_API void* lantern_sin_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_sin_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_sin_tensor)(void* self);
  HOST_API void* lantern_Tensor_sin_tensor(void* self) { void* ret = _lantern_Tensor_sin_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sin__tensor)(void* self);
  HOST_API void* lantern_sin__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_sin__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_sin__tensor)(void* self);
  HOST_API void* lantern_Tensor_sin__tensor(void* self) { void* ret = _lantern_Tensor_sin__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sin_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_sin_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_sin_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sinc_tensor)(void* self);
  HOST_API void* lantern_sinc_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_sinc_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_sinc_tensor)(void* self);
  HOST_API void* lantern_Tensor_sinc_tensor(void* self) { void* ret = _lantern_Tensor_sinc_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sinc__tensor)(void* self);
  HOST_API void* lantern_sinc__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_sinc__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_sinc__tensor)(void* self);
  HOST_API void* lantern_Tensor_sinc__tensor(void* self) { void* ret = _lantern_Tensor_sinc__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sinc_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_sinc_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_sinc_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sinh_tensor)(void* self);
  HOST_API void* lantern_sinh_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_sinh_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_sinh_tensor)(void* self);
  HOST_API void* lantern_Tensor_sinh_tensor(void* self) { void* ret = _lantern_Tensor_sinh_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sinh__tensor)(void* self);
  HOST_API void* lantern_sinh__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_sinh__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_sinh__tensor)(void* self);
  HOST_API void* lantern_Tensor_sinh__tensor(void* self) { void* ret = _lantern_Tensor_sinh__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sinh_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_sinh_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_sinh_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_detach_tensor)(void* self);
  HOST_API void* lantern_detach_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_detach_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_detach_tensor)(void* self);
  HOST_API void* lantern_Tensor_detach_tensor(void* self) { void* ret = _lantern_Tensor_detach_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_detach__tensor)(void* self);
  HOST_API void* lantern_detach__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_detach__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_detach__tensor)(void* self);
  HOST_API void* lantern_Tensor_detach__tensor(void* self) { void* ret = _lantern_Tensor_detach__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_size_tensor_intt)(void* self, void* dim);
  HOST_API void* lantern_size_tensor_intt(void* self, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_size_tensor_intt(self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_size_tensor_dimname)(void* self, void* dim);
  HOST_API void* lantern_size_tensor_dimname(void* self, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_size_tensor_dimname(self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_size_tensor_dimname)(void* self, void* dim);
  HOST_API void* lantern_Tensor_size_tensor_dimname(void* self, void* dim) { void* ret = _lantern_Tensor_size_tensor_dimname(self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_slice_tensor_intt_intt_intt_intt)(void* self, void* dim, void* start, void* end, void* step);
  HOST_API void* lantern_slice_tensor_intt_intt_intt_intt(void* self, void* dim, void* start, void* end, void* step) { LANTERN_CHECK_LOADED void* ret = _lantern_slice_tensor_intt_intt_intt_intt(self, dim, start, end, step); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_slice_tensor_intt_intt_intt_intt)(void* self, void* dim, void* start, void* end, void* step);
  HOST_API void* lantern_Tensor_slice_tensor_intt_intt_intt_intt(void* self, void* dim, void* start, void* end, void* step) { void* ret = _lantern_Tensor_slice_tensor_intt_intt_intt_intt(self, dim, start, end, step); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_slice_backward_tensor_intarrayref_intt_intt_intt_intt)(void* grad_output, void* input_sizes, void* dim, void* start, void* end, void* step);
  HOST_API void* lantern_slice_backward_tensor_intarrayref_intt_intt_intt_intt(void* grad_output, void* input_sizes, void* dim, void* start, void* end, void* step) { LANTERN_CHECK_LOADED void* ret = _lantern_slice_backward_tensor_intarrayref_intt_intt_intt_intt(grad_output, input_sizes, dim, start, end, step); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_slice_scatter_tensor_tensor_intt_intt_intt_intt)(void* self, void* src, void* dim, void* start, void* end, void* step);
  HOST_API void* lantern_slice_scatter_tensor_tensor_intt_intt_intt_intt(void* self, void* src, void* dim, void* start, void* end, void* step) { LANTERN_CHECK_LOADED void* ret = _lantern_slice_scatter_tensor_tensor_intt_intt_intt_intt(self, src, dim, start, end, step); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_slice_scatter_tensor_tensor_intt_intt_intt_intt)(void* self, void* src, void* dim, void* start, void* end, void* step);
  HOST_API void* lantern_Tensor_slice_scatter_tensor_tensor_intt_intt_intt_intt(void* self, void* src, void* dim, void* start, void* end, void* step) { void* ret = _lantern_Tensor_slice_scatter_tensor_tensor_intt_intt_intt_intt(self, src, dim, start, end, step); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_select_scatter_tensor_tensor_intt_intt)(void* self, void* src, void* dim, void* index);
  HOST_API void* lantern_select_scatter_tensor_tensor_intt_intt(void* self, void* src, void* dim, void* index) { LANTERN_CHECK_LOADED void* ret = _lantern_select_scatter_tensor_tensor_intt_intt(self, src, dim, index); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_select_scatter_tensor_tensor_intt_intt)(void* self, void* src, void* dim, void* index);
  HOST_API void* lantern_Tensor_select_scatter_tensor_tensor_intt_intt(void* self, void* src, void* dim, void* index) { void* ret = _lantern_Tensor_select_scatter_tensor_tensor_intt_intt(self, src, dim, index); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_diagonal_scatter_tensor_tensor_intt_intt_intt)(void* self, void* src, void* offset, void* dim1, void* dim2);
  HOST_API void* lantern_diagonal_scatter_tensor_tensor_intt_intt_intt(void* self, void* src, void* offset, void* dim1, void* dim2) { LANTERN_CHECK_LOADED void* ret = _lantern_diagonal_scatter_tensor_tensor_intt_intt_intt(self, src, offset, dim1, dim2); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_diagonal_scatter_tensor_tensor_intt_intt_intt)(void* self, void* src, void* offset, void* dim1, void* dim2);
  HOST_API void* lantern_Tensor_diagonal_scatter_tensor_tensor_intt_intt_intt(void* self, void* src, void* offset, void* dim1, void* dim2) { void* ret = _lantern_Tensor_diagonal_scatter_tensor_tensor_intt_intt_intt(self, src, offset, dim1, dim2); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_as_strided_scatter_tensor_tensor_intarrayref_intarrayref_intt)(void* self, void* src, void* size, void* stride, void* storage_offset);
  HOST_API void* lantern_as_strided_scatter_tensor_tensor_intarrayref_intarrayref_intt(void* self, void* src, void* size, void* stride, void* storage_offset) { LANTERN_CHECK_LOADED void* ret = _lantern_as_strided_scatter_tensor_tensor_intarrayref_intarrayref_intt(self, src, size, stride, storage_offset); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_as_strided_scatter_tensor_tensor_intarrayref_intarrayref_intt)(void* self, void* src, void* size, void* stride, void* storage_offset);
  HOST_API void* lantern_Tensor_as_strided_scatter_tensor_tensor_intarrayref_intarrayref_intt(void* self, void* src, void* size, void* stride, void* storage_offset) { void* ret = _lantern_Tensor_as_strided_scatter_tensor_tensor_intarrayref_intarrayref_intt(self, src, size, stride, storage_offset); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_smm_tensor_tensor)(void* self, void* mat2);
  HOST_API void* lantern_smm_tensor_tensor(void* self, void* mat2) { LANTERN_CHECK_LOADED void* ret = _lantern_smm_tensor_tensor(self, mat2); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_smm_tensor_tensor)(void* self, void* mat2);
  HOST_API void* lantern_Tensor_smm_tensor_tensor(void* self, void* mat2) { void* ret = _lantern_Tensor_smm_tensor_tensor(self, mat2); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_softmax_tensor_intt_scalartype)(void* self, void* dim, void* dtype);
  HOST_API void* lantern_softmax_tensor_intt_scalartype(void* self, void* dim, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern_softmax_tensor_intt_scalartype(self, dim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_softmax_tensor_intt_scalartype)(void* self, void* dim, void* dtype);
  HOST_API void* lantern_Tensor_softmax_tensor_intt_scalartype(void* self, void* dim, void* dtype) { void* ret = _lantern_Tensor_softmax_tensor_intt_scalartype(self, dim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_softmax_out_tensor_tensor_intt_scalartype)(void* out, void* self, void* dim, void* dtype);
  HOST_API void* lantern_softmax_out_tensor_tensor_intt_scalartype(void* out, void* self, void* dim, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern_softmax_out_tensor_tensor_intt_scalartype(out, self, dim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_softmax_tensor_dimname_scalartype)(void* self, void* dim, void* dtype);
  HOST_API void* lantern_softmax_tensor_dimname_scalartype(void* self, void* dim, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern_softmax_tensor_dimname_scalartype(self, dim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_softmax_tensor_dimname_scalartype)(void* self, void* dim, void* dtype);
  HOST_API void* lantern_Tensor_softmax_tensor_dimname_scalartype(void* self, void* dim, void* dtype) { void* ret = _lantern_Tensor_softmax_tensor_dimname_scalartype(self, dim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__softmax_tensor_intt_bool)(void* self, void* dim, void* half_to_float);
  HOST_API void* lantern__softmax_tensor_intt_bool(void* self, void* dim, void* half_to_float) { LANTERN_CHECK_LOADED void* ret = _lantern__softmax_tensor_intt_bool(self, dim, half_to_float); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__softmax_out_tensor_tensor_intt_bool)(void* out, void* self, void* dim, void* half_to_float);
  HOST_API void* lantern__softmax_out_tensor_tensor_intt_bool(void* out, void* self, void* dim, void* half_to_float) { LANTERN_CHECK_LOADED void* ret = _lantern__softmax_out_tensor_tensor_intt_bool(out, self, dim, half_to_float); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__softmax_backward_data_tensor_tensor_intt_scalartype)(void* grad_output, void* output, void* dim, void* input_dtype);
  HOST_API void* lantern__softmax_backward_data_tensor_tensor_intt_scalartype(void* grad_output, void* output, void* dim, void* input_dtype) { LANTERN_CHECK_LOADED void* ret = _lantern__softmax_backward_data_tensor_tensor_intt_scalartype(grad_output, output, dim, input_dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__softmax_backward_data_out_tensor_tensor_tensor_intt_scalartype)(void* grad_input, void* grad_output, void* output, void* dim, void* input_dtype);
  HOST_API void* lantern__softmax_backward_data_out_tensor_tensor_tensor_intt_scalartype(void* grad_input, void* grad_output, void* output, void* dim, void* input_dtype) { LANTERN_CHECK_LOADED void* ret = _lantern__softmax_backward_data_out_tensor_tensor_tensor_intt_scalartype(grad_input, grad_output, output, dim, input_dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_unsafe_split_tensor_intt_intt)(void* self, void* split_size, void* dim);
  HOST_API void* lantern_unsafe_split_tensor_intt_intt(void* self, void* split_size, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_unsafe_split_tensor_intt_intt(self, split_size, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_unsafe_split_tensor_intt_intt)(void* self, void* split_size, void* dim);
  HOST_API void* lantern_Tensor_unsafe_split_tensor_intt_intt(void* self, void* split_size, void* dim) { void* ret = _lantern_Tensor_unsafe_split_tensor_intt_intt(self, split_size, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_split_tensor_intt_intt)(void* self, void* split_size, void* dim);
  HOST_API void* lantern_split_tensor_intt_intt(void* self, void* split_size, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_split_tensor_intt_intt(self, split_size, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_split_tensor_intt_intt)(void* self, void* split_size, void* dim);
  HOST_API void* lantern_Tensor_split_tensor_intt_intt(void* self, void* split_size, void* dim) { void* ret = _lantern_Tensor_split_tensor_intt_intt(self, split_size, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_split_tensor_intarrayref_intt)(void* self, void* split_size, void* dim);
  HOST_API void* lantern_split_tensor_intarrayref_intt(void* self, void* split_size, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_split_tensor_intarrayref_intt(self, split_size, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_split_tensor_intarrayref_intt)(void* self, void* split_size, void* dim);
  HOST_API void* lantern_Tensor_split_tensor_intarrayref_intt(void* self, void* split_size, void* dim) { void* ret = _lantern_Tensor_split_tensor_intarrayref_intt(self, split_size, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_unsafe_split_with_sizes_tensor_intarrayref_intt)(void* self, void* split_sizes, void* dim);
  HOST_API void* lantern_unsafe_split_with_sizes_tensor_intarrayref_intt(void* self, void* split_sizes, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_unsafe_split_with_sizes_tensor_intarrayref_intt(self, split_sizes, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_unsafe_split_with_sizes_tensor_intarrayref_intt)(void* self, void* split_sizes, void* dim);
  HOST_API void* lantern_Tensor_unsafe_split_with_sizes_tensor_intarrayref_intt(void* self, void* split_sizes, void* dim) { void* ret = _lantern_Tensor_unsafe_split_with_sizes_tensor_intarrayref_intt(self, split_sizes, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_split_with_sizes_tensor_intarrayref_intt)(void* self, void* split_sizes, void* dim);
  HOST_API void* lantern_split_with_sizes_tensor_intarrayref_intt(void* self, void* split_sizes, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_split_with_sizes_tensor_intarrayref_intt(self, split_sizes, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_split_with_sizes_tensor_intarrayref_intt)(void* self, void* split_sizes, void* dim);
  HOST_API void* lantern_Tensor_split_with_sizes_tensor_intarrayref_intt(void* self, void* split_sizes, void* dim) { void* ret = _lantern_Tensor_split_with_sizes_tensor_intarrayref_intt(self, split_sizes, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_hsplit_tensor_intt)(void* self, void* sections);
  HOST_API void* lantern_hsplit_tensor_intt(void* self, void* sections) { LANTERN_CHECK_LOADED void* ret = _lantern_hsplit_tensor_intt(self, sections); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_hsplit_tensor_intt)(void* self, void* sections);
  HOST_API void* lantern_Tensor_hsplit_tensor_intt(void* self, void* sections) { void* ret = _lantern_Tensor_hsplit_tensor_intt(self, sections); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_hsplit_tensor_intarrayref)(void* self, void* indices);
  HOST_API void* lantern_hsplit_tensor_intarrayref(void* self, void* indices) { LANTERN_CHECK_LOADED void* ret = _lantern_hsplit_tensor_intarrayref(self, indices); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_hsplit_tensor_intarrayref)(void* self, void* indices);
  HOST_API void* lantern_Tensor_hsplit_tensor_intarrayref(void* self, void* indices) { void* ret = _lantern_Tensor_hsplit_tensor_intarrayref(self, indices); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_vsplit_tensor_intt)(void* self, void* sections);
  HOST_API void* lantern_vsplit_tensor_intt(void* self, void* sections) { LANTERN_CHECK_LOADED void* ret = _lantern_vsplit_tensor_intt(self, sections); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_vsplit_tensor_intt)(void* self, void* sections);
  HOST_API void* lantern_Tensor_vsplit_tensor_intt(void* self, void* sections) { void* ret = _lantern_Tensor_vsplit_tensor_intt(self, sections); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_vsplit_tensor_intarrayref)(void* self, void* indices);
  HOST_API void* lantern_vsplit_tensor_intarrayref(void* self, void* indices) { LANTERN_CHECK_LOADED void* ret = _lantern_vsplit_tensor_intarrayref(self, indices); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_vsplit_tensor_intarrayref)(void* self, void* indices);
  HOST_API void* lantern_Tensor_vsplit_tensor_intarrayref(void* self, void* indices) { void* ret = _lantern_Tensor_vsplit_tensor_intarrayref(self, indices); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_dsplit_tensor_intt)(void* self, void* sections);
  HOST_API void* lantern_dsplit_tensor_intt(void* self, void* sections) { LANTERN_CHECK_LOADED void* ret = _lantern_dsplit_tensor_intt(self, sections); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_dsplit_tensor_intt)(void* self, void* sections);
  HOST_API void* lantern_Tensor_dsplit_tensor_intt(void* self, void* sections) { void* ret = _lantern_Tensor_dsplit_tensor_intt(self, sections); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_dsplit_tensor_intarrayref)(void* self, void* indices);
  HOST_API void* lantern_dsplit_tensor_intarrayref(void* self, void* indices) { LANTERN_CHECK_LOADED void* ret = _lantern_dsplit_tensor_intarrayref(self, indices); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_dsplit_tensor_intarrayref)(void* self, void* indices);
  HOST_API void* lantern_Tensor_dsplit_tensor_intarrayref(void* self, void* indices) { void* ret = _lantern_Tensor_dsplit_tensor_intarrayref(self, indices); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_squeeze_tensor)(void* self);
  HOST_API void* lantern_squeeze_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_squeeze_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_squeeze_tensor)(void* self);
  HOST_API void* lantern_Tensor_squeeze_tensor(void* self) { void* ret = _lantern_Tensor_squeeze_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_squeeze_tensor_intt)(void* self, void* dim);
  HOST_API void* lantern_squeeze_tensor_intt(void* self, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_squeeze_tensor_intt(self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_squeeze_tensor_intt)(void* self, void* dim);
  HOST_API void* lantern_Tensor_squeeze_tensor_intt(void* self, void* dim) { void* ret = _lantern_Tensor_squeeze_tensor_intt(self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_squeeze_tensor_dimname)(void* self, void* dim);
  HOST_API void* lantern_squeeze_tensor_dimname(void* self, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_squeeze_tensor_dimname(self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_squeeze_tensor_dimname)(void* self, void* dim);
  HOST_API void* lantern_Tensor_squeeze_tensor_dimname(void* self, void* dim) { void* ret = _lantern_Tensor_squeeze_tensor_dimname(self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_squeeze__tensor)(void* self);
  HOST_API void* lantern_Tensor_squeeze__tensor(void* self) { void* ret = _lantern_Tensor_squeeze__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_squeeze__tensor_intt)(void* self, void* dim);
  HOST_API void* lantern_Tensor_squeeze__tensor_intt(void* self, void* dim) { void* ret = _lantern_Tensor_squeeze__tensor_intt(self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_squeeze__tensor_dimname)(void* self, void* dim);
  HOST_API void* lantern_Tensor_squeeze__tensor_dimname(void* self, void* dim) { void* ret = _lantern_Tensor_squeeze__tensor_dimname(self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sspaddmm_tensor_tensor_tensor_scalar_scalar)(void* self, void* mat1, void* mat2, void* beta, void* alpha);
  HOST_API void* lantern_sspaddmm_tensor_tensor_tensor_scalar_scalar(void* self, void* mat1, void* mat2, void* beta, void* alpha) { LANTERN_CHECK_LOADED void* ret = _lantern_sspaddmm_tensor_tensor_tensor_scalar_scalar(self, mat1, mat2, beta, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_sspaddmm_tensor_tensor_tensor_scalar_scalar)(void* self, void* mat1, void* mat2, void* beta, void* alpha);
  HOST_API void* lantern_Tensor_sspaddmm_tensor_tensor_tensor_scalar_scalar(void* self, void* mat1, void* mat2, void* beta, void* alpha) { void* ret = _lantern_Tensor_sspaddmm_tensor_tensor_tensor_scalar_scalar(self, mat1, mat2, beta, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sspaddmm_out_tensor_tensor_tensor_tensor_scalar_scalar)(void* out, void* self, void* mat1, void* mat2, void* beta, void* alpha);
  HOST_API void* lantern_sspaddmm_out_tensor_tensor_tensor_tensor_scalar_scalar(void* out, void* self, void* mat1, void* mat2, void* beta, void* alpha) { LANTERN_CHECK_LOADED void* ret = _lantern_sspaddmm_out_tensor_tensor_tensor_tensor_scalar_scalar(out, self, mat1, mat2, beta, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_stack_tensorlist_intt)(void* tensors, void* dim);
  HOST_API void* lantern_stack_tensorlist_intt(void* tensors, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_stack_tensorlist_intt(tensors, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_stack_out_tensor_tensorlist_intt)(void* out, void* tensors, void* dim);
  HOST_API void* lantern_stack_out_tensor_tensorlist_intt(void* out, void* tensors, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_stack_out_tensor_tensorlist_intt(out, tensors, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__stack_tensorlist_intt)(void* tensors, void* dim);
  HOST_API void* lantern__stack_tensorlist_intt(void* tensors, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern__stack_tensorlist_intt(tensors, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__stack_out_tensor_tensorlist_intt)(void* out, void* tensors, void* dim);
  HOST_API void* lantern__stack_out_tensor_tensorlist_intt(void* out, void* tensors, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern__stack_out_tensor_tensorlist_intt(out, tensors, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_hstack_tensorlist)(void* tensors);
  HOST_API void* lantern_hstack_tensorlist(void* tensors) { LANTERN_CHECK_LOADED void* ret = _lantern_hstack_tensorlist(tensors); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_hstack_out_tensor_tensorlist)(void* out, void* tensors);
  HOST_API void* lantern_hstack_out_tensor_tensorlist(void* out, void* tensors) { LANTERN_CHECK_LOADED void* ret = _lantern_hstack_out_tensor_tensorlist(out, tensors); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_vstack_tensorlist)(void* tensors);
  HOST_API void* lantern_vstack_tensorlist(void* tensors) { LANTERN_CHECK_LOADED void* ret = _lantern_vstack_tensorlist(tensors); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_vstack_out_tensor_tensorlist)(void* out, void* tensors);
  HOST_API void* lantern_vstack_out_tensor_tensorlist(void* out, void* tensors) { LANTERN_CHECK_LOADED void* ret = _lantern_vstack_out_tensor_tensorlist(out, tensors); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_dstack_tensorlist)(void* tensors);
  HOST_API void* lantern_dstack_tensorlist(void* tensors) { LANTERN_CHECK_LOADED void* ret = _lantern_dstack_tensorlist(tensors); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_dstack_out_tensor_tensorlist)(void* out, void* tensors);
  HOST_API void* lantern_dstack_out_tensor_tensorlist(void* out, void* tensors) { LANTERN_CHECK_LOADED void* ret = _lantern_dstack_out_tensor_tensorlist(out, tensors); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_stft_tensor_intt_intt_intt_tensor_bool_bool_bool)(void* self, void* n_fft, void* hop_length, void* win_length, void* window, void* normalized, void* onesided, void* return_complex);
  HOST_API void* lantern_stft_tensor_intt_intt_intt_tensor_bool_bool_bool(void* self, void* n_fft, void* hop_length, void* win_length, void* window, void* normalized, void* onesided, void* return_complex) { LANTERN_CHECK_LOADED void* ret = _lantern_stft_tensor_intt_intt_intt_tensor_bool_bool_bool(self, n_fft, hop_length, win_length, window, normalized, onesided, return_complex); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_stft_tensor_intt_intt_intt_tensor_bool_bool_bool)(void* self, void* n_fft, void* hop_length, void* win_length, void* window, void* normalized, void* onesided, void* return_complex);
  HOST_API void* lantern_Tensor_stft_tensor_intt_intt_intt_tensor_bool_bool_bool(void* self, void* n_fft, void* hop_length, void* win_length, void* window, void* normalized, void* onesided, void* return_complex) { void* ret = _lantern_Tensor_stft_tensor_intt_intt_intt_tensor_bool_bool_bool(self, n_fft, hop_length, win_length, window, normalized, onesided, return_complex); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_stft_tensor_intt_intt_intt_tensor_bool_cstringview_bool_bool_bool)(void* self, void* n_fft, void* hop_length, void* win_length, void* window, void* center, void* pad_mode, void* normalized, void* onesided, void* return_complex);
  HOST_API void* lantern_stft_tensor_intt_intt_intt_tensor_bool_cstringview_bool_bool_bool(void* self, void* n_fft, void* hop_length, void* win_length, void* window, void* center, void* pad_mode, void* normalized, void* onesided, void* return_complex) { LANTERN_CHECK_LOADED void* ret = _lantern_stft_tensor_intt_intt_intt_tensor_bool_cstringview_bool_bool_bool(self, n_fft, hop_length, win_length, window, center, pad_mode, normalized, onesided, return_complex); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_stft_tensor_intt_intt_intt_tensor_bool_cstringview_bool_bool_bool)(void* self, void* n_fft, void* hop_length, void* win_length, void* window, void* center, void* pad_mode, void* normalized, void* onesided, void* return_complex);
  HOST_API void* lantern_Tensor_stft_tensor_intt_intt_intt_tensor_bool_cstringview_bool_bool_bool(void* self, void* n_fft, void* hop_length, void* win_length, void* window, void* center, void* pad_mode, void* normalized, void* onesided, void* return_complex) { void* ret = _lantern_Tensor_stft_tensor_intt_intt_intt_tensor_bool_cstringview_bool_bool_bool(self, n_fft, hop_length, win_length, window, center, pad_mode, normalized, onesided, return_complex); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_istft_tensor_intt_intt_intt_tensor_bool_bool_bool_intt_bool)(void* self, void* n_fft, void* hop_length, void* win_length, void* window, void* center, void* normalized, void* onesided, void* length, void* return_complex);
  HOST_API void* lantern_istft_tensor_intt_intt_intt_tensor_bool_bool_bool_intt_bool(void* self, void* n_fft, void* hop_length, void* win_length, void* window, void* center, void* normalized, void* onesided, void* length, void* return_complex) { LANTERN_CHECK_LOADED void* ret = _lantern_istft_tensor_intt_intt_intt_tensor_bool_bool_bool_intt_bool(self, n_fft, hop_length, win_length, window, center, normalized, onesided, length, return_complex); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_istft_tensor_intt_intt_intt_tensor_bool_bool_bool_intt_bool)(void* self, void* n_fft, void* hop_length, void* win_length, void* window, void* center, void* normalized, void* onesided, void* length, void* return_complex);
  HOST_API void* lantern_Tensor_istft_tensor_intt_intt_intt_tensor_bool_bool_bool_intt_bool(void* self, void* n_fft, void* hop_length, void* win_length, void* window, void* center, void* normalized, void* onesided, void* length, void* return_complex) { void* ret = _lantern_Tensor_istft_tensor_intt_intt_intt_tensor_bool_bool_bool_intt_bool(self, n_fft, hop_length, win_length, window, center, normalized, onesided, length, return_complex); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_stride_tensor_intt)(void* self, void* dim);
  HOST_API void* lantern_stride_tensor_intt(void* self, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_stride_tensor_intt(self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_stride_tensor_intt)(void* self, void* dim);
  HOST_API void* lantern_Tensor_stride_tensor_intt(void* self, void* dim) { void* ret = _lantern_Tensor_stride_tensor_intt(self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_stride_tensor_dimname)(void* self, void* dim);
  HOST_API void* lantern_stride_tensor_dimname(void* self, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_stride_tensor_dimname(self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_stride_tensor_dimname)(void* self, void* dim);
  HOST_API void* lantern_Tensor_stride_tensor_dimname(void* self, void* dim) { void* ret = _lantern_Tensor_stride_tensor_dimname(self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sum_tensor_scalartype)(void* self, void* dtype);
  HOST_API void* lantern_sum_tensor_scalartype(void* self, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern_sum_tensor_scalartype(self, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_sum_tensor_scalartype)(void* self, void* dtype);
  HOST_API void* lantern_Tensor_sum_tensor_scalartype(void* self, void* dtype) { void* ret = _lantern_Tensor_sum_tensor_scalartype(self, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sum_tensor_intarrayref_bool_scalartype)(void* self, void* dim, void* keepdim, void* dtype);
  HOST_API void* lantern_sum_tensor_intarrayref_bool_scalartype(void* self, void* dim, void* keepdim, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern_sum_tensor_intarrayref_bool_scalartype(self, dim, keepdim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_sum_tensor_intarrayref_bool_scalartype)(void* self, void* dim, void* keepdim, void* dtype);
  HOST_API void* lantern_Tensor_sum_tensor_intarrayref_bool_scalartype(void* self, void* dim, void* keepdim, void* dtype) { void* ret = _lantern_Tensor_sum_tensor_intarrayref_bool_scalartype(self, dim, keepdim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sum_tensor_dimnamelist_bool_scalartype)(void* self, void* dim, void* keepdim, void* dtype);
  HOST_API void* lantern_sum_tensor_dimnamelist_bool_scalartype(void* self, void* dim, void* keepdim, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern_sum_tensor_dimnamelist_bool_scalartype(self, dim, keepdim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_sum_tensor_dimnamelist_bool_scalartype)(void* self, void* dim, void* keepdim, void* dtype);
  HOST_API void* lantern_Tensor_sum_tensor_dimnamelist_bool_scalartype(void* self, void* dim, void* keepdim, void* dtype) { void* ret = _lantern_Tensor_sum_tensor_dimnamelist_bool_scalartype(self, dim, keepdim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sum_out_tensor_tensor_intarrayref_bool_scalartype)(void* out, void* self, void* dim, void* keepdim, void* dtype);
  HOST_API void* lantern_sum_out_tensor_tensor_intarrayref_bool_scalartype(void* out, void* self, void* dim, void* keepdim, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern_sum_out_tensor_tensor_intarrayref_bool_scalartype(out, self, dim, keepdim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sum_out_tensor_tensor_dimnamelist_bool_scalartype)(void* out, void* self, void* dim, void* keepdim, void* dtype);
  HOST_API void* lantern_sum_out_tensor_tensor_dimnamelist_bool_scalartype(void* out, void* self, void* dim, void* keepdim, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern_sum_out_tensor_tensor_dimnamelist_bool_scalartype(out, self, dim, keepdim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__nested_sum_backward_tensor_tensor_intarrayref_bool)(void* grad, void* self, void* dim, void* keepdim);
  HOST_API void* lantern__nested_sum_backward_tensor_tensor_intarrayref_bool(void* grad, void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern__nested_sum_backward_tensor_tensor_intarrayref_bool(grad, self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_nansum_tensor_intarrayref_bool_scalartype)(void* self, void* dim, void* keepdim, void* dtype);
  HOST_API void* lantern_nansum_tensor_intarrayref_bool_scalartype(void* self, void* dim, void* keepdim, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern_nansum_tensor_intarrayref_bool_scalartype(self, dim, keepdim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_nansum_tensor_intarrayref_bool_scalartype)(void* self, void* dim, void* keepdim, void* dtype);
  HOST_API void* lantern_Tensor_nansum_tensor_intarrayref_bool_scalartype(void* self, void* dim, void* keepdim, void* dtype) { void* ret = _lantern_Tensor_nansum_tensor_intarrayref_bool_scalartype(self, dim, keepdim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_nansum_out_tensor_tensor_intarrayref_bool_scalartype)(void* out, void* self, void* dim, void* keepdim, void* dtype);
  HOST_API void* lantern_nansum_out_tensor_tensor_intarrayref_bool_scalartype(void* out, void* self, void* dim, void* keepdim, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern_nansum_out_tensor_tensor_intarrayref_bool_scalartype(out, self, dim, keepdim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_sum_to_size_tensor_intarrayref)(void* self, void* size);
  HOST_API void* lantern_Tensor_sum_to_size_tensor_intarrayref(void* self, void* size) { void* ret = _lantern_Tensor_sum_to_size_tensor_intarrayref(self, size); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sqrt_tensor)(void* self);
  HOST_API void* lantern_sqrt_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_sqrt_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_sqrt_tensor)(void* self);
  HOST_API void* lantern_Tensor_sqrt_tensor(void* self) { void* ret = _lantern_Tensor_sqrt_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sqrt__tensor)(void* self);
  HOST_API void* lantern_sqrt__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_sqrt__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_sqrt__tensor)(void* self);
  HOST_API void* lantern_Tensor_sqrt__tensor(void* self) { void* ret = _lantern_Tensor_sqrt__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sqrt_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_sqrt_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_sqrt_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_square_tensor)(void* self);
  HOST_API void* lantern_square_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_square_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_square_tensor)(void* self);
  HOST_API void* lantern_Tensor_square_tensor(void* self) { void* ret = _lantern_Tensor_square_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_square__tensor)(void* self);
  HOST_API void* lantern_square__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_square__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_square__tensor)(void* self);
  HOST_API void* lantern_Tensor_square__tensor(void* self) { void* ret = _lantern_Tensor_square__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_square_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_square_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_square_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_std_tensor_bool)(void* self, void* unbiased);
  HOST_API void* lantern_std_tensor_bool(void* self, void* unbiased) { LANTERN_CHECK_LOADED void* ret = _lantern_std_tensor_bool(self, unbiased); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_std_tensor_bool)(void* self, void* unbiased);
  HOST_API void* lantern_Tensor_std_tensor_bool(void* self, void* unbiased) { void* ret = _lantern_Tensor_std_tensor_bool(self, unbiased); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_std_tensor_intarrayref_bool_bool)(void* self, void* dim, void* unbiased, void* keepdim);
  HOST_API void* lantern_std_tensor_intarrayref_bool_bool(void* self, void* dim, void* unbiased, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_std_tensor_intarrayref_bool_bool(self, dim, unbiased, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_std_tensor_intarrayref_bool_bool)(void* self, void* dim, void* unbiased, void* keepdim);
  HOST_API void* lantern_Tensor_std_tensor_intarrayref_bool_bool(void* self, void* dim, void* unbiased, void* keepdim) { void* ret = _lantern_Tensor_std_tensor_intarrayref_bool_bool(self, dim, unbiased, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_std_tensor_intarrayref_intt_bool)(void* self, void* dim, void* correction, void* keepdim);
  HOST_API void* lantern_std_tensor_intarrayref_intt_bool(void* self, void* dim, void* correction, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_std_tensor_intarrayref_intt_bool(self, dim, correction, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_std_tensor_intarrayref_intt_bool)(void* self, void* dim, void* correction, void* keepdim);
  HOST_API void* lantern_Tensor_std_tensor_intarrayref_intt_bool(void* self, void* dim, void* correction, void* keepdim) { void* ret = _lantern_Tensor_std_tensor_intarrayref_intt_bool(self, dim, correction, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_std_mean_tensor_bool)(void* self, void* unbiased);
  HOST_API void* lantern_std_mean_tensor_bool(void* self, void* unbiased) { LANTERN_CHECK_LOADED void* ret = _lantern_std_mean_tensor_bool(self, unbiased); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_std_mean_tensor_intarrayref_bool_bool)(void* self, void* dim, void* unbiased, void* keepdim);
  HOST_API void* lantern_std_mean_tensor_intarrayref_bool_bool(void* self, void* dim, void* unbiased, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_std_mean_tensor_intarrayref_bool_bool(self, dim, unbiased, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_std_mean_tensor_intarrayref_intt_bool)(void* self, void* dim, void* correction, void* keepdim);
  HOST_API void* lantern_std_mean_tensor_intarrayref_intt_bool(void* self, void* dim, void* correction, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_std_mean_tensor_intarrayref_intt_bool(self, dim, correction, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_std_mean_tensor_dimnamelist_bool_bool)(void* self, void* dim, void* unbiased, void* keepdim);
  HOST_API void* lantern_std_mean_tensor_dimnamelist_bool_bool(void* self, void* dim, void* unbiased, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_std_mean_tensor_dimnamelist_bool_bool(self, dim, unbiased, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_std_mean_tensor_dimnamelist_intt_bool)(void* self, void* dim, void* correction, void* keepdim);
  HOST_API void* lantern_std_mean_tensor_dimnamelist_intt_bool(void* self, void* dim, void* correction, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_std_mean_tensor_dimnamelist_intt_bool(self, dim, correction, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_std_out_tensor_tensor_intarrayref_bool_bool)(void* out, void* self, void* dim, void* unbiased, void* keepdim);
  HOST_API void* lantern_std_out_tensor_tensor_intarrayref_bool_bool(void* out, void* self, void* dim, void* unbiased, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_std_out_tensor_tensor_intarrayref_bool_bool(out, self, dim, unbiased, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_std_out_tensor_tensor_intarrayref_intt_bool)(void* out, void* self, void* dim, void* correction, void* keepdim);
  HOST_API void* lantern_std_out_tensor_tensor_intarrayref_intt_bool(void* out, void* self, void* dim, void* correction, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_std_out_tensor_tensor_intarrayref_intt_bool(out, self, dim, correction, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_std_tensor_dimnamelist_bool_bool)(void* self, void* dim, void* unbiased, void* keepdim);
  HOST_API void* lantern_std_tensor_dimnamelist_bool_bool(void* self, void* dim, void* unbiased, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_std_tensor_dimnamelist_bool_bool(self, dim, unbiased, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_std_tensor_dimnamelist_bool_bool)(void* self, void* dim, void* unbiased, void* keepdim);
  HOST_API void* lantern_Tensor_std_tensor_dimnamelist_bool_bool(void* self, void* dim, void* unbiased, void* keepdim) { void* ret = _lantern_Tensor_std_tensor_dimnamelist_bool_bool(self, dim, unbiased, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_std_out_tensor_tensor_dimnamelist_bool_bool)(void* out, void* self, void* dim, void* unbiased, void* keepdim);
  HOST_API void* lantern_std_out_tensor_tensor_dimnamelist_bool_bool(void* out, void* self, void* dim, void* unbiased, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_std_out_tensor_tensor_dimnamelist_bool_bool(out, self, dim, unbiased, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_std_tensor_dimnamelist_intt_bool)(void* self, void* dim, void* correction, void* keepdim);
  HOST_API void* lantern_std_tensor_dimnamelist_intt_bool(void* self, void* dim, void* correction, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_std_tensor_dimnamelist_intt_bool(self, dim, correction, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_std_tensor_dimnamelist_intt_bool)(void* self, void* dim, void* correction, void* keepdim);
  HOST_API void* lantern_Tensor_std_tensor_dimnamelist_intt_bool(void* self, void* dim, void* correction, void* keepdim) { void* ret = _lantern_Tensor_std_tensor_dimnamelist_intt_bool(self, dim, correction, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_std_out_tensor_tensor_dimnamelist_intt_bool)(void* out, void* self, void* dim, void* correction, void* keepdim);
  HOST_API void* lantern_std_out_tensor_tensor_dimnamelist_intt_bool(void* out, void* self, void* dim, void* correction, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_std_out_tensor_tensor_dimnamelist_intt_bool(out, self, dim, correction, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_prod_tensor_scalartype)(void* self, void* dtype);
  HOST_API void* lantern_prod_tensor_scalartype(void* self, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern_prod_tensor_scalartype(self, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_prod_tensor_scalartype)(void* self, void* dtype);
  HOST_API void* lantern_Tensor_prod_tensor_scalartype(void* self, void* dtype) { void* ret = _lantern_Tensor_prod_tensor_scalartype(self, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_prod_tensor_intt_bool_scalartype)(void* self, void* dim, void* keepdim, void* dtype);
  HOST_API void* lantern_prod_tensor_intt_bool_scalartype(void* self, void* dim, void* keepdim, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern_prod_tensor_intt_bool_scalartype(self, dim, keepdim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_prod_tensor_intt_bool_scalartype)(void* self, void* dim, void* keepdim, void* dtype);
  HOST_API void* lantern_Tensor_prod_tensor_intt_bool_scalartype(void* self, void* dim, void* keepdim, void* dtype) { void* ret = _lantern_Tensor_prod_tensor_intt_bool_scalartype(self, dim, keepdim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_prod_out_tensor_tensor_intt_bool_scalartype)(void* out, void* self, void* dim, void* keepdim, void* dtype);
  HOST_API void* lantern_prod_out_tensor_tensor_intt_bool_scalartype(void* out, void* self, void* dim, void* keepdim, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern_prod_out_tensor_tensor_intt_bool_scalartype(out, self, dim, keepdim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_prod_tensor_dimname_bool_scalartype)(void* self, void* dim, void* keepdim, void* dtype);
  HOST_API void* lantern_prod_tensor_dimname_bool_scalartype(void* self, void* dim, void* keepdim, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern_prod_tensor_dimname_bool_scalartype(self, dim, keepdim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_prod_tensor_dimname_bool_scalartype)(void* self, void* dim, void* keepdim, void* dtype);
  HOST_API void* lantern_Tensor_prod_tensor_dimname_bool_scalartype(void* self, void* dim, void* keepdim, void* dtype) { void* ret = _lantern_Tensor_prod_tensor_dimname_bool_scalartype(self, dim, keepdim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_prod_out_tensor_tensor_dimname_bool_scalartype)(void* out, void* self, void* dim, void* keepdim, void* dtype);
  HOST_API void* lantern_prod_out_tensor_tensor_dimname_bool_scalartype(void* out, void* self, void* dim, void* keepdim, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern_prod_out_tensor_tensor_dimname_bool_scalartype(out, self, dim, keepdim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_t_tensor)(void* self);
  HOST_API void* lantern_t_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_t_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_t_tensor)(void* self);
  HOST_API void* lantern_Tensor_t_tensor(void* self) { void* ret = _lantern_Tensor_t_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_t__tensor)(void* self);
  HOST_API void* lantern_Tensor_t__tensor(void* self) { void* ret = _lantern_Tensor_t__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_tan_tensor)(void* self);
  HOST_API void* lantern_tan_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_tan_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_tan_tensor)(void* self);
  HOST_API void* lantern_Tensor_tan_tensor(void* self) { void* ret = _lantern_Tensor_tan_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_tan__tensor)(void* self);
  HOST_API void* lantern_tan__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_tan__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_tan__tensor)(void* self);
  HOST_API void* lantern_Tensor_tan__tensor(void* self) { void* ret = _lantern_Tensor_tan__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_tan_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_tan_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_tan_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_tanh_tensor)(void* self);
  HOST_API void* lantern_tanh_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_tanh_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_tanh_tensor)(void* self);
  HOST_API void* lantern_Tensor_tanh_tensor(void* self) { void* ret = _lantern_Tensor_tanh_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_tanh__tensor)(void* self);
  HOST_API void* lantern_tanh__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_tanh__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_tanh__tensor)(void* self);
  HOST_API void* lantern_Tensor_tanh__tensor(void* self) { void* ret = _lantern_Tensor_tanh__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_tanh_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_tanh_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_tanh_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_tensordot_tensor_tensor_intarrayref_intarrayref)(void* self, void* other, void* dims_self, void* dims_other);
  HOST_API void* lantern_tensordot_tensor_tensor_intarrayref_intarrayref(void* self, void* other, void* dims_self, void* dims_other) { LANTERN_CHECK_LOADED void* ret = _lantern_tensordot_tensor_tensor_intarrayref_intarrayref(self, other, dims_self, dims_other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_tensordot_out_tensor_tensor_tensor_intarrayref_intarrayref)(void* out, void* self, void* other, void* dims_self, void* dims_other);
  HOST_API void* lantern_tensordot_out_tensor_tensor_tensor_intarrayref_intarrayref(void* out, void* self, void* other, void* dims_self, void* dims_other) { LANTERN_CHECK_LOADED void* ret = _lantern_tensordot_out_tensor_tensor_tensor_intarrayref_intarrayref(out, self, other, dims_self, dims_other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_threshold_tensor_scalar_scalar)(void* self, void* threshold, void* value);
  HOST_API void* lantern_threshold_tensor_scalar_scalar(void* self, void* threshold, void* value) { LANTERN_CHECK_LOADED void* ret = _lantern_threshold_tensor_scalar_scalar(self, threshold, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_threshold__tensor_scalar_scalar)(void* self, void* threshold, void* value);
  HOST_API void* lantern_threshold__tensor_scalar_scalar(void* self, void* threshold, void* value) { LANTERN_CHECK_LOADED void* ret = _lantern_threshold__tensor_scalar_scalar(self, threshold, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_threshold_out_tensor_tensor_scalar_scalar)(void* out, void* self, void* threshold, void* value);
  HOST_API void* lantern_threshold_out_tensor_tensor_scalar_scalar(void* out, void* self, void* threshold, void* value) { LANTERN_CHECK_LOADED void* ret = _lantern_threshold_out_tensor_tensor_scalar_scalar(out, self, threshold, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_threshold_backward_out_tensor_tensor_tensor_scalar)(void* grad_input, void* grad_output, void* self, void* threshold);
  HOST_API void* lantern_threshold_backward_out_tensor_tensor_tensor_scalar(void* grad_input, void* grad_output, void* self, void* threshold) { LANTERN_CHECK_LOADED void* ret = _lantern_threshold_backward_out_tensor_tensor_tensor_scalar(grad_input, grad_output, self, threshold); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_threshold_backward_tensor_tensor_scalar)(void* grad_output, void* self, void* threshold);
  HOST_API void* lantern_threshold_backward_tensor_tensor_scalar(void* grad_output, void* self, void* threshold) { LANTERN_CHECK_LOADED void* ret = _lantern_threshold_backward_tensor_tensor_scalar(grad_output, self, threshold); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_tile_tensor_intarrayref)(void* self, void* dims);
  HOST_API void* lantern_tile_tensor_intarrayref(void* self, void* dims) { LANTERN_CHECK_LOADED void* ret = _lantern_tile_tensor_intarrayref(self, dims); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_tile_tensor_intarrayref)(void* self, void* dims);
  HOST_API void* lantern_Tensor_tile_tensor_intarrayref(void* self, void* dims) { void* ret = _lantern_Tensor_tile_tensor_intarrayref(self, dims); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_transpose_tensor_intt_intt)(void* self, void* dim0, void* dim1);
  HOST_API void* lantern_transpose_tensor_intt_intt(void* self, void* dim0, void* dim1) { LANTERN_CHECK_LOADED void* ret = _lantern_transpose_tensor_intt_intt(self, dim0, dim1); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_transpose_tensor_intt_intt)(void* self, void* dim0, void* dim1);
  HOST_API void* lantern_Tensor_transpose_tensor_intt_intt(void* self, void* dim0, void* dim1) { void* ret = _lantern_Tensor_transpose_tensor_intt_intt(self, dim0, dim1); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_transpose_tensor_dimname_dimname)(void* self, void* dim0, void* dim1);
  HOST_API void* lantern_transpose_tensor_dimname_dimname(void* self, void* dim0, void* dim1) { LANTERN_CHECK_LOADED void* ret = _lantern_transpose_tensor_dimname_dimname(self, dim0, dim1); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_transpose_tensor_dimname_dimname)(void* self, void* dim0, void* dim1);
  HOST_API void* lantern_Tensor_transpose_tensor_dimname_dimname(void* self, void* dim0, void* dim1) { void* ret = _lantern_Tensor_transpose_tensor_dimname_dimname(self, dim0, dim1); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__mkldnn_transpose_tensor_intt_intt)(void* self, void* dim0, void* dim1);
  HOST_API void* lantern__mkldnn_transpose_tensor_intt_intt(void* self, void* dim0, void* dim1) { LANTERN_CHECK_LOADED void* ret = _lantern__mkldnn_transpose_tensor_intt_intt(self, dim0, dim1); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_transpose__tensor_intt_intt)(void* self, void* dim0, void* dim1);
  HOST_API void* lantern_Tensor_transpose__tensor_intt_intt(void* self, void* dim0, void* dim1) { void* ret = _lantern_Tensor_transpose__tensor_intt_intt(self, dim0, dim1); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__mkldnn_transpose__tensor_intt_intt)(void* self, void* dim0, void* dim1);
  HOST_API void* lantern__mkldnn_transpose__tensor_intt_intt(void* self, void* dim0, void* dim1) { LANTERN_CHECK_LOADED void* ret = _lantern__mkldnn_transpose__tensor_intt_intt(self, dim0, dim1); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_one_hot_tensor_intt)(void* self, void* num_classes);
  HOST_API void* lantern_one_hot_tensor_intt(void* self, void* num_classes) { LANTERN_CHECK_LOADED void* ret = _lantern_one_hot_tensor_intt(self, num_classes); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_flip_tensor_intarrayref)(void* self, void* dims);
  HOST_API void* lantern_flip_tensor_intarrayref(void* self, void* dims) { LANTERN_CHECK_LOADED void* ret = _lantern_flip_tensor_intarrayref(self, dims); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_flip_tensor_intarrayref)(void* self, void* dims);
  HOST_API void* lantern_Tensor_flip_tensor_intarrayref(void* self, void* dims) { void* ret = _lantern_Tensor_flip_tensor_intarrayref(self, dims); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_fliplr_tensor)(void* self);
  HOST_API void* lantern_fliplr_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_fliplr_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_fliplr_tensor)(void* self);
  HOST_API void* lantern_Tensor_fliplr_tensor(void* self) { void* ret = _lantern_Tensor_fliplr_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_flipud_tensor)(void* self);
  HOST_API void* lantern_flipud_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_flipud_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_flipud_tensor)(void* self);
  HOST_API void* lantern_Tensor_flipud_tensor(void* self) { void* ret = _lantern_Tensor_flipud_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_roll_tensor_intarrayref_intarrayref)(void* self, void* shifts, void* dims);
  HOST_API void* lantern_roll_tensor_intarrayref_intarrayref(void* self, void* shifts, void* dims) { LANTERN_CHECK_LOADED void* ret = _lantern_roll_tensor_intarrayref_intarrayref(self, shifts, dims); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_roll_tensor_intarrayref_intarrayref)(void* self, void* shifts, void* dims);
  HOST_API void* lantern_Tensor_roll_tensor_intarrayref_intarrayref(void* self, void* shifts, void* dims) { void* ret = _lantern_Tensor_roll_tensor_intarrayref_intarrayref(self, shifts, dims); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_rot90_tensor_intt_intarrayref)(void* self, void* k, void* dims);
  HOST_API void* lantern_rot90_tensor_intt_intarrayref(void* self, void* k, void* dims) { LANTERN_CHECK_LOADED void* ret = _lantern_rot90_tensor_intt_intarrayref(self, k, dims); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_rot90_tensor_intt_intarrayref)(void* self, void* k, void* dims);
  HOST_API void* lantern_Tensor_rot90_tensor_intt_intarrayref(void* self, void* k, void* dims) { void* ret = _lantern_Tensor_rot90_tensor_intt_intarrayref(self, k, dims); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_trapezoid_tensor_tensor_intt)(void* y, void* x, void* dim);
  HOST_API void* lantern_trapezoid_tensor_tensor_intt(void* y, void* x, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_trapezoid_tensor_tensor_intt(y, x, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_trapezoid_tensor_scalar_intt)(void* y, void* dx, void* dim);
  HOST_API void* lantern_trapezoid_tensor_scalar_intt(void* y, void* dx, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_trapezoid_tensor_scalar_intt(y, dx, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_trapz_tensor_tensor_intt)(void* y, void* x, void* dim);
  HOST_API void* lantern_trapz_tensor_tensor_intt(void* y, void* x, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_trapz_tensor_tensor_intt(y, x, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_trapz_tensor_double_intt)(void* y, void* dx, void* dim);
  HOST_API void* lantern_trapz_tensor_double_intt(void* y, void* dx, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_trapz_tensor_double_intt(y, dx, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__transform_bias_rescale_qkv_tensor_tensor_intt)(void* qkv, void* qkv_bias, void* num_heads);
  HOST_API void* lantern__transform_bias_rescale_qkv_tensor_tensor_intt(void* qkv, void* qkv_bias, void* num_heads) { LANTERN_CHECK_LOADED void* ret = _lantern__transform_bias_rescale_qkv_tensor_tensor_intt(qkv, qkv_bias, num_heads); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__nested_tensor_from_mask_tensor_tensor_bool)(void* t, void* mask, void* mask_check);
  HOST_API void* lantern__nested_tensor_from_mask_tensor_tensor_bool(void* t, void* mask, void* mask_check) { LANTERN_CHECK_LOADED void* ret = _lantern__nested_tensor_from_mask_tensor_tensor_bool(t, mask, mask_check); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__nested_tensor_from_mask_left_aligned_tensor_tensor)(void* t, void* mask);
  HOST_API void* lantern__nested_tensor_from_mask_left_aligned_tensor_tensor(void* t, void* mask) { LANTERN_CHECK_LOADED void* ret = _lantern__nested_tensor_from_mask_left_aligned_tensor_tensor(t, mask); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__nested_from_padded_tensor_tensor_bool)(void* padded, void* cpu_nested_shape_example, void* fuse_transform_0213);
  HOST_API void* lantern__nested_from_padded_tensor_tensor_bool(void* padded, void* cpu_nested_shape_example, void* fuse_transform_0213) { LANTERN_CHECK_LOADED void* ret = _lantern__nested_from_padded_tensor_tensor_bool(padded, cpu_nested_shape_example, fuse_transform_0213); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor__nested_tensor_size_tensor)(void* self);
  HOST_API void* lantern_Tensor__nested_tensor_size_tensor(void* self) { void* ret = _lantern_Tensor__nested_tensor_size_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor__nested_tensor_strides_tensor)(void* self);
  HOST_API void* lantern_Tensor__nested_tensor_strides_tensor(void* self) { void* ret = _lantern_Tensor__nested_tensor_strides_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor__nested_tensor_offsets_tensor)(void* self);
  HOST_API void* lantern_Tensor__nested_tensor_offsets_tensor(void* self) { void* ret = _lantern_Tensor__nested_tensor_offsets_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__nested_from_padded_and_nested_example_tensor_tensor)(void* padded, void* nt_example);
  HOST_API void* lantern__nested_from_padded_and_nested_example_tensor_tensor(void* padded, void* nt_example) { LANTERN_CHECK_LOADED void* ret = _lantern__nested_from_padded_and_nested_example_tensor_tensor(padded, nt_example); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__nested_view_from_buffer_tensor_tensor_tensor_intarrayref)(void* self, void* nested_size, void* nested_strides, void* offsets);
  HOST_API void* lantern__nested_view_from_buffer_tensor_tensor_tensor_intarrayref(void* self, void* nested_size, void* nested_strides, void* offsets) { LANTERN_CHECK_LOADED void* ret = _lantern__nested_view_from_buffer_tensor_tensor_tensor_intarrayref(self, nested_size, nested_strides, offsets); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__nested_view_from_buffer_copy_tensor_tensor_tensor_intarrayref)(void* self, void* nested_size, void* nested_strides, void* offsets);
  HOST_API void* lantern__nested_view_from_buffer_copy_tensor_tensor_tensor_intarrayref(void* self, void* nested_size, void* nested_strides, void* offsets) { LANTERN_CHECK_LOADED void* ret = _lantern__nested_view_from_buffer_copy_tensor_tensor_tensor_intarrayref(self, nested_size, nested_strides, offsets); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__trilinear_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_intt)(void* i1, void* i2, void* i3, void* expand1, void* expand2, void* expand3, void* sumdim, void* unroll_dim);
  HOST_API void* lantern__trilinear_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_intt(void* i1, void* i2, void* i3, void* expand1, void* expand2, void* expand3, void* sumdim, void* unroll_dim) { LANTERN_CHECK_LOADED void* ret = _lantern__trilinear_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_intt(i1, i2, i3, expand1, expand2, expand3, sumdim, unroll_dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_triplet_margin_loss_tensor_tensor_tensor_double_double_double_bool_intt)(void* anchor, void* positive, void* negative, void* margin, void* p, void* eps, void* swap, void* reduction);
  HOST_API void* lantern_triplet_margin_loss_tensor_tensor_tensor_double_double_double_bool_intt(void* anchor, void* positive, void* negative, void* margin, void* p, void* eps, void* swap, void* reduction) { LANTERN_CHECK_LOADED void* ret = _lantern_triplet_margin_loss_tensor_tensor_tensor_double_double_double_bool_intt(anchor, positive, negative, margin, p, eps, swap, reduction); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_trunc_tensor)(void* self);
  HOST_API void* lantern_trunc_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_trunc_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_trunc_tensor)(void* self);
  HOST_API void* lantern_Tensor_trunc_tensor(void* self) { void* ret = _lantern_Tensor_trunc_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_trunc__tensor)(void* self);
  HOST_API void* lantern_trunc__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_trunc__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_trunc__tensor)(void* self);
  HOST_API void* lantern_Tensor_trunc__tensor(void* self) { void* ret = _lantern_Tensor_trunc__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_trunc_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_trunc_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_trunc_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_fix_tensor)(void* self);
  HOST_API void* lantern_fix_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_fix_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_fix_tensor)(void* self);
  HOST_API void* lantern_Tensor_fix_tensor(void* self) { void* ret = _lantern_Tensor_fix_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_fix__tensor)(void* self);
  HOST_API void* lantern_fix__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_fix__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_fix__tensor)(void* self);
  HOST_API void* lantern_Tensor_fix__tensor(void* self) { void* ret = _lantern_Tensor_fix__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_fix_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_fix_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_fix_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_type_as_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_type_as_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_type_as_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__has_compatible_shallow_copy_type_tensor_tensor)(void* self, void* from);
  HOST_API void* lantern__has_compatible_shallow_copy_type_tensor_tensor(void* self, void* from) { LANTERN_CHECK_LOADED void* ret = _lantern__has_compatible_shallow_copy_type_tensor_tensor(self, from); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__unique_tensor_bool_bool)(void* self, void* sorted, void* return_inverse);
  HOST_API void* lantern__unique_tensor_bool_bool(void* self, void* sorted, void* return_inverse) { LANTERN_CHECK_LOADED void* ret = _lantern__unique_tensor_bool_bool(self, sorted, return_inverse); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_unique_dim_tensor_intt_bool_bool_bool)(void* self, void* dim, void* sorted, void* return_inverse, void* return_counts);
  HOST_API void* lantern_unique_dim_tensor_intt_bool_bool_bool(void* self, void* dim, void* sorted, void* return_inverse, void* return_counts) { LANTERN_CHECK_LOADED void* ret = _lantern_unique_dim_tensor_intt_bool_bool_bool(self, dim, sorted, return_inverse, return_counts); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_unique_consecutive_tensor_bool_bool_intt)(void* self, void* return_inverse, void* return_counts, void* dim);
  HOST_API void* lantern_unique_consecutive_tensor_bool_bool_intt(void* self, void* return_inverse, void* return_counts, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_unique_consecutive_tensor_bool_bool_intt(self, return_inverse, return_counts, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_unique_dim_consecutive_tensor_intt_bool_bool)(void* self, void* dim, void* return_inverse, void* return_counts);
  HOST_API void* lantern_unique_dim_consecutive_tensor_intt_bool_bool(void* self, void* dim, void* return_inverse, void* return_counts) { LANTERN_CHECK_LOADED void* ret = _lantern_unique_dim_consecutive_tensor_intt_bool_bool(self, dim, return_inverse, return_counts); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__unique2_tensor_bool_bool_bool)(void* self, void* sorted, void* return_inverse, void* return_counts);
  HOST_API void* lantern__unique2_tensor_bool_bool_bool(void* self, void* sorted, void* return_inverse, void* return_counts) { LANTERN_CHECK_LOADED void* ret = _lantern__unique2_tensor_bool_bool_bool(self, sorted, return_inverse, return_counts); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__unsafe_view_tensor_intarrayref)(void* self, void* size);
  HOST_API void* lantern__unsafe_view_tensor_intarrayref(void* self, void* size) { LANTERN_CHECK_LOADED void* ret = _lantern__unsafe_view_tensor_intarrayref(self, size); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_unsqueeze_tensor_intt)(void* self, void* dim);
  HOST_API void* lantern_unsqueeze_tensor_intt(void* self, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_unsqueeze_tensor_intt(self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_unsqueeze_tensor_intt)(void* self, void* dim);
  HOST_API void* lantern_Tensor_unsqueeze_tensor_intt(void* self, void* dim) { void* ret = _lantern_Tensor_unsqueeze_tensor_intt(self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_unsqueeze__tensor_intt)(void* self, void* dim);
  HOST_API void* lantern_Tensor_unsqueeze__tensor_intt(void* self, void* dim) { void* ret = _lantern_Tensor_unsqueeze__tensor_intt(self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_vander_tensor_intt_bool)(void* x, void* N, void* increasing);
  HOST_API void* lantern_vander_tensor_intt_bool(void* x, void* N, void* increasing) { LANTERN_CHECK_LOADED void* ret = _lantern_vander_tensor_intt_bool(x, N, increasing); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_var_tensor_bool)(void* self, void* unbiased);
  HOST_API void* lantern_var_tensor_bool(void* self, void* unbiased) { LANTERN_CHECK_LOADED void* ret = _lantern_var_tensor_bool(self, unbiased); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_var_tensor_bool)(void* self, void* unbiased);
  HOST_API void* lantern_Tensor_var_tensor_bool(void* self, void* unbiased) { void* ret = _lantern_Tensor_var_tensor_bool(self, unbiased); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_var_tensor_intarrayref_bool_bool)(void* self, void* dim, void* unbiased, void* keepdim);
  HOST_API void* lantern_var_tensor_intarrayref_bool_bool(void* self, void* dim, void* unbiased, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_var_tensor_intarrayref_bool_bool(self, dim, unbiased, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_var_tensor_intarrayref_bool_bool)(void* self, void* dim, void* unbiased, void* keepdim);
  HOST_API void* lantern_Tensor_var_tensor_intarrayref_bool_bool(void* self, void* dim, void* unbiased, void* keepdim) { void* ret = _lantern_Tensor_var_tensor_intarrayref_bool_bool(self, dim, unbiased, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_var_tensor_intarrayref_intt_bool)(void* self, void* dim, void* correction, void* keepdim);
  HOST_API void* lantern_var_tensor_intarrayref_intt_bool(void* self, void* dim, void* correction, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_var_tensor_intarrayref_intt_bool(self, dim, correction, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_var_tensor_intarrayref_intt_bool)(void* self, void* dim, void* correction, void* keepdim);
  HOST_API void* lantern_Tensor_var_tensor_intarrayref_intt_bool(void* self, void* dim, void* correction, void* keepdim) { void* ret = _lantern_Tensor_var_tensor_intarrayref_intt_bool(self, dim, correction, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_var_out_tensor_tensor_intarrayref_bool_bool)(void* out, void* self, void* dim, void* unbiased, void* keepdim);
  HOST_API void* lantern_var_out_tensor_tensor_intarrayref_bool_bool(void* out, void* self, void* dim, void* unbiased, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_var_out_tensor_tensor_intarrayref_bool_bool(out, self, dim, unbiased, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_var_out_tensor_tensor_intarrayref_intt_bool)(void* out, void* self, void* dim, void* correction, void* keepdim);
  HOST_API void* lantern_var_out_tensor_tensor_intarrayref_intt_bool(void* out, void* self, void* dim, void* correction, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_var_out_tensor_tensor_intarrayref_intt_bool(out, self, dim, correction, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_var_tensor_dimnamelist_bool_bool)(void* self, void* dim, void* unbiased, void* keepdim);
  HOST_API void* lantern_var_tensor_dimnamelist_bool_bool(void* self, void* dim, void* unbiased, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_var_tensor_dimnamelist_bool_bool(self, dim, unbiased, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_var_tensor_dimnamelist_bool_bool)(void* self, void* dim, void* unbiased, void* keepdim);
  HOST_API void* lantern_Tensor_var_tensor_dimnamelist_bool_bool(void* self, void* dim, void* unbiased, void* keepdim) { void* ret = _lantern_Tensor_var_tensor_dimnamelist_bool_bool(self, dim, unbiased, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_var_out_tensor_tensor_dimnamelist_bool_bool)(void* out, void* self, void* dim, void* unbiased, void* keepdim);
  HOST_API void* lantern_var_out_tensor_tensor_dimnamelist_bool_bool(void* out, void* self, void* dim, void* unbiased, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_var_out_tensor_tensor_dimnamelist_bool_bool(out, self, dim, unbiased, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_var_tensor_dimnamelist_intt_bool)(void* self, void* dim, void* correction, void* keepdim);
  HOST_API void* lantern_var_tensor_dimnamelist_intt_bool(void* self, void* dim, void* correction, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_var_tensor_dimnamelist_intt_bool(self, dim, correction, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_var_tensor_dimnamelist_intt_bool)(void* self, void* dim, void* correction, void* keepdim);
  HOST_API void* lantern_Tensor_var_tensor_dimnamelist_intt_bool(void* self, void* dim, void* correction, void* keepdim) { void* ret = _lantern_Tensor_var_tensor_dimnamelist_intt_bool(self, dim, correction, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_var_out_tensor_tensor_dimnamelist_intt_bool)(void* out, void* self, void* dim, void* correction, void* keepdim);
  HOST_API void* lantern_var_out_tensor_tensor_dimnamelist_intt_bool(void* out, void* self, void* dim, void* correction, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_var_out_tensor_tensor_dimnamelist_intt_bool(out, self, dim, correction, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_var_mean_tensor_bool)(void* self, void* unbiased);
  HOST_API void* lantern_var_mean_tensor_bool(void* self, void* unbiased) { LANTERN_CHECK_LOADED void* ret = _lantern_var_mean_tensor_bool(self, unbiased); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_var_mean_tensor_intarrayref_bool_bool)(void* self, void* dim, void* unbiased, void* keepdim);
  HOST_API void* lantern_var_mean_tensor_intarrayref_bool_bool(void* self, void* dim, void* unbiased, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_var_mean_tensor_intarrayref_bool_bool(self, dim, unbiased, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_var_mean_tensor_intarrayref_intt_bool)(void* self, void* dim, void* correction, void* keepdim);
  HOST_API void* lantern_var_mean_tensor_intarrayref_intt_bool(void* self, void* dim, void* correction, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_var_mean_tensor_intarrayref_intt_bool(self, dim, correction, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_var_mean_tensor_dimnamelist_bool_bool)(void* self, void* dim, void* unbiased, void* keepdim);
  HOST_API void* lantern_var_mean_tensor_dimnamelist_bool_bool(void* self, void* dim, void* unbiased, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_var_mean_tensor_dimnamelist_bool_bool(self, dim, unbiased, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_var_mean_tensor_dimnamelist_intt_bool)(void* self, void* dim, void* correction, void* keepdim);
  HOST_API void* lantern_var_mean_tensor_dimnamelist_intt_bool(void* self, void* dim, void* correction, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_var_mean_tensor_dimnamelist_intt_bool(self, dim, correction, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_view_as_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_view_as_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_view_as_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_where_tensor_tensor_tensor)(void* condition, void* self, void* other);
  HOST_API void* lantern_where_tensor_tensor_tensor(void* condition, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_where_tensor_tensor_tensor(condition, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_where_tensor_tensor_tensor)(void* condition, void* self, void* other);
  HOST_API void* lantern_Tensor_where_tensor_tensor_tensor(void* condition, void* self, void* other) { void* ret = _lantern_Tensor_where_tensor_tensor_tensor(condition, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_where_out_tensor_tensor_tensor_tensor)(void* out, void* condition, void* self, void* other);
  HOST_API void* lantern_where_out_tensor_tensor_tensor_tensor(void* out, void* condition, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_where_out_tensor_tensor_tensor_tensor(out, condition, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_where_tensor_scalar_tensor)(void* condition, void* self, void* other);
  HOST_API void* lantern_where_tensor_scalar_tensor(void* condition, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_where_tensor_scalar_tensor(condition, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_where_tensor_tensor_scalar)(void* condition, void* self, void* other);
  HOST_API void* lantern_where_tensor_tensor_scalar(void* condition, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_where_tensor_tensor_scalar(condition, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_where_tensor_scalar_scalar)(void* condition, void* self, void* other);
  HOST_API void* lantern_where_tensor_scalar_scalar(void* condition, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_where_tensor_scalar_scalar(condition, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_where_tensor)(void* condition);
  HOST_API void* lantern_where_tensor(void* condition) { LANTERN_CHECK_LOADED void* ret = _lantern_where_tensor(condition); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_norm_except_dim_tensor_intt_intt)(void* v, void* pow, void* dim);
  HOST_API void* lantern_norm_except_dim_tensor_intt_intt(void* v, void* pow, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_norm_except_dim_tensor_intt_intt(v, pow, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__weight_norm_tensor_tensor_intt)(void* v, void* g, void* dim);
  HOST_API void* lantern__weight_norm_tensor_tensor_intt(void* v, void* g, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern__weight_norm_tensor_tensor_intt(v, g, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__weight_norm_interface_tensor_tensor_intt)(void* v, void* g, void* dim);
  HOST_API void* lantern__weight_norm_interface_tensor_tensor_intt(void* v, void* g, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern__weight_norm_interface_tensor_tensor_intt(v, g, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__weight_norm_interface_backward_tensor_tensor_tensor_tensor_intt)(void* grad_w, void* saved_v, void* saved_g, void* saved_norms, void* dim);
  HOST_API void* lantern__weight_norm_interface_backward_tensor_tensor_tensor_tensor_intt(void* grad_w, void* saved_v, void* saved_g, void* saved_norms, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern__weight_norm_interface_backward_tensor_tensor_tensor_tensor_intt(grad_w, saved_v, saved_g, saved_norms, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__weight_norm_differentiable_backward_tensor_tensor_tensor_tensor_intt)(void* grad_w, void* saved_v, void* saved_g, void* saved_norms, void* dim);
  HOST_API void* lantern__weight_norm_differentiable_backward_tensor_tensor_tensor_tensor_intt(void* grad_w, void* saved_v, void* saved_g, void* saved_norms, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern__weight_norm_differentiable_backward_tensor_tensor_tensor_tensor_intt(grad_w, saved_v, saved_g, saved_norms, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_zeros_intarrayref_dimnamelist_tensoroptions)(void* size, void* names, void* options);
  HOST_API void* lantern_zeros_intarrayref_dimnamelist_tensoroptions(void* size, void* names, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_zeros_intarrayref_dimnamelist_tensoroptions(size, names, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__efficientzerotensor_intarrayref_tensoroptions)(void* size, void* options);
  HOST_API void* lantern__efficientzerotensor_intarrayref_tensoroptions(void* size, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern__efficientzerotensor_intarrayref_tensoroptions(size, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_zeros_intarrayref_tensoroptions)(void* size, void* options);
  HOST_API void* lantern_zeros_intarrayref_tensoroptions(void* size, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_zeros_intarrayref_tensoroptions(size, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_zeros_out_tensor_intarrayref)(void* out, void* size);
  HOST_API void* lantern_zeros_out_tensor_intarrayref(void* out, void* size) { LANTERN_CHECK_LOADED void* ret = _lantern_zeros_out_tensor_intarrayref(out, size); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_zeros_like_tensor_tensoroptions_memoryformat)(void* self, void* options, void* memory_format);
  HOST_API void* lantern_zeros_like_tensor_tensoroptions_memoryformat(void* self, void* options, void* memory_format) { LANTERN_CHECK_LOADED void* ret = _lantern_zeros_like_tensor_tensoroptions_memoryformat(self, options, memory_format); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__standard_gamma_grad_tensor_tensor)(void* self, void* output);
  HOST_API void* lantern__standard_gamma_grad_tensor_tensor(void* self, void* output) { LANTERN_CHECK_LOADED void* ret = _lantern__standard_gamma_grad_tensor_tensor(self, output); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__standard_gamma_tensor_generator)(void* self, void* generator);
  HOST_API void* lantern__standard_gamma_tensor_generator(void* self, void* generator) { LANTERN_CHECK_LOADED void* ret = _lantern__standard_gamma_tensor_generator(self, generator); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__dirichlet_grad_tensor_tensor_tensor)(void* x, void* alpha, void* total);
  HOST_API void* lantern__dirichlet_grad_tensor_tensor_tensor(void* x, void* alpha, void* total) { LANTERN_CHECK_LOADED void* ret = _lantern__dirichlet_grad_tensor_tensor_tensor(x, alpha, total); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__sample_dirichlet_tensor_generator)(void* self, void* generator);
  HOST_API void* lantern__sample_dirichlet_tensor_generator(void* self, void* generator) { LANTERN_CHECK_LOADED void* ret = _lantern__sample_dirichlet_tensor_generator(self, generator); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_poisson_tensor_generator)(void* self, void* generator);
  HOST_API void* lantern_poisson_tensor_generator(void* self, void* generator) { LANTERN_CHECK_LOADED void* ret = _lantern_poisson_tensor_generator(self, generator); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_binomial_tensor_tensor_generator)(void* count, void* prob, void* generator);
  HOST_API void* lantern_binomial_tensor_tensor_generator(void* count, void* prob, void* generator) { LANTERN_CHECK_LOADED void* ret = _lantern_binomial_tensor_tensor_generator(count, prob, generator); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_native_norm_tensor_scalar)(void* self, void* p);
  HOST_API void* lantern_native_norm_tensor_scalar(void* self, void* p) { LANTERN_CHECK_LOADED void* ret = _lantern_native_norm_tensor_scalar(self, p); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_native_norm_tensor_scalar_intarrayref_bool_scalartype)(void* self, void* p, void* dim, void* keepdim, void* dtype);
  HOST_API void* lantern_native_norm_tensor_scalar_intarrayref_bool_scalartype(void* self, void* p, void* dim, void* keepdim, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern_native_norm_tensor_scalar_intarrayref_bool_scalartype(self, p, dim, keepdim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__sparse_sum_tensor)(void* self);
  HOST_API void* lantern__sparse_sum_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__sparse_sum_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__sparse_sum_tensor_scalartype)(void* self, void* dtype);
  HOST_API void* lantern__sparse_sum_tensor_scalartype(void* self, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern__sparse_sum_tensor_scalartype(self, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__sparse_sum_tensor_intarrayref)(void* self, void* dim);
  HOST_API void* lantern__sparse_sum_tensor_intarrayref(void* self, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern__sparse_sum_tensor_intarrayref(self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__sparse_sum_tensor_intarrayref_scalartype)(void* self, void* dim, void* dtype);
  HOST_API void* lantern__sparse_sum_tensor_intarrayref_scalartype(void* self, void* dim, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern__sparse_sum_tensor_intarrayref_scalartype(self, dim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__sparse_sum_backward_tensor_tensor_intarrayref)(void* grad, void* self, void* dim);
  HOST_API void* lantern__sparse_sum_backward_tensor_tensor_intarrayref(void* grad, void* self, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern__sparse_sum_backward_tensor_tensor_intarrayref(grad, self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__sparse_csr_sum_tensor_intarrayref_bool_scalartype)(void* self, void* dim, void* keepdim, void* dtype);
  HOST_API void* lantern__sparse_csr_sum_tensor_intarrayref_bool_scalartype(void* self, void* dim, void* keepdim, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern__sparse_csr_sum_tensor_intarrayref_bool_scalartype(self, dim, keepdim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__sparse_csr_prod_tensor_intarrayref_bool_scalartype)(void* self, void* dim, void* keepdim, void* dtype);
  HOST_API void* lantern__sparse_csr_prod_tensor_intarrayref_bool_scalartype(void* self, void* dim, void* keepdim, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern__sparse_csr_prod_tensor_intarrayref_bool_scalartype(self, dim, keepdim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__sparse_softmax_tensor_intt_scalartype)(void* self, void* dim, void* dtype);
  HOST_API void* lantern__sparse_softmax_tensor_intt_scalartype(void* self, void* dim, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern__sparse_softmax_tensor_intt_scalartype(self, dim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__sparse_softmax_tensor_dimname_scalartype)(void* self, void* dim, void* dtype);
  HOST_API void* lantern__sparse_softmax_tensor_dimname_scalartype(void* self, void* dim, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern__sparse_softmax_tensor_dimname_scalartype(self, dim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__sparse_softmax_tensor_intt_bool)(void* self, void* dim, void* half_to_float);
  HOST_API void* lantern__sparse_softmax_tensor_intt_bool(void* self, void* dim, void* half_to_float) { LANTERN_CHECK_LOADED void* ret = _lantern__sparse_softmax_tensor_intt_bool(self, dim, half_to_float); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__sparse_softmax_backward_data_tensor_tensor_intt_tensor)(void* grad_output, void* output, void* dim, void* self);
  HOST_API void* lantern__sparse_softmax_backward_data_tensor_tensor_intt_tensor(void* grad_output, void* output, void* dim, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__sparse_softmax_backward_data_tensor_tensor_intt_tensor(grad_output, output, dim, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__sparse_log_softmax_tensor_intt_scalartype)(void* self, void* dim, void* dtype);
  HOST_API void* lantern__sparse_log_softmax_tensor_intt_scalartype(void* self, void* dim, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern__sparse_log_softmax_tensor_intt_scalartype(self, dim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__sparse_log_softmax_tensor_dimname_scalartype)(void* self, void* dim, void* dtype);
  HOST_API void* lantern__sparse_log_softmax_tensor_dimname_scalartype(void* self, void* dim, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern__sparse_log_softmax_tensor_dimname_scalartype(self, dim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__sparse_log_softmax_tensor_intt_bool)(void* self, void* dim, void* half_to_float);
  HOST_API void* lantern__sparse_log_softmax_tensor_intt_bool(void* self, void* dim, void* half_to_float) { LANTERN_CHECK_LOADED void* ret = _lantern__sparse_log_softmax_tensor_intt_bool(self, dim, half_to_float); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__sparse_log_softmax_backward_data_tensor_tensor_intt_tensor)(void* grad_output, void* output, void* dim, void* self);
  HOST_API void* lantern__sparse_log_softmax_backward_data_tensor_tensor_intt_tensor(void* grad_output, void* output, void* dim, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__sparse_log_softmax_backward_data_tensor_tensor_intt_tensor(grad_output, output, dim, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__spdiags_tensor_tensor_intarrayref_layout)(void* diagonals, void* offsets, void* shape, void* layout);
  HOST_API void* lantern__spdiags_tensor_tensor_intarrayref_layout(void* diagonals, void* offsets, void* shape, void* layout) { LANTERN_CHECK_LOADED void* ret = _lantern__spdiags_tensor_tensor_intarrayref_layout(diagonals, offsets, shape, layout); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_norm_tensor_scalar_scalartype)(void* self, void* p, void* dtype);
  HOST_API void* lantern_norm_tensor_scalar_scalartype(void* self, void* p, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern_norm_tensor_scalar_scalartype(self, p, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_norm_tensor_scalar_scalartype)(void* self, void* p, void* dtype);
  HOST_API void* lantern_Tensor_norm_tensor_scalar_scalartype(void* self, void* p, void* dtype) { void* ret = _lantern_Tensor_norm_tensor_scalar_scalartype(self, p, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_norm_tensor_scalar)(void* self, void* p);
  HOST_API void* lantern_norm_tensor_scalar(void* self, void* p) { LANTERN_CHECK_LOADED void* ret = _lantern_norm_tensor_scalar(self, p); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_norm_tensor_scalar)(void* self, void* p);
  HOST_API void* lantern_Tensor_norm_tensor_scalar(void* self, void* p) { void* ret = _lantern_Tensor_norm_tensor_scalar(self, p); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_norm_tensor_scalar_intarrayref_bool_scalartype)(void* self, void* p, void* dim, void* keepdim, void* dtype);
  HOST_API void* lantern_norm_tensor_scalar_intarrayref_bool_scalartype(void* self, void* p, void* dim, void* keepdim, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern_norm_tensor_scalar_intarrayref_bool_scalartype(self, p, dim, keepdim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_norm_tensor_scalar_intarrayref_bool_scalartype)(void* self, void* p, void* dim, void* keepdim, void* dtype);
  HOST_API void* lantern_Tensor_norm_tensor_scalar_intarrayref_bool_scalartype(void* self, void* p, void* dim, void* keepdim, void* dtype) { void* ret = _lantern_Tensor_norm_tensor_scalar_intarrayref_bool_scalartype(self, p, dim, keepdim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_norm_tensor_scalar_intarrayref_bool)(void* self, void* p, void* dim, void* keepdim);
  HOST_API void* lantern_norm_tensor_scalar_intarrayref_bool(void* self, void* p, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_norm_tensor_scalar_intarrayref_bool(self, p, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_norm_tensor_scalar_intarrayref_bool)(void* self, void* p, void* dim, void* keepdim);
  HOST_API void* lantern_Tensor_norm_tensor_scalar_intarrayref_bool(void* self, void* p, void* dim, void* keepdim) { void* ret = _lantern_Tensor_norm_tensor_scalar_intarrayref_bool(self, p, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_norm_out_tensor_tensor_scalar_intarrayref_bool_scalartype)(void* out, void* self, void* p, void* dim, void* keepdim, void* dtype);
  HOST_API void* lantern_norm_out_tensor_tensor_scalar_intarrayref_bool_scalartype(void* out, void* self, void* p, void* dim, void* keepdim, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern_norm_out_tensor_tensor_scalar_intarrayref_bool_scalartype(out, self, p, dim, keepdim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_norm_out_tensor_tensor_scalar_intarrayref_bool)(void* out, void* self, void* p, void* dim, void* keepdim);
  HOST_API void* lantern_norm_out_tensor_tensor_scalar_intarrayref_bool(void* out, void* self, void* p, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_norm_out_tensor_tensor_scalar_intarrayref_bool(out, self, p, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_norm_tensor_scalar_dimnamelist_bool_scalartype)(void* self, void* p, void* dim, void* keepdim, void* dtype);
  HOST_API void* lantern_norm_tensor_scalar_dimnamelist_bool_scalartype(void* self, void* p, void* dim, void* keepdim, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern_norm_tensor_scalar_dimnamelist_bool_scalartype(self, p, dim, keepdim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_norm_tensor_scalar_dimnamelist_bool_scalartype)(void* self, void* p, void* dim, void* keepdim, void* dtype);
  HOST_API void* lantern_Tensor_norm_tensor_scalar_dimnamelist_bool_scalartype(void* self, void* p, void* dim, void* keepdim, void* dtype) { void* ret = _lantern_Tensor_norm_tensor_scalar_dimnamelist_bool_scalartype(self, p, dim, keepdim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_norm_tensor_scalar_dimnamelist_bool)(void* self, void* p, void* dim, void* keepdim);
  HOST_API void* lantern_norm_tensor_scalar_dimnamelist_bool(void* self, void* p, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_norm_tensor_scalar_dimnamelist_bool(self, p, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_norm_tensor_scalar_dimnamelist_bool)(void* self, void* p, void* dim, void* keepdim);
  HOST_API void* lantern_Tensor_norm_tensor_scalar_dimnamelist_bool(void* self, void* p, void* dim, void* keepdim) { void* ret = _lantern_Tensor_norm_tensor_scalar_dimnamelist_bool(self, p, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_norm_out_tensor_tensor_scalar_dimnamelist_bool_scalartype)(void* out, void* self, void* p, void* dim, void* keepdim, void* dtype);
  HOST_API void* lantern_norm_out_tensor_tensor_scalar_dimnamelist_bool_scalartype(void* out, void* self, void* p, void* dim, void* keepdim, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern_norm_out_tensor_tensor_scalar_dimnamelist_bool_scalartype(out, self, p, dim, keepdim, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_norm_out_tensor_tensor_scalar_dimnamelist_bool)(void* out, void* self, void* p, void* dim, void* keepdim);
  HOST_API void* lantern_norm_out_tensor_tensor_scalar_dimnamelist_bool(void* out, void* self, void* p, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_norm_out_tensor_tensor_scalar_dimnamelist_bool(out, self, p, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_frexp_tensor)(void* self);
  HOST_API void* lantern_frexp_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_frexp_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_frexp_tensor)(void* self);
  HOST_API void* lantern_Tensor_frexp_tensor(void* self) { void* ret = _lantern_Tensor_frexp_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_frexp_out_tensor_tensor_tensor)(void* mantissa, void* exponent, void* self);
  HOST_API void* lantern_frexp_out_tensor_tensor_tensor(void* mantissa, void* exponent, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_frexp_out_tensor_tensor_tensor(mantissa, exponent, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_frobenius_norm_tensor)(void* self);
  HOST_API void* lantern_frobenius_norm_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_frobenius_norm_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_frobenius_norm_tensor_intarrayref_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_frobenius_norm_tensor_intarrayref_bool(void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_frobenius_norm_tensor_intarrayref_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_frobenius_norm_out_tensor_tensor_intarrayref_bool)(void* out, void* self, void* dim, void* keepdim);
  HOST_API void* lantern_frobenius_norm_out_tensor_tensor_intarrayref_bool(void* out, void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_frobenius_norm_out_tensor_tensor_intarrayref_bool(out, self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_nuclear_norm_tensor_bool)(void* self, void* keepdim);
  HOST_API void* lantern_nuclear_norm_tensor_bool(void* self, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_nuclear_norm_tensor_bool(self, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_nuclear_norm_out_tensor_tensor_bool)(void* out, void* self, void* keepdim);
  HOST_API void* lantern_nuclear_norm_out_tensor_tensor_bool(void* out, void* self, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_nuclear_norm_out_tensor_tensor_bool(out, self, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_nuclear_norm_tensor_intarrayref_bool)(void* self, void* dim, void* keepdim);
  HOST_API void* lantern_nuclear_norm_tensor_intarrayref_bool(void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_nuclear_norm_tensor_intarrayref_bool(self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_nuclear_norm_out_tensor_tensor_intarrayref_bool)(void* out, void* self, void* dim, void* keepdim);
  HOST_API void* lantern_nuclear_norm_out_tensor_tensor_intarrayref_bool(void* out, void* self, void* dim, void* keepdim) { LANTERN_CHECK_LOADED void* ret = _lantern_nuclear_norm_out_tensor_tensor_intarrayref_bool(out, self, dim, keepdim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_clone_tensor_memoryformat)(void* self, void* memory_format);
  HOST_API void* lantern_clone_tensor_memoryformat(void* self, void* memory_format) { LANTERN_CHECK_LOADED void* ret = _lantern_clone_tensor_memoryformat(self, memory_format); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_clone_tensor_memoryformat)(void* self, void* memory_format);
  HOST_API void* lantern_Tensor_clone_tensor_memoryformat(void* self, void* memory_format) { void* ret = _lantern_Tensor_clone_tensor_memoryformat(self, memory_format); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_positive_tensor)(void* self);
  HOST_API void* lantern_positive_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_positive_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_positive_tensor)(void* self);
  HOST_API void* lantern_Tensor_positive_tensor(void* self) { void* ret = _lantern_Tensor_positive_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_resize_as__tensor_tensor_memoryformat)(void* self, void* the_template, void* memory_format);
  HOST_API void* lantern_resize_as__tensor_tensor_memoryformat(void* self, void* the_template, void* memory_format) { LANTERN_CHECK_LOADED void* ret = _lantern_resize_as__tensor_tensor_memoryformat(self, the_template, memory_format); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_resize_as__tensor_tensor_memoryformat)(void* self, void* the_template, void* memory_format);
  HOST_API void* lantern_Tensor_resize_as__tensor_tensor_memoryformat(void* self, void* the_template, void* memory_format) { void* ret = _lantern_Tensor_resize_as__tensor_tensor_memoryformat(self, the_template, memory_format); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_resize_as_sparse__tensor_tensor)(void* self, void* the_template);
  HOST_API void* lantern_resize_as_sparse__tensor_tensor(void* self, void* the_template) { LANTERN_CHECK_LOADED void* ret = _lantern_resize_as_sparse__tensor_tensor(self, the_template); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_resize_as_sparse__tensor_tensor)(void* self, void* the_template);
  HOST_API void* lantern_Tensor_resize_as_sparse__tensor_tensor(void* self, void* the_template) { void* ret = _lantern_Tensor_resize_as_sparse__tensor_tensor(self, the_template); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_zero__tensor)(void* self);
  HOST_API void* lantern_zero__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_zero__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_zero__tensor)(void* self);
  HOST_API void* lantern_Tensor_zero__tensor(void* self) { void* ret = _lantern_Tensor_zero__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sub_out_tensor_tensor_tensor_scalar)(void* out, void* self, void* other, void* alpha);
  HOST_API void* lantern_sub_out_tensor_tensor_tensor_scalar(void* out, void* self, void* other, void* alpha) { LANTERN_CHECK_LOADED void* ret = _lantern_sub_out_tensor_tensor_tensor_scalar(out, self, other, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sub_tensor_tensor_scalar)(void* self, void* other, void* alpha);
  HOST_API void* lantern_sub_tensor_tensor_scalar(void* self, void* other, void* alpha) { LANTERN_CHECK_LOADED void* ret = _lantern_sub_tensor_tensor_scalar(self, other, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_sub_tensor_tensor_scalar)(void* self, void* other, void* alpha);
  HOST_API void* lantern_Tensor_sub_tensor_tensor_scalar(void* self, void* other, void* alpha) { void* ret = _lantern_Tensor_sub_tensor_tensor_scalar(self, other, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_sub__tensor_tensor_scalar)(void* self, void* other, void* alpha);
  HOST_API void* lantern_Tensor_sub__tensor_tensor_scalar(void* self, void* other, void* alpha) { void* ret = _lantern_Tensor_sub__tensor_tensor_scalar(self, other, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sub_tensor_scalar_scalar)(void* self, void* other, void* alpha);
  HOST_API void* lantern_sub_tensor_scalar_scalar(void* self, void* other, void* alpha) { LANTERN_CHECK_LOADED void* ret = _lantern_sub_tensor_scalar_scalar(self, other, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_sub_tensor_scalar_scalar)(void* self, void* other, void* alpha);
  HOST_API void* lantern_Tensor_sub_tensor_scalar_scalar(void* self, void* other, void* alpha) { void* ret = _lantern_Tensor_sub_tensor_scalar_scalar(self, other, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_sub__tensor_scalar_scalar)(void* self, void* other, void* alpha);
  HOST_API void* lantern_Tensor_sub__tensor_scalar_scalar(void* self, void* other, void* alpha) { void* ret = _lantern_Tensor_sub__tensor_scalar_scalar(self, other, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_subtract_out_tensor_tensor_tensor_scalar)(void* out, void* self, void* other, void* alpha);
  HOST_API void* lantern_subtract_out_tensor_tensor_tensor_scalar(void* out, void* self, void* other, void* alpha) { LANTERN_CHECK_LOADED void* ret = _lantern_subtract_out_tensor_tensor_tensor_scalar(out, self, other, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_subtract_tensor_tensor_scalar)(void* self, void* other, void* alpha);
  HOST_API void* lantern_subtract_tensor_tensor_scalar(void* self, void* other, void* alpha) { LANTERN_CHECK_LOADED void* ret = _lantern_subtract_tensor_tensor_scalar(self, other, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_subtract_tensor_tensor_scalar)(void* self, void* other, void* alpha);
  HOST_API void* lantern_Tensor_subtract_tensor_tensor_scalar(void* self, void* other, void* alpha) { void* ret = _lantern_Tensor_subtract_tensor_tensor_scalar(self, other, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_subtract__tensor_tensor_scalar)(void* self, void* other, void* alpha);
  HOST_API void* lantern_Tensor_subtract__tensor_tensor_scalar(void* self, void* other, void* alpha) { void* ret = _lantern_Tensor_subtract__tensor_tensor_scalar(self, other, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_subtract_tensor_scalar_scalar)(void* self, void* other, void* alpha);
  HOST_API void* lantern_subtract_tensor_scalar_scalar(void* self, void* other, void* alpha) { LANTERN_CHECK_LOADED void* ret = _lantern_subtract_tensor_scalar_scalar(self, other, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_subtract_tensor_scalar_scalar)(void* self, void* other, void* alpha);
  HOST_API void* lantern_Tensor_subtract_tensor_scalar_scalar(void* self, void* other, void* alpha) { void* ret = _lantern_Tensor_subtract_tensor_scalar_scalar(self, other, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_subtract__tensor_scalar_scalar)(void* self, void* other, void* alpha);
  HOST_API void* lantern_Tensor_subtract__tensor_scalar_scalar(void* self, void* other, void* alpha) { void* ret = _lantern_Tensor_subtract__tensor_scalar_scalar(self, other, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_rsub_tensor_tensor_scalar)(void* self, void* other, void* alpha);
  HOST_API void* lantern_rsub_tensor_tensor_scalar(void* self, void* other, void* alpha) { LANTERN_CHECK_LOADED void* ret = _lantern_rsub_tensor_tensor_scalar(self, other, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_heaviside_out_tensor_tensor_tensor)(void* out, void* self, void* values);
  HOST_API void* lantern_heaviside_out_tensor_tensor_tensor(void* out, void* self, void* values) { LANTERN_CHECK_LOADED void* ret = _lantern_heaviside_out_tensor_tensor_tensor(out, self, values); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_heaviside_tensor_tensor)(void* self, void* values);
  HOST_API void* lantern_heaviside_tensor_tensor(void* self, void* values) { LANTERN_CHECK_LOADED void* ret = _lantern_heaviside_tensor_tensor(self, values); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_heaviside_tensor_tensor)(void* self, void* values);
  HOST_API void* lantern_Tensor_heaviside_tensor_tensor(void* self, void* values) { void* ret = _lantern_Tensor_heaviside_tensor_tensor(self, values); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_heaviside__tensor_tensor)(void* self, void* values);
  HOST_API void* lantern_Tensor_heaviside__tensor_tensor(void* self, void* values) { void* ret = _lantern_Tensor_heaviside__tensor_tensor(self, values); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_rsub_tensor_scalar_scalar)(void* self, void* other, void* alpha);
  HOST_API void* lantern_rsub_tensor_scalar_scalar(void* self, void* other, void* alpha) { LANTERN_CHECK_LOADED void* ret = _lantern_rsub_tensor_scalar_scalar(self, other, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__sparse_addmm_tensor_tensor_tensor_scalar_scalar)(void* self, void* mat1, void* mat2, void* beta, void* alpha);
  HOST_API void* lantern__sparse_addmm_tensor_tensor_tensor_scalar_scalar(void* self, void* mat1, void* mat2, void* beta, void* alpha) { LANTERN_CHECK_LOADED void* ret = _lantern__sparse_addmm_tensor_tensor_tensor_scalar_scalar(self, mat1, mat2, beta, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sparse_sampled_addmm_out_tensor_tensor_tensor_tensor_scalar_scalar)(void* out, void* self, void* mat1, void* mat2, void* beta, void* alpha);
  HOST_API void* lantern_sparse_sampled_addmm_out_tensor_tensor_tensor_tensor_scalar_scalar(void* out, void* self, void* mat1, void* mat2, void* beta, void* alpha) { LANTERN_CHECK_LOADED void* ret = _lantern_sparse_sampled_addmm_out_tensor_tensor_tensor_tensor_scalar_scalar(out, self, mat1, mat2, beta, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sparse_sampled_addmm_tensor_tensor_tensor_scalar_scalar)(void* self, void* mat1, void* mat2, void* beta, void* alpha);
  HOST_API void* lantern_sparse_sampled_addmm_tensor_tensor_tensor_scalar_scalar(void* self, void* mat1, void* mat2, void* beta, void* alpha) { LANTERN_CHECK_LOADED void* ret = _lantern_sparse_sampled_addmm_tensor_tensor_tensor_scalar_scalar(self, mat1, mat2, beta, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_addmm_out_tensor_tensor_tensor_tensor_scalar_scalar)(void* out, void* self, void* mat1, void* mat2, void* beta, void* alpha);
  HOST_API void* lantern_addmm_out_tensor_tensor_tensor_tensor_scalar_scalar(void* out, void* self, void* mat1, void* mat2, void* beta, void* alpha) { LANTERN_CHECK_LOADED void* ret = _lantern_addmm_out_tensor_tensor_tensor_tensor_scalar_scalar(out, self, mat1, mat2, beta, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_addmm_tensor_tensor_tensor_scalar_scalar)(void* self, void* mat1, void* mat2, void* beta, void* alpha);
  HOST_API void* lantern_addmm_tensor_tensor_tensor_scalar_scalar(void* self, void* mat1, void* mat2, void* beta, void* alpha) { LANTERN_CHECK_LOADED void* ret = _lantern_addmm_tensor_tensor_tensor_scalar_scalar(self, mat1, mat2, beta, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_addmm_tensor_tensor_tensor_scalar_scalar)(void* self, void* mat1, void* mat2, void* beta, void* alpha);
  HOST_API void* lantern_Tensor_addmm_tensor_tensor_tensor_scalar_scalar(void* self, void* mat1, void* mat2, void* beta, void* alpha) { void* ret = _lantern_Tensor_addmm_tensor_tensor_tensor_scalar_scalar(self, mat1, mat2, beta, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_addmm__tensor_tensor_tensor_scalar_scalar)(void* self, void* mat1, void* mat2, void* beta, void* alpha);
  HOST_API void* lantern_Tensor_addmm__tensor_tensor_tensor_scalar_scalar(void* self, void* mat1, void* mat2, void* beta, void* alpha) { void* ret = _lantern_Tensor_addmm__tensor_tensor_tensor_scalar_scalar(self, mat1, mat2, beta, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__addmm_activation_out_tensor_tensor_tensor_tensor_scalar_scalar_bool)(void* out, void* self, void* mat1, void* mat2, void* beta, void* alpha, void* use_gelu);
  HOST_API void* lantern__addmm_activation_out_tensor_tensor_tensor_tensor_scalar_scalar_bool(void* out, void* self, void* mat1, void* mat2, void* beta, void* alpha, void* use_gelu) { LANTERN_CHECK_LOADED void* ret = _lantern__addmm_activation_out_tensor_tensor_tensor_tensor_scalar_scalar_bool(out, self, mat1, mat2, beta, alpha, use_gelu); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__addmm_activation_tensor_tensor_tensor_scalar_scalar_bool)(void* self, void* mat1, void* mat2, void* beta, void* alpha, void* use_gelu);
  HOST_API void* lantern__addmm_activation_tensor_tensor_tensor_scalar_scalar_bool(void* self, void* mat1, void* mat2, void* beta, void* alpha, void* use_gelu) { LANTERN_CHECK_LOADED void* ret = _lantern__addmm_activation_tensor_tensor_tensor_scalar_scalar_bool(self, mat1, mat2, beta, alpha, use_gelu); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor__addmm_activation_tensor_tensor_tensor_scalar_scalar_bool)(void* self, void* mat1, void* mat2, void* beta, void* alpha, void* use_gelu);
  HOST_API void* lantern_Tensor__addmm_activation_tensor_tensor_tensor_scalar_scalar_bool(void* self, void* mat1, void* mat2, void* beta, void* alpha, void* use_gelu) { void* ret = _lantern_Tensor__addmm_activation_tensor_tensor_tensor_scalar_scalar_bool(self, mat1, mat2, beta, alpha, use_gelu); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sparse_compressed_tensor_tensor_tensor_tensor_intarrayref_tensoroptions)(void* compressed_indices, void* plain_indices, void* values, void* size, void* options);
  HOST_API void* lantern_sparse_compressed_tensor_tensor_tensor_tensor_intarrayref_tensoroptions(void* compressed_indices, void* plain_indices, void* values, void* size, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_sparse_compressed_tensor_tensor_tensor_tensor_intarrayref_tensoroptions(compressed_indices, plain_indices, values, size, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sparse_csr_tensor_tensor_tensor_tensor_intarrayref_tensoroptions)(void* crow_indices, void* col_indices, void* values, void* size, void* options);
  HOST_API void* lantern_sparse_csr_tensor_tensor_tensor_tensor_intarrayref_tensoroptions(void* crow_indices, void* col_indices, void* values, void* size, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_sparse_csr_tensor_tensor_tensor_tensor_intarrayref_tensoroptions(crow_indices, col_indices, values, size, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sparse_csc_tensor_tensor_tensor_tensor_intarrayref_tensoroptions)(void* ccol_indices, void* row_indices, void* values, void* size, void* options);
  HOST_API void* lantern_sparse_csc_tensor_tensor_tensor_tensor_intarrayref_tensoroptions(void* ccol_indices, void* row_indices, void* values, void* size, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_sparse_csc_tensor_tensor_tensor_tensor_intarrayref_tensoroptions(ccol_indices, row_indices, values, size, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sparse_bsr_tensor_tensor_tensor_tensor_intarrayref_tensoroptions)(void* crow_indices, void* col_indices, void* values, void* size, void* options);
  HOST_API void* lantern_sparse_bsr_tensor_tensor_tensor_tensor_intarrayref_tensoroptions(void* crow_indices, void* col_indices, void* values, void* size, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_sparse_bsr_tensor_tensor_tensor_tensor_intarrayref_tensoroptions(crow_indices, col_indices, values, size, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sparse_bsc_tensor_tensor_tensor_tensor_intarrayref_tensoroptions)(void* ccol_indices, void* row_indices, void* values, void* size, void* options);
  HOST_API void* lantern_sparse_bsc_tensor_tensor_tensor_tensor_intarrayref_tensoroptions(void* ccol_indices, void* row_indices, void* values, void* size, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_sparse_bsc_tensor_tensor_tensor_tensor_intarrayref_tensoroptions(ccol_indices, row_indices, values, size, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sparse_compressed_tensor_tensor_tensor_tensor_tensoroptions)(void* compressed_indices, void* plain_indices, void* values, void* options);
  HOST_API void* lantern_sparse_compressed_tensor_tensor_tensor_tensor_tensoroptions(void* compressed_indices, void* plain_indices, void* values, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_sparse_compressed_tensor_tensor_tensor_tensor_tensoroptions(compressed_indices, plain_indices, values, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sparse_csr_tensor_tensor_tensor_tensor_tensoroptions)(void* crow_indices, void* col_indices, void* values, void* options);
  HOST_API void* lantern_sparse_csr_tensor_tensor_tensor_tensor_tensoroptions(void* crow_indices, void* col_indices, void* values, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_sparse_csr_tensor_tensor_tensor_tensor_tensoroptions(crow_indices, col_indices, values, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sparse_csc_tensor_tensor_tensor_tensor_tensoroptions)(void* ccol_indices, void* row_indices, void* values, void* options);
  HOST_API void* lantern_sparse_csc_tensor_tensor_tensor_tensor_tensoroptions(void* ccol_indices, void* row_indices, void* values, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_sparse_csc_tensor_tensor_tensor_tensor_tensoroptions(ccol_indices, row_indices, values, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sparse_bsr_tensor_tensor_tensor_tensor_tensoroptions)(void* crow_indices, void* col_indices, void* values, void* options);
  HOST_API void* lantern_sparse_bsr_tensor_tensor_tensor_tensor_tensoroptions(void* crow_indices, void* col_indices, void* values, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_sparse_bsr_tensor_tensor_tensor_tensor_tensoroptions(crow_indices, col_indices, values, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sparse_bsc_tensor_tensor_tensor_tensor_tensoroptions)(void* ccol_indices, void* row_indices, void* values, void* options);
  HOST_API void* lantern_sparse_bsc_tensor_tensor_tensor_tensor_tensoroptions(void* ccol_indices, void* row_indices, void* values, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_sparse_bsc_tensor_tensor_tensor_tensor_tensoroptions(ccol_indices, row_indices, values, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__sparse_compressed_tensor_unsafe_tensor_tensor_tensor_intarrayref_tensoroptions)(void* compressed_indices, void* plain_indices, void* values, void* size, void* options);
  HOST_API void* lantern__sparse_compressed_tensor_unsafe_tensor_tensor_tensor_intarrayref_tensoroptions(void* compressed_indices, void* plain_indices, void* values, void* size, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern__sparse_compressed_tensor_unsafe_tensor_tensor_tensor_intarrayref_tensoroptions(compressed_indices, plain_indices, values, size, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__sparse_csr_tensor_unsafe_tensor_tensor_tensor_intarrayref_tensoroptions)(void* crow_indices, void* col_indices, void* values, void* size, void* options);
  HOST_API void* lantern__sparse_csr_tensor_unsafe_tensor_tensor_tensor_intarrayref_tensoroptions(void* crow_indices, void* col_indices, void* values, void* size, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern__sparse_csr_tensor_unsafe_tensor_tensor_tensor_intarrayref_tensoroptions(crow_indices, col_indices, values, size, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__sparse_csc_tensor_unsafe_tensor_tensor_tensor_intarrayref_tensoroptions)(void* ccol_indices, void* row_indices, void* values, void* size, void* options);
  HOST_API void* lantern__sparse_csc_tensor_unsafe_tensor_tensor_tensor_intarrayref_tensoroptions(void* ccol_indices, void* row_indices, void* values, void* size, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern__sparse_csc_tensor_unsafe_tensor_tensor_tensor_intarrayref_tensoroptions(ccol_indices, row_indices, values, size, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__sparse_bsr_tensor_unsafe_tensor_tensor_tensor_intarrayref_tensoroptions)(void* crow_indices, void* col_indices, void* values, void* size, void* options);
  HOST_API void* lantern__sparse_bsr_tensor_unsafe_tensor_tensor_tensor_intarrayref_tensoroptions(void* crow_indices, void* col_indices, void* values, void* size, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern__sparse_bsr_tensor_unsafe_tensor_tensor_tensor_intarrayref_tensoroptions(crow_indices, col_indices, values, size, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__sparse_bsc_tensor_unsafe_tensor_tensor_tensor_intarrayref_tensoroptions)(void* ccol_indices, void* row_indices, void* values, void* size, void* options);
  HOST_API void* lantern__sparse_bsc_tensor_unsafe_tensor_tensor_tensor_intarrayref_tensoroptions(void* ccol_indices, void* row_indices, void* values, void* size, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern__sparse_bsc_tensor_unsafe_tensor_tensor_tensor_intarrayref_tensoroptions(ccol_indices, row_indices, values, size, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sparse_coo_tensor_intarrayref_tensoroptions)(void* size, void* options);
  HOST_API void* lantern_sparse_coo_tensor_intarrayref_tensoroptions(void* size, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_sparse_coo_tensor_intarrayref_tensoroptions(size, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sparse_coo_tensor_tensor_tensor_tensoroptions)(void* indices, void* values, void* options);
  HOST_API void* lantern_sparse_coo_tensor_tensor_tensor_tensoroptions(void* indices, void* values, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_sparse_coo_tensor_tensor_tensor_tensoroptions(indices, values, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sparse_coo_tensor_tensor_tensor_intarrayref_tensoroptions)(void* indices, void* values, void* size, void* options);
  HOST_API void* lantern_sparse_coo_tensor_tensor_tensor_intarrayref_tensoroptions(void* indices, void* values, void* size, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_sparse_coo_tensor_tensor_tensor_intarrayref_tensoroptions(indices, values, size, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__sparse_coo_tensor_unsafe_tensor_tensor_intarrayref_tensoroptions)(void* indices, void* values, void* size, void* options);
  HOST_API void* lantern__sparse_coo_tensor_unsafe_tensor_tensor_intarrayref_tensoroptions(void* indices, void* values, void* size, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern__sparse_coo_tensor_unsafe_tensor_tensor_intarrayref_tensoroptions(indices, values, size, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__validate_sparse_coo_tensor_args_tensor_tensor_intarrayref)(void* indices, void* values, void* size);
  HOST_API void* lantern__validate_sparse_coo_tensor_args_tensor_tensor_intarrayref(void* indices, void* values, void* size) { LANTERN_CHECK_LOADED void* ret = _lantern__validate_sparse_coo_tensor_args_tensor_tensor_intarrayref(indices, values, size); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__validate_sparse_compressed_tensor_args_tensor_tensor_tensor_intarrayref_layout)(void* compressed_indices, void* plain_indices, void* values, void* size, void* layout);
  HOST_API void* lantern__validate_sparse_compressed_tensor_args_tensor_tensor_tensor_intarrayref_layout(void* compressed_indices, void* plain_indices, void* values, void* size, void* layout) { LANTERN_CHECK_LOADED void* ret = _lantern__validate_sparse_compressed_tensor_args_tensor_tensor_tensor_intarrayref_layout(compressed_indices, plain_indices, values, size, layout); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__validate_sparse_csr_tensor_args_tensor_tensor_tensor_intarrayref)(void* crow_indices, void* col_indices, void* values, void* size);
  HOST_API void* lantern__validate_sparse_csr_tensor_args_tensor_tensor_tensor_intarrayref(void* crow_indices, void* col_indices, void* values, void* size) { LANTERN_CHECK_LOADED void* ret = _lantern__validate_sparse_csr_tensor_args_tensor_tensor_tensor_intarrayref(crow_indices, col_indices, values, size); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__validate_sparse_csc_tensor_args_tensor_tensor_tensor_intarrayref)(void* ccol_indices, void* row_indices, void* values, void* size);
  HOST_API void* lantern__validate_sparse_csc_tensor_args_tensor_tensor_tensor_intarrayref(void* ccol_indices, void* row_indices, void* values, void* size) { LANTERN_CHECK_LOADED void* ret = _lantern__validate_sparse_csc_tensor_args_tensor_tensor_tensor_intarrayref(ccol_indices, row_indices, values, size); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__validate_sparse_bsr_tensor_args_tensor_tensor_tensor_intarrayref)(void* crow_indices, void* col_indices, void* values, void* size);
  HOST_API void* lantern__validate_sparse_bsr_tensor_args_tensor_tensor_tensor_intarrayref(void* crow_indices, void* col_indices, void* values, void* size) { LANTERN_CHECK_LOADED void* ret = _lantern__validate_sparse_bsr_tensor_args_tensor_tensor_tensor_intarrayref(crow_indices, col_indices, values, size); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__validate_sparse_bsc_tensor_args_tensor_tensor_tensor_intarrayref)(void* ccol_indices, void* row_indices, void* values, void* size);
  HOST_API void* lantern__validate_sparse_bsc_tensor_args_tensor_tensor_tensor_intarrayref(void* ccol_indices, void* row_indices, void* values, void* size) { LANTERN_CHECK_LOADED void* ret = _lantern__validate_sparse_bsc_tensor_args_tensor_tensor_tensor_intarrayref(ccol_indices, row_indices, values, size); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__sparse_coo_tensor_with_dims_intt_intt_intarrayref_tensoroptions)(void* sparse_dim, void* dense_dim, void* size, void* options);
  HOST_API void* lantern__sparse_coo_tensor_with_dims_intt_intt_intarrayref_tensoroptions(void* sparse_dim, void* dense_dim, void* size, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern__sparse_coo_tensor_with_dims_intt_intt_intarrayref_tensoroptions(sparse_dim, dense_dim, size, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__sparse_coo_tensor_with_dims_and_tensors_intt_intt_intarrayref_tensor_tensor_tensoroptions)(void* sparse_dim, void* dense_dim, void* size, void* indices, void* values, void* options);
  HOST_API void* lantern__sparse_coo_tensor_with_dims_and_tensors_intt_intt_intarrayref_tensor_tensor_tensoroptions(void* sparse_dim, void* dense_dim, void* size, void* indices, void* values, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern__sparse_coo_tensor_with_dims_and_tensors_intt_intt_intarrayref_tensor_tensor_tensoroptions(sparse_dim, dense_dim, size, indices, values, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_sparse_resize__tensor_intarrayref_intt_intt)(void* self, void* size, void* sparse_dim, void* dense_dim);
  HOST_API void* lantern_Tensor_sparse_resize__tensor_intarrayref_intt_intt(void* self, void* size, void* sparse_dim, void* dense_dim) { void* ret = _lantern_Tensor_sparse_resize__tensor_intarrayref_intt_intt(self, size, sparse_dim, dense_dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_sparse_resize_and_clear__tensor_intarrayref_intt_intt)(void* self, void* size, void* sparse_dim, void* dense_dim);
  HOST_API void* lantern_Tensor_sparse_resize_and_clear__tensor_intarrayref_intt_intt(void* self, void* size, void* sparse_dim, void* dense_dim) { void* ret = _lantern_Tensor_sparse_resize_and_clear__tensor_intarrayref_intt_intt(self, size, sparse_dim, dense_dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_sparse_mask_tensor_tensor)(void* self, void* mask);
  HOST_API void* lantern_Tensor_sparse_mask_tensor_tensor(void* self, void* mask) { void* ret = _lantern_Tensor_sparse_mask_tensor_tensor(self, mask); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__to_cpu_tensorlist)(void* tensors);
  HOST_API void* lantern__to_cpu_tensorlist(void* tensors) { LANTERN_CHECK_LOADED void* ret = _lantern__to_cpu_tensorlist(tensors); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_to_dense_tensor_scalartype)(void* self, void* dtype);
  HOST_API void* lantern_Tensor_to_dense_tensor_scalartype(void* self, void* dtype) { void* ret = _lantern_Tensor_to_dense_tensor_scalartype(self, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor__to_dense_tensor_scalartype)(void* self, void* dtype);
  HOST_API void* lantern_Tensor__to_dense_tensor_scalartype(void* self, void* dtype) { void* ret = _lantern_Tensor__to_dense_tensor_scalartype(self, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_to_dense_backward_tensor_tensor)(void* grad, void* input);
  HOST_API void* lantern_to_dense_backward_tensor_tensor(void* grad, void* input) { LANTERN_CHECK_LOADED void* ret = _lantern_to_dense_backward_tensor_tensor(grad, input); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_sparse_dim_tensor)(void* self);
  HOST_API void* lantern_Tensor_sparse_dim_tensor(void* self) { void* ret = _lantern_Tensor_sparse_dim_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor__dimi_tensor)(void* self);
  HOST_API void* lantern_Tensor__dimi_tensor(void* self) { void* ret = _lantern_Tensor__dimi_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_dense_dim_tensor)(void* self);
  HOST_API void* lantern_Tensor_dense_dim_tensor(void* self) { void* ret = _lantern_Tensor_dense_dim_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor__dimv_tensor)(void* self);
  HOST_API void* lantern_Tensor__dimv_tensor(void* self) { void* ret = _lantern_Tensor__dimv_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor__nnz_tensor)(void* self);
  HOST_API void* lantern_Tensor__nnz_tensor(void* self) { void* ret = _lantern_Tensor__nnz_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_coalesce_tensor)(void* self);
  HOST_API void* lantern_Tensor_coalesce_tensor(void* self) { void* ret = _lantern_Tensor_coalesce_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__coalesce_tensor)(void* self);
  HOST_API void* lantern__coalesce_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__coalesce_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_is_coalesced_tensor)(void* self);
  HOST_API void* lantern_Tensor_is_coalesced_tensor(void* self) { void* ret = _lantern_Tensor_is_coalesced_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor__indices_tensor)(void* self);
  HOST_API void* lantern_Tensor__indices_tensor(void* self) { void* ret = _lantern_Tensor__indices_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor__values_tensor)(void* self);
  HOST_API void* lantern_Tensor__values_tensor(void* self) { void* ret = _lantern_Tensor__values_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor__coalesced__tensor_bool)(void* self, void* coalesced);
  HOST_API void* lantern_Tensor__coalesced__tensor_bool(void* self, void* coalesced) { void* ret = _lantern_Tensor__coalesced__tensor_bool(self, coalesced); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_indices_tensor)(void* self);
  HOST_API void* lantern_Tensor_indices_tensor(void* self) { void* ret = _lantern_Tensor_indices_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_values_tensor)(void* self);
  HOST_API void* lantern_Tensor_values_tensor(void* self) { void* ret = _lantern_Tensor_values_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_crow_indices_tensor)(void* self);
  HOST_API void* lantern_Tensor_crow_indices_tensor(void* self) { void* ret = _lantern_Tensor_crow_indices_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_col_indices_tensor)(void* self);
  HOST_API void* lantern_Tensor_col_indices_tensor(void* self) { void* ret = _lantern_Tensor_col_indices_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_ccol_indices_tensor)(void* self);
  HOST_API void* lantern_Tensor_ccol_indices_tensor(void* self) { void* ret = _lantern_Tensor_ccol_indices_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_row_indices_tensor)(void* self);
  HOST_API void* lantern_Tensor_row_indices_tensor(void* self) { void* ret = _lantern_Tensor_row_indices_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_hspmm_out_tensor_tensor_tensor)(void* out, void* mat1, void* mat2);
  HOST_API void* lantern_hspmm_out_tensor_tensor_tensor(void* out, void* mat1, void* mat2) { LANTERN_CHECK_LOADED void* ret = _lantern_hspmm_out_tensor_tensor_tensor(out, mat1, mat2); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_hspmm_tensor_tensor)(void* mat1, void* mat2);
  HOST_API void* lantern_hspmm_tensor_tensor(void* mat1, void* mat2) { LANTERN_CHECK_LOADED void* ret = _lantern_hspmm_tensor_tensor(mat1, mat2); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_copy_sparse_to_sparse__tensor_tensor_bool)(void* self, void* src, void* non_blocking);
  HOST_API void* lantern_copy_sparse_to_sparse__tensor_tensor_bool(void* self, void* src, void* non_blocking) { LANTERN_CHECK_LOADED void* ret = _lantern_copy_sparse_to_sparse__tensor_tensor_bool(self, src, non_blocking); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_unbind_tensor_intt)(void* self, void* dim);
  HOST_API void* lantern_unbind_tensor_intt(void* self, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_unbind_tensor_intt(self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_unbind_tensor_intt)(void* self, void* dim);
  HOST_API void* lantern_Tensor_unbind_tensor_intt(void* self, void* dim) { void* ret = _lantern_Tensor_unbind_tensor_intt(self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_unbind_tensor_dimname)(void* self, void* dim);
  HOST_API void* lantern_unbind_tensor_dimname(void* self, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_unbind_tensor_dimname(self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_unbind_tensor_dimname)(void* self, void* dim);
  HOST_API void* lantern_Tensor_unbind_tensor_dimname(void* self, void* dim) { void* ret = _lantern_Tensor_unbind_tensor_dimname(self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_to_sparse_tensor_intt)(void* self, void* sparse_dim);
  HOST_API void* lantern_Tensor_to_sparse_tensor_intt(void* self, void* sparse_dim) { void* ret = _lantern_Tensor_to_sparse_tensor_intt(self, sparse_dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_to_sparse_tensor)(void* self);
  HOST_API void* lantern_Tensor_to_sparse_tensor(void* self) { void* ret = _lantern_Tensor_to_sparse_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_to_sparse_csr_tensor)(void* self);
  HOST_API void* lantern_Tensor_to_sparse_csr_tensor(void* self) { void* ret = _lantern_Tensor_to_sparse_csr_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_to_sparse_csc_tensor)(void* self);
  HOST_API void* lantern_Tensor_to_sparse_csc_tensor(void* self) { void* ret = _lantern_Tensor_to_sparse_csc_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_to_sparse_bsr_tensor_intarrayref)(void* self, void* blocksize);
  HOST_API void* lantern_Tensor_to_sparse_bsr_tensor_intarrayref(void* self, void* blocksize) { void* ret = _lantern_Tensor_to_sparse_bsr_tensor_intarrayref(self, blocksize); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_to_sparse_bsc_tensor_intarrayref)(void* self, void* blocksize);
  HOST_API void* lantern_Tensor_to_sparse_bsc_tensor_intarrayref(void* self, void* blocksize) { void* ret = _lantern_Tensor_to_sparse_bsc_tensor_intarrayref(self, blocksize); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_to_mkldnn_tensor_scalartype)(void* self, void* dtype);
  HOST_API void* lantern_Tensor_to_mkldnn_tensor_scalartype(void* self, void* dtype) { void* ret = _lantern_Tensor_to_mkldnn_tensor_scalartype(self, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_mkldnn_reorder_conv2d_weight_tensor_intarrayref_intarrayref_intarrayref_intt)(void* self, void* padding, void* stride, void* dilation, void* groups);
  HOST_API void* lantern_mkldnn_reorder_conv2d_weight_tensor_intarrayref_intarrayref_intarrayref_intt(void* self, void* padding, void* stride, void* dilation, void* groups) { LANTERN_CHECK_LOADED void* ret = _lantern_mkldnn_reorder_conv2d_weight_tensor_intarrayref_intarrayref_intarrayref_intt(self, padding, stride, dilation, groups); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_mkldnn_reorder_conv3d_weight_tensor_intarrayref_intarrayref_intarrayref_intt)(void* self, void* padding, void* stride, void* dilation, void* groups);
  HOST_API void* lantern_mkldnn_reorder_conv3d_weight_tensor_intarrayref_intarrayref_intarrayref_intt(void* self, void* padding, void* stride, void* dilation, void* groups) { LANTERN_CHECK_LOADED void* ret = _lantern_mkldnn_reorder_conv3d_weight_tensor_intarrayref_intarrayref_intarrayref_intt(self, padding, stride, dilation, groups); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_to_mkldnn_backward_tensor_tensor)(void* grad, void* input);
  HOST_API void* lantern_to_mkldnn_backward_tensor_tensor(void* grad, void* input) { LANTERN_CHECK_LOADED void* ret = _lantern_to_mkldnn_backward_tensor_tensor(grad, input); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_quantize_per_tensor_dynamic_tensor_scalartype_bool)(void* self, void* dtype, void* reduce_range);
  HOST_API void* lantern_quantize_per_tensor_dynamic_tensor_scalartype_bool(void* self, void* dtype, void* reduce_range) { LANTERN_CHECK_LOADED void* ret = _lantern_quantize_per_tensor_dynamic_tensor_scalartype_bool(self, dtype, reduce_range); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_quantize_per_tensor_tensor_double_intt_scalartype)(void* self, void* scale, void* zero_point, void* dtype);
  HOST_API void* lantern_quantize_per_tensor_tensor_double_intt_scalartype(void* self, void* scale, void* zero_point, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern_quantize_per_tensor_tensor_double_intt_scalartype(self, scale, zero_point, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_quantize_per_tensor_tensor_tensor_tensor_scalartype)(void* self, void* scale, void* zero_point, void* dtype);
  HOST_API void* lantern_quantize_per_tensor_tensor_tensor_tensor_scalartype(void* self, void* scale, void* zero_point, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern_quantize_per_tensor_tensor_tensor_tensor_scalartype(self, scale, zero_point, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_quantize_per_tensor_tensorlist_tensor_tensor_scalartype)(void* tensors, void* scales, void* zero_points, void* dtype);
  HOST_API void* lantern_quantize_per_tensor_tensorlist_tensor_tensor_scalartype(void* tensors, void* scales, void* zero_points, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern_quantize_per_tensor_tensorlist_tensor_tensor_scalartype(tensors, scales, zero_points, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_quantize_per_channel_tensor_tensor_tensor_intt_scalartype)(void* self, void* scales, void* zero_points, void* axis, void* dtype);
  HOST_API void* lantern_quantize_per_channel_tensor_tensor_tensor_intt_scalartype(void* self, void* scales, void* zero_points, void* axis, void* dtype) { LANTERN_CHECK_LOADED void* ret = _lantern_quantize_per_channel_tensor_tensor_tensor_intt_scalartype(self, scales, zero_points, axis, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_dequantize_tensor)(void* self);
  HOST_API void* lantern_dequantize_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_dequantize_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_dequantize_tensor)(void* self);
  HOST_API void* lantern_Tensor_dequantize_tensor(void* self) { void* ret = _lantern_Tensor_dequantize_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_dequantize_tensorlist)(void* tensors);
  HOST_API void* lantern_dequantize_tensorlist(void* tensors) { LANTERN_CHECK_LOADED void* ret = _lantern_dequantize_tensorlist(tensors); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_q_scale_tensor)(void* self);
  HOST_API void* lantern_q_scale_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_q_scale_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_q_scale_tensor)(void* self);
  HOST_API void* lantern_Tensor_q_scale_tensor(void* self) { void* ret = _lantern_Tensor_q_scale_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_q_zero_point_tensor)(void* self);
  HOST_API void* lantern_q_zero_point_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_q_zero_point_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_q_zero_point_tensor)(void* self);
  HOST_API void* lantern_Tensor_q_zero_point_tensor(void* self) { void* ret = _lantern_Tensor_q_zero_point_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_q_per_channel_scales_tensor)(void* self);
  HOST_API void* lantern_q_per_channel_scales_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_q_per_channel_scales_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_q_per_channel_scales_tensor)(void* self);
  HOST_API void* lantern_Tensor_q_per_channel_scales_tensor(void* self) { void* ret = _lantern_Tensor_q_per_channel_scales_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_q_per_channel_zero_points_tensor)(void* self);
  HOST_API void* lantern_q_per_channel_zero_points_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_q_per_channel_zero_points_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_q_per_channel_zero_points_tensor)(void* self);
  HOST_API void* lantern_Tensor_q_per_channel_zero_points_tensor(void* self) { void* ret = _lantern_Tensor_q_per_channel_zero_points_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_q_per_channel_axis_tensor)(void* self);
  HOST_API void* lantern_q_per_channel_axis_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_q_per_channel_axis_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_q_per_channel_axis_tensor)(void* self);
  HOST_API void* lantern_Tensor_q_per_channel_axis_tensor(void* self) { void* ret = _lantern_Tensor_q_per_channel_axis_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_int_repr_tensor)(void* self);
  HOST_API void* lantern_int_repr_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_int_repr_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_int_repr_tensor)(void* self);
  HOST_API void* lantern_Tensor_int_repr_tensor(void* self) { void* ret = _lantern_Tensor_int_repr_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__make_per_tensor_quantized_tensor_tensor_double_intt)(void* self, void* scale, void* zero_point);
  HOST_API void* lantern__make_per_tensor_quantized_tensor_tensor_double_intt(void* self, void* scale, void* zero_point) { LANTERN_CHECK_LOADED void* ret = _lantern__make_per_tensor_quantized_tensor_tensor_double_intt(self, scale, zero_point); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__make_per_channel_quantized_tensor_tensor_tensor_tensor_intt)(void* self, void* scale, void* zero_point, void* axis);
  HOST_API void* lantern__make_per_channel_quantized_tensor_tensor_tensor_tensor_intt(void* self, void* scale, void* zero_point, void* axis) { LANTERN_CHECK_LOADED void* ret = _lantern__make_per_channel_quantized_tensor_tensor_tensor_tensor_intt(self, scale, zero_point, axis); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_qscheme_tensor)(void* self);
  HOST_API void* lantern_Tensor_qscheme_tensor(void* self) { void* ret = _lantern_Tensor_qscheme_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_fake_quantize_per_tensor_affine_tensor_double_intt_intt_intt)(void* self, void* scale, void* zero_point, void* quant_min, void* quant_max);
  HOST_API void* lantern_fake_quantize_per_tensor_affine_tensor_double_intt_intt_intt(void* self, void* scale, void* zero_point, void* quant_min, void* quant_max) { LANTERN_CHECK_LOADED void* ret = _lantern_fake_quantize_per_tensor_affine_tensor_double_intt_intt_intt(self, scale, zero_point, quant_min, quant_max); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_fake_quantize_per_tensor_affine_tensor_tensor_tensor_intt_intt)(void* self, void* scale, void* zero_point, void* quant_min, void* quant_max);
  HOST_API void* lantern_fake_quantize_per_tensor_affine_tensor_tensor_tensor_intt_intt(void* self, void* scale, void* zero_point, void* quant_min, void* quant_max) { LANTERN_CHECK_LOADED void* ret = _lantern_fake_quantize_per_tensor_affine_tensor_tensor_tensor_intt_intt(self, scale, zero_point, quant_min, quant_max); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_fake_quantize_per_tensor_affine_cachemask_tensor_double_intt_intt_intt)(void* self, void* scale, void* zero_point, void* quant_min, void* quant_max);
  HOST_API void* lantern_fake_quantize_per_tensor_affine_cachemask_tensor_double_intt_intt_intt(void* self, void* scale, void* zero_point, void* quant_min, void* quant_max) { LANTERN_CHECK_LOADED void* ret = _lantern_fake_quantize_per_tensor_affine_cachemask_tensor_double_intt_intt_intt(self, scale, zero_point, quant_min, quant_max); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__fake_quantize_per_tensor_affine_cachemask_tensor_qparams_tensor_tensor_tensor_tensor_intt_intt)(void* self, void* scale, void* zero_point, void* fake_quant_enabled, void* quant_min, void* quant_max);
  HOST_API void* lantern__fake_quantize_per_tensor_affine_cachemask_tensor_qparams_tensor_tensor_tensor_tensor_intt_intt(void* self, void* scale, void* zero_point, void* fake_quant_enabled, void* quant_min, void* quant_max) { LANTERN_CHECK_LOADED void* ret = _lantern__fake_quantize_per_tensor_affine_cachemask_tensor_qparams_tensor_tensor_tensor_tensor_intt_intt(self, scale, zero_point, fake_quant_enabled, quant_min, quant_max); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_fake_quantize_per_tensor_affine_cachemask_backward_tensor_tensor)(void* grad, void* mask);
  HOST_API void* lantern_fake_quantize_per_tensor_affine_cachemask_backward_tensor_tensor(void* grad, void* mask) { LANTERN_CHECK_LOADED void* ret = _lantern_fake_quantize_per_tensor_affine_cachemask_backward_tensor_tensor(grad, mask); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__fake_quantize_learnable_per_tensor_affine_tensor_tensor_tensor_intt_intt_double)(void* self, void* scale, void* zero_point, void* quant_min, void* quant_max, void* grad_factor);
  HOST_API void* lantern__fake_quantize_learnable_per_tensor_affine_tensor_tensor_tensor_intt_intt_double(void* self, void* scale, void* zero_point, void* quant_min, void* quant_max, void* grad_factor) { LANTERN_CHECK_LOADED void* ret = _lantern__fake_quantize_learnable_per_tensor_affine_tensor_tensor_tensor_intt_intt_double(self, scale, zero_point, quant_min, quant_max, grad_factor); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__fake_quantize_learnable_per_tensor_affine_backward_tensor_tensor_tensor_tensor_intt_intt_double)(void* grad, void* self, void* scale, void* zero_point, void* quant_min, void* quant_max, void* grad_factor);
  HOST_API void* lantern__fake_quantize_learnable_per_tensor_affine_backward_tensor_tensor_tensor_tensor_intt_intt_double(void* grad, void* self, void* scale, void* zero_point, void* quant_min, void* quant_max, void* grad_factor) { LANTERN_CHECK_LOADED void* ret = _lantern__fake_quantize_learnable_per_tensor_affine_backward_tensor_tensor_tensor_tensor_intt_intt_double(grad, self, scale, zero_point, quant_min, quant_max, grad_factor); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_fake_quantize_per_channel_affine_tensor_tensor_tensor_intt_intt_intt)(void* self, void* scale, void* zero_point, void* axis, void* quant_min, void* quant_max);
  HOST_API void* lantern_fake_quantize_per_channel_affine_tensor_tensor_tensor_intt_intt_intt(void* self, void* scale, void* zero_point, void* axis, void* quant_min, void* quant_max) { LANTERN_CHECK_LOADED void* ret = _lantern_fake_quantize_per_channel_affine_tensor_tensor_tensor_intt_intt_intt(self, scale, zero_point, axis, quant_min, quant_max); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_fake_quantize_per_channel_affine_cachemask_tensor_tensor_tensor_intt_intt_intt)(void* self, void* scale, void* zero_point, void* axis, void* quant_min, void* quant_max);
  HOST_API void* lantern_fake_quantize_per_channel_affine_cachemask_tensor_tensor_tensor_intt_intt_intt(void* self, void* scale, void* zero_point, void* axis, void* quant_min, void* quant_max) { LANTERN_CHECK_LOADED void* ret = _lantern_fake_quantize_per_channel_affine_cachemask_tensor_tensor_tensor_intt_intt_intt(self, scale, zero_point, axis, quant_min, quant_max); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_fake_quantize_per_channel_affine_cachemask_backward_tensor_tensor)(void* grad, void* mask);
  HOST_API void* lantern_fake_quantize_per_channel_affine_cachemask_backward_tensor_tensor(void* grad, void* mask) { LANTERN_CHECK_LOADED void* ret = _lantern_fake_quantize_per_channel_affine_cachemask_backward_tensor_tensor(grad, mask); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__fake_quantize_learnable_per_channel_affine_tensor_tensor_tensor_intt_intt_intt_double)(void* self, void* scale, void* zero_point, void* axis, void* quant_min, void* quant_max, void* grad_factor);
  HOST_API void* lantern__fake_quantize_learnable_per_channel_affine_tensor_tensor_tensor_intt_intt_intt_double(void* self, void* scale, void* zero_point, void* axis, void* quant_min, void* quant_max, void* grad_factor) { LANTERN_CHECK_LOADED void* ret = _lantern__fake_quantize_learnable_per_channel_affine_tensor_tensor_tensor_intt_intt_intt_double(self, scale, zero_point, axis, quant_min, quant_max, grad_factor); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__fake_quantize_learnable_per_channel_affine_backward_tensor_tensor_tensor_tensor_intt_intt_intt_double)(void* grad, void* self, void* scale, void* zero_point, void* axis, void* quant_min, void* quant_max, void* grad_factor);
  HOST_API void* lantern__fake_quantize_learnable_per_channel_affine_backward_tensor_tensor_tensor_tensor_intt_intt_intt_double(void* grad, void* self, void* scale, void* zero_point, void* axis, void* quant_min, void* quant_max, void* grad_factor) { LANTERN_CHECK_LOADED void* ret = _lantern__fake_quantize_learnable_per_channel_affine_backward_tensor_tensor_tensor_tensor_intt_intt_intt_double(grad, self, scale, zero_point, axis, quant_min, quant_max, grad_factor); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_fused_moving_avg_obs_fake_quant_tensor_tensor_tensor_tensor_tensor_tensor_tensor_double_intt_intt_intt_bool_bool)(void* self, void* observer_on, void* fake_quant_on, void* running_min, void* running_max, void* scale, void* zero_point, void* averaging_const, void* quant_min, void* quant_max, void* ch_axis, void* per_row_fake_quant, void* symmetric_quant);
  HOST_API void* lantern_fused_moving_avg_obs_fake_quant_tensor_tensor_tensor_tensor_tensor_tensor_tensor_double_intt_intt_intt_bool_bool(void* self, void* observer_on, void* fake_quant_on, void* running_min, void* running_max, void* scale, void* zero_point, void* averaging_const, void* quant_min, void* quant_max, void* ch_axis, void* per_row_fake_quant, void* symmetric_quant) { LANTERN_CHECK_LOADED void* ret = _lantern_fused_moving_avg_obs_fake_quant_tensor_tensor_tensor_tensor_tensor_tensor_tensor_double_intt_intt_intt_bool_bool(self, observer_on, fake_quant_on, running_min, running_max, scale, zero_point, averaging_const, quant_min, quant_max, ch_axis, per_row_fake_quant, symmetric_quant); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__fused_moving_avg_obs_fq_helper_tensor_tensor_tensor_tensor_tensor_tensor_tensor_double_intt_intt_intt_bool_bool)(void* self, void* observer_on, void* fake_quant_on, void* running_min, void* running_max, void* scale, void* zero_point, void* averaging_const, void* quant_min, void* quant_max, void* ch_axis, void* per_row_fake_quant, void* symmetric_quant);
  HOST_API void* lantern__fused_moving_avg_obs_fq_helper_tensor_tensor_tensor_tensor_tensor_tensor_tensor_double_intt_intt_intt_bool_bool(void* self, void* observer_on, void* fake_quant_on, void* running_min, void* running_max, void* scale, void* zero_point, void* averaging_const, void* quant_min, void* quant_max, void* ch_axis, void* per_row_fake_quant, void* symmetric_quant) { LANTERN_CHECK_LOADED void* ret = _lantern__fused_moving_avg_obs_fq_helper_tensor_tensor_tensor_tensor_tensor_tensor_tensor_double_intt_intt_intt_bool_bool(self, observer_on, fake_quant_on, running_min, running_max, scale, zero_point, averaging_const, quant_min, quant_max, ch_axis, per_row_fake_quant, symmetric_quant); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__choose_qparams_per_tensor_tensor_bool)(void* self, void* reduce_range);
  HOST_API void* lantern__choose_qparams_per_tensor_tensor_bool(void* self, void* reduce_range) { LANTERN_CHECK_LOADED void* ret = _lantern__choose_qparams_per_tensor_tensor_bool(self, reduce_range); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__saturate_weight_to_fp16_tensor)(void* weight);
  HOST_API void* lantern__saturate_weight_to_fp16_tensor(void* weight) { LANTERN_CHECK_LOADED void* ret = _lantern__saturate_weight_to_fp16_tensor(weight); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_choose_qparams_optimized_tensor_intt_intt_double_intt)(void* input, void* numel, void* n_bins, void* ratio, void* bit_width);
  HOST_API void* lantern_choose_qparams_optimized_tensor_intt_intt_double_intt(void* input, void* numel, void* n_bins, void* ratio, void* bit_width) { LANTERN_CHECK_LOADED void* ret = _lantern_choose_qparams_optimized_tensor_intt_intt_double_intt(input, numel, n_bins, ratio, bit_width); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor__autocast_to_reduced_precision_tensor_bool_bool_scalartype_scalartype)(void* self, void* cuda_enabled, void* cpu_enabled, void* cuda_dtype, void* cpu_dtype);
  HOST_API void* lantern_Tensor__autocast_to_reduced_precision_tensor_bool_bool_scalartype_scalartype(void* self, void* cuda_enabled, void* cpu_enabled, void* cuda_dtype, void* cpu_dtype) { void* ret = _lantern_Tensor__autocast_to_reduced_precision_tensor_bool_bool_scalartype_scalartype(self, cuda_enabled, cpu_enabled, cuda_dtype, cpu_dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor__autocast_to_full_precision_tensor_bool_bool)(void* self, void* cuda_enabled, void* cpu_enabled);
  HOST_API void* lantern_Tensor__autocast_to_full_precision_tensor_bool_bool(void* self, void* cuda_enabled, void* cpu_enabled) { void* ret = _lantern_Tensor__autocast_to_full_precision_tensor_bool_bool(self, cuda_enabled, cpu_enabled); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__to_copy_tensor_tensoroptions_bool_memoryformat)(void* self, void* options, void* non_blocking, void* memory_format);
  HOST_API void* lantern__to_copy_tensor_tensoroptions_bool_memoryformat(void* self, void* options, void* non_blocking, void* memory_format) { LANTERN_CHECK_LOADED void* ret = _lantern__to_copy_tensor_tensoroptions_bool_memoryformat(self, options, non_blocking, memory_format); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_to_tensor_tensoroptions_bool_bool_memoryformat)(void* self, void* options, void* non_blocking, void* copy, void* memory_format);
  HOST_API void* lantern_Tensor_to_tensor_tensoroptions_bool_bool_memoryformat(void* self, void* options, void* non_blocking, void* copy, void* memory_format) { void* ret = _lantern_Tensor_to_tensor_tensoroptions_bool_bool_memoryformat(self, options, non_blocking, copy, memory_format); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_to_tensor_device_scalartype_bool_bool_memoryformat)(void* self, void* device, void* dtype, void* non_blocking, void* copy, void* memory_format);
  HOST_API void* lantern_Tensor_to_tensor_device_scalartype_bool_bool_memoryformat(void* self, void* device, void* dtype, void* non_blocking, void* copy, void* memory_format) { void* ret = _lantern_Tensor_to_tensor_device_scalartype_bool_bool_memoryformat(self, device, dtype, non_blocking, copy, memory_format); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_to_tensor_scalartype_bool_bool_memoryformat)(void* self, void* dtype, void* non_blocking, void* copy, void* memory_format);
  HOST_API void* lantern_Tensor_to_tensor_scalartype_bool_bool_memoryformat(void* self, void* dtype, void* non_blocking, void* copy, void* memory_format) { void* ret = _lantern_Tensor_to_tensor_scalartype_bool_bool_memoryformat(self, dtype, non_blocking, copy, memory_format); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_to_tensor_tensor_bool_bool_memoryformat)(void* self, void* other, void* non_blocking, void* copy, void* memory_format);
  HOST_API void* lantern_Tensor_to_tensor_tensor_bool_bool_memoryformat(void* self, void* other, void* non_blocking, void* copy, void* memory_format) { void* ret = _lantern_Tensor_to_tensor_tensor_bool_bool_memoryformat(self, other, non_blocking, copy, memory_format); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_meshgrid_tensorlist)(void* tensors);
  HOST_API void* lantern_meshgrid_tensorlist(void* tensors) { LANTERN_CHECK_LOADED void* ret = _lantern_meshgrid_tensorlist(tensors); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_meshgrid_tensorlist_cstringview)(void* tensors, void* indexing);
  HOST_API void* lantern_meshgrid_tensorlist_cstringview(void* tensors, void* indexing) { LANTERN_CHECK_LOADED void* ret = _lantern_meshgrid_tensorlist_cstringview(tensors, indexing); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cartesian_prod_tensorlist)(void* tensors);
  HOST_API void* lantern_cartesian_prod_tensorlist(void* tensors) { LANTERN_CHECK_LOADED void* ret = _lantern_cartesian_prod_tensorlist(tensors); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_combinations_tensor_intt_bool)(void* self, void* r, void* with_replacement);
  HOST_API void* lantern_combinations_tensor_intt_bool(void* self, void* r, void* with_replacement) { LANTERN_CHECK_LOADED void* ret = _lantern_combinations_tensor_intt_bool(self, r, with_replacement); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_item_tensor)(void* self);
  HOST_API void* lantern_Tensor_item_tensor(void* self) { void* ret = _lantern_Tensor_item_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_result_type_tensor_tensor)(void* tensor, void* other);
  HOST_API void* lantern_result_type_tensor_tensor(void* tensor, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_result_type_tensor_tensor(tensor, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_result_type_tensor_scalar)(void* tensor, void* other);
  HOST_API void* lantern_result_type_tensor_scalar(void* tensor, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_result_type_tensor_scalar(tensor, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_result_type_scalar_tensor)(void* scalar, void* tensor);
  HOST_API void* lantern_result_type_scalar_tensor(void* scalar, void* tensor) { LANTERN_CHECK_LOADED void* ret = _lantern_result_type_scalar_tensor(scalar, tensor); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_result_type_scalar_scalar)(void* scalar1, void* scalar2);
  HOST_API void* lantern_result_type_scalar_scalar(void* scalar1, void* scalar2) { LANTERN_CHECK_LOADED void* ret = _lantern_result_type_scalar_scalar(scalar1, scalar2); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_can_cast_scalartype_scalartype)(void* from, void* to);
  HOST_API void* lantern_can_cast_scalartype_scalartype(void* from, void* to) { LANTERN_CHECK_LOADED void* ret = _lantern_can_cast_scalartype_scalartype(from, to); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_promote_types_scalartype_scalartype)(void* type1, void* type2);
  HOST_API void* lantern_promote_types_scalartype_scalartype(void* type1, void* type2) { LANTERN_CHECK_LOADED void* ret = _lantern_promote_types_scalartype_scalartype(type1, type2); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__local_scalar_dense_tensor)(void* self);
  HOST_API void* lantern__local_scalar_dense_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__local_scalar_dense_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__lstm_mps_tensor_tensorlist_tensorlist_bool_intt_double_bool_bool_bool)(void* input, void* hx, void* params, void* has_biases, void* num_layers, void* dropout, void* train, void* bidirectional, void* batch_first);
  HOST_API void* lantern__lstm_mps_tensor_tensorlist_tensorlist_bool_intt_double_bool_bool_bool(void* input, void* hx, void* params, void* has_biases, void* num_layers, void* dropout, void* train, void* bidirectional, void* batch_first) { LANTERN_CHECK_LOADED void* ret = _lantern__lstm_mps_tensor_tensorlist_tensorlist_bool_intt_double_bool_bool_bool(input, hx, params, has_biases, num_layers, dropout, train, bidirectional, batch_first); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_lstm_mps_backward_tensor_tensor_tensor_tensor_tensor_tensor_tensorlist_tensorlist_bool_intt_double_bool_bool_bool)(void* grad_y, void* grad_hy, void* grad_cy, void* z_state, void* cell_state_fwd, void* input, void* hx, void* params, void* has_biases, void* num_layers, void* dropout, void* train, void* bidirectional, void* batch_first);
  HOST_API void* lantern_lstm_mps_backward_tensor_tensor_tensor_tensor_tensor_tensor_tensorlist_tensorlist_bool_intt_double_bool_bool_bool(void* grad_y, void* grad_hy, void* grad_cy, void* z_state, void* cell_state_fwd, void* input, void* hx, void* params, void* has_biases, void* num_layers, void* dropout, void* train, void* bidirectional, void* batch_first) { LANTERN_CHECK_LOADED void* ret = _lantern_lstm_mps_backward_tensor_tensor_tensor_tensor_tensor_tensor_tensorlist_tensorlist_bool_intt_double_bool_bool_bool(grad_y, grad_hy, grad_cy, z_state, cell_state_fwd, input, hx, params, has_biases, num_layers, dropout, train, bidirectional, batch_first); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__thnn_fused_lstm_cell_tensor_tensor_tensor_tensor_tensor)(void* input_gates, void* hidden_gates, void* cx, void* input_bias, void* hidden_bias);
  HOST_API void* lantern__thnn_fused_lstm_cell_tensor_tensor_tensor_tensor_tensor(void* input_gates, void* hidden_gates, void* cx, void* input_bias, void* hidden_bias) { LANTERN_CHECK_LOADED void* ret = _lantern__thnn_fused_lstm_cell_tensor_tensor_tensor_tensor_tensor(input_gates, hidden_gates, cx, input_bias, hidden_bias); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__thnn_fused_lstm_cell_backward_impl_tensor_tensor_tensor_tensor_tensor_bool)(void* grad_hy, void* grad_cy, void* cx, void* cy, void* workspace, void* has_bias);
  HOST_API void* lantern__thnn_fused_lstm_cell_backward_impl_tensor_tensor_tensor_tensor_tensor_bool(void* grad_hy, void* grad_cy, void* cx, void* cy, void* workspace, void* has_bias) { LANTERN_CHECK_LOADED void* ret = _lantern__thnn_fused_lstm_cell_backward_impl_tensor_tensor_tensor_tensor_tensor_bool(grad_hy, grad_cy, cx, cy, workspace, has_bias); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__thnn_fused_lstm_cell_backward_tensor_tensor_tensor_tensor_tensor_bool)(void* grad_hy, void* grad_cy, void* cx, void* cy, void* workspace, void* has_bias);
  HOST_API void* lantern__thnn_fused_lstm_cell_backward_tensor_tensor_tensor_tensor_tensor_bool(void* grad_hy, void* grad_cy, void* cx, void* cy, void* workspace, void* has_bias) { LANTERN_CHECK_LOADED void* ret = _lantern__thnn_fused_lstm_cell_backward_tensor_tensor_tensor_tensor_tensor_bool(grad_hy, grad_cy, cx, cy, workspace, has_bias); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__thnn_differentiable_lstm_cell_backward_tensor_tensor_tensor_tensor_tensor_tensor_tensor_tensor)(void* grad_hy, void* grad_cy, void* input_gates, void* hidden_gates, void* input_bias, void* hidden_bias, void* cx, void* cy);
  HOST_API void* lantern__thnn_differentiable_lstm_cell_backward_tensor_tensor_tensor_tensor_tensor_tensor_tensor_tensor(void* grad_hy, void* grad_cy, void* input_gates, void* hidden_gates, void* input_bias, void* hidden_bias, void* cx, void* cy) { LANTERN_CHECK_LOADED void* ret = _lantern__thnn_differentiable_lstm_cell_backward_tensor_tensor_tensor_tensor_tensor_tensor_tensor_tensor(grad_hy, grad_cy, input_gates, hidden_gates, input_bias, hidden_bias, cx, cy); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__thnn_fused_gru_cell_tensor_tensor_tensor_tensor_tensor)(void* input_gates, void* hidden_gates, void* hx, void* input_bias, void* hidden_bias);
  HOST_API void* lantern__thnn_fused_gru_cell_tensor_tensor_tensor_tensor_tensor(void* input_gates, void* hidden_gates, void* hx, void* input_bias, void* hidden_bias) { LANTERN_CHECK_LOADED void* ret = _lantern__thnn_fused_gru_cell_tensor_tensor_tensor_tensor_tensor(input_gates, hidden_gates, hx, input_bias, hidden_bias); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__thnn_fused_gru_cell_backward_tensor_tensor_bool)(void* grad_hy, void* workspace, void* has_bias);
  HOST_API void* lantern__thnn_fused_gru_cell_backward_tensor_tensor_bool(void* grad_hy, void* workspace, void* has_bias) { LANTERN_CHECK_LOADED void* ret = _lantern__thnn_fused_gru_cell_backward_tensor_tensor_bool(grad_hy, workspace, has_bias); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__thnn_differentiable_gru_cell_backward_tensor_tensor_tensor_tensor_tensor_tensor)(void* grad_hy, void* input_gates, void* hidden_gates, void* hx, void* input_bias, void* hidden_bias);
  HOST_API void* lantern__thnn_differentiable_gru_cell_backward_tensor_tensor_tensor_tensor_tensor_tensor(void* grad_hy, void* input_gates, void* hidden_gates, void* hx, void* input_bias, void* hidden_bias) { LANTERN_CHECK_LOADED void* ret = _lantern__thnn_differentiable_gru_cell_backward_tensor_tensor_tensor_tensor_tensor_tensor(grad_hy, input_gates, hidden_gates, hx, input_bias, hidden_bias); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_lstm_tensor_tensorlist_tensorlist_bool_intt_double_bool_bool_bool)(void* input, void* hx, void* params, void* has_biases, void* num_layers, void* dropout, void* train, void* bidirectional, void* batch_first);
  HOST_API void* lantern_lstm_tensor_tensorlist_tensorlist_bool_intt_double_bool_bool_bool(void* input, void* hx, void* params, void* has_biases, void* num_layers, void* dropout, void* train, void* bidirectional, void* batch_first) { LANTERN_CHECK_LOADED void* ret = _lantern_lstm_tensor_tensorlist_tensorlist_bool_intt_double_bool_bool_bool(input, hx, params, has_biases, num_layers, dropout, train, bidirectional, batch_first); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_lstm_tensor_tensor_tensorlist_tensorlist_bool_intt_double_bool_bool)(void* data, void* batch_sizes, void* hx, void* params, void* has_biases, void* num_layers, void* dropout, void* train, void* bidirectional);
  HOST_API void* lantern_lstm_tensor_tensor_tensorlist_tensorlist_bool_intt_double_bool_bool(void* data, void* batch_sizes, void* hx, void* params, void* has_biases, void* num_layers, void* dropout, void* train, void* bidirectional) { LANTERN_CHECK_LOADED void* ret = _lantern_lstm_tensor_tensor_tensorlist_tensorlist_bool_intt_double_bool_bool(data, batch_sizes, hx, params, has_biases, num_layers, dropout, train, bidirectional); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_gru_tensor_tensor_tensorlist_bool_intt_double_bool_bool_bool)(void* input, void* hx, void* params, void* has_biases, void* num_layers, void* dropout, void* train, void* bidirectional, void* batch_first);
  HOST_API void* lantern_gru_tensor_tensor_tensorlist_bool_intt_double_bool_bool_bool(void* input, void* hx, void* params, void* has_biases, void* num_layers, void* dropout, void* train, void* bidirectional, void* batch_first) { LANTERN_CHECK_LOADED void* ret = _lantern_gru_tensor_tensor_tensorlist_bool_intt_double_bool_bool_bool(input, hx, params, has_biases, num_layers, dropout, train, bidirectional, batch_first); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_gru_tensor_tensor_tensor_tensorlist_bool_intt_double_bool_bool)(void* data, void* batch_sizes, void* hx, void* params, void* has_biases, void* num_layers, void* dropout, void* train, void* bidirectional);
  HOST_API void* lantern_gru_tensor_tensor_tensor_tensorlist_bool_intt_double_bool_bool(void* data, void* batch_sizes, void* hx, void* params, void* has_biases, void* num_layers, void* dropout, void* train, void* bidirectional) { LANTERN_CHECK_LOADED void* ret = _lantern_gru_tensor_tensor_tensor_tensorlist_bool_intt_double_bool_bool(data, batch_sizes, hx, params, has_biases, num_layers, dropout, train, bidirectional); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_rnn_tanh_tensor_tensor_tensorlist_bool_intt_double_bool_bool_bool)(void* input, void* hx, void* params, void* has_biases, void* num_layers, void* dropout, void* train, void* bidirectional, void* batch_first);
  HOST_API void* lantern_rnn_tanh_tensor_tensor_tensorlist_bool_intt_double_bool_bool_bool(void* input, void* hx, void* params, void* has_biases, void* num_layers, void* dropout, void* train, void* bidirectional, void* batch_first) { LANTERN_CHECK_LOADED void* ret = _lantern_rnn_tanh_tensor_tensor_tensorlist_bool_intt_double_bool_bool_bool(input, hx, params, has_biases, num_layers, dropout, train, bidirectional, batch_first); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_rnn_tanh_tensor_tensor_tensor_tensorlist_bool_intt_double_bool_bool)(void* data, void* batch_sizes, void* hx, void* params, void* has_biases, void* num_layers, void* dropout, void* train, void* bidirectional);
  HOST_API void* lantern_rnn_tanh_tensor_tensor_tensor_tensorlist_bool_intt_double_bool_bool(void* data, void* batch_sizes, void* hx, void* params, void* has_biases, void* num_layers, void* dropout, void* train, void* bidirectional) { LANTERN_CHECK_LOADED void* ret = _lantern_rnn_tanh_tensor_tensor_tensor_tensorlist_bool_intt_double_bool_bool(data, batch_sizes, hx, params, has_biases, num_layers, dropout, train, bidirectional); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_rnn_relu_tensor_tensor_tensorlist_bool_intt_double_bool_bool_bool)(void* input, void* hx, void* params, void* has_biases, void* num_layers, void* dropout, void* train, void* bidirectional, void* batch_first);
  HOST_API void* lantern_rnn_relu_tensor_tensor_tensorlist_bool_intt_double_bool_bool_bool(void* input, void* hx, void* params, void* has_biases, void* num_layers, void* dropout, void* train, void* bidirectional, void* batch_first) { LANTERN_CHECK_LOADED void* ret = _lantern_rnn_relu_tensor_tensor_tensorlist_bool_intt_double_bool_bool_bool(input, hx, params, has_biases, num_layers, dropout, train, bidirectional, batch_first); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_rnn_relu_tensor_tensor_tensor_tensorlist_bool_intt_double_bool_bool)(void* data, void* batch_sizes, void* hx, void* params, void* has_biases, void* num_layers, void* dropout, void* train, void* bidirectional);
  HOST_API void* lantern_rnn_relu_tensor_tensor_tensor_tensorlist_bool_intt_double_bool_bool(void* data, void* batch_sizes, void* hx, void* params, void* has_biases, void* num_layers, void* dropout, void* train, void* bidirectional) { LANTERN_CHECK_LOADED void* ret = _lantern_rnn_relu_tensor_tensor_tensor_tensorlist_bool_intt_double_bool_bool(data, batch_sizes, hx, params, has_biases, num_layers, dropout, train, bidirectional); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_lstm_cell_tensor_tensorlist_tensor_tensor_tensor_tensor)(void* input, void* hx, void* w_ih, void* w_hh, void* b_ih, void* b_hh);
  HOST_API void* lantern_lstm_cell_tensor_tensorlist_tensor_tensor_tensor_tensor(void* input, void* hx, void* w_ih, void* w_hh, void* b_ih, void* b_hh) { LANTERN_CHECK_LOADED void* ret = _lantern_lstm_cell_tensor_tensorlist_tensor_tensor_tensor_tensor(input, hx, w_ih, w_hh, b_ih, b_hh); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_gru_cell_tensor_tensor_tensor_tensor_tensor_tensor)(void* input, void* hx, void* w_ih, void* w_hh, void* b_ih, void* b_hh);
  HOST_API void* lantern_gru_cell_tensor_tensor_tensor_tensor_tensor_tensor(void* input, void* hx, void* w_ih, void* w_hh, void* b_ih, void* b_hh) { LANTERN_CHECK_LOADED void* ret = _lantern_gru_cell_tensor_tensor_tensor_tensor_tensor_tensor(input, hx, w_ih, w_hh, b_ih, b_hh); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_rnn_tanh_cell_tensor_tensor_tensor_tensor_tensor_tensor)(void* input, void* hx, void* w_ih, void* w_hh, void* b_ih, void* b_hh);
  HOST_API void* lantern_rnn_tanh_cell_tensor_tensor_tensor_tensor_tensor_tensor(void* input, void* hx, void* w_ih, void* w_hh, void* b_ih, void* b_hh) { LANTERN_CHECK_LOADED void* ret = _lantern_rnn_tanh_cell_tensor_tensor_tensor_tensor_tensor_tensor(input, hx, w_ih, w_hh, b_ih, b_hh); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_rnn_relu_cell_tensor_tensor_tensor_tensor_tensor_tensor)(void* input, void* hx, void* w_ih, void* w_hh, void* b_ih, void* b_hh);
  HOST_API void* lantern_rnn_relu_cell_tensor_tensor_tensor_tensor_tensor_tensor(void* input, void* hx, void* w_ih, void* w_hh, void* b_ih, void* b_hh) { LANTERN_CHECK_LOADED void* ret = _lantern_rnn_relu_cell_tensor_tensor_tensor_tensor_tensor_tensor(input, hx, w_ih, w_hh, b_ih, b_hh); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_quantized_lstm_cell_tensor_tensorlist_tensor_tensor_tensor_tensor_tensor_tensor_tensor_tensor_scalar_scalar_scalar_scalar)(void* input, void* hx, void* w_ih, void* w_hh, void* b_ih, void* b_hh, void* packed_ih, void* packed_hh, void* col_offsets_ih, void* col_offsets_hh, void* scale_ih, void* scale_hh, void* zero_point_ih, void* zero_point_hh);
  HOST_API void* lantern_quantized_lstm_cell_tensor_tensorlist_tensor_tensor_tensor_tensor_tensor_tensor_tensor_tensor_scalar_scalar_scalar_scalar(void* input, void* hx, void* w_ih, void* w_hh, void* b_ih, void* b_hh, void* packed_ih, void* packed_hh, void* col_offsets_ih, void* col_offsets_hh, void* scale_ih, void* scale_hh, void* zero_point_ih, void* zero_point_hh) { LANTERN_CHECK_LOADED void* ret = _lantern_quantized_lstm_cell_tensor_tensorlist_tensor_tensor_tensor_tensor_tensor_tensor_tensor_tensor_scalar_scalar_scalar_scalar(input, hx, w_ih, w_hh, b_ih, b_hh, packed_ih, packed_hh, col_offsets_ih, col_offsets_hh, scale_ih, scale_hh, zero_point_ih, zero_point_hh); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_quantized_gru_cell_tensor_tensor_tensor_tensor_tensor_tensor_tensor_tensor_tensor_tensor_scalar_scalar_scalar_scalar)(void* input, void* hx, void* w_ih, void* w_hh, void* b_ih, void* b_hh, void* packed_ih, void* packed_hh, void* col_offsets_ih, void* col_offsets_hh, void* scale_ih, void* scale_hh, void* zero_point_ih, void* zero_point_hh);
  HOST_API void* lantern_quantized_gru_cell_tensor_tensor_tensor_tensor_tensor_tensor_tensor_tensor_tensor_tensor_scalar_scalar_scalar_scalar(void* input, void* hx, void* w_ih, void* w_hh, void* b_ih, void* b_hh, void* packed_ih, void* packed_hh, void* col_offsets_ih, void* col_offsets_hh, void* scale_ih, void* scale_hh, void* zero_point_ih, void* zero_point_hh) { LANTERN_CHECK_LOADED void* ret = _lantern_quantized_gru_cell_tensor_tensor_tensor_tensor_tensor_tensor_tensor_tensor_tensor_tensor_scalar_scalar_scalar_scalar(input, hx, w_ih, w_hh, b_ih, b_hh, packed_ih, packed_hh, col_offsets_ih, col_offsets_hh, scale_ih, scale_hh, zero_point_ih, zero_point_hh); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_quantized_rnn_relu_cell_tensor_tensor_tensor_tensor_tensor_tensor_tensor_tensor_tensor_tensor_scalar_scalar_scalar_scalar)(void* input, void* hx, void* w_ih, void* w_hh, void* b_ih, void* b_hh, void* packed_ih, void* packed_hh, void* col_offsets_ih, void* col_offsets_hh, void* scale_ih, void* scale_hh, void* zero_point_ih, void* zero_point_hh);
  HOST_API void* lantern_quantized_rnn_relu_cell_tensor_tensor_tensor_tensor_tensor_tensor_tensor_tensor_tensor_tensor_scalar_scalar_scalar_scalar(void* input, void* hx, void* w_ih, void* w_hh, void* b_ih, void* b_hh, void* packed_ih, void* packed_hh, void* col_offsets_ih, void* col_offsets_hh, void* scale_ih, void* scale_hh, void* zero_point_ih, void* zero_point_hh) { LANTERN_CHECK_LOADED void* ret = _lantern_quantized_rnn_relu_cell_tensor_tensor_tensor_tensor_tensor_tensor_tensor_tensor_tensor_tensor_scalar_scalar_scalar_scalar(input, hx, w_ih, w_hh, b_ih, b_hh, packed_ih, packed_hh, col_offsets_ih, col_offsets_hh, scale_ih, scale_hh, zero_point_ih, zero_point_hh); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_quantized_rnn_tanh_cell_tensor_tensor_tensor_tensor_tensor_tensor_tensor_tensor_tensor_tensor_scalar_scalar_scalar_scalar)(void* input, void* hx, void* w_ih, void* w_hh, void* b_ih, void* b_hh, void* packed_ih, void* packed_hh, void* col_offsets_ih, void* col_offsets_hh, void* scale_ih, void* scale_hh, void* zero_point_ih, void* zero_point_hh);
  HOST_API void* lantern_quantized_rnn_tanh_cell_tensor_tensor_tensor_tensor_tensor_tensor_tensor_tensor_tensor_tensor_scalar_scalar_scalar_scalar(void* input, void* hx, void* w_ih, void* w_hh, void* b_ih, void* b_hh, void* packed_ih, void* packed_hh, void* col_offsets_ih, void* col_offsets_hh, void* scale_ih, void* scale_hh, void* zero_point_ih, void* zero_point_hh) { LANTERN_CHECK_LOADED void* ret = _lantern_quantized_rnn_tanh_cell_tensor_tensor_tensor_tensor_tensor_tensor_tensor_tensor_tensor_tensor_scalar_scalar_scalar_scalar(input, hx, w_ih, w_hh, b_ih, b_hh, packed_ih, packed_hh, col_offsets_ih, col_offsets_hh, scale_ih, scale_hh, zero_point_ih, zero_point_hh); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__pack_padded_sequence_tensor_tensor_bool)(void* input, void* lengths, void* batch_first);
  HOST_API void* lantern__pack_padded_sequence_tensor_tensor_bool(void* input, void* lengths, void* batch_first) { LANTERN_CHECK_LOADED void* ret = _lantern__pack_padded_sequence_tensor_tensor_bool(input, lengths, batch_first); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__pack_padded_sequence_backward_tensor_intarrayref_tensor_bool)(void* grad, void* input_size, void* batch_sizes, void* batch_first);
  HOST_API void* lantern__pack_padded_sequence_backward_tensor_intarrayref_tensor_bool(void* grad, void* input_size, void* batch_sizes, void* batch_first) { LANTERN_CHECK_LOADED void* ret = _lantern__pack_padded_sequence_backward_tensor_intarrayref_tensor_bool(grad, input_size, batch_sizes, batch_first); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__pad_packed_sequence_tensor_tensor_bool_scalar_intt)(void* data, void* batch_sizes, void* batch_first, void* padding_value, void* total_length);
  HOST_API void* lantern__pad_packed_sequence_tensor_tensor_bool_scalar_intt(void* data, void* batch_sizes, void* batch_first, void* padding_value, void* total_length) { LANTERN_CHECK_LOADED void* ret = _lantern__pad_packed_sequence_tensor_tensor_bool_scalar_intt(data, batch_sizes, batch_first, padding_value, total_length); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_set__tensor_storage)(void* self, void* source);
  HOST_API void* lantern_Tensor_set__tensor_storage(void* self, void* source) { void* ret = _lantern_Tensor_set__tensor_storage(self, source); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_set__tensor_storage_intt_intarrayref_intarrayref)(void* self, void* source, void* storage_offset, void* size, void* stride);
  HOST_API void* lantern_Tensor_set__tensor_storage_intt_intarrayref_intarrayref(void* self, void* source, void* storage_offset, void* size, void* stride) { void* ret = _lantern_Tensor_set__tensor_storage_intt_intarrayref_intarrayref(self, source, storage_offset, size, stride); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_set__tensor_tensor_intt_intarrayref_intarrayref)(void* self, void* source, void* storage_offset, void* size, void* stride);
  HOST_API void* lantern_Tensor_set__tensor_tensor_intt_intarrayref_intarrayref(void* self, void* source, void* storage_offset, void* size, void* stride) { void* ret = _lantern_Tensor_set__tensor_tensor_intt_intarrayref_intarrayref(self, source, storage_offset, size, stride); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_set__tensor_tensor)(void* self, void* source);
  HOST_API void* lantern_Tensor_set__tensor_tensor(void* self, void* source) { void* ret = _lantern_Tensor_set__tensor_tensor(self, source); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_set__tensor)(void* self);
  HOST_API void* lantern_Tensor_set__tensor(void* self) { void* ret = _lantern_Tensor_set__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_lift_tensor)(void* self);
  HOST_API void* lantern_lift_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_lift_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_lift_fresh_tensor)(void* self);
  HOST_API void* lantern_lift_fresh_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_lift_fresh_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_lift_fresh_copy_tensor)(void* self);
  HOST_API void* lantern_lift_fresh_copy_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_lift_fresh_copy_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_is_set_to_tensor_tensor)(void* self, void* tensor);
  HOST_API void* lantern_Tensor_is_set_to_tensor_tensor(void* self, void* tensor) { void* ret = _lantern_Tensor_is_set_to_tensor_tensor(self, tensor); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_masked_fill__tensor_tensor_scalar)(void* self, void* mask, void* value);
  HOST_API void* lantern_Tensor_masked_fill__tensor_tensor_scalar(void* self, void* mask, void* value) { void* ret = _lantern_Tensor_masked_fill__tensor_tensor_scalar(self, mask, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_masked_fill_tensor_tensor_scalar)(void* self, void* mask, void* value);
  HOST_API void* lantern_masked_fill_tensor_tensor_scalar(void* self, void* mask, void* value) { LANTERN_CHECK_LOADED void* ret = _lantern_masked_fill_tensor_tensor_scalar(self, mask, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_masked_fill_tensor_tensor_scalar)(void* self, void* mask, void* value);
  HOST_API void* lantern_Tensor_masked_fill_tensor_tensor_scalar(void* self, void* mask, void* value) { void* ret = _lantern_Tensor_masked_fill_tensor_tensor_scalar(self, mask, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_masked_fill__tensor_tensor_tensor)(void* self, void* mask, void* value);
  HOST_API void* lantern_Tensor_masked_fill__tensor_tensor_tensor(void* self, void* mask, void* value) { void* ret = _lantern_Tensor_masked_fill__tensor_tensor_tensor(self, mask, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_masked_fill_tensor_tensor_tensor)(void* self, void* mask, void* value);
  HOST_API void* lantern_masked_fill_tensor_tensor_tensor(void* self, void* mask, void* value) { LANTERN_CHECK_LOADED void* ret = _lantern_masked_fill_tensor_tensor_tensor(self, mask, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_masked_fill_tensor_tensor_tensor)(void* self, void* mask, void* value);
  HOST_API void* lantern_Tensor_masked_fill_tensor_tensor_tensor(void* self, void* mask, void* value) { void* ret = _lantern_Tensor_masked_fill_tensor_tensor_tensor(self, mask, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_masked_scatter__tensor_tensor_tensor)(void* self, void* mask, void* source);
  HOST_API void* lantern_Tensor_masked_scatter__tensor_tensor_tensor(void* self, void* mask, void* source) { void* ret = _lantern_Tensor_masked_scatter__tensor_tensor_tensor(self, mask, source); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_masked_scatter_tensor_tensor_tensor)(void* self, void* mask, void* source);
  HOST_API void* lantern_masked_scatter_tensor_tensor_tensor(void* self, void* mask, void* source) { LANTERN_CHECK_LOADED void* ret = _lantern_masked_scatter_tensor_tensor_tensor(self, mask, source); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_masked_scatter_tensor_tensor_tensor)(void* self, void* mask, void* source);
  HOST_API void* lantern_Tensor_masked_scatter_tensor_tensor_tensor(void* self, void* mask, void* source) { void* ret = _lantern_Tensor_masked_scatter_tensor_tensor_tensor(self, mask, source); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__masked_softmax_tensor_tensor_intt_intt)(void* self, void* mask, void* dim, void* mask_type);
  HOST_API void* lantern__masked_softmax_tensor_tensor_intt_intt(void* self, void* mask, void* dim, void* mask_type) { LANTERN_CHECK_LOADED void* ret = _lantern__masked_softmax_tensor_tensor_intt_intt(self, mask, dim, mask_type); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__masked_softmax_backward_tensor_tensor_tensor_intt)(void* grad_output, void* output, void* mask, void* dim);
  HOST_API void* lantern__masked_softmax_backward_tensor_tensor_tensor_intt(void* grad_output, void* output, void* mask, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern__masked_softmax_backward_tensor_tensor_tensor_intt(grad_output, output, mask, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_view_tensor_intarrayref)(void* self, void* size);
  HOST_API void* lantern_Tensor_view_tensor_intarrayref(void* self, void* size) { void* ret = _lantern_Tensor_view_tensor_intarrayref(self, size); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_view_tensor_scalartype)(void* self, void* dtype);
  HOST_API void* lantern_Tensor_view_tensor_scalartype(void* self, void* dtype) { void* ret = _lantern_Tensor_view_tensor_scalartype(self, dtype); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_put__tensor_tensor_tensor_bool)(void* self, void* index, void* source, void* accumulate);
  HOST_API void* lantern_Tensor_put__tensor_tensor_tensor_bool(void* self, void* index, void* source, void* accumulate) { void* ret = _lantern_Tensor_put__tensor_tensor_tensor_bool(self, index, source, accumulate); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_put_tensor_tensor_tensor_bool)(void* self, void* index, void* source, void* accumulate);
  HOST_API void* lantern_put_tensor_tensor_tensor_bool(void* self, void* index, void* source, void* accumulate) { LANTERN_CHECK_LOADED void* ret = _lantern_put_tensor_tensor_tensor_bool(self, index, source, accumulate); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_put_tensor_tensor_tensor_bool)(void* self, void* index, void* source, void* accumulate);
  HOST_API void* lantern_Tensor_put_tensor_tensor_tensor_bool(void* self, void* index, void* source, void* accumulate) { void* ret = _lantern_Tensor_put_tensor_tensor_tensor_bool(self, index, source, accumulate); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_index_add_out_tensor_tensor_intt_tensor_tensor_scalar)(void* out, void* self, void* dim, void* index, void* source, void* alpha);
  HOST_API void* lantern_index_add_out_tensor_tensor_intt_tensor_tensor_scalar(void* out, void* self, void* dim, void* index, void* source, void* alpha) { LANTERN_CHECK_LOADED void* ret = _lantern_index_add_out_tensor_tensor_intt_tensor_tensor_scalar(out, self, dim, index, source, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_index_add__tensor_intt_tensor_tensor_scalar)(void* self, void* dim, void* index, void* source, void* alpha);
  HOST_API void* lantern_Tensor_index_add__tensor_intt_tensor_tensor_scalar(void* self, void* dim, void* index, void* source, void* alpha) { void* ret = _lantern_Tensor_index_add__tensor_intt_tensor_tensor_scalar(self, dim, index, source, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_index_add_tensor_intt_tensor_tensor_scalar)(void* self, void* dim, void* index, void* source, void* alpha);
  HOST_API void* lantern_index_add_tensor_intt_tensor_tensor_scalar(void* self, void* dim, void* index, void* source, void* alpha) { LANTERN_CHECK_LOADED void* ret = _lantern_index_add_tensor_intt_tensor_tensor_scalar(self, dim, index, source, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_index_add_tensor_intt_tensor_tensor_scalar)(void* self, void* dim, void* index, void* source, void* alpha);
  HOST_API void* lantern_Tensor_index_add_tensor_intt_tensor_tensor_scalar(void* self, void* dim, void* index, void* source, void* alpha) { void* ret = _lantern_Tensor_index_add_tensor_intt_tensor_tensor_scalar(self, dim, index, source, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_index_add_tensor_dimname_tensor_tensor_scalar)(void* self, void* dim, void* index, void* source, void* alpha);
  HOST_API void* lantern_index_add_tensor_dimname_tensor_tensor_scalar(void* self, void* dim, void* index, void* source, void* alpha) { LANTERN_CHECK_LOADED void* ret = _lantern_index_add_tensor_dimname_tensor_tensor_scalar(self, dim, index, source, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_index_add_tensor_dimname_tensor_tensor_scalar)(void* self, void* dim, void* index, void* source, void* alpha);
  HOST_API void* lantern_Tensor_index_add_tensor_dimname_tensor_tensor_scalar(void* self, void* dim, void* index, void* source, void* alpha) { void* ret = _lantern_Tensor_index_add_tensor_dimname_tensor_tensor_scalar(self, dim, index, source, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_index_reduce_out_tensor_tensor_intt_tensor_tensor_cstringview_bool)(void* out, void* self, void* dim, void* index, void* source, void* reduce, void* include_self);
  HOST_API void* lantern_index_reduce_out_tensor_tensor_intt_tensor_tensor_cstringview_bool(void* out, void* self, void* dim, void* index, void* source, void* reduce, void* include_self) { LANTERN_CHECK_LOADED void* ret = _lantern_index_reduce_out_tensor_tensor_intt_tensor_tensor_cstringview_bool(out, self, dim, index, source, reduce, include_self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_index_reduce__tensor_intt_tensor_tensor_cstringview_bool)(void* self, void* dim, void* index, void* source, void* reduce, void* include_self);
  HOST_API void* lantern_Tensor_index_reduce__tensor_intt_tensor_tensor_cstringview_bool(void* self, void* dim, void* index, void* source, void* reduce, void* include_self) { void* ret = _lantern_Tensor_index_reduce__tensor_intt_tensor_tensor_cstringview_bool(self, dim, index, source, reduce, include_self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_index_reduce_tensor_intt_tensor_tensor_cstringview_bool)(void* self, void* dim, void* index, void* source, void* reduce, void* include_self);
  HOST_API void* lantern_index_reduce_tensor_intt_tensor_tensor_cstringview_bool(void* self, void* dim, void* index, void* source, void* reduce, void* include_self) { LANTERN_CHECK_LOADED void* ret = _lantern_index_reduce_tensor_intt_tensor_tensor_cstringview_bool(self, dim, index, source, reduce, include_self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_index_reduce_tensor_intt_tensor_tensor_cstringview_bool)(void* self, void* dim, void* index, void* source, void* reduce, void* include_self);
  HOST_API void* lantern_Tensor_index_reduce_tensor_intt_tensor_tensor_cstringview_bool(void* self, void* dim, void* index, void* source, void* reduce, void* include_self) { void* ret = _lantern_Tensor_index_reduce_tensor_intt_tensor_tensor_cstringview_bool(self, dim, index, source, reduce, include_self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_index_fill__tensor_intt_tensor_scalar)(void* self, void* dim, void* index, void* value);
  HOST_API void* lantern_Tensor_index_fill__tensor_intt_tensor_scalar(void* self, void* dim, void* index, void* value) { void* ret = _lantern_Tensor_index_fill__tensor_intt_tensor_scalar(self, dim, index, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_index_fill_tensor_intt_tensor_scalar)(void* self, void* dim, void* index, void* value);
  HOST_API void* lantern_index_fill_tensor_intt_tensor_scalar(void* self, void* dim, void* index, void* value) { LANTERN_CHECK_LOADED void* ret = _lantern_index_fill_tensor_intt_tensor_scalar(self, dim, index, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_index_fill_tensor_intt_tensor_scalar)(void* self, void* dim, void* index, void* value);
  HOST_API void* lantern_Tensor_index_fill_tensor_intt_tensor_scalar(void* self, void* dim, void* index, void* value) { void* ret = _lantern_Tensor_index_fill_tensor_intt_tensor_scalar(self, dim, index, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_index_fill__tensor_intt_tensor_tensor)(void* self, void* dim, void* index, void* value);
  HOST_API void* lantern_Tensor_index_fill__tensor_intt_tensor_tensor(void* self, void* dim, void* index, void* value) { void* ret = _lantern_Tensor_index_fill__tensor_intt_tensor_tensor(self, dim, index, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_index_fill_tensor_intt_tensor_tensor)(void* self, void* dim, void* index, void* value);
  HOST_API void* lantern_index_fill_tensor_intt_tensor_tensor(void* self, void* dim, void* index, void* value) { LANTERN_CHECK_LOADED void* ret = _lantern_index_fill_tensor_intt_tensor_tensor(self, dim, index, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_index_fill_tensor_intt_tensor_tensor)(void* self, void* dim, void* index, void* value);
  HOST_API void* lantern_Tensor_index_fill_tensor_intt_tensor_tensor(void* self, void* dim, void* index, void* value) { void* ret = _lantern_Tensor_index_fill_tensor_intt_tensor_tensor(self, dim, index, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_index_fill__tensor_dimname_tensor_scalar)(void* self, void* dim, void* index, void* value);
  HOST_API void* lantern_Tensor_index_fill__tensor_dimname_tensor_scalar(void* self, void* dim, void* index, void* value) { void* ret = _lantern_Tensor_index_fill__tensor_dimname_tensor_scalar(self, dim, index, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_index_fill__tensor_dimname_tensor_tensor)(void* self, void* dim, void* index, void* value);
  HOST_API void* lantern_Tensor_index_fill__tensor_dimname_tensor_tensor(void* self, void* dim, void* index, void* value) { void* ret = _lantern_Tensor_index_fill__tensor_dimname_tensor_tensor(self, dim, index, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_index_fill_tensor_dimname_tensor_scalar)(void* self, void* dim, void* index, void* value);
  HOST_API void* lantern_index_fill_tensor_dimname_tensor_scalar(void* self, void* dim, void* index, void* value) { LANTERN_CHECK_LOADED void* ret = _lantern_index_fill_tensor_dimname_tensor_scalar(self, dim, index, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_index_fill_tensor_dimname_tensor_scalar)(void* self, void* dim, void* index, void* value);
  HOST_API void* lantern_Tensor_index_fill_tensor_dimname_tensor_scalar(void* self, void* dim, void* index, void* value) { void* ret = _lantern_Tensor_index_fill_tensor_dimname_tensor_scalar(self, dim, index, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_index_fill_tensor_dimname_tensor_tensor)(void* self, void* dim, void* index, void* value);
  HOST_API void* lantern_index_fill_tensor_dimname_tensor_tensor(void* self, void* dim, void* index, void* value) { LANTERN_CHECK_LOADED void* ret = _lantern_index_fill_tensor_dimname_tensor_tensor(self, dim, index, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_index_fill_tensor_dimname_tensor_tensor)(void* self, void* dim, void* index, void* value);
  HOST_API void* lantern_Tensor_index_fill_tensor_dimname_tensor_tensor(void* self, void* dim, void* index, void* value) { void* ret = _lantern_Tensor_index_fill_tensor_dimname_tensor_tensor(self, dim, index, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_scatter_tensor_intt_tensor_tensor)(void* self, void* dim, void* index, void* src);
  HOST_API void* lantern_scatter_tensor_intt_tensor_tensor(void* self, void* dim, void* index, void* src) { LANTERN_CHECK_LOADED void* ret = _lantern_scatter_tensor_intt_tensor_tensor(self, dim, index, src); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_scatter_tensor_intt_tensor_tensor)(void* self, void* dim, void* index, void* src);
  HOST_API void* lantern_Tensor_scatter_tensor_intt_tensor_tensor(void* self, void* dim, void* index, void* src) { void* ret = _lantern_Tensor_scatter_tensor_intt_tensor_tensor(self, dim, index, src); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_scatter__tensor_intt_tensor_tensor)(void* self, void* dim, void* index, void* src);
  HOST_API void* lantern_Tensor_scatter__tensor_intt_tensor_tensor(void* self, void* dim, void* index, void* src) { void* ret = _lantern_Tensor_scatter__tensor_intt_tensor_tensor(self, dim, index, src); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_scatter_out_tensor_tensor_intt_tensor_tensor)(void* out, void* self, void* dim, void* index, void* src);
  HOST_API void* lantern_scatter_out_tensor_tensor_intt_tensor_tensor(void* out, void* self, void* dim, void* index, void* src) { LANTERN_CHECK_LOADED void* ret = _lantern_scatter_out_tensor_tensor_intt_tensor_tensor(out, self, dim, index, src); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_scatter_tensor_intt_tensor_scalar)(void* self, void* dim, void* index, void* value);
  HOST_API void* lantern_scatter_tensor_intt_tensor_scalar(void* self, void* dim, void* index, void* value) { LANTERN_CHECK_LOADED void* ret = _lantern_scatter_tensor_intt_tensor_scalar(self, dim, index, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_scatter_tensor_intt_tensor_scalar)(void* self, void* dim, void* index, void* value);
  HOST_API void* lantern_Tensor_scatter_tensor_intt_tensor_scalar(void* self, void* dim, void* index, void* value) { void* ret = _lantern_Tensor_scatter_tensor_intt_tensor_scalar(self, dim, index, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_scatter__tensor_intt_tensor_scalar)(void* self, void* dim, void* index, void* value);
  HOST_API void* lantern_Tensor_scatter__tensor_intt_tensor_scalar(void* self, void* dim, void* index, void* value) { void* ret = _lantern_Tensor_scatter__tensor_intt_tensor_scalar(self, dim, index, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_scatter_out_tensor_tensor_intt_tensor_scalar)(void* out, void* self, void* dim, void* index, void* value);
  HOST_API void* lantern_scatter_out_tensor_tensor_intt_tensor_scalar(void* out, void* self, void* dim, void* index, void* value) { LANTERN_CHECK_LOADED void* ret = _lantern_scatter_out_tensor_tensor_intt_tensor_scalar(out, self, dim, index, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_scatter_tensor_intt_tensor_tensor_cstringview)(void* self, void* dim, void* index, void* src, void* reduce);
  HOST_API void* lantern_scatter_tensor_intt_tensor_tensor_cstringview(void* self, void* dim, void* index, void* src, void* reduce) { LANTERN_CHECK_LOADED void* ret = _lantern_scatter_tensor_intt_tensor_tensor_cstringview(self, dim, index, src, reduce); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_scatter_tensor_intt_tensor_tensor_cstringview)(void* self, void* dim, void* index, void* src, void* reduce);
  HOST_API void* lantern_Tensor_scatter_tensor_intt_tensor_tensor_cstringview(void* self, void* dim, void* index, void* src, void* reduce) { void* ret = _lantern_Tensor_scatter_tensor_intt_tensor_tensor_cstringview(self, dim, index, src, reduce); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_scatter__tensor_intt_tensor_tensor_cstringview)(void* self, void* dim, void* index, void* src, void* reduce);
  HOST_API void* lantern_Tensor_scatter__tensor_intt_tensor_tensor_cstringview(void* self, void* dim, void* index, void* src, void* reduce) { void* ret = _lantern_Tensor_scatter__tensor_intt_tensor_tensor_cstringview(self, dim, index, src, reduce); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_scatter_out_tensor_tensor_intt_tensor_tensor_cstringview)(void* out, void* self, void* dim, void* index, void* src, void* reduce);
  HOST_API void* lantern_scatter_out_tensor_tensor_intt_tensor_tensor_cstringview(void* out, void* self, void* dim, void* index, void* src, void* reduce) { LANTERN_CHECK_LOADED void* ret = _lantern_scatter_out_tensor_tensor_intt_tensor_tensor_cstringview(out, self, dim, index, src, reduce); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_scatter_tensor_intt_tensor_scalar_cstringview)(void* self, void* dim, void* index, void* value, void* reduce);
  HOST_API void* lantern_scatter_tensor_intt_tensor_scalar_cstringview(void* self, void* dim, void* index, void* value, void* reduce) { LANTERN_CHECK_LOADED void* ret = _lantern_scatter_tensor_intt_tensor_scalar_cstringview(self, dim, index, value, reduce); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_scatter_tensor_intt_tensor_scalar_cstringview)(void* self, void* dim, void* index, void* value, void* reduce);
  HOST_API void* lantern_Tensor_scatter_tensor_intt_tensor_scalar_cstringview(void* self, void* dim, void* index, void* value, void* reduce) { void* ret = _lantern_Tensor_scatter_tensor_intt_tensor_scalar_cstringview(self, dim, index, value, reduce); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_scatter__tensor_intt_tensor_scalar_cstringview)(void* self, void* dim, void* index, void* value, void* reduce);
  HOST_API void* lantern_Tensor_scatter__tensor_intt_tensor_scalar_cstringview(void* self, void* dim, void* index, void* value, void* reduce) { void* ret = _lantern_Tensor_scatter__tensor_intt_tensor_scalar_cstringview(self, dim, index, value, reduce); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_scatter_out_tensor_tensor_intt_tensor_scalar_cstringview)(void* out, void* self, void* dim, void* index, void* value, void* reduce);
  HOST_API void* lantern_scatter_out_tensor_tensor_intt_tensor_scalar_cstringview(void* out, void* self, void* dim, void* index, void* value, void* reduce) { LANTERN_CHECK_LOADED void* ret = _lantern_scatter_out_tensor_tensor_intt_tensor_scalar_cstringview(out, self, dim, index, value, reduce); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_scatter_tensor_dimname_tensor_tensor)(void* self, void* dim, void* index, void* src);
  HOST_API void* lantern_scatter_tensor_dimname_tensor_tensor(void* self, void* dim, void* index, void* src) { LANTERN_CHECK_LOADED void* ret = _lantern_scatter_tensor_dimname_tensor_tensor(self, dim, index, src); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_scatter_tensor_dimname_tensor_tensor)(void* self, void* dim, void* index, void* src);
  HOST_API void* lantern_Tensor_scatter_tensor_dimname_tensor_tensor(void* self, void* dim, void* index, void* src) { void* ret = _lantern_Tensor_scatter_tensor_dimname_tensor_tensor(self, dim, index, src); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_scatter_tensor_dimname_tensor_scalar)(void* self, void* dim, void* index, void* value);
  HOST_API void* lantern_scatter_tensor_dimname_tensor_scalar(void* self, void* dim, void* index, void* value) { LANTERN_CHECK_LOADED void* ret = _lantern_scatter_tensor_dimname_tensor_scalar(self, dim, index, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_scatter_tensor_dimname_tensor_scalar)(void* self, void* dim, void* index, void* value);
  HOST_API void* lantern_Tensor_scatter_tensor_dimname_tensor_scalar(void* self, void* dim, void* index, void* value) { void* ret = _lantern_Tensor_scatter_tensor_dimname_tensor_scalar(self, dim, index, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_scatter_add_tensor_intt_tensor_tensor)(void* self, void* dim, void* index, void* src);
  HOST_API void* lantern_scatter_add_tensor_intt_tensor_tensor(void* self, void* dim, void* index, void* src) { LANTERN_CHECK_LOADED void* ret = _lantern_scatter_add_tensor_intt_tensor_tensor(self, dim, index, src); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_scatter_add_tensor_intt_tensor_tensor)(void* self, void* dim, void* index, void* src);
  HOST_API void* lantern_Tensor_scatter_add_tensor_intt_tensor_tensor(void* self, void* dim, void* index, void* src) { void* ret = _lantern_Tensor_scatter_add_tensor_intt_tensor_tensor(self, dim, index, src); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_scatter_add__tensor_intt_tensor_tensor)(void* self, void* dim, void* index, void* src);
  HOST_API void* lantern_Tensor_scatter_add__tensor_intt_tensor_tensor(void* self, void* dim, void* index, void* src) { void* ret = _lantern_Tensor_scatter_add__tensor_intt_tensor_tensor(self, dim, index, src); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_scatter_add_out_tensor_tensor_intt_tensor_tensor)(void* out, void* self, void* dim, void* index, void* src);
  HOST_API void* lantern_scatter_add_out_tensor_tensor_intt_tensor_tensor(void* out, void* self, void* dim, void* index, void* src) { LANTERN_CHECK_LOADED void* ret = _lantern_scatter_add_out_tensor_tensor_intt_tensor_tensor(out, self, dim, index, src); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_scatter_add_tensor_dimname_tensor_tensor)(void* self, void* dim, void* index, void* src);
  HOST_API void* lantern_scatter_add_tensor_dimname_tensor_tensor(void* self, void* dim, void* index, void* src) { LANTERN_CHECK_LOADED void* ret = _lantern_scatter_add_tensor_dimname_tensor_tensor(self, dim, index, src); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_scatter_add_tensor_dimname_tensor_tensor)(void* self, void* dim, void* index, void* src);
  HOST_API void* lantern_Tensor_scatter_add_tensor_dimname_tensor_tensor(void* self, void* dim, void* index, void* src) { void* ret = _lantern_Tensor_scatter_add_tensor_dimname_tensor_tensor(self, dim, index, src); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_scatter_reduce_tensor_intt_tensor_tensor_cstringview_bool)(void* self, void* dim, void* index, void* src, void* reduce, void* include_self);
  HOST_API void* lantern_scatter_reduce_tensor_intt_tensor_tensor_cstringview_bool(void* self, void* dim, void* index, void* src, void* reduce, void* include_self) { LANTERN_CHECK_LOADED void* ret = _lantern_scatter_reduce_tensor_intt_tensor_tensor_cstringview_bool(self, dim, index, src, reduce, include_self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_scatter_reduce_tensor_intt_tensor_tensor_cstringview_bool)(void* self, void* dim, void* index, void* src, void* reduce, void* include_self);
  HOST_API void* lantern_Tensor_scatter_reduce_tensor_intt_tensor_tensor_cstringview_bool(void* self, void* dim, void* index, void* src, void* reduce, void* include_self) { void* ret = _lantern_Tensor_scatter_reduce_tensor_intt_tensor_tensor_cstringview_bool(self, dim, index, src, reduce, include_self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_scatter_reduce__tensor_intt_tensor_tensor_cstringview_bool)(void* self, void* dim, void* index, void* src, void* reduce, void* include_self);
  HOST_API void* lantern_Tensor_scatter_reduce__tensor_intt_tensor_tensor_cstringview_bool(void* self, void* dim, void* index, void* src, void* reduce, void* include_self) { void* ret = _lantern_Tensor_scatter_reduce__tensor_intt_tensor_tensor_cstringview_bool(self, dim, index, src, reduce, include_self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_scatter_reduce_out_tensor_tensor_intt_tensor_tensor_cstringview_bool)(void* out, void* self, void* dim, void* index, void* src, void* reduce, void* include_self);
  HOST_API void* lantern_scatter_reduce_out_tensor_tensor_intt_tensor_tensor_cstringview_bool(void* out, void* self, void* dim, void* index, void* src, void* reduce, void* include_self) { LANTERN_CHECK_LOADED void* ret = _lantern_scatter_reduce_out_tensor_tensor_intt_tensor_tensor_cstringview_bool(out, self, dim, index, src, reduce, include_self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_eq__tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_eq__tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_eq__tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_eq__tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_eq__tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_eq__tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_bitwise_and_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_bitwise_and_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_bitwise_and_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_bitwise_and_out_tensor_tensor_scalar)(void* out, void* self, void* other);
  HOST_API void* lantern_bitwise_and_out_tensor_tensor_scalar(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_bitwise_and_out_tensor_tensor_scalar(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_bitwise_and_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_bitwise_and_tensor_scalar(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_bitwise_and_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_bitwise_and_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_bitwise_and_tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_bitwise_and_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_bitwise_and_scalar_tensor)(void* self, void* other);
  HOST_API void* lantern_bitwise_and_scalar_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_bitwise_and_scalar_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_bitwise_and_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_bitwise_and_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_bitwise_and_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_bitwise_and_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_bitwise_and_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_bitwise_and_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_bitwise_and__tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_bitwise_and__tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_bitwise_and__tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_bitwise_and__tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_bitwise_and__tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_bitwise_and__tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern___and___tensor_scalar)(void* self, void* other);
  HOST_API void* lantern___and___tensor_scalar(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern___and___tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor___and___tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor___and___tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor___and___tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern___and___tensor_tensor)(void* self, void* other);
  HOST_API void* lantern___and___tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern___and___tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor___and___tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor___and___tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor___and___tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor___iand___tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor___iand___tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor___iand___tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor___iand___tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor___iand___tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor___iand___tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_bitwise_or_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_bitwise_or_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_bitwise_or_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_bitwise_or_out_tensor_tensor_scalar)(void* out, void* self, void* other);
  HOST_API void* lantern_bitwise_or_out_tensor_tensor_scalar(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_bitwise_or_out_tensor_tensor_scalar(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_bitwise_or_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_bitwise_or_tensor_scalar(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_bitwise_or_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_bitwise_or_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_bitwise_or_tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_bitwise_or_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_bitwise_or_scalar_tensor)(void* self, void* other);
  HOST_API void* lantern_bitwise_or_scalar_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_bitwise_or_scalar_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_bitwise_or_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_bitwise_or_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_bitwise_or_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_bitwise_or_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_bitwise_or_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_bitwise_or_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_bitwise_or__tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_bitwise_or__tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_bitwise_or__tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_bitwise_or__tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_bitwise_or__tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_bitwise_or__tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern___or___tensor_scalar)(void* self, void* other);
  HOST_API void* lantern___or___tensor_scalar(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern___or___tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor___or___tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor___or___tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor___or___tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern___or___tensor_tensor)(void* self, void* other);
  HOST_API void* lantern___or___tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern___or___tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor___or___tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor___or___tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor___or___tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor___ior___tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor___ior___tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor___ior___tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor___ior___tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor___ior___tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor___ior___tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_bitwise_xor_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_bitwise_xor_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_bitwise_xor_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_bitwise_xor_out_tensor_tensor_scalar)(void* out, void* self, void* other);
  HOST_API void* lantern_bitwise_xor_out_tensor_tensor_scalar(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_bitwise_xor_out_tensor_tensor_scalar(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_bitwise_xor_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_bitwise_xor_tensor_scalar(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_bitwise_xor_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_bitwise_xor_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_bitwise_xor_tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_bitwise_xor_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_bitwise_xor_scalar_tensor)(void* self, void* other);
  HOST_API void* lantern_bitwise_xor_scalar_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_bitwise_xor_scalar_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_bitwise_xor_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_bitwise_xor_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_bitwise_xor_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_bitwise_xor_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_bitwise_xor_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_bitwise_xor_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_bitwise_xor__tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_bitwise_xor__tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_bitwise_xor__tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_bitwise_xor__tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_bitwise_xor__tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_bitwise_xor__tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern___xor___tensor_scalar)(void* self, void* other);
  HOST_API void* lantern___xor___tensor_scalar(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern___xor___tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor___xor___tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor___xor___tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor___xor___tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern___xor___tensor_tensor)(void* self, void* other);
  HOST_API void* lantern___xor___tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern___xor___tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor___xor___tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor___xor___tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor___xor___tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor___ixor___tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor___ixor___tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor___ixor___tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor___ixor___tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor___ixor___tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor___ixor___tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern___lshift___tensor_scalar)(void* self, void* other);
  HOST_API void* lantern___lshift___tensor_scalar(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern___lshift___tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor___lshift___tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor___lshift___tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor___lshift___tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern___lshift___tensor_tensor)(void* self, void* other);
  HOST_API void* lantern___lshift___tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern___lshift___tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor___lshift___tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor___lshift___tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor___lshift___tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor___ilshift___tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor___ilshift___tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor___ilshift___tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor___ilshift___tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor___ilshift___tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor___ilshift___tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_bitwise_left_shift_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_bitwise_left_shift_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_bitwise_left_shift_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_bitwise_left_shift_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_bitwise_left_shift_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_bitwise_left_shift_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_bitwise_left_shift__tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_bitwise_left_shift__tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_bitwise_left_shift__tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_bitwise_left_shift_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_bitwise_left_shift_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_bitwise_left_shift_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_bitwise_left_shift_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_bitwise_left_shift_tensor_scalar(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_bitwise_left_shift_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_bitwise_left_shift_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_bitwise_left_shift_tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_bitwise_left_shift_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_bitwise_left_shift__tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_bitwise_left_shift__tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_bitwise_left_shift__tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_bitwise_left_shift_out_tensor_tensor_scalar)(void* out, void* self, void* other);
  HOST_API void* lantern_bitwise_left_shift_out_tensor_tensor_scalar(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_bitwise_left_shift_out_tensor_tensor_scalar(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_bitwise_left_shift_scalar_tensor)(void* self, void* other);
  HOST_API void* lantern_bitwise_left_shift_scalar_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_bitwise_left_shift_scalar_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern___rshift___tensor_scalar)(void* self, void* other);
  HOST_API void* lantern___rshift___tensor_scalar(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern___rshift___tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor___rshift___tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor___rshift___tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor___rshift___tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern___rshift___tensor_tensor)(void* self, void* other);
  HOST_API void* lantern___rshift___tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern___rshift___tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor___rshift___tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor___rshift___tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor___rshift___tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor___irshift___tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor___irshift___tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor___irshift___tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor___irshift___tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor___irshift___tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor___irshift___tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_bitwise_right_shift_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_bitwise_right_shift_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_bitwise_right_shift_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_bitwise_right_shift_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_bitwise_right_shift_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_bitwise_right_shift_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_bitwise_right_shift__tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_bitwise_right_shift__tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_bitwise_right_shift__tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_bitwise_right_shift_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_bitwise_right_shift_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_bitwise_right_shift_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_bitwise_right_shift_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_bitwise_right_shift_tensor_scalar(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_bitwise_right_shift_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_bitwise_right_shift_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_bitwise_right_shift_tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_bitwise_right_shift_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_bitwise_right_shift__tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_bitwise_right_shift__tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_bitwise_right_shift__tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_bitwise_right_shift_out_tensor_tensor_scalar)(void* out, void* self, void* other);
  HOST_API void* lantern_bitwise_right_shift_out_tensor_tensor_scalar(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_bitwise_right_shift_out_tensor_tensor_scalar(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_bitwise_right_shift_scalar_tensor)(void* self, void* other);
  HOST_API void* lantern_bitwise_right_shift_scalar_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_bitwise_right_shift_scalar_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_tril__tensor_intt)(void* self, void* diagonal);
  HOST_API void* lantern_Tensor_tril__tensor_intt(void* self, void* diagonal) { void* ret = _lantern_Tensor_tril__tensor_intt(self, diagonal); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_triu__tensor_intt)(void* self, void* diagonal);
  HOST_API void* lantern_Tensor_triu__tensor_intt(void* self, void* diagonal) { void* ret = _lantern_Tensor_triu__tensor_intt(self, diagonal); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_digamma__tensor)(void* self);
  HOST_API void* lantern_Tensor_digamma__tensor(void* self) { void* ret = _lantern_Tensor_digamma__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_lerp__tensor_tensor_scalar)(void* self, void* end, void* weight);
  HOST_API void* lantern_Tensor_lerp__tensor_tensor_scalar(void* self, void* end, void* weight) { void* ret = _lantern_Tensor_lerp__tensor_tensor_scalar(self, end, weight); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_lerp__tensor_tensor_tensor)(void* self, void* end, void* weight);
  HOST_API void* lantern_Tensor_lerp__tensor_tensor_tensor(void* self, void* end, void* weight) { void* ret = _lantern_Tensor_lerp__tensor_tensor_tensor(self, end, weight); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_addbmm__tensor_tensor_tensor_scalar_scalar)(void* self, void* batch1, void* batch2, void* beta, void* alpha);
  HOST_API void* lantern_Tensor_addbmm__tensor_tensor_tensor_scalar_scalar(void* self, void* batch1, void* batch2, void* beta, void* alpha) { void* ret = _lantern_Tensor_addbmm__tensor_tensor_tensor_scalar_scalar(self, batch1, batch2, beta, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_addbmm_out_tensor_tensor_tensor_tensor_scalar_scalar)(void* out, void* self, void* batch1, void* batch2, void* beta, void* alpha);
  HOST_API void* lantern_addbmm_out_tensor_tensor_tensor_tensor_scalar_scalar(void* out, void* self, void* batch1, void* batch2, void* beta, void* alpha) { LANTERN_CHECK_LOADED void* ret = _lantern_addbmm_out_tensor_tensor_tensor_tensor_scalar_scalar(out, self, batch1, batch2, beta, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_addbmm_tensor_tensor_tensor_scalar_scalar)(void* self, void* batch1, void* batch2, void* beta, void* alpha);
  HOST_API void* lantern_addbmm_tensor_tensor_tensor_scalar_scalar(void* self, void* batch1, void* batch2, void* beta, void* alpha) { LANTERN_CHECK_LOADED void* ret = _lantern_addbmm_tensor_tensor_tensor_scalar_scalar(self, batch1, batch2, beta, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_addbmm_tensor_tensor_tensor_scalar_scalar)(void* self, void* batch1, void* batch2, void* beta, void* alpha);
  HOST_API void* lantern_Tensor_addbmm_tensor_tensor_tensor_scalar_scalar(void* self, void* batch1, void* batch2, void* beta, void* alpha) { void* ret = _lantern_Tensor_addbmm_tensor_tensor_tensor_scalar_scalar(self, batch1, batch2, beta, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_random__tensor_intt_intt_generator)(void* self, void* from, void* to, void* generator);
  HOST_API void* lantern_Tensor_random__tensor_intt_intt_generator(void* self, void* from, void* to, void* generator) { void* ret = _lantern_Tensor_random__tensor_intt_intt_generator(self, from, to, generator); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_random__tensor_intt_generator)(void* self, void* to, void* generator);
  HOST_API void* lantern_Tensor_random__tensor_intt_generator(void* self, void* to, void* generator) { void* ret = _lantern_Tensor_random__tensor_intt_generator(self, to, generator); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_random__tensor_generator)(void* self, void* generator);
  HOST_API void* lantern_Tensor_random__tensor_generator(void* self, void* generator) { void* ret = _lantern_Tensor_random__tensor_generator(self, generator); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_uniform__tensor_double_double_generator)(void* self, void* from, void* to, void* generator);
  HOST_API void* lantern_Tensor_uniform__tensor_double_double_generator(void* self, void* from, void* to, void* generator) { void* ret = _lantern_Tensor_uniform__tensor_double_double_generator(self, from, to, generator); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_cauchy__tensor_double_double_generator)(void* self, void* median, void* sigma, void* generator);
  HOST_API void* lantern_Tensor_cauchy__tensor_double_double_generator(void* self, void* median, void* sigma, void* generator) { void* ret = _lantern_Tensor_cauchy__tensor_double_double_generator(self, median, sigma, generator); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_log_normal__tensor_double_double_generator)(void* self, void* mean, void* std, void* generator);
  HOST_API void* lantern_Tensor_log_normal__tensor_double_double_generator(void* self, void* mean, void* std, void* generator) { void* ret = _lantern_Tensor_log_normal__tensor_double_double_generator(self, mean, std, generator); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_exponential__tensor_double_generator)(void* self, void* lambd, void* generator);
  HOST_API void* lantern_Tensor_exponential__tensor_double_generator(void* self, void* lambd, void* generator) { void* ret = _lantern_Tensor_exponential__tensor_double_generator(self, lambd, generator); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_geometric__tensor_double_generator)(void* self, void* p, void* generator);
  HOST_API void* lantern_Tensor_geometric__tensor_double_generator(void* self, void* p, void* generator) { void* ret = _lantern_Tensor_geometric__tensor_double_generator(self, p, generator); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_diag_out_tensor_tensor_intt)(void* out, void* self, void* diagonal);
  HOST_API void* lantern_diag_out_tensor_tensor_intt(void* out, void* self, void* diagonal) { LANTERN_CHECK_LOADED void* ret = _lantern_diag_out_tensor_tensor_intt(out, self, diagonal); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_diag_tensor_intt)(void* self, void* diagonal);
  HOST_API void* lantern_diag_tensor_intt(void* self, void* diagonal) { LANTERN_CHECK_LOADED void* ret = _lantern_diag_tensor_intt(self, diagonal); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_diag_tensor_intt)(void* self, void* diagonal);
  HOST_API void* lantern_Tensor_diag_tensor_intt(void* self, void* diagonal) { void* ret = _lantern_Tensor_diag_tensor_intt(self, diagonal); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_diag_backward_tensor_intarrayref_intt)(void* grad, void* input_sizes, void* diagonal);
  HOST_API void* lantern_diag_backward_tensor_intarrayref_intt(void* grad, void* input_sizes, void* diagonal) { LANTERN_CHECK_LOADED void* ret = _lantern_diag_backward_tensor_intarrayref_intt(grad, input_sizes, diagonal); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cross_out_tensor_tensor_tensor_intt)(void* out, void* self, void* other, void* dim);
  HOST_API void* lantern_cross_out_tensor_tensor_tensor_intt(void* out, void* self, void* other, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_cross_out_tensor_tensor_tensor_intt(out, self, other, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cross_tensor_tensor_intt)(void* self, void* other, void* dim);
  HOST_API void* lantern_cross_tensor_tensor_intt(void* self, void* other, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_cross_tensor_tensor_intt(self, other, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_cross_tensor_tensor_intt)(void* self, void* other, void* dim);
  HOST_API void* lantern_Tensor_cross_tensor_tensor_intt(void* self, void* other, void* dim) { void* ret = _lantern_Tensor_cross_tensor_tensor_intt(self, other, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_triu_out_tensor_tensor_intt)(void* out, void* self, void* diagonal);
  HOST_API void* lantern_triu_out_tensor_tensor_intt(void* out, void* self, void* diagonal) { LANTERN_CHECK_LOADED void* ret = _lantern_triu_out_tensor_tensor_intt(out, self, diagonal); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_triu_tensor_intt)(void* self, void* diagonal);
  HOST_API void* lantern_triu_tensor_intt(void* self, void* diagonal) { LANTERN_CHECK_LOADED void* ret = _lantern_triu_tensor_intt(self, diagonal); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_triu_tensor_intt)(void* self, void* diagonal);
  HOST_API void* lantern_Tensor_triu_tensor_intt(void* self, void* diagonal) { void* ret = _lantern_Tensor_triu_tensor_intt(self, diagonal); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_tril_out_tensor_tensor_intt)(void* out, void* self, void* diagonal);
  HOST_API void* lantern_tril_out_tensor_tensor_intt(void* out, void* self, void* diagonal) { LANTERN_CHECK_LOADED void* ret = _lantern_tril_out_tensor_tensor_intt(out, self, diagonal); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_tril_tensor_intt)(void* self, void* diagonal);
  HOST_API void* lantern_tril_tensor_intt(void* self, void* diagonal) { LANTERN_CHECK_LOADED void* ret = _lantern_tril_tensor_intt(self, diagonal); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_tril_tensor_intt)(void* self, void* diagonal);
  HOST_API void* lantern_Tensor_tril_tensor_intt(void* self, void* diagonal) { void* ret = _lantern_Tensor_tril_tensor_intt(self, diagonal); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_tril_indices_intt_intt_intt_tensoroptions)(void* row, void* col, void* offset, void* options);
  HOST_API void* lantern_tril_indices_intt_intt_intt_tensoroptions(void* row, void* col, void* offset, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_tril_indices_intt_intt_intt_tensoroptions(row, col, offset, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_triu_indices_intt_intt_intt_tensoroptions)(void* row, void* col, void* offset, void* options);
  HOST_API void* lantern_triu_indices_intt_intt_intt_tensoroptions(void* row, void* col, void* offset, void* options) { LANTERN_CHECK_LOADED void* ret = _lantern_triu_indices_intt_intt_intt_tensoroptions(row, col, offset, options); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_trace_tensor)(void* self);
  HOST_API void* lantern_trace_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_trace_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_trace_tensor)(void* self);
  HOST_API void* lantern_Tensor_trace_tensor(void* self) { void* ret = _lantern_Tensor_trace_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_trace_backward_tensor_intarrayref)(void* grad, void* sizes);
  HOST_API void* lantern_trace_backward_tensor_intarrayref(void* grad, void* sizes) { LANTERN_CHECK_LOADED void* ret = _lantern_trace_backward_tensor_intarrayref(grad, sizes); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_ne_out_tensor_tensor_scalar)(void* out, void* self, void* other);
  HOST_API void* lantern_ne_out_tensor_tensor_scalar(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_ne_out_tensor_tensor_scalar(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_ne_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_ne_tensor_scalar(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_ne_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_ne_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_ne_tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_ne_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_ne_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_ne_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_ne_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_ne_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_ne_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_ne_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_ne_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_ne_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_ne_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_ne__tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_ne__tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_ne__tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_ne__tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_ne__tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_ne__tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_not_equal_out_tensor_tensor_scalar)(void* out, void* self, void* other);
  HOST_API void* lantern_not_equal_out_tensor_tensor_scalar(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_not_equal_out_tensor_tensor_scalar(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_not_equal_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_not_equal_tensor_scalar(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_not_equal_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_not_equal_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_not_equal_tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_not_equal_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_not_equal_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_not_equal_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_not_equal_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_not_equal_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_not_equal_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_not_equal_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_not_equal_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_not_equal_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_not_equal_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_not_equal__tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_not_equal__tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_not_equal__tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_not_equal__tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_not_equal__tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_not_equal__tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_eq_out_tensor_tensor_scalar)(void* out, void* self, void* other);
  HOST_API void* lantern_eq_out_tensor_tensor_scalar(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_eq_out_tensor_tensor_scalar(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_eq_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_eq_tensor_scalar(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_eq_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_eq_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_eq_tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_eq_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_eq_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_eq_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_eq_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_eq_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_eq_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_eq_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_eq_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_eq_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_eq_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_ge_out_tensor_tensor_scalar)(void* out, void* self, void* other);
  HOST_API void* lantern_ge_out_tensor_tensor_scalar(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_ge_out_tensor_tensor_scalar(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_ge_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_ge_tensor_scalar(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_ge_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_ge_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_ge_tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_ge_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_ge_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_ge_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_ge_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_ge_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_ge_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_ge_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_ge_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_ge_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_ge_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_ge__tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_ge__tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_ge__tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_ge__tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_ge__tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_ge__tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_greater_equal_out_tensor_tensor_scalar)(void* out, void* self, void* other);
  HOST_API void* lantern_greater_equal_out_tensor_tensor_scalar(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_greater_equal_out_tensor_tensor_scalar(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_greater_equal_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_greater_equal_tensor_scalar(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_greater_equal_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_greater_equal_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_greater_equal_tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_greater_equal_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_greater_equal_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_greater_equal_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_greater_equal_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_greater_equal_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_greater_equal_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_greater_equal_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_greater_equal_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_greater_equal_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_greater_equal_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_greater_equal__tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_greater_equal__tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_greater_equal__tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_greater_equal__tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_greater_equal__tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_greater_equal__tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_le_out_tensor_tensor_scalar)(void* out, void* self, void* other);
  HOST_API void* lantern_le_out_tensor_tensor_scalar(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_le_out_tensor_tensor_scalar(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_le_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_le_tensor_scalar(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_le_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_le_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_le_tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_le_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_le_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_le_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_le_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_le_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_le_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_le_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_le_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_le_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_le_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_le__tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_le__tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_le__tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_le__tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_le__tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_le__tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_less_equal_out_tensor_tensor_scalar)(void* out, void* self, void* other);
  HOST_API void* lantern_less_equal_out_tensor_tensor_scalar(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_less_equal_out_tensor_tensor_scalar(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_less_equal_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_less_equal_tensor_scalar(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_less_equal_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_less_equal_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_less_equal_tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_less_equal_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_less_equal_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_less_equal_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_less_equal_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_less_equal_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_less_equal_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_less_equal_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_less_equal_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_less_equal_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_less_equal_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_less_equal__tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_less_equal__tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_less_equal__tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_less_equal__tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_less_equal__tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_less_equal__tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_gt_out_tensor_tensor_scalar)(void* out, void* self, void* other);
  HOST_API void* lantern_gt_out_tensor_tensor_scalar(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_gt_out_tensor_tensor_scalar(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_gt_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_gt_tensor_scalar(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_gt_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_gt_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_gt_tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_gt_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_gt_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_gt_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_gt_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_gt_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_gt_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_gt_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_gt_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_gt_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_gt_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_gt__tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_gt__tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_gt__tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_gt__tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_gt__tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_gt__tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_greater_out_tensor_tensor_scalar)(void* out, void* self, void* other);
  HOST_API void* lantern_greater_out_tensor_tensor_scalar(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_greater_out_tensor_tensor_scalar(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_greater_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_greater_tensor_scalar(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_greater_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_greater_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_greater_tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_greater_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_greater_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_greater_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_greater_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_greater_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_greater_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_greater_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_greater_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_greater_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_greater_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_greater__tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_greater__tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_greater__tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_greater__tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_greater__tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_greater__tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_lt_out_tensor_tensor_scalar)(void* out, void* self, void* other);
  HOST_API void* lantern_lt_out_tensor_tensor_scalar(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_lt_out_tensor_tensor_scalar(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_lt_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_lt_tensor_scalar(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_lt_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_lt_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_lt_tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_lt_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_lt_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_lt_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_lt_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_lt_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_lt_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_lt_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_lt_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_lt_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_lt_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_lt__tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_lt__tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_lt__tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_lt__tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_lt__tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_lt__tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_less_out_tensor_tensor_scalar)(void* out, void* self, void* other);
  HOST_API void* lantern_less_out_tensor_tensor_scalar(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_less_out_tensor_tensor_scalar(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_less_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_less_tensor_scalar(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_less_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_less_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_less_tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_less_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_less_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_less_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_less_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_less_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_less_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_less_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_less_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_less_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_less_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_less__tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_less__tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_less__tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_less__tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_less__tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_less__tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_take_out_tensor_tensor_tensor)(void* out, void* self, void* index);
  HOST_API void* lantern_take_out_tensor_tensor_tensor(void* out, void* self, void* index) { LANTERN_CHECK_LOADED void* ret = _lantern_take_out_tensor_tensor_tensor(out, self, index); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_take_tensor_tensor)(void* self, void* index);
  HOST_API void* lantern_take_tensor_tensor(void* self, void* index) { LANTERN_CHECK_LOADED void* ret = _lantern_take_tensor_tensor(self, index); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_take_tensor_tensor)(void* self, void* index);
  HOST_API void* lantern_Tensor_take_tensor_tensor(void* self, void* index) { void* ret = _lantern_Tensor_take_tensor_tensor(self, index); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_take_along_dim_out_tensor_tensor_tensor_intt)(void* out, void* self, void* indices, void* dim);
  HOST_API void* lantern_take_along_dim_out_tensor_tensor_tensor_intt(void* out, void* self, void* indices, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_take_along_dim_out_tensor_tensor_tensor_intt(out, self, indices, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_take_along_dim_tensor_tensor_intt)(void* self, void* indices, void* dim);
  HOST_API void* lantern_take_along_dim_tensor_tensor_intt(void* self, void* indices, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_take_along_dim_tensor_tensor_intt(self, indices, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_take_along_dim_tensor_tensor_intt)(void* self, void* indices, void* dim);
  HOST_API void* lantern_Tensor_take_along_dim_tensor_tensor_intt(void* self, void* indices, void* dim) { void* ret = _lantern_Tensor_take_along_dim_tensor_tensor_intt(self, indices, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_index_select_out_tensor_tensor_intt_tensor)(void* out, void* self, void* dim, void* index);
  HOST_API void* lantern_index_select_out_tensor_tensor_intt_tensor(void* out, void* self, void* dim, void* index) { LANTERN_CHECK_LOADED void* ret = _lantern_index_select_out_tensor_tensor_intt_tensor(out, self, dim, index); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_index_select_tensor_intt_tensor)(void* self, void* dim, void* index);
  HOST_API void* lantern_index_select_tensor_intt_tensor(void* self, void* dim, void* index) { LANTERN_CHECK_LOADED void* ret = _lantern_index_select_tensor_intt_tensor(self, dim, index); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_index_select_tensor_intt_tensor)(void* self, void* dim, void* index);
  HOST_API void* lantern_Tensor_index_select_tensor_intt_tensor(void* self, void* dim, void* index) { void* ret = _lantern_Tensor_index_select_tensor_intt_tensor(self, dim, index); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_index_select_out_tensor_tensor_dimname_tensor)(void* out, void* self, void* dim, void* index);
  HOST_API void* lantern_index_select_out_tensor_tensor_dimname_tensor(void* out, void* self, void* dim, void* index) { LANTERN_CHECK_LOADED void* ret = _lantern_index_select_out_tensor_tensor_dimname_tensor(out, self, dim, index); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_index_select_tensor_dimname_tensor)(void* self, void* dim, void* index);
  HOST_API void* lantern_index_select_tensor_dimname_tensor(void* self, void* dim, void* index) { LANTERN_CHECK_LOADED void* ret = _lantern_index_select_tensor_dimname_tensor(self, dim, index); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_index_select_tensor_dimname_tensor)(void* self, void* dim, void* index);
  HOST_API void* lantern_Tensor_index_select_tensor_dimname_tensor(void* self, void* dim, void* index) { void* ret = _lantern_Tensor_index_select_tensor_dimname_tensor(self, dim, index); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_index_select_backward_tensor_intarrayref_intt_tensor)(void* grad, void* self_sizes, void* dim, void* index);
  HOST_API void* lantern_index_select_backward_tensor_intarrayref_intt_tensor(void* grad, void* self_sizes, void* dim, void* index) { LANTERN_CHECK_LOADED void* ret = _lantern_index_select_backward_tensor_intarrayref_intt_tensor(grad, self_sizes, dim, index); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_masked_select_out_tensor_tensor_tensor)(void* out, void* self, void* mask);
  HOST_API void* lantern_masked_select_out_tensor_tensor_tensor(void* out, void* self, void* mask) { LANTERN_CHECK_LOADED void* ret = _lantern_masked_select_out_tensor_tensor_tensor(out, self, mask); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_masked_select_tensor_tensor)(void* self, void* mask);
  HOST_API void* lantern_masked_select_tensor_tensor(void* self, void* mask) { LANTERN_CHECK_LOADED void* ret = _lantern_masked_select_tensor_tensor(self, mask); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_masked_select_tensor_tensor)(void* self, void* mask);
  HOST_API void* lantern_Tensor_masked_select_tensor_tensor(void* self, void* mask) { void* ret = _lantern_Tensor_masked_select_tensor_tensor(self, mask); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_masked_select_backward_tensor_tensor_tensor)(void* grad, void* input, void* mask);
  HOST_API void* lantern_masked_select_backward_tensor_tensor_tensor(void* grad, void* input, void* mask) { LANTERN_CHECK_LOADED void* ret = _lantern_masked_select_backward_tensor_tensor_tensor(grad, input, mask); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_nonzero_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_nonzero_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_nonzero_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_nonzero_tensor)(void* self);
  HOST_API void* lantern_nonzero_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_nonzero_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_nonzero_tensor)(void* self);
  HOST_API void* lantern_Tensor_nonzero_tensor(void* self) { void* ret = _lantern_Tensor_nonzero_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_nonzero_numpy_tensor)(void* self);
  HOST_API void* lantern_nonzero_numpy_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_nonzero_numpy_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_nonzero_numpy_tensor)(void* self);
  HOST_API void* lantern_Tensor_nonzero_numpy_tensor(void* self) { void* ret = _lantern_Tensor_nonzero_numpy_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_argwhere_tensor)(void* self);
  HOST_API void* lantern_argwhere_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_argwhere_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_argwhere_tensor)(void* self);
  HOST_API void* lantern_Tensor_argwhere_tensor(void* self) { void* ret = _lantern_Tensor_argwhere_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_gather_out_tensor_tensor_intt_tensor_bool)(void* out, void* self, void* dim, void* index, void* sparse_grad);
  HOST_API void* lantern_gather_out_tensor_tensor_intt_tensor_bool(void* out, void* self, void* dim, void* index, void* sparse_grad) { LANTERN_CHECK_LOADED void* ret = _lantern_gather_out_tensor_tensor_intt_tensor_bool(out, self, dim, index, sparse_grad); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_gather_tensor_intt_tensor_bool)(void* self, void* dim, void* index, void* sparse_grad);
  HOST_API void* lantern_gather_tensor_intt_tensor_bool(void* self, void* dim, void* index, void* sparse_grad) { LANTERN_CHECK_LOADED void* ret = _lantern_gather_tensor_intt_tensor_bool(self, dim, index, sparse_grad); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_gather_tensor_intt_tensor_bool)(void* self, void* dim, void* index, void* sparse_grad);
  HOST_API void* lantern_Tensor_gather_tensor_intt_tensor_bool(void* self, void* dim, void* index, void* sparse_grad) { void* ret = _lantern_Tensor_gather_tensor_intt_tensor_bool(self, dim, index, sparse_grad); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_gather_backward_tensor_tensor_intt_tensor_bool)(void* grad, void* self, void* dim, void* index, void* sparse_grad);
  HOST_API void* lantern_gather_backward_tensor_tensor_intt_tensor_bool(void* grad, void* self, void* dim, void* index, void* sparse_grad) { LANTERN_CHECK_LOADED void* ret = _lantern_gather_backward_tensor_tensor_intt_tensor_bool(grad, self, dim, index, sparse_grad); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_gather_out_tensor_tensor_dimname_tensor_bool)(void* out, void* self, void* dim, void* index, void* sparse_grad);
  HOST_API void* lantern_gather_out_tensor_tensor_dimname_tensor_bool(void* out, void* self, void* dim, void* index, void* sparse_grad) { LANTERN_CHECK_LOADED void* ret = _lantern_gather_out_tensor_tensor_dimname_tensor_bool(out, self, dim, index, sparse_grad); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_gather_tensor_dimname_tensor_bool)(void* self, void* dim, void* index, void* sparse_grad);
  HOST_API void* lantern_gather_tensor_dimname_tensor_bool(void* self, void* dim, void* index, void* sparse_grad) { LANTERN_CHECK_LOADED void* ret = _lantern_gather_tensor_dimname_tensor_bool(self, dim, index, sparse_grad); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_gather_tensor_dimname_tensor_bool)(void* self, void* dim, void* index, void* sparse_grad);
  HOST_API void* lantern_Tensor_gather_tensor_dimname_tensor_bool(void* self, void* dim, void* index, void* sparse_grad) { void* ret = _lantern_Tensor_gather_tensor_dimname_tensor_bool(self, dim, index, sparse_grad); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__gather_sparse_backward_tensor_intt_tensor_tensor)(void* self, void* dim, void* index, void* grad);
  HOST_API void* lantern__gather_sparse_backward_tensor_intt_tensor_tensor(void* self, void* dim, void* index, void* grad) { LANTERN_CHECK_LOADED void* ret = _lantern__gather_sparse_backward_tensor_intt_tensor_tensor(self, dim, index, grad); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_addcmul_out_tensor_tensor_tensor_tensor_scalar)(void* out, void* self, void* tensor1, void* tensor2, void* value);
  HOST_API void* lantern_addcmul_out_tensor_tensor_tensor_tensor_scalar(void* out, void* self, void* tensor1, void* tensor2, void* value) { LANTERN_CHECK_LOADED void* ret = _lantern_addcmul_out_tensor_tensor_tensor_tensor_scalar(out, self, tensor1, tensor2, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_addcmul_tensor_tensor_tensor_scalar)(void* self, void* tensor1, void* tensor2, void* value);
  HOST_API void* lantern_addcmul_tensor_tensor_tensor_scalar(void* self, void* tensor1, void* tensor2, void* value) { LANTERN_CHECK_LOADED void* ret = _lantern_addcmul_tensor_tensor_tensor_scalar(self, tensor1, tensor2, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_addcmul_tensor_tensor_tensor_scalar)(void* self, void* tensor1, void* tensor2, void* value);
  HOST_API void* lantern_Tensor_addcmul_tensor_tensor_tensor_scalar(void* self, void* tensor1, void* tensor2, void* value) { void* ret = _lantern_Tensor_addcmul_tensor_tensor_tensor_scalar(self, tensor1, tensor2, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_addcmul__tensor_tensor_tensor_scalar)(void* self, void* tensor1, void* tensor2, void* value);
  HOST_API void* lantern_Tensor_addcmul__tensor_tensor_tensor_scalar(void* self, void* tensor1, void* tensor2, void* value) { void* ret = _lantern_Tensor_addcmul__tensor_tensor_tensor_scalar(self, tensor1, tensor2, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_addcdiv_out_tensor_tensor_tensor_tensor_scalar)(void* out, void* self, void* tensor1, void* tensor2, void* value);
  HOST_API void* lantern_addcdiv_out_tensor_tensor_tensor_tensor_scalar(void* out, void* self, void* tensor1, void* tensor2, void* value) { LANTERN_CHECK_LOADED void* ret = _lantern_addcdiv_out_tensor_tensor_tensor_tensor_scalar(out, self, tensor1, tensor2, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_addcdiv_tensor_tensor_tensor_scalar)(void* self, void* tensor1, void* tensor2, void* value);
  HOST_API void* lantern_addcdiv_tensor_tensor_tensor_scalar(void* self, void* tensor1, void* tensor2, void* value) { LANTERN_CHECK_LOADED void* ret = _lantern_addcdiv_tensor_tensor_tensor_scalar(self, tensor1, tensor2, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_addcdiv_tensor_tensor_tensor_scalar)(void* self, void* tensor1, void* tensor2, void* value);
  HOST_API void* lantern_Tensor_addcdiv_tensor_tensor_tensor_scalar(void* self, void* tensor1, void* tensor2, void* value) { void* ret = _lantern_Tensor_addcdiv_tensor_tensor_tensor_scalar(self, tensor1, tensor2, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_addcdiv__tensor_tensor_tensor_scalar)(void* self, void* tensor1, void* tensor2, void* value);
  HOST_API void* lantern_Tensor_addcdiv__tensor_tensor_tensor_scalar(void* self, void* tensor1, void* tensor2, void* value) { void* ret = _lantern_Tensor_addcdiv__tensor_tensor_tensor_scalar(self, tensor1, tensor2, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cross_entropy_loss_tensor_tensor_tensor_intt_intt_double)(void* self, void* target, void* weight, void* reduction, void* ignore_index, void* label_smoothing);
  HOST_API void* lantern_cross_entropy_loss_tensor_tensor_tensor_intt_intt_double(void* self, void* target, void* weight, void* reduction, void* ignore_index, void* label_smoothing) { LANTERN_CHECK_LOADED void* ret = _lantern_cross_entropy_loss_tensor_tensor_tensor_intt_intt_double(self, target, weight, reduction, ignore_index, label_smoothing); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_triangular_solve_out_tensor_tensor_tensor_tensor_bool_bool_bool)(void* X, void* M, void* self, void* A, void* upper, void* transpose, void* unitriangular);
  HOST_API void* lantern_triangular_solve_out_tensor_tensor_tensor_tensor_bool_bool_bool(void* X, void* M, void* self, void* A, void* upper, void* transpose, void* unitriangular) { LANTERN_CHECK_LOADED void* ret = _lantern_triangular_solve_out_tensor_tensor_tensor_tensor_bool_bool_bool(X, M, self, A, upper, transpose, unitriangular); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_triangular_solve_tensor_tensor_bool_bool_bool)(void* self, void* A, void* upper, void* transpose, void* unitriangular);
  HOST_API void* lantern_triangular_solve_tensor_tensor_bool_bool_bool(void* self, void* A, void* upper, void* transpose, void* unitriangular) { LANTERN_CHECK_LOADED void* ret = _lantern_triangular_solve_tensor_tensor_bool_bool_bool(self, A, upper, transpose, unitriangular); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_triangular_solve_tensor_tensor_bool_bool_bool)(void* self, void* A, void* upper, void* transpose, void* unitriangular);
  HOST_API void* lantern_Tensor_triangular_solve_tensor_tensor_bool_bool_bool(void* self, void* A, void* upper, void* transpose, void* unitriangular) { void* ret = _lantern_Tensor_triangular_solve_tensor_tensor_bool_bool_bool(self, A, upper, transpose, unitriangular); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__linalg_check_errors_tensor_cstringview_bool)(void* info, void* api_name, void* is_matrix);
  HOST_API void* lantern__linalg_check_errors_tensor_cstringview_bool(void* info, void* api_name, void* is_matrix) { LANTERN_CHECK_LOADED void* ret = _lantern__linalg_check_errors_tensor_cstringview_bool(info, api_name, is_matrix); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_linalg_solve_triangular_out_tensor_tensor_tensor_bool_bool_bool)(void* out, void* self, void* B, void* upper, void* left, void* unitriangular);
  HOST_API void* lantern_linalg_solve_triangular_out_tensor_tensor_tensor_bool_bool_bool(void* out, void* self, void* B, void* upper, void* left, void* unitriangular) { LANTERN_CHECK_LOADED void* ret = _lantern_linalg_solve_triangular_out_tensor_tensor_tensor_bool_bool_bool(out, self, B, upper, left, unitriangular); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_linalg_solve_triangular_tensor_tensor_bool_bool_bool)(void* self, void* B, void* upper, void* left, void* unitriangular);
  HOST_API void* lantern_linalg_solve_triangular_tensor_tensor_bool_bool_bool(void* self, void* B, void* upper, void* left, void* unitriangular) { LANTERN_CHECK_LOADED void* ret = _lantern_linalg_solve_triangular_tensor_tensor_bool_bool_bool(self, B, upper, left, unitriangular); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_linalg_vander_tensor_intt)(void* x, void* N);
  HOST_API void* lantern_linalg_vander_tensor_intt(void* x, void* N) { LANTERN_CHECK_LOADED void* ret = _lantern_linalg_vander_tensor_intt(x, N); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_symeig_out_tensor_tensor_tensor_bool_bool)(void* e, void* V, void* self, void* eigenvectors, void* upper);
  HOST_API void* lantern_symeig_out_tensor_tensor_tensor_bool_bool(void* e, void* V, void* self, void* eigenvectors, void* upper) { LANTERN_CHECK_LOADED void* ret = _lantern_symeig_out_tensor_tensor_tensor_bool_bool(e, V, self, eigenvectors, upper); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_symeig_tensor_bool_bool)(void* self, void* eigenvectors, void* upper);
  HOST_API void* lantern_symeig_tensor_bool_bool(void* self, void* eigenvectors, void* upper) { LANTERN_CHECK_LOADED void* ret = _lantern_symeig_tensor_bool_bool(self, eigenvectors, upper); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_symeig_tensor_bool_bool)(void* self, void* eigenvectors, void* upper);
  HOST_API void* lantern_Tensor_symeig_tensor_bool_bool(void* self, void* eigenvectors, void* upper) { void* ret = _lantern_Tensor_symeig_tensor_bool_bool(self, eigenvectors, upper); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__symeig_helper_tensor_bool_bool)(void* self, void* eigenvectors, void* upper);
  HOST_API void* lantern__symeig_helper_tensor_bool_bool(void* self, void* eigenvectors, void* upper) { LANTERN_CHECK_LOADED void* ret = _lantern__symeig_helper_tensor_bool_bool(self, eigenvectors, upper); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_svd_out_tensor_tensor_tensor_tensor_bool_bool)(void* U, void* S, void* V, void* self, void* some, void* compute_uv);
  HOST_API void* lantern_svd_out_tensor_tensor_tensor_tensor_bool_bool(void* U, void* S, void* V, void* self, void* some, void* compute_uv) { LANTERN_CHECK_LOADED void* ret = _lantern_svd_out_tensor_tensor_tensor_tensor_bool_bool(U, S, V, self, some, compute_uv); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_svd_tensor_bool_bool)(void* self, void* some, void* compute_uv);
  HOST_API void* lantern_svd_tensor_bool_bool(void* self, void* some, void* compute_uv) { LANTERN_CHECK_LOADED void* ret = _lantern_svd_tensor_bool_bool(self, some, compute_uv); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_svd_tensor_bool_bool)(void* self, void* some, void* compute_uv);
  HOST_API void* lantern_Tensor_svd_tensor_bool_bool(void* self, void* some, void* compute_uv) { void* ret = _lantern_Tensor_svd_tensor_bool_bool(self, some, compute_uv); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_swapaxes_tensor_intt_intt)(void* self, void* axis0, void* axis1);
  HOST_API void* lantern_swapaxes_tensor_intt_intt(void* self, void* axis0, void* axis1) { LANTERN_CHECK_LOADED void* ret = _lantern_swapaxes_tensor_intt_intt(self, axis0, axis1); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_swapaxes_tensor_intt_intt)(void* self, void* axis0, void* axis1);
  HOST_API void* lantern_Tensor_swapaxes_tensor_intt_intt(void* self, void* axis0, void* axis1) { void* ret = _lantern_Tensor_swapaxes_tensor_intt_intt(self, axis0, axis1); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_swapaxes__tensor_intt_intt)(void* self, void* axis0, void* axis1);
  HOST_API void* lantern_Tensor_swapaxes__tensor_intt_intt(void* self, void* axis0, void* axis1) { void* ret = _lantern_Tensor_swapaxes__tensor_intt_intt(self, axis0, axis1); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_swapdims_tensor_intt_intt)(void* self, void* dim0, void* dim1);
  HOST_API void* lantern_swapdims_tensor_intt_intt(void* self, void* dim0, void* dim1) { LANTERN_CHECK_LOADED void* ret = _lantern_swapdims_tensor_intt_intt(self, dim0, dim1); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_swapdims_tensor_intt_intt)(void* self, void* dim0, void* dim1);
  HOST_API void* lantern_Tensor_swapdims_tensor_intt_intt(void* self, void* dim0, void* dim1) { void* ret = _lantern_Tensor_swapdims_tensor_intt_intt(self, dim0, dim1); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_swapdims__tensor_intt_intt)(void* self, void* dim0, void* dim1);
  HOST_API void* lantern_Tensor_swapdims__tensor_intt_intt(void* self, void* dim0, void* dim1) { void* ret = _lantern_Tensor_swapdims__tensor_intt_intt(self, dim0, dim1); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cholesky_out_tensor_tensor_bool)(void* out, void* self, void* upper);
  HOST_API void* lantern_cholesky_out_tensor_tensor_bool(void* out, void* self, void* upper) { LANTERN_CHECK_LOADED void* ret = _lantern_cholesky_out_tensor_tensor_bool(out, self, upper); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cholesky_tensor_bool)(void* self, void* upper);
  HOST_API void* lantern_cholesky_tensor_bool(void* self, void* upper) { LANTERN_CHECK_LOADED void* ret = _lantern_cholesky_tensor_bool(self, upper); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_cholesky_tensor_bool)(void* self, void* upper);
  HOST_API void* lantern_Tensor_cholesky_tensor_bool(void* self, void* upper) { void* ret = _lantern_Tensor_cholesky_tensor_bool(self, upper); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cholesky_solve_out_tensor_tensor_tensor_bool)(void* out, void* self, void* input2, void* upper);
  HOST_API void* lantern_cholesky_solve_out_tensor_tensor_tensor_bool(void* out, void* self, void* input2, void* upper) { LANTERN_CHECK_LOADED void* ret = _lantern_cholesky_solve_out_tensor_tensor_tensor_bool(out, self, input2, upper); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cholesky_solve_tensor_tensor_bool)(void* self, void* input2, void* upper);
  HOST_API void* lantern_cholesky_solve_tensor_tensor_bool(void* self, void* input2, void* upper) { LANTERN_CHECK_LOADED void* ret = _lantern_cholesky_solve_tensor_tensor_bool(self, input2, upper); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_cholesky_solve_tensor_tensor_bool)(void* self, void* input2, void* upper);
  HOST_API void* lantern_Tensor_cholesky_solve_tensor_tensor_bool(void* self, void* input2, void* upper) { void* ret = _lantern_Tensor_cholesky_solve_tensor_tensor_bool(self, input2, upper); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__cholesky_solve_helper_tensor_tensor_bool)(void* self, void* A, void* upper);
  HOST_API void* lantern__cholesky_solve_helper_tensor_tensor_bool(void* self, void* A, void* upper) { LANTERN_CHECK_LOADED void* ret = _lantern__cholesky_solve_helper_tensor_tensor_bool(self, A, upper); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cholesky_inverse_tensor_bool)(void* self, void* upper);
  HOST_API void* lantern_cholesky_inverse_tensor_bool(void* self, void* upper) { LANTERN_CHECK_LOADED void* ret = _lantern_cholesky_inverse_tensor_bool(self, upper); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_cholesky_inverse_tensor_bool)(void* self, void* upper);
  HOST_API void* lantern_Tensor_cholesky_inverse_tensor_bool(void* self, void* upper) { void* ret = _lantern_Tensor_cholesky_inverse_tensor_bool(self, upper); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_cholesky_inverse_out_tensor_tensor_bool)(void* out, void* self, void* upper);
  HOST_API void* lantern_cholesky_inverse_out_tensor_tensor_bool(void* out, void* self, void* upper) { LANTERN_CHECK_LOADED void* ret = _lantern_cholesky_inverse_out_tensor_tensor_bool(out, self, upper); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_qr_out_tensor_tensor_tensor_bool)(void* Q, void* R, void* self, void* some);
  HOST_API void* lantern_qr_out_tensor_tensor_tensor_bool(void* Q, void* R, void* self, void* some) { LANTERN_CHECK_LOADED void* ret = _lantern_qr_out_tensor_tensor_tensor_bool(Q, R, self, some); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_qr_tensor_bool)(void* self, void* some);
  HOST_API void* lantern_qr_tensor_bool(void* self, void* some) { LANTERN_CHECK_LOADED void* ret = _lantern_qr_tensor_bool(self, some); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_qr_tensor_bool)(void* self, void* some);
  HOST_API void* lantern_Tensor_qr_tensor_bool(void* self, void* some) { void* ret = _lantern_Tensor_qr_tensor_bool(self, some); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_geqrf_out_tensor_tensor_tensor)(void* a, void* tau, void* self);
  HOST_API void* lantern_geqrf_out_tensor_tensor_tensor(void* a, void* tau, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_geqrf_out_tensor_tensor_tensor(a, tau, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_geqrf_tensor)(void* self);
  HOST_API void* lantern_geqrf_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_geqrf_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_geqrf_tensor)(void* self);
  HOST_API void* lantern_Tensor_geqrf_tensor(void* self) { void* ret = _lantern_Tensor_geqrf_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_orgqr_tensor_tensor)(void* self, void* input2);
  HOST_API void* lantern_orgqr_tensor_tensor(void* self, void* input2) { LANTERN_CHECK_LOADED void* ret = _lantern_orgqr_tensor_tensor(self, input2); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_orgqr_tensor_tensor)(void* self, void* input2);
  HOST_API void* lantern_Tensor_orgqr_tensor_tensor(void* self, void* input2) { void* ret = _lantern_Tensor_orgqr_tensor_tensor(self, input2); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_orgqr_out_tensor_tensor_tensor)(void* out, void* self, void* input2);
  HOST_API void* lantern_orgqr_out_tensor_tensor_tensor(void* out, void* self, void* input2) { LANTERN_CHECK_LOADED void* ret = _lantern_orgqr_out_tensor_tensor_tensor(out, self, input2); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_ormqr_out_tensor_tensor_tensor_tensor_bool_bool)(void* out, void* self, void* input2, void* input3, void* left, void* transpose);
  HOST_API void* lantern_ormqr_out_tensor_tensor_tensor_tensor_bool_bool(void* out, void* self, void* input2, void* input3, void* left, void* transpose) { LANTERN_CHECK_LOADED void* ret = _lantern_ormqr_out_tensor_tensor_tensor_tensor_bool_bool(out, self, input2, input3, left, transpose); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_ormqr_tensor_tensor_tensor_bool_bool)(void* self, void* input2, void* input3, void* left, void* transpose);
  HOST_API void* lantern_ormqr_tensor_tensor_tensor_bool_bool(void* self, void* input2, void* input3, void* left, void* transpose) { LANTERN_CHECK_LOADED void* ret = _lantern_ormqr_tensor_tensor_tensor_bool_bool(self, input2, input3, left, transpose); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_ormqr_tensor_tensor_tensor_bool_bool)(void* self, void* input2, void* input3, void* left, void* transpose);
  HOST_API void* lantern_Tensor_ormqr_tensor_tensor_tensor_bool_bool(void* self, void* input2, void* input3, void* left, void* transpose) { void* ret = _lantern_Tensor_ormqr_tensor_tensor_tensor_bool_bool(self, input2, input3, left, transpose); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__lu_with_info_tensor_bool_bool)(void* self, void* pivot, void* check_errors);
  HOST_API void* lantern__lu_with_info_tensor_bool_bool(void* self, void* pivot, void* check_errors) { LANTERN_CHECK_LOADED void* ret = _lantern__lu_with_info_tensor_bool_bool(self, pivot, check_errors); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_lu_solve_out_tensor_tensor_tensor_tensor)(void* out, void* self, void* LU_data, void* LU_pivots);
  HOST_API void* lantern_lu_solve_out_tensor_tensor_tensor_tensor(void* out, void* self, void* LU_data, void* LU_pivots) { LANTERN_CHECK_LOADED void* ret = _lantern_lu_solve_out_tensor_tensor_tensor_tensor(out, self, LU_data, LU_pivots); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_lu_solve_tensor_tensor_tensor)(void* self, void* LU_data, void* LU_pivots);
  HOST_API void* lantern_lu_solve_tensor_tensor_tensor(void* self, void* LU_data, void* LU_pivots) { LANTERN_CHECK_LOADED void* ret = _lantern_lu_solve_tensor_tensor_tensor(self, LU_data, LU_pivots); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_lu_solve_tensor_tensor_tensor)(void* self, void* LU_data, void* LU_pivots);
  HOST_API void* lantern_Tensor_lu_solve_tensor_tensor_tensor(void* self, void* LU_data, void* LU_pivots) { void* ret = _lantern_Tensor_lu_solve_tensor_tensor_tensor(self, LU_data, LU_pivots); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_lu_unpack_tensor_tensor_bool_bool)(void* LU_data, void* LU_pivots, void* unpack_data, void* unpack_pivots);
  HOST_API void* lantern_lu_unpack_tensor_tensor_bool_bool(void* LU_data, void* LU_pivots, void* unpack_data, void* unpack_pivots) { LANTERN_CHECK_LOADED void* ret = _lantern_lu_unpack_tensor_tensor_bool_bool(LU_data, LU_pivots, unpack_data, unpack_pivots); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_lu_unpack_out_tensor_tensor_tensor_tensor_tensor_bool_bool)(void* P, void* L, void* U, void* LU_data, void* LU_pivots, void* unpack_data, void* unpack_pivots);
  HOST_API void* lantern_lu_unpack_out_tensor_tensor_tensor_tensor_tensor_bool_bool(void* P, void* L, void* U, void* LU_data, void* LU_pivots, void* unpack_data, void* unpack_pivots) { LANTERN_CHECK_LOADED void* ret = _lantern_lu_unpack_out_tensor_tensor_tensor_tensor_tensor_bool_bool(P, L, U, LU_data, LU_pivots, unpack_data, unpack_pivots); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_multinomial_out_tensor_tensor_intt_bool_generator)(void* out, void* self, void* num_samples, void* replacement, void* generator);
  HOST_API void* lantern_multinomial_out_tensor_tensor_intt_bool_generator(void* out, void* self, void* num_samples, void* replacement, void* generator) { LANTERN_CHECK_LOADED void* ret = _lantern_multinomial_out_tensor_tensor_intt_bool_generator(out, self, num_samples, replacement, generator); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_multinomial_tensor_intt_bool_generator)(void* self, void* num_samples, void* replacement, void* generator);
  HOST_API void* lantern_multinomial_tensor_intt_bool_generator(void* self, void* num_samples, void* replacement, void* generator) { LANTERN_CHECK_LOADED void* ret = _lantern_multinomial_tensor_intt_bool_generator(self, num_samples, replacement, generator); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_multinomial_tensor_intt_bool_generator)(void* self, void* num_samples, void* replacement, void* generator);
  HOST_API void* lantern_Tensor_multinomial_tensor_intt_bool_generator(void* self, void* num_samples, void* replacement, void* generator) { void* ret = _lantern_Tensor_multinomial_tensor_intt_bool_generator(self, num_samples, replacement, generator); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_lgamma_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_lgamma_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_lgamma_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_lgamma__tensor)(void* self);
  HOST_API void* lantern_Tensor_lgamma__tensor(void* self) { void* ret = _lantern_Tensor_lgamma__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_lgamma_tensor)(void* self);
  HOST_API void* lantern_lgamma_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_lgamma_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_lgamma_tensor)(void* self);
  HOST_API void* lantern_Tensor_lgamma_tensor(void* self) { void* ret = _lantern_Tensor_lgamma_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_digamma_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_digamma_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_digamma_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_digamma_tensor)(void* self);
  HOST_API void* lantern_digamma_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_digamma_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_digamma_tensor)(void* self);
  HOST_API void* lantern_Tensor_digamma_tensor(void* self) { void* ret = _lantern_Tensor_digamma_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_polygamma_out_tensor_intt_tensor)(void* out, void* n, void* self);
  HOST_API void* lantern_polygamma_out_tensor_intt_tensor(void* out, void* n, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_polygamma_out_tensor_intt_tensor(out, n, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_polygamma__tensor_intt)(void* self, void* n);
  HOST_API void* lantern_Tensor_polygamma__tensor_intt(void* self, void* n) { void* ret = _lantern_Tensor_polygamma__tensor_intt(self, n); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_erfinv_tensor)(void* self);
  HOST_API void* lantern_erfinv_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_erfinv_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_erfinv_tensor)(void* self);
  HOST_API void* lantern_Tensor_erfinv_tensor(void* self) { void* ret = _lantern_Tensor_erfinv_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_erfinv__tensor)(void* self);
  HOST_API void* lantern_Tensor_erfinv__tensor(void* self) { void* ret = _lantern_Tensor_erfinv__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_erfinv_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_erfinv_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_erfinv_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_i0_tensor)(void* self);
  HOST_API void* lantern_i0_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_i0_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_i0_tensor)(void* self);
  HOST_API void* lantern_Tensor_i0_tensor(void* self) { void* ret = _lantern_Tensor_i0_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_i0__tensor)(void* self);
  HOST_API void* lantern_i0__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_i0__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_i0__tensor)(void* self);
  HOST_API void* lantern_Tensor_i0__tensor(void* self) { void* ret = _lantern_Tensor_i0__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_i0_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_i0_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_i0_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sign_tensor)(void* self);
  HOST_API void* lantern_sign_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_sign_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_sign_tensor)(void* self);
  HOST_API void* lantern_Tensor_sign_tensor(void* self) { void* ret = _lantern_Tensor_sign_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_sign__tensor)(void* self);
  HOST_API void* lantern_Tensor_sign__tensor(void* self) { void* ret = _lantern_Tensor_sign__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sign_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_sign_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_sign_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_signbit_tensor)(void* self);
  HOST_API void* lantern_signbit_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_signbit_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_signbit_tensor)(void* self);
  HOST_API void* lantern_Tensor_signbit_tensor(void* self) { void* ret = _lantern_Tensor_signbit_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_signbit_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_signbit_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_signbit_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_dist_tensor_tensor_scalar)(void* self, void* other, void* p);
  HOST_API void* lantern_dist_tensor_tensor_scalar(void* self, void* other, void* p) { LANTERN_CHECK_LOADED void* ret = _lantern_dist_tensor_tensor_scalar(self, other, p); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_dist_tensor_tensor_scalar)(void* self, void* other, void* p);
  HOST_API void* lantern_Tensor_dist_tensor_tensor_scalar(void* self, void* other, void* p) { void* ret = _lantern_Tensor_dist_tensor_tensor_scalar(self, other, p); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_atan2_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_atan2_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_atan2_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_atan2__tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_atan2__tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_atan2__tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_atan2_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_atan2_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_atan2_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_atan2_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_atan2_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_atan2_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_arctan2_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_arctan2_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_arctan2_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_arctan2_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_arctan2_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_arctan2_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_arctan2_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_arctan2_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_arctan2_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_arctan2__tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_arctan2__tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_arctan2__tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_lerp_out_tensor_tensor_tensor_scalar)(void* out, void* self, void* end, void* weight);
  HOST_API void* lantern_lerp_out_tensor_tensor_tensor_scalar(void* out, void* self, void* end, void* weight) { LANTERN_CHECK_LOADED void* ret = _lantern_lerp_out_tensor_tensor_tensor_scalar(out, self, end, weight); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_lerp_out_tensor_tensor_tensor_tensor)(void* out, void* self, void* end, void* weight);
  HOST_API void* lantern_lerp_out_tensor_tensor_tensor_tensor(void* out, void* self, void* end, void* weight) { LANTERN_CHECK_LOADED void* ret = _lantern_lerp_out_tensor_tensor_tensor_tensor(out, self, end, weight); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_lerp_tensor_tensor_scalar)(void* self, void* end, void* weight);
  HOST_API void* lantern_lerp_tensor_tensor_scalar(void* self, void* end, void* weight) { LANTERN_CHECK_LOADED void* ret = _lantern_lerp_tensor_tensor_scalar(self, end, weight); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_lerp_tensor_tensor_scalar)(void* self, void* end, void* weight);
  HOST_API void* lantern_Tensor_lerp_tensor_tensor_scalar(void* self, void* end, void* weight) { void* ret = _lantern_Tensor_lerp_tensor_tensor_scalar(self, end, weight); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_lerp_tensor_tensor_tensor)(void* self, void* end, void* weight);
  HOST_API void* lantern_lerp_tensor_tensor_tensor(void* self, void* end, void* weight) { LANTERN_CHECK_LOADED void* ret = _lantern_lerp_tensor_tensor_tensor(self, end, weight); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_lerp_tensor_tensor_tensor)(void* self, void* end, void* weight);
  HOST_API void* lantern_Tensor_lerp_tensor_tensor_tensor(void* self, void* end, void* weight) { void* ret = _lantern_Tensor_lerp_tensor_tensor_tensor(self, end, weight); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_histc_out_tensor_tensor_intt_scalar_scalar)(void* out, void* self, void* bins, void* min, void* max);
  HOST_API void* lantern_histc_out_tensor_tensor_intt_scalar_scalar(void* out, void* self, void* bins, void* min, void* max) { LANTERN_CHECK_LOADED void* ret = _lantern_histc_out_tensor_tensor_intt_scalar_scalar(out, self, bins, min, max); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_histc_tensor_intt_scalar_scalar)(void* self, void* bins, void* min, void* max);
  HOST_API void* lantern_histc_tensor_intt_scalar_scalar(void* self, void* bins, void* min, void* max) { LANTERN_CHECK_LOADED void* ret = _lantern_histc_tensor_intt_scalar_scalar(self, bins, min, max); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_histc_tensor_intt_scalar_scalar)(void* self, void* bins, void* min, void* max);
  HOST_API void* lantern_Tensor_histc_tensor_intt_scalar_scalar(void* self, void* bins, void* min, void* max) { void* ret = _lantern_Tensor_histc_tensor_intt_scalar_scalar(self, bins, min, max); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_histogram_out_tensor_tensor_tensor_tensor_tensor_bool)(void* hist, void* bin_edges, void* self, void* bins, void* weight, void* density);
  HOST_API void* lantern_histogram_out_tensor_tensor_tensor_tensor_tensor_bool(void* hist, void* bin_edges, void* self, void* bins, void* weight, void* density) { LANTERN_CHECK_LOADED void* ret = _lantern_histogram_out_tensor_tensor_tensor_tensor_tensor_bool(hist, bin_edges, self, bins, weight, density); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_histogram_tensor_tensor_tensor_bool)(void* self, void* bins, void* weight, void* density);
  HOST_API void* lantern_histogram_tensor_tensor_tensor_bool(void* self, void* bins, void* weight, void* density) { LANTERN_CHECK_LOADED void* ret = _lantern_histogram_tensor_tensor_tensor_bool(self, bins, weight, density); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_histogram_tensor_tensor_tensor_bool)(void* self, void* bins, void* weight, void* density);
  HOST_API void* lantern_Tensor_histogram_tensor_tensor_tensor_bool(void* self, void* bins, void* weight, void* density) { void* ret = _lantern_Tensor_histogram_tensor_tensor_tensor_bool(self, bins, weight, density); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_histogram_out_tensor_tensor_tensor_intt_arrayrefdouble_tensor_bool)(void* hist, void* bin_edges, void* self, void* bins, void* range, void* weight, void* density);
  HOST_API void* lantern_histogram_out_tensor_tensor_tensor_intt_arrayrefdouble_tensor_bool(void* hist, void* bin_edges, void* self, void* bins, void* range, void* weight, void* density) { LANTERN_CHECK_LOADED void* ret = _lantern_histogram_out_tensor_tensor_tensor_intt_arrayrefdouble_tensor_bool(hist, bin_edges, self, bins, range, weight, density); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_histogram_tensor_intt_arrayrefdouble_tensor_bool)(void* self, void* bins, void* range, void* weight, void* density);
  HOST_API void* lantern_histogram_tensor_intt_arrayrefdouble_tensor_bool(void* self, void* bins, void* range, void* weight, void* density) { LANTERN_CHECK_LOADED void* ret = _lantern_histogram_tensor_intt_arrayrefdouble_tensor_bool(self, bins, range, weight, density); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_histogram_tensor_intt_arrayrefdouble_tensor_bool)(void* self, void* bins, void* range, void* weight, void* density);
  HOST_API void* lantern_Tensor_histogram_tensor_intt_arrayrefdouble_tensor_bool(void* self, void* bins, void* range, void* weight, void* density) { void* ret = _lantern_Tensor_histogram_tensor_intt_arrayrefdouble_tensor_bool(self, bins, range, weight, density); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__histogramdd_bin_edges_tensor_intarrayref_arrayrefdouble_tensor_bool)(void* self, void* bins, void* range, void* weight, void* density);
  HOST_API void* lantern__histogramdd_bin_edges_tensor_intarrayref_arrayrefdouble_tensor_bool(void* self, void* bins, void* range, void* weight, void* density) { LANTERN_CHECK_LOADED void* ret = _lantern__histogramdd_bin_edges_tensor_intarrayref_arrayrefdouble_tensor_bool(self, bins, range, weight, density); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__histogramdd_from_bin_cts_tensor_intarrayref_arrayrefdouble_tensor_bool)(void* self, void* bins, void* range, void* weight, void* density);
  HOST_API void* lantern__histogramdd_from_bin_cts_tensor_intarrayref_arrayrefdouble_tensor_bool(void* self, void* bins, void* range, void* weight, void* density) { LANTERN_CHECK_LOADED void* ret = _lantern__histogramdd_from_bin_cts_tensor_intarrayref_arrayrefdouble_tensor_bool(self, bins, range, weight, density); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__histogramdd_from_bin_tensors_tensor_tensorlist_tensor_bool)(void* self, void* bins, void* weight, void* density);
  HOST_API void* lantern__histogramdd_from_bin_tensors_tensor_tensorlist_tensor_bool(void* self, void* bins, void* weight, void* density) { LANTERN_CHECK_LOADED void* ret = _lantern__histogramdd_from_bin_tensors_tensor_tensorlist_tensor_bool(self, bins, weight, density); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_histogramdd_tensor_intarrayref_arrayrefdouble_tensor_bool)(void* self, void* bins, void* range, void* weight, void* density);
  HOST_API void* lantern_histogramdd_tensor_intarrayref_arrayrefdouble_tensor_bool(void* self, void* bins, void* range, void* weight, void* density) { LANTERN_CHECK_LOADED void* ret = _lantern_histogramdd_tensor_intarrayref_arrayrefdouble_tensor_bool(self, bins, range, weight, density); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_histogramdd_tensor_intt_arrayrefdouble_tensor_bool)(void* self, void* bins, void* range, void* weight, void* density);
  HOST_API void* lantern_histogramdd_tensor_intt_arrayrefdouble_tensor_bool(void* self, void* bins, void* range, void* weight, void* density) { LANTERN_CHECK_LOADED void* ret = _lantern_histogramdd_tensor_intt_arrayrefdouble_tensor_bool(self, bins, range, weight, density); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_histogramdd_tensor_tensorlist_arrayrefdouble_tensor_bool)(void* self, void* bins, void* range, void* weight, void* density);
  HOST_API void* lantern_histogramdd_tensor_tensorlist_arrayrefdouble_tensor_bool(void* self, void* bins, void* range, void* weight, void* density) { LANTERN_CHECK_LOADED void* ret = _lantern_histogramdd_tensor_tensorlist_arrayrefdouble_tensor_bool(self, bins, range, weight, density); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_fmod_out_tensor_tensor_scalar)(void* out, void* self, void* other);
  HOST_API void* lantern_fmod_out_tensor_tensor_scalar(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_fmod_out_tensor_tensor_scalar(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_fmod_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_fmod_tensor_scalar(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_fmod_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_fmod_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_fmod_tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_fmod_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_fmod__tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_fmod__tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_fmod__tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_fmod_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_fmod_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_fmod_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_fmod_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_fmod_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_fmod_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_fmod_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_fmod_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_fmod_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_fmod__tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_fmod__tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_fmod__tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_hypot_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_hypot_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_hypot_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_hypot_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_hypot_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_hypot_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_hypot_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_hypot_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_hypot_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_hypot__tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_hypot__tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_hypot__tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_igamma_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_igamma_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_igamma_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_igamma_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_igamma_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_igamma_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_igamma_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_igamma_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_igamma_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_igamma__tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_igamma__tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_igamma__tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_igammac_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_igammac_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_igammac_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_igammac_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_igammac_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_igammac_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_igammac_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_igammac_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_igammac_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_igammac__tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_igammac__tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_igammac__tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_nextafter_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_nextafter_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_nextafter_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_nextafter_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_nextafter_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_nextafter_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_nextafter_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_nextafter_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_nextafter_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_nextafter__tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_nextafter__tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_nextafter__tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_remainder_out_tensor_tensor_scalar)(void* out, void* self, void* other);
  HOST_API void* lantern_remainder_out_tensor_tensor_scalar(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_remainder_out_tensor_tensor_scalar(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_remainder_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_remainder_tensor_scalar(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_remainder_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_remainder_tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_remainder_tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_remainder_tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_remainder__tensor_scalar)(void* self, void* other);
  HOST_API void* lantern_Tensor_remainder__tensor_scalar(void* self, void* other) { void* ret = _lantern_Tensor_remainder__tensor_scalar(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_remainder_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_remainder_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_remainder_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_remainder_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_remainder_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_remainder_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_remainder_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_remainder_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_remainder_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_remainder__tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_remainder__tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_remainder__tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_remainder_scalar_tensor)(void* self, void* other);
  HOST_API void* lantern_remainder_scalar_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_remainder_scalar_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_min_tensor)(void* self);
  HOST_API void* lantern_min_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_min_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_min_tensor)(void* self);
  HOST_API void* lantern_Tensor_min_tensor(void* self) { void* ret = _lantern_Tensor_min_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_fmin_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_fmin_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_fmin_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_fmin_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_fmin_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_fmin_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_fmin_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_fmin_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_fmin_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_max_tensor)(void* self);
  HOST_API void* lantern_max_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_max_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_max_tensor)(void* self);
  HOST_API void* lantern_Tensor_max_tensor(void* self) { void* ret = _lantern_Tensor_max_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_fmax_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_fmax_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_fmax_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_fmax_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_fmax_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_fmax_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_fmax_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_fmax_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_fmax_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_maximum_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_maximum_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_maximum_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_maximum_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_maximum_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_maximum_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_maximum_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_maximum_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_maximum_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_max_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_max_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_max_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_max_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_max_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_max_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_max_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_max_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_max_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_minimum_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_minimum_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_minimum_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_minimum_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_minimum_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_minimum_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_minimum_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_minimum_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_minimum_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_min_out_tensor_tensor_tensor)(void* out, void* self, void* other);
  HOST_API void* lantern_min_out_tensor_tensor_tensor(void* out, void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_min_out_tensor_tensor_tensor(out, self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_min_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_min_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_min_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_min_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_min_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_min_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_quantile_tensor_tensor_intt_bool_cstringview)(void* self, void* q, void* dim, void* keepdim, void* interpolation);
  HOST_API void* lantern_quantile_tensor_tensor_intt_bool_cstringview(void* self, void* q, void* dim, void* keepdim, void* interpolation) { LANTERN_CHECK_LOADED void* ret = _lantern_quantile_tensor_tensor_intt_bool_cstringview(self, q, dim, keepdim, interpolation); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_quantile_tensor_tensor_intt_bool_cstringview)(void* self, void* q, void* dim, void* keepdim, void* interpolation);
  HOST_API void* lantern_Tensor_quantile_tensor_tensor_intt_bool_cstringview(void* self, void* q, void* dim, void* keepdim, void* interpolation) { void* ret = _lantern_Tensor_quantile_tensor_tensor_intt_bool_cstringview(self, q, dim, keepdim, interpolation); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_quantile_out_tensor_tensor_tensor_intt_bool_cstringview)(void* out, void* self, void* q, void* dim, void* keepdim, void* interpolation);
  HOST_API void* lantern_quantile_out_tensor_tensor_tensor_intt_bool_cstringview(void* out, void* self, void* q, void* dim, void* keepdim, void* interpolation) { LANTERN_CHECK_LOADED void* ret = _lantern_quantile_out_tensor_tensor_tensor_intt_bool_cstringview(out, self, q, dim, keepdim, interpolation); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_quantile_tensor_double_intt_bool_cstringview)(void* self, void* q, void* dim, void* keepdim, void* interpolation);
  HOST_API void* lantern_quantile_tensor_double_intt_bool_cstringview(void* self, void* q, void* dim, void* keepdim, void* interpolation) { LANTERN_CHECK_LOADED void* ret = _lantern_quantile_tensor_double_intt_bool_cstringview(self, q, dim, keepdim, interpolation); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_quantile_tensor_double_intt_bool_cstringview)(void* self, void* q, void* dim, void* keepdim, void* interpolation);
  HOST_API void* lantern_Tensor_quantile_tensor_double_intt_bool_cstringview(void* self, void* q, void* dim, void* keepdim, void* interpolation) { void* ret = _lantern_Tensor_quantile_tensor_double_intt_bool_cstringview(self, q, dim, keepdim, interpolation); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_quantile_out_tensor_tensor_double_intt_bool_cstringview)(void* out, void* self, void* q, void* dim, void* keepdim, void* interpolation);
  HOST_API void* lantern_quantile_out_tensor_tensor_double_intt_bool_cstringview(void* out, void* self, void* q, void* dim, void* keepdim, void* interpolation) { LANTERN_CHECK_LOADED void* ret = _lantern_quantile_out_tensor_tensor_double_intt_bool_cstringview(out, self, q, dim, keepdim, interpolation); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_nanquantile_tensor_tensor_intt_bool_cstringview)(void* self, void* q, void* dim, void* keepdim, void* interpolation);
  HOST_API void* lantern_nanquantile_tensor_tensor_intt_bool_cstringview(void* self, void* q, void* dim, void* keepdim, void* interpolation) { LANTERN_CHECK_LOADED void* ret = _lantern_nanquantile_tensor_tensor_intt_bool_cstringview(self, q, dim, keepdim, interpolation); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_nanquantile_tensor_tensor_intt_bool_cstringview)(void* self, void* q, void* dim, void* keepdim, void* interpolation);
  HOST_API void* lantern_Tensor_nanquantile_tensor_tensor_intt_bool_cstringview(void* self, void* q, void* dim, void* keepdim, void* interpolation) { void* ret = _lantern_Tensor_nanquantile_tensor_tensor_intt_bool_cstringview(self, q, dim, keepdim, interpolation); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_nanquantile_out_tensor_tensor_tensor_intt_bool_cstringview)(void* out, void* self, void* q, void* dim, void* keepdim, void* interpolation);
  HOST_API void* lantern_nanquantile_out_tensor_tensor_tensor_intt_bool_cstringview(void* out, void* self, void* q, void* dim, void* keepdim, void* interpolation) { LANTERN_CHECK_LOADED void* ret = _lantern_nanquantile_out_tensor_tensor_tensor_intt_bool_cstringview(out, self, q, dim, keepdim, interpolation); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_nanquantile_tensor_double_intt_bool_cstringview)(void* self, void* q, void* dim, void* keepdim, void* interpolation);
  HOST_API void* lantern_nanquantile_tensor_double_intt_bool_cstringview(void* self, void* q, void* dim, void* keepdim, void* interpolation) { LANTERN_CHECK_LOADED void* ret = _lantern_nanquantile_tensor_double_intt_bool_cstringview(self, q, dim, keepdim, interpolation); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_nanquantile_tensor_double_intt_bool_cstringview)(void* self, void* q, void* dim, void* keepdim, void* interpolation);
  HOST_API void* lantern_Tensor_nanquantile_tensor_double_intt_bool_cstringview(void* self, void* q, void* dim, void* keepdim, void* interpolation) { void* ret = _lantern_Tensor_nanquantile_tensor_double_intt_bool_cstringview(self, q, dim, keepdim, interpolation); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_nanquantile_out_tensor_tensor_double_intt_bool_cstringview)(void* out, void* self, void* q, void* dim, void* keepdim, void* interpolation);
  HOST_API void* lantern_nanquantile_out_tensor_tensor_double_intt_bool_cstringview(void* out, void* self, void* q, void* dim, void* keepdim, void* interpolation) { LANTERN_CHECK_LOADED void* ret = _lantern_nanquantile_out_tensor_tensor_double_intt_bool_cstringview(out, self, q, dim, keepdim, interpolation); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sort_out_tensor_tensor_tensor_intt_bool)(void* values, void* indices, void* self, void* dim, void* descending);
  HOST_API void* lantern_sort_out_tensor_tensor_tensor_intt_bool(void* values, void* indices, void* self, void* dim, void* descending) { LANTERN_CHECK_LOADED void* ret = _lantern_sort_out_tensor_tensor_tensor_intt_bool(values, indices, self, dim, descending); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sort_out_tensor_tensor_tensor_bool_intt_bool)(void* values, void* indices, void* self, void* stable, void* dim, void* descending);
  HOST_API void* lantern_sort_out_tensor_tensor_tensor_bool_intt_bool(void* values, void* indices, void* self, void* stable, void* dim, void* descending) { LANTERN_CHECK_LOADED void* ret = _lantern_sort_out_tensor_tensor_tensor_bool_intt_bool(values, indices, self, stable, dim, descending); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sort_tensor_intt_bool)(void* self, void* dim, void* descending);
  HOST_API void* lantern_sort_tensor_intt_bool(void* self, void* dim, void* descending) { LANTERN_CHECK_LOADED void* ret = _lantern_sort_tensor_intt_bool(self, dim, descending); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_sort_tensor_intt_bool)(void* self, void* dim, void* descending);
  HOST_API void* lantern_Tensor_sort_tensor_intt_bool(void* self, void* dim, void* descending) { void* ret = _lantern_Tensor_sort_tensor_intt_bool(self, dim, descending); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sort_tensor_bool_intt_bool)(void* self, void* stable, void* dim, void* descending);
  HOST_API void* lantern_sort_tensor_bool_intt_bool(void* self, void* stable, void* dim, void* descending) { LANTERN_CHECK_LOADED void* ret = _lantern_sort_tensor_bool_intt_bool(self, stable, dim, descending); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_sort_tensor_bool_intt_bool)(void* self, void* stable, void* dim, void* descending);
  HOST_API void* lantern_Tensor_sort_tensor_bool_intt_bool(void* self, void* stable, void* dim, void* descending) { void* ret = _lantern_Tensor_sort_tensor_bool_intt_bool(self, stable, dim, descending); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sort_out_tensor_tensor_tensor_dimname_bool)(void* values, void* indices, void* self, void* dim, void* descending);
  HOST_API void* lantern_sort_out_tensor_tensor_tensor_dimname_bool(void* values, void* indices, void* self, void* dim, void* descending) { LANTERN_CHECK_LOADED void* ret = _lantern_sort_out_tensor_tensor_tensor_dimname_bool(values, indices, self, dim, descending); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sort_out_tensor_tensor_tensor_bool_dimname_bool)(void* values, void* indices, void* self, void* stable, void* dim, void* descending);
  HOST_API void* lantern_sort_out_tensor_tensor_tensor_bool_dimname_bool(void* values, void* indices, void* self, void* stable, void* dim, void* descending) { LANTERN_CHECK_LOADED void* ret = _lantern_sort_out_tensor_tensor_tensor_bool_dimname_bool(values, indices, self, stable, dim, descending); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sort_tensor_dimname_bool)(void* self, void* dim, void* descending);
  HOST_API void* lantern_sort_tensor_dimname_bool(void* self, void* dim, void* descending) { LANTERN_CHECK_LOADED void* ret = _lantern_sort_tensor_dimname_bool(self, dim, descending); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_sort_tensor_dimname_bool)(void* self, void* dim, void* descending);
  HOST_API void* lantern_Tensor_sort_tensor_dimname_bool(void* self, void* dim, void* descending) { void* ret = _lantern_Tensor_sort_tensor_dimname_bool(self, dim, descending); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_sort_tensor_bool_dimname_bool)(void* self, void* stable, void* dim, void* descending);
  HOST_API void* lantern_sort_tensor_bool_dimname_bool(void* self, void* stable, void* dim, void* descending) { LANTERN_CHECK_LOADED void* ret = _lantern_sort_tensor_bool_dimname_bool(self, stable, dim, descending); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_sort_tensor_bool_dimname_bool)(void* self, void* stable, void* dim, void* descending);
  HOST_API void* lantern_Tensor_sort_tensor_bool_dimname_bool(void* self, void* stable, void* dim, void* descending) { void* ret = _lantern_Tensor_sort_tensor_bool_dimname_bool(self, stable, dim, descending); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_msort_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_msort_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_msort_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_msort_tensor)(void* self);
  HOST_API void* lantern_msort_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_msort_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_msort_tensor)(void* self);
  HOST_API void* lantern_Tensor_msort_tensor(void* self) { void* ret = _lantern_Tensor_msort_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_argsort_tensor_intt_bool)(void* self, void* dim, void* descending);
  HOST_API void* lantern_argsort_tensor_intt_bool(void* self, void* dim, void* descending) { LANTERN_CHECK_LOADED void* ret = _lantern_argsort_tensor_intt_bool(self, dim, descending); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_argsort_tensor_intt_bool)(void* self, void* dim, void* descending);
  HOST_API void* lantern_Tensor_argsort_tensor_intt_bool(void* self, void* dim, void* descending) { void* ret = _lantern_Tensor_argsort_tensor_intt_bool(self, dim, descending); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_argsort_tensor_bool_intt_bool)(void* self, void* stable, void* dim, void* descending);
  HOST_API void* lantern_argsort_tensor_bool_intt_bool(void* self, void* stable, void* dim, void* descending) { LANTERN_CHECK_LOADED void* ret = _lantern_argsort_tensor_bool_intt_bool(self, stable, dim, descending); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_argsort_tensor_bool_intt_bool)(void* self, void* stable, void* dim, void* descending);
  HOST_API void* lantern_Tensor_argsort_tensor_bool_intt_bool(void* self, void* stable, void* dim, void* descending) { void* ret = _lantern_Tensor_argsort_tensor_bool_intt_bool(self, stable, dim, descending); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_argsort_tensor_dimname_bool)(void* self, void* dim, void* descending);
  HOST_API void* lantern_argsort_tensor_dimname_bool(void* self, void* dim, void* descending) { LANTERN_CHECK_LOADED void* ret = _lantern_argsort_tensor_dimname_bool(self, dim, descending); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_argsort_tensor_dimname_bool)(void* self, void* dim, void* descending);
  HOST_API void* lantern_Tensor_argsort_tensor_dimname_bool(void* self, void* dim, void* descending) { void* ret = _lantern_Tensor_argsort_tensor_dimname_bool(self, dim, descending); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_topk_out_tensor_tensor_tensor_intt_intt_bool_bool)(void* values, void* indices, void* self, void* k, void* dim, void* largest, void* sorted);
  HOST_API void* lantern_topk_out_tensor_tensor_tensor_intt_intt_bool_bool(void* values, void* indices, void* self, void* k, void* dim, void* largest, void* sorted) { LANTERN_CHECK_LOADED void* ret = _lantern_topk_out_tensor_tensor_tensor_intt_intt_bool_bool(values, indices, self, k, dim, largest, sorted); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_topk_tensor_intt_intt_bool_bool)(void* self, void* k, void* dim, void* largest, void* sorted);
  HOST_API void* lantern_topk_tensor_intt_intt_bool_bool(void* self, void* k, void* dim, void* largest, void* sorted) { LANTERN_CHECK_LOADED void* ret = _lantern_topk_tensor_intt_intt_bool_bool(self, k, dim, largest, sorted); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_topk_tensor_intt_intt_bool_bool)(void* self, void* k, void* dim, void* largest, void* sorted);
  HOST_API void* lantern_Tensor_topk_tensor_intt_intt_bool_bool(void* self, void* k, void* dim, void* largest, void* sorted) { void* ret = _lantern_Tensor_topk_tensor_intt_intt_bool_bool(self, k, dim, largest, sorted); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_all_tensor)(void* self);
  HOST_API void* lantern_all_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_all_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_all_tensor)(void* self);
  HOST_API void* lantern_Tensor_all_tensor(void* self) { void* ret = _lantern_Tensor_all_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_all_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_all_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_all_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_any_tensor)(void* self);
  HOST_API void* lantern_any_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_any_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_any_tensor)(void* self);
  HOST_API void* lantern_Tensor_any_tensor(void* self) { void* ret = _lantern_Tensor_any_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_any_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_any_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_any_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_renorm_out_tensor_tensor_scalar_intt_scalar)(void* out, void* self, void* p, void* dim, void* maxnorm);
  HOST_API void* lantern_renorm_out_tensor_tensor_scalar_intt_scalar(void* out, void* self, void* p, void* dim, void* maxnorm) { LANTERN_CHECK_LOADED void* ret = _lantern_renorm_out_tensor_tensor_scalar_intt_scalar(out, self, p, dim, maxnorm); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_renorm_tensor_scalar_intt_scalar)(void* self, void* p, void* dim, void* maxnorm);
  HOST_API void* lantern_renorm_tensor_scalar_intt_scalar(void* self, void* p, void* dim, void* maxnorm) { LANTERN_CHECK_LOADED void* ret = _lantern_renorm_tensor_scalar_intt_scalar(self, p, dim, maxnorm); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_renorm_tensor_scalar_intt_scalar)(void* self, void* p, void* dim, void* maxnorm);
  HOST_API void* lantern_Tensor_renorm_tensor_scalar_intt_scalar(void* self, void* p, void* dim, void* maxnorm) { void* ret = _lantern_Tensor_renorm_tensor_scalar_intt_scalar(self, p, dim, maxnorm); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_renorm__tensor_scalar_intt_scalar)(void* self, void* p, void* dim, void* maxnorm);
  HOST_API void* lantern_Tensor_renorm__tensor_scalar_intt_scalar(void* self, void* p, void* dim, void* maxnorm) { void* ret = _lantern_Tensor_renorm__tensor_scalar_intt_scalar(self, p, dim, maxnorm); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_unfold_tensor_intt_intt_intt)(void* self, void* dimension, void* size, void* step);
  HOST_API void* lantern_Tensor_unfold_tensor_intt_intt_intt(void* self, void* dimension, void* size, void* step) { void* ret = _lantern_Tensor_unfold_tensor_intt_intt_intt(self, dimension, size, step); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_unfold_backward_tensor_intarrayref_intt_intt_intt)(void* grad_in, void* input_sizes, void* dim, void* size, void* step);
  HOST_API void* lantern_unfold_backward_tensor_intarrayref_intt_intt_intt(void* grad_in, void* input_sizes, void* dim, void* size, void* step) { LANTERN_CHECK_LOADED void* ret = _lantern_unfold_backward_tensor_intarrayref_intt_intt_intt(grad_in, input_sizes, dim, size, step); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_equal_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_equal_tensor_tensor(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern_equal_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_equal_tensor_tensor)(void* self, void* other);
  HOST_API void* lantern_Tensor_equal_tensor_tensor(void* self, void* other) { void* ret = _lantern_Tensor_equal_tensor_tensor(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_pow_out_tensor_tensor_tensor)(void* out, void* self, void* exponent);
  HOST_API void* lantern_pow_out_tensor_tensor_tensor(void* out, void* self, void* exponent) { LANTERN_CHECK_LOADED void* ret = _lantern_pow_out_tensor_tensor_tensor(out, self, exponent); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_pow_tensor_tensor)(void* self, void* exponent);
  HOST_API void* lantern_pow_tensor_tensor(void* self, void* exponent) { LANTERN_CHECK_LOADED void* ret = _lantern_pow_tensor_tensor(self, exponent); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_pow_tensor_tensor)(void* self, void* exponent);
  HOST_API void* lantern_Tensor_pow_tensor_tensor(void* self, void* exponent) { void* ret = _lantern_Tensor_pow_tensor_tensor(self, exponent); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_pow_out_tensor_scalar_tensor)(void* out, void* self, void* exponent);
  HOST_API void* lantern_pow_out_tensor_scalar_tensor(void* out, void* self, void* exponent) { LANTERN_CHECK_LOADED void* ret = _lantern_pow_out_tensor_scalar_tensor(out, self, exponent); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_pow_scalar_tensor)(void* self, void* exponent);
  HOST_API void* lantern_pow_scalar_tensor(void* self, void* exponent) { LANTERN_CHECK_LOADED void* ret = _lantern_pow_scalar_tensor(self, exponent); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_pow_out_tensor_tensor_scalar)(void* out, void* self, void* exponent);
  HOST_API void* lantern_pow_out_tensor_tensor_scalar(void* out, void* self, void* exponent) { LANTERN_CHECK_LOADED void* ret = _lantern_pow_out_tensor_tensor_scalar(out, self, exponent); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_pow_tensor_scalar)(void* self, void* exponent);
  HOST_API void* lantern_pow_tensor_scalar(void* self, void* exponent) { LANTERN_CHECK_LOADED void* ret = _lantern_pow_tensor_scalar(self, exponent); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_pow_tensor_scalar)(void* self, void* exponent);
  HOST_API void* lantern_Tensor_pow_tensor_scalar(void* self, void* exponent) { void* ret = _lantern_Tensor_pow_tensor_scalar(self, exponent); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_pow__tensor_scalar)(void* self, void* exponent);
  HOST_API void* lantern_Tensor_pow__tensor_scalar(void* self, void* exponent) { void* ret = _lantern_Tensor_pow__tensor_scalar(self, exponent); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_pow__tensor_tensor)(void* self, void* exponent);
  HOST_API void* lantern_Tensor_pow__tensor_tensor(void* self, void* exponent) { void* ret = _lantern_Tensor_pow__tensor_tensor(self, exponent); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_float_power_out_tensor_tensor_tensor)(void* out, void* self, void* exponent);
  HOST_API void* lantern_float_power_out_tensor_tensor_tensor(void* out, void* self, void* exponent) { LANTERN_CHECK_LOADED void* ret = _lantern_float_power_out_tensor_tensor_tensor(out, self, exponent); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_float_power_tensor_tensor)(void* self, void* exponent);
  HOST_API void* lantern_float_power_tensor_tensor(void* self, void* exponent) { LANTERN_CHECK_LOADED void* ret = _lantern_float_power_tensor_tensor(self, exponent); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_float_power_tensor_tensor)(void* self, void* exponent);
  HOST_API void* lantern_Tensor_float_power_tensor_tensor(void* self, void* exponent) { void* ret = _lantern_Tensor_float_power_tensor_tensor(self, exponent); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_float_power_out_tensor_scalar_tensor)(void* out, void* self, void* exponent);
  HOST_API void* lantern_float_power_out_tensor_scalar_tensor(void* out, void* self, void* exponent) { LANTERN_CHECK_LOADED void* ret = _lantern_float_power_out_tensor_scalar_tensor(out, self, exponent); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_float_power_scalar_tensor)(void* self, void* exponent);
  HOST_API void* lantern_float_power_scalar_tensor(void* self, void* exponent) { LANTERN_CHECK_LOADED void* ret = _lantern_float_power_scalar_tensor(self, exponent); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_float_power_out_tensor_tensor_scalar)(void* out, void* self, void* exponent);
  HOST_API void* lantern_float_power_out_tensor_tensor_scalar(void* out, void* self, void* exponent) { LANTERN_CHECK_LOADED void* ret = _lantern_float_power_out_tensor_tensor_scalar(out, self, exponent); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_float_power_tensor_scalar)(void* self, void* exponent);
  HOST_API void* lantern_float_power_tensor_scalar(void* self, void* exponent) { LANTERN_CHECK_LOADED void* ret = _lantern_float_power_tensor_scalar(self, exponent); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_float_power_tensor_scalar)(void* self, void* exponent);
  HOST_API void* lantern_Tensor_float_power_tensor_scalar(void* self, void* exponent) { void* ret = _lantern_Tensor_float_power_tensor_scalar(self, exponent); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_float_power__tensor_scalar)(void* self, void* exponent);
  HOST_API void* lantern_Tensor_float_power__tensor_scalar(void* self, void* exponent) { void* ret = _lantern_Tensor_float_power__tensor_scalar(self, exponent); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_float_power__tensor_tensor)(void* self, void* exponent);
  HOST_API void* lantern_Tensor_float_power__tensor_tensor(void* self, void* exponent) { void* ret = _lantern_Tensor_float_power__tensor_tensor(self, exponent); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_normal__tensor_double_double_generator)(void* self, void* mean, void* std, void* generator);
  HOST_API void* lantern_Tensor_normal__tensor_double_double_generator(void* self, void* mean, void* std, void* generator) { void* ret = _lantern_Tensor_normal__tensor_double_double_generator(self, mean, std, generator); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_normal_functional_tensor_double_double_generator)(void* self, void* mean, void* std, void* generator);
  HOST_API void* lantern_normal_functional_tensor_double_double_generator(void* self, void* mean, void* std, void* generator) { LANTERN_CHECK_LOADED void* ret = _lantern_normal_functional_tensor_double_double_generator(self, mean, std, generator); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_normal_out_tensor_tensor_double_generator)(void* out, void* mean, void* std, void* generator);
  HOST_API void* lantern_normal_out_tensor_tensor_double_generator(void* out, void* mean, void* std, void* generator) { LANTERN_CHECK_LOADED void* ret = _lantern_normal_out_tensor_tensor_double_generator(out, mean, std, generator); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_normal_out_tensor_double_tensor_generator)(void* out, void* mean, void* std, void* generator);
  HOST_API void* lantern_normal_out_tensor_double_tensor_generator(void* out, void* mean, void* std, void* generator) { LANTERN_CHECK_LOADED void* ret = _lantern_normal_out_tensor_double_tensor_generator(out, mean, std, generator); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_normal_out_tensor_tensor_tensor_generator)(void* out, void* mean, void* std, void* generator);
  HOST_API void* lantern_normal_out_tensor_tensor_tensor_generator(void* out, void* mean, void* std, void* generator) { LANTERN_CHECK_LOADED void* ret = _lantern_normal_out_tensor_tensor_tensor_generator(out, mean, std, generator); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_normal_out_tensor_double_double_intarrayref_generator)(void* out, void* mean, void* std, void* size, void* generator);
  HOST_API void* lantern_normal_out_tensor_double_double_intarrayref_generator(void* out, void* mean, void* std, void* size, void* generator) { LANTERN_CHECK_LOADED void* ret = _lantern_normal_out_tensor_double_double_intarrayref_generator(out, mean, std, size, generator); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_alias_tensor)(void* self);
  HOST_API void* lantern_alias_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_alias_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_Tensor_alias_tensor)(void* self);
  HOST_API void* lantern_Tensor_alias_tensor(void* self) { void* ret = _lantern_Tensor_alias_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__amp_foreach_non_finite_check_and_unscale__tensorlist_tensor_tensor)(void* self, void* found_inf, void* inv_scale);
  HOST_API void* lantern__amp_foreach_non_finite_check_and_unscale__tensorlist_tensor_tensor(void* self, void* found_inf, void* inv_scale) { LANTERN_CHECK_LOADED void* ret = _lantern__amp_foreach_non_finite_check_and_unscale__tensorlist_tensor_tensor(self, found_inf, inv_scale); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__amp_update_scale__tensor_tensor_tensor_double_double_intt)(void* self, void* growth_tracker, void* found_inf, void* scale_growth_factor, void* scale_backoff_factor, void* growth_interval);
  HOST_API void* lantern__amp_update_scale__tensor_tensor_tensor_double_double_intt(void* self, void* growth_tracker, void* found_inf, void* scale_growth_factor, void* scale_backoff_factor, void* growth_interval) { LANTERN_CHECK_LOADED void* ret = _lantern__amp_update_scale__tensor_tensor_tensor_double_double_intt(self, growth_tracker, found_inf, scale_growth_factor, scale_backoff_factor, growth_interval); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_add_tensorlist_scalar)(void* self, void* scalar);
  HOST_API void* lantern__foreach_add_tensorlist_scalar(void* self, void* scalar) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_add_tensorlist_scalar(self, scalar); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_add__tensorlist_scalar)(void* self, void* scalar);
  HOST_API void* lantern__foreach_add__tensorlist_scalar(void* self, void* scalar) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_add__tensorlist_scalar(self, scalar); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_sub_tensorlist_scalar)(void* self, void* scalar);
  HOST_API void* lantern__foreach_sub_tensorlist_scalar(void* self, void* scalar) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_sub_tensorlist_scalar(self, scalar); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_sub__tensorlist_scalar)(void* self, void* scalar);
  HOST_API void* lantern__foreach_sub__tensorlist_scalar(void* self, void* scalar) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_sub__tensorlist_scalar(self, scalar); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_mul_tensorlist_scalar)(void* self, void* scalar);
  HOST_API void* lantern__foreach_mul_tensorlist_scalar(void* self, void* scalar) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_mul_tensorlist_scalar(self, scalar); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_mul__tensorlist_scalar)(void* self, void* scalar);
  HOST_API void* lantern__foreach_mul__tensorlist_scalar(void* self, void* scalar) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_mul__tensorlist_scalar(self, scalar); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_div_tensorlist_scalar)(void* self, void* scalar);
  HOST_API void* lantern__foreach_div_tensorlist_scalar(void* self, void* scalar) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_div_tensorlist_scalar(self, scalar); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_div__tensorlist_scalar)(void* self, void* scalar);
  HOST_API void* lantern__foreach_div__tensorlist_scalar(void* self, void* scalar) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_div__tensorlist_scalar(self, scalar); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_add_tensorlist_tensorlist_scalar)(void* self, void* other, void* alpha);
  HOST_API void* lantern__foreach_add_tensorlist_tensorlist_scalar(void* self, void* other, void* alpha) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_add_tensorlist_tensorlist_scalar(self, other, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_add__tensorlist_tensorlist_scalar)(void* self, void* other, void* alpha);
  HOST_API void* lantern__foreach_add__tensorlist_tensorlist_scalar(void* self, void* other, void* alpha) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_add__tensorlist_tensorlist_scalar(self, other, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_sub_tensorlist_tensorlist_scalar)(void* self, void* other, void* alpha);
  HOST_API void* lantern__foreach_sub_tensorlist_tensorlist_scalar(void* self, void* other, void* alpha) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_sub_tensorlist_tensorlist_scalar(self, other, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_sub__tensorlist_tensorlist_scalar)(void* self, void* other, void* alpha);
  HOST_API void* lantern__foreach_sub__tensorlist_tensorlist_scalar(void* self, void* other, void* alpha) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_sub__tensorlist_tensorlist_scalar(self, other, alpha); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_mul_tensorlist_tensorlist)(void* self, void* other);
  HOST_API void* lantern__foreach_mul_tensorlist_tensorlist(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_mul_tensorlist_tensorlist(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_mul__tensorlist_tensorlist)(void* self, void* other);
  HOST_API void* lantern__foreach_mul__tensorlist_tensorlist(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_mul__tensorlist_tensorlist(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_div_tensorlist_tensorlist)(void* self, void* other);
  HOST_API void* lantern__foreach_div_tensorlist_tensorlist(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_div_tensorlist_tensorlist(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_div__tensorlist_tensorlist)(void* self, void* other);
  HOST_API void* lantern__foreach_div__tensorlist_tensorlist(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_div__tensorlist_tensorlist(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_add_tensorlist_arrayrefscalar)(void* self, void* scalars);
  HOST_API void* lantern__foreach_add_tensorlist_arrayrefscalar(void* self, void* scalars) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_add_tensorlist_arrayrefscalar(self, scalars); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_add__tensorlist_arrayrefscalar)(void* self, void* scalars);
  HOST_API void* lantern__foreach_add__tensorlist_arrayrefscalar(void* self, void* scalars) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_add__tensorlist_arrayrefscalar(self, scalars); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_sub_tensorlist_arrayrefscalar)(void* self, void* scalars);
  HOST_API void* lantern__foreach_sub_tensorlist_arrayrefscalar(void* self, void* scalars) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_sub_tensorlist_arrayrefscalar(self, scalars); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_sub__tensorlist_arrayrefscalar)(void* self, void* scalars);
  HOST_API void* lantern__foreach_sub__tensorlist_arrayrefscalar(void* self, void* scalars) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_sub__tensorlist_arrayrefscalar(self, scalars); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_div_tensorlist_arrayrefscalar)(void* self, void* scalars);
  HOST_API void* lantern__foreach_div_tensorlist_arrayrefscalar(void* self, void* scalars) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_div_tensorlist_arrayrefscalar(self, scalars); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_div__tensorlist_arrayrefscalar)(void* self, void* scalars);
  HOST_API void* lantern__foreach_div__tensorlist_arrayrefscalar(void* self, void* scalars) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_div__tensorlist_arrayrefscalar(self, scalars); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_mul_tensorlist_arrayrefscalar)(void* self, void* scalars);
  HOST_API void* lantern__foreach_mul_tensorlist_arrayrefscalar(void* self, void* scalars) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_mul_tensorlist_arrayrefscalar(self, scalars); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_mul__tensorlist_arrayrefscalar)(void* self, void* scalars);
  HOST_API void* lantern__foreach_mul__tensorlist_arrayrefscalar(void* self, void* scalars) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_mul__tensorlist_arrayrefscalar(self, scalars); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_exp_tensorlist)(void* self);
  HOST_API void* lantern__foreach_exp_tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_exp_tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_zero__tensorlist)(void* self);
  HOST_API void* lantern__foreach_zero__tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_zero__tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_exp__tensorlist)(void* self);
  HOST_API void* lantern__foreach_exp__tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_exp__tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_sqrt_tensorlist)(void* self);
  HOST_API void* lantern__foreach_sqrt_tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_sqrt_tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_sqrt__tensorlist)(void* self);
  HOST_API void* lantern__foreach_sqrt__tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_sqrt__tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_abs_tensorlist)(void* self);
  HOST_API void* lantern__foreach_abs_tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_abs_tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_abs__tensorlist)(void* self);
  HOST_API void* lantern__foreach_abs__tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_abs__tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_acos_tensorlist)(void* self);
  HOST_API void* lantern__foreach_acos_tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_acos_tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_acos__tensorlist)(void* self);
  HOST_API void* lantern__foreach_acos__tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_acos__tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_asin_tensorlist)(void* self);
  HOST_API void* lantern__foreach_asin_tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_asin_tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_asin__tensorlist)(void* self);
  HOST_API void* lantern__foreach_asin__tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_asin__tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_atan_tensorlist)(void* self);
  HOST_API void* lantern__foreach_atan_tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_atan_tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_atan__tensorlist)(void* self);
  HOST_API void* lantern__foreach_atan__tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_atan__tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_ceil_tensorlist)(void* self);
  HOST_API void* lantern__foreach_ceil_tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_ceil_tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_ceil__tensorlist)(void* self);
  HOST_API void* lantern__foreach_ceil__tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_ceil__tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_cos_tensorlist)(void* self);
  HOST_API void* lantern__foreach_cos_tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_cos_tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_cos__tensorlist)(void* self);
  HOST_API void* lantern__foreach_cos__tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_cos__tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_cosh_tensorlist)(void* self);
  HOST_API void* lantern__foreach_cosh_tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_cosh_tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_cosh__tensorlist)(void* self);
  HOST_API void* lantern__foreach_cosh__tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_cosh__tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_erf_tensorlist)(void* self);
  HOST_API void* lantern__foreach_erf_tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_erf_tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_erf__tensorlist)(void* self);
  HOST_API void* lantern__foreach_erf__tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_erf__tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_erfc_tensorlist)(void* self);
  HOST_API void* lantern__foreach_erfc_tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_erfc_tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_erfc__tensorlist)(void* self);
  HOST_API void* lantern__foreach_erfc__tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_erfc__tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_expm1_tensorlist)(void* self);
  HOST_API void* lantern__foreach_expm1_tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_expm1_tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_expm1__tensorlist)(void* self);
  HOST_API void* lantern__foreach_expm1__tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_expm1__tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_floor_tensorlist)(void* self);
  HOST_API void* lantern__foreach_floor_tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_floor_tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_floor__tensorlist)(void* self);
  HOST_API void* lantern__foreach_floor__tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_floor__tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_log_tensorlist)(void* self);
  HOST_API void* lantern__foreach_log_tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_log_tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_log__tensorlist)(void* self);
  HOST_API void* lantern__foreach_log__tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_log__tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_log10_tensorlist)(void* self);
  HOST_API void* lantern__foreach_log10_tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_log10_tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_log10__tensorlist)(void* self);
  HOST_API void* lantern__foreach_log10__tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_log10__tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_log1p_tensorlist)(void* self);
  HOST_API void* lantern__foreach_log1p_tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_log1p_tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_log1p__tensorlist)(void* self);
  HOST_API void* lantern__foreach_log1p__tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_log1p__tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_log2_tensorlist)(void* self);
  HOST_API void* lantern__foreach_log2_tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_log2_tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_log2__tensorlist)(void* self);
  HOST_API void* lantern__foreach_log2__tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_log2__tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_neg_tensorlist)(void* self);
  HOST_API void* lantern__foreach_neg_tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_neg_tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_neg__tensorlist)(void* self);
  HOST_API void* lantern__foreach_neg__tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_neg__tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_tan_tensorlist)(void* self);
  HOST_API void* lantern__foreach_tan_tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_tan_tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_tan__tensorlist)(void* self);
  HOST_API void* lantern__foreach_tan__tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_tan__tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_tanh_tensorlist)(void* self);
  HOST_API void* lantern__foreach_tanh_tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_tanh_tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_tanh__tensorlist)(void* self);
  HOST_API void* lantern__foreach_tanh__tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_tanh__tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_sin_tensorlist)(void* self);
  HOST_API void* lantern__foreach_sin_tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_sin_tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_sin__tensorlist)(void* self);
  HOST_API void* lantern__foreach_sin__tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_sin__tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_sinh_tensorlist)(void* self);
  HOST_API void* lantern__foreach_sinh_tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_sinh_tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_sinh__tensorlist)(void* self);
  HOST_API void* lantern__foreach_sinh__tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_sinh__tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_round_tensorlist)(void* self);
  HOST_API void* lantern__foreach_round_tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_round_tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_round__tensorlist)(void* self);
  HOST_API void* lantern__foreach_round__tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_round__tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_lgamma_tensorlist)(void* self);
  HOST_API void* lantern__foreach_lgamma_tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_lgamma_tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_lgamma__tensorlist)(void* self);
  HOST_API void* lantern__foreach_lgamma__tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_lgamma__tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_frac_tensorlist)(void* self);
  HOST_API void* lantern__foreach_frac_tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_frac_tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_frac__tensorlist)(void* self);
  HOST_API void* lantern__foreach_frac__tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_frac__tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_reciprocal_tensorlist)(void* self);
  HOST_API void* lantern__foreach_reciprocal_tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_reciprocal_tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_reciprocal__tensorlist)(void* self);
  HOST_API void* lantern__foreach_reciprocal__tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_reciprocal__tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_sigmoid_tensorlist)(void* self);
  HOST_API void* lantern__foreach_sigmoid_tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_sigmoid_tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_sigmoid__tensorlist)(void* self);
  HOST_API void* lantern__foreach_sigmoid__tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_sigmoid__tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_trunc_tensorlist)(void* self);
  HOST_API void* lantern__foreach_trunc_tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_trunc_tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_trunc__tensorlist)(void* self);
  HOST_API void* lantern__foreach_trunc__tensorlist(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_trunc__tensorlist(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_addcdiv__tensorlist_tensorlist_tensorlist_scalar)(void* self, void* tensor1, void* tensor2, void* value);
  HOST_API void* lantern__foreach_addcdiv__tensorlist_tensorlist_tensorlist_scalar(void* self, void* tensor1, void* tensor2, void* value) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_addcdiv__tensorlist_tensorlist_tensorlist_scalar(self, tensor1, tensor2, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_addcmul__tensorlist_tensorlist_tensorlist_scalar)(void* self, void* tensor1, void* tensor2, void* value);
  HOST_API void* lantern__foreach_addcmul__tensorlist_tensorlist_tensorlist_scalar(void* self, void* tensor1, void* tensor2, void* value) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_addcmul__tensorlist_tensorlist_tensorlist_scalar(self, tensor1, tensor2, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_addcdiv__tensorlist_tensorlist_tensorlist_arrayrefscalar)(void* self, void* tensor1, void* tensor2, void* scalars);
  HOST_API void* lantern__foreach_addcdiv__tensorlist_tensorlist_tensorlist_arrayrefscalar(void* self, void* tensor1, void* tensor2, void* scalars) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_addcdiv__tensorlist_tensorlist_tensorlist_arrayrefscalar(self, tensor1, tensor2, scalars); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_addcmul__tensorlist_tensorlist_tensorlist_arrayrefscalar)(void* self, void* tensor1, void* tensor2, void* scalars);
  HOST_API void* lantern__foreach_addcmul__tensorlist_tensorlist_tensorlist_arrayrefscalar(void* self, void* tensor1, void* tensor2, void* scalars) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_addcmul__tensorlist_tensorlist_tensorlist_arrayrefscalar(self, tensor1, tensor2, scalars); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_addcdiv_tensorlist_tensorlist_tensorlist_scalar)(void* self, void* tensor1, void* tensor2, void* value);
  HOST_API void* lantern__foreach_addcdiv_tensorlist_tensorlist_tensorlist_scalar(void* self, void* tensor1, void* tensor2, void* value) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_addcdiv_tensorlist_tensorlist_tensorlist_scalar(self, tensor1, tensor2, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_addcmul_tensorlist_tensorlist_tensorlist_scalar)(void* self, void* tensor1, void* tensor2, void* value);
  HOST_API void* lantern__foreach_addcmul_tensorlist_tensorlist_tensorlist_scalar(void* self, void* tensor1, void* tensor2, void* value) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_addcmul_tensorlist_tensorlist_tensorlist_scalar(self, tensor1, tensor2, value); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_addcdiv_tensorlist_tensorlist_tensorlist_arrayrefscalar)(void* self, void* tensor1, void* tensor2, void* scalars);
  HOST_API void* lantern__foreach_addcdiv_tensorlist_tensorlist_tensorlist_arrayrefscalar(void* self, void* tensor1, void* tensor2, void* scalars) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_addcdiv_tensorlist_tensorlist_tensorlist_arrayrefscalar(self, tensor1, tensor2, scalars); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_addcmul_tensorlist_tensorlist_tensorlist_arrayrefscalar)(void* self, void* tensor1, void* tensor2, void* scalars);
  HOST_API void* lantern__foreach_addcmul_tensorlist_tensorlist_tensorlist_arrayrefscalar(void* self, void* tensor1, void* tensor2, void* scalars) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_addcmul_tensorlist_tensorlist_tensorlist_arrayrefscalar(self, tensor1, tensor2, scalars); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_maximum_tensorlist_tensorlist)(void* self, void* other);
  HOST_API void* lantern__foreach_maximum_tensorlist_tensorlist(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_maximum_tensorlist_tensorlist(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_maximum__tensorlist_tensorlist)(void* self, void* other);
  HOST_API void* lantern__foreach_maximum__tensorlist_tensorlist(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_maximum__tensorlist_tensorlist(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_minimum_tensorlist_tensorlist)(void* self, void* other);
  HOST_API void* lantern__foreach_minimum_tensorlist_tensorlist(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_minimum_tensorlist_tensorlist(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_minimum__tensorlist_tensorlist)(void* self, void* other);
  HOST_API void* lantern__foreach_minimum__tensorlist_tensorlist(void* self, void* other) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_minimum__tensorlist_tensorlist(self, other); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__foreach_norm_tensorlist_scalar)(void* self, void* ord);
  HOST_API void* lantern__foreach_norm_tensorlist_scalar(void* self, void* ord) { LANTERN_CHECK_LOADED void* ret = _lantern__foreach_norm_tensorlist_scalar(self, ord); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_bucketize_tensor_tensor_bool_bool)(void* self, void* boundaries, void* out_int32, void* right);
  HOST_API void* lantern_bucketize_tensor_tensor_bool_bool(void* self, void* boundaries, void* out_int32, void* right) { LANTERN_CHECK_LOADED void* ret = _lantern_bucketize_tensor_tensor_bool_bool(self, boundaries, out_int32, right); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_bucketize_out_tensor_tensor_tensor_bool_bool)(void* out, void* self, void* boundaries, void* out_int32, void* right);
  HOST_API void* lantern_bucketize_out_tensor_tensor_tensor_bool_bool(void* out, void* self, void* boundaries, void* out_int32, void* right) { LANTERN_CHECK_LOADED void* ret = _lantern_bucketize_out_tensor_tensor_tensor_bool_bool(out, self, boundaries, out_int32, right); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_bucketize_scalar_tensor_bool_bool)(void* self, void* boundaries, void* out_int32, void* right);
  HOST_API void* lantern_bucketize_scalar_tensor_bool_bool(void* self, void* boundaries, void* out_int32, void* right) { LANTERN_CHECK_LOADED void* ret = _lantern_bucketize_scalar_tensor_bool_bool(self, boundaries, out_int32, right); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_searchsorted_tensor_tensor_bool_bool_cstringview_tensor)(void* sorted_sequence, void* self, void* out_int32, void* right, void* side, void* sorter);
  HOST_API void* lantern_searchsorted_tensor_tensor_bool_bool_cstringview_tensor(void* sorted_sequence, void* self, void* out_int32, void* right, void* side, void* sorter) { LANTERN_CHECK_LOADED void* ret = _lantern_searchsorted_tensor_tensor_bool_bool_cstringview_tensor(sorted_sequence, self, out_int32, right, side, sorter); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__torch_cuda_cu_linker_symbol_op_tensor)(void* self);
  HOST_API void* lantern__torch_cuda_cu_linker_symbol_op_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__torch_cuda_cu_linker_symbol_op_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_searchsorted_out_tensor_tensor_tensor_bool_bool_cstringview_tensor)(void* out, void* sorted_sequence, void* self, void* out_int32, void* right, void* side, void* sorter);
  HOST_API void* lantern_searchsorted_out_tensor_tensor_tensor_bool_bool_cstringview_tensor(void* out, void* sorted_sequence, void* self, void* out_int32, void* right, void* side, void* sorter) { LANTERN_CHECK_LOADED void* ret = _lantern_searchsorted_out_tensor_tensor_tensor_bool_bool_cstringview_tensor(out, sorted_sequence, self, out_int32, right, side, sorter); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_searchsorted_tensor_scalar_bool_bool_cstringview_tensor)(void* sorted_sequence, void* self, void* out_int32, void* right, void* side, void* sorter);
  HOST_API void* lantern_searchsorted_tensor_scalar_bool_bool_cstringview_tensor(void* sorted_sequence, void* self, void* out_int32, void* right, void* side, void* sorter) { LANTERN_CHECK_LOADED void* ret = _lantern_searchsorted_tensor_scalar_bool_bool_cstringview_tensor(sorted_sequence, self, out_int32, right, side, sorter); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__convert_indices_from_coo_to_csr_tensor_intt_bool)(void* self, void* size, void* out_int32);
  HOST_API void* lantern__convert_indices_from_coo_to_csr_tensor_intt_bool(void* self, void* size, void* out_int32) { LANTERN_CHECK_LOADED void* ret = _lantern__convert_indices_from_coo_to_csr_tensor_intt_bool(self, size, out_int32); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__convert_indices_from_coo_to_csr_out_tensor_tensor_intt_bool)(void* out, void* self, void* size, void* out_int32);
  HOST_API void* lantern__convert_indices_from_coo_to_csr_out_tensor_tensor_intt_bool(void* out, void* self, void* size, void* out_int32) { LANTERN_CHECK_LOADED void* ret = _lantern__convert_indices_from_coo_to_csr_out_tensor_tensor_intt_bool(out, self, size, out_int32); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__convert_indices_from_csr_to_coo_tensor_tensor_bool_bool)(void* crow_indices, void* col_indices, void* out_int32, void* transpose);
  HOST_API void* lantern__convert_indices_from_csr_to_coo_tensor_tensor_bool_bool(void* crow_indices, void* col_indices, void* out_int32, void* transpose) { LANTERN_CHECK_LOADED void* ret = _lantern__convert_indices_from_csr_to_coo_tensor_tensor_bool_bool(crow_indices, col_indices, out_int32, transpose); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__convert_indices_from_csr_to_coo_out_tensor_tensor_tensor_bool_bool)(void* out, void* crow_indices, void* col_indices, void* out_int32, void* transpose);
  HOST_API void* lantern__convert_indices_from_csr_to_coo_out_tensor_tensor_tensor_bool_bool(void* out, void* crow_indices, void* col_indices, void* out_int32, void* transpose) { LANTERN_CHECK_LOADED void* ret = _lantern__convert_indices_from_csr_to_coo_out_tensor_tensor_tensor_bool_bool(out, crow_indices, col_indices, out_int32, transpose); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_mse_loss_out_tensor_tensor_tensor_intt)(void* out, void* self, void* target, void* reduction);
  HOST_API void* lantern_mse_loss_out_tensor_tensor_tensor_intt(void* out, void* self, void* target, void* reduction) { LANTERN_CHECK_LOADED void* ret = _lantern_mse_loss_out_tensor_tensor_tensor_intt(out, self, target, reduction); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_mse_loss_tensor_tensor_intt)(void* self, void* target, void* reduction);
  HOST_API void* lantern_mse_loss_tensor_tensor_intt(void* self, void* target, void* reduction) { LANTERN_CHECK_LOADED void* ret = _lantern_mse_loss_tensor_tensor_intt(self, target, reduction); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_mse_loss_backward_out_tensor_tensor_tensor_tensor_intt)(void* grad_input, void* grad_output, void* self, void* target, void* reduction);
  HOST_API void* lantern_mse_loss_backward_out_tensor_tensor_tensor_tensor_intt(void* grad_input, void* grad_output, void* self, void* target, void* reduction) { LANTERN_CHECK_LOADED void* ret = _lantern_mse_loss_backward_out_tensor_tensor_tensor_tensor_intt(grad_input, grad_output, self, target, reduction); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_mse_loss_backward_tensor_tensor_tensor_intt)(void* grad_output, void* self, void* target, void* reduction);
  HOST_API void* lantern_mse_loss_backward_tensor_tensor_tensor_intt(void* grad_output, void* self, void* target, void* reduction) { LANTERN_CHECK_LOADED void* ret = _lantern_mse_loss_backward_tensor_tensor_tensor_intt(grad_output, self, target, reduction); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_l1_loss_tensor_tensor_intt)(void* self, void* target, void* reduction);
  HOST_API void* lantern_l1_loss_tensor_tensor_intt(void* self, void* target, void* reduction) { LANTERN_CHECK_LOADED void* ret = _lantern_l1_loss_tensor_tensor_intt(self, target, reduction); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_multi_margin_loss_out_tensor_tensor_tensor_scalar_scalar_tensor_intt)(void* out, void* self, void* target, void* p, void* margin, void* weight, void* reduction);
  HOST_API void* lantern_multi_margin_loss_out_tensor_tensor_tensor_scalar_scalar_tensor_intt(void* out, void* self, void* target, void* p, void* margin, void* weight, void* reduction) { LANTERN_CHECK_LOADED void* ret = _lantern_multi_margin_loss_out_tensor_tensor_tensor_scalar_scalar_tensor_intt(out, self, target, p, margin, weight, reduction); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_multi_margin_loss_tensor_tensor_scalar_scalar_tensor_intt)(void* self, void* target, void* p, void* margin, void* weight, void* reduction);
  HOST_API void* lantern_multi_margin_loss_tensor_tensor_scalar_scalar_tensor_intt(void* self, void* target, void* p, void* margin, void* weight, void* reduction) { LANTERN_CHECK_LOADED void* ret = _lantern_multi_margin_loss_tensor_tensor_scalar_scalar_tensor_intt(self, target, p, margin, weight, reduction); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_multi_margin_loss_backward_out_tensor_tensor_tensor_tensor_scalar_scalar_tensor_intt)(void* grad_input, void* grad_output, void* self, void* target, void* p, void* margin, void* weight, void* reduction);
  HOST_API void* lantern_multi_margin_loss_backward_out_tensor_tensor_tensor_tensor_scalar_scalar_tensor_intt(void* grad_input, void* grad_output, void* self, void* target, void* p, void* margin, void* weight, void* reduction) { LANTERN_CHECK_LOADED void* ret = _lantern_multi_margin_loss_backward_out_tensor_tensor_tensor_tensor_scalar_scalar_tensor_intt(grad_input, grad_output, self, target, p, margin, weight, reduction); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_multi_margin_loss_backward_tensor_tensor_tensor_scalar_scalar_tensor_intt)(void* grad_output, void* self, void* target, void* p, void* margin, void* weight, void* reduction);
  HOST_API void* lantern_multi_margin_loss_backward_tensor_tensor_tensor_scalar_scalar_tensor_intt(void* grad_output, void* self, void* target, void* p, void* margin, void* weight, void* reduction) { LANTERN_CHECK_LOADED void* ret = _lantern_multi_margin_loss_backward_tensor_tensor_tensor_scalar_scalar_tensor_intt(grad_output, self, target, p, margin, weight, reduction); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_multilabel_margin_loss_out_tensor_tensor_tensor_intt)(void* out, void* self, void* target, void* reduction);
  HOST_API void* lantern_multilabel_margin_loss_out_tensor_tensor_tensor_intt(void* out, void* self, void* target, void* reduction) { LANTERN_CHECK_LOADED void* ret = _lantern_multilabel_margin_loss_out_tensor_tensor_tensor_intt(out, self, target, reduction); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_multilabel_margin_loss_tensor_tensor_intt)(void* self, void* target, void* reduction);
  HOST_API void* lantern_multilabel_margin_loss_tensor_tensor_intt(void* self, void* target, void* reduction) { LANTERN_CHECK_LOADED void* ret = _lantern_multilabel_margin_loss_tensor_tensor_intt(self, target, reduction); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_multilabel_margin_loss_forward_out_tensor_tensor_tensor_tensor_intt)(void* output, void* is_target, void* self, void* target, void* reduction);
  HOST_API void* lantern_multilabel_margin_loss_forward_out_tensor_tensor_tensor_tensor_intt(void* output, void* is_target, void* self, void* target, void* reduction) { LANTERN_CHECK_LOADED void* ret = _lantern_multilabel_margin_loss_forward_out_tensor_tensor_tensor_tensor_intt(output, is_target, self, target, reduction); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_multilabel_margin_loss_forward_tensor_tensor_intt)(void* self, void* target, void* reduction);
  HOST_API void* lantern_multilabel_margin_loss_forward_tensor_tensor_intt(void* self, void* target, void* reduction) { LANTERN_CHECK_LOADED void* ret = _lantern_multilabel_margin_loss_forward_tensor_tensor_intt(self, target, reduction); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_multilabel_margin_loss_backward_out_tensor_tensor_tensor_tensor_intt_tensor)(void* grad_input, void* grad_output, void* self, void* target, void* reduction, void* is_target);
  HOST_API void* lantern_multilabel_margin_loss_backward_out_tensor_tensor_tensor_tensor_intt_tensor(void* grad_input, void* grad_output, void* self, void* target, void* reduction, void* is_target) { LANTERN_CHECK_LOADED void* ret = _lantern_multilabel_margin_loss_backward_out_tensor_tensor_tensor_tensor_intt_tensor(grad_input, grad_output, self, target, reduction, is_target); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_multilabel_margin_loss_backward_tensor_tensor_tensor_intt_tensor)(void* grad_output, void* self, void* target, void* reduction, void* is_target);
  HOST_API void* lantern_multilabel_margin_loss_backward_tensor_tensor_tensor_intt_tensor(void* grad_output, void* self, void* target, void* reduction, void* is_target) { LANTERN_CHECK_LOADED void* ret = _lantern_multilabel_margin_loss_backward_tensor_tensor_tensor_intt_tensor(grad_output, self, target, reduction, is_target); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_nll_loss_out_tensor_tensor_tensor_tensor_intt_intt)(void* out, void* self, void* target, void* weight, void* reduction, void* ignore_index);
  HOST_API void* lantern_nll_loss_out_tensor_tensor_tensor_tensor_intt_intt(void* out, void* self, void* target, void* weight, void* reduction, void* ignore_index) { LANTERN_CHECK_LOADED void* ret = _lantern_nll_loss_out_tensor_tensor_tensor_tensor_intt_intt(out, self, target, weight, reduction, ignore_index); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_nll_loss_nd_tensor_tensor_tensor_intt_intt)(void* self, void* target, void* weight, void* reduction, void* ignore_index);
  HOST_API void* lantern_nll_loss_nd_tensor_tensor_tensor_intt_intt(void* self, void* target, void* weight, void* reduction, void* ignore_index) { LANTERN_CHECK_LOADED void* ret = _lantern_nll_loss_nd_tensor_tensor_tensor_intt_intt(self, target, weight, reduction, ignore_index); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_nll_loss_tensor_tensor_tensor_intt_intt)(void* self, void* target, void* weight, void* reduction, void* ignore_index);
  HOST_API void* lantern_nll_loss_tensor_tensor_tensor_intt_intt(void* self, void* target, void* weight, void* reduction, void* ignore_index) { LANTERN_CHECK_LOADED void* ret = _lantern_nll_loss_tensor_tensor_tensor_intt_intt(self, target, weight, reduction, ignore_index); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_nll_loss_forward_out_tensor_tensor_tensor_tensor_tensor_intt_intt)(void* output, void* total_weight, void* self, void* target, void* weight, void* reduction, void* ignore_index);
  HOST_API void* lantern_nll_loss_forward_out_tensor_tensor_tensor_tensor_tensor_intt_intt(void* output, void* total_weight, void* self, void* target, void* weight, void* reduction, void* ignore_index) { LANTERN_CHECK_LOADED void* ret = _lantern_nll_loss_forward_out_tensor_tensor_tensor_tensor_tensor_intt_intt(output, total_weight, self, target, weight, reduction, ignore_index); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_nll_loss_forward_tensor_tensor_tensor_intt_intt)(void* self, void* target, void* weight, void* reduction, void* ignore_index);
  HOST_API void* lantern_nll_loss_forward_tensor_tensor_tensor_intt_intt(void* self, void* target, void* weight, void* reduction, void* ignore_index) { LANTERN_CHECK_LOADED void* ret = _lantern_nll_loss_forward_tensor_tensor_tensor_intt_intt(self, target, weight, reduction, ignore_index); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_nll_loss_backward_out_tensor_tensor_tensor_tensor_tensor_intt_intt_tensor)(void* grad_input, void* grad_output, void* self, void* target, void* weight, void* reduction, void* ignore_index, void* total_weight);
  HOST_API void* lantern_nll_loss_backward_out_tensor_tensor_tensor_tensor_tensor_intt_intt_tensor(void* grad_input, void* grad_output, void* self, void* target, void* weight, void* reduction, void* ignore_index, void* total_weight) { LANTERN_CHECK_LOADED void* ret = _lantern_nll_loss_backward_out_tensor_tensor_tensor_tensor_tensor_intt_intt_tensor(grad_input, grad_output, self, target, weight, reduction, ignore_index, total_weight); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_nll_loss_backward_tensor_tensor_tensor_tensor_intt_intt_tensor)(void* grad_output, void* self, void* target, void* weight, void* reduction, void* ignore_index, void* total_weight);
  HOST_API void* lantern_nll_loss_backward_tensor_tensor_tensor_tensor_intt_intt_tensor(void* grad_output, void* self, void* target, void* weight, void* reduction, void* ignore_index, void* total_weight) { LANTERN_CHECK_LOADED void* ret = _lantern_nll_loss_backward_tensor_tensor_tensor_tensor_intt_intt_tensor(grad_output, self, target, weight, reduction, ignore_index, total_weight); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_nll_loss2d_out_tensor_tensor_tensor_tensor_intt_intt)(void* out, void* self, void* target, void* weight, void* reduction, void* ignore_index);
  HOST_API void* lantern_nll_loss2d_out_tensor_tensor_tensor_tensor_intt_intt(void* out, void* self, void* target, void* weight, void* reduction, void* ignore_index) { LANTERN_CHECK_LOADED void* ret = _lantern_nll_loss2d_out_tensor_tensor_tensor_tensor_intt_intt(out, self, target, weight, reduction, ignore_index); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_nll_loss2d_tensor_tensor_tensor_intt_intt)(void* self, void* target, void* weight, void* reduction, void* ignore_index);
  HOST_API void* lantern_nll_loss2d_tensor_tensor_tensor_intt_intt(void* self, void* target, void* weight, void* reduction, void* ignore_index) { LANTERN_CHECK_LOADED void* ret = _lantern_nll_loss2d_tensor_tensor_tensor_intt_intt(self, target, weight, reduction, ignore_index); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_nll_loss2d_forward_out_tensor_tensor_tensor_tensor_tensor_intt_intt)(void* output, void* total_weight, void* self, void* target, void* weight, void* reduction, void* ignore_index);
  HOST_API void* lantern_nll_loss2d_forward_out_tensor_tensor_tensor_tensor_tensor_intt_intt(void* output, void* total_weight, void* self, void* target, void* weight, void* reduction, void* ignore_index) { LANTERN_CHECK_LOADED void* ret = _lantern_nll_loss2d_forward_out_tensor_tensor_tensor_tensor_tensor_intt_intt(output, total_weight, self, target, weight, reduction, ignore_index); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_nll_loss2d_forward_tensor_tensor_tensor_intt_intt)(void* self, void* target, void* weight, void* reduction, void* ignore_index);
  HOST_API void* lantern_nll_loss2d_forward_tensor_tensor_tensor_intt_intt(void* self, void* target, void* weight, void* reduction, void* ignore_index) { LANTERN_CHECK_LOADED void* ret = _lantern_nll_loss2d_forward_tensor_tensor_tensor_intt_intt(self, target, weight, reduction, ignore_index); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_nll_loss2d_backward_out_tensor_tensor_tensor_tensor_tensor_intt_intt_tensor)(void* grad_input, void* grad_output, void* self, void* target, void* weight, void* reduction, void* ignore_index, void* total_weight);
  HOST_API void* lantern_nll_loss2d_backward_out_tensor_tensor_tensor_tensor_tensor_intt_intt_tensor(void* grad_input, void* grad_output, void* self, void* target, void* weight, void* reduction, void* ignore_index, void* total_weight) { LANTERN_CHECK_LOADED void* ret = _lantern_nll_loss2d_backward_out_tensor_tensor_tensor_tensor_tensor_intt_intt_tensor(grad_input, grad_output, self, target, weight, reduction, ignore_index, total_weight); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_nll_loss2d_backward_tensor_tensor_tensor_tensor_intt_intt_tensor)(void* grad_output, void* self, void* target, void* weight, void* reduction, void* ignore_index, void* total_weight);
  HOST_API void* lantern_nll_loss2d_backward_tensor_tensor_tensor_tensor_intt_intt_tensor(void* grad_output, void* self, void* target, void* weight, void* reduction, void* ignore_index, void* total_weight) { LANTERN_CHECK_LOADED void* ret = _lantern_nll_loss2d_backward_tensor_tensor_tensor_tensor_intt_intt_tensor(grad_output, self, target, weight, reduction, ignore_index, total_weight); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_smooth_l1_loss_out_tensor_tensor_tensor_intt_double)(void* out, void* self, void* target, void* reduction, void* beta);
  HOST_API void* lantern_smooth_l1_loss_out_tensor_tensor_tensor_intt_double(void* out, void* self, void* target, void* reduction, void* beta) { LANTERN_CHECK_LOADED void* ret = _lantern_smooth_l1_loss_out_tensor_tensor_tensor_intt_double(out, self, target, reduction, beta); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_smooth_l1_loss_tensor_tensor_intt_double)(void* self, void* target, void* reduction, void* beta);
  HOST_API void* lantern_smooth_l1_loss_tensor_tensor_intt_double(void* self, void* target, void* reduction, void* beta) { LANTERN_CHECK_LOADED void* ret = _lantern_smooth_l1_loss_tensor_tensor_intt_double(self, target, reduction, beta); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_smooth_l1_loss_backward_out_tensor_tensor_tensor_tensor_intt_double)(void* grad_input, void* grad_output, void* self, void* target, void* reduction, void* beta);
  HOST_API void* lantern_smooth_l1_loss_backward_out_tensor_tensor_tensor_tensor_intt_double(void* grad_input, void* grad_output, void* self, void* target, void* reduction, void* beta) { LANTERN_CHECK_LOADED void* ret = _lantern_smooth_l1_loss_backward_out_tensor_tensor_tensor_tensor_intt_double(grad_input, grad_output, self, target, reduction, beta); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_smooth_l1_loss_backward_tensor_tensor_tensor_intt_double)(void* grad_output, void* self, void* target, void* reduction, void* beta);
  HOST_API void* lantern_smooth_l1_loss_backward_tensor_tensor_tensor_intt_double(void* grad_output, void* self, void* target, void* reduction, void* beta) { LANTERN_CHECK_LOADED void* ret = _lantern_smooth_l1_loss_backward_tensor_tensor_tensor_intt_double(grad_output, self, target, reduction, beta); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_huber_loss_out_tensor_tensor_tensor_intt_double)(void* out, void* self, void* target, void* reduction, void* delta);
  HOST_API void* lantern_huber_loss_out_tensor_tensor_tensor_intt_double(void* out, void* self, void* target, void* reduction, void* delta) { LANTERN_CHECK_LOADED void* ret = _lantern_huber_loss_out_tensor_tensor_tensor_intt_double(out, self, target, reduction, delta); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_huber_loss_tensor_tensor_intt_double)(void* self, void* target, void* reduction, void* delta);
  HOST_API void* lantern_huber_loss_tensor_tensor_intt_double(void* self, void* target, void* reduction, void* delta) { LANTERN_CHECK_LOADED void* ret = _lantern_huber_loss_tensor_tensor_intt_double(self, target, reduction, delta); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_huber_loss_backward_out_tensor_tensor_tensor_tensor_intt_double)(void* grad_input, void* grad_output, void* self, void* target, void* reduction, void* delta);
  HOST_API void* lantern_huber_loss_backward_out_tensor_tensor_tensor_tensor_intt_double(void* grad_input, void* grad_output, void* self, void* target, void* reduction, void* delta) { LANTERN_CHECK_LOADED void* ret = _lantern_huber_loss_backward_out_tensor_tensor_tensor_tensor_intt_double(grad_input, grad_output, self, target, reduction, delta); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_huber_loss_backward_tensor_tensor_tensor_intt_double)(void* grad_output, void* self, void* target, void* reduction, void* delta);
  HOST_API void* lantern_huber_loss_backward_tensor_tensor_tensor_intt_double(void* grad_output, void* self, void* target, void* reduction, void* delta) { LANTERN_CHECK_LOADED void* ret = _lantern_huber_loss_backward_tensor_tensor_tensor_intt_double(grad_output, self, target, reduction, delta); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_soft_margin_loss_out_tensor_tensor_tensor_intt)(void* out, void* self, void* target, void* reduction);
  HOST_API void* lantern_soft_margin_loss_out_tensor_tensor_tensor_intt(void* out, void* self, void* target, void* reduction) { LANTERN_CHECK_LOADED void* ret = _lantern_soft_margin_loss_out_tensor_tensor_tensor_intt(out, self, target, reduction); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_soft_margin_loss_tensor_tensor_intt)(void* self, void* target, void* reduction);
  HOST_API void* lantern_soft_margin_loss_tensor_tensor_intt(void* self, void* target, void* reduction) { LANTERN_CHECK_LOADED void* ret = _lantern_soft_margin_loss_tensor_tensor_intt(self, target, reduction); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_soft_margin_loss_backward_out_tensor_tensor_tensor_tensor_intt)(void* grad_input, void* grad_output, void* self, void* target, void* reduction);
  HOST_API void* lantern_soft_margin_loss_backward_out_tensor_tensor_tensor_tensor_intt(void* grad_input, void* grad_output, void* self, void* target, void* reduction) { LANTERN_CHECK_LOADED void* ret = _lantern_soft_margin_loss_backward_out_tensor_tensor_tensor_tensor_intt(grad_input, grad_output, self, target, reduction); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_soft_margin_loss_backward_tensor_tensor_tensor_intt)(void* grad_output, void* self, void* target, void* reduction);
  HOST_API void* lantern_soft_margin_loss_backward_tensor_tensor_tensor_intt(void* grad_output, void* self, void* target, void* reduction) { LANTERN_CHECK_LOADED void* ret = _lantern_soft_margin_loss_backward_tensor_tensor_tensor_intt(grad_output, self, target, reduction); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_elu_out_tensor_tensor_scalar_scalar_scalar)(void* out, void* self, void* alpha, void* scale, void* input_scale);
  HOST_API void* lantern_elu_out_tensor_tensor_scalar_scalar_scalar(void* out, void* self, void* alpha, void* scale, void* input_scale) { LANTERN_CHECK_LOADED void* ret = _lantern_elu_out_tensor_tensor_scalar_scalar_scalar(out, self, alpha, scale, input_scale); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_elu_tensor_scalar_scalar_scalar)(void* self, void* alpha, void* scale, void* input_scale);
  HOST_API void* lantern_elu_tensor_scalar_scalar_scalar(void* self, void* alpha, void* scale, void* input_scale) { LANTERN_CHECK_LOADED void* ret = _lantern_elu_tensor_scalar_scalar_scalar(self, alpha, scale, input_scale); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_elu_backward_out_tensor_tensor_scalar_scalar_scalar_bool_tensor)(void* grad_input, void* grad_output, void* alpha, void* scale, void* input_scale, void* is_result, void* self_or_result);
  HOST_API void* lantern_elu_backward_out_tensor_tensor_scalar_scalar_scalar_bool_tensor(void* grad_input, void* grad_output, void* alpha, void* scale, void* input_scale, void* is_result, void* self_or_result) { LANTERN_CHECK_LOADED void* ret = _lantern_elu_backward_out_tensor_tensor_scalar_scalar_scalar_bool_tensor(grad_input, grad_output, alpha, scale, input_scale, is_result, self_or_result); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_elu_backward_tensor_scalar_scalar_scalar_bool_tensor)(void* grad_output, void* alpha, void* scale, void* input_scale, void* is_result, void* self_or_result);
  HOST_API void* lantern_elu_backward_tensor_scalar_scalar_scalar_bool_tensor(void* grad_output, void* alpha, void* scale, void* input_scale, void* is_result, void* self_or_result) { LANTERN_CHECK_LOADED void* ret = _lantern_elu_backward_tensor_scalar_scalar_scalar_bool_tensor(grad_output, alpha, scale, input_scale, is_result, self_or_result); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_elu__tensor_scalar_scalar_scalar)(void* self, void* alpha, void* scale, void* input_scale);
  HOST_API void* lantern_elu__tensor_scalar_scalar_scalar(void* self, void* alpha, void* scale, void* input_scale) { LANTERN_CHECK_LOADED void* ret = _lantern_elu__tensor_scalar_scalar_scalar(self, alpha, scale, input_scale); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_glu_out_tensor_tensor_intt)(void* out, void* self, void* dim);
  HOST_API void* lantern_glu_out_tensor_tensor_intt(void* out, void* self, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_glu_out_tensor_tensor_intt(out, self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_glu_tensor_intt)(void* self, void* dim);
  HOST_API void* lantern_glu_tensor_intt(void* self, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_glu_tensor_intt(self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_glu_backward_out_tensor_tensor_tensor_intt)(void* grad_input, void* grad_output, void* self, void* dim);
  HOST_API void* lantern_glu_backward_out_tensor_tensor_tensor_intt(void* grad_input, void* grad_output, void* self, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_glu_backward_out_tensor_tensor_tensor_intt(grad_input, grad_output, self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_glu_backward_tensor_tensor_intt)(void* grad_output, void* self, void* dim);
  HOST_API void* lantern_glu_backward_tensor_tensor_intt(void* grad_output, void* self, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_glu_backward_tensor_tensor_intt(grad_output, self, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_glu_jvp_tensor_tensor_tensor_intt)(void* glu, void* x, void* dx, void* dim);
  HOST_API void* lantern_glu_jvp_tensor_tensor_tensor_intt(void* glu, void* x, void* dx, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_glu_jvp_tensor_tensor_tensor_intt(glu, x, dx, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_glu_backward_jvp_tensor_tensor_tensor_tensor_tensor_intt)(void* grad_x, void* grad_glu, void* x, void* dgrad_glu, void* dx, void* dim);
  HOST_API void* lantern_glu_backward_jvp_tensor_tensor_tensor_tensor_tensor_intt(void* grad_x, void* grad_glu, void* x, void* dgrad_glu, void* dx, void* dim) { LANTERN_CHECK_LOADED void* ret = _lantern_glu_backward_jvp_tensor_tensor_tensor_tensor_tensor_intt(grad_x, grad_glu, x, dgrad_glu, dx, dim); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_hardsigmoid_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_hardsigmoid_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_hardsigmoid_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_hardsigmoid_tensor)(void* self);
  HOST_API void* lantern_hardsigmoid_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_hardsigmoid_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_hardsigmoid__tensor)(void* self);
  HOST_API void* lantern_hardsigmoid__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_hardsigmoid__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_hardsigmoid_backward_out_tensor_tensor_tensor)(void* grad_input, void* grad_output, void* self);
  HOST_API void* lantern_hardsigmoid_backward_out_tensor_tensor_tensor(void* grad_input, void* grad_output, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_hardsigmoid_backward_out_tensor_tensor_tensor(grad_input, grad_output, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_hardsigmoid_backward_tensor_tensor)(void* grad_output, void* self);
  HOST_API void* lantern_hardsigmoid_backward_tensor_tensor(void* grad_output, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_hardsigmoid_backward_tensor_tensor(grad_output, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_hardtanh_out_tensor_tensor_scalar_scalar)(void* out, void* self, void* min_val, void* max_val);
  HOST_API void* lantern_hardtanh_out_tensor_tensor_scalar_scalar(void* out, void* self, void* min_val, void* max_val) { LANTERN_CHECK_LOADED void* ret = _lantern_hardtanh_out_tensor_tensor_scalar_scalar(out, self, min_val, max_val); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_hardtanh_tensor_scalar_scalar)(void* self, void* min_val, void* max_val);
  HOST_API void* lantern_hardtanh_tensor_scalar_scalar(void* self, void* min_val, void* max_val) { LANTERN_CHECK_LOADED void* ret = _lantern_hardtanh_tensor_scalar_scalar(self, min_val, max_val); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_hardtanh_backward_out_tensor_tensor_tensor_scalar_scalar)(void* grad_input, void* grad_output, void* self, void* min_val, void* max_val);
  HOST_API void* lantern_hardtanh_backward_out_tensor_tensor_tensor_scalar_scalar(void* grad_input, void* grad_output, void* self, void* min_val, void* max_val) { LANTERN_CHECK_LOADED void* ret = _lantern_hardtanh_backward_out_tensor_tensor_tensor_scalar_scalar(grad_input, grad_output, self, min_val, max_val); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_hardtanh_backward_tensor_tensor_scalar_scalar)(void* grad_output, void* self, void* min_val, void* max_val);
  HOST_API void* lantern_hardtanh_backward_tensor_tensor_scalar_scalar(void* grad_output, void* self, void* min_val, void* max_val) { LANTERN_CHECK_LOADED void* ret = _lantern_hardtanh_backward_tensor_tensor_scalar_scalar(grad_output, self, min_val, max_val); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_hardtanh__tensor_scalar_scalar)(void* self, void* min_val, void* max_val);
  HOST_API void* lantern_hardtanh__tensor_scalar_scalar(void* self, void* min_val, void* max_val) { LANTERN_CHECK_LOADED void* ret = _lantern_hardtanh__tensor_scalar_scalar(self, min_val, max_val); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_hardswish_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_hardswish_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_hardswish_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_hardswish_tensor)(void* self);
  HOST_API void* lantern_hardswish_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_hardswish_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_hardswish__tensor)(void* self);
  HOST_API void* lantern_hardswish__tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_hardswish__tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_hardswish_backward_tensor_tensor)(void* grad_output, void* self);
  HOST_API void* lantern_hardswish_backward_tensor_tensor(void* grad_output, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_hardswish_backward_tensor_tensor(grad_output, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_leaky_relu_out_tensor_tensor_scalar)(void* out, void* self, void* negative_slope);
  HOST_API void* lantern_leaky_relu_out_tensor_tensor_scalar(void* out, void* self, void* negative_slope) { LANTERN_CHECK_LOADED void* ret = _lantern_leaky_relu_out_tensor_tensor_scalar(out, self, negative_slope); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_leaky_relu_tensor_scalar)(void* self, void* negative_slope);
  HOST_API void* lantern_leaky_relu_tensor_scalar(void* self, void* negative_slope) { LANTERN_CHECK_LOADED void* ret = _lantern_leaky_relu_tensor_scalar(self, negative_slope); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_leaky_relu_backward_out_tensor_tensor_tensor_scalar_bool)(void* grad_input, void* grad_output, void* self, void* negative_slope, void* self_is_result);
  HOST_API void* lantern_leaky_relu_backward_out_tensor_tensor_tensor_scalar_bool(void* grad_input, void* grad_output, void* self, void* negative_slope, void* self_is_result) { LANTERN_CHECK_LOADED void* ret = _lantern_leaky_relu_backward_out_tensor_tensor_tensor_scalar_bool(grad_input, grad_output, self, negative_slope, self_is_result); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_leaky_relu_backward_tensor_tensor_scalar_bool)(void* grad_output, void* self, void* negative_slope, void* self_is_result);
  HOST_API void* lantern_leaky_relu_backward_tensor_tensor_scalar_bool(void* grad_output, void* self, void* negative_slope, void* self_is_result) { LANTERN_CHECK_LOADED void* ret = _lantern_leaky_relu_backward_tensor_tensor_scalar_bool(grad_output, self, negative_slope, self_is_result); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_leaky_relu__tensor_scalar)(void* self, void* negative_slope);
  HOST_API void* lantern_leaky_relu__tensor_scalar(void* self, void* negative_slope) { LANTERN_CHECK_LOADED void* ret = _lantern_leaky_relu__tensor_scalar(self, negative_slope); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_log_sigmoid_out_tensor_tensor)(void* out, void* self);
  HOST_API void* lantern_log_sigmoid_out_tensor_tensor(void* out, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_log_sigmoid_out_tensor_tensor(out, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_log_sigmoid_tensor)(void* self);
  HOST_API void* lantern_log_sigmoid_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_log_sigmoid_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_log_sigmoid_forward_out_tensor_tensor_tensor)(void* output, void* buffer, void* self);
  HOST_API void* lantern_log_sigmoid_forward_out_tensor_tensor_tensor(void* output, void* buffer, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_log_sigmoid_forward_out_tensor_tensor_tensor(output, buffer, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_log_sigmoid_forward_tensor)(void* self);
  HOST_API void* lantern_log_sigmoid_forward_tensor(void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_log_sigmoid_forward_tensor(self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_log_sigmoid_backward_out_tensor_tensor_tensor_tensor)(void* grad_input, void* grad_output, void* self, void* buffer);
  HOST_API void* lantern_log_sigmoid_backward_out_tensor_tensor_tensor_tensor(void* grad_input, void* grad_output, void* self, void* buffer) { LANTERN_CHECK_LOADED void* ret = _lantern_log_sigmoid_backward_out_tensor_tensor_tensor_tensor(grad_input, grad_output, self, buffer); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_log_sigmoid_backward_tensor_tensor_tensor)(void* grad_output, void* self, void* buffer);
  HOST_API void* lantern_log_sigmoid_backward_tensor_tensor_tensor(void* grad_output, void* self, void* buffer) { LANTERN_CHECK_LOADED void* ret = _lantern_log_sigmoid_backward_tensor_tensor_tensor(grad_output, self, buffer); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_rrelu_with_noise_out_tensor_tensor_tensor_scalar_scalar_bool_generator)(void* out, void* self, void* noise, void* lower, void* upper, void* training, void* generator);
  HOST_API void* lantern_rrelu_with_noise_out_tensor_tensor_tensor_scalar_scalar_bool_generator(void* out, void* self, void* noise, void* lower, void* upper, void* training, void* generator) { LANTERN_CHECK_LOADED void* ret = _lantern_rrelu_with_noise_out_tensor_tensor_tensor_scalar_scalar_bool_generator(out, self, noise, lower, upper, training, generator); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_rrelu_with_noise_tensor_tensor_scalar_scalar_bool_generator)(void* self, void* noise, void* lower, void* upper, void* training, void* generator);
  HOST_API void* lantern_rrelu_with_noise_tensor_tensor_scalar_scalar_bool_generator(void* self, void* noise, void* lower, void* upper, void* training, void* generator) { LANTERN_CHECK_LOADED void* ret = _lantern_rrelu_with_noise_tensor_tensor_scalar_scalar_bool_generator(self, noise, lower, upper, training, generator); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_rrelu_with_noise_backward_tensor_tensor_tensor_scalar_scalar_bool_bool)(void* grad_output, void* self, void* noise, void* lower, void* upper, void* training, void* self_is_result);
  HOST_API void* lantern_rrelu_with_noise_backward_tensor_tensor_tensor_scalar_scalar_bool_bool(void* grad_output, void* self, void* noise, void* lower, void* upper, void* training, void* self_is_result) { LANTERN_CHECK_LOADED void* ret = _lantern_rrelu_with_noise_backward_tensor_tensor_tensor_scalar_scalar_bool_bool(grad_output, self, noise, lower, upper, training, self_is_result); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_rrelu_with_noise__tensor_tensor_scalar_scalar_bool_generator)(void* self, void* noise, void* lower, void* upper, void* training, void* generator);
  HOST_API void* lantern_rrelu_with_noise__tensor_tensor_scalar_scalar_bool_generator(void* self, void* noise, void* lower, void* upper, void* training, void* generator) { LANTERN_CHECK_LOADED void* ret = _lantern_rrelu_with_noise__tensor_tensor_scalar_scalar_bool_generator(self, noise, lower, upper, training, generator); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_softplus_out_tensor_tensor_scalar_scalar)(void* out, void* self, void* beta, void* threshold);
  HOST_API void* lantern_softplus_out_tensor_tensor_scalar_scalar(void* out, void* self, void* beta, void* threshold) { LANTERN_CHECK_LOADED void* ret = _lantern_softplus_out_tensor_tensor_scalar_scalar(out, self, beta, threshold); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_softplus_tensor_scalar_scalar)(void* self, void* beta, void* threshold);
  HOST_API void* lantern_softplus_tensor_scalar_scalar(void* self, void* beta, void* threshold) { LANTERN_CHECK_LOADED void* ret = _lantern_softplus_tensor_scalar_scalar(self, beta, threshold); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_softplus_backward_out_tensor_tensor_tensor_scalar_scalar)(void* grad_input, void* grad_output, void* self, void* beta, void* threshold);
  HOST_API void* lantern_softplus_backward_out_tensor_tensor_tensor_scalar_scalar(void* grad_input, void* grad_output, void* self, void* beta, void* threshold) { LANTERN_CHECK_LOADED void* ret = _lantern_softplus_backward_out_tensor_tensor_tensor_scalar_scalar(grad_input, grad_output, self, beta, threshold); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_softplus_backward_tensor_tensor_scalar_scalar)(void* grad_output, void* self, void* beta, void* threshold);
  HOST_API void* lantern_softplus_backward_tensor_tensor_scalar_scalar(void* grad_output, void* self, void* beta, void* threshold) { LANTERN_CHECK_LOADED void* ret = _lantern_softplus_backward_tensor_tensor_scalar_scalar(grad_output, self, beta, threshold); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_softshrink_out_tensor_tensor_scalar)(void* out, void* self, void* lambd);
  HOST_API void* lantern_softshrink_out_tensor_tensor_scalar(void* out, void* self, void* lambd) { LANTERN_CHECK_LOADED void* ret = _lantern_softshrink_out_tensor_tensor_scalar(out, self, lambd); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_softshrink_tensor_scalar)(void* self, void* lambd);
  HOST_API void* lantern_softshrink_tensor_scalar(void* self, void* lambd) { LANTERN_CHECK_LOADED void* ret = _lantern_softshrink_tensor_scalar(self, lambd); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_softshrink_backward_out_tensor_tensor_tensor_scalar)(void* grad_input, void* grad_output, void* self, void* lambd);
  HOST_API void* lantern_softshrink_backward_out_tensor_tensor_tensor_scalar(void* grad_input, void* grad_output, void* self, void* lambd) { LANTERN_CHECK_LOADED void* ret = _lantern_softshrink_backward_out_tensor_tensor_tensor_scalar(grad_input, grad_output, self, lambd); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_softshrink_backward_tensor_tensor_scalar)(void* grad_output, void* self, void* lambd);
  HOST_API void* lantern_softshrink_backward_tensor_tensor_scalar(void* grad_output, void* self, void* lambd) { LANTERN_CHECK_LOADED void* ret = _lantern_softshrink_backward_tensor_tensor_scalar(grad_output, self, lambd); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_adaptive_avg_pool2d_out_tensor_tensor_intarrayref)(void* out, void* self, void* output_size);
  HOST_API void* lantern_adaptive_avg_pool2d_out_tensor_tensor_intarrayref(void* out, void* self, void* output_size) { LANTERN_CHECK_LOADED void* ret = _lantern_adaptive_avg_pool2d_out_tensor_tensor_intarrayref(out, self, output_size); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_adaptive_avg_pool2d_tensor_intarrayref)(void* self, void* output_size);
  HOST_API void* lantern_adaptive_avg_pool2d_tensor_intarrayref(void* self, void* output_size) { LANTERN_CHECK_LOADED void* ret = _lantern_adaptive_avg_pool2d_tensor_intarrayref(self, output_size); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_mkldnn_adaptive_avg_pool2d_tensor_intarrayref)(void* self, void* output_size);
  HOST_API void* lantern_mkldnn_adaptive_avg_pool2d_tensor_intarrayref(void* self, void* output_size) { LANTERN_CHECK_LOADED void* ret = _lantern_mkldnn_adaptive_avg_pool2d_tensor_intarrayref(self, output_size); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_mkldnn_adaptive_avg_pool2d_out_tensor_tensor_intarrayref)(void* out, void* self, void* output_size);
  HOST_API void* lantern_mkldnn_adaptive_avg_pool2d_out_tensor_tensor_intarrayref(void* out, void* self, void* output_size) { LANTERN_CHECK_LOADED void* ret = _lantern_mkldnn_adaptive_avg_pool2d_out_tensor_tensor_intarrayref(out, self, output_size); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_mkldnn_adaptive_avg_pool2d_backward_tensor_tensor)(void* grad_output, void* self);
  HOST_API void* lantern_mkldnn_adaptive_avg_pool2d_backward_tensor_tensor(void* grad_output, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_mkldnn_adaptive_avg_pool2d_backward_tensor_tensor(grad_output, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__adaptive_avg_pool2d_tensor_intarrayref)(void* self, void* output_size);
  HOST_API void* lantern__adaptive_avg_pool2d_tensor_intarrayref(void* self, void* output_size) { LANTERN_CHECK_LOADED void* ret = _lantern__adaptive_avg_pool2d_tensor_intarrayref(self, output_size); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__adaptive_avg_pool2d_backward_tensor_tensor)(void* grad_output, void* self);
  HOST_API void* lantern__adaptive_avg_pool2d_backward_tensor_tensor(void* grad_output, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__adaptive_avg_pool2d_backward_tensor_tensor(grad_output, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_adaptive_avg_pool3d_out_tensor_tensor_intarrayref)(void* out, void* self, void* output_size);
  HOST_API void* lantern_adaptive_avg_pool3d_out_tensor_tensor_intarrayref(void* out, void* self, void* output_size) { LANTERN_CHECK_LOADED void* ret = _lantern_adaptive_avg_pool3d_out_tensor_tensor_intarrayref(out, self, output_size); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_adaptive_avg_pool3d_tensor_intarrayref)(void* self, void* output_size);
  HOST_API void* lantern_adaptive_avg_pool3d_tensor_intarrayref(void* self, void* output_size) { LANTERN_CHECK_LOADED void* ret = _lantern_adaptive_avg_pool3d_tensor_intarrayref(self, output_size); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__adaptive_avg_pool3d_tensor_intarrayref)(void* self, void* output_size);
  HOST_API void* lantern__adaptive_avg_pool3d_tensor_intarrayref(void* self, void* output_size) { LANTERN_CHECK_LOADED void* ret = _lantern__adaptive_avg_pool3d_tensor_intarrayref(self, output_size); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_adaptive_avg_pool3d_backward_out_tensor_tensor_tensor)(void* grad_input, void* grad_output, void* self);
  HOST_API void* lantern_adaptive_avg_pool3d_backward_out_tensor_tensor_tensor(void* grad_input, void* grad_output, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern_adaptive_avg_pool3d_backward_out_tensor_tensor_tensor(grad_input, grad_output, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern__adaptive_avg_pool3d_backward_tensor_tensor)(void* grad_output, void* self);
  HOST_API void* lantern__adaptive_avg_pool3d_backward_tensor_tensor(void* grad_output, void* self) { LANTERN_CHECK_LOADED void* ret = _lantern__adaptive_avg_pool3d_backward_tensor_tensor(grad_output, self); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_adaptive_max_pool2d_out_tensor_tensor_tensor_intarrayref)(void* out, void* indices, void* self, void* output_size);
  HOST_API void* lantern_adaptive_max_pool2d_out_tensor_tensor_tensor_intarrayref(void* out, void* indices, void* self, void* output_size) { LANTERN_CHECK_LOADED void* ret = _lantern_adaptive_max_pool2d_out_tensor_tensor_tensor_intarrayref(out, indices, self, output_size); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_adaptive_max_pool2d_tensor_intarrayref)(void* self, void* output_size);
  HOST_API void* lantern_adaptive_max_pool2d_tensor_intarrayref(void* self, void* output_size) { LANTERN_CHECK_LOADED void* ret = _lantern_adaptive_max_pool2d_tensor_intarrayref(self, output_size); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_adaptive_max_pool2d_backward_out_tensor_tensor_tensor_tensor)(void* grad_input, void* grad_output, void* self, void* indices);
  HOST_API void* lantern_adaptive_max_pool2d_backward_out_tensor_tensor_tensor_tensor(void* grad_input, void* grad_output, void* self, void* indices) { LANTERN_CHECK_LOADED void* ret = _lantern_adaptive_max_pool2d_backward_out_tensor_tensor_tensor_tensor(grad_input, grad_output, self, indices); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_adaptive_max_pool2d_backward_tensor_tensor_tensor)(void* grad_output, void* self, void* indices);
  HOST_API void* lantern_adaptive_max_pool2d_backward_tensor_tensor_tensor(void* grad_output, void* self, void* indices) { LANTERN_CHECK_LOADED void* ret = _lantern_adaptive_max_pool2d_backward_tensor_tensor_tensor(grad_output, self, indices); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_adaptive_max_pool3d_out_tensor_tensor_tensor_intarrayref)(void* out, void* indices, void* self, void* output_size);
  HOST_API void* lantern_adaptive_max_pool3d_out_tensor_tensor_tensor_intarrayref(void* out, void* indices, void* self, void* output_size) { LANTERN_CHECK_LOADED void* ret = _lantern_adaptive_max_pool3d_out_tensor_tensor_tensor_intarrayref(out, indices, self, output_size); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_adaptive_max_pool3d_tensor_intarrayref)(void* self, void* output_size);
  HOST_API void* lantern_adaptive_max_pool3d_tensor_intarrayref(void* self, void* output_size) { LANTERN_CHECK_LOADED void* ret = _lantern_adaptive_max_pool3d_tensor_intarrayref(self, output_size); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_adaptive_max_pool3d_backward_out_tensor_tensor_tensor_tensor)(void* grad_input, void* grad_output, void* self, void* indices);
  HOST_API void* lantern_adaptive_max_pool3d_backward_out_tensor_tensor_tensor_tensor(void* grad_input, void* grad_output, void* self, void* indices) { LANTERN_CHECK_LOADED void* ret = _lantern_adaptive_max_pool3d_backward_out_tensor_tensor_tensor_tensor(grad_input, grad_output, self, indices); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_adaptive_max_pool3d_backward_tensor_tensor_tensor)(void* grad_output, void* self, void* indices);
  HOST_API void* lantern_adaptive_max_pool3d_backward_tensor_tensor_tensor(void* grad_output, void* self, void* indices) { LANTERN_CHECK_LOADED void* ret = _lantern_adaptive_max_pool3d_backward_tensor_tensor_tensor(grad_output, self, indices); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_avg_pool2d_out_tensor_tensor_intarrayref_intarrayref_intarrayref_bool_bool_intt)(void* out, void* self, void* kernel_size, void* stride, void* padding, void* ceil_mode, void* count_include_pad, void* divisor_override);
  HOST_API void* lantern_avg_pool2d_out_tensor_tensor_intarrayref_intarrayref_intarrayref_bool_bool_intt(void* out, void* self, void* kernel_size, void* stride, void* padding, void* ceil_mode, void* count_include_pad, void* divisor_override) { LANTERN_CHECK_LOADED void* ret = _lantern_avg_pool2d_out_tensor_tensor_intarrayref_intarrayref_intarrayref_bool_bool_intt(out, self, kernel_size, stride, padding, ceil_mode, count_include_pad, divisor_override); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_avg_pool2d_tensor_intarrayref_intarrayref_intarrayref_bool_bool_intt)(void* self, void* kernel_size, void* stride, void* padding, void* ceil_mode, void* count_include_pad, void* divisor_override);
  HOST_API void* lantern_avg_pool2d_tensor_intarrayref_intarrayref_intarrayref_bool_bool_intt(void* self, void* kernel_size, void* stride, void* padding, void* ceil_mode, void* count_include_pad, void* divisor_override) { LANTERN_CHECK_LOADED void* ret = _lantern_avg_pool2d_tensor_intarrayref_intarrayref_intarrayref_bool_bool_intt(self, kernel_size, stride, padding, ceil_mode, count_include_pad, divisor_override); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_avg_pool2d_backward_out_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_bool_bool_intt)(void* grad_input, void* grad_output, void* self, void* kernel_size, void* stride, void* padding, void* ceil_mode, void* count_include_pad, void* divisor_override);
  HOST_API void* lantern_avg_pool2d_backward_out_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_bool_bool_intt(void* grad_input, void* grad_output, void* self, void* kernel_size, void* stride, void* padding, void* ceil_mode, void* count_include_pad, void* divisor_override) { LANTERN_CHECK_LOADED void* ret = _lantern_avg_pool2d_backward_out_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_bool_bool_intt(grad_input, grad_output, self, kernel_size, stride, padding, ceil_mode, count_include_pad, divisor_override); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_avg_pool2d_backward_tensor_tensor_intarrayref_intarrayref_intarrayref_bool_bool_intt)(void* grad_output, void* self, void* kernel_size, void* stride, void* padding, void* ceil_mode, void* count_include_pad, void* divisor_override);
  HOST_API void* lantern_avg_pool2d_backward_tensor_tensor_intarrayref_intarrayref_intarrayref_bool_bool_intt(void* grad_output, void* self, void* kernel_size, void* stride, void* padding, void* ceil_mode, void* count_include_pad, void* divisor_override) { LANTERN_CHECK_LOADED void* ret = _lantern_avg_pool2d_backward_tensor_tensor_intarrayref_intarrayref_intarrayref_bool_bool_intt(grad_output, self, kernel_size, stride, padding, ceil_mode, count_include_pad, divisor_override); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_avg_pool3d_out_tensor_tensor_intarrayref_intarrayref_intarrayref_bool_bool_intt)(void* out, void* self, void* kernel_size, void* stride, void* padding, void* ceil_mode, void* count_include_pad, void* divisor_override);
  HOST_API void* lantern_avg_pool3d_out_tensor_tensor_intarrayref_intarrayref_intarrayref_bool_bool_intt(void* out, void* self, void* kernel_size, void* stride, void* padding, void* ceil_mode, void* count_include_pad, void* divisor_override) { LANTERN_CHECK_LOADED void* ret = _lantern_avg_pool3d_out_tensor_tensor_intarrayref_intarrayref_intarrayref_bool_bool_intt(out, self, kernel_size, stride, padding, ceil_mode, count_include_pad, divisor_override); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_avg_pool3d_tensor_intarrayref_intarrayref_intarrayref_bool_bool_intt)(void* self, void* kernel_size, void* stride, void* padding, void* ceil_mode, void* count_include_pad, void* divisor_override);
  HOST_API void* lantern_avg_pool3d_tensor_intarrayref_intarrayref_intarrayref_bool_bool_intt(void* self, void* kernel_size, void* stride, void* padding, void* ceil_mode, void* count_include_pad, void* divisor_override) { LANTERN_CHECK_LOADED void* ret = _lantern_avg_pool3d_tensor_intarrayref_intarrayref_intarrayref_bool_bool_intt(self, kernel_size, stride, padding, ceil_mode, count_include_pad, divisor_override); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_avg_pool3d_backward_out_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_bool_bool_intt)(void* grad_input, void* grad_output, void* self, void* kernel_size, void* stride, void* padding, void* ceil_mode, void* count_include_pad, void* divisor_override);
  HOST_API void* lantern_avg_pool3d_backward_out_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_bool_bool_intt(void* grad_input, void* grad_output, void* self, void* kernel_size, void* stride, void* padding, void* ceil_mode, void* count_include_pad, void* divisor_override) { LANTERN_CHECK_LOADED void* ret = _lantern_avg_pool3d_backward_out_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_bool_bool_intt(grad_input, grad_output, self, kernel_size, stride, padding, ceil_mode, count_include_pad, divisor_override); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_avg_pool3d_backward_tensor_tensor_intarrayref_intarrayref_intarrayref_bool_bool_intt)(void* grad_output, void* self, void* kernel_size, void* stride, void* padding, void* ceil_mode, void* count_include_pad, void* divisor_override);
  HOST_API void* lantern_avg_pool3d_backward_tensor_tensor_intarrayref_intarrayref_intarrayref_bool_bool_intt(void* grad_output, void* self, void* kernel_size, void* stride, void* padding, void* ceil_mode, void* count_include_pad, void* divisor_override) { LANTERN_CHECK_LOADED void* ret = _lantern_avg_pool3d_backward_tensor_tensor_intarrayref_intarrayref_intarrayref_bool_bool_intt(grad_output, self, kernel_size, stride, padding, ceil_mode, count_include_pad, divisor_override); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_fractional_max_pool2d_out_tensor_tensor_tensor_intarrayref_intarrayref_tensor)(void* output, void* indices, void* self, void* kernel_size, void* output_size, void* random_samples);
  HOST_API void* lantern_fractional_max_pool2d_out_tensor_tensor_tensor_intarrayref_intarrayref_tensor(void* output, void* indices, void* self, void* kernel_size, void* output_size, void* random_samples) { LANTERN_CHECK_LOADED void* ret = _lantern_fractional_max_pool2d_out_tensor_tensor_tensor_intarrayref_intarrayref_tensor(output, indices, self, kernel_size, output_size, random_samples); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_fractional_max_pool2d_tensor_intarrayref_intarrayref_tensor)(void* self, void* kernel_size, void* output_size, void* random_samples);
  HOST_API void* lantern_fractional_max_pool2d_tensor_intarrayref_intarrayref_tensor(void* self, void* kernel_size, void* output_size, void* random_samples) { LANTERN_CHECK_LOADED void* ret = _lantern_fractional_max_pool2d_tensor_intarrayref_intarrayref_tensor(self, kernel_size, output_size, random_samples); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_fractional_max_pool2d_backward_out_tensor_tensor_tensor_intarrayref_intarrayref_tensor)(void* grad_input, void* grad_output, void* self, void* kernel_size, void* output_size, void* indices);
  HOST_API void* lantern_fractional_max_pool2d_backward_out_tensor_tensor_tensor_intarrayref_intarrayref_tensor(void* grad_input, void* grad_output, void* self, void* kernel_size, void* output_size, void* indices) { LANTERN_CHECK_LOADED void* ret = _lantern_fractional_max_pool2d_backward_out_tensor_tensor_tensor_intarrayref_intarrayref_tensor(grad_input, grad_output, self, kernel_size, output_size, indices); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_fractional_max_pool2d_backward_tensor_tensor_intarrayref_intarrayref_tensor)(void* grad_output, void* self, void* kernel_size, void* output_size, void* indices);
  HOST_API void* lantern_fractional_max_pool2d_backward_tensor_tensor_intarrayref_intarrayref_tensor(void* grad_output, void* self, void* kernel_size, void* output_size, void* indices) { LANTERN_CHECK_LOADED void* ret = _lantern_fractional_max_pool2d_backward_tensor_tensor_intarrayref_intarrayref_tensor(grad_output, self, kernel_size, output_size, indices); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_fractional_max_pool3d_out_tensor_tensor_tensor_intarrayref_intarrayref_tensor)(void* output, void* indices, void* self, void* kernel_size, void* output_size, void* random_samples);
  HOST_API void* lantern_fractional_max_pool3d_out_tensor_tensor_tensor_intarrayref_intarrayref_tensor(void* output, void* indices, void* self, void* kernel_size, void* output_size, void* random_samples) { LANTERN_CHECK_LOADED void* ret = _lantern_fractional_max_pool3d_out_tensor_tensor_tensor_intarrayref_intarrayref_tensor(output, indices, self, kernel_size, output_size, random_samples); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_fractional_max_pool3d_tensor_intarrayref_intarrayref_tensor)(void* self, void* kernel_size, void* output_size, void* random_samples);
  HOST_API void* lantern_fractional_max_pool3d_tensor_intarrayref_intarrayref_tensor(void* self, void* kernel_size, void* output_size, void* random_samples) { LANTERN_CHECK_LOADED void* ret = _lantern_fractional_max_pool3d_tensor_intarrayref_intarrayref_tensor(self, kernel_size, output_size, random_samples); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_fractional_max_pool3d_backward_out_tensor_tensor_tensor_intarrayref_intarrayref_tensor)(void* grad_input, void* grad_output, void* self, void* kernel_size, void* output_size, void* indices);
  HOST_API void* lantern_fractional_max_pool3d_backward_out_tensor_tensor_tensor_intarrayref_intarrayref_tensor(void* grad_input, void* grad_output, void* self, void* kernel_size, void* output_size, void* indices) { LANTERN_CHECK_LOADED void* ret = _lantern_fractional_max_pool3d_backward_out_tensor_tensor_tensor_intarrayref_intarrayref_tensor(grad_input, grad_output, self, kernel_size, output_size, indices); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_fractional_max_pool3d_backward_tensor_tensor_intarrayref_intarrayref_tensor)(void* grad_output, void* self, void* kernel_size, void* output_size, void* indices);
  HOST_API void* lantern_fractional_max_pool3d_backward_tensor_tensor_intarrayref_intarrayref_tensor(void* grad_output, void* self, void* kernel_size, void* output_size, void* indices) { LANTERN_CHECK_LOADED void* ret = _lantern_fractional_max_pool3d_backward_tensor_tensor_intarrayref_intarrayref_tensor(grad_output, self, kernel_size, output_size, indices); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_max_pool2d_with_indices_out_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool)(void* out, void* indices, void* self, void* kernel_size, void* stride, void* padding, void* dilation, void* ceil_mode);
  HOST_API void* lantern_max_pool2d_with_indices_out_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool(void* out, void* indices, void* self, void* kernel_size, void* stride, void* padding, void* dilation, void* ceil_mode) { LANTERN_CHECK_LOADED void* ret = _lantern_max_pool2d_with_indices_out_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool(out, indices, self, kernel_size, stride, padding, dilation, ceil_mode); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_max_pool2d_with_indices_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool)(void* self, void* kernel_size, void* stride, void* padding, void* dilation, void* ceil_mode);
  HOST_API void* lantern_max_pool2d_with_indices_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool(void* self, void* kernel_size, void* stride, void* padding, void* dilation, void* ceil_mode) { LANTERN_CHECK_LOADED void* ret = _lantern_max_pool2d_with_indices_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool(self, kernel_size, stride, padding, dilation, ceil_mode); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_max_pool2d_with_indices_backward_out_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool_tensor)(void* grad_input, void* grad_output, void* self, void* kernel_size, void* stride, void* padding, void* dilation, void* ceil_mode, void* indices);
  HOST_API void* lantern_max_pool2d_with_indices_backward_out_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool_tensor(void* grad_input, void* grad_output, void* self, void* kernel_size, void* stride, void* padding, void* dilation, void* ceil_mode, void* indices) { LANTERN_CHECK_LOADED void* ret = _lantern_max_pool2d_with_indices_backward_out_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool_tensor(grad_input, grad_output, self, kernel_size, stride, padding, dilation, ceil_mode, indices); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_max_pool2d_with_indices_backward_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool_tensor)(void* grad_output, void* self, void* kernel_size, void* stride, void* padding, void* dilation, void* ceil_mode, void* indices);
  HOST_API void* lantern_max_pool2d_with_indices_backward_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool_tensor(void* grad_output, void* self, void* kernel_size, void* stride, void* padding, void* dilation, void* ceil_mode, void* indices) { LANTERN_CHECK_LOADED void* ret = _lantern_max_pool2d_with_indices_backward_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool_tensor(grad_output, self, kernel_size, stride, padding, dilation, ceil_mode, indices); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_max_pool3d_with_indices_out_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool)(void* out, void* indices, void* self, void* kernel_size, void* stride, void* padding, void* dilation, void* ceil_mode);
  HOST_API void* lantern_max_pool3d_with_indices_out_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool(void* out, void* indices, void* self, void* kernel_size, void* stride, void* padding, void* dilation, void* ceil_mode) { LANTERN_CHECK_LOADED void* ret = _lantern_max_pool3d_with_indices_out_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool(out, indices, self, kernel_size, stride, padding, dilation, ceil_mode); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_max_pool3d_with_indices_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool)(void* self, void* kernel_size, void* stride, void* padding, void* dilation, void* ceil_mode);
  HOST_API void* lantern_max_pool3d_with_indices_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool(void* self, void* kernel_size, void* stride, void* padding, void* dilation, void* ceil_mode) { LANTERN_CHECK_LOADED void* ret = _lantern_max_pool3d_with_indices_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool(self, kernel_size, stride, padding, dilation, ceil_mode); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_max_pool3d_with_indices_backward_out_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool_tensor)(void* grad_input, void* grad_output, void* self, void* kernel_size, void* stride, void* padding, void* dilation, void* ceil_mode, void* indices);
  HOST_API void* lantern_max_pool3d_with_indices_backward_out_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool_tensor(void* grad_input, void* grad_output, void* self, void* kernel_size, void* stride, void* padding, void* dilation, void* ceil_mode, void* indices) { LANTERN_CHECK_LOADED void* ret = _lantern_max_pool3d_with_indices_backward_out_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool_tensor(grad_input, grad_output, self, kernel_size, stride, padding, dilation, ceil_mode, indices); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_max_pool3d_with_indices_backward_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool_tensor)(void* grad_output, void* self, void* kernel_size, void* stride, void* padding, void* dilation, void* ceil_mode, void* indices);
  HOST_API void* lantern_max_pool3d_with_indices_backward_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool_tensor(void* grad_output, void* self, void* kernel_size, void* stride, void* padding, void* dilation, void* ceil_mode, void* indices) { LANTERN_CHECK_LOADED void* ret = _lantern_max_pool3d_with_indices_backward_tensor_tensor_intarrayref_intarrayref_intarrayref_intarrayref_bool_tensor(grad_output, self, kernel_size, stride, padding, dilation, ceil_mode, indices); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_max_unpool2d_out_tensor_tensor_tensor_intarrayref)(void* out, void* self, void* indices, void* output_size);
  HOST_API void* lantern_max_unpool2d_out_tensor_tensor_tensor_intarrayref(void* out, void* self, void* indices, void* output_size) { LANTERN_CHECK_LOADED void* ret = _lantern_max_unpool2d_out_tensor_tensor_tensor_intarrayref(out, self, indices, output_size); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_max_unpool2d_tensor_tensor_intarrayref)(void* self, void* indices, void* output_size);
  HOST_API void* lantern_max_unpool2d_tensor_tensor_intarrayref(void* self, void* indices, void* output_size) { LANTERN_CHECK_LOADED void* ret = _lantern_max_unpool2d_tensor_tensor_intarrayref(self, indices, output_size); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_max_unpool3d_out_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref)(void* out, void* self, void* indices, void* output_size, void* stride, void* padding);
  HOST_API void* lantern_max_unpool3d_out_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref(void* out, void* self, void* indices, void* output_size, void* stride, void* padding) { LANTERN_CHECK_LOADED void* ret = _lantern_max_unpool3d_out_tensor_tensor_tensor_intarrayref_intarrayref_intarrayref(out, self, indices, output_size, stride, padding); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_max_unpool3d_tensor_tensor_intarrayref_intarrayref_intarrayref)(void* self, void* indices, void* output_size, void* stride, void* padding);
  HOST_API void* lantern_max_unpool3d_tensor_tensor_intarrayref_intarrayref_intarrayref(void* self, void* indices, void* output_size, void* stride, void* padding) { LANTERN_CHECK_LOADED void* ret = _lantern_max_unpool3d_tensor_tensor_intarrayref_intarrayref_intarrayref(self, indices, output_size, stride, padding); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_reflection_pad1d_out_tensor_tensor_intarrayref)(void* out, void* self, void* padding);
  HOST_API void* lantern_reflection_pad1d_out_tensor_tensor_intarrayref(void* out, void* self, void* padding) { LANTERN_CHECK_LOADED void* ret = _lantern_reflection_pad1d_out_tensor_tensor_intarrayref(out, self, padding); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_reflection_pad1d_tensor_intarrayref)(void* self, void* padding);
  HOST_API void* lantern_reflection_pad1d_tensor_intarrayref(void* self, void* padding) { LANTERN_CHECK_LOADED void* ret = _lantern_reflection_pad1d_tensor_intarrayref(self, padding); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_reflection_pad1d_backward_out_tensor_tensor_tensor_intarrayref)(void* grad_input, void* grad_output, void* self, void* padding);
  HOST_API void* lantern_reflection_pad1d_backward_out_tensor_tensor_tensor_intarrayref(void* grad_input, void* grad_output, void* self, void* padding) { LANTERN_CHECK_LOADED void* ret = _lantern_reflection_pad1d_backward_out_tensor_tensor_tensor_intarrayref(grad_input, grad_output, self, padding); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_reflection_pad1d_backward_tensor_tensor_intarrayref)(void* grad_output, void* self, void* padding);
  HOST_API void* lantern_reflection_pad1d_backward_tensor_tensor_intarrayref(void* grad_output, void* self, void* padding) { LANTERN_CHECK_LOADED void* ret = _lantern_reflection_pad1d_backward_tensor_tensor_intarrayref(grad_output, self, padding); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_reflection_pad2d_out_tensor_tensor_intarrayref)(void* out, void* self, void* padding);
  HOST_API void* lantern_reflection_pad2d_out_tensor_tensor_intarrayref(void* out, void* self, void* padding) { LANTERN_CHECK_LOADED void* ret = _lantern_reflection_pad2d_out_tensor_tensor_intarrayref(out, self, padding); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_reflection_pad2d_tensor_intarrayref)(void* self, void* padding);
  HOST_API void* lantern_reflection_pad2d_tensor_intarrayref(void* self, void* padding) { LANTERN_CHECK_LOADED void* ret = _lantern_reflection_pad2d_tensor_intarrayref(self, padding); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_reflection_pad2d_backward_out_tensor_tensor_tensor_intarrayref)(void* grad_input, void* grad_output, void* self, void* padding);
  HOST_API void* lantern_reflection_pad2d_backward_out_tensor_tensor_tensor_intarrayref(void* grad_input, void* grad_output, void* self, void* padding) { LANTERN_CHECK_LOADED void* ret = _lantern_reflection_pad2d_backward_out_tensor_tensor_tensor_intarrayref(grad_input, grad_output, self, padding); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_reflection_pad2d_backward_tensor_tensor_intarrayref)(void* grad_output, void* self, void* padding);
  HOST_API void* lantern_reflection_pad2d_backward_tensor_tensor_intarrayref(void* grad_output, void* self, void* padding) { LANTERN_CHECK_LOADED void* ret = _lantern_reflection_pad2d_backward_tensor_tensor_intarrayref(grad_output, self, padding); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_reflection_pad3d_out_tensor_tensor_intarrayref)(void* out, void* self, void* padding);
  HOST_API void* lantern_reflection_pad3d_out_tensor_tensor_intarrayref(void* out, void* self, void* padding) { LANTERN_CHECK_LOADED void* ret = _lantern_reflection_pad3d_out_tensor_tensor_intarrayref(out, self, padding); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_reflection_pad3d_tensor_intarrayref)(void* self, void* padding);
  HOST_API void* lantern_reflection_pad3d_tensor_intarrayref(void* self, void* padding) { LANTERN_CHECK_LOADED void* ret = _lantern_reflection_pad3d_tensor_intarrayref(self, padding); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_reflection_pad3d_backward_out_tensor_tensor_tensor_intarrayref)(void* grad_input, void* grad_output, void* self, void* padding);
  HOST_API void* lantern_reflection_pad3d_backward_out_tensor_tensor_tensor_intarrayref(void* grad_input, void* grad_output, void* self, void* padding) { LANTERN_CHECK_LOADED void* ret = _lantern_reflection_pad3d_backward_out_tensor_tensor_tensor_intarrayref(grad_input, grad_output, self, padding); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_reflection_pad3d_backward_tensor_tensor_intarrayref)(void* grad_output, void* self, void* padding);
  HOST_API void* lantern_reflection_pad3d_backward_tensor_tensor_intarrayref(void* grad_output, void* self, void* padding) { LANTERN_CHECK_LOADED void* ret = _lantern_reflection_pad3d_backward_tensor_tensor_intarrayref(grad_output, self, padding); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_replication_pad1d_out_tensor_tensor_intarrayref)(void* out, void* self, void* padding);
  HOST_API void* lantern_replication_pad1d_out_tensor_tensor_intarrayref(void* out, void* self, void* padding) { LANTERN_CHECK_LOADED void* ret = _lantern_replication_pad1d_out_tensor_tensor_intarrayref(out, self, padding); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_replication_pad1d_tensor_intarrayref)(void* self, void* padding);
  HOST_API void* lantern_replication_pad1d_tensor_intarrayref(void* self, void* padding) { LANTERN_CHECK_LOADED void* ret = _lantern_replication_pad1d_tensor_intarrayref(self, padding); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_replication_pad1d_backward_out_tensor_tensor_tensor_intarrayref)(void* grad_input, void* grad_output, void* self, void* padding);
  HOST_API void* lantern_replication_pad1d_backward_out_tensor_tensor_tensor_intarrayref(void* grad_input, void* grad_output, void* self, void* padding) { LANTERN_CHECK_LOADED void* ret = _lantern_replication_pad1d_backward_out_tensor_tensor_tensor_intarrayref(grad_input, grad_output, self, padding); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_replication_pad1d_backward_tensor_tensor_intarrayref)(void* grad_output, void* self, void* padding);
  HOST_API void* lantern_replication_pad1d_backward_tensor_tensor_intarrayref(void* grad_output, void* self, void* padding) { LANTERN_CHECK_LOADED void* ret = _lantern_replication_pad1d_backward_tensor_tensor_intarrayref(grad_output, self, padding); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_replication_pad2d_out_tensor_tensor_intarrayref)(void* out, void* self, void* padding);
  HOST_API void* lantern_replication_pad2d_out_tensor_tensor_intarrayref(void* out, void* self, void* padding) { LANTERN_CHECK_LOADED void* ret = _lantern_replication_pad2d_out_tensor_tensor_intarrayref(out, self, padding); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_replication_pad2d_tensor_intarrayref)(void* self, void* padding);
  HOST_API void* lantern_replication_pad2d_tensor_intarrayref(void* self, void* padding) { LANTERN_CHECK_LOADED void* ret = _lantern_replication_pad2d_tensor_intarrayref(self, padding); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_replication_pad2d_backward_out_tensor_tensor_tensor_intarrayref)(void* grad_input, void* grad_output, void* self, void* padding);
  HOST_API void* lantern_replication_pad2d_backward_out_tensor_tensor_tensor_intarrayref(void* grad_input, void* grad_output, void* self, void* padding) { LANTERN_CHECK_LOADED void* ret = _lantern_replication_pad2d_backward_out_tensor_tensor_tensor_intarrayref(grad_input, grad_output, self, padding); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_replication_pad2d_backward_tensor_tensor_intarrayref)(void* grad_output, void* self, void* padding);
  HOST_API void* lantern_replication_pad2d_backward_tensor_tensor_intarrayref(void* grad_output, void* self, void* padding) { LANTERN_CHECK_LOADED void* ret = _lantern_replication_pad2d_backward_tensor_tensor_intarrayref(grad_output, self, padding); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_replication_pad3d_out_tensor_tensor_intarrayref)(void* out, void* self, void* padding);
  HOST_API void* lantern_replication_pad3d_out_tensor_tensor_intarrayref(void* out, void* self, void* padding) { LANTERN_CHECK_LOADED void* ret = _lantern_replication_pad3d_out_tensor_tensor_intarrayref(out, self, padding); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_replication_pad3d_tensor_intarrayref)(void* self, void* padding);
  HOST_API void* lantern_replication_pad3d_tensor_intarrayref(void* self, void* padding) { LANTERN_CHECK_LOADED void* ret = _lantern_replication_pad3d_tensor_intarrayref(self, padding); LANTERN_HOST_HANDLER return ret; }
  LANTERN_API void* (LANTERN_PTR _lantern_replication_pad3d_ba