/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.client.custom;

import it.bancaditalia.oss.sdmx.api.DataFlowStructure;
import it.bancaditalia.oss.sdmx.api.Dataflow;
import it.bancaditalia.oss.sdmx.client.custom.RestSdmx20Client;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxExceptionFactory;
import it.bancaditalia.oss.sdmx.exceptions.SdmxXmlContentException;
import it.bancaditalia.oss.sdmx.parser.v20.DataStructureParser;
import it.bancaditalia.oss.sdmx.parser.v21.Sdmx21Queries;
import it.bancaditalia.oss.sdmx.util.Configuration;
import it.bancaditalia.oss.sdmx.util.RestQueryBuilder;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public abstract class DotStat
extends RestSdmx20Client {
    protected static Logger logger = Configuration.getSdmxLogger();

    public DotStat(String string, URI uRI, boolean bl, String string2) {
        super(string, uRI, bl, null, string2);
    }

    public DotStat(String string, URI uRI, boolean bl) {
        super(string, uRI, bl, null, "compact_v2");
    }

    @Override
    public Dataflow getDataflow(String string, String string2, String string3) throws SdmxException {
        URL uRL = this.buildFlowQuery(string, "all", "latest");
        List<DataFlowStructure> list = this.runQuery(new DataStructureParser(), uRL, null, null);
        if (list.size() > 0) {
            DataFlowStructure dataFlowStructure = list.get(0);
            Dataflow dataflow = new Dataflow(dataFlowStructure, dataFlowStructure.getName());
            dataflow.setDsdIdentifier(dataFlowStructure);
            return dataflow;
        }
        throw new SdmxXmlContentException("The query returned zero dataflows");
    }

    @Override
    public Map<String, Dataflow> getDataflows() throws SdmxException {
        URL uRL = this.buildFlowQuery("ALL", "all", "latest");
        List<DataFlowStructure> list = this.runQuery(new DataStructureParser(), uRL, null, null);
        if (list.size() > 0) {
            HashMap<String, Dataflow> hashMap = new HashMap<String, Dataflow>();
            for (DataFlowStructure dataFlowStructure : list) {
                Dataflow dataflow = new Dataflow(dataFlowStructure, dataFlowStructure.getName());
                dataflow.setDsdIdentifier(dataFlowStructure);
                hashMap.put(dataFlowStructure.getId(), dataflow);
            }
            return hashMap;
        }
        throw new SdmxXmlContentException("The query returned zero dataflows");
    }

    @Override
    protected URL buildFlowQuery(String string, String string2, String string3) throws SdmxException {
        return this.buildDSDQuery(string, string2, string3, false);
    }

    @Override
    protected URL buildDSDQuery(String string, String string2, String string3, boolean bl) throws SdmxException {
        if (this.endpoint != null && string != null && !string.isEmpty()) {
            try {
                return new RestQueryBuilder(this.endpoint).addPath("GetDataStructure").addPath(string).build();
            }
            catch (MalformedURLException malformedURLException) {
                throw SdmxExceptionFactory.wrap(malformedURLException);
            }
        }
        throw new RuntimeException("Invalid query parameters: dsd=" + string + " endpoint=" + this.endpoint);
    }

    @Override
    protected URL buildDataQuery(Dataflow dataflow, String string, String string2, String string3, boolean bl, String string4, boolean bl2) throws SdmxException {
        if (this.endpoint != null && dataflow != null && string != null && !string.isEmpty()) {
            Sdmx21Queries sdmx21Queries = (Sdmx21Queries)new Sdmx21Queries(this.endpoint).addPath("GetData").addPath(dataflow.getId()).addPath(string);
            return sdmx21Queries.addParams(string2, string3, bl, string4, bl2, this.format).buildSdmx21Query();
        }
        throw new RuntimeException("Invalid query parameters: dataflow=" + dataflow + " resource=" + string + " endpoint=" + this.endpoint);
    }
}

