/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.error;

import org.openfast.QName;
import org.openfast.error.ErrorCode;
import org.openfast.error.ErrorHandler;
import org.openfast.error.ErrorType;
import org.openfast.error.FastAlertSeverity;
import org.openfast.error.FastException;

public interface FastConstants {
    public static final QName ANY_TYPE = new QName("any");
    public static final FastAlertSeverity ERROR = FastAlertSeverity.ERROR;
    public static final FastAlertSeverity WARN = FastAlertSeverity.WARN;
    public static final FastAlertSeverity FATAL = FastAlertSeverity.FATAL;
    public static final ErrorType DYNAMIC = new ErrorType("Dynamic");
    public static final ErrorType STATIC = new ErrorType("Static");
    public static final ErrorType REPORTABLE = new ErrorType("Reportable");
    public static final ErrorCode S1_INVALID_XML = new ErrorCode(STATIC, 1, "ERR S1", "Invalid XML", ERROR);
    public static final ErrorCode S2_OPERATOR_TYPE_INCOMP = new ErrorCode(STATIC, 2, "ERR S2", "Incompatible operator and type", ERROR);
    public static final ErrorCode S3_INITIAL_VALUE_INCOMP = new ErrorCode(STATIC, 3, "ERR S3", "Incompatible initial value", ERROR);
    public static final ErrorCode S4_NO_INITIAL_VALUE_FOR_CONST = new ErrorCode(STATIC, 4, "ERR S4", "Fields with constant operators must have a default value defined.", ERROR);
    public static final ErrorCode S5_NO_INITVAL_MNDTRY_DFALT = new ErrorCode(STATIC, 5, "ERR S5", "No initial value for mandatory field with default operator", ERROR);
    public static final ErrorCode D1_FIELD_APP_INCOMP = new ErrorCode(DYNAMIC, 1, "ERR D1", "Field cannot be converted to type of application field", ERROR);
    public static final ErrorCode D2_INT_OUT_OF_RANGE = new ErrorCode(DYNAMIC, 2, "ERR D2", "The integer value is out of range for the specified integer type.", WARN);
    public static final ErrorCode D3_CANT_ENCODE_VALUE = new ErrorCode(DYNAMIC, 3, "ERR D3", "The value cannot be encoded for the given operator.", ERROR);
    public static final ErrorCode D4_INVALID_TYPE = new ErrorCode(DYNAMIC, 4, "ERR D4", "The previous value is not the same type as the type of the current field.", ERROR);
    public static final ErrorCode D5_NO_DEFAULT_VALUE = new ErrorCode(DYNAMIC, 5, "ERR D5", "If no prior value is set and the field is not present, there must be a default value or the optional flag must be set.", ERROR);
    public static final ErrorCode D6_MNDTRY_FIELD_NOT_PRESENT = new ErrorCode(DYNAMIC, 6, "ERR D6", "A mandatory field must have a value", ERROR);
    public static final ErrorCode D7_SUBTRCTN_LEN_LONG = new ErrorCode(DYNAMIC, 7, "ERR D7", "The subtraction length is longer than the base value.", ERROR);
    public static final ErrorCode D8_TEMPLATE_NOT_EXIST = new ErrorCode(DYNAMIC, 8, "ERR D8", "The referenced template does not exist.", ERROR);
    public static final ErrorCode D9_TEMPLATE_NOT_REGISTERED = new ErrorCode(DYNAMIC, 9, "ERR D9", "The template has not been registered.", ERROR);
    public static final ErrorCode R1_LARGE_DECIMAL = new ErrorCode(REPORTABLE, 1, "ERR R1", "Decimal exponent does not fit into range -63...63", WARN);
    public static final ErrorCode R4_NUMERIC_VALUE_TOO_LARGE = new ErrorCode(REPORTABLE, 4, "ERR R4", "The value is too large.", WARN);
    public static final ErrorCode R5_DECIMAL_CANT_CONVERT_TO_INT = new ErrorCode(REPORTABLE, 5, "ERR R5", "The decimal value cannot convert to an integer because of trailing decimal part.", WARN);
    public static final ErrorCode R7_PMAP_OVERLONG = new ErrorCode(REPORTABLE, 7, "ERR R7", "The presence map is overlong.", WARN);
    public static final ErrorCode R8_PMAP_TOO_MANY_BITS = new ErrorCode(REPORTABLE, 8, "ERR R8", "The presence map has too many bits.", WARN);
    public static final ErrorCode R9_STRING_OVERLONG = new ErrorCode(REPORTABLE, 9, "ERR R9", "The string is overlong.", ERROR);
    public static final ErrorCode GENERAL_ERROR = new ErrorCode(DYNAMIC, 100, "GENERAL", "An error has occurred.", ERROR);
    public static final ErrorCode IMPOSSIBLE_EXCEPTION = new ErrorCode(DYNAMIC, 101, "IMPOSSIBLE", "This should never happen.", ERROR);
    public static final ErrorCode IO_ERROR = new ErrorCode(DYNAMIC, 102, "IOERROR", "An IO error occurred.", FATAL);
    public static final ErrorCode PARSE_ERROR = new ErrorCode(DYNAMIC, 103, "PARSEERR", "An exception occurred while parsing.", ERROR);
    public static final ErrorCode END_OF_STREAM = new ErrorCode(DYNAMIC, 104, "ENDSTREAM", "There is not more data in the stream.", ERROR);
    public static final String TEMPLATE_DEFINITION_1_1 = "http://www.fixprotocol.org/ns/fast/td/1.1";
    public static final QName LENGTH_FIELD = new QName("length", "http://www.fixprotocol.org/ns/fast/td/1.1");
    public static final QName LENGTH_NAME_ATTR = new QName("name", "http://www.fixprotocol.org/ns/fast/td/1.1");
    public static final QName LENGTH_NS_ATTR = new QName("namespace", "http://www.fixprotocol.org/ns/fast/td/1.1");
    public static final QName LENGTH_ID_ATTR = new QName("id", "http://www.fixprotocol.org/ns/fast/td/1.1");
    public static final ErrorHandler BASIC_ERROR_HANDLER = new ErrorHandler(){

        public void error(ErrorCode code, String message) {
            if (REPORTABLE.equals(code.getType())) {
                System.out.println("WARNING: " + message);
            } else {
                code.throwException(message);
            }
        }

        public void error(ErrorCode code, String message, Throwable t) {
            if (!REPORTABLE.equals(code.getType())) {
                throw new FastException(message, code, t);
            }
            System.out.println(message);
        }
    };
}

