/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.REngine;

import org.rosuda.REngine.REXPDouble;
import org.rosuda.REngine.REXPList;
import org.rosuda.REngine.REXPVector;

public class REXPLogical
extends REXPVector {
    protected byte[] payload;
    static final int NA_internal = Integer.MIN_VALUE;
    public static final byte NA = -128;
    public static final byte TRUE = 1;
    public static final byte FALSE = 0;

    public static boolean isNA(byte value) {
        return value == -128;
    }

    public REXPLogical(boolean load) {
        this.payload = new byte[]{load ? (byte)1 : 0};
    }

    public REXPLogical(byte load) {
        this.payload = new byte[]{load};
    }

    public REXPLogical(byte[] load) {
        this.payload = load == null ? new byte[]{} : load;
    }

    public REXPLogical(boolean[] load) {
        this.payload = new byte[load == null ? 0 : load.length];
        if (load != null) {
            for (int i = 0; i < load.length; ++i) {
                this.payload[i] = load[i] ? (byte)1 : 0;
            }
        }
    }

    public REXPLogical(byte[] load, REXPList attr) {
        super(attr);
        this.payload = load == null ? new byte[]{} : load;
    }

    public REXPLogical(boolean[] load, REXPList attr) {
        super(attr);
        this.payload = new byte[load == null ? 0 : load.length];
        if (load != null) {
            for (int i = 0; i < load.length; ++i) {
                this.payload[i] = load[i] ? (byte)1 : 0;
            }
        }
    }

    @Override
    public int length() {
        return this.payload.length;
    }

    @Override
    public boolean isLogical() {
        return true;
    }

    @Override
    public Object asNativeJavaObject() {
        return this.payload;
    }

    @Override
    public int[] asIntegers() {
        int[] p = new int[this.payload.length];
        for (int i = 0; i < this.payload.length; ++i) {
            p[i] = this.payload[i] == -128 ? Integer.MIN_VALUE : (this.payload[i] == 0 ? 0 : 1);
        }
        return p;
    }

    @Override
    public byte[] asBytes() {
        return this.payload;
    }

    @Override
    public double[] asDoubles() {
        double[] d = new double[this.payload.length];
        for (int i = 0; i < this.payload.length; ++i) {
            d[i] = this.payload[i] == -128 ? REXPDouble.NA : (this.payload[i] == 0 ? 0.0 : 1.0);
        }
        return d;
    }

    @Override
    public String[] asStrings() {
        String[] s = new String[this.payload.length];
        for (int i = 0; i < this.payload.length; ++i) {
            s[i] = this.payload[i] == -128 ? "NA" : (this.payload[i] == 0 ? "FALSE" : "TRUE");
        }
        return s;
    }

    @Override
    public boolean[] isNA() {
        boolean[] a = new boolean[this.payload.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = this.payload[i] == -128;
        }
        return a;
    }

    public boolean[] isTRUE() {
        boolean[] a = new boolean[this.payload.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = this.payload[i] != -128 && this.payload[i] != 0;
        }
        return a;
    }

    public boolean[] isFALSE() {
        boolean[] a = new boolean[this.payload.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = this.payload[i] == 0;
        }
        return a;
    }

    public boolean[] isTrue() {
        return this.isTRUE();
    }

    public boolean[] isFalse() {
        return this.isFALSE();
    }

    @Override
    public String toDebugString() {
        int i;
        StringBuffer sb = new StringBuffer(super.toDebugString() + "{");
        for (i = 0; i < this.payload.length && i < maxDebugItems; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.payload[i] == -128 ? "NA" : (this.payload[i] == 0 ? "FALSE" : "TRUE"));
        }
        if (i < this.payload.length) {
            sb.append(",..");
        }
        return sb.toString() + "}";
    }
}

