/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat;

import cern.colt.function.tfloat.FloatFloatFunction;
import cern.colt.function.tfloat.FloatFunction;
import cern.colt.function.tfloat.FloatProcedure;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.algo.FloatFormatter;
import cern.colt.matrix.tfloat.algo.FloatProperty;
import cern.colt.matrix.tfloat.algo.FloatSorting;
import cern.jet.math.tfloat.FloatFunctions;
import cern.jet.math.tfloat.FloatPlusMultSecond;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class FloatMatrix1D
extends AbstractMatrix1D {
    private static final long serialVersionUID = 1L;

    protected FloatMatrix1D() {
    }

    public float aggregate(final FloatFloatFunction floatFloatFunction, final FloatFunction floatFunction) {
        if (this.size == 0) {
            return Float.NaN;
        }
        float f = floatFunction.apply(this.getQuick(0));
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float f = floatFunction.apply(FloatMatrix1D.this.getQuick(n3));
                        for (int i = n3 + 1; i < n4; ++i) {
                            f = floatFloatFunction.apply(f, floatFunction.apply(FloatMatrix1D.this.getQuick(i)));
                        }
                        return Float.valueOf(f);
                    }
                });
            }
            f = ConcurrencyUtils.waitForCompletion(futureArray, floatFloatFunction);
        } else {
            for (int i = 1; i < this.size; ++i) {
                f = floatFloatFunction.apply(f, floatFunction.apply(this.getQuick(i)));
            }
        }
        return f;
    }

    public float aggregate(final FloatFloatFunction floatFloatFunction, final FloatFunction floatFunction, IntArrayList intArrayList) {
        if (this.size() == 0L) {
            return Float.NaN;
        }
        int n = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        float f = 0.0f;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n2 = Math.min(n2, n);
            Future[] futureArray = new Future[n2];
            int n3 = n / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float f = floatFunction.apply(FloatMatrix1D.this.getQuick(nArray[n4]));
                        for (int i = n4 + 1; i < n5; ++i) {
                            float f2 = FloatMatrix1D.this.getQuick(nArray[i]);
                            f = floatFloatFunction.apply(f, floatFunction.apply(f2));
                        }
                        return Float.valueOf(f);
                    }
                });
            }
            f = ConcurrencyUtils.waitForCompletion(futureArray, floatFloatFunction);
        } else {
            f = floatFunction.apply(this.getQuick(nArray[0]));
            for (int i = 1; i < n; ++i) {
                float f2 = this.getQuick(nArray[i]);
                f = floatFloatFunction.apply(f, floatFunction.apply(f2));
            }
        }
        return f;
    }

    public float aggregate(final FloatMatrix1D floatMatrix1D, final FloatFloatFunction floatFloatFunction, final FloatFloatFunction floatFloatFunction2) {
        this.checkSize(floatMatrix1D);
        if (this.size == 0) {
            return Float.NaN;
        }
        float f = floatFloatFunction2.apply(this.getQuick(0), floatMatrix1D.getQuick(0));
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float f = floatFloatFunction2.apply(FloatMatrix1D.this.getQuick(n3), floatMatrix1D.getQuick(n3));
                        for (int i = n3 + 1; i < n4; ++i) {
                            f = floatFloatFunction.apply(f, floatFloatFunction2.apply(FloatMatrix1D.this.getQuick(i), floatMatrix1D.getQuick(i)));
                        }
                        return Float.valueOf(f);
                    }
                });
            }
            f = ConcurrencyUtils.waitForCompletion(futureArray, floatFloatFunction);
        } else {
            for (int i = 1; i < this.size; ++i) {
                f = floatFloatFunction.apply(f, floatFloatFunction2.apply(this.getQuick(i), floatMatrix1D.getQuick(i)));
            }
        }
        return f;
    }

    public FloatMatrix1D assign(final FloatFunction floatFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            FloatMatrix1D.this.setQuick(i, floatFunction.apply(FloatMatrix1D.this.getQuick(i)));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, floatFunction.apply(this.getQuick(i)));
            }
        }
        return this;
    }

    public FloatMatrix1D assign(final FloatProcedure floatProcedure, final FloatFunction floatFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            float f = FloatMatrix1D.this.getQuick(i);
                            if (!floatProcedure.apply(f)) continue;
                            FloatMatrix1D.this.setQuick(i, floatFunction.apply(f));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                float f = this.getQuick(i);
                if (!floatProcedure.apply(f)) continue;
                this.setQuick(i, floatFunction.apply(f));
            }
        }
        return this;
    }

    public FloatMatrix1D assign(final FloatProcedure floatProcedure, final float f) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            float f2 = FloatMatrix1D.this.getQuick(i);
                            if (!floatProcedure.apply(f2)) continue;
                            FloatMatrix1D.this.setQuick(i, f);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                float f2 = this.getQuick(i);
                if (!floatProcedure.apply(f2)) continue;
                this.setQuick(i, f);
            }
        }
        return this;
    }

    public FloatMatrix1D assign(final float f) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            FloatMatrix1D.this.setQuick(i, f);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, f);
            }
        }
        return this;
    }

    public FloatMatrix1D assign(final float[] fArray) {
        if (fArray.length != this.size) {
            throw new IllegalArgumentException("Must have same number of cells: length=" + fArray.length + "size()=" + this.size());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            FloatMatrix1D.this.setQuick(i, fArray[i]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, fArray[i]);
            }
        }
        return this;
    }

    public FloatMatrix1D assign(FloatMatrix1D floatMatrix1D) {
        if (floatMatrix1D == this) {
            return this;
        }
        this.checkSize(floatMatrix1D);
        final FloatMatrix1D floatMatrix1D2 = this.haveSharedCells(floatMatrix1D) ? floatMatrix1D.copy() : floatMatrix1D;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            FloatMatrix1D.this.setQuick(i, floatMatrix1D2.getQuick(i));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, floatMatrix1D2.getQuick(i));
            }
        }
        return this;
    }

    public FloatMatrix1D assign(final FloatMatrix1D floatMatrix1D, final FloatFloatFunction floatFloatFunction) {
        this.checkSize(floatMatrix1D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            FloatMatrix1D.this.setQuick(i, floatFloatFunction.apply(FloatMatrix1D.this.getQuick(i), floatMatrix1D.getQuick(i)));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, floatFloatFunction.apply(this.getQuick(i), floatMatrix1D.getQuick(i)));
            }
        }
        return this;
    }

    public FloatMatrix1D assign(FloatMatrix1D floatMatrix1D, FloatFloatFunction floatFloatFunction, IntArrayList intArrayList) {
        this.checkSize(floatMatrix1D);
        int[] nArray = intArrayList.elements();
        if (floatFloatFunction == FloatFunctions.mult) {
            int n = 0;
            int n2 = intArrayList.size();
            while (--n2 >= 0) {
                int n3 = nArray[n2];
                while (n < n3) {
                    this.setQuick(n, 0.0f);
                    ++n;
                }
                this.setQuick(n3, this.getQuick(n3) * floatMatrix1D.getQuick(n3));
                ++n;
            }
        } else if (floatFloatFunction instanceof FloatPlusMultSecond) {
            float f = ((FloatPlusMultSecond)floatFloatFunction).multiplicator;
            if (f == 0.0f) {
                return this;
            }
            if (f == 1.0f) {
                int n = intArrayList.size();
                while (--n >= 0) {
                    int n4 = nArray[n];
                    this.setQuick(n4, this.getQuick(n4) + floatMatrix1D.getQuick(n4));
                }
            } else if (f == -1.0f) {
                int n = intArrayList.size();
                while (--n >= 0) {
                    int n5 = nArray[n];
                    this.setQuick(n5, this.getQuick(n5) - floatMatrix1D.getQuick(n5));
                }
            } else {
                int n = intArrayList.size();
                while (--n >= 0) {
                    int n6 = nArray[n];
                    this.setQuick(n6, this.getQuick(n6) + f * floatMatrix1D.getQuick(n6));
                }
            }
        } else {
            return this.assign(floatMatrix1D, floatFloatFunction);
        }
        return this;
    }

    public int cardinality() {
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n3;
            n2 = Math.min(n2, this.size);
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n4 = this.size / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.size : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        for (int i = n5; i < n6; ++i) {
                            if (FloatMatrix1D.this.getQuick(i) == 0.0f) continue;
                            ++n;
                        }
                        return n;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    integerArray[n3] = (Integer)futureArray[n3].get();
                }
                n = integerArray[0];
                for (n3 = 1; n3 < n2; ++n3) {
                    n += integerArray[n3].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (this.getQuick(i) == 0.0f) continue;
                ++n;
            }
        }
        return n;
    }

    public FloatMatrix1D copy() {
        FloatMatrix1D floatMatrix1D = this.like();
        floatMatrix1D.assign(this);
        return floatMatrix1D;
    }

    public abstract Object elements();

    public boolean equals(float f) {
        return FloatProperty.DEFAULT.equals(this, f);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof FloatMatrix1D)) {
            return false;
        }
        return FloatProperty.DEFAULT.equals(this, (FloatMatrix1D)object);
    }

    public float get(int n) {
        if (n < 0 || n >= this.size) {
            this.checkIndex(n);
        }
        return this.getQuick(n);
    }

    public float[] getMaxLocation() {
        int n = 0;
        float f = 0.0f;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n3;
            n2 = Math.min(n2, this.size);
            Future[] futureArray = new Future[n2];
            float[][] fArray = new float[n2][2];
            int n4 = this.size / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.size : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        int n = n5;
                        float f = FloatMatrix1D.this.getQuick(n);
                        for (int i = n5 + 1; i < n6; ++i) {
                            float f2 = FloatMatrix1D.this.getQuick(i);
                            if (!(f < f2)) continue;
                            f = f2;
                            n = i;
                        }
                        return new float[]{f, n};
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    fArray[n3] = (float[])futureArray[n3].get();
                }
                f = fArray[0][0];
                n = (int)fArray[0][1];
                for (n3 = 1; n3 < n2; ++n3) {
                    if (!(f < fArray[n3][0])) continue;
                    f = fArray[n3][0];
                    n = (int)fArray[n3][1];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            f = this.getQuick(n);
            int n7 = 1;
            while ((long)n7 < this.size()) {
                float f2 = this.getQuick(n7);
                if (f < f2) {
                    f = f2;
                    n = n7;
                }
                ++n7;
            }
        }
        return new float[]{f, n};
    }

    public float[] getMinLocation() {
        int n = 0;
        float f = 0.0f;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n3;
            n2 = Math.min(n2, this.size);
            Future[] futureArray = new Future[n2];
            float[][] fArray = new float[n2][2];
            int n4 = this.size / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.size : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        int n = n5;
                        float f = FloatMatrix1D.this.getQuick(n);
                        for (int i = n5 + 1; i < n6; ++i) {
                            float f2 = FloatMatrix1D.this.getQuick(i);
                            if (!(f > f2)) continue;
                            f = f2;
                            n = i;
                        }
                        return new float[]{f, n};
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    fArray[n3] = (float[])futureArray[n3].get();
                }
                f = fArray[0][0];
                n = (int)fArray[0][1];
                for (n3 = 1; n3 < n2; ++n3) {
                    if (!(f > fArray[n3][0])) continue;
                    f = fArray[n3][0];
                    n = (int)fArray[n3][1];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            f = this.getQuick(n);
            int n7 = 1;
            while ((long)n7 < this.size()) {
                float f2 = this.getQuick(n7);
                if (f > f2) {
                    f = f2;
                    n = n7;
                }
                ++n7;
            }
        }
        return new float[]{f, n};
    }

    public void getNegativeValues(IntArrayList intArrayList, FloatArrayList floatArrayList) {
        float f;
        int n;
        boolean bl;
        boolean bl2 = intArrayList != null;
        boolean bl3 = bl = floatArrayList != null;
        if (bl2) {
            intArrayList.clear();
        }
        if (bl) {
            floatArrayList.clear();
        }
        if ((n = this.size % 2) == 1 && (f = this.getQuick(0)) < 0.0f) {
            if (bl2) {
                intArrayList.add(0);
            }
            if (bl) {
                floatArrayList.add(f);
            }
        }
        for (int i = n; i < this.size; i += 2) {
            float f2 = this.getQuick(i);
            if (f2 < 0.0f) {
                if (bl2) {
                    intArrayList.add(i);
                }
                if (bl) {
                    floatArrayList.add(f2);
                }
            }
            if (!((f2 = this.getQuick(i + 1)) < 0.0f)) continue;
            if (bl2) {
                intArrayList.add(i + 1);
            }
            if (!bl) continue;
            floatArrayList.add(f2);
        }
    }

    public void getNonZeros(IntArrayList intArrayList, FloatArrayList floatArrayList) {
        float f;
        int n;
        boolean bl;
        boolean bl2 = intArrayList != null;
        boolean bl3 = bl = floatArrayList != null;
        if (bl2) {
            intArrayList.clear();
        }
        if (bl) {
            floatArrayList.clear();
        }
        if ((n = this.size % 2) == 1 && (f = this.getQuick(0)) != 0.0f) {
            if (bl2) {
                intArrayList.add(0);
            }
            if (bl) {
                floatArrayList.add(f);
            }
        }
        for (int i = n; i < this.size; i += 2) {
            float f2 = this.getQuick(i);
            if (f2 != 0.0f) {
                if (bl2) {
                    intArrayList.add(i);
                }
                if (bl) {
                    floatArrayList.add(f2);
                }
            }
            if ((f2 = this.getQuick(i + 1)) == 0.0f) continue;
            if (bl2) {
                intArrayList.add(i + 1);
            }
            if (!bl) continue;
            floatArrayList.add(f2);
        }
    }

    public void getNonZeros(IntArrayList intArrayList, FloatArrayList floatArrayList, int n) {
        boolean bl;
        boolean bl2 = intArrayList != null;
        boolean bl3 = bl = floatArrayList != null;
        if (bl2) {
            intArrayList.clear();
        }
        if (bl) {
            floatArrayList.clear();
        }
        int n2 = this.size;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            float f = this.getQuick(i);
            if (f != 0.0f) {
                if (bl2) {
                    intArrayList.add(i);
                }
                if (bl) {
                    floatArrayList.add(f);
                }
                ++n3;
            }
            if (n3 >= n) break;
        }
    }

    public void getPositiveValues(IntArrayList intArrayList, FloatArrayList floatArrayList) {
        float f;
        int n;
        boolean bl;
        boolean bl2 = intArrayList != null;
        boolean bl3 = bl = floatArrayList != null;
        if (bl2) {
            intArrayList.clear();
        }
        if (bl) {
            floatArrayList.clear();
        }
        if ((n = this.size % 2) == 1 && (f = this.getQuick(0)) > 0.0f) {
            if (bl2) {
                intArrayList.add(0);
            }
            if (bl) {
                floatArrayList.add(f);
            }
        }
        for (int i = n; i < this.size; i += 2) {
            float f2 = this.getQuick(i);
            if (f2 > 0.0f) {
                if (bl2) {
                    intArrayList.add(i);
                }
                if (bl) {
                    floatArrayList.add(f2);
                }
            }
            if (!((f2 = this.getQuick(i + 1)) > 0.0f)) continue;
            if (bl2) {
                intArrayList.add(i + 1);
            }
            if (!bl) continue;
            floatArrayList.add(f2);
        }
    }

    public abstract float getQuick(int var1);

    public FloatMatrix1D like() {
        return this.like(this.size);
    }

    public abstract FloatMatrix1D like(int var1);

    public abstract FloatMatrix2D like2D(int var1, int var2);

    public void normalize() {
        float f = this.getMinLocation()[0];
        if (f < 0.0f) {
            this.assign(FloatFunctions.minus(f));
        }
        if (this.getMaxLocation()[0] == 0.0f) {
            this.assign(1.0f / (float)this.size());
        } else {
            float f2 = this.zSum();
            f2 = 1.0f / f2;
            this.assign(FloatFunctions.mult(f2));
        }
    }

    public abstract FloatMatrix2D reshape(int var1, int var2);

    public abstract FloatMatrix3D reshape(int var1, int var2, int var3);

    public void set(int n, float f) {
        if (n < 0 || n >= this.size) {
            this.checkIndex(n);
        }
        this.setQuick(n, f);
    }

    public abstract void setQuick(int var1, float var2);

    public void swap(final FloatMatrix1D floatMatrix1D) {
        this.checkSize(floatMatrix1D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            float f = FloatMatrix1D.this.getQuick(i);
                            FloatMatrix1D.this.setQuick(i, floatMatrix1D.getQuick(i));
                            floatMatrix1D.setQuick(i, f);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                float f = this.getQuick(i);
                this.setQuick(i, floatMatrix1D.getQuick(i));
                floatMatrix1D.setQuick(i, f);
            }
        }
    }

    public float[] toArray() {
        float[] fArray = new float[this.size];
        this.toArray(fArray);
        return fArray;
    }

    public void toArray(final float[] fArray) {
        if (fArray.length < this.size) {
            throw new IllegalArgumentException("values too small");
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            fArray[i] = FloatMatrix1D.this.getQuick(i);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                fArray[i] = this.getQuick(i);
            }
        }
    }

    public String toString() {
        return new FloatFormatter().toString(this);
    }

    public FloatMatrix1D viewFlip() {
        return (FloatMatrix1D)this.view().vFlip();
    }

    public FloatMatrix1D viewPart(int n, int n2) {
        return (FloatMatrix1D)this.view().vPart(n, n2);
    }

    public FloatMatrix1D viewSelection(FloatProcedure floatProcedure) {
        IntArrayList intArrayList = new IntArrayList();
        for (int i = 0; i < this.size; ++i) {
            if (!floatProcedure.apply(this.getQuick(i))) continue;
            intArrayList.add(i);
        }
        intArrayList.trimToSize();
        return this.viewSelection(intArrayList.elements());
    }

    public FloatMatrix1D viewSelection(int[] nArray) {
        if (nArray == null) {
            nArray = new int[this.size];
            for (int i = 0; i < this.size; ++i) {
                nArray[i] = i;
            }
        }
        this.checkIndexes(nArray);
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = (int)this.index(nArray[i]);
        }
        return this.viewSelectionLike(nArray2);
    }

    public FloatMatrix1D viewSorted() {
        return FloatSorting.mergeSort.sort(this);
    }

    public FloatMatrix1D viewStrides(int n) {
        return (FloatMatrix1D)this.view().vStrides(n);
    }

    public float zDotProduct(FloatMatrix1D floatMatrix1D) {
        return this.zDotProduct(floatMatrix1D, 0, this.size);
    }

    public float zDotProduct(final FloatMatrix1D floatMatrix1D, final int n, int n2) {
        if (n < 0 || n2 <= 0) {
            return 0.0f;
        }
        int n3 = n + n2;
        if (this.size < n3) {
            n3 = this.size;
        }
        if (floatMatrix1D.size < n3) {
            n3 = floatMatrix1D.size;
        }
        n2 = n3 - n;
        float f = 0.0f;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n5;
            n4 = Math.min(n4, n2);
            Future[] futureArray = new Future[n4];
            Float[] floatArray = new Float[n4];
            int n6 = n2 / n4;
            for (n5 = 0; n5 < n4; ++n5) {
                final int n7 = n5 * n6;
                final int n8 = n5 == n4 - 1 ? n2 : n7 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float f = 0.0f;
                        for (int i = n7; i < n8; ++i) {
                            int n2 = i + n;
                            f += FloatMatrix1D.this.getQuick(n2) * floatMatrix1D.getQuick(n2);
                        }
                        return Float.valueOf(f);
                    }
                });
            }
            try {
                for (n5 = 0; n5 < n4; ++n5) {
                    floatArray[n5] = (Float)futureArray[n5].get();
                }
                f = floatArray[0].floatValue();
                for (n5 = 1; n5 < n4; ++n5) {
                    f += floatArray[n5].floatValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            int n9 = n3 - 1;
            int n10 = n2;
            while (--n10 >= 0) {
                f += this.getQuick(n9) * floatMatrix1D.getQuick(n9);
                --n9;
            }
        }
        return f;
    }

    public float zDotProduct(FloatMatrix1D floatMatrix1D, int n, int n2, IntArrayList intArrayList) {
        int n3;
        int n4;
        if (n < 0 || n2 <= 0) {
            return 0.0f;
        }
        int n5 = n + n2;
        if (this.size < n5) {
            n5 = this.size;
        }
        if (floatMatrix1D.size < n5) {
            n5 = floatMatrix1D.size;
        }
        if ((n2 = n5 - n) <= 0) {
            return 0.0f;
        }
        IntArrayList intArrayList2 = intArrayList.copy();
        intArrayList2.trimToSize();
        intArrayList2.quickSort();
        int[] nArray = intArrayList2.elements();
        int n6 = intArrayList2.size();
        for (n4 = 0; n4 < n6 && nArray[n4] < n; ++n4) {
        }
        float f = 0.0f;
        while (--n2 >= 0 && n4 < n6 && (n3 = nArray[n4]) < n5) {
            f += this.getQuick(n3) * floatMatrix1D.getQuick(n3);
            ++n4;
        }
        return f;
    }

    public float zSum() {
        if (this.size() == 0L) {
            return 0.0f;
        }
        return this.aggregate(FloatFunctions.plus, FloatFunctions.identity);
    }

    protected int cardinality(int n) {
        int n2 = 0;
        int n3 = this.size;
        while (--n3 >= 0 && n2 < n) {
            if (this.getQuick(n3) == 0.0f) continue;
            ++n2;
        }
        return n2;
    }

    protected FloatMatrix1D getContent() {
        return this;
    }

    protected boolean haveSharedCells(FloatMatrix1D floatMatrix1D) {
        if (floatMatrix1D == null) {
            return false;
        }
        if (this == floatMatrix1D) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(floatMatrix1D.getContent());
    }

    protected boolean haveSharedCellsRaw(FloatMatrix1D floatMatrix1D) {
        return false;
    }

    protected FloatMatrix1D view() {
        return (FloatMatrix1D)this.clone();
    }

    protected abstract FloatMatrix1D viewSelectionLike(int[] var1);

    protected float zDotProduct(FloatMatrix1D floatMatrix1D, IntArrayList intArrayList) {
        return this.zDotProduct(floatMatrix1D, 0, this.size, intArrayList);
    }
}

