/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent.operators;

import dr.evomodel.coalescent.GaussianProcessSkytrackLikelihood;
import dr.inference.model.Parameter;
import dr.inference.operators.AdaptationMode;
import dr.inference.operators.GibbsOperator;
import dr.inference.operators.OperatorUtils;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import dr.util.NumberFormatter;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import no.uib.cipr.matrix.BandCholesky;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.SymmTridiagMatrix;
import no.uib.cipr.matrix.UpperSPDBandMatrix;
import no.uib.cipr.matrix.UpperTriangBandMatrix;

public class GaussianProcessSkytrackBlockUpdateOperator
extends SimpleMCMCOperator
implements GibbsOperator {
    private double scaleFactor;
    public static final double TWO_TIMES_PI = 6.283185;
    private Parameter popSizeParameter;
    private Parameter precisionParameter;
    private Parameter lambdaParameter;
    private Parameter lambdaBoundParameter;
    private Parameter changePoints;
    private Parameter GPcounts;
    private Parameter GPtype;
    private Parameter CoalCounts;
    private Parameter numPoints;
    private double[] GPcoalfactor;
    private Parameter coalfactor;
    private double alphaprior;
    private double betaprior;
    private SymmTridiagMatrix currentQ;
    private int numberPoints;
    private int[] CoalPosIndicator;
    private double[] CoalTime;
    GaussianProcessSkytrackLikelihood GPvalue;

    public GaussianProcessSkytrackBlockUpdateOperator(GaussianProcessSkytrackLikelihood gaussianProcessSkytrackLikelihood, double d, AdaptationMode adaptationMode, double d2, int n, double d3) {
        this.GPvalue = gaussianProcessSkytrackLikelihood;
        this.popSizeParameter = gaussianProcessSkytrackLikelihood.getPopSizeParameter();
        this.changePoints = gaussianProcessSkytrackLikelihood.getChangePoints();
        this.GPcoalfactor = gaussianProcessSkytrackLikelihood.getGPcoalfactor();
        this.coalfactor = gaussianProcessSkytrackLikelihood.getcoalfactor();
        this.GPtype = gaussianProcessSkytrackLikelihood.getGPtype();
        this.GPcounts = gaussianProcessSkytrackLikelihood.getGPcounts();
        this.precisionParameter = gaussianProcessSkytrackLikelihood.getPrecisionParameter();
        this.lambdaParameter = gaussianProcessSkytrackLikelihood.getLambdaParameter();
        this.alphaprior = gaussianProcessSkytrackLikelihood.getAlphaParameter();
        this.betaprior = gaussianProcessSkytrackLikelihood.getBetaParameter();
        this.lambdaBoundParameter = gaussianProcessSkytrackLikelihood.getLambdaBoundParameter();
        this.currentQ = gaussianProcessSkytrackLikelihood.getWeightMatrix();
        this.CoalPosIndicator = gaussianProcessSkytrackLikelihood.getCoalPosIndicator();
        this.CoalTime = gaussianProcessSkytrackLikelihood.getCoalTime();
        this.CoalCounts = gaussianProcessSkytrackLikelihood.getCoalCounts();
        this.numberPoints = this.CoalCounts.getSize();
        this.numPoints = gaussianProcessSkytrackLikelihood.getNumPoints();
        this.scaleFactor = d2;
        this.setWeight(d);
    }

    public GaussianProcessSkytrackBlockUpdateOperator() {
    }

    private double getProposalLambda(double d) {
        double d2 = MathUtils.uniform(d - 1.0E-5, d + 1.0E-5);
        if (d2 < 0.0) {
            d2 = -d2;
        }
        return d2;
    }

    private double getPriorLambda(double d, double d2, double d3) {
        double d4 = d3 < d ? d2 * (1.0 / d) : (1.0 - d2) * (1.0 / d) * Math.exp(-(1.0 / d) * (d3 - d));
        return d4;
    }

    private void getNewUpperBound(double d) {
        double d2 = this.getProposalLambda(d);
        double d3 = this.lambdaParameter.getParameterValue(0);
        double d4 = this.getPriorLambda(d3, 0.01, d2) * Math.pow(d2 / d, this.popSizeParameter.getSize()) * Math.exp((d - d2) * this.GPvalue.getConstlik()) / this.getPriorLambda(d3, 0.01, d);
        if (d4 > MathUtils.nextDouble()) {
            this.lambdaBoundParameter.setParameterValue(0, d2);
        }
    }

    private double getQuadraticForm(SymmTridiagMatrix symmTridiagMatrix, DenseVector denseVector) {
        DenseVector denseVector2 = new DenseVector(denseVector.size());
        symmTridiagMatrix.mult(denseVector, denseVector2);
        return denseVector.dot(denseVector2);
    }

    protected SymmTridiagMatrix getQmatrix(double d, DenseVector denseVector) {
        double d2 = 0.0;
        double[] dArray = new double[denseVector.size() - 1];
        double[] dArray2 = new double[denseVector.size()];
        for (int i = 0; i < denseVector.size() - 1; ++i) {
            dArray[i] = d * (-1.0 / (denseVector.get(i + 1) - denseVector.get(i)));
            if (i >= denseVector.size() - 2) continue;
            dArray2[i + 1] = -dArray[i] + d * (1.0 / (denseVector.get(i + 2) - denseVector.get(i + 1)) + d2);
        }
        dArray2[0] = -dArray[0] + d * d2;
        dArray2[denseVector.size() - 1] = -dArray[denseVector.size() - 2] + d * d2;
        SymmTridiagMatrix symmTridiagMatrix = new SymmTridiagMatrix(dArray2, dArray);
        return symmTridiagMatrix;
    }

    protected SymmTridiagMatrix getQmatrix(double d, double[] dArray) {
        double d2 = 1.0E-11;
        double[] dArray2 = new double[dArray.length - 1];
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray.length - 1; ++i) {
            dArray2[i] = d * (-1.0 / (dArray[i + 1] - dArray[i]));
            if (i >= dArray.length - 2) continue;
            dArray3[i + 1] = -dArray2[i] + d * (1.0 / (dArray[i + 2] - dArray[i + 1]) + d2);
        }
        dArray3[0] = -dArray2[0] + d * d2;
        dArray3[dArray.length - 1] = -dArray2[dArray.length - 2] + d * d2;
        SymmTridiagMatrix symmTridiagMatrix = new SymmTridiagMatrix(dArray3, dArray2);
        return symmTridiagMatrix;
    }

    protected QuadupleGP sortUpdate(double[] dArray, double[] dArray2) {
        int n = dArray.length + dArray2.length;
        double[] dArray3 = new double[n];
        int[] nArray = new int[n];
        int[] nArray2 = new int[dArray2.length];
        int[] nArray3 = new int[dArray.length];
        int n2 = dArray.length;
        double d = dArray2[0];
        double d2 = dArray[0];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            if (n2 < n) {
                if (d2 < d) {
                    dArray3[i] = d2;
                    nArray[i] = n3;
                    nArray3[n3] = i;
                    d2 = dArray[++n3];
                    continue;
                }
                dArray3[i] = d;
                nArray[i] = n2;
                nArray2[n2 - dArray.length] = i;
                if (++n2 >= n) continue;
                d = dArray2[n2 - dArray.length];
                continue;
            }
            dArray3[i] = dArray[n3];
            nArray[i] = n3;
            nArray3[n3] = i;
            ++n3;
        }
        return new QuadupleGP(dArray3, nArray, nArray2, nArray3);
    }

    protected Quaduple1GP sortUpdate(double[] dArray, double d) {
        int n = dArray.length + 1;
        double[] dArray2 = new double[n];
        int[] nArray = new int[n];
        int n2 = 0;
        int[] nArray2 = new int[dArray.length];
        int n3 = dArray.length;
        double d2 = d;
        double d3 = dArray[0];
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            if (n3 < n) {
                if (d3 < d2) {
                    dArray2[i] = d3;
                    nArray[i] = n4;
                    nArray2[n4] = i;
                    d3 = dArray[++n4];
                    continue;
                }
                dArray2[i] = d2;
                nArray[i] = n3++;
                n2 = i;
                if (n3 >= n) continue;
                d2 = d;
                continue;
            }
            dArray2[i] = dArray[n4];
            nArray[i] = n4;
            nArray2[n4] = i;
            ++n4;
        }
        return new Quaduple1GP(dArray2, nArray, n2, nArray2);
    }

    protected int[] Neighbors(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        int n2 = 0;
        for (int i = 0; i < nArray.length - 1; ++i) {
            if (nArray[i] == 0) {
                if (nArray[i + 1] > 2) {
                    nArray2[n2] = 0;
                    nArray2[n2 + 1] = 1;
                    n2 += 2;
                }
                if (nArray[i + 1] != 2) continue;
                nArray2[n2] = 0;
                ++n2;
                continue;
            }
            if (nArray[i + 1] - nArray[i] > 2) {
                nArray2[n2] = nArray[i] - 1;
                nArray2[n2 + 1] = nArray[i];
                nArray2[n2 + 2] = nArray[i] + 1;
                n2 += 3;
            }
            if (nArray[i + 1] - nArray[i] == 2) {
                nArray2[n2] = nArray[i] - 1;
                nArray2[n2 + 1] = nArray[i];
                n2 += 2;
            }
            if (nArray[i + 1] - nArray[i] != 1) continue;
            nArray2[n2] = nArray[i] - 1;
            ++n2;
        }
        nArray2[n2] = nArray[nArray.length - 1] - 1;
        nArray2[n2 + 1] = nArray[nArray.length - 1];
        nArray2[n2 + 2] = nArray[nArray.length - 1] + 1;
        int[] nArray3 = new int[n2 += 3];
        System.arraycopy(nArray2, 0, nArray3, 0, n2);
        return nArray3;
    }

    protected int[] Neighbors(int n) {
        int[] nArray = new int[3];
        int n2 = 3;
        if (n > 0) {
            nArray[0] = n - 1;
            nArray[1] = n;
            nArray[2] = n + 1;
        } else {
            nArray[0] = 0;
            nArray[1] = 1;
            n2 = 2;
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    protected double[] SubsetData(double[] dArray, int[] nArray) {
        double[] dArray2 = new double[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            dArray2[i] = dArray[nArray[i]];
        }
        return dArray2;
    }

    protected double[] SubsetData(DenseVector denseVector, int[] nArray) {
        double[] dArray = new double[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            dArray[i] = denseVector.get(nArray[i]);
        }
        return dArray;
    }

    protected int[] SubsetData(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[nArray2.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray3[i] = nArray[nArray2[i]];
        }
        return nArray3;
    }

    protected PairIndex SubIndex(int[] nArray, int n, int n2) {
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n];
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= n) {
                nArray2[n3] = i;
                ++n3;
                continue;
            }
            nArray3[n4] = i;
            ++n4;
        }
        int[] nArray4 = new int[n4];
        System.arraycopy(nArray3, 0, nArray4, 0, n4);
        return new PairIndex(nArray2, nArray4);
    }

    private double getNewPrecision(double d, double d2) {
        double d3 = this.alphaprior + (double)this.popSizeParameter.getSize() * 0.5;
        double d4 = this.betaprior + 0.5 * (1.0 / d) * d2;
        return MathUtils.nextGamma(d3, d4);
    }

    public DenseVector getMultiNormalMean(DenseVector denseVector, UpperTriangBandMatrix upperTriangBandMatrix) {
        DenseVector denseVector2 = new DenseVector(denseVector.size());
        DenseVector denseVector3 = new DenseVector(denseVector.size());
        upperTriangBandMatrix.transSolve(denseVector, denseVector2);
        upperTriangBandMatrix.solve(denseVector2, denseVector3);
        return denseVector3;
    }

    public DenseVector getMultiNormal(DenseVector denseVector, UpperTriangBandMatrix upperTriangBandMatrix) {
        int n = denseVector.size();
        DenseVector denseVector2 = new DenseVector(n);
        for (int i = 0; i < n; ++i) {
            denseVector2.set(i, MathUtils.nextGaussian());
        }
        DenseVector denseVector3 = new DenseVector(denseVector.size());
        upperTriangBandMatrix.solve(denseVector2, denseVector3);
        denseVector3.add(denseVector);
        return denseVector3;
    }

    public TripGP getGPvalues(double[] dArray, DenseVector denseVector, double[] dArray2, double d) {
        int n = dArray.length;
        int n2 = dArray2.length;
        int n3 = n + n2;
        QuadupleGP quadupleGP = this.sortUpdate(dArray, dArray2);
        int[] nArray = this.Neighbors(quadupleGP.getPositionNew(), n3);
        DenseVector denseVector2 = new DenseVector(this.SubsetData(quadupleGP.getData(), nArray));
        SymmTridiagMatrix symmTridiagMatrix = this.getQmatrix(d, denseVector2);
        int[] nArray2 = this.SubsetData(quadupleGP.getOrder(), nArray);
        PairIndex pairIndex = this.SubIndex(nArray2, n, n2);
        UpperSPDBandMatrix upperSPDBandMatrix = new UpperSPDBandMatrix(Matrices.getSubMatrix(symmTridiagMatrix, pairIndex.getOrderNew(), pairIndex.getOrderNew()), 1);
        BandCholesky bandCholesky = new BandCholesky(n2, 1, true);
        bandCholesky.factor(upperSPDBandMatrix);
        DenseVector denseVector3 = new DenseVector(n2);
        int[] nArray3 = this.SubsetData(nArray2, pairIndex.getOrderOld());
        DenseVector denseVector4 = new DenseVector(this.SubsetData(denseVector, nArray3));
        Matrix matrix = Matrices.getSubMatrix(symmTridiagMatrix, pairIndex.getOrderNew(), pairIndex.getOrderOld());
        matrix.mult(-1.0, denseVector4, denseVector3);
        DenseVector denseVector5 = new DenseVector(this.getMultiNormalMean(denseVector3, bandCholesky.getU()));
        double[] dArray3 = this.getMultiNormal(denseVector5, bandCholesky.getU()).getData();
        return new TripGP(dArray3, quadupleGP.getOrder(), quadupleGP.getPositionNew());
    }

    public double[] getGPvaluesS(double[] dArray, double[] dArray2, double[] dArray3, double d) {
        int n = dArray.length;
        int n2 = dArray3.length;
        int n3 = n + n2;
        QuadupleGP quadupleGP = this.sortUpdate(dArray, dArray3);
        int[] nArray = this.Neighbors(quadupleGP.getPositionNew(), n3);
        DenseVector denseVector = new DenseVector(this.SubsetData(quadupleGP.getData(), nArray));
        SymmTridiagMatrix symmTridiagMatrix = this.getQmatrix(d, denseVector);
        int[] nArray2 = this.SubsetData(quadupleGP.getOrder(), nArray);
        PairIndex pairIndex = this.SubIndex(nArray2, n, n2);
        UpperSPDBandMatrix upperSPDBandMatrix = new UpperSPDBandMatrix(Matrices.getSubMatrix(symmTridiagMatrix, pairIndex.getOrderNew(), pairIndex.getOrderNew()), 1);
        BandCholesky bandCholesky = new BandCholesky(n2, 1, true);
        bandCholesky.factor(upperSPDBandMatrix);
        DenseVector denseVector2 = new DenseVector(n2);
        int[] nArray3 = this.SubsetData(nArray2, pairIndex.getOrderOld());
        DenseVector denseVector3 = new DenseVector(dArray2);
        DenseVector denseVector4 = new DenseVector(this.SubsetData(denseVector3, nArray3));
        Matrix matrix = Matrices.getSubMatrix(symmTridiagMatrix, pairIndex.getOrderNew(), pairIndex.getOrderOld());
        matrix.mult(-1.0, denseVector4, denseVector2);
        DenseVector denseVector5 = new DenseVector(this.getMultiNormalMean(denseVector2, bandCholesky.getU()));
        double[] dArray4 = this.getMultiNormal(denseVector5, bandCholesky.getU()).getData();
        return dArray4;
    }

    public Trip1GP getGPvalues(double[] dArray, DenseVector denseVector, double d, double d2) {
        int n = dArray.length;
        int n2 = 1;
        int n3 = n + n2;
        Quaduple1GP quaduple1GP = this.sortUpdate(dArray, d);
        int[] nArray = this.Neighbors(quaduple1GP.getPositionNew());
        DenseVector denseVector2 = new DenseVector(this.SubsetData(quaduple1GP.getData(), nArray));
        SymmTridiagMatrix symmTridiagMatrix = this.getQmatrix(d2, denseVector2);
        double d3 = 0.0;
        double d4 = 1.0;
        if (nArray.length == 3) {
            d4 = symmTridiagMatrix.get(1, 1);
            d3 = -denseVector.get(nArray[0]) * symmTridiagMatrix.get(1, 0) - denseVector.get(nArray[1]) * symmTridiagMatrix.get(1, 2);
        }
        if (nArray.length == 2) {
            d4 = symmTridiagMatrix.get(0, 0);
            d3 = -denseVector.get(nArray[0]) * symmTridiagMatrix.get(0, 1);
        }
        double d5 = d3 / d4 + MathUtils.nextGaussian() / Math.sqrt(d4);
        return new Trip1GP(d5, quaduple1GP.getOrder(), quaduple1GP.getPositionNew());
    }

    public double[] getGPvalue(double[] dArray, DenseVector denseVector, double d, double d2) {
        int n = dArray.length;
        boolean bl = true;
        Quaduple1GP quaduple1GP = this.sortUpdate(dArray, d);
        int[] nArray = this.Neighbors(quaduple1GP.getPositionNew());
        DenseVector denseVector2 = new DenseVector(this.SubsetData(quaduple1GP.getData(), nArray));
        SymmTridiagMatrix symmTridiagMatrix = this.getQmatrix(d2, denseVector2);
        double d3 = 0.0;
        double d4 = 1.0;
        if (nArray.length == 3) {
            d4 = symmTridiagMatrix.get(1, 1);
            d3 = -denseVector.get(nArray[0]) * symmTridiagMatrix.get(1, 0) - denseVector.get(nArray[1]) * symmTridiagMatrix.get(1, 2);
        }
        if (nArray.length == 2) {
            d4 = symmTridiagMatrix.get(0, 0);
            d3 = -denseVector.get(nArray[0]) * symmTridiagMatrix.get(0, 1);
        }
        double d5 = d3 / d4 + MathUtils.nextGaussian() / Math.sqrt(d4);
        double d6 = 0.5 * Math.log(d4) - 0.5 * d4 * Math.pow(d5 - d3 / d4, 2.0);
        double[] dArray2 = new double[]{d5, d6, quaduple1GP.getPositionNew()};
        return dArray2;
    }

    public double[] getGPvalueroot(double[] dArray, DenseVector denseVector, double d, double d2) {
        DenseVector denseVector2;
        double[] dArray2 = new double[2];
        double d3 = 0.0;
        double d4 = 1.0;
        if (dArray[dArray.length - 1] < d) {
            dArray2[0] = dArray[dArray.length - 1];
            dArray2[1] = d;
            denseVector2 = new DenseVector(dArray2);
            SymmTridiagMatrix symmTridiagMatrix = this.getQmatrix(d2, denseVector2);
            d4 = symmTridiagMatrix.get(1, 1);
            d3 = -denseVector.get(denseVector.size() - 1) * symmTridiagMatrix.get(0, 1);
        } else {
            dArray2[1] = dArray[dArray.length - 1];
            dArray2[0] = d;
            denseVector2 = new DenseVector(dArray2);
            SymmTridiagMatrix symmTridiagMatrix = this.getQmatrix(d2, denseVector2);
            d4 = symmTridiagMatrix.get(0, 0);
            d3 = -denseVector.get(denseVector.size() - 1) * symmTridiagMatrix.get(0, 1);
        }
        double d5 = d3 / d4 + MathUtils.nextGaussian() / Math.sqrt(d4);
        double d6 = 0.5 * Math.log(d4) - 0.5 * d4 * Math.pow(d5 - d3 / d4, 2.0);
        double[] dArray3 = new double[]{d5, d6};
        return dArray3;
    }

    public double getDensity(double[] dArray, DenseVector denseVector, double d, double d2, int n) {
        SymmTridiagMatrix symmTridiagMatrix;
        DenseVector denseVector2;
        double[] dArray2;
        double d3 = 0.0;
        double d4 = 1.0;
        if (n == 0) {
            dArray2 = new double[]{d, dArray[1]};
            denseVector2 = new DenseVector(dArray2);
            symmTridiagMatrix = this.getQmatrix(d2, denseVector2);
            d4 = symmTridiagMatrix.get(0, 0);
            d3 = -denseVector.get(1) * symmTridiagMatrix.get(0, 1);
        }
        if (n == dArray.length - 1) {
            dArray2 = new double[]{dArray[n - 1], d};
            denseVector2 = new DenseVector(dArray2);
            symmTridiagMatrix = this.getQmatrix(d2, denseVector2);
            d4 = symmTridiagMatrix.get(1, 1);
            d3 = -denseVector.get(0) * symmTridiagMatrix.get(0, 1);
        }
        if (n > 0 & n < dArray.length - 1) {
            dArray2 = new double[]{dArray[n - 1], d, dArray[n + 1]};
            denseVector2 = new DenseVector(dArray2);
            symmTridiagMatrix = this.getQmatrix(d2, denseVector2);
            d4 = symmTridiagMatrix.get(1, 1);
            d3 = -denseVector.get(n - 1) * symmTridiagMatrix.get(1, 0) - denseVector.get(n + 1) * symmTridiagMatrix.get(1, 2);
        }
        double d5 = denseVector.get(n);
        double d6 = 0.5 * Math.log(d4) - 0.5 * d4 * Math.pow(d5 - d3 / d4, 2.0);
        return d6;
    }

    public double sigmoidal(double d) {
        return 1.0 / (1.0 + Math.exp(-d));
    }

    public void addOnePoint(double d, double d2, int n, int n2) {
        this.GPcounts.setParameterValue(n2, this.GPcounts.getParameterValue(n2) + 1.0);
        this.popSizeParameter.addDimension(n, d);
        this.changePoints.addDimension(n, d2);
        this.GPtype.addDimension(n, -1.0);
        this.coalfactor.addDimension(n, this.GPcoalfactor[n2]);
    }

    public void delOnePoint(int n, int n2) {
        this.popSizeParameter.removeDimension(n);
        this.changePoints.removeDimension(n);
        this.GPtype.removeDimension(n);
        this.coalfactor.removeDimension(n);
        this.GPcounts.setParameterValue(n2, this.GPcounts.getParameterValue(n2) - 1.0);
    }

    public int wherePoint(double d, int n, double d2) {
        int n2 = 0;
        boolean bl = false;
        if (n == -1) {
            n2 = 0;
        }
        if (n >= 0) {
            n2 = this.CoalPosIndicator[n] + 1;
        }
        while (!bl) {
            if (d <= d2 + this.GPvalue.getInterval(n2)) {
                bl = true;
                continue;
            }
            d2 += this.GPvalue.getInterval(n2);
            ++n2;
        }
        return n2;
    }

    public int searchPos(double[] dArray, double d, double d2, int n) {
        boolean bl = false;
        if (d < d2) {
            while (!bl) {
                if (!(dArray[--n] <= d)) continue;
                bl = true;
            }
        } else {
            while (!bl) {
                if (!(dArray[++n] >= d)) continue;
                bl = true;
            }
        }
        return n;
    }

    public void writeChain(double[] dArray, String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string, true));
            for (int i = 0; i < dArray.length; ++i) {
                bufferedWriter.write(dArray[i] + " ");
            }
            bufferedWriter.newLine();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            System.err.println("IOException:" + iOException.getMessage());
        }
    }

    public void numberThinned(double[] dArray, DenseVector denseVector, double d) {
        this.numberPoints = this.CoalCounts.getSize();
        double[] dArray2 = new double[this.numberPoints];
        int[] nArray = new int[this.numberPoints];
        int[] nArray2 = new int[this.numberPoints];
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < this.numberPoints; ++i) {
            d3 += this.GPvalue.getGPCoalInterval(i);
            if (MathUtils.nextDouble() < 0.5) {
                nArray2[i] = 1;
                dArray2[n3] = MathUtils.uniform(d2, d3);
                nArray[n3] = this.wherePoint(dArray2[n3], i - 1, d2);
                ++n3;
            }
            d2 = d3;
        }
        double[] dArray3 = new double[n3];
        System.arraycopy(dArray2, 0, dArray3, 0, n3);
        TripGP tripGP = this.getGPvalues(dArray, denseVector, dArray3, d);
        for (int i = 0; i < this.numberPoints; ++i) {
            if (nArray2[i] == 1) {
                d4 = this.lambdaBoundParameter.getParameterValue(0) * this.GPvalue.getGPCoalInterval(i) * this.GPcoalfactor[nArray[n4]] * this.sigmoidal(-tripGP.getData()[n4]) / (this.CoalCounts.getParameterValue(i) + 1.0);
                if (MathUtils.nextDouble() < d4) {
                    this.addOnePoint(tripGP.getData()[n4], dArray3[n4], tripGP.getNewOrder()[n4] + n5, nArray[n4]);
                    this.CoalCounts.setParameterValue(i, this.CoalCounts.getParameterValue(i) + 1.0);
                } else {
                    --n5;
                }
                ++n4;
            } else {
                int n6;
                double d6 = this.CoalCounts.getParameterValue(i);
                if (d6 > 1.0) {
                    n6 = MathUtils.nextInt((int)d6 - 1);
                    n2 = n + n6;
                    d4 = d6 / (this.lambdaBoundParameter.getParameterValue(0) * this.GPvalue.getGPCoalInterval(i) * this.sigmoidal(-this.popSizeParameter.getParameterValue(n2)) * this.coalfactor.getParameterValue(n2));
                    if (MathUtils.nextDouble() < d4) {
                        d5 = i > 0 ? this.CoalTime[i - 1] : 0.0;
                        int n7 = this.wherePoint(this.changePoints.getParameterValue(n2), i - 1, d5);
                        this.delOnePoint(n2 + 1, n7);
                        this.CoalCounts.setParameterValue(i, this.CoalCounts.getParameterValue(i) - 1.0);
                        --n5;
                    }
                }
                if (d6 == 1.0) {
                    d5 = i > 0 ? this.CoalTime[i - 1] : 0.0;
                    n6 = this.wherePoint(this.changePoints.getParameterValue(n), i - 1, d5);
                    this.delOnePoint(n + 1, n6);
                    this.CoalCounts.setParameterValue(i, 0.0);
                    --n5;
                }
            }
            n = (int)((double)n + (this.CoalCounts.getParameterValue(i) + 1.0));
        }
    }

    public void locationThinned(double[] dArray, DenseVector denseVector, double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        boolean bl = false;
        double d5 = 0.0;
        double d6 = this.CoalCounts.getSize();
        int n = 0;
        while ((double)n < d6) {
            if (this.CoalCounts.getParameterValue(n) > 0.0) {
                d5 += this.GPvalue.getGPCoalInterval(n);
            }
            ++n;
        }
        n = 0;
        int n2 = 0;
        int n3 = 0;
        if (d5 > 0.0) {
            int n4;
            double d7 = MathUtils.uniform(0.0, d5);
            while (!bl) {
                d4 += this.GPvalue.getGPCoalInterval(n);
                if (this.CoalCounts.getParameterValue(n) > 0.0) {
                    if (d7 > d2 & d7 <= (d3 += this.GPvalue.getGPCoalInterval(n))) {
                        bl = true;
                    }
                    d2 = d3;
                }
                n2 = (int)((double)n2 + (this.CoalCounts.getParameterValue(n) + 1.0));
                ++n;
            }
            n2 = (int)((double)n2 - (this.CoalCounts.getParameterValue(--n) + 1.0));
            int n5 = (int)this.CoalCounts.getParameterValue(n);
            double[] dArray2 = new double[n5];
            double[] dArray3 = new double[n5];
            int[] nArray = new int[n5];
            double[] dArray4 = new double[n5];
            int[] nArray2 = new int[n5];
            for (n4 = 0; n4 < n5; ++n4) {
                dArray2[n4] = MathUtils.uniform(d4 - this.GPvalue.getGPCoalInterval(n), d4);
                nArray[n4] = this.wherePoint(dArray2[n4], n - 1, d4 - this.GPvalue.getGPCoalInterval(n));
                dArray4[n4] = dArray[n2 + n4];
                dArray3[n4] = denseVector.get(n2 + n4);
                nArray2[n4] = this.wherePoint(this.changePoints.getParameterValue(n2 + n4), n - 1, d4 - this.GPvalue.getGPCoalInterval(n));
            }
            for (n4 = 0; n4 < n5; ++n4) {
                Trip1GP trip1GP = this.getGPvalues(dArray, denseVector, dArray2[n4], d);
                double d8 = this.GPcoalfactor[nArray[n4]] * this.sigmoidal(-trip1GP.getData()) / (this.GPcoalfactor[nArray2[n4]] * this.sigmoidal(-dArray3[n4]));
                if (!(MathUtils.nextDouble() < d8)) continue;
                this.addOnePoint(trip1GP.getData(), dArray2[n4], trip1GP.getNewOrder(), nArray[n4]);
                dArray = this.changePoints.getParameterValues();
                denseVector = new DenseVector(this.popSizeParameter.getParameterValues());
                n3 = this.searchPos(dArray, dArray4[n4], dArray2[n4], trip1GP.getNewOrder());
                this.delOnePoint(n3 + 1, nArray2[n4]);
                dArray = this.changePoints.getParameterValues();
                denseVector = new DenseVector(this.popSizeParameter.getParameterValues());
            }
        }
    }

    public double forLikelihood(double[] dArray, Parameter parameter) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d -= Math.log(1.0 + Math.exp(-parameter.getParameterValue(i) * dArray[i]));
        }
        return d;
    }

    public void sliceSampling(double[] dArray, DenseVector denseVector, double d) {
        double d2 = 0.0;
        int n = 1;
        double[] dArray2 = new double[denseVector.size()];
        DenseVector denseVector2 = new DenseVector(dArray2);
        DenseVector denseVector3 = new DenseVector(dArray2);
        DenseVector denseVector4 = new DenseVector(dArray2);
        DenseVector denseVector5 = new DenseVector(dArray2);
        this.currentQ = this.getQmatrix(d, dArray);
        UpperSPDBandMatrix upperSPDBandMatrix = new UpperSPDBandMatrix(this.currentQ, 1);
        BandCholesky bandCholesky = new BandCholesky(dArray2.length, 1, true);
        bandCholesky.factor(upperSPDBandMatrix);
        denseVector2 = this.getMultiNormal(denseVector3, bandCholesky.getU());
        double d3 = MathUtils.uniform(0.0, 6.283185);
        denseVector3.add(Math.sin(d3), denseVector);
        denseVector3.add(Math.cos(d3), denseVector2);
        denseVector4.add(Math.cos(d3), denseVector);
        denseVector4.add(-Math.sin(d3), denseVector2);
        double d4 = 0.0;
        double d5 = 6.283185;
        double[] dArray3 = denseVector.getData();
        double d6 = Math.log(MathUtils.nextDouble()) + this.forLikelihood(dArray3, this.GPtype);
        double d7 = 0.0;
        while (n == 1) {
            d2 = MathUtils.uniform(d4, d5);
            denseVector5.zero();
            denseVector5.add(Math.sin(d2), denseVector3);
            denseVector5.add(Math.cos(d2), denseVector4);
            double[] dArray4 = denseVector5.getData();
            d7 = this.forLikelihood(dArray4, this.GPtype);
            if (d7 > d6) {
                n = 2;
                continue;
            }
            if (d2 < d3) {
                d4 = d2;
                continue;
            }
            d5 = d2;
        }
        for (int i = 0; i < this.popSizeParameter.getSize(); ++i) {
            this.popSizeParameter.setParameterValue(i, denseVector5.get(i));
        }
    }

    public static double logGeneralizedDeterminant(UpperTriangBandMatrix upperTriangBandMatrix) {
        double d = 0.0;
        for (int i = 0; i < upperTriangBandMatrix.numColumns(); ++i) {
            if (!(upperTriangBandMatrix.get(i, i) > 1.0E-7)) continue;
            d += Math.log(upperTriangBandMatrix.get(i, i));
        }
        return d;
    }

    @Override
    public double doOperation() {
        int n;
        System.err.println("Runs my operator");
        double d = this.precisionParameter.getParameterValue(0);
        DenseVector denseVector = new DenseVector(this.popSizeParameter.getParameterValues());
        double[] dArray = this.changePoints.getParameterValues();
        this.currentQ = this.getQmatrix(d, dArray);
        double d2 = this.getQuadraticForm(this.currentQ, denseVector);
        double d3 = this.getNewPrecision(d, d2);
        this.precisionParameter.setParameterValue(0, d3);
        d = this.precisionParameter.getParameterValue(0);
        double d4 = this.lambdaBoundParameter.getParameterValue(0);
        this.getNewUpperBound(d4);
        d4 = this.lambdaBoundParameter.getParameterValue(0);
        this.numberThinned(dArray, denseVector, d);
        DenseVector denseVector2 = new DenseVector(this.popSizeParameter.getParameterValues());
        double[] dArray2 = this.changePoints.getParameterValues();
        this.locationThinned(dArray2, denseVector2, d);
        DenseVector denseVector3 = new DenseVector(this.popSizeParameter.getParameterValues());
        double[] dArray3 = this.changePoints.getParameterValues();
        this.sliceSampling(dArray3, denseVector3, d);
        this.numPoints.setParameterValue(0, this.popSizeParameter.getSize());
        double[] dArray4 = this.popSizeParameter.getParameterValues();
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < this.changePoints.getSize(); ++n) {
            if (this.GPtype.getParameterValue(n) != 1.0) continue;
            ++n2;
        }
        for (n = 0; n < this.CoalCounts.getSize(); ++n) {
            n3 = (int)((double)n3 + this.CoalCounts.getParameterValue(n));
        }
        if (n2 != this.CoalCounts.getSize()) {
            System.err.println("WARNING CONSISTENCY 1");
        }
        if (n3 != this.changePoints.getSize() - this.CoalCounts.getSize()) {
            System.err.println("WARNING CONSISTENCY 2" + n3 + "and changePts size" + this.changePoints.getSize());
        }
        return 0.0;
    }

    @Override
    public final String getOperatorName() {
        return "gpBlockUpdateOperator";
    }

    public double getTemperature() {
        return 0.0;
    }

    public int getStepCount() {
        return 1;
    }

    public double getRawParameter() {
        return this.scaleFactor;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public double getTargetAcceptanceProbability() {
        return 0.234;
    }

    public double getMinimumAcceptanceLevel() {
        return 0.1;
    }

    public double getMaximumAcceptanceLevel() {
        return 0.4;
    }

    public double getMinimumGoodAcceptanceLevel() {
        return 0.2;
    }

    public double getMaximumGoodAcceptanceLevel() {
        return 0.3;
    }

    public final String getPerformanceSuggestion() {
        double d = this.getAcceptanceProbability();
        double d2 = this.getTargetAcceptanceProbability();
        NumberFormatter numberFormatter = new NumberFormatter(5);
        double d3 = OperatorUtils.optimizeWindowSize(this.scaleFactor, d, d2);
        if (d < this.getMinimumGoodAcceptanceLevel()) {
            return "Try setting scaleFactor to about " + numberFormatter.format(d3);
        }
        if (d > this.getMaximumGoodAcceptanceLevel()) {
            return "Try setting scaleFactor to about " + numberFormatter.format(d3);
        }
        return "";
    }

    public class Quaduple1GP {
        private double[] array1;
        private int[] array2;
        private int array3;
        private int[] array4;

        public Quaduple1GP(double[] dArray, int[] nArray, int n, int[] nArray2) {
            this.array1 = dArray;
            this.array2 = nArray;
            this.array3 = n;
            this.array4 = nArray2;
        }

        public double[] getData() {
            return this.array1;
        }

        public int[] getOrder() {
            return this.array2;
        }

        public int getPositionNew() {
            return this.array3;
        }

        public int[] getPositionOld() {
            return this.array4;
        }
    }

    public class QuadupleGP {
        private double[] array1;
        private int[] array2;
        private int[] array3;
        private int[] array4;

        public QuadupleGP(double[] dArray, int[] nArray, int[] nArray2, int[] nArray3) {
            this.array1 = dArray;
            this.array2 = nArray;
            this.array3 = nArray2;
            this.array4 = nArray3;
        }

        public double[] getData() {
            return this.array1;
        }

        public int[] getOrder() {
            return this.array2;
        }

        public int[] getPositionNew() {
            return this.array3;
        }

        public int[] getPositionOld() {
            return this.array4;
        }
    }

    public class PairIndex {
        private int[] array1;
        private int[] array2;

        public PairIndex(int[] nArray, int[] nArray2) {
            this.array1 = nArray;
            this.array2 = nArray2;
        }

        public int[] getOrderNew() {
            return this.array1;
        }

        public int[] getOrderOld() {
            return this.array2;
        }
    }

    private class Trip1GP {
        private double array1;
        private int[] array2;
        private int array3;

        public Trip1GP(double d, int[] nArray, int n) {
            this.array1 = d;
            this.array2 = nArray;
            this.array3 = n;
        }

        public double getData() {
            return this.array1;
        }

        public int[] getOrder() {
            return this.array2;
        }

        public int getNewOrder() {
            return this.array3;
        }
    }

    public class TripGP {
        private double[] array1;
        private int[] array2;
        private int[] array3;

        public TripGP(double[] dArray, int[] nArray, int[] nArray2) {
            this.array1 = dArray;
            this.array2 = nArray;
            this.array3 = nArray2;
        }

        public double[] getData() {
            return this.array1;
        }

        public int[] getOrder() {
            return this.array2;
        }

        public int[] getNewOrder() {
            return this.array3;
        }
    }

    public class Pair1GP {
        private double array1;
        private int[] array2;

        public Pair1GP(double d, int[] nArray) {
            this.array1 = d;
            this.array2 = nArray;
        }

        public double getData() {
            return this.array1;
        }

        public int[] getOrder() {
            return this.array2;
        }
    }

    private class PairGP {
        private double[] array1;
        private int[] array2;

        public PairGP(double[] dArray, int[] nArray) {
            this.array1 = dArray;
            this.array2 = nArray;
        }

        public double[] getData() {
            return this.array1;
        }

        public int[] getOrder() {
            return this.array2;
        }
    }
}

