/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchmodel;

import dr.evolution.tree.NodeRef;
import dr.evomodel.branchmodel.BranchModel;
import dr.evomodel.substmodel.FrequencyModel;
import dr.evomodel.substmodel.SubstitutionModel;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Variable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

public class BranchAssignmentModel
extends AbstractModel
implements BranchModel {
    public static final String BRANCH_ASSIGNMENT_MODEL = "branchAssignmentModel";
    private TreeModel treeModel;
    private final String annotation;
    private final LinkedHashMap<Integer, SubstitutionModel> modelIndexMap;
    private final SubstitutionModel baseModel;
    private Integer baseModelIndex;
    private LinkedHashMap<NodeRef, Integer> branchAssignmentMap;
    private LinkedList<SubstitutionModel> substitutionModels;

    public BranchAssignmentModel(TreeModel treeModel, String string, LinkedHashMap<Integer, SubstitutionModel> linkedHashMap, SubstitutionModel substitutionModel) {
        super(BRANCH_ASSIGNMENT_MODEL);
        this.treeModel = treeModel;
        this.annotation = string;
        this.modelIndexMap = linkedHashMap;
        this.baseModel = substitutionModel;
        this.substitutionModels = new LinkedList();
        this.branchAssignmentMap = new LinkedHashMap();
        this.baseModelIndex = linkedHashMap.size();
        this.setup();
    }

    private void setup() {
        for (NodeRef nodeRef : this.treeModel.getNodes()) {
            if (this.treeModel.isRoot(nodeRef)) continue;
            Integer n = Integer.MAX_VALUE;
            SubstitutionModel substitutionModel = null;
            Object object = this.treeModel.getNodeAttribute(nodeRef, this.annotation);
            if (object == null) {
                System.out.println("Attribute " + this.annotation + " missing from node. Using base model as branch model.");
                n = this.baseModelIndex;
                substitutionModel = this.baseModel;
            } else {
                n = (Integer)object;
                substitutionModel = this.modelIndexMap.get(n);
            }
            this.branchAssignmentMap.put(nodeRef, n);
            this.substitutionModels.add(substitutionModel);
        }
    }

    @Override
    public BranchModel.Mapping getBranchModelMapping(NodeRef nodeRef) {
        final int n = this.branchAssignmentMap.get(nodeRef);
        return new BranchModel.Mapping(){

            @Override
            public int[] getOrder() {
                return new int[]{n};
            }

            @Override
            public double[] getWeights() {
                return new double[]{1.0};
            }
        };
    }

    @Override
    public List<SubstitutionModel> getSubstitutionModels() {
        return this.substitutionModels;
    }

    @Override
    public SubstitutionModel getRootSubstitutionModel() {
        Object object = this.treeModel.getNodeAttribute(this.treeModel.getRoot(), "annotationValue");
        SubstitutionModel substitutionModel = null;
        if (object == null) {
            substitutionModel = this.baseModel;
        } else {
            Integer n = (Integer)object;
            substitutionModel = this.modelIndexMap.get(n);
        }
        return substitutionModel;
    }

    @Override
    public FrequencyModel getRootFrequencyModel() {
        return this.getRootSubstitutionModel().getFrequencyModel();
    }

    @Override
    public boolean requiresMatrixConvolution() {
        return false;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.fireModelChanged();
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }
}

