/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.reified.leaves;

import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.reified.ArithmNode;
import choco.kernel.solver.constraints.reified.INode;
import choco.kernel.solver.constraints.reified.NodeType;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class VariableLeaf
extends INode
implements ArithmNode {
    public int idx;
    public IntDomainVar var;
    public IntegerVariable ivar;

    public VariableLeaf(IntDomainVar var) {
        super(NodeType.VARIABLELEAF);
        this.var = var;
    }

    public VariableLeaf(IntegerVariable ivar) {
        super(NodeType.VARIABLELEAF);
        this.ivar = ivar;
    }

    public int getIdx() {
        return this.idx;
    }

    public void setSolverVar(IntDomainVar v) {
        this.var = v;
    }

    @Override
    public int eval(int[] tuple) {
        return tuple[this.idx];
    }

    @Override
    public void setIndexes(IntDomainVar[] vs) {
        for (int i = 0; i < vs.length; ++i) {
            if (vs[i] != this.var) continue;
            this.idx = i;
            break;
        }
    }

    @Override
    public final IntDomainVar[] getScope(Solver s) {
        if (this.ivar != null) {
            this.var = s.getVar(this.ivar);
        }
        return new IntDomainVar[]{this.var};
    }

    @Override
    public IntegerVariable[] getModelScope() {
        return new IntegerVariable[]{this.ivar};
    }

    @Override
    public boolean isDecompositionPossible() {
        return true;
    }

    @Override
    public boolean isReified() {
        return false;
    }

    @Override
    public IntDomainVar extractResult(Solver s) {
        return this.var;
    }

    @Override
    public int getNbSubTrees() {
        return 0;
    }

    @Override
    public boolean isAVariable() {
        return true;
    }

    @Override
    public boolean isBoolean() {
        return this.var.hasBooleanDomain();
    }

    @Override
    public boolean isAConstant() {
        return false;
    }

    @Override
    public String pretty() {
        return this.var.pretty();
    }

    @Override
    public int countNbVar() {
        return 1;
    }

    @Override
    public boolean isALinearTerm() {
        return true;
    }

    @Override
    public int[] computeLinearExpr(int scope) {
        int[] coeffs = new int[scope + 1];
        coeffs[this.idx] = 1;
        return coeffs;
    }
}

