/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.common.util.preprocessor.detector.scheduling;

import choco.Choco;
import choco.cp.common.util.preprocessor.detector.scheduling.AbstractRscDetector;
import choco.cp.common.util.preprocessor.detector.scheduling.DisjunctiveModel;
import choco.cp.common.util.preprocessor.detector.scheduling.PPResource;
import choco.cp.model.CPModel;
import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.model.constraints.ConstraintType;
import choco.kernel.model.constraints.TemporalConstraint;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.model.variables.scheduling.TaskVariable;

public class DisjointFromUnaryModelDetector
extends AbstractRscDetector {
    public DisjointFromUnaryModelDetector(CPModel model, DisjunctiveModel disjMod) {
        super(model, disjMod);
    }

    @Override
    protected ConstraintType getType() {
        return ConstraintType.DISJUNCTIVE;
    }

    protected boolean isDisjoint(PPResource rsc, int i, int j) {
        return true;
    }

    @Override
    protected final void apply(PPResource rsc) {
        int n = rsc.getParameters().getNbRegularTasks();
        for (int i = 0; i < n; ++i) {
            TaskVariable t1 = rsc.getTask(i);
            for (int j = i + 1; j < n; ++j) {
                TaskVariable t2 = rsc.getTask(j);
                if (this.disjMod.containsRelation(t1, t2) || !this.isDisjoint(rsc, i, j)) continue;
                IntegerVariable dir = Choco.makeBooleanVar(StringUtils.dirRandomName(t1.getName(), t2.getName()), new String[0]);
                TemporalConstraint c = (TemporalConstraint)Choco.precedenceDisjoint(t1, t2, dir);
                this.disjMod.addEdge(t1.getHook(), t2.getHook(), c);
                this.add(dir);
                this.add(c);
            }
        }
    }
}

