/*
 * Decompiled with CFR 0.152.
 */
package org.extratrees;

import java.util.ArrayList;

public class QuickSelect {
    private static final int CUTOFF = 10;

    public static double quickSelect(ArrayList<Double> arrayList, double d) {
        int n = 1 + (int)Math.round(d * (double)arrayList.size());
        if (n > arrayList.size()) {
            n = arrayList.size();
        }
        return QuickSelect.quickSelect(arrayList, n);
    }

    public static double quickSelect(ArrayList<Double> arrayList, int n) {
        if (n <= 0) {
            return Double.NaN;
        }
        QuickSelect.quickSelect(arrayList, 0, arrayList.size() - 1, n);
        return arrayList.get(n - 1);
    }

    private static void quickSelect(ArrayList<Double> arrayList, int n, int n2, int n3) {
        if (n + 10 > n2) {
            QuickSelect.insertionSort(arrayList, n, n2);
        } else {
            int n4 = (n + n2) / 2;
            if (arrayList.get(n4).compareTo(arrayList.get(n)) < 0) {
                QuickSelect.swapReferences(arrayList, n, n4);
            }
            if (arrayList.get(n2).compareTo(arrayList.get(n)) < 0) {
                QuickSelect.swapReferences(arrayList, n, n2);
            }
            if (arrayList.get(n2).compareTo(arrayList.get(n4)) < 0) {
                QuickSelect.swapReferences(arrayList, n4, n2);
            }
            QuickSelect.swapReferences(arrayList, n4, n2 - 1);
            Double d = arrayList.get(n2 - 1);
            int n5 = n;
            int n6 = n2 - 1;
            while (true) {
                if (arrayList.get(++n5).compareTo(d) < 0) {
                    continue;
                }
                while (d.compareTo(arrayList.get(--n6)) < 0) {
                }
                if (n5 >= n6) break;
                QuickSelect.swapReferences(arrayList, n5, n6);
            }
            QuickSelect.swapReferences(arrayList, n5, n2 - 1);
            if (n3 <= n5) {
                QuickSelect.quickSelect(arrayList, n, n5 - 1, n3);
            } else if (n3 > n5 + 1) {
                QuickSelect.quickSelect(arrayList, n5 + 1, n2, n3);
            }
        }
    }

    private static void insertionSort(ArrayList<Double> arrayList, int n, int n2) {
        for (int i = n + 1; i <= n2; ++i) {
            int n3;
            Double d = arrayList.get(i);
            for (n3 = i; n3 > n && d.compareTo(arrayList.get(n3 - 1)) < 0; --n3) {
                arrayList.set(n3, arrayList.get(n3 - 1));
            }
            arrayList.set(n3, d);
        }
    }

    public static final void swapReferences(ArrayList<Double> arrayList, int n, int n2) {
        Double d = arrayList.get(n);
        arrayList.set(n, arrayList.get(n2));
        arrayList.set(n2, d);
    }
}

