/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Associative_Classification.ClassifierFuzzyFARCHD;

import java.util.ArrayList;
import java.util.Collections;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFARCHD.DataBase;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFARCHD.Individual;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFARCHD.RuleBase;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFARCHD.myDataset;
import org.core.Randomize;

public class Population {
    ArrayList<Individual> Population;
    double alpha;
    double w1;
    double L;
    double Lini;
    int n_variables;
    int pop_size;
    int maxTrials;
    int nTrials;
    int BITS_GEN;
    double best_fitness;
    double best_accuracy;
    int[] selected;
    myDataset train;
    DataBase dataBase;
    RuleBase ruleBase;

    public boolean BETTER(double a, double b) {
        return a > b;
    }

    public Population() {
    }

    public Population(myDataset train, DataBase dataBase, RuleBase ruleBase, int size, int BITS_GEN, int maxTrials, double alpha) {
        this.dataBase = dataBase;
        this.train = train;
        this.ruleBase = ruleBase;
        this.BITS_GEN = BITS_GEN;
        this.n_variables = dataBase.numVariables();
        this.pop_size = size;
        this.alpha = alpha;
        this.maxTrials = maxTrials;
        this.L = this.Lini = (double)(dataBase.getnLabelsReal() * BITS_GEN + ruleBase.size()) / 4.0;
        this.w1 = this.alpha * (double)ruleBase.size();
        this.Population = new ArrayList();
        this.selected = new int[this.pop_size];
    }

    public void Generation() {
        this.init();
        this.evaluate(0);
        do {
            this.selection();
            this.crossover();
            this.evaluate(this.pop_size);
            this.elitist();
            if (this.hasNew()) continue;
            this.L -= 1.0;
            if (!(this.L < 0.0)) continue;
            this.restart();
        } while (this.nTrials < this.maxTrials);
    }

    private void init() {
        Individual ind = new Individual(this.ruleBase, this.dataBase, this.w1);
        ind.reset();
        this.Population.add(ind);
        for (int i = 1; i < this.pop_size; ++i) {
            ind = new Individual(this.ruleBase, this.dataBase, this.w1);
            ind.randomValues();
            this.Population.add(ind);
        }
        this.best_fitness = 0.0;
        this.nTrials = 0;
    }

    private void evaluate(int pos) {
        for (int i = pos; i < this.Population.size(); ++i) {
            this.Population.get(i).evaluate();
        }
        this.nTrials += this.Population.size() - pos;
    }

    private void selection() {
        int i;
        for (i = 0; i < this.pop_size; ++i) {
            this.selected[i] = i;
        }
        for (i = 0; i < this.pop_size; ++i) {
            int random = Randomize.Randint(0, this.pop_size);
            int aux = this.selected[random];
            this.selected[random] = this.selected[i];
            this.selected[i] = aux;
        }
    }

    private void xPC_BLX(double d, Individual son1, Individual son2) {
        son1.xPC_BLX(son2, d);
    }

    private void Hux(Individual son1, Individual son2) {
        son1.Hux(son2);
    }

    private void crossover() {
        for (int i = 0; i < this.pop_size; i += 2) {
            Individual dad = this.Population.get(this.selected[i]);
            Individual mom = this.Population.get(this.selected[i + 1]);
            double dist = dad.distHamming(mom, this.BITS_GEN);
            if (!((dist /= 2.0) > this.L)) continue;
            Individual son1 = dad.clone();
            Individual son2 = mom.clone();
            this.xPC_BLX(1.0, son1, son2);
            this.Hux(son1, son2);
            son1.onNew();
            son2.onNew();
            this.Population.add(son1);
            this.Population.add(son2);
        }
    }

    private void elitist() {
        Collections.sort(this.Population);
        while (this.Population.size() > this.pop_size) {
            this.Population.remove(this.pop_size);
        }
        this.best_fitness = this.Population.get(0).getFitness();
    }

    private boolean hasNew() {
        boolean state = false;
        for (int i = 0; i < this.pop_size; ++i) {
            Individual ind = this.Population.get(i);
            if (!ind.isNew()) continue;
            ind.offNew();
            state = true;
        }
        return state;
    }

    private void restart() {
        this.w1 = 0.0;
        Collections.sort(this.Population);
        Individual ind = this.Population.get(0).clone();
        ind.setw1(this.w1);
        this.Population.clear();
        this.Population.add(ind);
        for (int i = 1; i < this.pop_size; ++i) {
            ind = new Individual(this.ruleBase, this.dataBase, this.w1);
            ind.randomValues();
            this.Population.add(ind);
        }
        this.evaluate(0);
        this.L = this.Lini;
    }

    public RuleBase getBestRB() {
        Collections.sort(this.Population);
        RuleBase ruleBase = this.Population.get(0).generateRB();
        return ruleBase;
    }
}

