/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

import ec.tstoolkit.arima.estimation.ArmaKF;
import ec.tstoolkit.arima.estimation.RegArimaEstimation;
import ec.tstoolkit.arima.estimation.RegArimaModel;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.modelling.arima.IDifferencingModule;
import ec.tstoolkit.modelling.arima.IPreprocessingModule;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.ProcessingResult;
import ec.tstoolkit.modelling.arima.tramo.AbstractTramoModule;
import ec.tstoolkit.modelling.arima.tramo.TramoException;
import ec.tstoolkit.modelling.arima.tramo.TramoProcessor;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;
import ec.tstoolkit.sarima.estimation.GlsSarimaMonitor;
import ec.tstoolkit.sarima.estimation.HannanRissanen;
import ec.tstoolkit.sarima.estimation.SarimaMapping;

public class DifferencingModule
extends AbstractTramoModule
implements IDifferencingModule,
IPreprocessingModule {
    public static final int MAXD = 2;
    public static final int MAXBD = 1;
    public static final double EPS = 1.0E-5;
    private DataBlock data_ = null;
    private SarimaSpecification spec_ = new SarimaSpecification();
    private boolean seas_;
    private SarimaModel lastModel_;
    private RegArimaModel<SarimaModel> model_;
    private volatile double rmax_;
    private volatile double rsmax_;
    private volatile double c_;
    private volatile double din_;
    private double ub1_ = 0.97;
    private double ub2_ = 0.91;
    private double cancel_ = 0.1;
    private int iter_;
    private boolean ml_;
    private boolean useml_;
    private boolean mlused_;
    private boolean bcalc_;
    private double tmean_;
    private int maxd = 2;
    private int maxbd = 1;
    private static final String DIFFERENCING = "Differencing";

    private static double removeMean(DataBlock data) {
        int n = data.getLength();
        double m = data.sum() / (double)n;
        data.sub(m);
        return m;
    }

    static boolean comespd(int freq, int nz, boolean seas) {
        SarimaSpecification spec = new SarimaSpecification(freq);
        spec.setD(2);
        if (seas) {
            spec.setBD(1);
        }
        return TramoProcessor.autlar(nz, spec) >= 0;
    }

    private void allcond() {
        if (this.spec_.getD() + this.spec_.getBD() != 0) {
            return;
        }
        double ar = this.lastModel_.phi(1);
        if (!this.seas_) {
            if (Math.abs(ar + 1.0) <= this.din_) {
                this.spec_.setD(this.spec_.getD() + 1);
            }
        } else {
            double sar = this.lastModel_.bphi(1);
            if (Math.abs(ar + 1.0) <= 0.15 || Math.abs(sar + 1.0) <= this.din_) {
                this.rmax_ = -ar;
                this.rsmax_ = -sar;
                if (ar < sar) {
                    this.spec_.setD(this.spec_.getD() + 1);
                } else {
                    this.spec_.setBD(this.spec_.getBD() + 1);
                }
            }
        }
    }

    private void calc() {
        if (this.data_ == null || this.bcalc_) {
            return;
        }
        this.c_ = this.cancel_;
        this.useml_ = false;
        this.mlused_ = false;
        this.bcalc_ = true;
        this.rsmax_ = 0.0;
        this.rmax_ = 0.0;
        this.din_ = 0.0;
        this.step0();
        this.iter_ = 0;
        while (this.nextstep() && this.iter_ < 5) {
            ++this.iter_;
        }
        this.computeTMean();
    }

    public void clear() {
        this.lastModel_ = null;
        this.model_ = null;
        this.spec_ = new SarimaSpecification();
        this.bcalc_ = false;
        this.data_ = null;
        this.useml_ = false;
        this.tmean_ = 0.0;
    }

    private int cond1(int icon) {
        if (this.spec_.getD() + this.spec_.getBD() != 0) {
            return icon;
        }
        double ar = this.lastModel_.phi(1);
        double ma = this.lastModel_.theta(1);
        double sar = 0.0;
        double sma = 0.0;
        if (this.seas_) {
            sar = this.lastModel_.bphi(1);
            sma = this.lastModel_.btheta(1);
        }
        if ((Math.abs(ar - ma) < this.c_ || this.seas_ && Math.abs(sar - sma) < this.c_) && (this.rmax_ >= 0.9 || this.rsmax_ >= 0.9)) {
            if (this.useml_ && icon == 1) {
                this.useml_ = false;
            } else {
                ++icon;
            }
            if (this.rmax_ > this.rsmax_) {
                this.spec_.setD(this.spec_.getD() + 1);
            } else {
                this.spec_.setBD(this.spec_.getBD() + 1);
            }
        }
        return icon;
    }

    private int finalcond(int icon) {
        if (icon == 2) {
            this.spec_.setD(this.spec_.getD() - 1);
            this.spec_.setBD(this.spec_.getBD() - 1);
            if (this.mlused_) {
                if (this.lastModel_.phi(1) < this.lastModel_.bphi(1)) {
                    this.spec_.setD(this.spec_.getD() + 1);
                } else {
                    this.spec_.setBD(this.spec_.getBD() + 1);
                }
            } else if (this.rmax_ > this.rsmax_) {
                if (this.rmax_ > 0.0) {
                    this.spec_.setD(this.spec_.getD() + 1);
                }
            } else if (this.rsmax_ > 0.0) {
                this.spec_.setBD(this.spec_.getBD() + 1);
            }
        }
        if (this.spec_.getD() > this.maxd) {
            this.spec_.setD(this.maxd);
            icon = 0;
        }
        if (this.spec_.getBD() > this.maxbd) {
            this.spec_.setBD(this.maxbd);
            icon = 0;
        }
        return icon;
    }

    @Override
    public int getBD() {
        return this.spec_.getBD();
    }

    public double getTMean() {
        return this.tmean_;
    }

    @Override
    public int getD() {
        return this.spec_.getD();
    }

    public BackFilter getDifferencingFilter() {
        return this.spec_.getDifferencingFilter();
    }

    @Override
    public boolean isMeanCorrection() {
        return TramoProcessor.meantest(this.data_.getLength(), this.tmean_);
    }

    @Deprecated
    public boolean isMean() {
        return this.isMeanCorrection();
    }

    public double getUB1() {
        return this.ub1_;
    }

    public double getUB2() {
        return this.ub2_;
    }

    public boolean hasSeas() {
        return this.seas_;
    }

    public void setSeas(boolean seas) {
        this.seas_ = seas;
    }

    public double getCancel() {
        return this.cancel_;
    }

    private void initstep(boolean bstart) {
        boolean usedefault;
        if (this.spec_.getD() == 0 && this.spec_.getBD() == 0 && bstart) {
            if (this.spec_.getFrequency() != 2) {
                this.spec_.setP(2);
            } else {
                this.spec_.setP(1);
            }
            this.spec_.setQ(0);
            this.spec_.setBQ(0);
            if (this.seas_) {
                this.spec_.setBP(1);
            }
        } else {
            this.spec_.setP(1);
            this.spec_.setQ(1);
            if (this.seas_) {
                this.spec_.setBP(1);
                this.spec_.setBQ(1);
            }
        }
        this.model_ = new RegArimaModel<SarimaModel>(new SarimaModel(this.spec_), this.data_);
        this.model_.setMeanCorrection(true);
        DataBlock data = this.model_.getDModel().getY().deepClone();
        double mean = DifferencingModule.removeMean(data);
        HannanRissanen hr = new HannanRissanen();
        boolean bl = usedefault = !hr.process(data, this.spec_.doStationary());
        if (!usedefault) {
            this.lastModel_ = hr.getModel();
            if (bstart && !this.lastModel_.isStable(true)) {
                if (this.spec_.getP() > 1 || this.spec_.getP() == 1 && Math.abs(this.lastModel_.phi(1)) > 1.02 || this.spec_.getBP() == 1 && Math.abs(this.lastModel_.bphi(1)) > 1.02) {
                    usedefault = true;
                } else {
                    SarimaMapping.stabilize(this.lastModel_);
                }
            }
        }
        if (usedefault) {
            this.lastModel_ = new SarimaModel(this.spec_.doStationary());
        }
        if (usedefault || this.ml_ || this.useml_) {
            SarimaMapping.stabilize(this.lastModel_);
            GlsSarimaMonitor monitor = this.getMonitor();
            monitor.setPrecision(1.0E-5);
            monitor.useMaximumLikelihood(!bstart || this.spec_.getD() != 0 || this.spec_.getBD() != 0);
            RegArimaEstimation<SarimaModel> rslt = monitor.optimize(this.model_, this.lastModel_);
            if (rslt == null) {
                throw new TramoException("Non convergence in ESPDIF");
            }
            this.lastModel_.setParameters(((SarimaModel)rslt.model.getArima()).getParameters());
            this.mlused_ = true;
        } else {
            this.mlused_ = false;
        }
        this.useml_ = false;
    }

    public boolean isUsingML() {
        return this.ml_;
    }

    private int maincondition() {
        double ar = this.lastModel_.phi(1);
        double ma = this.lastModel_.theta(1);
        double sar = 0.0;
        double sma = 0.0;
        if (this.seas_) {
            sar = this.lastModel_.bphi(1);
            sma = this.lastModel_.btheta(1);
        }
        this.c_ -= 0.002;
        this.din_ = 1.005 - this.ub2_;
        int icon = 0;
        if (Math.abs(ar + 1.0) <= this.din_) {
            if (-ar > 1.02) {
                icon = 1;
                this.useml_ = true;
            } else if (Math.abs(ar - ma) > this.c_) {
                ++icon;
                this.spec_.setD(this.spec_.getD() + 1);
            }
        } else if (Math.abs(ar) > 1.12) {
            icon = 1;
            this.useml_ = true;
        }
        if (this.seas_) {
            if (Math.abs(sar + 1.0) <= this.din_) {
                if (-sar > 1.02) {
                    this.useml_ = true;
                    icon = 1;
                } else if (this.spec_.getBD() == 0 && Math.abs(sar - sma) > this.c_) {
                    ++icon;
                    this.spec_.setBD(this.spec_.getBD() + 1);
                    if (this.useml_) {
                        --icon;
                        this.useml_ = false;
                    }
                }
            } else if (Math.abs(sar) > 1.12) {
                icon = 1;
                this.useml_ = true;
            }
        }
        return icon;
    }

    private boolean nextstep() {
        this.initstep(false);
        int icon = this.maincondition();
        if (this.iter_ == 0) {
            icon = this.cond1(icon);
        }
        return this.finalcond(icon) != 0;
    }

    @Override
    public ProcessingResult process(ModellingContext context) {
        try {
            int freq = context.description.getFrequency();
            this.seas_ = context.hasseas;
            if (!DifferencingModule.comespd(freq, context.description.getEstimationDomain().getLength(), this.seas_)) {
                return ProcessingResult.Unprocessed;
            }
            if (context.estimation == null) {
                return ProcessingResult.Failed;
            }
            int xcount = context.estimation.getRegArima().getXCount();
            int xout = context.description.getOutliers().size();
            DataBlock res = context.estimation.getCorrectedData(xcount - xout, xcount);
            SarimaSpecification nspec = context.description.getSpecification();
            this.process(res, freq, nspec.getD(), nspec.getBD());
            int nd = this.spec_.getD();
            int nbd = this.spec_.getBD();
            boolean changed = false;
            boolean nmean = this.isMeanCorrection();
            if (nspec.getD() != nd || nspec.getBD() != nbd) {
                changed = true;
                SarimaSpecification cspec = new SarimaSpecification(freq);
                cspec.setD(nd);
                cspec.setBD(nbd);
                context.description.setSpecification(cspec);
                context.estimation = null;
            }
            if (nmean != context.description.isEstimatedMean()) {
                changed = true;
                context.description.setMean(nmean);
                context.estimation = null;
            }
            this.addDifferencingInfo(context, nd, nbd, nmean);
            return changed ? ProcessingResult.Changed : ProcessingResult.Unchanged;
        }
        catch (RuntimeException err) {
            context.description.setAirline(context.hasseas);
            context.estimation = null;
            return ProcessingResult.Failed;
        }
    }

    @Override
    public void process(IReadDataBlock data, int freq, int d, int bd) {
        this.clear();
        this.data_ = new DataBlock(data);
        this.spec_.setFrequency(freq);
        this.spec_.setD(d);
        this.spec_.setBD(bd);
        this.calc();
    }

    private int searchur(Complex[] r, double val, boolean regular) {
        if (r == null) {
            return 0;
        }
        int n = 0;
        double vmax = 0.0;
        for (int i = 0; i < r.length; ++i) {
            double cdim = Math.abs(r[i].getIm());
            double vcur = r[i].abs();
            if (vcur >= val && cdim <= 0.05 && r[i].getRe() > 0.0) {
                ++n;
                continue;
            }
            if (!(cdim <= 0.02) || !(r[i].getRe() > 0.0) || !(vcur > vmax)) continue;
            vmax = vcur;
        }
        if (regular) {
            this.rmax_ = vmax;
        } else {
            this.rsmax_ = vmax;
        }
        return n;
    }

    public void setCancel(double value) {
        this.cancel_ = value;
        this.clear();
    }

    public void setUB1(double value) {
        this.ub1_ = value;
        this.clear();
    }

    public void setUB2(double value) {
        this.ub2_ = value;
        this.clear();
    }

    private void step0() {
        this.initstep(true);
        if (this.spec_.getD() != 0 || this.spec_.getBD() != 0) {
            this.rmax_ = this.lastModel_.phi(1);
            if (this.seas_) {
                this.rsmax_ = this.lastModel_.bphi(1);
            }
        }
        Complex[] rar = this.lastModel_.getRegularAR().mirror().roots();
        this.spec_.setD(this.spec_.getD() + this.searchur(rar, this.ub1_, true));
        if (this.seas_) {
            Complex[] rsar = this.lastModel_.getSeasonalAR().mirror().roots();
            this.spec_.setBD(this.spec_.getBD() + this.searchur(rsar, this.ub1_, false));
        }
    }

    public void useML(boolean value) {
        this.ml_ = value;
        this.clear();
    }

    private void computeTMean() {
        DataBlock res = null;
        if (this.spec_.getD() == 0 && this.spec_.getBD() == 0) {
            res = this.data_;
        } else {
            if (this.lastModel_ == null) {
                throw new TramoException("Failure in the identification of the differencing oreders");
            }
            SarimaMapping.stabilize(this.lastModel_);
            ArmaKF kf = new ArmaKF(this.lastModel_);
            BackFilter D = this.getDifferencingFilter();
            res = new DataBlock(this.data_.getLength() - D.getDegree());
            D.filter(this.data_, res);
            res = kf.fastFilter(res);
        }
        double s = res.sum();
        double s2 = res.ssq();
        int n = res.getLength();
        this.tmean_ = s / Math.sqrt((s2 * (double)n - s * s) / (double)n);
    }

    private void addDifferencingInfo(ModellingContext context, int d, int bd, boolean mean) {
    }

    @Override
    public void setLimits(int maxd, int maxbd) {
        this.maxd = maxd;
        this.maxbd = maxbd;
    }
}

