/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.visualization;

import java.awt.Color;
import java.awt.Graphics;
import moa.evaluation.MeasureCollection;
import moa.gui.visualization.AbstractGraphPlot;

public class GraphMultiCurve
extends AbstractGraphPlot {
    private static final long serialVersionUID = 1L;

    protected void setGraph(MeasureCollection[] measures, MeasureCollection[] measureStds, int[] processFrequencies, Color[] colors) {
        super.setGraph(measures, measureStds, colors);
    }

    protected void setProcessFrequency(int min_processFrequency) {
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.measures == null) {
            return;
        }
        for (int i = 0; i < this.measures.length; ++i) {
            this.paintFullCurve(g, i);
        }
    }

    private void paintFullCurve(Graphics g, int i) {
        if (this.measures[i].getNumberOfValues(this.measureSelected) == 0) {
            return;
        }
        g.setColor(this.colors[i]);
        int height = this.getHeight();
        int n = this.measures[i].getNumberOfValues(this.measureSelected);
        int[] x = new int[n];
        int[] y = new int[n];
        for (int j = 0; j < n; ++j) {
            x[j] = (int)((double)j * this.x_resolution);
            y[j] = (int)((double)height - this.measures[i].getValue(this.measureSelected, j) / this.upper_y_value * (double)height);
            if (!this.isStandardDeviationPainted) continue;
            int len = (int)(this.measureStds[i].getValue(this.measureSelected, j) / this.upper_y_value * (double)height);
            this.paintStandardDeviation(g, len, x[j], y[j]);
        }
        g.drawPolyline(x, y, n);
    }
}

