/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.sat;

import gnu.trove.list.TIntList;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import org.chocosolver.sat.Dimacs;
import org.chocosolver.sat.SatFactory;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.IntHeap;

public class MiniSat
implements SatFactory,
Dimacs {
    private static final int varUndef = -1;
    private static final int litUndef = -2;
    static final Clause CR_Undef = new Clause(new int[0]);
    static final VarData VD_Undef = new VarData(CR_Undef, -1);
    public boolean ok_ = true;
    public final ArrayList<Clause> clauses = new ArrayList();
    private final ArrayList<Clause> learnts = new ArrayList();
    private final TIntObjectHashMap<ArrayList<Watcher>> watches_ = new TIntObjectHashMap();
    List<Boolean> assignment_ = new ArrayList<Boolean>();
    TIntArrayList trail_ = new TIntArrayList();
    TIntArrayList trail_markers_ = new TIntArrayList();
    int qhead_ = 0;
    int num_vars_ = 0;
    int ccmin_mode = 1;
    int phase_saving = 2;
    double cla_inc = 1.0;
    double var_inc = 1.0;
    double var_decay = 0.95;
    double clause_decay = 0.999;
    double random_var_freq = 0.0;
    int restart_inc = 2;
    boolean rnd_init_act = true;
    boolean luby_restart = true;
    int restart_first = 100;
    int random_seed = 7;
    double learntsize_adjust_confl = 100.0;
    int learntsize_adjust_cnt = 100;
    double learntsize_adjust_inc = 1.5;
    double learntsize_inc = 1.1;
    double learntsize_factor = 0.3333333333333333;
    boolean rnd_pol;
    int conflict_budget = -1;
    int propagation_budget = -1;
    int propagations;
    int rnd_decisions;
    boolean asynch_interrupt = false;
    ArrayList<Boolean> model = new ArrayList();
    TIntArrayList conflict = new TIntArrayList();
    ArrayList<VarData> vardata = new ArrayList();
    int conflicts;
    int decisions;
    int max_literals;
    int tot_literals;
    int dec_vars;
    int clauses_literals;
    int learnts_literals;
    double max_learnts;
    BitSet seen = new BitSet();
    BitSet decision = new BitSet();
    BitSet polarity = new BitSet();
    TIntArrayList analyze_toclear = new TIntArrayList();
    TDoubleArrayList activity = new TDoubleArrayList();
    IntHeap order_heap = new IntHeap((a2, b) -> this.activity.get(a2) > this.activity.get(b));
    Random rand;
    private final TIntArrayList temporary_add_vector_ = new TIntArrayList();
    public TIntArrayList touched_variables_ = new TIntArrayList();

    protected MiniSat() {
        this.rand = new Random(this.random_seed);
        this.assignment_.add(Boolean.lUndef);
    }

    @Override
    public MiniSat _me() {
        return this;
    }

    public int newVariable() {
        int v = this.incrementVariableCounter();
        this.assignment_.add(v, Boolean.lUndef);
        this.vardata.add(new VarData(CR_Undef, 0));
        this.activity.add(this.rnd_init_act ? this.rand.nextDouble() * 1.0E-5 : 0.0);
        this.seen.clear(v);
        this.polarity.set(v);
        if (!this.decision.get(v)) {
            ++this.dec_vars;
        }
        this.decision.set(v);
        this.insertVarOrder(v);
        return v;
    }

    private void insertVarOrder(int v) {
        if (!this.order_heap.contains(v) && this.decision.get(v)) {
            this.order_heap.insert(v);
        }
    }

    public boolean addClause(TIntList ps) {
        assert (0 == this.trailMarker());
        if (!this.ok_) {
            return false;
        }
        ps.sort();
        int lit = -2;
        int j = 0;
        for (int i = 0; i < ps.size(); ++i) {
            if (this.valueLit(ps.get(i)) == Boolean.lTrue || ps.get(i) == MiniSat.neg(lit)) {
                return true;
            }
            if (this.valueLit(ps.get(i)) == Boolean.lFalse || ps.get(i) == lit) continue;
            lit = ps.get(i);
            ps.set(j++, lit);
        }
        if (j < ps.size()) {
            ps.remove(j, ps.size() - j);
        }
        switch (ps.size()) {
            case 0: {
                this.ok_ = false;
                return false;
            }
            case 1: {
                this.uncheckedEnqueue(ps.get(0));
                this.ok_ = this.propagate() == CR_Undef;
                return this.ok_;
            }
        }
        Clause cr = new Clause(ps.toArray());
        this.clauses.add(cr);
        this.attachClause(cr);
        return true;
    }

    public boolean addClause(int l) {
        this.temporary_add_vector_.resetQuick();
        this.temporary_add_vector_.add(l);
        return this.addClause(this.temporary_add_vector_);
    }

    public boolean addClause(int p, int q) {
        this.temporary_add_vector_.resetQuick();
        this.temporary_add_vector_.add(p);
        this.temporary_add_vector_.add(q);
        return this.addClause(this.temporary_add_vector_);
    }

    public boolean addClause(int p, int q, int r) {
        this.temporary_add_vector_.resetQuick();
        this.temporary_add_vector_.add(p);
        this.temporary_add_vector_.add(q);
        this.temporary_add_vector_.add(r);
        return this.addClause(this.temporary_add_vector_);
    }

    boolean initPropagator() {
        this.touched_variables_.resetQuick();
        return !this.ok_;
    }

    void cancelUntil(int level) {
        if (this.trailMarker() > level) {
            for (int c = this.trail_.size() - 1; c >= this.trail_markers_.get(level); --c) {
                int x = MiniSat.var(this.trail_.get(c));
                this.assignment_.set(x, Boolean.lUndef);
                if (this.phase_saving > 1 || this.phase_saving == 1 && c > this.trail_markers_.get(this.trail_markers_.size() - 1)) {
                    this.polarity.set(x, MiniSat.sgn(this.trail_.get(c)));
                }
                this.insertVarOrder(x);
            }
            this.qhead_ = this.trail_markers_.get(level);
            this.trail_.remove(this.trail_markers_.get(level), this.trail_.size() - this.trail_markers_.get(level));
            this.trail_markers_.remove(level, this.trail_markers_.size() - level);
        }
    }

    int trailMarker() {
        return this.trail_markers_.size();
    }

    Boolean valueVar(int x) {
        return this.assignment_.get(x);
    }

    Boolean valueLit(int l) {
        Boolean b = this.assignment_.get(MiniSat.var(l));
        return b == Boolean.lUndef ? Boolean.lUndef : MiniSat.xor(b, MiniSat.sgn(l));
    }

    int nClauses() {
        return this.clauses.size();
    }

    private int incrementVariableCounter() {
        return this.num_vars_++;
    }

    int nVars() {
        return this.num_vars_;
    }

    void pushTrailMarker() {
        this.trail_markers_.add(this.trail_.size());
    }

    void uncheckedEnqueue(int l, Clause from) {
        assert (this.valueLit(l) == Boolean.lUndef);
        if (this.assignment_.get(MiniSat.var(l)) == Boolean.lUndef) {
            this.touched_variables_.add(l);
        }
        this.assignment_.set(MiniSat.var(l), MiniSat.makeBoolean(MiniSat.sgn(l)));
        while (this.vardata.size() < MiniSat.var(l)) {
            this.vardata.add(VD_Undef);
        }
        this.vardata.set(MiniSat.var(l), new VarData(from, this.trailMarker()));
        this.trail_.add(l);
    }

    void uncheckedEnqueue(int l) {
        this.uncheckedEnqueue(l, CR_Undef);
    }

    void attachClause(Clause cr) {
        ArrayList<Watcher> l1;
        assert (cr.size() > 1);
        ArrayList<Watcher> l0 = this.watches_.get(MiniSat.neg(cr._g(0)));
        if (l0 == null) {
            l0 = new ArrayList();
            this.watches_.put(MiniSat.neg(cr._g(0)), l0);
        }
        if ((l1 = this.watches_.get(MiniSat.neg(cr._g(1)))) == null) {
            l1 = new ArrayList();
            this.watches_.put(MiniSat.neg(cr._g(1)), l1);
        }
        l0.add(new Watcher(cr, cr._g(1)));
        l1.add(new Watcher(cr, cr._g(0)));
        if (cr.learnt()) {
            this.learnts_literals += cr.size();
        } else {
            this.clauses_literals += cr.size();
        }
    }

    void detachClause(Clause cr) {
        int i;
        ArrayList<Watcher> ws = this.watches_.get(MiniSat.neg(cr._g(0)));
        for (i = ws.size() - 1; i >= 0 && ws.get((int)i).clause != cr; --i) {
        }
        assert (i > -1);
        ws.remove(i);
        ws = this.watches_.get(MiniSat.neg(cr._g(1)));
        for (i = ws.size() - 1; i >= 0 && ws.get((int)i).clause != cr; --i) {
        }
        assert (i > -1);
        ws.remove(i);
    }

    Clause propagate() {
        Clause confl = CR_Undef;
        int num_props = 0;
        while (this.qhead_ < this.trail_.size()) {
            int p = this.trail_.get(this.qhead_++);
            ArrayList<Watcher> ws = this.watches_.get(p);
            ++num_props;
            int i = 0;
            int j = 0;
            while (ws != null && i < ws.size()) {
                int blocker = ws.get((int)i).blocker;
                if (this.valueLit(blocker) == Boolean.lTrue) {
                    ws.set(j++, ws.get(i++));
                    continue;
                }
                Clause cr = ws.get((int)i).clause;
                int false_lit = MiniSat.neg(p);
                if (cr._g(0) == false_lit) {
                    cr._s(0, cr._g(1));
                    cr._s(1, false_lit);
                }
                assert (cr._g(1) == false_lit);
                ++i;
                int first = cr._g(0);
                Watcher w = new Watcher(cr, first);
                if (first != blocker && this.valueLit(first) == Boolean.lTrue) {
                    ws.set(j++, w);
                    continue;
                }
                boolean cont = false;
                for (int k = 2; k < cr.size(); ++k) {
                    if (this.valueLit(cr._g(k)) == Boolean.lFalse) continue;
                    cr._s(1, cr._g(k));
                    cr._s(k, false_lit);
                    ArrayList<Watcher> lw = this.watches_.get(MiniSat.neg(cr._g(1)));
                    if (lw == null) {
                        lw = new ArrayList();
                        this.watches_.put(MiniSat.neg(cr._g(1)), lw);
                    }
                    lw.add(w);
                    cont = true;
                    break;
                }
                if (cont) continue;
                ws.set(j++, w);
                if (this.valueLit(first) == Boolean.lFalse) {
                    confl = cr;
                    this.qhead_ = this.trail_.size();
                    while (i < ws.size()) {
                        ws.set(j++, ws.get(i++));
                    }
                    this.touched_variables_.add(first);
                    continue;
                }
                this.uncheckedEnqueue(first, cr);
            }
            if (ws == null || ws.size() <= j) continue;
            ws.subList(j, ws.size()).clear();
        }
        this.propagations += num_props;
        return confl;
    }

    public ESat solve() {
        this.model.clear();
        this.conflict.clear();
        if (!this.ok_) {
            return ESat.FALSE;
        }
        this.max_learnts = (double)this.nClauses() * this.learntsize_factor;
        this.learntsize_adjust_confl = 100.0;
        this.learntsize_adjust_cnt = (int)this.learntsize_adjust_confl;
        ESat status = ESat.UNDEFINED;
        int curr_restarts = 0;
        while (status == ESat.UNDEFINED) {
            double rest_base = this.luby_restart ? MiniSat.luby(this.restart_inc, curr_restarts) : Math.pow(this.restart_inc, curr_restarts);
            status = this.search((int)(rest_base * (double)this.restart_first));
            if (!this.withinBudget()) break;
            ++curr_restarts;
        }
        if (status == ESat.TRUE) {
            this.model.ensureCapacity(this.nVars());
            for (int i = 0; i < this.nVars(); ++i) {
                this.model.add(this.valueLit(i));
            }
        } else if (status == ESat.FALSE && this.conflict.size() == 0) {
            this.ok_ = false;
        }
        this.cancelUntil(0);
        if (status == ESat.TRUE) {
            System.out.print("SAT\n");
            for (int i = 0; i < this.nVars(); ++i) {
                if (this.model.get(i) == Boolean.lUndef) continue;
                System.out.printf("%s%s%d", i == 0 ? "" : " ", this.model.get(i) == Boolean.lTrue ? "" : "-", i + 1);
            }
            System.out.print(" 0\n");
        } else if (status == ESat.FALSE) {
            System.out.print("UNSAT\n");
        } else {
            System.out.print("INDET\n");
        }
        return status;
    }

    ESat search(int nof_conflicts) {
        assert (this.ok_);
        int conflictC = 0;
        TIntArrayList learnt_clause = new TIntArrayList();
        while (true) {
            Clause confl;
            if ((confl = this.propagate()) != CR_Undef) {
                ++this.conflicts;
                ++conflictC;
                if (this.trailMarker() == 0) {
                    return ESat.FALSE;
                }
                learnt_clause.clear();
                int backtrack_level = this.analyze(confl, learnt_clause);
                this.cancelUntil(backtrack_level);
                for (int v = 0; v < this.nVars(); ++v) {
                    assert (this.valueVar(v) != Boolean.lUndef || this.order_heap.contains(v)) : v + " not heaped";
                }
                if (learnt_clause.size() == 1) {
                    this.uncheckedEnqueue(learnt_clause.get(0));
                } else {
                    Clause cr = new Clause(learnt_clause.toArray(), true);
                    this.learnts.add(cr);
                    this.attachClause(cr);
                    this.claBumpActivity(cr);
                    this.uncheckedEnqueue(learnt_clause.get(0), cr);
                }
                this.varDecayActivity();
                this.claDecayActivity();
                if (--this.learntsize_adjust_cnt != 0) continue;
                this.learntsize_adjust_confl *= this.learntsize_adjust_inc;
                this.learntsize_adjust_cnt = (int)this.learntsize_adjust_confl;
                this.max_learnts *= this.learntsize_inc;
                continue;
            }
            if (nof_conflicts >= 0 && conflictC >= nof_conflicts || !this.withinBudget()) {
                this.cancelUntil(0);
                return ESat.UNDEFINED;
            }
            if (this.trailMarker() == 0 && !this.simplify()) {
                return ESat.FALSE;
            }
            if ((double)(this.learnts.size() - this.trail_.size()) >= this.max_learnts) {
                this.reduceDB();
            }
            ++this.decisions;
            int next = this.pickBranchLit();
            if (next == -2) {
                return ESat.TRUE;
            }
            this.pushTrailMarker();
            this.uncheckedEnqueue(next, CR_Undef);
        }
    }

    int pickBranchLit() {
        int next = -1;
        if (this.rand.nextDouble() < this.random_var_freq && !this.order_heap.isEmpty() && this.valueVar(next = this.order_heap.get(this.rand.nextInt(this.order_heap.size()))) == Boolean.lUndef && this.decision.get(next)) {
            ++this.rnd_decisions;
        }
        while (next == -1 || this.valueVar(next) != Boolean.lUndef || !this.decision.get(next)) {
            if (this.order_heap.isEmpty()) {
                next = -1;
                break;
            }
            next = this.order_heap.removeMin();
        }
        return next == -1 ? -2 : MiniSat.makeLiteral(next, this.rnd_pol ? this.rand.nextDouble() < 0.5 : this.polarity.get(next));
    }

    int analyze(Clause confl, TIntList out_learnt) {
        int out_btlevel;
        int j;
        int pathC = 0;
        int p = -2;
        out_learnt.add(-2);
        int index = this.trail_.size() - 1;
        do {
            assert (confl != CR_Undef);
            Clause c = confl;
            if (c.learnt()) {
                this.claBumpActivity(c);
            }
            int n = j = p == -2 ? 0 : 1;
            while (j < c.size()) {
                int q = c._g(j);
                if (!this.seen.get(MiniSat.var(q)) && this.level(MiniSat.var(q)) > 0) {
                    this.varBumpActivity(MiniSat.var(q));
                    this.seen.set(MiniSat.var(q));
                    if (this.level(MiniSat.var(q)) >= this.trailMarker()) {
                        ++pathC;
                    } else {
                        out_learnt.add(q);
                    }
                }
                ++j;
            }
            while (!this.seen.get(MiniSat.var(this.trail_.get(index--)))) {
            }
            p = this.trail_.get(index + 1);
            confl = this.reason(MiniSat.var(p));
            this.seen.clear(MiniSat.var(p));
        } while (--pathC > 0);
        out_learnt.set(0, MiniSat.neg(p));
        this.analyze_toclear.clear();
        this.analyze_toclear.addAll(out_learnt);
        if (this.ccmin_mode == 1) {
            j = 1;
            block3: for (int i = 1; i < out_learnt.size(); ++i) {
                int x = MiniSat.var(out_learnt.get(i));
                if (this.reason(x) == CR_Undef) {
                    out_learnt.set(j++, out_learnt.get(i));
                    continue;
                }
                Clause c = this.reason(MiniSat.var(out_learnt.get(i)));
                for (int k = 1; k < c.size(); ++k) {
                    if (this.seen.get(MiniSat.var(c._g(k))) || this.level(MiniSat.var(c._g(k))) <= 0) continue;
                    out_learnt.set(j++, out_learnt.get(i));
                    continue block3;
                }
            }
        } else {
            j = out_learnt.size();
        }
        this.max_literals += out_learnt.size();
        out_learnt.subList(j, out_learnt.size()).clear();
        this.tot_literals += out_learnt.size();
        if (out_learnt.size() == 1) {
            out_btlevel = 0;
        } else {
            int max_i = 1;
            for (int i = 2; i < out_learnt.size(); ++i) {
                if (this.level(MiniSat.var(out_learnt.get(i))) <= this.level(MiniSat.var(out_learnt.get(max_i)))) continue;
                max_i = i;
            }
            p = out_learnt.get(max_i);
            out_learnt.set(max_i, out_learnt.get(1));
            out_learnt.set(1, p);
            out_btlevel = this.level(MiniSat.var(p));
        }
        for (j = 0; j < this.analyze_toclear.size(); ++j) {
            this.seen.clear(MiniSat.var(this.analyze_toclear.get(j)));
        }
        return out_btlevel;
    }

    boolean simplify() {
        assert (this.trailMarker() == 0);
        if (!this.ok_ || this.propagate() != CR_Undef) {
            this.ok_ = false;
            return false;
        }
        this.rebuildOrderHeap();
        return true;
    }

    private void rebuildOrderHeap() {
        TIntArrayList vs = new TIntArrayList();
        for (int v = 0; v < this.nVars(); ++v) {
            if (!this.decision.get(v) || this.valueVar(v) != Boolean.lUndef) continue;
            vs.add(v);
        }
        this.order_heap.build(vs);
    }

    void reduceDB() {
        double extra_lim = this.cla_inc / (double)this.learnts.size();
        this.learnts.sort(Comparator.comparingDouble(c -> ((Clause)c).activity));
        int j = 0;
        for (int i = 0; i < this.learnts.size(); ++i) {
            Clause c2 = this.learnts.get(i);
            if (c2.size() > 2 && !this.locked(c2) && (i < this.learnts.size() / 2 || c2.activity < extra_lim)) {
                this.removeClause(this.learnts.get(i));
                continue;
            }
            this.learnts.set(j++, this.learnts.get(i));
        }
        this.learnts.subList(j, this.learnts.size()).clear();
    }

    boolean withinBudget() {
        return !(this.asynch_interrupt || this.conflict_budget >= 0 && this.conflicts >= this.conflict_budget || this.propagation_budget >= 0 && this.propagations >= this.propagation_budget);
    }

    Clause reason(int x) {
        return this.vardata.get((int)x).cr;
    }

    int level(int x) {
        return this.vardata.get((int)x).level;
    }

    boolean locked(Clause c) {
        return this.valueLit(c._g(0)) == Boolean.lTrue && this.reason(MiniSat.var(c._g(0))) != CR_Undef && this.reason(MiniSat.var(c._g(0))) == c;
    }

    void removeClause(Clause cr) {
        this.detachClause(cr);
        if (this.locked(cr)) {
            this.vardata.get((int)MiniSat.var((int)cr._g((int)0))).cr = CR_Undef;
        }
    }

    void claBumpActivity(Clause c) {
        if ((c.activity += this.cla_inc) > 1.0E20) {
            for (int i = 0; i < this.learnts.size(); ++i) {
                this.learnts.get(i).activity *= 1.0E-20;
            }
            this.cla_inc *= 1.0E-20;
        }
    }

    void varBumpActivity(int v) {
        this.varBumpActivity(v, this.var_inc);
    }

    void varBumpActivity(int v, double inc) {
        this.activity.ensureCapacity(this.nVars());
        double a2 = this.activity.get(v);
        this.activity.setQuick(v, a2 + inc);
        if (a2 + inc > 1.0E100) {
            for (int i = 0; i < this.nVars(); ++i) {
                this.activity.transformValues(value -> value * 1.0E-100);
            }
            this.var_inc *= 1.0E-100;
        }
        if (this.order_heap.contains(v)) {
            this.order_heap.decrease(v);
        }
    }

    void varDecayActivity() {
        this.var_inc *= 1.0 / this.var_decay;
    }

    void claDecayActivity() {
        this.cla_inc *= 1.0 / this.clause_decay;
    }

    private static double luby(double y, int x) {
        int size = 1;
        int seq = 0;
        while (size < x + 1) {
            ++seq;
            size = 2 * size + 1;
        }
        while (size - 1 != x) {
            size = size - 1 >> 1;
            --seq;
            x %= size;
        }
        return Math.pow(y, seq);
    }

    public static int makeLiteral(int var, boolean sign) {
        return 2 * var + (sign ? 1 : 0);
    }

    public static int makeLiteral(int var) {
        return MiniSat.makeLiteral(var, true);
    }

    public static int neg(int l) {
        return l ^ 1;
    }

    public static boolean sgn(int l) {
        return (l & 1) != 0;
    }

    public static int var(int l) {
        return l >> 1;
    }

    static Boolean makeBoolean(boolean b) {
        return b ? Boolean.lTrue : Boolean.lFalse;
    }

    private static Boolean xor(Boolean a2, boolean b) {
        return Boolean.make((byte)(a2.value() ^ (b ? (byte)1 : 0)));
    }

    static class VarData {
        Clause cr;
        int level;

        public VarData(Clause cr, int level) {
            this.cr = cr;
            this.level = level;
        }
    }

    public static enum Boolean {
        lTrue(0),
        lFalse(1),
        lUndef(2);

        byte value;

        private Boolean(byte value) {
            this.value = value;
        }

        public byte value() {
            return this.value;
        }

        public static Boolean make(byte b) {
            if (b == 1) {
                return lTrue;
            }
            if (b == 0) {
                return lFalse;
            }
            return lUndef;
        }
    }

    static class Watcher {
        Clause clause;
        int blocker;

        Watcher(Clause cr, int l) {
            this.clause = cr;
            this.blocker = l;
        }
    }

    public static class Clause {
        private final int[] literals_;
        private final boolean learnt;
        private double activity;

        Clause(int[] ps, boolean learnt) {
            this.literals_ = (int[])ps.clone();
            this.learnt = learnt;
        }

        Clause(int[] ps) {
            this(ps, false);
        }

        public int size() {
            return this.literals_.length;
        }

        public boolean learnt() {
            return this.learnt;
        }

        public int _g(int i) {
            return this.literals_[i];
        }

        void _s(int pos, int l) {
            this.literals_[pos] = l;
        }

        public String toString() {
            return Arrays.toString(this.literals_);
        }
    }
}

