/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model.visitors;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.dmg.pmml.PMMLObject;
import org.jpmml.model.ReflectionUtil;
import org.jpmml.model.visitors.AbstractVisitor;

public abstract class Interner<V>
extends AbstractVisitor {
    private Class<? extends V> type = null;

    public Interner(Class<? extends V> type) {
        this.setType(type);
    }

    public abstract V intern(V var1);

    public Class<? extends V> getType() {
        return this.type;
    }

    private void setType(Class<? extends V> type) {
        this.type = Objects.requireNonNull(type);
    }

    protected void apply(Field field, PMMLObject object) {
        Object value;
        Class<V> type = this.getType();
        Class<V> fieldType = field.getType();
        if (Objects.equals(List.class, fieldType)) {
            List values;
            ParameterizedType listType = (ParameterizedType)field.getGenericType();
            Type[] typeArguments = listType.getActualTypeArguments();
            if (typeArguments.length != 1) {
                throw new IllegalArgumentException();
            }
            Class listElementType = (Class)typeArguments[0];
            if (listElementType.isAssignableFrom(type) && (values = (List)ReflectionUtil.getFieldValue(field, object)) != null && !values.isEmpty()) {
                ListIterator it = values.listIterator();
                while (it.hasNext()) {
                    Object value2 = it.next();
                    if (!type.isInstance(value2)) continue;
                    Object internedValue = this.intern(value2);
                    it.set(internedValue);
                }
            }
            return;
        }
        if (fieldType.isAssignableFrom(type) && (value = ReflectionUtil.getFieldValue(field, object)) != null && type.isInstance(value)) {
            V internedValue = this.intern(type.cast(value));
            ReflectionUtil.setFieldValue(field, object, internedValue);
        }
    }
}

