/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.utilities;

import java.util.Comparator;
import keel.Algorithms.Instance_Generation.Basic.Prototype;

public class Distance
implements Comparator<Prototype> {
    protected static Prototype basePrototype = null;
    protected static int numberOfInputs = 0;

    public static void setNumberOfInputs(int _n) {
        numberOfInputs = _n;
    }

    public void setPrototypeToCompare(Prototype p) {
        basePrototype = p;
    }

    public Distance(Prototype p) {
        basePrototype = p;
    }

    public static double squaredEuclideanDistance(Prototype one, Prototype two) {
        double[] oneInputs = one.getInputs();
        double[] twoInputs = two.getInputs();
        double acc = 0.0;
        for (int i = 0; i < numberOfInputs; ++i) {
            acc += (oneInputs[i] - twoInputs[i]) * (oneInputs[i] - twoInputs[i]);
        }
        return acc;
    }

    public static double dSquared(Prototype one, Prototype two) {
        return Distance.squaredEuclideanDistance(one, two);
    }

    public static double d(Prototype one, Prototype two) {
        return Math.sqrt(Distance.squaredEuclideanDistance(one, two));
    }

    public static double euclideanDistance(Prototype one, Prototype two) {
        return Distance.d(one, two);
    }

    public static double distance(Prototype one, Prototype two) {
        return Distance.d(one, two);
    }

    public static double absoluteDistance(Prototype one, Prototype two) {
        double[] oneInputs = one.getInputs();
        double[] twoInputs = two.getInputs();
        double acc = 0.0;
        for (int i = 0; i < numberOfInputs; ++i) {
            acc += Math.abs(oneInputs[i] - twoInputs[i]);
        }
        return acc;
    }

    @Override
    public int compare(Prototype one, Prototype two) {
        double two_d;
        double one_d = Distance.d(basePrototype, one);
        if (one_d > (two_d = Distance.d(basePrototype, two))) {
            return 1;
        }
        if (one_d == two_d) {
            return 0;
        }
        return -1;
    }
}

