/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.Basic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerationAlgorithm;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.utilities.Distance;
import keel.Algorithms.Instance_Generation.utilities.KNN.KNN;
import keel.Algorithms.Instance_Generation.utilities.KeelFile;
import keel.Algorithms.Instance_Generation.utilities.Pair;
import keel.Algorithms.Instance_Generation.utilities.Parameters;
import keel.Algorithms.Instance_Generation.utilities.RandomGenerator;
import org.core.Randomize;

public class PrototypeGenerator {
    protected PrototypeSet trainingDataSet;
    protected PrototypeSet generatedDataSet = null;
    protected String algorithmName = "1NN";
    public static long SEED = 7161592756342978231L;
    public final long[] seedDefaultValueList = new long[]{7161592756342978231L, 4132097864321L, 1498764321724L, 897043219780L, 24397804321L};
    private long _time = 0L;

    private void startTimer() {
        this._time = System.nanoTime();
    }

    private long stopTimer() {
        this._time = System.nanoTime() - this._time;
        return this._time;
    }

    public static void setSeed(long _seed) {
        SEED = _seed;
        RandomGenerator.setSeed(_seed);
    }

    public static long getSeed() {
        return SEED;
    }

    public long getTime() {
        return this._time;
    }

    protected int getSetSizeFromPercentage(double percentage) {
        return PrototypeGenerator.getSetSizeFromPercentage(this.trainingDataSet, percentage);
    }

    protected static int getSetSizeFromPercentage(PrototypeSet set, double percentage) {
        int size = (int)Math.floor((double)set.size() * percentage / 100.0);
        return size;
    }

    public PrototypeSet selecRandomSet(int numberOfPrototypesSelected, boolean usePriorProb) {
        if (usePriorProb && numberOfPrototypesSelected != this.trainingDataSet.size()) {
            int numberOfInstances_1 = this.trainingDataSet.size() - 1;
            int _size = this.trainingDataSet.size();
            double prop = (double)numberOfPrototypesSelected / (double)_size;
            PrototypeSet edited = new PrototypeSet();
            HashMap<Double, Integer> sizeOfPartition = this.trainingDataSet.countPrototypesOfEachOutput();
            ArrayList<Double> values = Prototype.possibleValuesOfOutput();
            for (double class_i : values) {
                int n_class_i = (int)Math.floor(prop * (double)sizeOfPartition.get(class_i).intValue());
                HashSet<Integer> forbidden = new HashSet<Integer>();
                for (int k = 0; k < n_class_i; ++k) {
                    int chosen;
                    while (forbidden.contains(chosen = RandomGenerator.Randint(0, numberOfInstances_1)) || ((Prototype)this.trainingDataSet.get(chosen)).firstOutput() != class_i) {
                    }
                    forbidden.add(chosen);
                    edited.add(this.trainingDataSet.get(chosen));
                }
            }
            HashSet<Integer> forbidden = new HashSet<Integer>();
            while (edited.size() < numberOfPrototypesSelected) {
                int chosen;
                while (forbidden.contains(chosen = RandomGenerator.Randint(0, numberOfInstances_1)) || edited.contains(this.trainingDataSet.get(chosen))) {
                }
                forbidden.add(chosen);
                edited.add(this.trainingDataSet.get(chosen));
            }
            return edited;
        }
        PrototypeSet edited = new PrototypeSet(numberOfPrototypesSelected);
        RandomGenerator.generateDifferentRandomIntegers(0, this.trainingDataSet.size());
        ArrayList<Integer> indexes = RandomGenerator.generateDifferentRandomIntegers(0, this.trainingDataSet.size() - 1);
        for (int i = 0; i < numberOfPrototypesSelected; ++i) {
            edited.add(this.trainingDataSet.get(indexes.get(i)));
        }
        return edited;
    }

    public PrototypeSet reduceSet() {
        return this.trainingDataSet.copy();
    }

    public final PrototypeSet execute() {
        this.startTimer();
        PrototypeSet resultSet = this.reduceSet();
        this.stopTimer();
        this.generatedDataSet = resultSet;
        resultSet.applyThresholds();
        return resultSet;
    }

    public PrototypeSet generateReducedDataSet() {
        return this.execute();
    }

    public PrototypeGenerator(PrototypeSet _trainingDataSet) {
        this.trainingDataSet = _trainingDataSet;
        Distance.setNumberOfInputs(((Prototype)_trainingDataSet.get(0)).numberOfInputs());
        PrototypeGenerator.setSeed(SEED);
    }

    public PrototypeGenerator(PrototypeSet _trainingDataSet, int seedIndex) {
        this.trainingDataSet = _trainingDataSet;
        Distance.setNumberOfInputs(((Prototype)_trainingDataSet.get(0)).numberOfInputs());
        PrototypeGenerator.setSeed(this.seedDefaultValueList[seedIndex %= this.seedDefaultValueList.length]);
    }

    public PrototypeGenerator(PrototypeSet _trainingDataSet, Parameters parameters) {
        this.trainingDataSet = _trainingDataSet;
        Distance.setNumberOfInputs(((Prototype)_trainingDataSet.get(0)).numberOfInputs());
        PrototypeGenerator.setSeed(parameters.getNextAsInt());
    }

    protected static int absoluteAccuracy(PrototypeSet condensed, PrototypeSet test) {
        int accuracy1NN = KNN.classficationAccuracy1NN(condensed, test);
        return accuracy1NN;
    }

    protected static int absoluteAccuracyKNN(PrototypeSet condensed, PrototypeSet test, int k) {
        int accuracy1NN = KNN.classficationAccuracy(condensed, test, k);
        return accuracy1NN;
    }

    protected static double accuracy(PrototypeSet condensed, PrototypeSet test) {
        double absAccuracy = PrototypeGenerator.absoluteAccuracy(condensed, test);
        return 100.0 * (absAccuracy / (double)test.size());
    }

    public double accuracy2(PrototypeSet condensed, PrototypeSet test) {
        double absAccuracy = PrototypeGenerator.absoluteAccuracy(condensed, test);
        return 100.0 * (absAccuracy / (double)test.size());
    }

    protected static Pair<Integer, Integer> absoluteAccuracyAndError(PrototypeSet condensed, PrototypeSet test) {
        return KNN.classficationAccuracyAndError1NN(condensed, test);
    }

    public void showResultsOfAccuracy(int accuracyKNN, int accuracy1NN, int k, PrototypeSet test) {
        double test_size = test.size();
        double training_size = this.trainingDataSet.size();
        double generated_size = this.generatedDataSet.size();
        double porc_aciertosKNN = (double)accuracyKNN / test_size * 100.0;
        double porc_aciertos1NN = (double)accuracy1NN / test_size * 100.0;
        double porc_reduction = 100.0 - generated_size / training_size * 100.0;
        System.out.println("-------------------------------------------------");
        System.out.println("RESULTS (using " + k + "NN classifier):");
        System.out.println("Aciertos usando reducido: " + accuracyKNN + " de " + test_size + " prototipos (" + porc_aciertosKNN + "%)");
        System.out.println("Reducci\u00c3\u00b3n: " + generated_size + " de " + training_size + " prototipos (" + porc_reduction + "%)");
        System.out.println("-------------------------------------------------");
        System.out.println("RESULTS (using 1NN classifier):");
        System.out.println("Aciertos usando reducido: " + accuracy1NN + " de " + test_size + " prototipos (" + porc_aciertos1NN + "%)");
        System.out.println("Reducci\u00c3\u00b3n: " + generated_size + " de " + training_size + " prototipos (" + porc_reduction + "%)");
        System.out.println("-------------------------------------------------");
    }

    public String getResultsOfAccuracy(String name, int accuracy1NN, PrototypeSet test) {
        double test_size = test.size();
        double training_size = this.trainingDataSet.size();
        double generated_size = this.generatedDataSet.size();
        double porc_aciertos1NN = (double)accuracy1NN / test_size * 100.0;
        double porc_reduction = 100.0 - generated_size / training_size * 100.0;
        String out = "";
        out = out + "-------------------------------------------------\n";
        out = out + "RESULTADOS DE REDUCIR " + name + " usando " + this.algorithmName + ":\n";
        out = out + "Reduccion: " + porc_reduction + "% (" + generated_size + " de " + training_size + " prototipos)\n";
        out = out + "ACIERTOS: " + porc_aciertos1NN + "% (" + accuracy1NN + " de " + test_size + " prototipos)\n";
        out = out + "-------------------------------------------------\n";
        return out;
    }

    public String getResults(String name, String algoName, int accuracy1NN, int training_size, PrototypeSet test) {
        double test_size = test.size();
        double generated_size = this.generatedDataSet.size();
        double porc_aciertos1NN = (double)accuracy1NN / test_size * 100.0;
        double porc_reduction = 100.0 - generated_size / (double)training_size * 100.0;
        String out = "";
        out = out + "-------------------------------------------------\n";
        out = out + "RESULTS OF REDUCED DATA " + name + " using " + algoName + ":\n";
        out = out + "REDUCTION: " + porc_reduction + "% (" + generated_size + " of " + training_size + " prototypes)\n";
        out = out + "ACCURACY: " + porc_aciertos1NN + "% (" + accuracy1NN + " of " + test_size + " prototypes)\n";
        out = out + "-------------------------------------------------\n";
        return out;
    }

    public String getResultingAccuracy(String name, String algoName, int accuracy1NN, PrototypeSet test) {
        double test_size = test.size();
        double porc_aciertos1NN = (double)accuracy1NN / test_size * 100.0;
        String out = "";
        out = out + "-------------------------------------------------\n";
        out = out + "RESULTS OF REDUCED DATA " + name + " USING " + algoName + ":\n";
        out = out + "ACCURACY: " + porc_aciertos1NN + "% (" + accuracy1NN + " of " + test_size + " prototypes)\n";
        out = out + "-------------------------------------------------\n";
        return out;
    }

    public String getResultingAccuracy(String name, int accuracy1NN, PrototypeSet test) {
        return this.getResultingAccuracy(name, this.algorithmName, accuracy1NN, test);
    }

    public void showResultsOfAccuracy(String name, int accuracy1NN, PrototypeSet test) {
        System.out.print(this.getResultsOfAccuracy(name, accuracy1NN, test));
    }

    public void saveResultsOfAccuracyIn(String name, int accuracy1NN, PrototypeSet test, String fileName) {
        String data = this.getResultsOfAccuracy(name, accuracy1NN, test);
        KeelFile.write(fileName, data);
    }

    public static String getResultsOfAccuracy(String name, String algorithmUsed, PrototypeSet reduced, PrototypeSet test) {
        int accuracy1NN = KNN.classficationAccuracy1NN(reduced, test);
        System.err.println("accuracy1NN: " + accuracy1NN);
        double test_size = test.size();
        double porc_aciertos1NN = (double)accuracy1NN / test_size * 100.0;
        System.err.println("porcAciertos: " + porc_aciertos1NN);
        String out = "";
        out = out + "-------------------------------------------------\n";
        out = out + "RESULTADOS DE BONDAD DEL CONJUNTO " + name + " GENERADO MEDIANTE " + algorithmUsed + ":\n";
        out = out + "ACIERTOS: " + porc_aciertos1NN + "% (" + accuracy1NN + " de " + test_size + " prototipos)\n";
        out = out + "-------------------------------------------------\n";
        return out;
    }

    public static void saveResultsOfAccuracyIn(String name, String algorithmUsed, PrototypeSet reduced, PrototypeSet test, String fileName, boolean append) {
        String data = PrototypeGenerator.getResultsOfAccuracy(name, algorithmUsed, reduced, test);
        if (append) {
            KeelFile.append(fileName, data);
        } else {
            KeelFile.write(fileName, data);
        }
    }

    public void inic_vector(int[] vector) {
        for (int i = 0; i < vector.length; ++i) {
            vector[i] = i;
        }
    }

    public void inic_vector_sin(int[] vector, int without) {
        for (int i = 0; i < vector.length; ++i) {
            if (i == without) continue;
            vector[i] = i;
        }
    }

    public void desordenar_vector_sin(int[] vector) {
        for (int i = 0; i < vector.length - 1; ++i) {
            int pos = Randomize.Randint(0, vector.length - 1);
            int tmp = vector[i];
            vector[i] = vector[pos];
            vector[pos] = tmp;
        }
    }

    public void desordenar_vector(int[] vector) {
        for (int i = 0; i < vector.length; ++i) {
            int pos = Randomize.Randint(0, vector.length - 1);
            int tmp = vector[i];
            vector[i] = vector[pos];
            vector[pos] = tmp;
        }
    }

    public static void main(String[] args) {
        Parameters.setUse("PrototypeGenerator", "");
        Parameters.assertBasicArgs(args);
        PrototypeSet training = PrototypeGenerationAlgorithm.readPrototypeSet(args[0]);
        PrototypeSet test = PrototypeGenerationAlgorithm.readPrototypeSet(args[1]);
        PrototypeGenerator generator = new PrototypeGenerator(training);
        ArrayList<Double> p = Prototype.possibleValuesOfOutput();
        PrototypeSet resultingSet = generator.execute();
        int accuracy1NN = KNN.classficationAccuracy1NN(resultingSet, test);
        generator.showResultsOfAccuracy(Parameters.getFileName(), accuracy1NN, test);
    }
}

