/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core;

import keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core.Antd;
import keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core.AttributeWeka;
import keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core.Instance;
import keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core.Instances;
import keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core.Utils;

public class NumericAntd
extends Antd {
    static final long serialVersionUID = 5699457269983735442L;
    public double splitPoint = Double.NaN;
    public double supportBound = Double.NaN;
    public boolean fuzzyYet = false;

    public NumericAntd(AttributeWeka a) {
        super(a);
    }

    public double getSplitPoint() {
        return this.splitPoint;
    }

    @Override
    public Object copy() {
        NumericAntd na = new NumericAntd(this.getAttr());
        na.m_confidence = this.m_confidence;
        na.value = this.value;
        na.splitPoint = this.splitPoint;
        na.supportBound = this.supportBound;
        na.fuzzyYet = this.fuzzyYet;
        return na;
    }

    @Override
    public Instances[] splitData(Instances insts, double defAcRt, double cl) {
        Instance inst;
        Instances data = insts;
        int total = data.numInstances();
        int split = 1;
        int prev = 0;
        int finalSplit = split;
        this.maxInfoGain = 0.0;
        this.value = 0.0;
        double fstCover = 0.0;
        double sndCover = 0.0;
        double fstAccu = 0.0;
        double sndAccu = 0.0;
        data.sort(this.att);
        for (int x = 0; x < data.numInstances(); ++x) {
            inst = data.instance(x);
            if (inst.isMissing(this.att)) {
                total = x;
                break;
            }
            sndCover += inst.weight();
            if (!Utils.eq(inst.classValue(), cl)) continue;
            sndAccu += inst.weight();
        }
        if (total == 0) {
            return null;
        }
        this.splitPoint = data.instance(total - 1).value(this.att);
        while (split <= total) {
            if (split == total || data.instance(split).value(this.att) > data.instance(prev).value(this.att)) {
                double coverage;
                double accurate;
                double accRate;
                double infoGain;
                boolean isFirst;
                double sndInfoGain;
                for (int y = prev; y < split; ++y) {
                    inst = data.instance(y);
                    fstCover += inst.weight();
                    if (!Utils.eq(data.instance(y).classValue(), cl)) continue;
                    fstAccu += inst.weight();
                }
                double fstAccuRate = (fstAccu + 1.0) / (fstCover + 1.0);
                double sndAccuRate = (sndAccu + 1.0) / (sndCover + 1.0);
                double fstInfoGain = fstAccu * (Utils.log2(fstAccuRate) - Utils.log2(defAcRt));
                if (fstInfoGain > (sndInfoGain = sndAccu * (Utils.log2(sndAccuRate) - Utils.log2(defAcRt)))) {
                    isFirst = true;
                    infoGain = fstInfoGain;
                    accRate = fstAccuRate;
                    accurate = fstAccu;
                    coverage = fstCover;
                } else {
                    isFirst = false;
                    infoGain = sndInfoGain;
                    accRate = sndAccuRate;
                    accurate = sndAccu;
                    coverage = sndCover;
                }
                if (infoGain > this.maxInfoGain) {
                    this.splitPoint = data.instance(prev).value(this.att);
                    this.value = isFirst ? 0.0 : 1.0;
                    this.accuRate = accRate;
                    this.accu = accurate;
                    this.cover = coverage;
                    this.maxInfoGain = infoGain;
                    finalSplit = isFirst ? split : prev;
                }
                for (int y = prev; y < split; ++y) {
                    Instance inst2 = data.instance(y);
                    sndCover -= inst2.weight();
                    if (!Utils.eq(data.instance(y).classValue(), cl)) continue;
                    sndAccu -= inst2.weight();
                }
                prev = split;
            }
            ++split;
        }
        Instances[] splitData = new Instances[]{new Instances(data, 0, finalSplit), new Instances(data, finalSplit, total - finalSplit)};
        return splitData;
    }

    @Override
    public double covers(Instance inst) {
        double isCover = 0.0;
        if (!inst.isMissing(this.att)) {
            if ((int)this.value == 0) {
                if (inst.value(this.att) <= this.splitPoint) {
                    isCover = 1.0;
                } else if (this.fuzzyYet && inst.value(this.att) > this.splitPoint && inst.value(this.att) < this.supportBound) {
                    isCover = 1.0 - (inst.value(this.att) - this.splitPoint) / (this.supportBound - this.splitPoint);
                }
            } else if (inst.value(this.att) >= this.splitPoint) {
                isCover = 1.0;
            } else if (this.fuzzyYet && inst.value(this.att) < this.splitPoint && inst.value(this.att) > this.supportBound) {
                isCover = 1.0 - (this.splitPoint - inst.value(this.att)) / (this.splitPoint - this.supportBound);
            }
        }
        return isCover;
    }

    @Override
    public String toString() {
        String symbol;
        String string = symbol = (int)this.value == 0 ? " <= " : " >= ";
        if (this.fuzzyYet) {
            return this.att.name() + symbol + Utils.doubleToString(this.splitPoint, 6) + "(-> " + Utils.doubleToString(this.supportBound, 6) + ")";
        }
        return this.att.name() + symbol + Utils.doubleToString(this.splitPoint, 6);
    }
}

