/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Preprocess.NoiseFilters.SaturationFilter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Vector;
import keel.Algorithms.Genetic_Rule_Learning.Globals.FileManagement;
import keel.Algorithms.Preprocess.NoiseFilters.SaturationFilter.IntegerSet;
import keel.Algorithms.Preprocess.NoiseFilters.SaturationFilter.Literals;
import keel.Algorithms.Preprocess.NoiseFilters.SaturationFilter.Parameters;
import keel.Algorithms.Preprocess.NoiseFilters.SaturationFilter.pnPair;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import keel.Dataset.Instance;
import keel.Dataset.InstanceSet;
import org.core.Randomize;

public class SaturationFilter {
    private boolean[][] literals;
    private int numlit;
    private Instance[] instancesTrain;
    private Vector noisyInstances;

    public SaturationFilter() {
        Randomize.setSeed(Parameters.seed);
        InstanceSet is = new InstanceSet();
        try {
            is.readSet(Parameters.trainInputFile, true);
        }
        catch (Exception e) {
            System.exit(1);
        }
        this.instancesTrain = is.getInstances();
        Parameters.numClasses = Attributes.getOutputAttributes()[0].getNumNominalValues();
        Parameters.numAttributes = Attributes.getInputAttributes().length;
        Parameters.numInstances = this.instancesTrain.length;
    }

    public void run() {
        boolean[] noisyIns = new boolean[Parameters.numInstances];
        Arrays.fill(noisyIns, false);
        for (int posClass = 0; posClass < Parameters.numClasses; ++posClass) {
            System.out.println("\n\n\n-----> POSITIVE CLASS = " + posClass);
            Literals lit = new Literals(this.instancesTrain, posClass);
            this.numlit = lit.getNumLiterals();
            this.literals = lit.getLiteralsMatrix();
            boolean[] partialNoise = this.saturationFilter(posClass);
            for (int i = 0; i < Parameters.numInstances; ++i) {
                if (!partialNoise[i]) continue;
                noisyIns[i] = true;
            }
        }
        this.noisyInstances = new Vector();
        for (int i = 0; i < Parameters.numInstances; ++i) {
            if (!noisyIns[i]) continue;
            this.noisyInstances.add(i);
        }
        System.out.println("Numero de ejemplos eliminados = " + this.noisyInstances.size());
        System.out.println(this.noisyInstances);
        this.createDatasets(Parameters.trainInputFile, Parameters.trainOutputFile, Parameters.testInputFile, Parameters.testOutputFile);
    }

    public boolean[] saturationFilter(int positiveClass) {
        boolean salir = false;
        double[] We = new double[Parameters.numInstances];
        IntegerSet E = new IntegerSet(Parameters.numInstances);
        for (int i = 0; i < Parameters.numInstances; ++i) {
            E.addValue(i);
        }
        boolean[] hasNoise = new boolean[Parameters.numInstances];
        Arrays.fill(hasNoise, false);
        while (E.size() > 0 && !salir) {
            E.print();
            Arrays.fill(We, 0.0);
            Vector<pnPair> U = pnPair.getPNpairs(E, this.instancesTrain, positiveClass);
            if (U.size() == 0) break;
            for (int i = 0; i < U.size(); ++i) {
                int num = U.get(i).numliteralCovers(this.literals, this.numlit);
                if (num != 0) continue;
                E.removeValue(U.get(i).getPosEx());
                E.removeValue(U.get(i).getNegEx());
            }
            U = pnPair.getPNpairs(E, this.instancesTrain, positiveClass);
            Vector<Integer> L = this.minimalCov(positiveClass, U);
            for (int lt = 0; lt < L.size(); ++lt) {
                IntegerSet Pe = new IntegerSet(Parameters.numInstances);
                IntegerSet Ne = new IntegerSet(Parameters.numInstances);
                for (int pn = 0; pn < U.size(); ++pn) {
                    if (!U.get(pn).onlyOneLiteral(this.literals, L, L.get(lt))) continue;
                    Pe.addValue(U.get(pn).getPosEx());
                    Ne.addValue(U.get(pn).getNegEx());
                }
                if (Pe.size() == 0) {
                    L.remove(lt);
                    --lt;
                    continue;
                }
                for (int p = 0; p < Pe.size(); ++p) {
                    int n = Pe.getElement(p);
                    We[n] = We[n] + 1.0 / (double)Pe.size();
                }
                for (int n = 0; n < Ne.size(); ++n) {
                    int n2 = Ne.getElement(n);
                    We[n2] = We[n2] + 1.0 / (double)Ne.size();
                }
            }
            int indexSelected = 0;
            double max = We[0];
            for (int i = 1; i < Parameters.numInstances; ++i) {
                if (!(We[i] > max)) continue;
                indexSelected = i;
                max = We[i];
            }
            if (max > Parameters.noiseSensitivity) {
                hasNoise[indexSelected] = true;
                E.removeValue(indexSelected);
                continue;
            }
            salir = true;
        }
        return hasNoise;
    }

    public Vector<Integer> minimalCov(int positiveClass, Vector<pnPair> U) {
        Vector<Integer> mL = new Vector<Integer>();
        for (int i = 0; i < U.size(); ++i) {
            int num = U.get(i).numliteralCovers(this.literals, this.numlit);
            U.get(i).setWeight(1.0 / (double)num);
        }
        Vector<pnPair> Uaux = new Vector<pnPair>();
        for (int i = 0; i < U.size(); ++i) {
            Uaux.add(U.get(i));
        }
        while (Uaux.size() > 0) {
            int i;
            int pos = 0;
            double max = ((pnPair)Uaux.get(0)).getWeight();
            for (int i2 = 1; i2 < Uaux.size(); ++i2) {
                if (!(((pnPair)Uaux.get(i2)).getWeight() > max)) continue;
                pos = i2;
                max = ((pnPair)Uaux.get(i2)).getWeight();
            }
            Vector<Integer> Laux = ((pnPair)Uaux.get(pos)).indexLiterals(this.literals, this.numlit);
            double[] wlit = new double[Laux.size()];
            for (i = 0; i < Laux.size(); ++i) {
                wlit[i] = this.sumOfWeights(Laux.get(i), Uaux);
            }
            pos = 0;
            max = wlit[0];
            for (i = 1; i < Laux.size(); ++i) {
                if (!(wlit[i] > max)) continue;
                pos = i;
                max = wlit[i];
            }
            mL.add(Laux.get(pos));
            this.remove(Laux.get(pos), Uaux);
        }
        return mL;
    }

    public void remove(int indexLit, Vector<pnPair> Uaux) {
        for (int i = 0; i < Uaux.size(); ++i) {
            if (!Uaux.get(i).isCovered(this.literals, indexLit)) continue;
            Uaux.remove(i);
            --i;
        }
    }

    public double sumOfWeights(int indexLit, Vector<pnPair> Uaux) {
        double res = 0.0;
        for (int i = 0; i < Uaux.size(); ++i) {
            if (!Uaux.get(i).isCovered(this.literals, indexLit)) continue;
            res += Uaux.get(i).getWeight();
        }
        return res;
    }

    public void createDatasets(String trainIN, String trainOUT, String testIN, String testOUT) {
        String header = "";
        header = "@relation " + Attributes.getRelationName() + "\n";
        header = header + Attributes.getInputAttributesHeader();
        header = header + Attributes.getOutputAttributesHeader();
        header = header + Attributes.getInputHeader() + "\n";
        header = header + Attributes.getOutputHeader() + "\n";
        header = header + "@data\n";
        FileManagement fm = new FileManagement();
        Attribute[] att = Attributes.getInputAttributes();
        try {
            fm.initWrite(trainOUT);
            fm.writeLine(header);
            int numNoisyEx = 0;
            for (int i = 0; i < this.instancesTrain.length; ++i) {
                if (numNoisyEx < this.noisyInstances.size() && (Integer)this.noisyInstances.get(numNoisyEx) == i) {
                    ++numNoisyEx;
                    continue;
                }
                boolean[] missing = this.instancesTrain[i].getInputMissingValues();
                String newInstance = "";
                for (int j = 0; j < Parameters.numAttributes; ++j) {
                    if (missing[j]) {
                        newInstance = newInstance + "?";
                    } else {
                        if (att[j].getType() == 2) {
                            newInstance = newInstance + this.instancesTrain[i].getInputRealValues(j);
                        }
                        if (att[j].getType() == 1) {
                            newInstance = newInstance + (int)this.instancesTrain[i].getInputRealValues(j);
                        }
                        if (att[j].getType() == 0) {
                            newInstance = newInstance + this.instancesTrain[i].getInputNominalValues(j);
                        }
                    }
                    newInstance = newInstance + ", ";
                }
                String className = this.instancesTrain[i].getOutputNominalValues(0);
                newInstance = newInstance + className + "\n";
                fm.writeLine(newInstance);
            }
            fm.closeWrite();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        try {
            String s;
            File Archi1 = new File(testIN);
            File Archi2 = new File(testOUT);
            BufferedReader in = new BufferedReader(new FileReader(Archi1));
            PrintWriter out = new PrintWriter(new FileWriter(Archi2));
            while ((s = in.readLine()) != null) {
                out.println(s);
            }
            in.close();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

