/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.base;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jclec.IIndividual;
import net.sourceforge.jclec.ISystem;
import net.sourceforge.jclec.base.DecoratedMutator;
import net.sourceforge.jclec.util.random.IRandGen;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.builder.EqualsBuilder;

public class FilteredMutator
extends DecoratedMutator {
    private static final long serialVersionUID = 6949238978074907056L;
    protected double mutProb;
    protected IRandGen randgen;
    protected transient List<IIndividual> fertile = new ArrayList<IIndividual>();
    protected transient List<IIndividual> sterile = new ArrayList<IIndividual>();

    public FilteredMutator() {
    }

    public FilteredMutator(ISystem context) {
        this.contextualize(context);
    }

    public final double getMutProb() {
        return this.mutProb;
    }

    public final void setMutProb(double mutProb) {
        this.mutProb = mutProb;
    }

    @Override
    public void contextualize(ISystem context) {
        super.contextualize(context);
        this.randgen = context.createRandGen();
    }

    @Override
    public List<IIndividual> mutate(List<IIndividual> parents) {
        this.fertile.clear();
        this.sterile.clear();
        for (IIndividual ind : parents) {
            if (this.randgen.coin(this.mutProb)) {
                this.fertile.add(ind);
                continue;
            }
            this.sterile.add(ind);
        }
        return this.decorated.mutate(this.fertile);
    }

    public List<IIndividual> getSterile() {
        return this.sterile;
    }

    public List<IIndividual> getFertile() {
        return this.fertile;
    }

    @Override
    public void configure(Configuration settings) {
        super.configure(settings);
        double mutProb = settings.getDouble("mutation-prob", 0.05);
        this.setMutProb(mutProb);
    }

    public boolean equals(Object other) {
        if (other instanceof FilteredMutator) {
            FilteredMutator o = (FilteredMutator)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.decorated, o.decorated);
            eb.append(this.mutProb, o.mutProb);
            return eb.isEquals();
        }
        return false;
    }
}

