/*
 * Decompiled with CFR 0.152.
 */
package keel.Dataset;

import java.util.Vector;
import keel.Dataset.Attribute;

public final class Attributes {
    static Vector attributes = new Vector();
    static Vector inputAttr = new Vector();
    static Vector outputAttr = new Vector();
    static Vector undefinedAttr = new Vector();
    static boolean hasNominal = false;
    static boolean hasInteger = false;
    static boolean hasReal = false;
    static boolean hasMissing = false;
    static String relationName;

    public static void clearAll() {
        attributes = new Vector();
        inputAttr = new Vector();
        outputAttr = new Vector();
        undefinedAttr = new Vector();
        hasNominal = false;
        hasInteger = false;
        hasReal = false;
        hasMissing = false;
        Object relationName = null;
    }

    static void addAttribute(Attribute attr) {
        attributes.addElement(attr);
        if (attr.getType() == 0) {
            hasNominal = true;
        }
        if (attr.getType() == 1) {
            hasInteger = true;
        }
        if (attr.getType() == 2) {
            hasReal = true;
        }
    }

    public static boolean hasNominalAttributes() {
        return hasNominal;
    }

    public static boolean hasIntegerAttributes() {
        return hasInteger;
    }

    public static boolean hasRealAttributes() {
        return hasReal;
    }

    public static boolean hasMissingValues() {
        return hasMissing;
    }

    public static Attribute getAttribute(String _name) {
        int i;
        for (i = 0; i < attributes.size() && !((Attribute)attributes.elementAt(i)).getName().equals(_name); ++i) {
        }
        if (i == attributes.size()) {
            return null;
        }
        return (Attribute)attributes.elementAt(i);
    }

    public static Attribute[] getAttributes() {
        if (attributes.size() == 0) {
            return null;
        }
        Attribute[] attr = new Attribute[attributes.size()];
        for (int i = 0; i < attr.length; ++i) {
            attr[i] = (Attribute)attributes.elementAt(i);
        }
        return attr;
    }

    public static Attribute getInputAttribute(int pos) {
        if (pos < 0 || pos >= inputAttr.size()) {
            return null;
        }
        return (Attribute)inputAttr.elementAt(pos);
    }

    public static Attribute[] getInputAttributes() {
        if (inputAttr.size() == 0) {
            return null;
        }
        Attribute[] attr = new Attribute[inputAttr.size()];
        for (int i = 0; i < attr.length; ++i) {
            attr[i] = (Attribute)inputAttr.elementAt(i);
        }
        return attr;
    }

    public static String getInputHeader() {
        String aux = "@inputs ";
        String ending = ",";
        for (int i = 0; i < inputAttr.size(); ++i) {
            if (i == inputAttr.size() - 1) {
                ending = "";
            }
            aux = aux + ((Attribute)inputAttr.elementAt(i)).getName() + ending;
        }
        return aux;
    }

    public static String getInputAttributesHeader() {
        String aux = "";
        for (int i = 0; i < inputAttr.size(); ++i) {
            aux = aux + ((Attribute)inputAttr.elementAt(i)).toString() + "\n";
        }
        return aux;
    }

    public static Attribute[] getOutputAttributes() {
        if (outputAttr.size() == 0) {
            return null;
        }
        Attribute[] attr = new Attribute[outputAttr.size()];
        for (int i = 0; i < attr.length; ++i) {
            attr[i] = (Attribute)outputAttr.elementAt(i);
        }
        return attr;
    }

    public static Attribute getOutputAttribute(int pos) {
        if (pos < 0 || pos >= outputAttr.size()) {
            return null;
        }
        return (Attribute)outputAttr.elementAt(pos);
    }

    public static String getOutputHeader() {
        String aux = "@outputs ";
        String ending = ",";
        for (int i = 0; i < outputAttr.size(); ++i) {
            if (i == outputAttr.size() - 1) {
                ending = "";
            }
            aux = aux + ((Attribute)outputAttr.elementAt(i)).getName() + ending;
        }
        return aux;
    }

    public static String getOutputAttributesHeader() {
        String aux = "";
        for (int i = 0; i < outputAttr.size(); ++i) {
            aux = aux + ((Attribute)outputAttr.elementAt(i)).toString() + "\n";
        }
        return aux;
    }

    public static Attribute getUndefinedAttribute(int pos) {
        if (pos < 0 || pos >= undefinedAttr.size()) {
            return null;
        }
        return (Attribute)undefinedAttr.elementAt(pos);
    }

    public static Attribute[] getUndefinedAttributes() {
        if (undefinedAttr.size() == 0) {
            return null;
        }
        Attribute[] attr = new Attribute[undefinedAttr.size()];
        for (int i = 0; i < attr.length; ++i) {
            attr[i] = (Attribute)undefinedAttr.elementAt(i);
        }
        return attr;
    }

    public static String getUndefinedAttributesHeader() {
        String aux = "";
        for (int i = 0; i < undefinedAttr.size(); ++i) {
            aux = aux + ((Attribute)undefinedAttr.elementAt(i)).toString() + "\n";
        }
        return aux;
    }

    public static Attribute getAttribute(int pos) {
        return (Attribute)attributes.elementAt(pos);
    }

    public static int getNumAttributes() {
        return attributes.size();
    }

    public static int getInputNumAttributes() {
        return inputAttr.size();
    }

    public static int getOutputNumAttributes() {
        return outputAttr.size();
    }

    public static int getUndefinedNumAttributes() {
        return undefinedAttr.size();
    }

    static Vector getAttributesExcept(Vector v) {
        Vector<String> restAt = new Vector<String>();
        for (int i = 0; i < attributes.size(); ++i) {
            String attName = ((Attribute)attributes.get(i)).getName();
            if (v.contains(attName)) continue;
            restAt.add(attName);
        }
        return restAt;
    }

    static void setOutputInputAttributes(Vector inAttNames, Vector outAttNames) {
        Attribute att;
        int i;
        for (i = 0; i < attributes.size(); ++i) {
            att = (Attribute)attributes.get(i);
            String attName = att.getName();
            if (inAttNames.contains(attName)) {
                att.setDirectionAttribute(1);
                inputAttr.add(attributes.get(i));
                continue;
            }
            if (outAttNames.contains(attName)) {
                att.setDirectionAttribute(2);
                outputAttr.add(attributes.get(i));
                continue;
            }
            undefinedAttr.add(attributes.get(i));
        }
        hasNominal = false;
        hasInteger = false;
        hasReal = false;
        for (int index = 0; index < 2; ++index) {
            int iterations = index == 0 ? inputAttr.size() : outputAttr.size();
            block7: for (i = 0; i < iterations; ++i) {
                att = index == 0 ? (Attribute)inputAttr.elementAt(i) : (Attribute)outputAttr.elementAt(i);
                switch (att.getType()) {
                    case 0: {
                        hasNominal = true;
                        continue block7;
                    }
                    case 1: {
                        hasInteger = true;
                        continue block7;
                    }
                    case 2: {
                        hasReal = true;
                    }
                }
            }
        }
    }

    static boolean areAllDefinedAsInputs(Vector inputNames) {
        if (inputNames.size() != inputAttr.size()) {
            return false;
        }
        for (int i = 0; i < inputAttr.size(); ++i) {
            if (inputNames.contains(((Attribute)inputAttr.elementAt(i)).getName())) continue;
            return false;
        }
        return true;
    }

    public static boolean areAllDefinedAsOutputs(Vector outputNames) {
        if (outputNames.size() != outputAttr.size()) {
            return false;
        }
        for (int i = 0; i < outputAttr.size(); ++i) {
            if (outputNames.contains(((Attribute)outputAttr.elementAt(i)).getName())) continue;
            return false;
        }
        return true;
    }

    public static void setRelationName(String rel) {
        relationName = rel;
    }

    public static String getRelationName() {
        return relationName;
    }

    public static boolean removeAttribute(boolean inputAtt, int whichAtt) {
        Attribute atToDel = null;
        if (inputAtt && (whichAtt >= inputAttr.size() || whichAtt < 0)) {
            return false;
        }
        if (!(inputAtt || whichAtt < outputAttr.size() && whichAtt >= 0)) {
            return false;
        }
        if (inputAtt) {
            atToDel = (Attribute)inputAttr.elementAt(whichAtt);
            atToDel.setDirectionAttribute(-1);
            inputAttr.removeElementAt(whichAtt);
        } else {
            atToDel = (Attribute)outputAttr.elementAt(whichAtt);
            atToDel.setDirectionAttribute(-1);
            outputAttr.removeElementAt(whichAtt);
        }
        int undefPosition = Attributes.searchUndefPosition(atToDel);
        undefinedAttr.insertElementAt(atToDel, undefPosition);
        hasNominal = false;
        hasInteger = false;
        hasReal = false;
        for (int index = 0; index < 2; ++index) {
            int iterations = index == 0 ? inputAttr.size() : outputAttr.size();
            block6: for (int i = 0; i < iterations; ++i) {
                Attribute att = index == 0 ? (Attribute)inputAttr.elementAt(i) : (Attribute)outputAttr.elementAt(i);
                switch (att.getType()) {
                    case 0: {
                        hasNominal = true;
                        continue block6;
                    }
                    case 1: {
                        hasInteger = true;
                        continue block6;
                    }
                    case 2: {
                        hasReal = true;
                    }
                }
            }
        }
        return true;
    }

    static int searchUndefPosition(Attribute attToDel) {
        int undefCount = 0;
        int count = 0;
        Attribute att_aux = (Attribute)attributes.elementAt(count);
        while (attToDel != att_aux) {
            if (att_aux.getDirectionAttribute() == -1) {
                ++undefCount;
            }
            att_aux = (Attribute)attributes.elementAt(++count);
        }
        return undefCount;
    }

    static void initStatistics() {
        if (outputAttr.size() != 1) {
            return;
        }
        int classNumber = ((Attribute)outputAttr.elementAt(0)).getNumNominalValues();
        if (classNumber <= 0) {
            return;
        }
        for (int i = 0; i < inputAttr.size(); ++i) {
            ((Attribute)inputAttr.elementAt(i)).initStatistics(classNumber);
        }
    }

    static void finishStatistics() {
        if (outputAttr.size() != 1) {
            return;
        }
        for (int i = 0; i < inputAttr.size(); ++i) {
            ((Attribute)inputAttr.elementAt(i)).finishStatistics();
        }
    }

    public static void print() {
        System.out.println("@relation = " + relationName);
        for (int i = 0; i < attributes.size(); ++i) {
            Attribute att = (Attribute)attributes.elementAt(i);
            if (att.getDirectionAttribute() == 1) {
                System.out.println("  > INPUT ATTRIBUTE:     ");
            } else if (att.getDirectionAttribute() == 2) {
                System.out.println("  > OUTPUT ATTRIBUTE:    ");
            } else {
                System.out.println("  > UNDEFINED ATTRIBUTE: ");
            }
            att.print();
        }
    }
}

