/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.quantity;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Acceleration;
import javax.measure.quantity.AmountOfSubstance;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Area;
import javax.measure.quantity.CatalyticActivity;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.ElectricCapacitance;
import javax.measure.quantity.ElectricCharge;
import javax.measure.quantity.ElectricConductance;
import javax.measure.quantity.ElectricCurrent;
import javax.measure.quantity.ElectricInductance;
import javax.measure.quantity.ElectricPotential;
import javax.measure.quantity.ElectricResistance;
import javax.measure.quantity.Energy;
import javax.measure.quantity.Force;
import javax.measure.quantity.Frequency;
import javax.measure.quantity.Illuminance;
import javax.measure.quantity.Length;
import javax.measure.quantity.LuminousFlux;
import javax.measure.quantity.LuminousIntensity;
import javax.measure.quantity.MagneticFlux;
import javax.measure.quantity.MagneticFluxDensity;
import javax.measure.quantity.Mass;
import javax.measure.quantity.Power;
import javax.measure.quantity.Pressure;
import javax.measure.quantity.RadiationDoseAbsorbed;
import javax.measure.quantity.RadiationDoseEffective;
import javax.measure.quantity.Radioactivity;
import javax.measure.quantity.SolidAngle;
import javax.measure.quantity.Speed;
import javax.measure.quantity.Temperature;
import javax.measure.quantity.Time;
import javax.measure.quantity.Volume;
import javax.measure.spi.QuantityFactory;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.quantity.Quantities;
import tech.units.indriya.unit.Units;

public class DefaultQuantityFactory<Q extends Quantity<Q>>
implements QuantityFactory<Q> {
    static final Map<Class, QuantityFactory> INSTANCES = new HashMap<Class, QuantityFactory>();
    static final Logger logger = Logger.getLogger(DefaultQuantityFactory.class.getName());
    static final Level LOG_LEVEL = Level.FINE;
    private final Class<Q> type;
    private final Unit<Q> systemUnit;
    private static final Map<Class, Unit> CLASS_TO_SYSTEM_UNIT = new ConcurrentHashMap<Class, Unit>();

    private DefaultQuantityFactory(Class<Q> quantity) {
        this.type = quantity;
        this.systemUnit = CLASS_TO_SYSTEM_UNIT.get(this.type);
    }

    public static <Q extends Quantity<Q>> QuantityFactory<Q> getInstance(Class<Q> type) {
        logger.log(LOG_LEVEL, "Type: " + type + ": " + type.isInterface());
        DefaultQuantityFactory<Q> factory = INSTANCES.get(type);
        if (factory != null) {
            return factory;
        }
        if (!Quantity.class.isAssignableFrom(type)) {
            throw new ClassCastException();
        }
        factory = new DefaultQuantityFactory<Q>(type);
        INSTANCES.put(type, factory);
        return factory;
    }

    public String toString() {
        return this.getClass().getName() + " <" + this.type.getName() + '>';
    }

    public boolean equals(Object obj) {
        if (DefaultQuantityFactory.class.isInstance(obj)) {
            DefaultQuantityFactory other = (DefaultQuantityFactory)DefaultQuantityFactory.class.cast(obj);
            return Objects.equals(this.type, other.type);
        }
        return false;
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    @Override
    public Quantity<Q> create(Number value, Unit<Q> unit) {
        return Quantities.getQuantity(value, unit);
    }

    @Override
    public Quantity<Q> create(Number value, Unit<Q> unit, Quantity.Scale sc) {
        return Quantities.getQuantity(value, unit, sc);
    }

    @Override
    public Unit<Q> getSystemUnit() {
        return this.systemUnit;
    }

    static {
        CLASS_TO_SYSTEM_UNIT.put(Dimensionless.class, AbstractUnit.ONE);
        CLASS_TO_SYSTEM_UNIT.put(ElectricCurrent.class, Units.AMPERE);
        CLASS_TO_SYSTEM_UNIT.put(LuminousIntensity.class, Units.CANDELA);
        CLASS_TO_SYSTEM_UNIT.put(Temperature.class, Units.KELVIN);
        CLASS_TO_SYSTEM_UNIT.put(Mass.class, Units.KILOGRAM);
        CLASS_TO_SYSTEM_UNIT.put(Length.class, Units.METRE);
        CLASS_TO_SYSTEM_UNIT.put(AmountOfSubstance.class, Units.MOLE);
        CLASS_TO_SYSTEM_UNIT.put(Time.class, Units.SECOND);
        CLASS_TO_SYSTEM_UNIT.put(Angle.class, Units.RADIAN);
        CLASS_TO_SYSTEM_UNIT.put(SolidAngle.class, Units.STERADIAN);
        CLASS_TO_SYSTEM_UNIT.put(Frequency.class, Units.HERTZ);
        CLASS_TO_SYSTEM_UNIT.put(Force.class, Units.NEWTON);
        CLASS_TO_SYSTEM_UNIT.put(Pressure.class, Units.PASCAL);
        CLASS_TO_SYSTEM_UNIT.put(Energy.class, Units.JOULE);
        CLASS_TO_SYSTEM_UNIT.put(Power.class, Units.WATT);
        CLASS_TO_SYSTEM_UNIT.put(ElectricCharge.class, Units.COULOMB);
        CLASS_TO_SYSTEM_UNIT.put(ElectricPotential.class, Units.VOLT);
        CLASS_TO_SYSTEM_UNIT.put(ElectricCapacitance.class, Units.FARAD);
        CLASS_TO_SYSTEM_UNIT.put(ElectricResistance.class, Units.OHM);
        CLASS_TO_SYSTEM_UNIT.put(ElectricConductance.class, Units.SIEMENS);
        CLASS_TO_SYSTEM_UNIT.put(MagneticFlux.class, Units.WEBER);
        CLASS_TO_SYSTEM_UNIT.put(MagneticFluxDensity.class, Units.TESLA);
        CLASS_TO_SYSTEM_UNIT.put(ElectricInductance.class, Units.HENRY);
        CLASS_TO_SYSTEM_UNIT.put(LuminousFlux.class, Units.LUMEN);
        CLASS_TO_SYSTEM_UNIT.put(Illuminance.class, Units.LUX);
        CLASS_TO_SYSTEM_UNIT.put(Radioactivity.class, Units.BECQUEREL);
        CLASS_TO_SYSTEM_UNIT.put(RadiationDoseAbsorbed.class, Units.GRAY);
        CLASS_TO_SYSTEM_UNIT.put(RadiationDoseEffective.class, Units.SIEVERT);
        CLASS_TO_SYSTEM_UNIT.put(CatalyticActivity.class, Units.KATAL);
        CLASS_TO_SYSTEM_UNIT.put(Speed.class, Units.METRE_PER_SECOND);
        CLASS_TO_SYSTEM_UNIT.put(Acceleration.class, Units.METRE_PER_SQUARE_SECOND);
        CLASS_TO_SYSTEM_UNIT.put(Area.class, Units.SQUARE_METRE);
        CLASS_TO_SYSTEM_UNIT.put(Volume.class, Units.CUBIC_METRE);
    }
}

