/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.triangulate;

import java.util.Collection;
import org.locationtech.jts.triangulate.quadedge.QuadEdge;
import org.locationtech.jts.triangulate.quadedge.QuadEdgeSubdivision;
import org.locationtech.jts.triangulate.quadedge.Vertex;

public class IncrementalDelaunayTriangulator {
    private QuadEdgeSubdivision subdiv;
    private boolean isUsingTolerance = false;

    public IncrementalDelaunayTriangulator(QuadEdgeSubdivision subdiv) {
        this.subdiv = subdiv;
        this.isUsingTolerance = subdiv.getTolerance() > 0.0;
    }

    public void insertSites(Collection vertices) {
        for (Vertex v : vertices) {
            this.insertSite(v);
        }
    }

    public QuadEdge insertSite(Vertex v) {
        QuadEdge e2 = this.subdiv.locate(v);
        if (this.subdiv.isVertexOfEdge(e2, v)) {
            return e2;
        }
        if (this.subdiv.isOnEdge(e2, v.getCoordinate())) {
            e2 = e2.oPrev();
            this.subdiv.delete(e2.oNext());
        }
        QuadEdge base = this.subdiv.makeEdge(e2.orig(), v);
        QuadEdge.splice(base, e2);
        QuadEdge startEdge = base;
        while ((e2 = (base = this.subdiv.connect(e2, base.sym())).oPrev()).lNext() != startEdge) {
        }
        while (true) {
            QuadEdge t;
            if ((t = e2.oPrev()).dest().rightOf(e2) && v.isInCircle(e2.orig(), t.dest(), e2.dest())) {
                QuadEdge.swap(e2);
                e2 = e2.oPrev();
                continue;
            }
            if (e2.oNext() == startEdge) {
                return base;
            }
            e2 = e2.oNext().lPrev();
        }
    }
}

