/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.valid;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geomgraph.DirectedEdge;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.EdgeRing;
import org.locationtech.jts.geomgraph.GeometryGraph;
import org.locationtech.jts.geomgraph.PlanarGraph;
import org.locationtech.jts.operation.overlay.MaximalEdgeRing;
import org.locationtech.jts.operation.overlay.OverlayNodeFactory;
import org.locationtech.jts.util.Assert;

public class ConnectedInteriorTester {
    private GeometryFactory geometryFactory = new GeometryFactory();
    private GeometryGraph geomGraph;
    private Coordinate disconnectedRingcoord;

    public static Coordinate findDifferentPoint(Coordinate[] coord, Coordinate pt) {
        for (int i = 0; i < coord.length; ++i) {
            if (coord[i].equals(pt)) continue;
            return coord[i];
        }
        return null;
    }

    public ConnectedInteriorTester(GeometryGraph geomGraph) {
        this.geomGraph = geomGraph;
    }

    public Coordinate getCoordinate() {
        return this.disconnectedRingcoord;
    }

    public boolean isInteriorsConnected() {
        ArrayList splitEdges = new ArrayList();
        this.geomGraph.computeSplitEdges(splitEdges);
        PlanarGraph graph = new PlanarGraph(new OverlayNodeFactory());
        graph.addEdges(splitEdges);
        this.setInteriorEdgesInResult(graph);
        graph.linkResultDirectedEdges();
        List edgeRings = this.buildEdgeRings(graph.getEdgeEnds());
        this.visitShellInteriors(this.geomGraph.getGeometry(), graph);
        return !this.hasUnvisitedShellEdge(edgeRings);
    }

    private void setInteriorEdgesInResult(PlanarGraph graph) {
        for (DirectedEdge de : graph.getEdgeEnds()) {
            if (de.getLabel().getLocation(0, 2) != 0) continue;
            de.setInResult(true);
        }
    }

    private List buildEdgeRings(Collection dirEdges) {
        ArrayList edgeRings = new ArrayList();
        for (DirectedEdge de : dirEdges) {
            if (!de.isInResult() || de.getEdgeRing() != null) continue;
            MaximalEdgeRing er = new MaximalEdgeRing(de, this.geometryFactory);
            er.linkDirectedEdgesForMinimalEdgeRings();
            List minEdgeRings = er.buildMinimalRings();
            edgeRings.addAll(minEdgeRings);
        }
        return edgeRings;
    }

    private void visitShellInteriors(Geometry g2, PlanarGraph graph) {
        if (g2 instanceof Polygon) {
            Polygon p = (Polygon)g2;
            this.visitInteriorRing(p.getExteriorRing(), graph);
        }
        if (g2 instanceof MultiPolygon) {
            MultiPolygon mp = (MultiPolygon)g2;
            for (int i = 0; i < mp.getNumGeometries(); ++i) {
                Polygon p = (Polygon)mp.getGeometryN(i);
                this.visitInteriorRing(p.getExteriorRing(), graph);
            }
        }
    }

    private void visitInteriorRing(LineString ring, PlanarGraph graph) {
        if (ring.isEmpty()) {
            return;
        }
        Coordinate[] pts = ring.getCoordinates();
        Coordinate pt0 = pts[0];
        Coordinate pt1 = ConnectedInteriorTester.findDifferentPoint(pts, pt0);
        Edge e2 = graph.findEdgeInSameDirection(pt0, pt1);
        DirectedEdge de = (DirectedEdge)graph.findEdgeEnd(e2);
        DirectedEdge intDe = null;
        if (de.getLabel().getLocation(0, 2) == 0) {
            intDe = de;
        } else if (de.getSym().getLabel().getLocation(0, 2) == 0) {
            intDe = de.getSym();
        }
        Assert.isTrue(intDe != null, "unable to find dirEdge with Interior on RHS");
        this.visitLinkedDirectedEdges(intDe);
    }

    protected void visitLinkedDirectedEdges(DirectedEdge start) {
        DirectedEdge startDe = start;
        DirectedEdge de = start;
        do {
            Assert.isTrue(de != null, "found null Directed Edge");
            de.setVisited(true);
        } while ((de = de.getNext()) != startDe);
    }

    private boolean hasUnvisitedShellEdge(List edgeRings) {
        for (int i = 0; i < edgeRings.size(); ++i) {
            List edges;
            DirectedEdge de;
            EdgeRing er = (EdgeRing)edgeRings.get(i);
            if (er.isHole() || (de = (DirectedEdge)(edges = er.getEdges()).get(0)).getLabel().getLocation(0, 2) != 0) continue;
            for (int j = 0; j < edges.size(); ++j) {
                de = (DirectedEdge)edges.get(j);
                if (de.isVisited()) continue;
                this.disconnectedRingcoord = de.getCoordinate();
                return true;
            }
        }
        return false;
    }
}

