/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geomgraph;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.locationtech.jts.algorithm.BoundaryNodeRule;
import org.locationtech.jts.algorithm.locate.SimplePointInAreaLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.geomgraph.EdgeEnd;
import org.locationtech.jts.geomgraph.GeometryGraph;
import org.locationtech.jts.geomgraph.Label;
import org.locationtech.jts.util.Assert;

public abstract class EdgeEndStar {
    protected Map edgeMap = new TreeMap();
    protected List edgeList;
    private int[] ptInAreaLocation = new int[]{-1, -1};

    public abstract void insert(EdgeEnd var1);

    protected void insertEdgeEnd(EdgeEnd e2, Object obj) {
        this.edgeMap.put(e2, obj);
        this.edgeList = null;
    }

    public Coordinate getCoordinate() {
        Iterator it = this.iterator();
        if (!it.hasNext()) {
            return null;
        }
        EdgeEnd e2 = (EdgeEnd)it.next();
        return e2.getCoordinate();
    }

    public int getDegree() {
        return this.edgeMap.size();
    }

    public Iterator iterator() {
        return this.getEdges().iterator();
    }

    public List getEdges() {
        if (this.edgeList == null) {
            this.edgeList = new ArrayList(this.edgeMap.values());
        }
        return this.edgeList;
    }

    public EdgeEnd getNextCW(EdgeEnd ee) {
        this.getEdges();
        int i = this.edgeList.indexOf(ee);
        int iNextCW = i - 1;
        if (i == 0) {
            iNextCW = this.edgeList.size() - 1;
        }
        return (EdgeEnd)this.edgeList.get(iNextCW);
    }

    public void computeLabelling(GeometryGraph[] geomGraph) {
        int geomi;
        Label label;
        EdgeEnd e2;
        this.computeEdgeEndLabels(geomGraph[0].getBoundaryNodeRule());
        this.propagateSideLabels(0);
        this.propagateSideLabels(1);
        boolean[] hasDimensionalCollapseEdge = new boolean[]{false, false};
        Iterator it = this.iterator();
        while (it.hasNext()) {
            e2 = (EdgeEnd)it.next();
            label = e2.getLabel();
            for (geomi = 0; geomi < 2; ++geomi) {
                if (!label.isLine(geomi) || label.getLocation(geomi) != 1) continue;
                hasDimensionalCollapseEdge[geomi] = true;
            }
        }
        it = this.iterator();
        while (it.hasNext()) {
            e2 = (EdgeEnd)it.next();
            label = e2.getLabel();
            for (geomi = 0; geomi < 2; ++geomi) {
                if (!label.isAnyNull(geomi)) continue;
                int loc = -1;
                if (hasDimensionalCollapseEdge[geomi]) {
                    loc = 2;
                } else {
                    Coordinate p = e2.getCoordinate();
                    loc = this.getLocation(geomi, p, geomGraph);
                }
                label.setAllLocationsIfNull(geomi, loc);
            }
        }
    }

    private void computeEdgeEndLabels(BoundaryNodeRule boundaryNodeRule) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            EdgeEnd ee = (EdgeEnd)it.next();
            ee.computeLabel(boundaryNodeRule);
        }
    }

    private int getLocation(int geomIndex, Coordinate p, GeometryGraph[] geom) {
        if (this.ptInAreaLocation[geomIndex] == -1) {
            this.ptInAreaLocation[geomIndex] = SimplePointInAreaLocator.locate(p, geom[geomIndex].getGeometry());
        }
        return this.ptInAreaLocation[geomIndex];
    }

    public boolean isAreaLabelsConsistent(GeometryGraph geomGraph) {
        this.computeEdgeEndLabels(geomGraph.getBoundaryNodeRule());
        return this.checkAreaLabelsConsistent(0);
    }

    private boolean checkAreaLabelsConsistent(int geomIndex) {
        List edges = this.getEdges();
        if (edges.size() <= 0) {
            return true;
        }
        int lastEdgeIndex = edges.size() - 1;
        Label startLabel = ((EdgeEnd)edges.get(lastEdgeIndex)).getLabel();
        int startLoc = startLabel.getLocation(geomIndex, 1);
        Assert.isTrue(startLoc != -1, "Found unlabelled area edge");
        int currLoc = startLoc;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            EdgeEnd e2 = (EdgeEnd)it.next();
            Label label = e2.getLabel();
            Assert.isTrue(label.isArea(geomIndex), "Found non-area edge");
            int leftLoc = label.getLocation(geomIndex, 1);
            int rightLoc = label.getLocation(geomIndex, 2);
            if (leftLoc == rightLoc) {
                return false;
            }
            if (rightLoc != currLoc) {
                return false;
            }
            currLoc = leftLoc;
        }
        return true;
    }

    void propagateSideLabels(int geomIndex) {
        int startLoc = -1;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            EdgeEnd e2 = (EdgeEnd)it.next();
            Label label = e2.getLabel();
            if (!label.isArea(geomIndex) || label.getLocation(geomIndex, 1) == -1) continue;
            startLoc = label.getLocation(geomIndex, 1);
        }
        if (startLoc == -1) {
            return;
        }
        int currLoc = startLoc;
        Iterator it2 = this.iterator();
        while (it2.hasNext()) {
            EdgeEnd e3 = (EdgeEnd)it2.next();
            Label label = e3.getLabel();
            if (label.getLocation(geomIndex, 0) == -1) {
                label.setLocation(geomIndex, 0, currLoc);
            }
            if (!label.isArea(geomIndex)) continue;
            int leftLoc = label.getLocation(geomIndex, 1);
            int rightLoc = label.getLocation(geomIndex, 2);
            if (rightLoc != -1) {
                if (rightLoc != currLoc) {
                    throw new TopologyException("side location conflict", e3.getCoordinate());
                }
                if (leftLoc == -1) {
                    Assert.shouldNeverReachHere("found single null side (at " + e3.getCoordinate() + ")");
                }
                currLoc = leftLoc;
                continue;
            }
            Assert.isTrue(label.getLocation(geomIndex, 1) == -1, "found single null side");
            label.setLocation(geomIndex, 2, currLoc);
            label.setLocation(geomIndex, 1, currLoc);
        }
    }

    public int findIndex(EdgeEnd eSearch) {
        this.iterator();
        for (int i = 0; i < this.edgeList.size(); ++i) {
            EdgeEnd e2 = (EdgeEnd)this.edgeList.get(i);
            if (e2 != eSearch) continue;
            return i;
        }
        return -1;
    }

    public void print(PrintStream out) {
        System.out.println("EdgeEndStar:   " + this.getCoordinate());
        Iterator it = this.iterator();
        while (it.hasNext()) {
            EdgeEnd e2 = (EdgeEnd)it.next();
            e2.print(out);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("EdgeEndStar:   " + this.getCoordinate());
        buf.append("\n");
        Iterator it = this.iterator();
        while (it.hasNext()) {
            EdgeEnd e2 = (EdgeEnd)it.next();
            buf.append(e2);
            buf.append("\n");
        }
        return buf.toString();
    }
}

