/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.media.jai.zonalstats;

import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import org.jaitools.CollectionFactory;
import org.jaitools.media.jai.zonalstats.Result;
import org.jaitools.numeric.Range;
import org.jaitools.numeric.Statistic;
import org.jaitools.numeric.StreamingSampleStats;

public class ZonalStats {
    private List<Result> results = CollectionFactory.list();

    ZonalStats() {
    }

    private ZonalStats(ZonalStats src, Integer band, Integer zone, Statistic stat, List<Range> ranges) {
        for (Result r : src.results) {
            if (band != null && r.getImageBand() != band.intValue() || zone != null && r.getZone() != zone.intValue() || stat != null && r.getStatistic() != stat) continue;
            if (ranges == null || ranges.isEmpty()) {
                this.results.add(r);
                continue;
            }
            if (r.getRanges().containsAll(ranges)) {
                this.results.add(r);
                continue;
            }
            for (Range range : ranges) {
                if (!r.getRanges().contains(range)) continue;
                this.results.add(r);
            }
        }
    }

    void setResults(int band, int zone, StreamingSampleStats stats, List<Range> includedRanges) {
        for (Statistic s2 : stats.getStatistics()) {
            Result r = new Result(band, zone, s2, includedRanges, stats.getStatisticValue(s2), stats.getNumOffered(s2), stats.getNumAccepted(s2), stats.getNumNaN(s2), stats.getNumNoData(s2));
            this.results.add(r);
        }
    }

    void setResults(int band, int zone, StreamingSampleStats stats) {
        this.setResults(band, zone, stats, null);
    }

    public SortedSet<Integer> getZones() {
        SortedSet<Integer> ids = CollectionFactory.sortedSet();
        for (Result r : this.results) {
            ids.add(r.getZone());
        }
        return ids;
    }

    public ZonalStats band(int b2) {
        return new ZonalStats(this, b2, null, null, null);
    }

    public ZonalStats zone(int z) {
        return new ZonalStats(this, null, z, null, null);
    }

    public ZonalStats statistic(Statistic s2) {
        return new ZonalStats(this, null, null, s2, null);
    }

    public ZonalStats ranges(List<Range> ranges) {
        return new ZonalStats(this, null, null, null, ranges);
    }

    public List<Result> results() {
        return Collections.unmodifiableList(this.results);
    }
}

