/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.geotools.geometry.jts.AbstractLiteIterator;
import org.geotools.geometry.jts.Decimator;
import org.geotools.geometry.jts.EmptyIterator;
import org.geotools.geometry.jts.GeomCollectionIterator;
import org.geotools.geometry.jts.LineIterator;
import org.geotools.geometry.jts.LiteCoordinateSequence;
import org.geotools.geometry.jts.LiteCoordinateSequenceFactory;
import org.geotools.geometry.jts.PointIterator;
import org.geotools.geometry.jts.PolygonIterator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public final class LiteShape2
implements Shape,
Cloneable {
    private Geometry geometry;
    private boolean generalize = false;
    private double maxDistance = 1.0;
    private static GeometryFactory geomFac;
    private MathTransform mathTransform;

    public LiteShape2(Geometry geom, MathTransform mathTransform, Decimator decimator, boolean generalize, double maxDistance) throws TransformException, FactoryException {
        this(geom, mathTransform, decimator, generalize);
        this.maxDistance = maxDistance;
    }

    public LiteShape2(Geometry geom, MathTransform mathTransform, Decimator decimator, boolean generalize) throws TransformException, FactoryException {
        this(geom, mathTransform, decimator, generalize, true);
    }

    public LiteShape2(Geometry geom, MathTransform mathTransform, Decimator decimator, boolean generalize, boolean clone) throws TransformException, FactoryException {
        if (geom != null) {
            this.geometry = !clone && geom.getFactory().getCoordinateSequenceFactory() instanceof LiteCoordinateSequenceFactory ? geom : LiteCoordinateSequence.cloneGeometry(geom);
        }
        this.mathTransform = mathTransform;
        if (decimator != null) {
            this.geometry = decimator.decimateTransformGeneralize(this.geometry, this.mathTransform);
            this.geometry.geometryChanged();
        } else {
            if (mathTransform != null && !mathTransform.isIdentity() && generalize && this.geometry != null) {
                new Decimator(mathTransform.inverse(), this.getRectangle(this.geometry.getEnvelopeInternal())).decimate(this.geometry);
                this.geometry.geometryChanged();
            }
            if (this.geometry != null) {
                this.transformGeometry(this.geometry);
                this.geometry.geometryChanged();
            }
        }
        this.generalize = false;
    }

    private Rectangle getRectangle(Envelope envelope) {
        int minX = (int)Math.floor(envelope.getMinX());
        int minY = (int)Math.floor(envelope.getMinY());
        int maxX = (int)Math.floor(envelope.getMaxX());
        int maxY = (int)Math.floor(envelope.getMaxY());
        return new Rectangle(minX, minY, maxX - minX, maxY - minY);
    }

    private void transformGeometry(Geometry geometry) throws TransformException, FactoryException {
        if (this.mathTransform == null || this.mathTransform.isIdentity()) {
            return;
        }
        if (geometry instanceof GeometryCollection) {
            GeometryCollection collection = (GeometryCollection)geometry;
            for (int i = 0; i < collection.getNumGeometries(); ++i) {
                this.transformGeometry(collection.getGeometryN(i));
            }
        } else if (geometry instanceof Point) {
            LiteCoordinateSequence seq = (LiteCoordinateSequence)((Point)geometry).getCoordinateSequence();
            double[] coords = seq.getArray();
            double[] newCoords = new double[coords.length];
            this.mathTransform.transform(coords, 0, newCoords, 0, seq.size());
            seq.setArray(newCoords);
        } else if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            this.transformGeometry(polygon.getExteriorRing());
            for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
                this.transformGeometry(polygon.getInteriorRingN(i));
            }
        } else if (geometry instanceof LineString) {
            LiteCoordinateSequence seq = (LiteCoordinateSequence)((LineString)geometry).getCoordinateSequence();
            double[] coords = seq.getArray();
            this.mathTransform.transform(coords, 0, coords, 0, seq.size());
            seq.setArray(coords);
        }
    }

    private GeometryFactory getGeometryFactory() {
        if (geomFac == null) {
            geomFac = new GeometryFactory(new LiteCoordinateSequenceFactory());
        }
        return geomFac;
    }

    public void setGeometry(Geometry g2) throws TransformException, FactoryException {
        if (g2 != null) {
            this.geometry = this.getGeometryFactory().createGeometry(g2);
            this.transformGeometry(this.geometry);
        }
    }

    @Override
    public boolean contains(Rectangle2D r) {
        Geometry rect = this.rectangleToGeometry(r);
        return this.geometry.contains(rect);
    }

    @Override
    public boolean contains(Point2D p) {
        Coordinate coord = new Coordinate(p.getX(), p.getY());
        Point point = this.geometry.getFactory().createPoint(coord);
        return this.geometry.contains(point);
    }

    @Override
    public boolean contains(double x, double y) {
        Coordinate coord = new Coordinate(x, y);
        Point point = this.geometry.getFactory().createPoint(coord);
        return this.geometry.contains(point);
    }

    @Override
    public boolean contains(double x, double y, double w, double h2) {
        Geometry rect = this.createRectangle(x, y, w, h2);
        return this.geometry.contains(rect);
    }

    @Override
    public Rectangle getBounds() {
        Rectangle2D env = this.getBounds2D();
        return new Rectangle((int)Math.round(env.getMinX()), (int)Math.round(env.getMinY()), (int)Math.ceil(env.getWidth()), (int)Math.ceil(env.getHeight()));
    }

    @Override
    public Rectangle2D getBounds2D() {
        Envelope env = this.geometry.getEnvelopeInternal();
        return new Rectangle2D.Double(env.getMinX(), env.getMinY(), env.getMaxX() - env.getMinX(), env.getMaxY() - env.getMinY());
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        AbstractLiteIterator pi = null;
        if (this.geometry == null || this.geometry.isEmpty()) {
            return EmptyIterator.INSTANCE;
        }
        if (this.geometry instanceof Point) {
            pi = new PointIterator((Point)this.geometry, at);
        }
        if (this.geometry instanceof Polygon) {
            pi = new PolygonIterator((Polygon)this.geometry, at, this.generalize, this.maxDistance);
        } else if (this.geometry instanceof LineString) {
            pi = new LineIterator((LineString)this.geometry, at, this.generalize, (float)this.maxDistance);
        } else if (this.geometry instanceof GeometryCollection) {
            pi = new GeomCollectionIterator((GeometryCollection)this.geometry, at, this.generalize, this.maxDistance);
        }
        return pi;
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        Geometry rect = this.rectangleToGeometry(r);
        return this.geometry.intersects(rect);
    }

    @Override
    public boolean intersects(double x, double y, double w, double h2) {
        Geometry rect = this.createRectangle(x, y, w, h2);
        return this.geometry.intersects(rect);
    }

    private Geometry rectangleToGeometry(Rectangle2D r) {
        return this.createRectangle(r.getMinX(), r.getMinY(), r.getWidth(), r.getHeight());
    }

    private Geometry createRectangle(double x, double y, double w, double h2) {
        Coordinate[] coords = new Coordinate[]{new Coordinate(x, y), new Coordinate(x, y + h2), new Coordinate(x + w, y + h2), new Coordinate(x + w, y), new Coordinate(x, y)};
        LinearRing lr = this.geometry.getFactory().createLinearRing(coords);
        return this.geometry.getFactory().createPolygon(lr, null);
    }

    public MathTransform getMathTransform() {
        return this.mathTransform;
    }

    public Geometry getGeometry() {
        return this.geometry;
    }
}

