/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.PackedCoordinateSequenceFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeometryCollector {
    List<Geometry> geometries = new ArrayList<Geometry>();
    GeometryFactory factory = new GeometryFactory(new PackedCoordinateSequenceFactory());
    long coordinates = 0L;
    long maxCoordinates = -1L;
    CoordinateReferenceSystem crs = null;
    int srid = -1;

    public long getMaxCoordinates() {
        return this.maxCoordinates;
    }

    public void setMaxCoordinates(long maxCoordinates) {
        this.maxCoordinates = maxCoordinates;
    }

    public GeometryFactory getFactory() {
        return this.factory;
    }

    public void setFactory(GeometryFactory factory) {
        this.factory = factory;
    }

    public GeometryCollection collect() {
        GeometryCollection gc = this.collectInternal();
        if (this.srid > 0) {
            gc.setSRID(this.srid);
        }
        if (this.crs != null) {
            gc.setUserData(this.crs);
        }
        return gc;
    }

    public GeometryCollection collectInternal() {
        Class collectionClass;
        if (this.geometries.isEmpty()) {
            return new GeometryCollection(null, this.factory == null ? new GeometryFactory() : this.factory);
        }
        GeometryFactory gf = this.factory;
        if (gf == null) {
            gf = this.geometries.get(0).getFactory();
        }
        if (gf == null) {
            gf = new GeometryFactory();
        }
        if ((collectionClass = this.guessCollectionType()) == MultiPoint.class) {
            Point[] array = this.geometries.toArray(new Point[this.geometries.size()]);
            return gf.createMultiPoint(array);
        }
        if (collectionClass == MultiPolygon.class) {
            Polygon[] array = this.geometries.toArray(new Polygon[this.geometries.size()]);
            MultiPolygon mp = gf.createMultiPolygon(array);
            if (array.length > 1 && !mp.isValid()) {
                Geometry g2 = mp.buffer(0.0);
                if (g2 instanceof Polygon) {
                    return gf.createMultiPolygon(new Polygon[]{(Polygon)g2});
                }
                return (GeometryCollection)g2;
            }
            return mp;
        }
        if (collectionClass == MultiLineString.class) {
            LineString[] array = this.geometries.toArray(new LineString[this.geometries.size()]);
            return gf.createMultiLineString(array);
        }
        Geometry[] array = this.geometries.toArray(new Geometry[this.geometries.size()]);
        return gf.createGeometryCollection(array);
    }

    private Class guessCollectionType() {
        if (this.geometries == null || this.geometries.size() == 0) {
            return GeometryCollection.class;
        }
        Class result = this.baseType(this.geometries.get(0).getClass());
        for (int i = 1; i < this.geometries.size(); ++i) {
            Class<?> curr = this.geometries.get(i).getClass();
            if (curr == result || result.isAssignableFrom(curr)) continue;
            return GeometryCollection.class;
        }
        if (result == Point.class) {
            return MultiPoint.class;
        }
        if (result == LineString.class) {
            return MultiLineString.class;
        }
        if (result == Polygon.class) {
            return MultiPolygon.class;
        }
        return GeometryCollection.class;
    }

    private Class baseType(Class geometry) {
        if (Polygon.class.isAssignableFrom(geometry)) {
            return Polygon.class;
        }
        if (LineString.class.isAssignableFrom(geometry)) {
            return LineString.class;
        }
        if (Point.class.isAssignableFrom(geometry)) {
            return Point.class;
        }
        return geometry;
    }

    public void add(Geometry g2) {
        if (g2 == null) {
            return;
        }
        this.initCRS(g2);
        if (g2 instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)g2;
            for (int i = 0; i < gc.getNumGeometries(); ++i) {
                this.add(gc.getGeometryN(i));
            }
        } else {
            this.coordinates += (long)g2.getNumPoints();
            if (this.maxCoordinates > 0L && this.coordinates > this.maxCoordinates) {
                throw new IllegalStateException("Max number of collected ordinates has been exceeded. Current count is " + this.coordinates + ", max count is " + this.maxCoordinates);
            }
            if (this.factory != null) {
                g2 = this.factory.createGeometry(g2);
            }
            this.geometries.add(g2);
        }
    }

    private void initCRS(Geometry g2) {
        if (this.crs == null && g2.getUserData() instanceof CoordinateReferenceSystem) {
            this.crs = (CoordinateReferenceSystem)g2.getUserData();
        }
        if (this.srid == -1 && g2.getSRID() > 0) {
            this.srid = g2.getSRID();
        }
    }
}

