/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid.io.footprint;

import java.io.File;
import java.io.FileReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.geotools.coverage.grid.io.footprint.FootprintLoader;
import org.geotools.coverage.grid.io.footprint.FootprintLoaderSpi;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTReader;

public class WKTLoaderSPI
implements FootprintLoaderSpi {
    @Override
    public FootprintLoader createLoader() {
        return new WKTLoader();
    }

    public static class WKTLoader
    implements FootprintLoader {
        WKTReader reader = new WKTReader();

        @Override
        public Geometry loadFootprint(String pathNoExtension) throws Exception {
            File file = new File(pathNoExtension + ".wkt");
            if (file.exists()) {
                try (FileReader fr = new FileReader(file);){
                    Geometry geometry = this.reader.read(fr);
                    return geometry;
                }
            }
            return null;
        }

        @Override
        public List<File> getFootprintFiles(String pathNoExtension) {
            File sidecar = new File(pathNoExtension + ".wkt");
            if (sidecar.exists()) {
                return Arrays.asList(sidecar);
            }
            return Collections.emptyList();
        }
    }
}

