/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid;

import java.awt.geom.Point2D;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.media.jai.PropertySource;
import org.geotools.coverage.AbstractCoverage;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.metadata.i18n.Errors;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class AbstractGridCoverage
extends AbstractCoverage
implements GridCoverage {
    private static final long serialVersionUID = 6476934258101450793L;
    public static final Logger LOGGER = Logging.getLogger(AbstractGridCoverage.class);
    private final transient List<GridCoverage> sources;

    protected AbstractGridCoverage(CharSequence name, CoordinateReferenceSystem crs, PropertySource propertySource, Map<?, ?> properties) {
        super(name, crs, propertySource, properties);
        this.sources = null;
    }

    protected AbstractGridCoverage(CharSequence name, CoordinateReferenceSystem crs, GridCoverage[] sources, PropertySource propertySource, Map<?, ?> properties) {
        super(name, crs, propertySource, properties);
        if (sources != null) {
            switch (sources.length) {
                case 0: {
                    this.sources = null;
                    break;
                }
                case 1: {
                    this.sources = Collections.singletonList(sources[0]);
                    break;
                }
                default: {
                    this.sources = Collections.unmodifiableList(Arrays.asList((Object[])sources.clone()));
                    break;
                }
            }
        } else {
            this.sources = null;
        }
    }

    protected AbstractGridCoverage(CharSequence name, GridCoverage coverage) {
        super(name, coverage);
        this.sources = Collections.singletonList(coverage);
    }

    @Override
    public List<GridCoverage> getSources() {
        if (this.sources != null) {
            return this.sources;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isDataEditable() {
        return false;
    }

    @Override
    public int getNumOverviews() {
        return 0;
    }

    @Override
    public GridGeometry getOverviewGridGeometry(int index) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException(this.indexOutOfBounds(index));
    }

    @Override
    public GridCoverage getOverview(int index) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException(this.indexOutOfBounds(index));
    }

    private String indexOutOfBounds(int index) {
        return Errors.getResources(this.getLocale()).getString(58, "index", index);
    }

    protected String formatEvaluateError(Point2D point, boolean outside) {
        return this.formatEvaluateError(new DirectPosition2D(point), outside);
    }

    protected String formatEvaluateError(DirectPosition point, boolean outside) {
        Locale locale = this.getLocale();
        return Errors.getResources(locale).getString(outside ? 156 : 26, AbstractGridCoverage.toString(point, locale));
    }

    static String toString(Point2D point, Locale locale) {
        return AbstractGridCoverage.toString(new DirectPosition2D(point), locale);
    }

    static String toString(DirectPosition point, Locale locale) {
        StringBuffer buffer = new StringBuffer();
        FieldPosition dummy = new FieldPosition(0);
        NumberFormat format = NumberFormat.getNumberInstance(locale);
        int dimension = point.getDimension();
        for (int i = 0; i < dimension; ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            format.format(point.getOrdinate(i), buffer, dummy);
        }
        return buffer.toString();
    }
}

