/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.row.mult;

import org.ejml.MatrixDimensionException;
import org.ejml.data.DMatrix1Row;
import org.ejml.dense.row.CommonOps_DDRM;

public class MatrixMatrixMult_DDRM {
    public static void mult_reorder(DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2) {
        if (a2 == c2 || b2 == c2) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a2.numCols != b2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a2.numRows != c2.numRows || b2.numCols != c2.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (a2.numCols == 0 || a2.numRows == 0) {
            CommonOps_DDRM.fill(c2, 0.0);
            return;
        }
        int indexCbase = 0;
        int endOfKLoop = b2.numRows * b2.numCols;
        for (int i = 0; i < a2.numRows; ++i) {
            int indexA = i * a2.numCols;
            int indexB = 0;
            int indexC = indexCbase;
            int end = indexB + b2.numCols;
            double valA = a2.get(indexA++);
            while (indexB < end) {
                c2.set(indexC++, valA * b2.get(indexB++));
            }
            while (indexB != endOfKLoop) {
                indexC = indexCbase;
                end = indexB + b2.numCols;
                valA = a2.get(indexA++);
                while (indexB < end) {
                    c2.plus(indexC++, valA * b2.get(indexB++));
                }
            }
            indexCbase += c2.numCols;
        }
    }

    public static void mult_small(DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2) {
        if (a2 == c2 || b2 == c2) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a2.numCols != b2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a2.numRows != c2.numRows || b2.numCols != c2.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int aIndexStart = 0;
        int cIndex = 0;
        for (int i = 0; i < a2.numRows; ++i) {
            for (int j = 0; j < b2.numCols; ++j) {
                double total = 0.0;
                int indexA = aIndexStart;
                int indexB = j;
                int end = indexA + b2.numRows;
                while (indexA < end) {
                    total += a2.get(indexA++) * b2.get(indexB);
                    indexB += b2.numCols;
                }
                c2.set(cIndex++, total);
            }
            aIndexStart += a2.numCols;
        }
    }

    public static void mult_aux(DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2, double[] aux) {
        if (a2 == c2 || b2 == c2) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a2.numCols != b2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a2.numRows != c2.numRows || b2.numCols != c2.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (aux == null) {
            aux = new double[b2.numRows];
        }
        for (int j = 0; j < b2.numCols; ++j) {
            for (int k = 0; k < b2.numRows; ++k) {
                aux[k] = b2.unsafe_get(k, j);
            }
            int indexA = 0;
            for (int i = 0; i < a2.numRows; ++i) {
                double total = 0.0;
                int k = 0;
                while (k < b2.numRows) {
                    total += a2.get(indexA++) * aux[k++];
                }
                c2.set(i * c2.numCols + j, total);
            }
        }
    }

    public static void multTransA_reorder(DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2) {
        if (a2 == c2 || b2 == c2) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a2.numRows != b2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a2.numCols != c2.numRows || b2.numCols != c2.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (a2.numCols == 0 || a2.numRows == 0) {
            CommonOps_DDRM.fill(c2, 0.0);
            return;
        }
        for (int i = 0; i < a2.numCols; ++i) {
            int indexC_start = i * c2.numCols;
            double valA = a2.get(i);
            int indexB = 0;
            int end = indexB + b2.numCols;
            int indexC = indexC_start;
            while (indexB < end) {
                c2.set(indexC++, valA * b2.get(indexB++));
            }
            for (int k = 1; k < a2.numRows; ++k) {
                valA = a2.unsafe_get(k, i);
                end = indexB + b2.numCols;
                indexC = indexC_start;
                while (indexB < end) {
                    c2.plus(indexC++, valA * b2.get(indexB++));
                }
            }
        }
    }

    public static void multTransA_small(DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2) {
        if (a2 == c2 || b2 == c2) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a2.numRows != b2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a2.numCols != c2.numRows || b2.numCols != c2.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int cIndex = 0;
        for (int i = 0; i < a2.numCols; ++i) {
            for (int j = 0; j < b2.numCols; ++j) {
                int indexB;
                int indexA = i;
                int end = indexB + b2.numRows * b2.numCols;
                double total = 0.0;
                for (indexB = j; indexB < end; indexB += b2.numCols) {
                    total += a2.get(indexA) * b2.get(indexB);
                    indexA += a2.numCols;
                }
                c2.set(cIndex++, total);
            }
        }
    }

    public static void multTransAB(DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2) {
        if (a2 == c2 || b2 == c2) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a2.numRows != b2.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a2.numCols != c2.numRows || b2.numRows != c2.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int cIndex = 0;
        for (int i = 0; i < a2.numCols; ++i) {
            int indexB = 0;
            for (int j = 0; j < b2.numRows; ++j) {
                int indexA = i;
                int end = indexB + b2.numCols;
                double total = 0.0;
                while (indexB < end) {
                    total += a2.get(indexA) * b2.get(indexB++);
                    indexA += a2.numCols;
                }
                c2.set(cIndex++, total);
            }
        }
    }

    public static void multTransAB_aux(DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2, double[] aux) {
        if (a2 == c2 || b2 == c2) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a2.numRows != b2.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a2.numCols != c2.numRows || b2.numRows != c2.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (aux == null) {
            aux = new double[a2.numRows];
        }
        if (a2.numCols == 0 || a2.numRows == 0) {
            CommonOps_DDRM.fill(c2, 0.0);
            return;
        }
        int indexC = 0;
        for (int i = 0; i < a2.numCols; ++i) {
            for (int k = 0; k < b2.numCols; ++k) {
                aux[k] = a2.unsafe_get(k, i);
            }
            for (int j = 0; j < b2.numRows; ++j) {
                double total = 0.0;
                for (int k = 0; k < b2.numCols; ++k) {
                    total += aux[k] * b2.unsafe_get(j, k);
                }
                c2.set(indexC++, total);
            }
        }
    }

    public static void multTransB(DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2) {
        if (a2 == c2 || b2 == c2) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a2.numCols != b2.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a2.numRows != c2.numRows || b2.numRows != c2.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int cIndex = 0;
        int aIndexStart = 0;
        for (int xA = 0; xA < a2.numRows; ++xA) {
            int end = aIndexStart + b2.numCols;
            int indexB = 0;
            for (int xB = 0; xB < b2.numRows; ++xB) {
                int indexA = aIndexStart;
                double total = 0.0;
                while (indexA < end) {
                    total += a2.get(indexA++) * b2.get(indexB++);
                }
                c2.set(cIndex++, total);
            }
            aIndexStart += a2.numCols;
        }
    }

    public static void multAdd_reorder(DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2) {
        if (a2 == c2 || b2 == c2) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a2.numCols != b2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a2.numRows != c2.numRows || b2.numCols != c2.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (a2.numCols == 0 || a2.numRows == 0) {
            return;
        }
        int indexCbase = 0;
        int endOfKLoop = b2.numRows * b2.numCols;
        for (int i = 0; i < a2.numRows; ++i) {
            int indexA = i * a2.numCols;
            int indexB = 0;
            int indexC = indexCbase;
            int end = indexB + b2.numCols;
            double valA = a2.get(indexA++);
            while (indexB < end) {
                c2.plus(indexC++, valA * b2.get(indexB++));
            }
            while (indexB != endOfKLoop) {
                indexC = indexCbase;
                end = indexB + b2.numCols;
                valA = a2.get(indexA++);
                while (indexB < end) {
                    c2.plus(indexC++, valA * b2.get(indexB++));
                }
            }
            indexCbase += c2.numCols;
        }
    }

    public static void multAdd_small(DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2) {
        if (a2 == c2 || b2 == c2) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a2.numCols != b2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a2.numRows != c2.numRows || b2.numCols != c2.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int aIndexStart = 0;
        int cIndex = 0;
        for (int i = 0; i < a2.numRows; ++i) {
            for (int j = 0; j < b2.numCols; ++j) {
                double total = 0.0;
                int indexA = aIndexStart;
                int indexB = j;
                int end = indexA + b2.numRows;
                while (indexA < end) {
                    total += a2.get(indexA++) * b2.get(indexB);
                    indexB += b2.numCols;
                }
                c2.plus(cIndex++, total);
            }
            aIndexStart += a2.numCols;
        }
    }

    public static void multAdd_aux(DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2, double[] aux) {
        if (a2 == c2 || b2 == c2) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a2.numCols != b2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a2.numRows != c2.numRows || b2.numCols != c2.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (aux == null) {
            aux = new double[b2.numRows];
        }
        for (int j = 0; j < b2.numCols; ++j) {
            for (int k = 0; k < b2.numRows; ++k) {
                aux[k] = b2.unsafe_get(k, j);
            }
            int indexA = 0;
            for (int i = 0; i < a2.numRows; ++i) {
                double total = 0.0;
                int k = 0;
                while (k < b2.numRows) {
                    total += a2.get(indexA++) * aux[k++];
                }
                c2.plus(i * c2.numCols + j, total);
            }
        }
    }

    public static void multAddTransA_reorder(DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2) {
        if (a2 == c2 || b2 == c2) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a2.numRows != b2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a2.numCols != c2.numRows || b2.numCols != c2.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (a2.numCols == 0 || a2.numRows == 0) {
            return;
        }
        for (int i = 0; i < a2.numCols; ++i) {
            int indexC_start = i * c2.numCols;
            double valA = a2.get(i);
            int indexB = 0;
            int end = indexB + b2.numCols;
            int indexC = indexC_start;
            while (indexB < end) {
                c2.plus(indexC++, valA * b2.get(indexB++));
            }
            for (int k = 1; k < a2.numRows; ++k) {
                valA = a2.unsafe_get(k, i);
                end = indexB + b2.numCols;
                indexC = indexC_start;
                while (indexB < end) {
                    c2.plus(indexC++, valA * b2.get(indexB++));
                }
            }
        }
    }

    public static void multAddTransA_small(DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2) {
        if (a2 == c2 || b2 == c2) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a2.numRows != b2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a2.numCols != c2.numRows || b2.numCols != c2.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int cIndex = 0;
        for (int i = 0; i < a2.numCols; ++i) {
            for (int j = 0; j < b2.numCols; ++j) {
                int indexB;
                int indexA = i;
                int end = indexB + b2.numRows * b2.numCols;
                double total = 0.0;
                for (indexB = j; indexB < end; indexB += b2.numCols) {
                    total += a2.get(indexA) * b2.get(indexB);
                    indexA += a2.numCols;
                }
                c2.plus(cIndex++, total);
            }
        }
    }

    public static void multAddTransAB(DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2) {
        if (a2 == c2 || b2 == c2) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a2.numRows != b2.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a2.numCols != c2.numRows || b2.numRows != c2.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int cIndex = 0;
        for (int i = 0; i < a2.numCols; ++i) {
            int indexB = 0;
            for (int j = 0; j < b2.numRows; ++j) {
                int indexA = i;
                int end = indexB + b2.numCols;
                double total = 0.0;
                while (indexB < end) {
                    total += a2.get(indexA) * b2.get(indexB++);
                    indexA += a2.numCols;
                }
                c2.plus(cIndex++, total);
            }
        }
    }

    public static void multAddTransAB_aux(DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2, double[] aux) {
        if (a2 == c2 || b2 == c2) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a2.numRows != b2.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a2.numCols != c2.numRows || b2.numRows != c2.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (aux == null) {
            aux = new double[a2.numRows];
        }
        if (a2.numCols == 0 || a2.numRows == 0) {
            return;
        }
        int indexC = 0;
        for (int i = 0; i < a2.numCols; ++i) {
            for (int k = 0; k < b2.numCols; ++k) {
                aux[k] = a2.unsafe_get(k, i);
            }
            for (int j = 0; j < b2.numRows; ++j) {
                double total = 0.0;
                for (int k = 0; k < b2.numCols; ++k) {
                    total += aux[k] * b2.unsafe_get(j, k);
                }
                c2.plus(indexC++, total);
            }
        }
    }

    public static void multAddTransB(DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2) {
        if (a2 == c2 || b2 == c2) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a2.numCols != b2.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a2.numRows != c2.numRows || b2.numRows != c2.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int cIndex = 0;
        int aIndexStart = 0;
        for (int xA = 0; xA < a2.numRows; ++xA) {
            int end = aIndexStart + b2.numCols;
            int indexB = 0;
            for (int xB = 0; xB < b2.numRows; ++xB) {
                int indexA = aIndexStart;
                double total = 0.0;
                while (indexA < end) {
                    total += a2.get(indexA++) * b2.get(indexB++);
                }
                c2.plus(cIndex++, total);
            }
            aIndexStart += a2.numCols;
        }
    }

    public static void mult_reorder(double alpha, DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2) {
        if (a2 == c2 || b2 == c2) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a2.numCols != b2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a2.numRows != c2.numRows || b2.numCols != c2.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (a2.numCols == 0 || a2.numRows == 0) {
            CommonOps_DDRM.fill(c2, 0.0);
            return;
        }
        int indexCbase = 0;
        int endOfKLoop = b2.numRows * b2.numCols;
        for (int i = 0; i < a2.numRows; ++i) {
            int indexA = i * a2.numCols;
            int indexB = 0;
            int indexC = indexCbase;
            int end = indexB + b2.numCols;
            double valA = alpha * a2.get(indexA++);
            while (indexB < end) {
                c2.set(indexC++, valA * b2.get(indexB++));
            }
            while (indexB != endOfKLoop) {
                indexC = indexCbase;
                end = indexB + b2.numCols;
                valA = alpha * a2.get(indexA++);
                while (indexB < end) {
                    c2.plus(indexC++, valA * b2.get(indexB++));
                }
            }
            indexCbase += c2.numCols;
        }
    }

    public static void mult_small(double alpha, DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2) {
        if (a2 == c2 || b2 == c2) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a2.numCols != b2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a2.numRows != c2.numRows || b2.numCols != c2.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int aIndexStart = 0;
        int cIndex = 0;
        for (int i = 0; i < a2.numRows; ++i) {
            for (int j = 0; j < b2.numCols; ++j) {
                double total = 0.0;
                int indexA = aIndexStart;
                int indexB = j;
                int end = indexA + b2.numRows;
                while (indexA < end) {
                    total += a2.get(indexA++) * b2.get(indexB);
                    indexB += b2.numCols;
                }
                c2.set(cIndex++, alpha * total);
            }
            aIndexStart += a2.numCols;
        }
    }

    public static void mult_aux(double alpha, DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2, double[] aux) {
        if (a2 == c2 || b2 == c2) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a2.numCols != b2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a2.numRows != c2.numRows || b2.numCols != c2.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (aux == null) {
            aux = new double[b2.numRows];
        }
        for (int j = 0; j < b2.numCols; ++j) {
            for (int k = 0; k < b2.numRows; ++k) {
                aux[k] = b2.unsafe_get(k, j);
            }
            int indexA = 0;
            for (int i = 0; i < a2.numRows; ++i) {
                double total = 0.0;
                int k = 0;
                while (k < b2.numRows) {
                    total += a2.get(indexA++) * aux[k++];
                }
                c2.set(i * c2.numCols + j, alpha * total);
            }
        }
    }

    public static void multTransA_reorder(double alpha, DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2) {
        if (a2 == c2 || b2 == c2) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a2.numRows != b2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a2.numCols != c2.numRows || b2.numCols != c2.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (a2.numCols == 0 || a2.numRows == 0) {
            CommonOps_DDRM.fill(c2, 0.0);
            return;
        }
        for (int i = 0; i < a2.numCols; ++i) {
            int indexC_start = i * c2.numCols;
            double valA = alpha * a2.get(i);
            int indexB = 0;
            int end = indexB + b2.numCols;
            int indexC = indexC_start;
            while (indexB < end) {
                c2.set(indexC++, valA * b2.get(indexB++));
            }
            for (int k = 1; k < a2.numRows; ++k) {
                valA = alpha * a2.unsafe_get(k, i);
                end = indexB + b2.numCols;
                indexC = indexC_start;
                while (indexB < end) {
                    c2.plus(indexC++, valA * b2.get(indexB++));
                }
            }
        }
    }

    public static void multTransA_small(double alpha, DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2) {
        if (a2 == c2 || b2 == c2) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a2.numRows != b2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a2.numCols != c2.numRows || b2.numCols != c2.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int cIndex = 0;
        for (int i = 0; i < a2.numCols; ++i) {
            for (int j = 0; j < b2.numCols; ++j) {
                int indexB;
                int indexA = i;
                int end = indexB + b2.numRows * b2.numCols;
                double total = 0.0;
                for (indexB = j; indexB < end; indexB += b2.numCols) {
                    total += a2.get(indexA) * b2.get(indexB);
                    indexA += a2.numCols;
                }
                c2.set(cIndex++, alpha * total);
            }
        }
    }

    public static void multTransAB(double alpha, DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2) {
        if (a2 == c2 || b2 == c2) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a2.numRows != b2.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a2.numCols != c2.numRows || b2.numRows != c2.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int cIndex = 0;
        for (int i = 0; i < a2.numCols; ++i) {
            int indexB = 0;
            for (int j = 0; j < b2.numRows; ++j) {
                int indexA = i;
                int end = indexB + b2.numCols;
                double total = 0.0;
                while (indexB < end) {
                    total += a2.get(indexA) * b2.get(indexB++);
                    indexA += a2.numCols;
                }
                c2.set(cIndex++, alpha * total);
            }
        }
    }

    public static void multTransAB_aux(double alpha, DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2, double[] aux) {
        if (a2 == c2 || b2 == c2) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a2.numRows != b2.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a2.numCols != c2.numRows || b2.numRows != c2.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (aux == null) {
            aux = new double[a2.numRows];
        }
        if (a2.numCols == 0 || a2.numRows == 0) {
            CommonOps_DDRM.fill(c2, 0.0);
            return;
        }
        int indexC = 0;
        for (int i = 0; i < a2.numCols; ++i) {
            for (int k = 0; k < b2.numCols; ++k) {
                aux[k] = a2.unsafe_get(k, i);
            }
            for (int j = 0; j < b2.numRows; ++j) {
                double total = 0.0;
                for (int k = 0; k < b2.numCols; ++k) {
                    total += aux[k] * b2.unsafe_get(j, k);
                }
                c2.set(indexC++, alpha * total);
            }
        }
    }

    public static void multTransB(double alpha, DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2) {
        if (a2 == c2 || b2 == c2) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a2.numCols != b2.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a2.numRows != c2.numRows || b2.numRows != c2.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int cIndex = 0;
        int aIndexStart = 0;
        for (int xA = 0; xA < a2.numRows; ++xA) {
            int end = aIndexStart + b2.numCols;
            int indexB = 0;
            for (int xB = 0; xB < b2.numRows; ++xB) {
                int indexA = aIndexStart;
                double total = 0.0;
                while (indexA < end) {
                    total += a2.get(indexA++) * b2.get(indexB++);
                }
                c2.set(cIndex++, alpha * total);
            }
            aIndexStart += a2.numCols;
        }
    }

    public static void multAdd_reorder(double alpha, DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2) {
        if (a2 == c2 || b2 == c2) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a2.numCols != b2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a2.numRows != c2.numRows || b2.numCols != c2.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (a2.numCols == 0 || a2.numRows == 0) {
            return;
        }
        int indexCbase = 0;
        int endOfKLoop = b2.numRows * b2.numCols;
        for (int i = 0; i < a2.numRows; ++i) {
            int indexA = i * a2.numCols;
            int indexB = 0;
            int indexC = indexCbase;
            int end = indexB + b2.numCols;
            double valA = alpha * a2.get(indexA++);
            while (indexB < end) {
                c2.plus(indexC++, valA * b2.get(indexB++));
            }
            while (indexB != endOfKLoop) {
                indexC = indexCbase;
                end = indexB + b2.numCols;
                valA = alpha * a2.get(indexA++);
                while (indexB < end) {
                    c2.plus(indexC++, valA * b2.get(indexB++));
                }
            }
            indexCbase += c2.numCols;
        }
    }

    public static void multAdd_small(double alpha, DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2) {
        if (a2 == c2 || b2 == c2) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a2.numCols != b2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a2.numRows != c2.numRows || b2.numCols != c2.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int aIndexStart = 0;
        int cIndex = 0;
        for (int i = 0; i < a2.numRows; ++i) {
            for (int j = 0; j < b2.numCols; ++j) {
                double total = 0.0;
                int indexA = aIndexStart;
                int indexB = j;
                int end = indexA + b2.numRows;
                while (indexA < end) {
                    total += a2.get(indexA++) * b2.get(indexB);
                    indexB += b2.numCols;
                }
                c2.plus(cIndex++, alpha * total);
            }
            aIndexStart += a2.numCols;
        }
    }

    public static void multAdd_aux(double alpha, DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2, double[] aux) {
        if (a2 == c2 || b2 == c2) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a2.numCols != b2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a2.numRows != c2.numRows || b2.numCols != c2.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (aux == null) {
            aux = new double[b2.numRows];
        }
        for (int j = 0; j < b2.numCols; ++j) {
            for (int k = 0; k < b2.numRows; ++k) {
                aux[k] = b2.unsafe_get(k, j);
            }
            int indexA = 0;
            for (int i = 0; i < a2.numRows; ++i) {
                double total = 0.0;
                int k = 0;
                while (k < b2.numRows) {
                    total += a2.get(indexA++) * aux[k++];
                }
                c2.plus(i * c2.numCols + j, alpha * total);
            }
        }
    }

    public static void multAddTransA_reorder(double alpha, DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2) {
        if (a2 == c2 || b2 == c2) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a2.numRows != b2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a2.numCols != c2.numRows || b2.numCols != c2.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (a2.numCols == 0 || a2.numRows == 0) {
            return;
        }
        for (int i = 0; i < a2.numCols; ++i) {
            int indexC_start = i * c2.numCols;
            double valA = alpha * a2.get(i);
            int indexB = 0;
            int end = indexB + b2.numCols;
            int indexC = indexC_start;
            while (indexB < end) {
                c2.plus(indexC++, valA * b2.get(indexB++));
            }
            for (int k = 1; k < a2.numRows; ++k) {
                valA = alpha * a2.unsafe_get(k, i);
                end = indexB + b2.numCols;
                indexC = indexC_start;
                while (indexB < end) {
                    c2.plus(indexC++, valA * b2.get(indexB++));
                }
            }
        }
    }

    public static void multAddTransA_small(double alpha, DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2) {
        if (a2 == c2 || b2 == c2) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a2.numRows != b2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a2.numCols != c2.numRows || b2.numCols != c2.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int cIndex = 0;
        for (int i = 0; i < a2.numCols; ++i) {
            for (int j = 0; j < b2.numCols; ++j) {
                int indexB;
                int indexA = i;
                int end = indexB + b2.numRows * b2.numCols;
                double total = 0.0;
                for (indexB = j; indexB < end; indexB += b2.numCols) {
                    total += a2.get(indexA) * b2.get(indexB);
                    indexA += a2.numCols;
                }
                c2.plus(cIndex++, alpha * total);
            }
        }
    }

    public static void multAddTransAB(double alpha, DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2) {
        if (a2 == c2 || b2 == c2) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a2.numRows != b2.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a2.numCols != c2.numRows || b2.numRows != c2.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int cIndex = 0;
        for (int i = 0; i < a2.numCols; ++i) {
            int indexB = 0;
            for (int j = 0; j < b2.numRows; ++j) {
                int indexA = i;
                int end = indexB + b2.numCols;
                double total = 0.0;
                while (indexB < end) {
                    total += a2.get(indexA) * b2.get(indexB++);
                    indexA += a2.numCols;
                }
                c2.plus(cIndex++, alpha * total);
            }
        }
    }

    public static void multAddTransAB_aux(double alpha, DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2, double[] aux) {
        if (a2 == c2 || b2 == c2) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a2.numRows != b2.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a2.numCols != c2.numRows || b2.numRows != c2.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (aux == null) {
            aux = new double[a2.numRows];
        }
        if (a2.numCols == 0 || a2.numRows == 0) {
            return;
        }
        int indexC = 0;
        for (int i = 0; i < a2.numCols; ++i) {
            for (int k = 0; k < b2.numCols; ++k) {
                aux[k] = a2.unsafe_get(k, i);
            }
            for (int j = 0; j < b2.numRows; ++j) {
                double total = 0.0;
                for (int k = 0; k < b2.numCols; ++k) {
                    total += aux[k] * b2.unsafe_get(j, k);
                }
                c2.plus(indexC++, alpha * total);
            }
        }
    }

    public static void multAddTransB(double alpha, DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2) {
        if (a2 == c2 || b2 == c2) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a2.numCols != b2.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a2.numRows != c2.numRows || b2.numRows != c2.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int cIndex = 0;
        int aIndexStart = 0;
        for (int xA = 0; xA < a2.numRows; ++xA) {
            int end = aIndexStart + b2.numCols;
            int indexB = 0;
            for (int xB = 0; xB < b2.numRows; ++xB) {
                int indexA = aIndexStart;
                double total = 0.0;
                while (indexA < end) {
                    total += a2.get(indexA++) * b2.get(indexB++);
                }
                c2.plus(cIndex++, alpha * total);
            }
            aIndexStart += a2.numCols;
        }
    }
}

