/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.tools;

import org.chocosolver.solver.expression.continuous.arithmetic.RealIntervalConstant;
import org.chocosolver.util.objects.RealInterval;

public class RealUtils {
    private static final double ZERO = 0.0;
    private static final double NEG_ZER0 = -0.0;

    public static double nextFloat(double x) {
        if (x < 0.0) {
            return Double.longBitsToDouble(Double.doubleToLongBits(x) - 1L);
        }
        if (x == 0.0) {
            return Double.longBitsToDouble(1L);
        }
        if (x < Double.POSITIVE_INFINITY) {
            return Double.longBitsToDouble(Double.doubleToLongBits(x) + 1L);
        }
        return x;
    }

    public static double prevFloat(double x) {
        if (x == 0.0) {
            return -RealUtils.nextFloat(0.0);
        }
        return -RealUtils.nextFloat(-x);
    }

    public static RealInterval add(RealInterval x, RealInterval y) {
        return new RealIntervalConstant(RealUtils.prevFloat(x.getLB() + y.getLB()), RealUtils.nextFloat(x.getUB() + y.getUB()));
    }

    public static RealInterval sub(RealInterval x, RealInterval y) {
        return new RealIntervalConstant(RealUtils.prevFloat(x.getLB() - y.getUB()), RealUtils.nextFloat(x.getUB() - y.getLB()));
    }

    public static RealInterval mul(RealInterval x, RealInterval y) {
        double s2;
        double i;
        if (x.getLB() == 0.0 && x.getUB() == 0.0 || y.getLB() == 0.0 && y.getUB() == 0.0) {
            i = -0.0;
            s2 = 0.0;
        } else if (x.getLB() >= 0.0) {
            if (y.getLB() >= 0.0) {
                i = Math.max(0.0, RealUtils.prevFloat(x.getLB() * y.getLB()));
                s2 = RealUtils.nextFloat(x.getUB() * y.getUB());
            } else if (y.getUB() <= 0.0) {
                i = RealUtils.prevFloat(x.getUB() * y.getLB());
                s2 = Math.min(0.0, RealUtils.nextFloat(x.getLB() * y.getUB()));
            } else {
                i = RealUtils.prevFloat(x.getUB() * y.getLB());
                s2 = RealUtils.nextFloat(x.getUB() * y.getUB());
            }
        } else if (x.getUB() <= 0.0) {
            if (y.getLB() >= 0.0) {
                i = RealUtils.prevFloat(x.getLB() * y.getUB());
                s2 = Math.min(0.0, RealUtils.nextFloat(x.getUB() * y.getLB()));
            } else if (y.getUB() <= 0.0) {
                i = Math.max(0.0, RealUtils.prevFloat(x.getUB() * y.getUB()));
                s2 = RealUtils.nextFloat(x.getLB() * y.getLB());
            } else {
                i = RealUtils.prevFloat(x.getLB() * y.getUB());
                s2 = RealUtils.nextFloat(x.getLB() * y.getLB());
            }
        } else if (y.getLB() >= 0.0) {
            i = RealUtils.prevFloat(x.getLB() * y.getUB());
            s2 = RealUtils.nextFloat(x.getUB() * y.getUB());
        } else if (y.getUB() <= 0.0) {
            i = RealUtils.prevFloat(x.getUB() * y.getLB());
            s2 = RealUtils.nextFloat(x.getLB() * y.getLB());
        } else {
            i = Math.min(RealUtils.prevFloat(x.getLB() * y.getUB()), RealUtils.prevFloat(x.getUB() * y.getLB()));
            s2 = Math.max(RealUtils.nextFloat(x.getLB() * y.getLB()), RealUtils.nextFloat(x.getUB() * y.getUB()));
        }
        return new RealIntervalConstant(i, s2);
    }

    public static RealInterval odiv(RealInterval x, RealInterval y) {
        if (y.getLB() >= 0.0 && y.getUB() <= 0.0) {
            throw new ArithmeticException("the divisor is 0");
        }
        double yl = y.getLB();
        double yh = y.getUB();
        double i = Double.NEGATIVE_INFINITY;
        double s2 = Double.POSITIVE_INFINITY;
        if (yh == 0.0) {
            yh = -0.0;
        }
        if (x.getLB() >= 0.0) {
            if (yl >= 0.0) {
                i = Math.max(0.0, RealUtils.prevFloat(x.getLB() / yh));
                s2 = RealUtils.nextFloat(x.getUB() / yl);
            } else if (yh <= 0.0) {
                i = RealUtils.prevFloat(x.getUB() / yh);
                s2 = Math.min(0.0, RealUtils.nextFloat(x.getLB() / yl));
            }
        } else if (x.getUB() <= 0.0) {
            if (yl >= 0.0) {
                i = RealUtils.prevFloat(x.getLB() / yl);
                s2 = Math.min(0.0, RealUtils.nextFloat(x.getUB() / yh));
            } else if (yh <= 0.0) {
                i = Math.max(0.0, RealUtils.prevFloat(x.getUB() / yl));
                s2 = RealUtils.nextFloat(x.getLB() / yh);
            }
        } else if (yl >= 0.0) {
            i = RealUtils.prevFloat(x.getLB() / yl);
            s2 = RealUtils.nextFloat(x.getUB() / yl);
        } else if (yh <= 0.0) {
            i = RealUtils.prevFloat(x.getUB() / yh);
            s2 = RealUtils.nextFloat(x.getLB() / yh);
        }
        return new RealIntervalConstant(i, s2);
    }

    public static RealInterval odiv_wrt(RealInterval x, RealInterval y, RealInterval res) {
        if (y.getLB() > 0.0 || y.getUB() < 0.0) {
            return RealUtils.odiv(x, y);
        }
        double resl = res.getLB();
        double resh = res.getUB();
        if (x.getLB() >= 0.0) {
            double tmp_neg = RealUtils.nextFloat(x.getLB() / y.getLB());
            double tmp_pos = RealUtils.prevFloat(x.getLB() / y.getUB());
            if ((resl > tmp_neg || resl == 0.0) && resl < tmp_pos) {
                resl = tmp_pos;
            }
            if ((resh < tmp_pos || resh == 0.0) && resh > tmp_neg) {
                resh = tmp_neg;
            }
        } else if (x.getUB() <= 0.0) {
            double tmp_neg = RealUtils.nextFloat(x.getUB() / y.getUB());
            double tmp_pos = RealUtils.nextFloat(x.getUB() / y.getLB());
            if ((resl > tmp_neg || resl == 0.0) && resl < tmp_pos) {
                resl = tmp_pos;
            }
            if ((resh < tmp_pos || resh == 0.0) && resh > tmp_neg) {
                resh = tmp_neg;
            }
        }
        return new RealIntervalConstant(resl, resh);
    }

    public static RealInterval firstHalf(RealInterval i) {
        double sup;
        double inf = i.getLB();
        if (inf == Double.NEGATIVE_INFINITY) {
            inf = -1.7976931348623157E308;
        }
        if ((sup = i.getUB()) == Double.POSITIVE_INFINITY) {
            sup = Double.MAX_VALUE;
        }
        return new RealIntervalConstant(i.getLB(), inf + sup / 2.0 - inf / 2.0);
    }

    public static RealInterval secondHalf(RealInterval i) {
        double sup;
        double inf = i.getLB();
        if (inf == Double.NEGATIVE_INFINITY) {
            inf = -1.7976931348623157E308;
        }
        if ((sup = i.getUB()) == Double.POSITIVE_INFINITY) {
            sup = Double.MAX_VALUE;
        }
        return new RealIntervalConstant(inf + sup / 2.0 - inf / 2.0, i.getUB());
    }

    private static double iPower_lo(double x, int p) {
        if (x == 0.0) {
            return 0.0;
        }
        if (x == 1.0) {
            return 1.0;
        }
        return RealUtils.prevFloat(Math.exp(RealUtils.prevFloat((double)p * RealUtils.prevFloat(Math.log(x)))));
    }

    private static double iPower_up(double x, int p) {
        if (x == 0.0) {
            return 0.0;
        }
        if (x == 1.0) {
            return 1.0;
        }
        return RealUtils.nextFloat(Math.exp(RealUtils.nextFloat((double)p * RealUtils.nextFloat(Math.log(x)))));
    }

    private static RealInterval evenIPower(RealInterval i, int p) {
        double sup;
        double inf;
        if (i.getLB() >= 0.0) {
            if (i.getLB() == Double.POSITIVE_INFINITY) {
                inf = Double.POSITIVE_INFINITY;
                sup = Double.POSITIVE_INFINITY;
            } else {
                inf = RealUtils.iPower_lo(i.getLB(), p);
                sup = i.getUB() == Double.POSITIVE_INFINITY ? Double.POSITIVE_INFINITY : RealUtils.iPower_up(i.getUB(), p);
            }
        } else if (i.getUB() <= 0.0) {
            if (i.getUB() == Double.NEGATIVE_INFINITY) {
                inf = Double.POSITIVE_INFINITY;
                sup = Double.POSITIVE_INFINITY;
            } else {
                inf = RealUtils.iPower_lo(-i.getUB(), p);
                sup = i.getLB() == Double.NEGATIVE_INFINITY ? Double.POSITIVE_INFINITY : RealUtils.iPower_up(-i.getLB(), p);
            }
        } else {
            inf = 0.0;
            sup = i.getLB() == Double.NEGATIVE_INFINITY || i.getUB() == Double.POSITIVE_INFINITY ? Double.POSITIVE_INFINITY : Math.max(RealUtils.iPower_up(-i.getLB(), p), RealUtils.iPower_up(i.getUB(), p));
        }
        return new RealIntervalConstant(inf, sup);
    }

    private static RealInterval oddIPower(RealInterval i, int p) {
        double sup;
        double inf;
        if (i.getLB() >= 0.0) {
            if (i.getLB() == Double.POSITIVE_INFINITY) {
                inf = Double.POSITIVE_INFINITY;
                sup = Double.POSITIVE_INFINITY;
            } else {
                inf = RealUtils.iPower_lo(i.getLB(), p);
                sup = i.getUB() == Double.POSITIVE_INFINITY ? Double.POSITIVE_INFINITY : RealUtils.iPower_up(i.getUB(), p);
            }
        } else if (i.getUB() <= 0.0) {
            if (i.getUB() == Double.NEGATIVE_INFINITY) {
                inf = Double.NEGATIVE_INFINITY;
                sup = Double.NEGATIVE_INFINITY;
            } else {
                sup = -RealUtils.iPower_lo(-i.getUB(), p);
                inf = i.getLB() == Double.NEGATIVE_INFINITY ? Double.NEGATIVE_INFINITY : -RealUtils.iPower_up(-i.getLB(), p);
            }
        } else {
            inf = i.getLB() == Double.NEGATIVE_INFINITY ? Double.NEGATIVE_INFINITY : -RealUtils.iPower_up(-i.getLB(), p);
            sup = i.getUB() == Double.POSITIVE_INFINITY ? Double.POSITIVE_INFINITY : RealUtils.iPower_up(i.getUB(), p);
        }
        return new RealIntervalConstant(inf, sup);
    }

    public static RealInterval iPower(RealInterval i, int p) {
        if (p <= 1) {
            throw new UnsupportedOperationException();
        }
        if (p % 2 == 0) {
            return RealUtils.evenIPower(i, p);
        }
        return RealUtils.oddIPower(i, p);
    }

    private static double iRoot_lo(double x, int p) {
        double d_lo = RealUtils.prevFloat(1.0 / (double)p);
        double d_hi = RealUtils.nextFloat(1.0 / (double)p);
        if (x == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        if (x == 0.0) {
            return 0.0;
        }
        if (x == 1.0) {
            return 1.0;
        }
        if (x < 1.0) {
            return RealUtils.prevFloat(Math.exp(RealUtils.prevFloat(d_hi * RealUtils.prevFloat(Math.log(x)))));
        }
        return RealUtils.prevFloat(Math.exp(RealUtils.prevFloat(d_lo * RealUtils.prevFloat(Math.log(x)))));
    }

    private static double iRoot_up(double x, int p) {
        double d_lo = RealUtils.prevFloat(1.0 / (double)p);
        double d_hi = RealUtils.nextFloat(1.0 / (double)p);
        if (x == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        if (x == 0.0) {
            return 0.0;
        }
        if (x == 1.0) {
            return 1.0;
        }
        if (x < 1.0) {
            return RealUtils.nextFloat(Math.exp(RealUtils.nextFloat(d_lo * RealUtils.nextFloat(Math.log(x)))));
        }
        return RealUtils.nextFloat(Math.exp(RealUtils.nextFloat(d_hi * RealUtils.nextFloat(Math.log(x)))));
    }

    private static RealInterval evenIRoot(RealInterval i, int p) {
        if (i.getUB() < 0.0) {
            System.err.println("Erreur !!");
        }
        double inf = i.getLB() < 0.0 ? 0.0 : RealUtils.iRoot_lo(i.getLB(), p);
        double sup = RealUtils.iRoot_up(i.getUB(), p);
        return new RealIntervalConstant(inf, sup);
    }

    private static RealInterval evenIRoot(RealInterval i, int p, RealInterval res) {
        if (i.getUB() < 0.0) {
            System.err.println("Erreur !!");
        }
        double inf = i.getLB() < 0.0 ? 0.0 : RealUtils.iRoot_lo(i.getLB(), p);
        double sup = RealUtils.iRoot_up(i.getUB(), p);
        if (res.getUB() < inf) {
            return new RealIntervalConstant(-sup, -inf);
        }
        if (res.getLB() > sup) {
            return new RealIntervalConstant(inf, sup);
        }
        return new RealIntervalConstant(-sup, sup);
    }

    private static RealInterval oddIRoot(RealInterval i, int p) {
        double inf = i.getLB() >= 0.0 ? RealUtils.iRoot_lo(i.getLB(), p) : -RealUtils.iRoot_up(-i.getLB(), p);
        double sup = i.getUB() >= 0.0 ? RealUtils.iRoot_up(i.getUB(), p) : -RealUtils.iRoot_lo(-i.getUB(), p);
        return new RealIntervalConstant(inf, sup);
    }

    public static RealInterval iRoot(RealInterval i, int p) {
        if (p <= 1) {
            throw new UnsupportedOperationException();
        }
        if (p % 2 == 0) {
            return RealUtils.evenIRoot(i, p);
        }
        return RealUtils.oddIRoot(i, p);
    }

    public static RealInterval iRoot(RealInterval i, int p, RealInterval res) {
        if (p <= 1) {
            throw new UnsupportedOperationException();
        }
        if (p % 2 == 0) {
            return RealUtils.evenIRoot(i, p, res);
        }
        return RealUtils.oddIRoot(i, p);
    }

    private static RealInterval sinRange(int a2, int b2) {
        switch (4 * a2 + b2) {
            case 1: {
                return new RealIntervalConstant(1.0, 1.0);
            }
            case 2: 
            case 13: {
                return new RealIntervalConstant(0.0, 1.0);
            }
            case 6: 
            case 12: {
                return new RealIntervalConstant(0.0, 0.0);
            }
            case 7: 
            case 8: {
                return new RealIntervalConstant(-1.0, 0.0);
            }
            case 11: {
                return new RealIntervalConstant(-1.0, -1.0);
            }
        }
        throw new UnsupportedOperationException();
    }

    public static RealInterval cos(RealInterval i) {
        if (i.getUB() - i.getLB() > RealUtils.prevFloat(1.5 * RealUtils.prevFloat(Math.PI))) {
            return new RealIntervalConstant(-1.0, 1.0);
        }
        int nlo = i.getLB() >= 0.0 ? (int)Math.floor(RealUtils.prevFloat(RealUtils.prevFloat(i.getLB() * 2.0) / RealUtils.nextFloat(Math.PI))) : (int)Math.floor(RealUtils.prevFloat(RealUtils.prevFloat(i.getLB() * 2.0) / RealUtils.prevFloat(Math.PI)));
        int nup = i.getUB() >= 0.0 ? (int)Math.floor(RealUtils.nextFloat(RealUtils.nextFloat(i.getUB() * 2.0) / RealUtils.prevFloat(Math.PI))) : (int)Math.floor(RealUtils.nextFloat(RealUtils.nextFloat(i.getUB() * 2.0) / RealUtils.nextFloat(Math.PI)));
        if (((nup - nlo) % 4 + 4) % 4 == 3) {
            return new RealIntervalConstant(-1.0, 1.0);
        }
        double clo = Math.min(RealUtils.prevFloat(Math.cos(i.getLB())), RealUtils.prevFloat(Math.cos(i.getUB())));
        double cup = Math.max(RealUtils.nextFloat(Math.cos(i.getLB())), RealUtils.nextFloat(Math.cos(i.getUB())));
        if (((nup - nlo) % 4 + 4) % 4 == 0) {
            return new RealIntervalConstant(clo, cup);
        }
        RealInterval mask = RealUtils.sinRange(((nlo + 1) % 4 + 4) % 4, ((nup + 1) % 4 + 4) % 4);
        if (mask.getLB() < clo) {
            clo = mask.getLB();
        }
        if (mask.getUB() > cup) {
            cup = mask.getUB();
        }
        return new RealIntervalConstant(clo, cup);
    }

    public static RealInterval sin(RealInterval i) {
        if (i.getUB() - i.getLB() > RealUtils.prevFloat(1.5 * RealUtils.prevFloat(Math.PI))) {
            return new RealIntervalConstant(-1.0, 1.0);
        }
        int nlo = i.getLB() >= 0.0 ? (int)Math.floor(RealUtils.prevFloat(RealUtils.prevFloat(i.getLB() * 2.0) / RealUtils.nextFloat(Math.PI))) : (int)Math.floor(RealUtils.prevFloat(RealUtils.prevFloat(i.getLB() * 2.0) / RealUtils.prevFloat(Math.PI)));
        int nup = i.getUB() >= 0.0 ? (int)Math.floor(RealUtils.nextFloat(RealUtils.nextFloat(i.getUB() * 2.0) / RealUtils.prevFloat(Math.PI))) : (int)Math.floor(RealUtils.nextFloat(RealUtils.nextFloat(i.getUB() * 2.0) / RealUtils.nextFloat(Math.PI)));
        if (((nup - nlo) % 4 + 4) % 4 == 3) {
            return new RealIntervalConstant(-1.0, 1.0);
        }
        double clo = Math.min(RealUtils.prevFloat(Math.sin(i.getLB())), RealUtils.prevFloat(Math.sin(i.getUB())));
        double cup = Math.max(RealUtils.nextFloat(Math.sin(i.getLB())), RealUtils.nextFloat(Math.sin(i.getUB())));
        if (((nup - nlo) % 4 + 4) % 4 == 0) {
            return new RealIntervalConstant(clo, cup);
        }
        RealInterval mask = RealUtils.sinRange((nlo % 4 + 4) % 4, (nup % 4 + 4) % 4);
        if (mask.getLB() < clo) {
            clo = mask.getLB();
        }
        if (mask.getUB() > cup) {
            cup = mask.getUB();
        }
        return new RealIntervalConstant(clo, cup);
    }

    public static RealInterval asin_wrt(RealInterval i, RealInterval res) {
        double decInf;
        double decSup;
        double retSup = Double.POSITIVE_INFINITY;
        double retInf = Double.NEGATIVE_INFINITY;
        double asinl = RealUtils.prevFloat(Math.asin(i.getLB()));
        double asinu = RealUtils.nextFloat(Math.asin(i.getUB()));
        int modSup = (int)Math.floor((res.getLB() + RealUtils.nextFloat(Math.PI)) / RealUtils.prevFloat(Math.PI * 2));
        if (modSup < 0) {
            decSup = RealUtils.nextFloat((double)(2 * modSup) * RealUtils.prevFloat(Math.PI));
            decInf = RealUtils.prevFloat((double)(2 * modSup) * RealUtils.nextFloat(Math.PI));
        } else if (modSup > 0) {
            decSup = RealUtils.nextFloat((double)(2 * modSup) * RealUtils.nextFloat(Math.PI));
            decInf = RealUtils.prevFloat((double)(2 * modSup) * RealUtils.prevFloat(Math.PI));
        } else {
            decSup = 0.0;
            decInf = 0.0;
        }
        if (i.getLB() > -1.0) {
            if (res.getLB() > RealUtils.nextFloat(RealUtils.nextFloat(-Math.PI) - asinl + decSup) && res.getLB() < RealUtils.prevFloat(asinl + decInf)) {
                retInf = RealUtils.prevFloat(asinl + decInf);
            }
            if (res.getLB() > RealUtils.nextFloat(RealUtils.nextFloat(Math.PI) - asinl + decSup) && res.getLB() < RealUtils.prevFloat(asinl + 2.0 * RealUtils.prevFloat(Math.PI) + decInf)) {
                retInf = RealUtils.prevFloat(asinl + 2.0 * RealUtils.prevFloat(Math.PI) + decInf);
            }
        }
        if (i.getUB() < 1.0 && res.getLB() > asinu + decSup && res.getLB() < RealUtils.prevFloat(RealUtils.prevFloat(Math.PI) - asinu) + decInf) {
            retInf = RealUtils.prevFloat(RealUtils.prevFloat(Math.PI) - asinu) + decInf;
        }
        if ((modSup = (int)Math.floor((res.getUB() + RealUtils.nextFloat(Math.PI)) / RealUtils.prevFloat(Math.PI * 2))) < 0) {
            decSup = RealUtils.nextFloat((double)(2 * modSup) * RealUtils.prevFloat(Math.PI));
            decInf = RealUtils.prevFloat((double)(2 * modSup) * RealUtils.nextFloat(Math.PI));
        } else if (modSup > 0) {
            decSup = RealUtils.nextFloat((double)(2 * modSup) * RealUtils.nextFloat(Math.PI));
            decInf = RealUtils.prevFloat((double)(2 * modSup) * RealUtils.prevFloat(Math.PI));
        } else {
            decSup = 0.0;
            decInf = 0.0;
        }
        if (i.getLB() > -1.0) {
            if (res.getUB() > RealUtils.nextFloat(RealUtils.nextFloat(-Math.PI) - asinl + decSup) && res.getUB() < RealUtils.prevFloat(asinl + decInf)) {
                retSup = RealUtils.nextFloat(RealUtils.nextFloat(-Math.PI) - asinl + decSup);
            }
            if (res.getUB() > RealUtils.nextFloat(RealUtils.nextFloat(Math.PI) - asinl + decSup) && res.getUB() < RealUtils.prevFloat(asinl + 2.0 * RealUtils.prevFloat(Math.PI) + decInf)) {
                retSup = RealUtils.nextFloat(RealUtils.nextFloat(Math.PI) - asinl + decSup);
            }
        }
        if (i.getUB() < 1.0 && res.getUB() > asinu + decSup && res.getUB() < RealUtils.prevFloat(RealUtils.prevFloat(Math.PI) - asinu) + decInf) {
            retSup = asinu + decSup;
        }
        return new RealIntervalConstant(retInf, retSup);
    }

    public static RealInterval acos_wrt(RealInterval i, RealInterval res) {
        double decInf;
        double decSup;
        double retSup = Double.POSITIVE_INFINITY;
        double retInf = Double.NEGATIVE_INFINITY;
        double acosl = RealUtils.prevFloat(Math.acos(i.getUB()));
        double acosu = RealUtils.nextFloat(Math.acos(i.getLB()));
        int modSup = (int)Math.floor(res.getLB() / RealUtils.prevFloat(Math.PI * 2));
        if (modSup < 0) {
            decSup = RealUtils.nextFloat((double)(2 * modSup) * RealUtils.prevFloat(Math.PI));
            decInf = RealUtils.prevFloat((double)(2 * modSup) * RealUtils.nextFloat(Math.PI));
        } else if (modSup > 0) {
            decSup = RealUtils.nextFloat((double)(2 * modSup) * RealUtils.nextFloat(Math.PI));
            decInf = RealUtils.prevFloat((double)(2 * modSup) * RealUtils.prevFloat(Math.PI));
        } else {
            decSup = 0.0;
            decInf = 0.0;
        }
        if (i.getUB() < 1.0) {
            if (res.getLB() > RealUtils.nextFloat(decSup - acosl) && res.getLB() < RealUtils.prevFloat(decInf + acosl)) {
                retInf = RealUtils.prevFloat(decInf + acosl);
            }
            if (res.getLB() > RealUtils.nextFloat(2.0 * RealUtils.nextFloat(Math.PI) - acosl + decSup) && res.getLB() < RealUtils.prevFloat(2.0 * RealUtils.prevFloat(Math.PI) + acosl + decInf)) {
                retInf = RealUtils.prevFloat(2.0 * RealUtils.prevFloat(Math.PI) + acosl + decInf);
            }
        }
        if (i.getLB() > -1.0 && res.getLB() > RealUtils.nextFloat(acosu + decSup) && res.getLB() < RealUtils.prevFloat(2.0 * RealUtils.prevFloat(Math.PI) - acosu + decInf)) {
            retInf = RealUtils.prevFloat(2.0 * RealUtils.prevFloat(Math.PI) - acosu + decInf);
        }
        if ((modSup = (int)Math.floor(res.getUB() / RealUtils.prevFloat(Math.PI * 2))) < 0) {
            decSup = RealUtils.nextFloat((double)(2 * modSup) * RealUtils.prevFloat(Math.PI));
            decInf = RealUtils.prevFloat((double)(2 * modSup) * RealUtils.nextFloat(Math.PI));
        } else if (modSup > 0) {
            decSup = RealUtils.nextFloat((double)(2 * modSup) * RealUtils.nextFloat(Math.PI));
            decInf = RealUtils.prevFloat((double)(2 * modSup) * RealUtils.prevFloat(Math.PI));
        } else {
            decSup = 0.0;
            decInf = 0.0;
        }
        if (i.getUB() < 1.0) {
            if (res.getUB() > RealUtils.nextFloat(decSup - acosl) && res.getUB() < RealUtils.prevFloat(decInf + acosl)) {
                retSup = RealUtils.nextFloat(decSup - acosl);
            }
            if (res.getUB() > RealUtils.nextFloat(2.0 * RealUtils.nextFloat(Math.PI) - acosl + decSup) && res.getUB() < RealUtils.prevFloat(2.0 * RealUtils.prevFloat(Math.PI) + acosl + decInf)) {
                retSup = RealUtils.nextFloat(2.0 * RealUtils.nextFloat(Math.PI) - acosl + decSup);
            }
        }
        if (i.getLB() > -1.0 && res.getUB() > RealUtils.nextFloat(acosu + decSup) && res.getUB() < RealUtils.prevFloat(2.0 * RealUtils.prevFloat(Math.PI) - acosu + decInf)) {
            retSup = RealUtils.nextFloat(acosu + decSup);
        }
        return new RealIntervalConstant(retInf, retSup);
    }
}

