/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.tree;

public interface Interval
extends Comparable<Interval> {
    public int start();

    public int end();

    default public int length() {
        return this.end() - this.start();
    }

    default public boolean isAdjacent(Interval other) {
        return this.start() == other.end() || this.end() == other.start();
    }

    default public boolean overlaps(Interval o) {
        return this.end() > o.start() && o.end() > this.start();
    }

    default public boolean overlaps(int start, int end) {
        return this.end() > start && end > this.start();
    }

    @Override
    default public int compareTo(Interval o) {
        return this.compareTo(o.start(), o.end());
    }

    default public int compareTo(int s2, int e2) {
        int d2 = this.start() - s2;
        if (!(1.$assertionsDisabled || this.start() > s2 && d2 > 0 || this.start() < s2 && d2 < 0 || this.start() == s2 && d2 == 0)) {
            throw new AssertionError();
        }
        if (d2 == 0) {
            d2 = this.end() - e2;
            if (!(1.$assertionsDisabled || this.end() > e2 && d2 > 0 || this.end() < e2 && d2 < 0 || this.end() == e2 && d2 == 0)) {
                throw new AssertionError();
            }
        }
        return Integer.signum(d2);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

