/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.ISetDeltaMonitor;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.procedure.IntProcedure;

public class PropAllDisjoint
extends Propagator<SetVar> {
    private final int n;
    private int currentSet;
    private final ISetDeltaMonitor[] sdm;
    private final IntProcedure elementForced;

    public PropAllDisjoint(SetVar[] sets) {
        super((Variable[])sets, (Priority)PropagatorPriority.LINEAR, true);
        this.n = sets.length;
        this.sdm = new ISetDeltaMonitor[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.sdm[i] = ((SetVar[])this.vars)[i].monitorDelta(this);
        }
        this.elementForced = element -> {
            for (int i = 0; i < this.n; ++i) {
                if (i == this.currentSet) continue;
                ((SetVar[])this.vars)[i].remove(element, this);
            }
        };
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return SetEventType.ADD_TO_KER.getMask();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            int i;
            for (i = 0; i < this.n; ++i) {
                ISetIterator iSetIterator = ((SetVar[])this.vars)[i].getLB().iterator();
                while (iSetIterator.hasNext()) {
                    int j = (Integer)iSetIterator.next();
                    for (int i2 = 0; i2 < this.n; ++i2) {
                        if (i2 == i) continue;
                        ((SetVar[])this.vars)[i2].remove(j, this);
                    }
                }
            }
            for (i = 0; i < this.n; ++i) {
                this.sdm[i].startMonitoring();
            }
        }
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.currentSet = idxVarInProp;
        this.sdm[this.currentSet].forEach(this.elementForced, SetEventType.ADD_TO_KER);
    }

    @Override
    public ESat isEntailed() {
        boolean allInstantiated = true;
        for (int i = 0; i < this.n; ++i) {
            if (!((SetVar[])this.vars)[i].isInstantiated()) {
                allInstantiated = false;
            }
            ISetIterator iter = ((SetVar[])this.vars)[i].getLB().iterator();
            while (iter.hasNext()) {
                int j = iter.nextInt();
                for (int i2 = 0; i2 < this.n; ++i2) {
                    if (i2 == i || !((SetVar[])this.vars)[i2].getLB().contains(j)) continue;
                    return ESat.FALSE;
                }
            }
        }
        if (allInstantiated) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

