/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.real;

import gnu.trove.map.hash.TIntIntHashMap;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.real.RealPropagator;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;

public class RealConstraint
extends Constraint {
    private static final Pattern p0 = Pattern.compile("\\{\\d*\\}");
    private static final Pattern p1 = Pattern.compile("\\{_");

    private RealConstraint(String name, RealPropagator ... propagators) {
        super(name, propagators);
    }

    public RealConstraint(String functions, double contractionRatio, Variable ... rvars) {
        this("REALCONSTRAINT", RealConstraint.createPropagator(functions, contractionRatio, rvars));
    }

    public RealConstraint(String functions, Variable ... rvars) {
        this(functions, 0.01, rvars);
    }

    private static RealPropagator[] createPropagator(String functions, double contractionRatio, Variable ... rvars) {
        String[] theFunctions = functions.split(";");
        RealPropagator[] props = new RealPropagator[theFunctions.length];
        ArrayList<Variable> vars = new ArrayList<Variable>();
        TIntIntHashMap sidx = new TIntIntHashMap();
        for (int i = 0; i < props.length; ++i) {
            String fct = theFunctions[i];
            Matcher m3 = p0.matcher(fct);
            while (m3.find()) {
                String g2 = m3.group();
                int id = Integer.parseInt(g2.substring(1, g2.length() - 1));
                if (sidx.contains(id)) continue;
                sidx.put(id, vars.size());
                vars.add(rvars[id]);
            }
            for (Object k : (String)sidx.keys()) {
                fct = fct.replaceAll("\\{" + (int)k + "\\}", "{_" + sidx.get((int)k) + "}");
            }
            fct = p1.matcher(fct).replaceAll("{");
            RealPropagator realPropagator = new RealPropagator(fct, vars.toArray(new Variable[0]));
            realPropagator.setContractionRatio(contractionRatio);
            props[i] = realPropagator;
            sidx.clear();
            vars.clear();
        }
        return props;
    }

    @Override
    public void reifyWith(BoolVar bool) {
        Model s2 = this.propagators[0].getModel();
        this.getOpposite();
        if (this.boolReif == null) {
            this.post();
            this.boolReif = bool;
            if (this.propagators.length == 1) {
                ((RealPropagator)this.propagators[0]).reify(bool);
            } else {
                BoolVar[] bvars = bool.getModel().boolVarArray(this.propagators.length);
                for (int i = 0; i < this.propagators.length; ++i) {
                    ((RealPropagator)this.propagators[i]).reify(bvars[i]);
                }
                bool.getModel().addClausesBoolAndArrayEqVar(bvars, bool);
            }
        } else if (bool != this.boolReif) {
            s2.arithm((IntVar)bool, "=", this.boolReif).post();
        }
    }
}

