/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.lex;

import java.util.Arrays;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

public class PropLex
extends Propagator<IntVar> {
    private final int n;
    private final IStateInt alpha;
    private final IStateInt beta;
    private boolean entailed;
    private final IntVar[] x;
    private final IntVar[] y;
    private final boolean strict;

    public PropLex(IntVar[] X2, IntVar[] Y, boolean strict) {
        super((Variable[])ArrayUtils.append(X2, Y), (Priority)PropagatorPriority.LINEAR, true);
        this.x = Arrays.copyOfRange((IntVar[])this.vars, 0, X2.length);
        this.y = Arrays.copyOfRange((IntVar[])this.vars, X2.length, ((IntVar[])this.vars).length);
        this.strict = strict;
        this.n = X2.length;
        IEnvironment environment = this.model.getEnvironment();
        this.alpha = environment.makeInt(0);
        this.beta = environment.makeInt(0);
        this.entailed = false;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            this.initialize();
        } else {
            this.gacLexLeq(this.alpha.get());
        }
    }

    @Override
    public void propagate(int vIdx, int mask) throws ContradictionException {
        this.entailed = false;
        if (vIdx < this.n) {
            this.gacLexLeq(vIdx);
        } else {
            this.gacLexLeq(vIdx - this.n);
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            for (int i = 0; i < this.x.length; ++i) {
                int yi;
                int xi = ((IntVar[])this.vars)[i].getValue();
                if (xi < (yi = ((IntVar[])this.vars)[i + this.n].getValue())) {
                    return ESat.TRUE;
                }
                if (xi <= yi) continue;
                return ESat.FALSE;
            }
            if (this.strict) {
                return ESat.FALSE;
            }
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    private boolean groundEq(IntVar x1, IntVar y1) {
        return x1.isInstantiated() && y1.isInstantiated() && x1.getValue() == y1.getValue();
    }

    private boolean checkLex(int i) {
        if (!this.strict) {
            if (i == this.n - 1) {
                return this.x[i].getUB() <= this.y[i].getLB();
            }
            return this.x[i].getUB() < this.y[i].getLB();
        }
        return this.x[i].getUB() < this.y[i].getLB();
    }

    private void updateAlpha(int i) throws ContradictionException {
        if (i == this.beta.get()) {
            this.fails();
        }
        if (i == this.n) {
            if (this.strict) {
                this.fails();
            } else {
                this.entailed = true;
                this.setPassive();
                return;
            }
        }
        if (!this.groundEq(this.x[i], this.y[i])) {
            this.alpha.set(i);
            this.gacLexLeq(i);
        } else {
            this.updateAlpha(i + 1);
        }
    }

    private void updateBeta(int i) throws ContradictionException {
        if (i + 1 == this.alpha.get()) {
            this.fails();
        }
        if (this.x[i].getLB() < this.y[i].getUB()) {
            this.beta.set(i + 1);
            if (this.x[i].getUB() >= this.y[i].getLB()) {
                this.gacLexLeq(i);
            }
        } else if (this.x[i].getLB() == this.y[i].getUB()) {
            this.updateBeta(i - 1);
        }
    }

    private void initialize() throws ContradictionException {
        int i;
        this.entailed = false;
        for (i = 0; i < this.n && this.groundEq(this.x[i], this.y[i]); ++i) {
        }
        if (i == this.n) {
            if (!this.strict) {
                this.entailed = true;
                this.setPassive();
            } else {
                this.fails();
            }
        } else {
            int a2 = i;
            if (this.checkLex(i)) {
                this.setPassive();
                return;
            }
            int b2 = -1;
            while (i != this.n && this.x[i].getLB() <= this.y[i].getUB()) {
                if (this.x[i].getLB() == this.y[i].getUB()) {
                    if (b2 == -1) {
                        b2 = i;
                    }
                } else {
                    b2 = -1;
                }
                ++i;
            }
            if (!this.strict && i == this.n) {
                b2 = Integer.MAX_VALUE;
            }
            if (b2 == -1) {
                b2 = i;
            }
            if (a2 >= b2) {
                this.fails();
            }
            this.alpha.set(a2);
            this.beta.set(b2);
            this.gacLexLeq(a2);
        }
    }

    private void gacLexLeq(int i) throws ContradictionException {
        int a2 = this.alpha.get();
        int b2 = this.beta.get();
        if (i >= b2 || this.entailed) {
            return;
        }
        if (i == a2 && i + 1 == b2) {
            this.x[i].updateUpperBound(this.y[i].getUB() - 1, this);
            this.y[i].updateLowerBound(this.x[i].getLB() + 1, this);
            if (this.checkLex(i)) {
                this.entailed = true;
                this.setPassive();
                return;
            }
        }
        if (i == a2 && i + 1 < b2) {
            this.x[i].updateUpperBound(this.y[i].getUB(), this);
            this.y[i].updateLowerBound(this.x[i].getLB(), this);
            if (this.checkLex(i)) {
                this.entailed = true;
                this.setPassive();
                return;
            }
            if (this.groundEq(this.x[i], this.y[i])) {
                this.updateAlpha(i + 1);
            }
        }
        if (a2 < i && (i == b2 - 1 && this.x[i].getLB() == this.y[i].getUB() || this.x[i].getLB() > this.y[i].getUB())) {
            this.updateBeta(i - 1);
        }
    }

    @Override
    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder(32);
        sb.append("LEX <");
        for (i = 0; i < Math.min(this.x.length - 1, 2); ++i) {
            sb.append(this.x[i]).append(", ");
        }
        if (i == 2 && this.x.length - 1 > 2) {
            sb.append("..., ");
        }
        sb.append(this.x[this.x.length - 1]);
        sb.append(">, <");
        for (i = 0; i < Math.min(this.y.length - 1, 2); ++i) {
            sb.append(this.y[i]).append(", ");
        }
        if (i == 2 && this.y.length - 1 > 2) {
            sb.append("..., ");
        }
        sb.append(this.y[this.y.length - 1]);
        sb.append(">");
        return sb.toString();
    }
}

